if(select(2, UnitClass('player')) ~= 'DEATHKNIGHT') then 
	return
end

frostFeverLocal = "";
bloodPlagueLocal = "";

if GetLocale() == "deDE" then

	frostFeverLocal = "Frostfieber";
	bloodPlagueLocal = "Blutseuche";

elseif GetLocale() == "frFR" then

	frostFeverLocal = "Fivre de givre";
	bloodPlagueLocal = "Peste de sang";

else

	frostFeverLocal = "Frost Fever";
	bloodPlagueLocal = "Blood Plague";

end
	
local frame_locked = 0;
-- Draggable Frame -------------------------------------
local dragFrame = CreateFrame("Frame", "Backgroundframe", UIParent)
dragFrame:SetPoint("CENTER", 0, 0);
dragFrame:RegisterForDrag("LeftButton")
dragFrame:SetScript("OnDragStart", dragFrame.StartMoving)
dragFrame:SetScript("OnDragStop", function(dragFrame) 
	dragFrame:StopMovingOrSizing();
	umb_x, umb_y = floor(dragFrame:GetLeft()), floor(dragFrame:GetBottom());
end)
dragFrame:SetWidth(130);
dragFrame:SetHeight(110);
local tex1 = dragFrame:CreateTexture("ARTWORK");
tex1:SetAllPoints();
tex1:SetTexture(0.5, 1, 0.5); 
tex1:SetAlpha(0);


-- Addon Render frame ------------------------------
local frame = CreateFrame("Frame", "Backgroundframe", UIParent)
frame:SetPoint("CENTER", dragFrame, "CENTER", 0, -10); 
frame:SetWidth(120);
frame:SetHeight(80);

-- Backgrounds -------------------------------------
local rpback = CreateFrame("Frame", "Backgroundframe", frame)
rpback:SetPoint("CENTER", frame, "CENTER", 0, -19);
rpback:SetWidth(120); 
rpback:SetHeight(12);
local tex2 = rpback:CreateTexture("ARTWORK");
tex2:SetAllPoints();
tex2:SetTexture(0, 0.3, 0.4); 
tex2:SetAlpha(0.4);
local RunicPowerPerc = rpback:CreateFontString("Runic Power Percentage", "ARTWORK", "GameFontNormalSmall");
RunicPowerPerc:SetPoint("CENTER", rpback, "CENTER", 75, 0);
RunicPowerPerc:SetText(0);
local presence = CreateFrame("Frame", "Backgroundframe", frame)
presence:SetPoint("CENTER", rpback, "CENTER", -72, 0);
presence:SetWidth(14); 
presence:SetHeight(14);
local presencetex = presence:CreateTexture("ARTWORK");
presencetex:SetAllPoints();
presencetex:SetTexture(0, 0, 0); 
presencetex:SetAlpha(1);


local hpback = CreateFrame("Frame", "Backgroundframe", frame)
hpback:SetPoint("CENTER", frame, "CENTER", 0, -7);
hpback:SetWidth(120); 
hpback:SetHeight(12);
local tex3 = hpback:CreateTexture("ARTWORK");
tex3:SetAllPoints();
tex3:SetTexture(0, 0.4, 0); 
tex3:SetAlpha(0.4);
local MyHealthPerc = hpback:CreateFontString("Hit Points Percentage", "ARTWORK", "GameFontNormalSmall");
MyHealthPerc:SetPoint("CENTER", hpback, "CENTER", 75, 0);
MyHealthPerc:SetText(0);
local MyLevel = hpback:CreateFontString("My Level", "ARTWORK", "GameFontNormalSmall");
MyLevel:SetPoint("CENTER", hpback, "CENTER", -75, 0);
MyLevel:SetText(0);

local tarhpback = CreateFrame("Frame", "Backgroundframe", frame)
tarhpback:SetPoint("CENTER", frame, "CENTER", 0, 33);
tarhpback:SetWidth(120); 
tarhpback:SetHeight(8);
local tex4 = tarhpback:CreateTexture("ARTWORK");
tex4:SetAllPoints();
tex4:SetTexture(0.4, 0, 0); 
tex4:SetAlpha(0.4);

local tarenback = CreateFrame("Frame", "Backgroundframe", frame)
tarenback:SetPoint("CENTER", frame, "CENTER", 0, 25);
tarenback:SetWidth(120); 
tarenback:SetHeight(8);
local tex5 = tarenback:CreateTexture("ARTWORK");
tex5:SetAllPoints();
tex5:SetTexture(0.4, 0.4, 0.4); 
tex5:SetAlpha(0.4);


-- Status bars -------------------------------------
local RunicPowerBar = CreateFrame("StatusBar", nil, frame)
RunicPowerBar:SetStatusBarTexture("Interface\\TargetingFrame\\UI-StatusBar")
RunicPowerBar:GetStatusBarTexture():SetHorizTile(false)
RunicPowerBar:SetMinMaxValues(0, 100)
RunicPowerBar:SetWidth(120)
RunicPowerBar:SetHeight(12)
RunicPowerBar:SetPoint("CENTER", rpback, "CENTER", 0, 0); 
RunicPowerBar:SetStatusBarColor(0, 0.6, 0.7)
local RunicPowerText = RunicPowerBar:CreateFontString("Runic Power Number", "ARTWORK", "GameFontNormalSmall");
RunicPowerText:SetPoint("CENTER", RunicPowerBar, "CENTER", 0, 0);
RunicPowerText:SetText(0);

local MyHealthBar = CreateFrame("StatusBar", nil, frame)
MyHealthBar:SetStatusBarTexture("Interface\\TargetingFrame\\UI-StatusBar")
MyHealthBar:GetStatusBarTexture():SetHorizTile(false)
MyHealthBar:SetMinMaxValues(0, 100)
MyHealthBar:SetWidth(120)
MyHealthBar:SetHeight(12)
MyHealthBar:SetPoint("CENTER", hpback, "CENTER", 0, 0); 
MyHealthBar:SetStatusBarColor(0, 0.8, 0)
local HealthBarText = MyHealthBar:CreateFontString("Health Points Number", "ARTWORK", "GameFontNormalSmall");
HealthBarText:SetPoint("CENTER", MyHealthBar, "CENTER", 0, 0);
HealthBarText:SetText(0);

local TargetHealthBar = CreateFrame("StatusBar", nil, frame)
TargetHealthBar:SetStatusBarTexture("Interface\\TargetingFrame\\UI-StatusBar")
TargetHealthBar:GetStatusBarTexture():SetHorizTile(false)
TargetHealthBar:SetMinMaxValues(0, 100)
TargetHealthBar:SetWidth(120)
TargetHealthBar:SetHeight(8)
TargetHealthBar:SetPoint("CENTER", tarhpback, "CENTER", 0, 0); 
TargetHealthBar:SetStatusBarColor(0.6, 0, 0)
local TargetHealthBarText = TargetHealthBar:CreateFontString("Target Health Points Number", "ARTWORK", "GameFontNormalSmall");
TargetHealthBarText:SetPoint("CENTER", TargetHealthBar, "CENTER", 0, 1);
TargetHealthBarText:SetText(0);

local TargetEnergyBar = CreateFrame("StatusBar", nil, frame)
TargetEnergyBar:SetStatusBarTexture("Interface\\TargetingFrame\\UI-StatusBar")
TargetEnergyBar:GetStatusBarTexture():SetHorizTile(false)
TargetEnergyBar:SetMinMaxValues(0, 100)
TargetEnergyBar:SetWidth(120)
TargetEnergyBar:SetHeight(8)
TargetEnergyBar:SetPoint("CENTER", tarenback, "CENTER", 0, 0); 
TargetEnergyBar:SetStatusBarColor(0.6, 0.6, 0.6)
local TargetEnergyBarText = TargetEnergyBar:CreateFontString("Target Energy Number", "ARTWORK", "GameFontNormalSmall");
TargetEnergyBarText:SetPoint("CENTER", TargetEnergyBar, "CENTER", 0, 0);
TargetEnergyBarText:SetText(0);


local TarHealthPerc = TargetHealthBar:CreateFontString("Target Hit Points Percentage", "ARTWORK", "GameFontNormalSmall");
TarHealthPerc:SetPoint("CENTER", TargetHealthBar, "CENTER", 75, 0);
TarHealthPerc:SetText(0);
local TarLevel = TargetHealthBar:CreateFontString("Target Level", "ARTWORK", "GameFontNormalSmall");
TarLevel:SetPoint("CENTER", TargetHealthBar, "CENTER", -75, 0);
TarLevel:SetText(0);
local TarEnergyPerc = TargetEnergyBar:CreateFontString("Target Energy Percentage", "ARTWORK", "GameFontNormalSmall");
TarEnergyPerc:SetPoint("CENTER", TargetEnergyBar, "CENTER", 75, 0);
TarEnergyPerc:SetText(0);

-- Names, levels and other values -------------
local TargetNameText = frame:CreateFontString("Target Name", "ARTWORK", "GameFontNormalSmall");
TargetNameText:SetPoint("CENTER", frame, "CENTER", 0, 60);
TargetNameText:SetText(0);

-- Debufftrackers -----------------------------
local fftrack = CreateFrame("Frame", "Backgroundframe", frame)
fftrack:SetPoint("CENTER", frame, "CENTER", -8, 45);
fftrack:SetWidth(16); 
fftrack:SetHeight(16);
local fftracktex = fftrack:CreateTexture("ARTWORK");
fftracktex:SetAllPoints();
fftracktex:SetTexture("Interface\\Icons\\spell_deathknight_frostfever");
fftracktex:SetAlpha(1);
local fftracknumber = fftrack:CreateFontString("Target Name", "ARTWORK", "GameFontNormalSmall");
fftracknumber:SetPoint("CENTER", fftrack, "CENTER", -16, 0);
fftracknumber:SetText(0);

local bptrack = CreateFrame("Frame", "Backgroundframe", frame)
bptrack:SetPoint("CENTER", frame, "CENTER", 8, 45);
bptrack:SetWidth(16); 
bptrack:SetHeight(16);
local bptracktex = bptrack:CreateTexture("ARTWORK");
bptracktex:SetAllPoints();
bptracktex:SetTexture("Interface\\Icons\\spell_deathknight_bloodplague"); 
bptracktex:SetAlpha(1);
local bptracknumber = bptrack:CreateFontString("Target Name", "ARTWORK", "GameFontNormalSmall");
bptracknumber:SetPoint("CENTER", bptrack, "CENTER", 16, 0);
bptracknumber:SetText(0);

-- OnUpdate -------------------------------------
frame:SetScript("OnUpdate", function(self, elapsed)

	if frame_locked == 0 then
		dragFrame:ClearAllPoints();
		dragFrame:SetPoint("BOTTOMLEFT", umb_x, umb_y);
	end
	
	if umb_show_player == 1 then
		
		MyHealthBar:SetMinMaxValues(0, UnitHealthMax("player"));
		MyHealthBar:SetValue(UnitHealth("player"));
		
		MyLevel:SetText("L:"..UnitLevel("player").."");
	
	
		-- Status Texts --
		hpamount = UnitHealth("player");
		hpmax = UnitHealthMax("player");
		HealthBarText:SetText(""..hpamount.." / "..hpmax.."");
		
		
		
		hpperc = UnitHealth("player")/(UnitHealthMax("player")/100);
		resultmyhp = floor( hpperc*10 ^ 0 + 0.5 ) / 10 ^ 0;
		MyHealthPerc:SetText(resultmyhp.."%");
		
		-- Presences -----------------------------
		if UnitBuff("player", "Blood Presence", "", "PLAYER") then
			presencetex:SetTexture("Interface\\Icons\\spell_deathknight_bloodpresence");
			presencetex:SetAlpha(1);
		elseif UnitBuff("player", "Frost Presence", "", "PLAYER") then
			presencetex:SetTexture("Interface\\Icons\\spell_deathknight_frostpresence"); 
			presencetex:SetAlpha(1);
		elseif UnitBuff("player", "Unholy Presence", "", "PLAYER") then
			presencetex:SetTexture("Interface\\Icons\\spell_deathknight_unholypresence"); 
			presencetex:SetAlpha(1);
		else
			presencetex:SetTexture(0, 0, 0); 
			presencetex:SetAlpha(0);
		end
		
		tex3:SetAlpha(0.4);
		MyHealthBar:SetAlpha(1);
		
		rpback:SetPoint("CENTER", frame, "CENTER", 0, -19);
		
	else
	
		tex3:SetAlpha(0);
		MyHealthBar:SetAlpha(0);
		
		MyHealthPerc:SetText("");
		MyLevel:SetText("");
		HealthBarText:SetText("");
		
		presencetex:SetTexture(0, 0, 0); 
		presencetex:SetAlpha(0);
		
		rpback:SetPoint("CENTER", frame, "CENTER", 0, -9);
		
	end
	
	
	RunicPowerBar:SetMinMaxValues(0, UnitPowerMax("player",6));
	RunicPowerBar:SetValue(UnitPower("player",6));
	
	rpamount = UnitPower("player",6);
	rpmax = UnitPowerMax("player",6);
	RunicPowerText:SetText(""..rpamount.." / "..rpmax.."");
	
	rpperc = UnitPower("player")/(UnitPowerMax("player")/100);
	resultrunpow = floor( rpperc*10 ^ 0 + 0.5 ) / 10 ^ 0;
	RunicPowerPerc:SetText(resultrunpow.."%");
	
	if umb_show_target == 1 then
		
		TargetHealthBar:SetMinMaxValues(0, UnitHealthMax("target"));
		TargetHealthBar:SetValue(UnitHealth("target"));
		
		TargetEnergyBar:SetMinMaxValues(0, UnitPowerMax("target"));
		TargetEnergyBar:SetValue(UnitPower("target"));
		
		tarhp = UnitHealth("target");
		TargetHealthBarText:SetText(""..tarhp.."");
		
		teamount = UnitPower("target");
		temax = UnitPowerMax("target");
		TargetEnergyBarText:SetText(""..teamount.." / "..temax.."");
		
		
		-- Percentages ---------------		
		tarhpperc = UnitHealth("target")/(UnitHealthMax("target")/100);
		if UnitHealthMax("target") == 0 then
			TarHealthPerc:SetText(" ");
		else
			resulttarhp = floor( tarhpperc*10 ^ 0 + 0.5 ) / 10 ^ 0;
			TarHealthPerc:SetText(resulttarhp.."%");
		end
		
		tarenperc = UnitPower("target")/(UnitPowerMax("target")/100);
		if UnitPowerMax("target") == 0 then
			TarEnergyPerc:SetText(" ");
		else
			resulttaren = floor( tarenperc*10 ^ 0 + 0.5 ) / 10 ^ 0;
			TarEnergyPerc:SetText(resulttaren.."%");
		end
		
		-- Names, levels and other values---------
		TargetNameText:SetText(UnitName("target"));
		
		tarlvlvalue = UnitLevel("target");
		if tarlvlvalue == -1 then
			TarLevel:SetText("Boss");
		elseif tarlvlvalue == 0 then
			TarLevel:SetText("");
		else
			TarLevel:SetText("L:"..tarlvlvalue.."");
		end
		
		tarenback:SetAlpha(0.4);
		tarhpback:SetAlpha(0.4);
		TargetEnergyBar:SetAlpha(1);
		TargetHealthBar:SetAlpha(1);
		
		fftrack:SetPoint("CENTER", frame, "CENTER", -8, 45);
		fftracknumber:SetPoint("CENTER", fftrack, "CENTER", -16, 0);
		bptrack:SetPoint("CENTER", frame, "CENTER", 8, 45);
		bptracknumber:SetPoint("CENTER", bptrack, "CENTER", 16, 0);
		
	else
		tarenback:SetAlpha(0);
		tarhpback:SetAlpha(0);
		TargetEnergyBar:SetAlpha(0);
		TargetHealthBar:SetAlpha(0);
		
		TargetHealthBarText:SetText("");
		TargetEnergyBarText:SetText("");
		TarHealthPerc:SetText("");
		TarEnergyPerc:SetText("");
		TargetNameText:SetText("");
		TarLevel:SetText("");
		
		fftrack:SetPoint("CENTER", frame, "CENTER", -8, 30);
		fftracknumber:SetPoint("CENTER", fftrack, "CENTER", -16, 0);
		bptrack:SetPoint("CENTER", frame, "CENTER", 8, 30);
		bptracknumber:SetPoint("CENTER", bptrack, "CENTER", 16, 0);
	end
	
	
	
	-- Diseases ----------------------------
	if UnitDebuff("target", frostFeverLocal, "", "PLAYER") then
		fftracktex:SetAlpha(1);
	else
		fftracktex:SetAlpha(0.1);
	end
	
	if UnitDebuff("target", bloodPlagueLocal, "", "PLAYER") then
		bptracktex:SetAlpha(1);
	else
		bptracktex:SetAlpha(0.1);
	end
	
	local name, _, _, _, _, dur, exp = UnitDebuff("target", frostFeverLocal, nil, "PLAYER");
	if name then
		fftracknumber:SetText(string.format("%d", exp - GetTime()));
	else
		fftracknumber:SetText(" ");
	end
	
	local name, _, _, _, _, dur, exp = UnitDebuff("target", bloodPlagueLocal, nil, "PLAYER");
	if name then
		bptracknumber:SetText(string.format("%d", exp - GetTime()));
	else
		bptracknumber:SetText(" ");
	end
	
	if umb_show_target == nil then
		umb_show_target = 1;
	end
	if umb_show_player == nil then
		umb_show_player = 1;
	end
	if umb_x == nil then
		umb_x = (GetScreenWidth() / 2) - 60;
	end
	if umb_y == nil then
		umb_y = (GetScreenHeight() / 2) - 157;
	end
end)



-- Slash command -------------------------------------
SLASH_UMBER1 = '/umber';
local function handler(msg, editbox)
local command, rest = msg:match("^(%S*)%s*(.-)$")
	if command == 'toggletarget' then
		
		if umb_show_target == 0 then
			umb_show_target = 1;
			print("|cFFFFA07AUmberRunes: |cffffffffShowing target healthbar.");
		else
			umb_show_target = 0;
			print("|cFFFFA07AUmberRunes: |cffffffffHiding target healthbar.");
		end
				
	elseif command == 'toggleplayer' then
		
		if umb_show_player == 0 then
			umb_show_player = 1;
			print("|cFFFFA07AUmberRunes: |cffffffffShowing player healthbar.");
		else
			umb_show_player = 0;
			print("|cFFFFA07AUmberRunes: |cffffffffHiding player healthbar.");
		end
				
	elseif command == 'lock' then
		
		if frame_locked == 0 then
			frame_locked = 1;
			
			dragFrame:SetMovable(true);
			dragFrame:EnableMouse(true);
			
			print("|cFFFFA07AUmberRunes: |cffffffffFrame unlocked.");
		else
			frame_locked = 0;
			
			dragFrame:SetMovable(false);
			dragFrame:EnableMouse(false);
			
			print("|cFFFFA07AUmberRunes: |cffffffffFrame locked.");
		end
	elseif command == 'reset' then
		
		dragFrame:ClearAllPoints();
		dragFrame:SetPoint("CENTER", 0, 0);
		umb_x, umb_y = floor(dragFrame:GetLeft()), floor(dragFrame:GetBottom());
		print("|cFFFFA07AUmberRunes: |cffffffffFrame position reset.");
		
	else
		print("|cFFFFA07AUmberRunes:");
		print("|cFF00FFFFlock |cffffffff- Lock/unlock frame.");
		print("|cFF00FFFFreset |cffffffff- Reset frame position.");
		print("|cFF00FFFFtoggleplayer |cffffffff- Toggle player health bars on/off.");
		print("|cFF00FFFFtoggletarget |cffffffff- Toggle target health bars on/off.");
	end
end
SlashCmdList["UMBER"] = handler;




-- Rune Moving -------------------------------------
RuneButtonIndividual1:ClearAllPoints();
RuneButtonIndividual2:ClearAllPoints();
RuneButtonIndividual3:ClearAllPoints();
RuneButtonIndividual4:ClearAllPoints();
RuneButtonIndividual5:ClearAllPoints();
RuneButtonIndividual6:ClearAllPoints();

RuneButtonIndividual1:SetPoint("CENTER", frame, "CENTER", -50, 10);
RuneButtonIndividual2:SetPoint("CENTER", frame, "CENTER", -30, 10);
RuneButtonIndividual3:SetPoint("CENTER", frame, "CENTER", 30, 10);
RuneButtonIndividual4:SetPoint("CENTER", frame, "CENTER", 50, 10);
RuneButtonIndividual5:SetPoint("CENTER", frame, "CENTER", -10, 10);
RuneButtonIndividual6:SetPoint("CENTER", frame, "CENTER", 10, 10);

RuneButtonIndividual1:EnableMouse(false);
RuneButtonIndividual2:EnableMouse(false);
RuneButtonIndividual3:EnableMouse(false);
RuneButtonIndividual4:EnableMouse(false);
RuneButtonIndividual5:EnableMouse(false);
RuneButtonIndividual6:EnableMouse(false);