-- Titan Panel support

Titan_Skills_list = {};
local Skills_ID = "Skills";
local Skills_Name = "Titan Skills";
local Skills_Version = "1.0.7";

-- My Colors
local ORANGE_COLOR_CODE = "|cffff9900";
local BLUE_COLOR_CODE = "|cff8080FF";
local YELLOW_COLOR_CODE = "|cffffff00";

function Titan_Skills_OnLoad()
	if not TitanPanelButton_UpdateButton then
	return;
	end

	this.registry = {
		id = Skills_ID,
		menuText = Skills_Name,
		version = Skills_Version,
		category = "Information",
		buttonTextFunction = "TitanPanelSkillsButton_GetButtonText", 
		icon = "Interface\\Icons\\Ability_Parry",
		iconWidth = 16,
		tooltipTitle = "Skills Info",
		tooltipTextFunction = "TitanPanelSkillsButton_GetTooltipText",
		savedVariables = {
			ShowIcon = 1,
			ShowLabelText = 1,
			UseColor = 1,
		}
	};
end

function Titan_Skills_OnClick(button)
	if ( button == "LeftButton" ) then
	end
end

function Titan_Skills_OnEvent()
	TitanPanelSkillsButton_GetTooltipText();
	TitanPanelButton_UpdateButton(Skills_ID);
end

function TitanPanelSkillsButton_GetButtonText()
	return Skills_Name;
end

function TitanSkills_GetColor(min,max,header,skillname)
	local level = UnitLevel("player");
	local color = HIGHLIGHT_FONT_COLOR_CODE;
	local lvlskill = (5*level);
	local topmax1, topmax2;
	local version = GetBuildInfo();
	local ridingmax = 300;

	if version >= "3.0.0" then
		topmax1 = 450;	-- Profession Max
		topmax2 = 400;	-- Weapon Max
	else
		topmax1 = 375;	-- Profession Max
		topmax2 = 350;	-- Weapon Max
	end

	if (TitanGetVar(Skills_ID, "UseColor") == nil)or(TitanGetVar(Skills_ID, "UseColor") == 0) then
		return color;
	end

	if (TitanGetVar(Skills_ID, "UseColor") == 3) then
		local thismax = topmax1;
		if header == "Weapon Skills" then
			thismax = topmax2;
		end
		if skillname == "Riding" then
			thismax = ridingmax;
		end
		if (min == max)and(max == thismax) then
			return BLUE_COLOR_CODE;
		end
	elseif (min == max) then
		return BLUE_COLOR_CODE;
	end

	if (TitanGetVar(Skills_ID, "UseColor") == 2) then
		max = lvlskill;
	elseif (TitanGetVar(Skills_ID, "UseColor") == 3) then
		max = topmax1;
		if header == "Weapon Skills" then
			max = topmax2;
		end
		if skillname == "Riding" then
			max = ridingmax;
		end
	end

	local percent = min/max;

	if percent >= 0.75 then
		color = GREEN_FONT_COLOR_CODE;		-- Color Green if above or equal to 75%.
	elseif percent >= 0.50 then
		color = YELLOW_COLOR_CODE;		-- Color Yellow if above or equal to 50%.
	elseif percent >= 0.25 then
		color = ORANGE_COLOR_CODE;		-- Color Orange if above or equal to 25%.
	elseif percent >= 0.05 then
		color = RED_FONT_COLOR_CODE;		-- Color Red if above or equal to 5%.
	elseif (percent < 0.05)or(min == 1) then	
		color = GRAY_FONT_COLOR_CODE;		-- Color Gray if below 5% or Min = 1;
	else
		color = HIGHLIGHT_FONT_COLOR_CODE;	-- If everything should fail, color white.
	end

	return color;
end

function TitanPanelSkillsButton_GetTooltipText()
	Titan_Skills_GenerateList();

	local result = " \n";
	local a = Titan_Skills_list;

	for group,gv in pairs(a) do
		result = result..TitanUtils_GetNormalText(group).."\n";
		for skill,sv in pairs(a[group]) do
			if a[group][skill]["maxrank"] >= 5 then
				result = result.."    "..Titan_Skills_GetSkill(skill).."\n";
			end
		end
	end

	return result;
end

function Titan_Skills_GetSkill(skillname)
	local a = Titan_Skills_list;
	for group,v in pairs(a) do
		for skill,v in pairs(a[group]) do
			if (skill == skillname) then
				local mod ="";
				if a[group][skill]["modifier"] > 0 then
					mod = TitanUtils_GetGreenText("+"..a[group][skill]["modifier"]);
				end
				result = TitanSkills_GetColor(a[group][skill]["rank"],a[group][skill]["maxrank"],group,skill)..skill.." ("..a[group][skill]["rank"]..mod.."/"..a[group][skill]["maxrank"]..")"..FONT_COLOR_CODE_CLOSE;
				return result;
			end
		end
	end
end

function Titan_Skills_GenerateList()
	Titan_Skills_list = {};
	local Current_Header;
	local hasClassSkills;

	-- Pre-scan for Class Skills
	for i=1, GetNumSkillLines() do
		skillName, isHeader, _, skillRank, numTempPoints, skillModifier, skillMaxRank, _, stepCost, rankCost, minLevel, skillCostType, skillDescription = GetSkillLineInfo(i);

		if (isHeader~=nil) then
			Current_Header = skillName;
		end

		if (Current_Header == "Class Skills") then
			if (skillMaxRank > 1) then
				hasClassSkills = 1;
			end
		end
	end

	-- Main Scan
	Current_Header = nil;

	for i=1, GetNumSkillLines() do
		skillName, isHeader, _, skillRank, numTempPoints, skillModifier, skillMaxRank, _, stepCost, rankCost, minLevel, skillCostType, skillDescription = GetSkillLineInfo(i);

		if (isHeader~=nil) then
			Current_Header = skillName;
			if ((Current_Header == "Class Skills") and (hasClassSkills ~= nil)) or (Current_Header ~= "Class Skills" and Current_Header ~= "Armor Proficiencies" and Current_Header ~= "Languages") then
				if not (Titan_Skills_list[Current_Header]) then
					Titan_Skills_list[Current_Header] = {};
				end
			end
		elseif (isHeader == nil) then
			if ((Current_Header == "Class Skills") and (hasClassSkills ~= nil)) or (Current_Header ~= "Class Skills" and Current_Header ~= "Armor Proficiencies" and Current_Header ~= "Languages") then
				Titan_Skills_list[Current_Header][skillName] = {
					["rank"] = skillRank,
					["numtemp"] = numTempPoints,
					["modifier"] = skillModifier,
					["maxrank"] =  skillMaxRank,
					["desc"] = skillDescription,
				}
			end
		end
	end
end

function Titan_SKills_OnShow()
	local hasTimer = TitanPanel:HasTimer("TitanPanel"..Skills_ID);
	if hasTimer then
		--do nothing
	else
		TitanPanel:AddRepeatingTimer("TitanPanel"..Skills_ID, 1, TitanPanelPluginHandle_OnUpdate, Skills_ID, TITAN_PANEL_UPDATE_TOOLTIP)
	end
end

function Titan_SKills_OnHide()
	local hasTimer = TitanPanel:HasTimer("TitanPanel"..Skills_ID);
	if hasTimer then
		TitanPanel:RemoveTimer("TitanPanel"..Skills_ID);
	end
end

function Titan_Skills_GetColorCB(mode)
	local temp = TitanGetVar(Skills_ID, "UseColor");
	if temp == mode then
		return 1;
	end
	return nil;
end

function TitanPanelRightClickMenu_PrepareSkillsMenu()
	local info;
	if ( UIDROPDOWNMENU_MENU_LEVEL == 2 ) then
		-- Do Not Color
		info = {};
		info.text = "None";
		info.value = 0;
		info.func = function () TitanSkills_UseColor(0) end;
		info.checked = Titan_Skills_GetColorCB(info.value);
		UIDropDownMenu_AddButton(info,UIDROPDOWNMENU_MENU_LEVEL);

		-- Color by Skill Level (Standard Coloring)
		info = {};
		info.text = "Standard";
		info.value = 1;
		info.func = function () TitanSkills_UseColor(1) end;
		info.checked = Titan_Skills_GetColorCB(info.value);
		UIDropDownMenu_AddButton(info,UIDROPDOWNMENU_MENU_LEVEL);

		-- Color by Character Level
		info = {};
		info.text = "By Player Level";
		info.value = 2;
		info.func = function () TitanSkills_UseColor(2) end;
		info.checked = Titan_Skills_GetColorCB(info.value);
		UIDropDownMenu_AddButton(info,UIDROPDOWNMENU_MENU_LEVEL);

		-- Color by Maximum
		info = {};
		info.text = "By Maximum Skill";
		info.value = 3;
		info.func = function () TitanSkills_UseColor(3) end;
		info.checked = Titan_Skills_GetColorCB(info.value);
		UIDropDownMenu_AddButton(info,UIDROPDOWNMENU_MENU_LEVEL);
	else
		TitanPanelRightClickMenu_AddTitle(TitanPlugins[Skills_ID].menuText.." "..Skills_Version);

		TitanPanelRightClickMenu_AddSpacer();

		-- Color Dropdown
		info = {};
		info.text = "Coloring";
		info.hasArrow = 1;
		UIDropDownMenu_AddButton(info);

		TitanPanelRightClickMenu_AddSpacer();
		TitanPanelRightClickMenu_AddToggleIcon(Skills_ID);
		TitanPanelRightClickMenu_AddCommand(TITAN_PANEL_MENU_HIDE, Skills_ID, TITAN_PANEL_MENU_FUNC_HIDE);
	end
end

function TitanSkills_UseColor(mode)
	TitanSetVar(Skills_ID, "UseColor", mode);
	TitanPanelButton_UpdateButton(Skills_ID);
	
end

function TitanSkills_ColorToLevel()
	TitanToggleVar(Skills_ID, "ColorToLevel");
	TitanPanelButton_UpdateButton(Skills_ID);
end