--         -------------------------------------------
--        | TinyMeleeStats by TheVaan and ArcaneMagus |
--         -------------------------------------------
--
-- File version: 40
-- Project: 44
--

local AceAddon = LibStub("AceAddon-3.0")
local media = LibStub:GetLibrary("LibSharedMedia-3.0")
TinyMeleeStats = AceAddon:NewAddon("TinyMeleeStats", "AceConsole-3.0", "AceEvent-3.0")
local L = LibStub("AceLocale-3.0"):GetLocale("TinyMeleeStats")

local ldb = LibStub:GetLibrary("LibDataBroker-1.1");
local TMSBroker = ldb:NewDataObject("TinyMeleeStats", { 
	type = "data source",
	label = "TinyMeleeStats", 
	icon = "Interface\\Icons\\Ability_Racial_ShadowMeld",
	text = "--"
	}
	)
	
TinyMeleeStats.fonts = {}

TinyMeleeStats.defaults = {
	char = {
		Font = "Vera",
		FontEffect = "none",
		Size = 12,
		FrameLocked = true,
		yPosition = 200,
		xPosition = 200,
		inCombatAlpha = 1,
		outOfCombatAlpha = .3,
		RecordMsg = true,
		RecordSound = true,
		RecordSoundFile = "Fanfare3",
		HighestAp = 0,
		HighestCrit = 0,
		FastestMh = 500,
		FastestOh = 500,
		HighestHit = 0,
		HighestArp = 0,
		Style = {
			Ap = true,
			Crit = true,
			Speed = true,
			Hit = false,
			Arp = false,
			showRecords = true,
			vertical = false,
			labels = false
		},
		Color = {
			ap = {
				r = 1,
				g = 0.803921568627451,
				b = 0
			},
			crit = {
				r = 1,
				g = 0,
				b = 0.6549019607843137
			},
			speed = {
				r = 0,
				g = 0.611764705882353,
				b = 1
			},
			hit = {
				r = 0.07058823529411765,
				g = 0.7686274509803921,
				b = 0
			},
			arp = {
				r = 0,
				g = 0.05490196078431373,
				b = 0.8
			}
		}	
	}
}

TinyMeleeStats.tmsframe = CreateFrame("Frame","TinyMeleeStatsFrame",UIParent)
TinyMeleeStats.tmsframe:SetWidth(100)
TinyMeleeStats.tmsframe:SetHeight(15)
TinyMeleeStats.tmsframe:SetFrameStrata("BACKGROUND")
TinyMeleeStats.tmsframe:EnableMouse(true)
TinyMeleeStats.tmsframe:RegisterForDrag("LeftButton")

TinyMeleeStats.strings = {
	apString = TinyMeleeStats.tmsframe:CreateFontString(),
	critString = TinyMeleeStats.tmsframe:CreateFontString(),
	speedString = TinyMeleeStats.tmsframe:CreateFontString(),
	hitString = TinyMeleeStats.tmsframe:CreateFontString(),
	arpString = TinyMeleeStats.tmsframe:CreateFontString(),

	apRecordString = TinyMeleeStats.tmsframe:CreateFontString(),
	critRecordString = TinyMeleeStats.tmsframe:CreateFontString(),
	speedRecordString = TinyMeleeStats.tmsframe:CreateFontString(),
	hitRecordString = TinyMeleeStats.tmsframe:CreateFontString(),
	arpRecordString = TinyMeleeStats.tmsframe:CreateFontString()
}

function TinyMeleeStats:SetStringColors()
	local c = self.db.char.Color
	self.strings.apString:SetTextColor(c.ap.r, c.ap.g, c.ap.b, 1.0)
	self.strings.critString:SetTextColor(c.crit.r, c.crit.g, c.crit.b, 1.0)
	self.strings.speedString:SetTextColor(c.speed.r, c.speed.g, c.speed.b, 1.0)
	self.strings.hitString:SetTextColor(c.hit.r, c.hit.g, c.hit.b, 1.0)
	self.strings.arpString:SetTextColor(c.arp.r, c.arp.g, c.arp.b, 1.0)
	
	self.strings.apRecordString:SetTextColor(c.ap.r, c.ap.g, c.ap.b, 1.0)
	self.strings.critRecordString:SetTextColor(c.crit.r, c.crit.g, c.crit.b, 1.0)
	self.strings.speedRecordString:SetTextColor(c.speed.r, c.speed.g, c.speed.b, 1.0)
	self.strings.hitRecordString:SetTextColor(c.hit.r, c.hit.g, c.hit.b, 1.0)
	self.strings.arpRecordString:SetTextColor(c.arp.r, c.arp.g, c.arp.b, 1.0)
end

function TinyMeleeStats:OnInitialize()
	local AceConfigReg = LibStub("AceConfigRegistry-3.0")
	local AceConfigDialog = LibStub("AceConfigDialog-3.0")
	
	self.db = LibStub("AceDB-3.0"):New("TinyMeleeStats", TinyMeleeStats.defaults, "char")
	LibStub("AceConfig-3.0"):RegisterOptionsTable("TinyMeleeStats", self:Options(), "tmscmd")
	media.RegisterCallback(self, "LibSharedMedia_Registered")
	
	self:RegisterChatCommand("tms", function() AceConfigDialog:Open("TinyMeleeStats") end)	
	self:RegisterChatCommand("tinymeleestats", function() AceConfigDialog:Open("TinyMeleeStats") end)	
	self.optionsFrame = AceConfigDialog:AddToBlizOptions("TinyMeleeStats", "TinyMeleeStats")
	self.db:RegisterDefaults(self.defaults)
	local version = GetAddOnMetadata("TinyMeleeStats","Version")
	local loaded = L["Open the configuration menu with /tms or /tinymeleestats"].."|r"
	
	DEFAULT_CHAT_FRAME:AddMessage("|cffffd700TinyMeleeStats |cff00ff00~v"..version.."~|cffffd700: "..loaded)
end

function TinyMeleeStats:OnEnable()
	self:LibSharedMedia_Registered()
	self:RegisterEvent("PLAYER_ENTERING_WORLD", "OnEvent")
	self:RegisterEvent("ADDON_LOADED", "OnEvent")
	self:RegisterEvent("VARIABLES_LOADED", "OnEvent")
	self:RegisterEvent("UNIT_ATTACK_POWER", "OnEvent")
	self:RegisterEvent("UNIT_ATTACK_SPEED", "OnEvent")
	self:RegisterEvent("UNIT_AURA", "OnEvent")
	self:RegisterEvent("UPDATE_SHAPESHIFT_FORM", "OnEvent")
	self:RegisterEvent("UNIT_INVENTORY_CHANGED", "OnEvent")
	self:RegisterEvent("UNIT_LEVEL", "OnEvent")
	self:RegisterEvent("PLAYER_REGEN_ENABLED", "OnEvent")
	self:RegisterEvent("PLAYER_REGEN_DISABLED", "OnEvent")
	self:RegisterEvent("PLAYER_TALENT_UPDATE", "OnEvent")
end

function TinyMeleeStats:LibSharedMedia_Registered()
	media:Register("font", "BaarSophia", [[Interface\Addons\TinyMeleeStats\Fonts\BaarSophia.ttf]])
	media:Register("font", "LucidaSD", [[Interface\Addons\TinyMeleeStats\Fonts\LucidaSD.ttf]])
	media:Register("font", "Teen", [[Interface\Addons\TinyMeleeStats\Fonts\Teen.ttf]])
	media:Register("font", "Vera", [[Interface\Addons\TinyMeleeStats\Fonts\Vera.ttf]])
	
	for k, v in pairs(media:List("font")) do
		self.fonts[v] = v
	end
end

function TinyMeleeStats:OnEvent(event, arg1)
	if (event == "ADDON_LOADED") then
		self.tmsframe:SetPoint("BOTTOMLEFT", UIParent, "BOTTOMLEFT", self.db.char.xPosition, self.db.char.yPosition)
		local font = media:Fetch("font", self.db.char.Font)
		for k, fontObject in pairs(self.strings) do
			fontObject:SetFontObject(GameFontNormal)
			fontObject:SetFont(font, self.db.char.Size, self.db.char.FontEffect)
			fontObject:SetJustifyH("LEFT")
			fontObject:SetJustifyV("MIDDLE")
		end
		self.strings.apString:SetText(" ")
		self.strings.apString:SetHeight(self.strings.apString:GetStringHeight())
		self.strings.apString:SetText("")
		self:SetTextAnchors()
		self:SetStringColors()
	end
	if ((event == "PLAYER_REGEN_ENABLED") or (event == "PLAYER_ENTERING_WORLD")) then
		self.tmsframe:SetAlpha(self.db.char.outOfCombatAlpha)
	end
	if (event == "PLAYER_REGEN_DISABLED") then
		self.tmsframe:SetAlpha(self.db.char.inCombatAlpha)
	end
	if (self.db.char.FrameLocked == true) then 
		local fixed = L["Text is fixed. Uncheck Lock Frame in the options to move!"]
		self.tmsframe:SetScript("OnDragStart", function() DEFAULT_CHAT_FRAME:AddMessage(fixed) end)
	end
  	self:Stats()
end

function TinyMeleeStats:SetTextAnchors()
	local offsetX, offsetY = 3, 0
	if (not self.db.char.Style.vertical) then
		self.strings.apString:SetPoint("TOPLEFT", self.tmsframe)
		self.strings.critString:SetPoint("TOPLEFT", self.strings.apString, "TOPRIGHT", offsetX, offsetY)
		self.strings.speedString:SetPoint("TOPLEFT", self.strings.critString, "TOPRIGHT", offsetX, offsetY)
		self.strings.hitString:SetPoint("TOPLEFT", self.strings.speedString, "TOPRIGHT", offsetX, offsetY)
		self.strings.arpString:SetPoint("TOPLEFT", self.strings.hitString, "TOPRIGHT", offsetX, offsetY)
		
		self.strings.apRecordString:SetPoint("TOPLEFT", self.strings.apString, "BOTTOMLEFT")
		self.strings.critRecordString:SetPoint("TOPLEFT", self.strings.apRecordString, "TOPRIGHT", offsetX, offsetY)
		self.strings.speedRecordString:SetPoint("TOPLEFT", self.strings.critRecordString, "TOPRIGHT", offsetX, offsetY)
		self.strings.hitRecordString:SetPoint("TOPLEFT", self.strings.speedRecordString, "TOPRIGHT", offsetX, offsetY)
		self.strings.arpRecordString:SetPoint("TOPLEFT", self.strings.hitRecordString, "TOPRIGHT", offsetX, offsetY)
	else
		self.strings.apString:SetPoint("TOPLEFT", self.tmsframe)
		self.strings.critString:SetPoint("TOPLEFT", self.strings.apString, "BOTTOMLEFT")
		self.strings.speedString:SetPoint("TOPLEFT", self.strings.critString, "BOTTOMLEFT")
		self.strings.hitString:SetPoint("TOPLEFT", self.strings.speedString, "BOTTOMLEFT")
		self.strings.arpString:SetPoint("TOPLEFT", self.strings.hitString, "BOTTOMLEFT")
		
		self.strings.apRecordString:SetPoint("TOPLEFT", self.strings.apString, "TOPRIGHT", offsetX, offsetY)
		self.strings.critRecordString:SetPoint("TOPLEFT", self.strings.critString, "TOPRIGHT", offsetX, offsetY)
		self.strings.speedRecordString:SetPoint("TOPLEFT", self.strings.speedString, "TOPRIGHT", offsetX, offsetY)
		self.strings.hitRecordString:SetPoint("TOPLEFT", self.strings.hitString, "TOPRIGHT", offsetX, offsetY)
		self.strings.arpRecordString:SetPoint("TOPLEFT", self.strings.arpString, "TOPRIGHT", offsetX, offsetY)
	end
end

function TinyMeleeStats:Stats()
	local style = self.db.char.Style
	local base, buff, debuff = UnitAttackPower("player")
	local pow = base + buff + debuff
	local crit = string.format("%.2f", GetCritChance("player"))
	local mainSpeed, offSpeed = UnitAttackSpeed("player")
	local speed = 0
	local hit = string.format("%.2f", GetCombatRatingBonus(CR_HIT_MELEE))
	local arp = string.format("%.2f", GetArmorPenetration("player"))
	local recordBroken = "|cffFF0000"..L["Record broken!"].." "
	local soundFile = "Interface\\Addons\\TinyMeleeStats\\Sound\\"..self.db.char.RecordSoundFile..".wav"
	local recordIsBroken = false

	if (offSpeed == nil) then
		if (mainSpeed > 0) then
			mainSpeed = string.format("%.2f", mainSpeed)
			speed = mainSpeed
			if (tonumber(mainSpeed) < tonumber(self.db.char.FastestMh)) then
				self.db.char.FastestMh = mainSpeed
				if (self.db.char.RecordMsg == true) then
					DEFAULT_CHAT_FRAME:AddMessage(recordBroken.."|cffFF0000"..L["Wapeon speed"]..": |c00ffef00"..self.db.char.FastestMh.."|r")
					recordIsBroken = true
				end
			end
			fastestSpeed = self.db.char.FastestMh
		else
			speed = 0
			mainSpeed = 0
		end
	else
		if (mainSpeed > 0) then
			mainSpeed = string.format("%.2f", mainSpeed)
			offSpeed = string.format("%.2f", offSpeed)
			speed = mainSpeed.."s "..offSpeed
			if (tonumber(mainSpeed) < tonumber(self.db.char.FastestMh)) then
				self.db.char.FastestMh = mainSpeed
				if (self.db.char.RecordMsg == true) then
					DEFAULT_CHAT_FRAME:AddMessage(recordBroken.."|cffFF0000"..L["Weapon speed"].." (MainHand): |c00ffef00"..self.db.char.FastestMh.."|r")
					recordIsBroken = true
				end
			end
			if (tonumber(offSpeed) < tonumber(self.db.char.FastestOh)) then
				self.db.char.FastestOh = offSpeed
				if (self.db.char.RecordMsg == true) then
					DEFAULT_CHAT_FRAME:AddMessage(recordBroken.."|cffFF0000"..L["Weapon speed"].." (OffHand): |c00ffef00"..self.db.char.FastestOh.."|r")
					recordIsBroken = true
				end
			end
			fastestSpeed = self.db.char.FastestMh.."s "..self.db.char.FastestOh
		else
			speed = 0
			mainSpeed = 0
			offSpeed = 0
			fastestSpeed = 0
		end
	end
	
	if (tonumber(pow) > tonumber(self.db.char.HighestAp)) then
		self.db.char.HighestAp = pow
		if (self.db.char.RecordMsg == true) then
			DEFAULT_CHAT_FRAME:AddMessage(recordBroken.."|cffFF0000"..L["Attack Power"]..": |c00ffef00"..self.db.char.HighestAp.."|r")
			recordIsBroken = true
		end
	end
	if (tonumber(crit) > tonumber(self.db.char.HighestCrit)) then
		self.db.char.HighestCrit = crit
		if (self.db.char.RecordMsg == true) then
			DEFAULT_CHAT_FRAME:AddMessage(recordBroken.."|cffFF0000"..L["Critical Chance"]..": |c00ffef00"..self.db.char.HighestCrit.."|r")
			recordIsBroken = true
		end
	end
	if (tonumber(hit) > tonumber(self.db.char.HighestHit)) then
		self.db.char.HighestHit = hit
		if (self.db.char.RecordMsg == true) then
			DEFAULT_CHAT_FRAME:AddMessage(recordBroken.."|cffFF0000"..L["Hit rating"]..": |c00ffef00"..self.db.char.HighestHit.."|r")
			recordIsBroken = true
		end
	end
	if (tonumber(arp) > tonumber(self.db.char.HighestArp)) then
		self.db.char.HighestArp = arp
		if (self.db.char.RecordMsg == true) then
			DEFAULT_CHAT_FRAME:AddMessage(recordBroken.."|cffFF0000"..L["Armor Penetration"]..": |c00ffef00"..self.db.char.HighestArp.."|r")
			recordIsBroken = true
		end
	end
	
	if ((recordIsBroken == true) and (self.db.char.RecordSound == true)) then
		PlaySoundFile(soundFile)
	end
	
	local ldbString = ""
	local ldbRecord = ""
	
	if (style.Ap == true) then
		local apTempString = ""
		local apRecordTempString = ""
		ldbString = ldbString.."|c00ffef00"
		if (style.labels) then
			apTempString = apTempString..L["Ap:"].." "
			ldbString = ldbString..L["Ap:"].." "
		end
		apTempString = apTempString..pow
		ldbString = ldbString..pow.." "
		if (style.showRecords) then
			ldbRecord = ldbRecord.."|c00ffef00"
			if (style.vertical) then
				apRecordTempString = apRecordTempString.."("..self.db.char.HighestAp..")"
				if (style.labels) then
					ldbRecord = ldbRecord..L["Ap:"].." "
				end
				ldbRecord = ldbRecord..self.db.char.HighestAp.." "
			else
				if (style.labels) then
					apRecordTempString = apRecordTempString..L["Ap:"].." "
					ldbRecord = ldbRecord..L["Ap:"].." "
				end
				apRecordTempString = apRecordTempString..self.db.char.HighestAp
				ldbRecord = ldbRecord..self.db.char.HighestAp.." "
			end
		end
		self.strings.apString:SetText(apTempString)
		self.strings.apRecordString:SetText(apRecordTempString)
	else
		self.strings.apString:SetText("")
		self.strings.apRecordString:SetText("")
	end
	if (style.Crit == true) then
		local critTempString = ""
		local critRecordTempString = ""
		ldbString = ldbString.."|c00ff00ff"
		if (style.labels) then
			critTempString = critTempString..L["Crit:"].." "
			ldbString = ldbString..L["Crit:"].." "
		end
		critTempString = critTempString..crit
		ldbString = ldbString..crit.." "
		if (style.showRecords) then
			ldbRecord = ldbRecord.."|c00ff00ff"
			if (style.vertical) then
				critRecordTempString = critRecordTempString.."("..self.db.char.HighestCrit..")"
				if (style.labels) then
					ldbRecord = ldbRecord..L["Crit:"].." "
				end
				ldbRecord = ldbRecord..self.db.char.HighestCrit.." "
			else
				if (style.labels) then
					critRecordTempString = critRecordTempString..L["Crit:"].." "
					ldbRecord = ldbRecord..L["Crit:"].." "
				end
				critRecordTempString = critRecordTempString..self.db.char.HighestCrit
				ldbRecord = ldbRecord..self.db.char.HighestCrit.." "
			end
		end
		self.strings.critString:SetText(critTempString)
		self.strings.critRecordString:SetText(critRecordTempString)
	else
		self.strings.critString:SetText("")
		self.strings.critRecordString:SetText("")
	end
	if (style.Speed == true) then
		local speedTempString = ""
		local speedRecordTempString = ""
		ldbString = ldbString.."|c0000CD00"
		if (style.labels) then
			speedTempString = speedTempString..L["Speed:"].." "
			ldbString = ldbString..L["Speed:"].." "
		end
		speedTempString = speedTempString..speed.."s"
		ldbString = ldbString..speed.."s "
		if (style.showRecords) then
			ldbRecord = ldbRecord.."|c0000CD00"
			if (style.vertical) then
				speedRecordTempString = speedRecordTempString.."("..fastestSpeed.."s)"
				if (style.labels) then
					ldbRecord = ldbRecord..L["Speed:"].." "
				end
				ldbRecord = ldbRecord..fastestSpeed.."s "
			else
				if (style.labels) then
					speedRecordTempString = speedRecordTempString..L["Speed:"].." "
					ldbRecord = ldbRecord..L["Speed:"].." "
				end
				speedRecordTempString = speedRecordTempString..fastestSpeed.."s"
				ldbRecord = ldbRecord..fastestSpeed.."s "
			end
		end
		self.strings.speedString:SetText(speedTempString)
		self.strings.speedRecordString:SetText(speedRecordTempString)
	else
		self.strings.speedString:SetText("")
		self.strings.speedRecordString:SetText("")
	end
	if (style.Hit == true) then
		local hitTempString = ""
		local hitRecordTempString = ""
		ldbString = ldbString.."|c001E90FF"
		if (style.labels) then
			hitTempString = hitTempString..L["Hit:"].." "
			ldbString = ldbString..L["Hit:"].." "
		end
		hitTempString = hitTempString..hit
		ldbString = ldbString..hit.." "
		if (style.showRecords) then
			ldbRecord = ldbRecord.."|c001E90FF"
			if (style.vertical) then
				hitRecordTempString = hitRecordTempString.."("..string.format("%.2f", self.db.char.HighestHit)..")"
				if (style.labels) then
					ldbRecord = ldbRecord..L["Hit:"].." "
				end
				ldbRecord = ldbRecord..string.format("%.2f", self.db.char.HighestHit).." "
			else
				if (style.labels) then
					hitRecordTempString = hitRecordTempString..L["Hit:"].." "
					ldbRecord = ldbRecord..L["Hit:"].." "
				end
				hitRecordTempString = hitRecordTempString..string.format("%.2f", self.db.char.HighestHit)
				ldbRecord = ldbRecord..string.format("%.2f", self.db.char.HighestHit).." "
			end
		end
		self.strings.hitString:SetText(hitTempString)
		self.strings.hitRecordString:SetText(hitRecordTempString)
	else
		self.strings.hitString:SetText("")
		self.strings.hitRecordString:SetText("")
	end
	if (style.Arp == true) then
		local arpTempString = ""
		local arpRecordTempString = ""
		ldbString = ldbString.."|c000033CC"
		if (style.labels) then
			arpTempString = arpTempString..L["Arp:"].." "
			ldbString = ldbString..L["Arp:"].." "
		end
		arpTempString = arpTempString..arp
		ldbString = ldbString..arp
		if (style.showRecords) then
			ldbRecord = ldbRecord.."|c000033CC"
			if (style.vertical) then
				arpRecordTempString = arpRecordTempString.."("..string.format("%.2f", self.db.char.HighestArp)..")"
				if (style.labels) then
					ldbRecord = ldbRecord..L["Arp:"].." "
				end
				ldbRecord = ldbRecord..string.format("%.2f", self.db.char.HighestArp)
			else
				if (style.labels) then
					arpRecordTempString = arpRecordTempString..L["Arp:"].." "
					ldbRecord = ldbRecord..L["Arp:"].." "
				end
				arpRecordTempString = arpRecordTempString..string.format("%.2f", self.db.char.HighestArp)
				ldbRecord = ldbRecord..string.format("%.2f", self.db.char.HighestArp)
			end
		end
		self.strings.arpString:SetText(arpTempString)
		self.strings.arpRecordString:SetText(arpRecordTempString)
	else
		self.strings.arpString:SetText("")
		self.strings.arpRecordString:SetText("")
	end
	ldbString = ldbString.."|n"..ldbRecord.."|r"
	TMSBroker.text = ldbString
end
