--
-- File version: 40
-- Project: 44
--
if not TinyMeleeStats then return end

local L = LibStub("AceLocale-3.0"):GetLocale("TinyMeleeStats")
local media = LibStub:GetLibrary("LibSharedMedia-3.0")

TinyMeleeStats.fonteffects = {
	["none"] = L["NONE"],
	["OUTLINE"] = L["OUTLINE"],
	["THICKOUTLINE"] = L["THICKOUTLINE"]
}

TinyMeleeStats.sound = {
	["Fanfare"] = "Fanfare",
	["Fanfare2"] = "Fanfare2",
	["Fanfare3"] = "Fanfare3",
}

function TinyMeleeStats:Options()
	local options = {
		name = "TinyMeleeStats",
	    handler = TinyMeleeStats,
	    type = 'group',
	    args = {
			reset = {
				name = L["Reset position"],
				desc = L["Resets the frame's position"],
				type = 'execute',
				func = function() self.tmsframe:ClearAllPoints() self.tmsframe:SetPoint("CENTER", UIParent, "CENTER") end,
				disabled = function() return InCombatLockdown() end,
				order = 1,
			},
			lock = {
				name = L["Lock Frame"],
				desc = L["Locks the position of the text frame"],
				type = 'toggle',
				get = function() return self.db.char.FrameLocked end,
				set = function(info, value)				
					if(value) then
						self.db.char.FrameLocked = true
						self.tmsframe:SetMovable(false)
						fixed = "|cffFF0000"..L["Text is fixed. Uncheck Lock Frame in the options to move!"].."|r"
						self.tmsframe:SetScript("OnDragStart", function() DEFAULT_CHAT_FRAME:AddMessage(fixed) end)
					else
						self.db.char.FrameLocked = false
						self.tmsframe:SetMovable(true)
						self.tmsframe:SetScript("OnDragStart", function() self.tmsframe:StartMoving() end)
						self.tmsframe:SetScript("OnDragStop", function()	self.tmsframe:StopMovingOrSizing() self.db.char.xPosition = self.tmsframe:GetLeft() self.db.char.yPosition = self.tmsframe:GetBottom()	end)
					end
				end,
				disabled = function() return InCombatLockdown() end,
				order = 2,
			},
			style = {
				name = L["Stats"],
				desc = L["Select which stats to show"],
				type = 'group',
				order = 2,
				args = {
					hader = {
						name = L["Stats"],
						type = 'header',
						order = 1,
					},
					spaceline3 = {
						name = "\n",
						type = 'description',
						order = 2,
					},
					ap = {
						name = L["Attack Power"],
						desc = L["Attack Power"].." "..L["show/hide"],
						width = 'double',
						type = 'toggle',
						get = function() return self.db.char.Style.Ap end,
						set = function(info, value)				
							if(value) then
								self.db.char.Style.Ap = true
							else
								self.db.char.Style.Ap = false
							end
							self:SetTextAnchors()
							self:Stats()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 3,
					},
					apcolor = {
						name = "",
						desc = "",
						width = 'half',
						type = 'color',
						get = function()
							local c = self.db.char.Color.ap
							return c.r, c.g, c.b
						end,
						set = function(info, r, g, b)
							local c = self.db.char.Color.ap
							c.r, c.g, c.b = r, g, b
							self:SetStringColors()
						end,
						order = 4,
					},
					crit = {
						name = L["Critical Chance"],
						desc = L["Critical Chance"].." "..L["show/hide"],
						width = 'double',
						type = 'toggle',
						get = function() return self.db.char.Style.Crit end,
						set = function(info, value)				
							if(value) then
								self.db.char.Style.Crit = true
							else
								self.db.char.Style.Crit = false
							end
							self:Stats()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 5,
					},
					critcolor = {
						name = "",
						desc = "",
						width = 'half',
						type = 'color',
						get = function()
							local c = self.db.char.Color.crit
							return c.r, c.g, c.b
						end,
						set = function(info, r, g, b)
							local c = self.db.char.Color.crit
							c.r, c.g, c.b = r, g, b
							self:SetStringColors()
						end,
						order = 6,
					},
					speed = {
						name = L["Weapon speed"],
						desc = L["Weapon speed"].." "..L["show/hide"],
						width = 'double',
						type = 'toggle',
						get = function() return self.db.char.Style.Speed end,
						set = function(info, value)				
							if(value) then
								self.db.char.Style.Speed = true
							else
								self.db.char.Style.Speed = false
							end
							self:Stats()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 7,
					},
					speedcolor = {
						name = "",
						desc = "",
						width = 'half',
						type = 'color',
						get = function()
							local c = self.db.char.Color.speed
							return c.r, c.g, c.b
						end,
						set = function(info, r, g, b)
							local c = self.db.char.Color.speed
							c.r, c.g, c.b = r, g, b
							self:SetStringColors()
						end,
						order = 8,
					},
					hit = {
						name = L["Hit rating"],
						desc = L["Hit rating"].." "..L["show/hide"],
						width = 'double',
						type = 'toggle',
						get = function() return self.db.char.Style.Hit end,
						set = function(info, value)				
							if(value) then
								self.db.char.Style.Hit = true
							else
								self.db.char.Style.Hit = false
							end
							self:Stats()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 9,
					},
					hitcolor = {
						name = "",
						desc = "",
						width = 'half',
						type = 'color',
						get = function()
							local c = self.db.char.Color.hit
							return c.r, c.g, c.b
						end,
						set = function(info, r, g, b)
							local c = self.db.char.Color.hit
							c.r, c.g, c.b = r, g, b
							self:SetStringColors()
						end,
						order = 10,
					},
					arp = {
						name = L["Armor Penetration"],
						desc = L["Armor Penetration"].." "..L["show/hide"],
						width = 'double',
						type = 'toggle',
						get = function() return self.db.char.Style.Arp end,
						set = function(info, value)				
							if(value) then
								self.db.char.Style.Arp = true
							else
								self.db.char.Style.Arp = false
							end
							self:Stats()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 11,
					},
					arpcolor = {
						name = "",
						desc = "",
						width = 'half',
						type = 'color',
						get = function()
							local c = self.db.char.Color.arp
							return c.r, c.g, c.b
						end,
						set = function(info, r, g, b)
							local c = self.db.char.Color.arp
							c.r, c.g, c.b = r, g, b
							self:SetStringColors()
						end,
						order = 12,
					},
					spaceline4 = {
						name = "\n",
						type = 'description',
						order = 13,
					},
					showrecords = {
						name = L["Show records"],
						desc = L["Whether or not to show record values"],
						width = 'full',
						type = 'toggle',
						get = function() return self.db.char.Style.showRecords end,
						set = function(info, value)
							if(value) then
								self.db.char.Style.showRecords = true
							else
								self.db.char.Style.showRecords = false
							end
							self:Stats()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 14,
					},
					resetrecords = {
						name = L["Reset records"],
						desc = L["Clears your current records"],
						width = 'normal',
						type = 'execute',
						func = function()
							self.db.char.HighestAp = 0
							self.db.char.HighestCrit = 0
							self.db.char.FastestMh = 500
							self.db.char.FastestOh = 500
							self.db.char.HighestHit = 0
							self.db.char.HighestArp = 0
							self:Stats()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 15,
					},
					resetcolor = {
						name = L["Reset colors"],
						desc = L["Clears your current color settings"],
						type = 'execute',
						func = function()
							local c = self.db.char.Color
							c.ap.r, c.ap.g, c.ap.b = 1, 0.803921568627451, 0
							c.crit.r, c.crit.g, c.crit.b = 1, 0, 0.6549019607843137
							c.hit.r, c.hit.g, c.hit.b = 0, 0.611764705882353, 1
							c.speed.r, c.speed.g, c.speed.b = 0.07058823529411765, 0.7686274509803921, 0
							c.arp.r, c.arp.g, c.arp.b = 0, 0.05490196078431373, 0.8
							self:SetStringColors()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 16,
					}
				}
			},
			text = {
				name = L["Text"],
				desc = L["Text settings"],
				type = 'group',
				order = 3,
				args = {
					oocalpha = {
						name = L["Text Alpha"].." "..L["out of combat"],
						desc = L["Alpha of the text"].." ("..L["out of combat"]..")",
						width = 'full',
						type = 'range',
						min = 0,
						max = 1,
						step = 0.01,
						isPercent = true,
						get = function() return self.db.char.outOfCombatAlpha end,
						set = function(info, newValue)
							self.db.char.outOfCombatAlpha = newValue
							self.tmsframe:SetAlpha(self.db.char.outOfCombatAlpha)
						end,
						disabled = function() return InCombatLockdown() end,
						order = 1,
					},
					icalpha = {
						name = L["Text Alpha"].." "..L["in combat"],
						desc = L["Alpha of the text"].." ("..L["in combat"]..")",
						width = 'full',
						type = 'range',
						min = 0,
						max = 1,
						step = 0.01,
						isPercent = true,
						get = function() return self.db.char.inCombatAlpha end,
						set = function(info, newValue)
							self.db.char.inCombatAlpha = newValue
							self.tmsframe:SetAlpha(self.db.char.inCombatAlpha)
						end,
						disabled = function() return InCombatLockdown() end,
						order = 2,
					},
					barfontsize = {
						name = L["Font size"],
						width = 'full',
						type = 'range',
						min = 6,
						max = 32,
						step = 1,
						get = function() return self.db.char.Size end,
						set = function(info, newValue)
							self.db.char.Size = newValue
							local font = media:Fetch("font", self.db.char.Font)
							for k, fontObject in pairs(self.strings) do
								fontObject:SetFont(font, self.db.char.Size, self.db.char.FontEffect)
							end
						end,
						order = 3,
					},
					font = {
						name = L["Font"],
						type = 'select',
						get = function() return self.db.char.Font end,
						set = function(info, newValue)
							self.db.char.Font = newValue
							local font = media:Fetch("font", self.db.char.Font)
							for k, fontObject in pairs(self.strings) do
								fontObject:SetFont(font, self.db.char.Size, self.db.char.FontEffect)
							end
						end,
						values = self.fonts,
						order = 4,
					},
					fonteffect = {
						name = L["Font border"],
						type = 'select',
						get = function() return self.db.char.FontEffect end,
						set = function(info, newValue)
							self.db.char.FontEffect = newValue
							local font = media:Fetch("font", self.db.char.Font)
							for k, fontObject in pairs(self.strings) do
								fontObject:SetFont(font, self.db.char.Size, self.db.char.FontEffect)
							end
						end,
						values = self.fonteffects,
						order = 5,
					},
					vertical = {
						name = L["Display stats vertically"],
						desc = L["Whether or not to show stats vertically"],
						width = 'full',
						type = 'toggle',
						get = function() return self.db.char.Style.vertical end,
						set = function(info, value)
							if(value) then
								self.db.char.Style.vertical = true
							else
								self.db.char.Style.vertical = false
							end
							self:Stats()
							self:SetTextAnchors()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 6,
					},
					labels = {
						name = L["Show labels"],
						desc = L["Whether or not to show labels for each stat"],
						type = 'toggle',
						get = function() return self.db.char.Style.labels end,
						set = function(info, value)
							if(value) then
								self.db.char.Style.labels = true
							else
								self.db.char.Style.labels = false
							end
							self:Stats()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 7,
					},
					spaceline4 = {
						name = " ",
						type = 'description',
						order = 8,
					},
					record = {
						name = L["Announce records"],
						desc = L["Whether or not to display a message when a record is broken"],
						type = 'toggle',
						get = function() return self.db.char.RecordMsg end,
						set = function(info, value)
							if(value) then
								self.db.char.RecordMsg = true
							else
								self.db.char.RecordMsg = false
							end
						end,
						disabled = function() return InCombatLockdown() end,
						order = 9,
					},
					recordSound = {
						name = L["Play sound on record"],
						desc = L["Whether or not to play a sound when a record is broken"],
						type = 'toggle',
						get = function() return self.db.char.RecordSound end,
						set = function(info, value)
							if(value) then
								self.db.char.RecordSound = true
							else
								self.db.char.RecordSound = false
							end
						end,
						disabled = function() return InCombatLockdown() end,
						order = 10,
					},
					spaceline5 = {
						name = " ",
						type = 'description',
						order = 11,
					},
					selectSound = {
						name = L["Sound"],
						type = 'select',
						get = function() return self.db.char.RecordSoundFile end,
						set = function(info, value) self.db.char.RecordSoundFile = value end,
						values = self.sound,
						disabled = function() return InCombatLockdown() end,
						order = 12,
					},
					listenSound = {
						name = L["Play sound"],
						type = 'execute',
						func = function() PlaySoundFile("Interface\\Addons\\TinyMeleeStats\\Sound\\"..self.db.char.RecordSoundFile..".wav") end,
						disabled = function() return InCombatLockdown() end,
						order = 13,
					}
				}
			}
		}
	}
	return options
end
