--         ---------------------------------------------
--        |  TinyCasterStats by TheVaan and ArcaneMagus |
--         ---------------------------------------------
--
-- File version: 36
-- Project: 37
--

local AceAddon = LibStub("AceAddon-3.0")
local media = LibStub:GetLibrary("LibSharedMedia-3.0")
TinyCasterStats = AceAddon:NewAddon("TinyCasterStats", "AceConsole-3.0", "AceEvent-3.0", "AceTimer-3.0")
local L = LibStub:GetLibrary("AceLocale-3.0"):GetLocale("TinyCasterStats")
local LGT = LibStub:GetLibrary("LibGroupTalents-1.0");
local isInFight = false


local ldb = LibStub:GetLibrary("LibDataBroker-1.1");
local TCSBroker = ldb:NewDataObject("TinyCasterStats", {
	type = "data source",
	label = "TCS",
	icon = "Interface\\Icons\\Ability_Mage_ArcaneBarrage",
	text = "--"
	})

TinyCasterStats.fonts = {}

TinyCasterStats.defaults = {
	char = {
		Font = "Vera",
		FontEffect = "none",
		Size = 12,
		FrameLocked = true,
		yPosition = 200,
		xPosition = 200,
		inCombatAlpha = 1,
		outOfCombatAlpha = .3,
		RecordMsg = true,
		HighestSpelldmg = 0,
		HighestCrit = 0,
		HighestHaste = 0,
		HighestHastePerc = 0,
		HighestHit = 0,
		HighestMP5if = 0,
		HighestMP5 = 0,
		Style = {
			Spelldmg = true,
			Crit = true,
			Haste = true,
			HastePerc = false,
			Hit = false,
			MP5 = false,
			MP5ic = false,
			MP5auto = false,
			showRecords = true,
			vertical = false,
			labels = false
		},
		Color = {
			sp = {
				r = 1.0,
				g = 0.9372549019607843,
				b = 0
			},
			crit = {
				r = 1.0,
				g = 0,
				b = 1.0
			},
			hit = {
				r = 0,
				g = 0.803921568627451,
				b = 0
			},
			haste = {
				r = 0.1176470588235294,
				g = 0.5647058823529412,
				b = 1.0
			},
			mp5 = {
				r = 1.0,
				g = 1.0,
				b = 1.0
			}
		}
	}
}

TinyCasterStats.tcsframe = CreateFrame("Frame","TinyCasterStatsFrame",UIParent)
TinyCasterStats.tcsframe:SetWidth(100)
TinyCasterStats.tcsframe:SetHeight(15)
TinyCasterStats.tcsframe:SetFrameStrata("BACKGROUND")
TinyCasterStats.tcsframe:EnableMouse(true)
TinyCasterStats.tcsframe:RegisterForDrag("LeftButton")

TinyCasterStats.strings = {
	spString = TinyCasterStats.tcsframe:CreateFontString(),
	critString = TinyCasterStats.tcsframe:CreateFontString(),
	hitString = TinyCasterStats.tcsframe:CreateFontString(),
	hasteString = TinyCasterStats.tcsframe:CreateFontString(),
	mp5String = TinyCasterStats.tcsframe:CreateFontString(),
	
	spRecordString = TinyCasterStats.tcsframe:CreateFontString(),
	critRecordString = TinyCasterStats.tcsframe:CreateFontString(),
	hitRecordString = TinyCasterStats.tcsframe:CreateFontString(),
	hasteRecordString = TinyCasterStats.tcsframe:CreateFontString(),
	mp5RecordString = TinyCasterStats.tcsframe:CreateFontString()
}

function TinyCasterStats:SetStringColors()
	local c = self.db.char.Color
	self.strings.spString:SetTextColor(c.sp.r, c.sp.g, c.sp.b, 1.0)
	self.strings.critString:SetTextColor(c.crit.r, c.crit.g, c.crit.b, 1.0)
	self.strings.hitString:SetTextColor(c.hit.r, c.hit.g, c.hit.b, 1.0)
	self.strings.hasteString:SetTextColor(c.haste.r, c.haste.g, c.haste.b, 1.0)
	self.strings.mp5String:SetTextColor(c.mp5.r, c.mp5.g, c.mp5.b, 1.0)

	self.strings.spRecordString:SetTextColor(c.sp.r, c.sp.g, c.sp.b, 1.0)
	self.strings.critRecordString:SetTextColor(c.crit.r, c.crit.g, c.crit.b, 1.0)
	self.strings.hitRecordString:SetTextColor(c.hit.r, c.hit.g, c.hit.b, 1.0)
	self.strings.hasteRecordString:SetTextColor(c.haste.r, c.haste.g, c.haste.b, 1.0)
	self.strings.mp5RecordString:SetTextColor(c.mp5.r, c.mp5.g, c.mp5.b, 1.0)
end

function TinyCasterStats:SetTextAnchors()
	local offsetX, offsetY = 3, 0
	if (not self.db.char.Style.vertical) then
		self.strings.spString:SetPoint("TOPLEFT", self.tcsframe)
		self.strings.critString:SetPoint("TOPLEFT", self.strings.spString, "TOPRIGHT", offsetX, offsetY)
		self.strings.hitString:SetPoint("TOPLEFT", self.strings.critString, "TOPRIGHT", offsetX, offsetY)
		self.strings.hasteString:SetPoint("TOPLEFT", self.strings.hitString, "TOPRIGHT", offsetX, offsetY)
		self.strings.mp5String:SetPoint("TOPLEFT", self.strings.hasteString, "TOPRIGHT", offsetX, offsetY)

		self.strings.spRecordString:SetPoint("TOPLEFT", self.strings.spString, "BOTTOMLEFT")
		self.strings.critRecordString:SetPoint("TOPLEFT", self.strings.spRecordString, "TOPRIGHT", offsetX, offsetY)
		self.strings.hitRecordString:SetPoint("TOPLEFT", self.strings.critRecordString, "TOPRIGHT", offsetX, offsetY)
		self.strings.hasteRecordString:SetPoint("TOPLEFT", self.strings.hitRecordString, "TOPRIGHT", offsetX, offsetY)
		self.strings.mp5RecordString:SetPoint("TOPLEFT", self.strings.hasteRecordString, "TOPRIGHT", offsetX, offsetY)
	else
		self.strings.spString:SetPoint("TOPLEFT", self.tcsframe)
		self.strings.critString:SetPoint("TOPLEFT", self.strings.spString, "BOTTOMLEFT")
		self.strings.hitString:SetPoint("TOPLEFT", self.strings.critString, "BOTTOMLEFT")
		self.strings.hasteString:SetPoint("TOPLEFT", self.strings.hitString, "BOTTOMLEFT")
		self.strings.mp5String:SetPoint("TOPLEFT", self.strings.hasteString, "BOTTOMLEFT")

		self.strings.spRecordString:SetPoint("TOPLEFT", self.strings.spString, "TOPRIGHT", offsetX, offsetY)
		self.strings.critRecordString:SetPoint("TOPLEFT", self.strings.critString, "TOPRIGHT", offsetX, offsetY)
		self.strings.hitRecordString:SetPoint("TOPLEFT", self.strings.hitString, "TOPRIGHT", offsetX, offsetY)
		self.strings.hasteRecordString:SetPoint("TOPLEFT", self.strings.hasteString, "TOPRIGHT", offsetX, offsetY)
		self.strings.mp5RecordString:SetPoint("TOPLEFT", self.strings.mp5String, "TOPRIGHT", offsetX, offsetY)
	end
end

function TinyCasterStats:OnInitialize()
	local AceConfigReg = LibStub("AceConfigRegistry-3.0")
	local AceConfigDialog = LibStub("AceConfigDialog-3.0")

	self.db = LibStub("AceDB-3.0"):New("TinyCasterStats", TinyCasterStats.defaults, "char")
	LibStub("AceConfig-3.0"):RegisterOptionsTable("TinyCasterStats", self:Options(), "tcscmd")
	media.RegisterCallback(self, "LibSharedMedia_Registered")

	self:RegisterChatCommand("tcs", function() AceConfigDialog:Open("TinyCasterStats") end)
	self:RegisterChatCommand("TinyCasterStats", function() AceConfigDialog:Open("TinyCasterStats") end)
	self.optionsFrame = AceConfigDialog:AddToBlizOptions("TinyCasterStats", "TinyCasterStats")
	self.db:RegisterDefaults(self.defaults)
	local version = GetAddOnMetadata("TinyCasterStats","Version")
	local loaded = L["Open the configuration menu with /tcs or /tinycasterstats"].."|r"
	DEFAULT_CHAT_FRAME:AddMessage("|cffffd700TinyCasterStats |cff00ff00~v"..version.."~|cffffd700: "..loaded)
end

function TinyCasterStats:OnEnable()
	self:LibSharedMedia_Registered()
	self:RegisterEvent("PLAYER_ENTERING_WORLD", "OnEvent")
	self:RegisterEvent("ADDON_LOADED", "OnEvent")
	self:RegisterEvent("VARIABLES_LOADED", "OnEvent")
	self:RegisterEvent("UNIT_AURA", "OnEvent")
	self:RegisterEvent("UPDATE_SHAPESHIFT_FORM", "OnEvent")
	self:RegisterEvent("UNIT_INVENTORY_CHANGED", "OnEvent")
	self:RegisterEvent("UNIT_LEVEL", "OnEvent")
	self:RegisterEvent("PLAYER_REGEN_ENABLED", "OnEvent")
	self:RegisterEvent("PLAYER_REGEN_DISABLED", "OnEvent")
	self:RegisterEvent("PLAYER_TALENT_UPDATE", "OnEvent")
end

function TinyCasterStats:LibSharedMedia_Registered()
	media:Register("font", "BaarSophia", [[Interface\Addons\TinyCasterStats\Fonts\BaarSophia.ttf]])
	media:Register("font", "LucidaSD", [[Interface\Addons\TinyCasterStats\Fonts\LucidaSD.ttf]])
	media:Register("font", "Teen", [[Interface\Addons\TinyCasterStats\Fonts\Teen.ttf]])
	media:Register("font", "Vera", [[Interface\Addons\TinyCasterStats\Fonts\Vera.ttf]])

	for k, v in pairs(media:List("font")) do
		self.fonts[v] = v
	end
end

function TinyCasterStats:OnEvent(event, arg1)
	if (event == "ADDON_LOADED") then
		self.tcsframe:SetPoint("BOTTOMLEFT", UIParent, "BOTTOMLEFT", self.db.char.xPosition, self.db.char.yPosition)
		local font = media:Fetch("font", self.db.char.Font)
		for k, fontObject in pairs(self.strings) do
			fontObject:SetFontObject(GameFontNormal)
			fontObject:SetFont(font, self.db.char.Size, self.db.char.FontEffect)
			fontObject:SetJustifyH("LEFT")
			fontObject:SetJustifyV("MIDDLE")
		end
		self.strings.spString:SetText(" ")
		self.strings.spString:SetHeight(self.strings.spString:GetStringHeight())
		self.strings.spString:SetText("")
		self:SetTextAnchors()
		self:SetStringColors()
	end
	if ((event == "PLAYER_REGEN_ENABLED") or (event == "PLAYER_ENTERING_WORLD")) then
		self.tcsframe:SetAlpha(self.db.char.outOfCombatAlpha)
		isInFight = false
	end
	if (event == "PLAYER_REGEN_DISABLED") then
		self.tcsframe:SetAlpha(self.db.char.inCombatAlpha)
		isInFight = true
	end
	if (self.db.char.FrameLocked == true) then
		local fixed = "|cffFF0000"..L["Text is fixed. Uncheck Lock Frame in the options to move!"].."|r"
		self.tcsframe:SetScript("OnDragStart", function() DEFAULT_CHAT_FRAME:AddMessage(fixed) end)
	end
	if (event == "UNIT_AURA" and arg1 == "player") then
		self:ScheduleTimer("Stats", .8)
	end
  	self:Stats()
end

local function GetHaste()
--Localize buff names
	local hasteBuffs = {
		bloodlust = GetSpellInfo(2825),
		heroism = GetSpellInfo(32182),
		wrathOfAir = GetSpellInfo(2895),
		elementalMastery = GetSpellInfo(64701),
		moonkinAura = GetSpellInfo(24907),
		concentrationAura = GetSpellInfo(19746),
		crusaderAura = GetSpellInfo(32223),
		devotionAura = GetSpellInfo(465),
		retributionAura = GetSpellInfo(7294),
		shadowResistanceAura = GetSpellInfo(19876),
		frostResistanceAura = GetSpellInfo(19888),
		fireResistanceAura = GetSpellInfo(19891),
		icyVeins = GetSpellInfo(12472),
		berserking = GetSpellInfo(26297),
		backdraft = GetSpellInfo(54277),
		pushingTheLimit = GetSpellInfo(70753),
		powerInfusion = GetSpellInfo(10060),
		naturesGrace = GetSpellInfo(16886),
		netherwindPresence = GetSpellInfo(44403),
		celestialFocus = GetSpellInfo(16924),
		giftOfTheEarthmother = GetSpellInfo(51183),
		swiftRetribution = GetSpellInfo(53648),
		improvedMoonkinForm = GetSpellInfo(48396),
		judgementsOfThePure = GetSpellInfo(54153)
	}
	local haste = GetCombatRating(CR_HASTE_SPELL)
	local hasteperc = 1 + 0.01 * GetCombatRatingBonus(CR_HASTE_SPELL)
	
	if (UnitAura("player", hasteBuffs.bloodlust) or UnitAura("player", hasteBuffs.heroism)) then
		haste = haste * 1.3
		hasteperc = hasteperc * 1.3
	end
	if (UnitAura("player", hasteBuffs.wrathOfAir)) then
		haste = haste * 1.05
		hasteperc = hasteperc * 1.05
	end
	if (UnitAura("player", hasteBuffs.elementalMastery)) then
		haste = haste * 1.15
		hasteperc = hasteperc * 1.05
	end
	if (UnitAura("player", hasteBuffs.icyVeins)) then
		haste = haste * 1.20
		hasteperc = hasteperc * 1.20
	end
	if (UnitAura("player", hasteBuffs.berserking)) then
		haste = haste * 1.20
		hasteperc = hasteperc * 1.20
	end
	if (UnitAura("player", hasteBuffs.backdraft)) then
		haste = haste * 1.30
		hasteperc = hasteperc * 1.30
	end
	if (UnitAura("player", hasteBuffs.pushingTheLimit)) then
		haste = haste * 1.12
		hasteperc = hasteperc * 1.12
	end
	if (UnitAura("player", hasteBuffs.naturesGrace)) then
		haste = haste * 1.20
		hasteperc = hasteperc * 1.20
	end
	local _,_,_,_,_,_,_,_,_,_,spellID = UnitAura("player", hasteBuffs.judgementsOfThePure)
	if (spellID) then
		if (spellID == 54153) then --Rank 5
			haste = haste * 1.15
			hasteperc = hasteperc * 1.15
		elseif (spellID == 54152) then --Rank 4
			haste = haste * 1.12
			hasteperc = hasteperc * 1.12
		elseif (spellID == 53657) then --Rank 3
			haste = haste * 1.09
			hasteperc = hasteperc * 1.09
		elseif (spellID == 53656) then --Rank 2
			haste = haste * 1.06
			hasteperc = hasteperc * 1.06
		elseif (spellID == 53655) then --Rank 1
			haste = haste * 1.03
			hasteperc = hasteperc * 1.03
		end
	end
	
	if (UnitAura("player", hasteBuffs.powerInfusion)
		and not (UnitAura("player", hasteBuffs.bloodlust) or UnitAura("player", hasteBuffs.heroism))) then
		haste = haste * 1.20
		hasteperc = hasteperc * 1.20
	end
	local netherwindPresence = LGT:UnitHasTalent("player", hasteBuffs.netherwindPresence)
	if (netherwindPresence) then
		haste = haste * (1 + netherwindPresence * .02)
		hasteperc = hasteperc * (1 + netherwindPresence * .02)
	end
	local celestialFocus = LGT:UnitHasTalent("player", hasteBuffs.celestialFocus)
	if (celestialFocus) then
		haste = haste * (1 + celestialFocus * .01)
		hasteperc = hasteperc * (1 + celestialFocus * .01)
	end
	local giftOfTheEarthmother = LGT:UnitHasTalent("player", hasteBuffs.giftOfTheEarthmother)
	if (giftOfTheEarthmother) then
		haste = haste * (1 + giftOfTheEarthmother * .02)
		hasteperc = hasteperc * (1 + giftOfTheEarthmother * .02)
	end

	local moonkinPoints
	local _,_,_,_,_,_,_,caster = UnitAura("player", hasteBuffs.moonkinAura)
	if (caster) then
		moonkinPoints = LGT:UnitHasTalent(caster, hasteBuffs.improvedMoonkinForm)
	end
	local oldPoints, pallyPoints = 0, nil
	for i,buff in ipairs({"concentrationAura","crusaderAura","devotionAura","retributionAura",
		"shadowResistanceAura","frostResistanceAura","fireResistanceAura"}) do
		local _,_,_,_,_,_,_,caster = UnitAura("player", hasteBuffs[buff])
		if (caster) then
			if (pallyPoints) then
				oldPoints = pallyPoints
			end
			local newPoints = LGT:UnitHasTalent(caster, hasteBuffs.swiftRetribution)
			if (newPoints and newPoints > oldPoints) then
				pallyPoints = newPoints
			end
		end
	end
	if (pallyPoints or moonkinPoints) then
		if (pallyPoints and moonkinPoints) then
			if (pallyPoints >= moonkinPoints) then
				haste = (haste * (1 + pallyPoints * .01))
				hasteperc = (hasteperc * (1 + pallyPoints * .01))
			else
				haste = (haste * (1 + moonkinPoints * .01))
				hasteperc = (hasteperc * (1 + moonkinPoints * .01))
			end
		elseif (not moonkinPoints and pallyPoints) then
			haste = (haste * (1 + pallyPoints * .01))
			hasteperc = (hasteperc * (1 + pallyPoints * .01))
		elseif (not pallyPoints) then
			haste = (haste * (1 + moonkinPoints * .01))
			hasteperc = (hasteperc * (1 + moonkinPoints * .01))
		end
	end
	return haste, (hasteperc - 1) * 100
end

local function GetSpellDamage()
	local spelldamage = 0
	for i = 2, 7, 1 do
		if (spelldamage < GetSpellBonusDamage(i)) then
			spelldamage = GetSpellBonusDamage(i)
		end
	end
	if (spelldamage < GetSpellBonusHealing()) then
		spelldamage = GetSpellBonusHealing()
	end
	return spelldamage
end

local function GetCrit()
	local critchance = 0
	for i = 2, 7, 1 do
		if (critchance < GetSpellCritChance(i)) then
			critchance = GetSpellCritChance(i)
		end
	end
	return critchance
end

local function GetHit()
	local hitBuffs = { -- 1%/rank unless otherwise noted
		arcaneFocus = GetSpellInfo(12840),
		precision = GetSpellInfo(29440),
		elementalPrecision = GetSpellInfo(30674),
		shadowFocus = GetSpellInfo(15328),
		suppression = GetSpellInfo(18176),
		balanceOfPower = GetSpellInfo(33596), -- 2%/rank
		impFaerieFire = GetSpellInfo(33602),
		faerieFire = GetSpellInfo(770), -- target
		misery = GetSpellInfo(33198) -- target
	}
	local hit = GetCombatRatingBonus(CR_HIT_SPELL)
	local arcaneFocus = LGT:UnitHasTalent("player", hitBuffs.arcaneFocus)
	if (arcaneFocus) then
		hit = hit + arcaneFocus
	end
	local precision = LGT:UnitHasTalent("player", hitBuffs.precision)
	if (precision) then
		hit = hit + precision
	end
	local elementalPrecision = LGT:UnitHasTalent("player", hitBuffs.elementalPrecision)
	if (elementalPrecision) then
		hit = hit + elementalPrecision
	end
	local shadowFocus = LGT:UnitHasTalent("player", hitBuffs.shadowFocus)
	if (shadowFocus) then
		hit = hit + shadowFocus
	end
	local suppression = LGT:UnitHasTalent("player", hitBuffs.suppression)
	if (suppression) then
		hit = hit + suppression
	end
	local balanceOfPower = LGT:UnitHasTalent("player", hitBuffs.balanceOfPower)
	if (balanceOfPower) then
		hit = hit + 2 * balanceOfPower
	end
	
	local impFaerieFirePoints
	local _,_,_,_,_,_,_,caster = UnitAura("target", hitBuffs.faerieFire, nil, "HARMFUL")
	if (caster) then
		impFaerieFirePoints = LGT:UnitHasTalent(caster, hitBuffs.impFaerieFire)
	end
	local miseryPoints
	local _,_,_,_,_,_,_,caster,_,_,spellID = UnitAura("target", hitBuffs.misery, nil, "HARMFUL")
	if (caster) then
		if (spellID == 33198) then --Rank 3
			miseryPoints = 3
		elseif (spellID == 33197) then --Rank 2
			miseryPoints = 2
		elseif (spellID == 33196) then --Rank 1
			miseryPoints = 1
		end
	end
	if (impFaerieFirePoints or miseryPoints) then
		if (impFaerieFirePoints and miseryPoints) then
			if (impFaerieFirePoints >= miseryPoints) then
				hit = hit + impFaerieFirePoints
			else
				hit = hit + miseryPoints
			end
		elseif (not miseryPoints and impFaerieFirePoints) then
			hit = hit + impFaerieFirePoints
		elseif (not impFaerieFirePoints) then
			hit = hit + miseryPoints
		end
	end
	return hit
end

function TinyCasterStats:Stats()
	local style = self.db.char.Style
	local spelldmg = GetSpellDamage()
	local crit = GetCrit()
	local haste, hasteperc = GetHaste()
	local hit = GetHit()
	local base, casting = GetManaRegen()
	base = base * 5
	casting = casting * 5
	local recordBroken = "|cffFF0000"..L["Record broken!"]..": "

	if (spelldmg > tonumber(self.db.char.HighestSpelldmg)) then
		self.db.char.HighestSpelldmg = spelldmg
		if (self.db.char.RecordMsg == true) then
			DEFAULT_CHAT_FRAME:AddMessage(recordBroken.."|cffFF0000"..L["Spellpower"]..": |c00ffef00"..self.db.char.HighestSpelldmg.."|r")
		end
	end
	if (crit > tonumber(self.db.char.HighestCrit)) then
		self.db.char.HighestCrit = crit
		if (self.db.char.RecordMsg == true) then
			DEFAULT_CHAT_FRAME:AddMessage(recordBroken.."|cffFF0000"..L["Crit Chance"]..": |c00ffef00"..string.format("%.2f", self.db.char.HighestCrit).."%|r")
		end
	end
	if ((haste > tonumber(self.db.char.HighestHaste)) or (hasteperc > tonumber(self.db.char.HighestHastePerc))) then
		self.db.char.HighestHaste = haste
		self.db.char.HighestHastePerc = hasteperc
		if (self.db.char.RecordMsg == true) then
			DEFAULT_CHAT_FRAME:AddMessage(recordBroken.."|cffFF0000"..L["Haste Rating"]..": |c00ffef00"..string.format("%.0f", self.db.char.HighestHaste).."|r")
			DEFAULT_CHAT_FRAME:AddMessage(recordBroken.."|cffFF0000"..L["Percent Haste"]..": |c00ffef00"..string.format("%.2f", self.db.char.HighestHastePerc).."%|r")
		end
	end
	if (hit > tonumber(self.db.char.HighestHit)) then
		self.db.char.HighestHit = hit
		if (self.db.char.RecordMsg == true) then
			DEFAULT_CHAT_FRAME:AddMessage(recordBroken.."|cffFF0000"..L["Hit Rate"]..": |c00ffef00"..string.format("%.2f", self.db.char.HighestHit).."%|r")
		end
	end
	if (base > tonumber(self.db.char.HighestMP5)) then
		self.db.char.HighestMP5 = base
		if (self.db.char.RecordMsg == true) then
			DEFAULT_CHAT_FRAME:AddMessage(recordBroken.."|cffFF0000"..L["Mana Regeneration"].." "..L["out of combat"]..": |c00ffef00"..string.format("%.0f", self.db.char.HighestMP5).."|r")
		end
	end
	if (casting > tonumber(self.db.char.HighestMP5if)) then
		self.db.char.HighestMP5if = casting
		if (self.db.char.RecordMsg == true) then
			DEFAULT_CHAT_FRAME:AddMessage(recordBroken.."|cffFF0000"..L["Mana Regeneration"].." "..L["in combat"]..": |c00ffef00"..string.format("%.0f", self.db.char.HighestMP5if).."|r")
		end
	end

	local ldbString = ""
	local ldbRecord = ""
	
	if (style.Spelldmg) then
		local spTempString = ""
		local spRecordTempString = ""
		ldbString = ldbString.."|c00ffef00"
		if (style.labels) then
			spTempString = spTempString..L["Sp:"].." "
			ldbString = ldbString..L["Sp:"].." "
		end
		spTempString = spTempString..spelldmg
		ldbString = ldbString..spelldmg.." "
		if (style.showRecords) then
			ldbRecord = ldbRecord.."|c00ffef00"
			if (style.vertical) then
				if (style.labels) then
					ldbRecord = ldbRecord..L["Sp:"].." "
				end
				spRecordTempString = spRecordTempString.."("..self.db.char.HighestSpelldmg..")"
				ldbRecord = ldbRecord..self.db.char.HighestSpelldmg.." "
			else
				if (style.labels) then
					spRecordTempString = spRecordTempString..L["Sp:"].." "
					ldbRecord = ldbRecord..L["Sp:"].." "
				end
				spRecordTempString = spRecordTempString..self.db.char.HighestSpelldmg
				ldbRecord = ldbRecord..self.db.char.HighestSpelldmg.." "
			end
		end
		self.strings.spString:SetText(spTempString)
		self.strings.spRecordString:SetText(spRecordTempString)
	else
		self.strings.spString:SetText("")
		self.strings.spRecordString:SetText("")
	end
	if (style.Crit) then
		local critTempString = ""
		local critRecordTempString = ""
		ldbString = ldbString.."|c00ffef00"
		if (style.labels) then
			critTempString = critTempString..L["Crit:"].." "
			ldbString = ldbString..L["Crit:"].." "
		end
		critTempString = critTempString..string.format("%.2f", crit).."%"
		ldbString = ldbString..string.format("%.2f", crit).."% "
		if (style.showRecords) then
			ldbRecord = ldbRecord.."|c00ffef00"
			if (style.vertical) then
				if (style.labels) then
					ldbRecord = ldbRecord..L["Crit:"].." "
				end
				critRecordTempString = critRecordTempString.."("..string.format("%.2f", self.db.char.HighestCrit).."%)"
				ldbRecord = ldbRecord..string.format("%.2f", self.db.char.HighestCrit).."% "
			else
				if (style.labels) then
					critRecordTempString = critRecordTempString..L["Crit:"].." "
					ldbRecord = ldbRecord..L["Crit:"].." "
				end
				critRecordTempString = critRecordTempString..string.format("%.2f", self.db.char.HighestCrit).."%"
				ldbRecord = ldbRecord..string.format("%.2f", self.db.char.HighestCrit).."% "
			end
		end
		self.strings.critString:SetText(critTempString)
		self.strings.critRecordString:SetText(critRecordTempString)
	else
		self.strings.critString:SetText("")
		self.strings.critRecordString:SetText("")
	end
	if (style.Hit) then
		local hitTempString = ""
		local hitRecordTempString = ""
		ldbString = ldbString.."|c00ffef00"
		if (style.labels) then
			hitTempString = hitTempString..L["Hit:"].." "
			ldbString = ldbString..L["Hit:"].." "
		end
		hitTempString = hitTempString..string.format("%.2f", hit).."%"
		ldbString = ldbString..string.format("%.2f", hit).."% "
		if (style.showRecords) then
			ldbRecord = ldbRecord.."|c00ffef00"
			if (style.vertical) then
				if (style.labels) then
					ldbRecord = ldbRecord..L["Hit:"].." "
				end
				hitRecordTempString = hitRecordTempString.."("..string.format("%.2f", self.db.char.HighestHit).."%)"
				ldbRecord = ldbRecord..string.format("%.2f", self.db.char.HighestHit).."% "
			else
				if (style.labels) then
					hitRecordTempString = hitRecordTempString..L["Hit:"].." "
					ldbRecord = ldbRecord..L["Hit:"].." "
				end
				hitRecordTempString = hitRecordTempString..string.format("%.2f", self.db.char.HighestHit).."%"
				ldbRecord = ldbRecord..string.format("%.2f", self.db.char.HighestHit).."% "
			end
		end
		self.strings.hitString:SetText(hitTempString)
		self.strings.hitRecordString:SetText(hitRecordTempString)
	else
		self.strings.hitString:SetText("")
		self.strings.hitRecordString:SetText("")
	end
	if (style.Haste) then
		local hasteTempString = ""
		local hasteRecordTempString = ""
		ldbString = ldbString.."|c00ffef00"
		if (style.labels) then
			hasteTempString = hasteTempString..L["Haste:"].." "
			ldbString = ldbString..L["Haste:"].." "
		end
		hasteTempString = hasteTempString..string.format("%.0f", haste)
		ldbString = ldbString..string.format("%.0f", haste).." "
		if (style.showRecords) then
			ldbRecord = ldbRecord.."|c00ffef00"
			if (style.vertical) then
				if (style.labels) then
					ldbRecord = ldbRecord..L["Haste:"].." "
				end
				hasteRecordTempString = hasteRecordTempString.."("..string.format("%.0f", self.db.char.HighestHaste)..")"
				ldbRecord = ldbRecord..string.format("%.0f", self.db.char.HighestHaste).." "
			else
				if (style.labels) then
					hasteRecordTempString = hasteRecordTempString..L["Haste:"].." "
					ldbRecord = ldbRecord..L["Haste:"].." "
				end
				hasteRecordTempString = hasteRecordTempString..string.format("%.0f", self.db.char.HighestHaste)
				ldbRecord = ldbRecord..string.format("%.0f", self.db.char.HighestHaste).." "
			end
		end
		self.strings.hasteString:SetText(hasteTempString)
		self.strings.hasteRecordString:SetText(hasteRecordTempString)
	else
		if (not style.HastePerc) then
			self.strings.hasteString:SetText("")
			self.strings.hasteRecordString:SetText("")
		end
	end
	if (style.HastePerc) then
		local hasteTempString = ""
		local hasteRecordTempString = ""
		ldbString = ldbString.."|c00ffef00"
		if (style.labels) then
			hasteTempString = hasteTempString..L["Haste:"].." "
			ldbString = ldbString..L["Haste:"].." "
		end
		hasteTempString = hasteTempString..string.format("%.2f", hasteperc).."%"
		ldbString = ldbString..string.format("%.2f", hasteperc).."% "
		if (style.showRecords) then
			ldbRecord = ldbRecord.."|c00ffef00"
			if (style.vertical) then
				if (style.labels) then
					ldbRecord = ldbRecord..L["Haste:"].." "
				end
				hasteRecordTempString = hasteRecordTempString.."("..string.format("%.2f", self.db.char.HighestHastePerc).."%)"
				ldbRecord = ldbRecord..string.format("%.2f", self.db.char.HighestHastePerc).."% "
			else
				if (style.labels) then
					hasteRecordTempString = hasteRecordTempString..L["Haste:"].." "
					ldbRecord = ldbRecord..L["Haste:"].." "
				end
				hasteRecordTempString = hasteRecordTempString..string.format("%.2f", self.db.char.HighestHastePerc).."%"
				ldbRecord = ldbRecord..string.format("%.2f", self.db.char.HighestHastePerc).."% "
			end
		end
		self.strings.hasteString:SetText(hasteTempString)
		self.strings.hasteRecordString:SetText(hasteRecordTempString)
	else
		if (not style.Haste) then
			self.strings.hasteString:SetText("")
			self.strings.hasteRecordString:SetText("")
		end
	end
	if (style.MP5) then
		local mp5TempString = ""
		local mp5RecordTempString = ""
		ldbString = ldbString.."|c00FFFFFF"
		if (style.labels) then
			mp5TempString = mp5TempString..L["MP5:"].." "
			ldbString = ldbString..L["MP5:"].." "
		end
		mp5TempString = mp5TempString..string.format("%.0f", base).."mp5"
		ldbString = ldbString..string.format("%.0f", base).."mp5 "
		if (style.showRecords) then
			ldbRecord = ldbRecord.."|c00FFFFFF"
			if (style.vertical) then
				if (style.labels) then
					ldbRecord = ldbRecord..L["MP5:"].." "
				end
				mp5RecordTempString = mp5RecordTempString.."("..string.format("%.0f", self.db.char.HighestMP5).."mp5)"
				ldbRecord = ldbRecord..string.format("%.0f", self.db.char.HighestMP5).."mp5 "
			else
				if (style.labels) then
					mp5RecordTempString = mp5RecordTempString..L["MP5:"].." "
					ldbRecord = ldbRecord..L["MP5:"].." "
				end
				mp5RecordTempString = mp5RecordTempString..string.format("%.0f", self.db.char.HighestMP5).."mp5"
				ldbRecord = ldbRecord..string.format("%.0f", self.db.char.HighestMP5).."mp5 "
			end
		end
		self.strings.mp5String:SetText(mp5TempString)
		self.strings.mp5RecordString:SetText(mp5RecordTempString)
	else
		self.strings.mp5String:SetText("")
		self.strings.mp5RecordString:SetText("")
	end
	if (style.MP5ic) then
		local mp5TempString = ""
		local mp5RecordTempString = ""
		ldbString = ldbString.."|c00FFFFFF"
		if (style.labels) then
			mp5TempString = mp5TempString..L["MP5-ic:"].." "
			ldbString = ldbString..L["MP5-ic:"].." "
		end
		mp5TempString = mp5TempString..string.format("%.0f", casting).."mp5"
		ldbString = ldbString..string.format("%.0f", casting).."mp5 "
		if (style.showRecords) then
			ldbRecord = ldbRecord.."|c00FFFFFF"
			if (style.vertical) then
				if (style.labels) then
					ldbRecord = ldbRecord..L["MP5-ic:"].." "
				end
				mp5RecordTempString = mp5RecordTempString.."("..string.format("%.0f", self.db.char.HighestMP5if).."mp5)"
				ldbRecord = ldbRecord..string.format("%.0f", self.db.char.HighestMP5if).."mp5 "
			else
				if (style.labels) then
					mp5RecordTempString = mp5RecordTempString..L["MP5-ic:"].." "
					ldbRecord = ldbRecord..L["MP5-ic:"].." "
				end
				mp5RecordTempString = mp5RecordTempString..string.format("%.0f", self.db.char.HighestMP5if)
				ldbRecord = ldbRecord..string.format("%.0f", self.db.char.HighestMP5if).." "
			end
		end
		self.strings.mp5String:SetText(mp5TempString)
		self.strings.mp5RecordString:SetText(mp5RecordTempString)
	else
		self.strings.mp5String:SetText("")
		self.strings.mp5RecordString:SetText("")
	end
	if (style.MP5auto) then
		local mp5TempString = ""
		local mp5RecordTempString = ""
		ldbString = ldbString.."|c00FFFFFF"
		if (style.labels) then
			mp5TempString = mp5TempString..L["MP5:"].." "
			ldbString = ldbString..L["MP5:"].." "
		end
		if (isInFight) then
			mp5TempString = mp5TempString..string.format("%.0f", casting).."mp5"
			ldbString = ldbString..string.format("%.0f", casting).."mp5 "
		else
			mp5TempString = mp5TempString..string.format("%.0f", base).."mp5"
			ldbString = ldbString..string.format("%.0f", base).."mp5 "
		end
		if (style.showRecords) then
			ldbRecord = ldbRecord.."|c00ffef00"
			if (style.vertical) then
				if (style.labels) then
					ldbRecord = ldbRecord..L["MP5:"].." "
				end
				if (isInFight) then
					mp5RecordTempString = mp5RecordTempString.."("..string.format("%.0f", self.db.char.HighestMP5if).."mp5)"
					ldbRecord = ldbRecord..string.format("%.0f", self.db.char.HighestMP5if).."mp5)"
				else
					mp5RecordTempString = mp5RecordTempString.."("..string.format("%.0f", self.db.char.HighestMP5).."mp5)"
					ldbRecord = ldbRecord..string.format("%.0f", self.db.char.HighestMP5).."mp5)"
				end
			else
				if (style.labels) then
					mp5RecordTempString = mp5RecordTempString..L["MP5:"].." "
					ldbRecord = ldbRecord..L["MP5:"].." "
				end
				if (isInFight) then
					mp5RecordTempString = mp5RecordTempString..string.format("%.0f", self.db.char.HighestMP5if).."mp5"
					ldbRecord = ldbRecord..string.format("%.0f", self.db.char.HighestMP5if).."mp5"
				else
					mp5RecordTempString = mp5RecordTempString..string.format("%.0f", self.db.char.HighestMP5).."mp5"
					ldbRecord = ldbRecord..string.format("%.0f", self.db.char.HighestMP5).."mp5"
				end
			end
		end
		self.strings.mp5String:SetText(mp5TempString)
		self.strings.mp5RecordString:SetText(mp5RecordTempString)
	else
		self.strings.mp5String:SetText("")
		self.strings.mp5RecordString:SetText("")
	end
	
	TCSBroker.text = ldbString.."|n"..ldbRecord.."|r"
end
