--
-- File version: 33
-- Project: 37
--
if not TinyCasterStats then return end

local L = LibStub:GetLibrary("AceLocale-3.0"):GetLocale("TinyCasterStats")
local media = LibStub:GetLibrary("LibSharedMedia-3.0")

TinyCasterStats.fonteffects = {
	["none"] = L["NONE"],
	["OUTLINE"] = L["OUTLINE"],
	["THICKOUTLINE"] = L["THICKOUTLINE"]
}

function TinyCasterStats:Options()
	local options = {
		name = "TinyCasterStats",
	    handler = TinyCasterStats,
	    type = 'group',
	    args = {
			reset = {
				name = L["Reset position"],
				desc = L["Resets the frame's position"],
				type = "execute",
				func = function() self.tcsframe:ClearAllPoints() self.tcsframe:SetPoint("CENTER", UIParent, "CENTER") end,
				disabled = function() return InCombatLockdown() end,
				order = 1
			},
			lock = {
				name = L["Lock Frame"],
				desc = L["Locks the position of the text frame"],
				type = 'toggle',
				get = function() return self.db.char.FrameLocked end,
				set = function(info, value)
					if(value) then
						self.db.char.FrameLocked = true
						self.tcsframe:SetMovable(false)
						fixed = "|cffFF0000"..L["Text is fixed. Uncheck Lock Frame in the options to move!"].."|r"
						self.tcsframe:SetScript("OnDragStart", function() DEFAULT_CHAT_FRAME:AddMessage(fixed) end)
					else
						self.db.char.FrameLocked = false
						self.tcsframe:SetMovable(true)
						self.tcsframe:SetScript("OnDragStart", function() self.tcsframe:StartMoving() end)
						self.tcsframe:SetScript("OnDragStop", function() self.tcsframe:StopMovingOrSizing() self.db.char.xPosition = self.tcsframe:GetLeft() self.db.char.yPosition = self.tcsframe:GetBottom() end)
					end
				end,
				disabled = function() return InCombatLockdown() end,
				order = 2
			},
			text = {
				name = L["Text"],
				desc = L["Text settings"],
				type = 'group',
				order = 3,
				args = {
					oocalpha = {
						name = L["Text Alpha"].." "..L["out of combat"],
						desc = L["Alpha of the text"].." ("..L["out of combat"]..")",
						width = 'full',
						type = 'range',
						min = 0,
						max = 1,
						step = 0.01,
						isPercent = true,
						get = function() return self.db.char.outOfCombatAlpha end,
						set = function(info, newValue)
							self.db.char.outOfCombatAlpha = newValue
							self.tcsframe:SetAlpha(self.db.char.outOfCombatAlpha)
						end,
						disabled = function() return InCombatLockdown() end,
						order = 1
					},
					icalpha = {
						name = L["Text Alpha"].." "..L["in combat"],
						desc = L["Alpha of the text"].." ("..L["in combat"]..")",
						width = 'full',
						type = 'range',
						min = 0,
						max = 1,
						step = 0.01,
						isPercent = true,
						get = function() return self.db.char.inCombatAlpha end,
						set = function(info, newValue)
							self.db.char.inCombatAlpha = newValue
							self.tcsframe:SetAlpha(self.db.char.inCombatAlpha)
						end,
						disabled = function() return InCombatLockdown() end,
						order = 2
					},
					barfontsize = {
						name = L["Font size"],
						width = 'full',
						type = 'range',
						min = 6,
						max = 32,
						step = 1,
						get = function() return self.db.char.Size end,
						set = function(info, newValue)
							self.db.char.Size = newValue
							local font = media:Fetch("font", self.db.char.Font)
							for k, fontObject in pairs(self.strings) do
								fontObject:SetFont(font, self.db.char.Size, self.db.char.FontEffect)
							end
						end,
						order = 3
					},
					font = {
						name = L["Font"],
						type = 'select',
						get = function() return self.db.char.Font end,
						set = function(info, newValue)
							self.db.char.Font = newValue
							local font = media:Fetch("font", self.db.char.Font)
							for k, fontObject in pairs(self.strings) do
								fontObject:SetFont(font, self.db.char.Size, self.db.char.FontEffect)
							end
						end,
						values = self.fonts,
						order = 4
					},
					fonteffect = {
						name = L["Font border"],
						type = 'select',
						get = function() return self.db.char.FontEffect end,
						set = function(info, newValue)
							self.db.char.FontEffect = newValue
							local font = media:Fetch("font", self.db.char.Font)
							for k, fontObject in pairs(self.strings) do
								fontObject:SetFont(font, self.db.char.Size, self.db.char.FontEffect)
							end
						end,
						values = self.fonteffects,
						order = 5
					},
					vertical = {
						name = L["Display stats vertically"],
						desc = L["Whether or not to show stats vertically"],
						width = 'full',
						type = 'toggle',
						get = function() return self.db.char.Style.vertical end,
						set = function(info, value)
							if(value) then
								self.db.char.Style.vertical = true
							else
								self.db.char.Style.vertical = false
							end
							self:Stats()
							self:SetTextAnchors()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 6
					},
					record = {
						name = L["Announce records"],
						desc = L["Whether or not to display a message when a record is broken"],
						type = 'toggle',
						get = function() return self.db.char.RecordMsg end,
						set = function(info, value)
							if(value) then
								self.db.char.RecordMsg = true
							else
								self.db.char.RecordMsg = false
							end
						end,
						disabled = function() return InCombatLockdown() end,
						order = 7
					},
					labels = {
						name = L["Show labels"],
						desc = L["Whether or not to show labels for each stat"],
						type = 'toggle',
						get = function() return self.db.char.Style.labels end,
						set = function(info, value)
							if(value) then
								self.db.char.Style.labels = true
							else
								self.db.char.Style.labels = false
							end
							self:Stats()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 8
					}
				}
			},
			style = {
				name = L["Stats"],
				desc = L["Select which stats to show"],
				type = 'group',
				order = 4,
				args = {
					spelldmg = {
						name = L["Spellpower"],
						desc = L["Spellpower"].." "..L["show/hide"],
						width = 'full',
						type = 'toggle',
						get = function() return self.db.char.Style.Spelldmg end,
						set = function(info, value)
							if(value) then
								self.db.char.Style.Spelldmg = true
							else
								self.db.char.Style.Spelldmg = false
							end
							self:Stats()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 1
					},
					crit = {
						name = L["Crit Chance"],
						desc = L["Crit Chance"].." "..L["show/hide"],
						width = 'full',
						type = 'toggle',
						get = function() return self.db.char.Style.Crit end,
						set = function(info, value)
							if(value) then
								self.db.char.Style.Crit = true
							else
								self.db.char.Style.Crit = false
							end
							self:Stats()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 2
					},
					hit = {
						name = L["Hit Rate"],
						desc = L["Hit Rate"].." "..L["show/hide"],
						width = 'full',
						type = 'toggle',
						get = function() return self.db.char.Style.Hit end,
						set = function(info, value)
							if(value) then
								self.db.char.Style.Hit = true
							else
								self.db.char.Style.Hit = false
							end
							self:Stats()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 3
					},
					haste = {
						name = L["Haste Rating"],
						desc = L["Haste Rating"].." "..L["show/hide"].."\n"..L["(Only rating or percentage display possible!)"],
						width = 'full',
						type = 'toggle',
						get = function() return self.db.char.Style.Haste end,
						set = function(info, value)
							if(value) then
								self.db.char.Style.Haste = true
								self.db.char.Style.HastePerc = false
							else
								self.db.char.Style.Haste = false
							end
							self:Stats()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 4
					},
					hasteperc = {
						name = L["Percent Haste"],
						desc = L["Percent Haste"].." "..L["show/hide"].."\n"..L["(Only rating or percentage display possible!)"],
						width = 'full',
						type = 'toggle',
						get = function() return self.db.char.Style.HastePerc end,
						set = function(info, value)
							if(value) then
								self.db.char.Style.HastePerc = true
								self.db.char.Style.Haste = false
							else
								self.db.char.Style.HastePerc = false
							end
							self:Stats()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 5
					},
					mp5 = {
						name = L["Mana Regeneration"].." "..L["out of combat"],
						desc = L["Mana Regeneration"].." "..L["out of combat"].." "..L["show/hide"],
						width = 'full',
						type = 'toggle',
						get = function() return self.db.char.Style.MP5 end,
						set = function(info, value)
							if(value) then
								self.db.char.Style.MP5 = true
								self.db.char.Style.MP5auto = false
							else
								self.db.char.Style.MP5 = false
							end
							self:Stats()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 6
					},
					mp5ic = {
						name = L["Mana Regeneration"].." "..L["in combat"],
						desc = L["Mana Regeneration"].." "..L["in combat"].." "..L["show/hide"],
						width = 'full',
						type = 'toggle',
						get = function() return self.db.char.Style.MP5ic end,
						set = function(info, value)
							if(value) then
								self.db.char.Style.MP5ic = true
								self.db.char.Style.MP5auto = false
							else
								self.db.char.Style.MP5ic = false
							end
							self:Stats()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 7
					},
					mp5auto = {
						name = L["Mana Regeneration"].." ("..L["automatic"]..")",
						desc = L["Automatically selects which mana regeneration to show"],
						width = 'full',
						type = 'toggle',
						get = function() return self.db.char.Style.MP5auto end,
						set = function(info, value)
							if(value) then
								self.db.char.Style.MP5 = false
								self.db.char.Style.MP5ic = false
								self.db.char.Style.MP5auto = true
							else
								self.db.char.Style.MP5auto = false
							end
							self:Stats()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 8
					},
					split = {
						name = "",
						type = 'header',
						order = 9
					},
					showrecords = {
						name = L["Show records"],
						desc = L["Whether or not to show record values"],
						width = 'full',
						type = 'toggle',
						get = function() return self.db.char.Style.showRecords end,
						set = function(info, value)
							if(value) then
								self.db.char.Style.showRecords = true
							else
								self.db.char.Style.showRecords = false
							end
							self:Stats()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 10
					},
					resetrecords = {
						name = L["Reset records"],
						desc = L["Clears your current records"],
						type = 'execute',
						func = function()
							self.db.char.HighestSpelldmg = 0
							self.db.char.HighestCrit = 0
							self.db.char.HighestHaste = 0
							self.db.char.HighestHastePerc = 0
							self.db.char.HighestHit = 0
							self.db.char.HighestMP5if = 0
							self.db.char.HighestMP5 = 0
							self:Stats()
						end,
						disabled = function() return InCombatLockdown() end,
						order = 11
					}
				}
			}
		}
	}
	return options
end
