﻿if KarmaStub:isLib("LibKarmaAce", 1.1, "$Revision: 68 $") then return end

--[[
	Simple integrated automated lightweight support for other basic desparate libraries and systems
			
	Notes:
	
		This is primarily a way to hobble together rock, ace2, ace3, minimap, fubar, ldb, titan, and
		others in a	way where the addon can be blissfully unaware. Either rely on any or none of these
		facilities being available and get at worst case a native minimap icon with a right-click menu.
		This is really a lot of functionality in a pretty small space...
		
	High level table structure (yes confusing):

		LibKarma			-- global LK (LibKarma) instance
			[funcs]			-- global LK functions
		LibKarmaAce			-- global LKA (LibKarmaAce) instance
			[funcs]			-- global LKA functions
			_acelib			-- global LKA data (aka _instG)
		[appinst]			-- instance for the addon (aka inst), inherits LibKarma and LibKarmaUtil, but not LibKarmaAce
			_acelib			-- instance LKA data (aka _inst), inherits LibKarmaAce._acelib
				instance	-- instance Ace3 "instance" or stub table (aka _inst.instance), lowers name conflicts rather than using _acelib or _inst
					[funcs]	-- instance Ace3 and other funcs and stubs, and selectively referenced LibKarmaAce.[funcs] (based on what libs are available at startup)
					_karma	-- instance reference back to [appinst](aka inst), so that LibKarmaAce funcs can find home
					
		More detail:
		[global]._acelib 	-- (aka _instG)
			locale			-- locale data and base functions
			defaults		-- misc global defaults 
			lib				-- lib stub references, ones discovered (ala LibStub etc...)
			base			-- lib stub instances, ones that support or would work as one global shared instance (for LKA purposes)
			
		[inst]._acelib		-- (aka _inst)
			db				-- KLA specific DB, used to support Ace and others that need Ace/Rock style db, separate from the KL DB
			locale			-- locale data and base functions
			L,LR			-- combined locale normal and reverse lookuptables
			instance		-- the Ace3 real (or mockup) instance (is where all the splicing and things come together)
			menu			-- the base default menu used by the various UI libraries to produce right-click menus
]]--

LibKarmaAce = LibKarmaAce or  {

}


function LibKarmaAce:LoadLocales( frame, inst, locale, L )

	L["Help"] = true
	L["Show Help"] = true
	L["Main Window"] = true
	L["Show Main Window"] = true
	L["Options"] = true
	L["Show Options"] = true
	L["Item Options"] = true
	L["Show Item Options"] = true
	L.ADDON_TOOLTIP = "|cffeda55fClick|r to open main window, |cffeda55fShift-click|r to open options."

	-- already localized
	L["Join"] = JOIN
	L["Leave"] = CHAT_LEAVE

	if locale == "esMX" then
--		L["Help"] = "Spanish"
	end

	-- inst:DebugTable("LibKarmaAce:LoadLocales", locale, L:GetLocale(Name,true))
end

function LibKarmaAce:OnAddonLoaded( frame, inst )
	
	-- global
	self._acelib = self._acelib or {
		locale = {
			mt = {	__newindex = function( t, k, v ) if t[1] then t[1][k] = v end; end,
					__index = function( t, k ) if not k then return end
						local _,_,c,s,r,f = string.find(k, "^(|c%x%x%x%x%x%x%x%x)(.-)(|r)$")
						if c then k,s = s,k end
						for i, v in pairs(t) do
							v = (v and type(i) == "number") and v[k]; f = f or v
							if v and (i==1 or v~=k) then
								return c and (c..v..r) or v
							end
						end
						if not f and t[1] then t[1][k] = k end;			-- store capture
						return c and s or (f or k);						-- return cross checked value or defaults
					end, },
			proxy	= {	__newindex = function( t, k, v ) rawset(t[1],k,v==true and k or v) end,	__index = function( t, k ) return rawget(t[1],k); end, },
			proxyr	= { __newindex = function( t, k, v ) end, __index = function( t, k ) for i, v in pairs(t[1]) do if v==k then return i end end end, },
			format  = function( t, s, ... ) return s and string.format(t[s], ...) end,
		},
		defaults = {
			profile = { minimap = { show = 1, position = 225, }, },
			global = { LCapture = { [inst._meta.locale]={} }, LCaptureR = { [inst._meta.locale]={} }, },
		}
	}

	-- instance
	inst._acelib = {
		name	= inst._instance.name.."Ace",
		nameDB	= inst._instance.name.."AceDB",
		nameLDB = inst._instance.name.."AceLDB",
		locale	= { },
	}
	setmetatable( inst._acelib, { __index = self._acelib } )
end


do
	LoadAddOn("Ace3")
	LoadAddOn("Dewdrop-2.0")
	LoadAddOn("LibRock-1.0")
	LoadAddOn("LibBabble-Zone-3.0")
	LoadAddOn("LibBabble-Boss-3.0")
	LoadAddOn("LibBabble-Class-3.0")
	LoadAddOn("LibBabble-Inventory-3.0")
	LoadAddOn("LibBabble-CreatureType-3.0")
	LoadAddOn("LibFuBarPlugin-3.0")
	LoadAddOn("LibDataBroker-1.1")
end

function LibKarmaAce:OnPlayerLogin( frame, inst )
	local _instG, _inst = self._acelib, inst._acelib

	-- --------- relies on old variables_loaded ----------

	-- global (get lib references)
	local LibStub = LibStub
	if not _instG.lib then
		_instG.lib = {
			L	= LibStub and LibStub("AceLocale-3.0", true),
			LZ	= LibStub and LibStub("LibBabble-Zone-3.0", true),
			LB	= LibStub and LibStub("LibBabble-Boss-3.0", true),
			LC	= LibStub and LibStub("LibBabble-Class-3.0", true),
			LI	= LibStub and LibStub("LibBabble-Inventory-3.0", true),
			LT	= LibStub and LibStub("LibBabble-CreatureType-3.0", true),
			fu	= LibStub and LibStub("LibFuBarPlugin-3.0", true),
			al	= AceLibrary,
			aao	= LibStub and LibStub("AceAddon-3.0", true),
			ac	= LibStub and LibStub("AceConsole-3.0", true),
			db	= LibStub and LibStub("AceDB-3.0", true),
			dd	= LibStub and LibStub("AceDB-3.0", true),
			ldb	= LibStub and LibStub("LibDataBroker-1.1", true),
			aaoembed = { },
		}
		if _instG.lib.ac then tinsert(_instG.lib.aaoembed, "AceConsole-3.0") end
	end
	local _LG, _lib = _instG.locale, _instG.lib

	-- global (get instances)
	if not _LG.base then
		_LG.base	= setmetatable({ {}, }, _LG.proxy)
		_LG.zone	= _lib.LZ	and inst:SafeCall(_lib.LZ.GetUnstrictLookupTable, _lib.LZ)
		_LG.boss	= _lib.LB	and inst:SafeCall(_lib.LB.GetUnstrictLookupTable, _lib.LB)
		_LG.class	= _lib.LC	and inst:SafeCall(_lib.LC.GetUnstrictLookupTable, _lib.LC)
		_LG.inv		= _lib.LI	and inst:SafeCall(_lib.LI.GetUnstrictLookupTable, _lib.LI)
		_LG.ctype	= _lib.LT	and inst:SafeCall(_lib.LT.GetUnstrictLookupTable, _lib.LT)
		_LG.baseR	= setmetatable({ _LG.base[1], }, _LG.proxyr)
		_LG.zoneR	= _lib.LZ	and inst:SafeCall(_lib.LZ.GetReverseLookupTable, _lib.LZ)
		_LG.bossR	= _lib.LB	and inst:SafeCall(_lib.LB.GetReverseLookupTable, _lib.LB)
		_LG.classR	= _lib.LC	and inst:SafeCall(_lib.LC.GetReverseLookupTable, _lib.LC)
		_LG.invR	= _lib.LI	and inst:SafeCall(_lib.LI.GetReverseLookupTable, _lib.LI)
		_LG.ctypeR	= _lib.LT	and inst:SafeCall(_lib.LT.GetReverseLookupTable, _lib.LT)
	end
	_lib.dd			= _lib.al	and (_lib.al:HasInstance("Dewdrop-2.0") and _lib.al("Dewdrop-2.0"))	


	-- instance (get db and loc instances)
	local _L = _inst.locale
	_inst.db	= _lib.db and _lib.db:New(_inst.nameDB, _inst.defaults) or inst:_GetDB(nil, _inst.nameDB, _inst.defaults, true)
	_L.capture	= inst._meta.lcapture and _inst.db.global.LCapture[inst._meta.locale] or { }
	_L.captureR	= inst._meta.lcapture and _inst.db.global.LCaptureR[inst._meta.locale] or { }
	_L.inst		= setmetatable({_lib.L and _lib.L:GetLocale(inst._instance.name, true) or {}}, _LG.proxy)
	_L.instR	= setmetatable({_L.inst[1]}, _LG.proxyr)
	_inst.LR	= setmetatable({_L.captureR,_LG.zoneR,_LG.bossR,_LG.classR,_LG.invR,_LG.ctypeR,_L.instR,_LG.baseR, F=_LG.format,}, _LG.mt)
	_inst.L		= setmetatable({_L.capture,_LG.zone,_LG.boss,_LG.class,_LG.inv,_LG.ctype,_L.inst,_LG.base, S=_L.inst, F=_LG.format, R=_inst.LR,}, _LG.mt)

	-- instance (load LK locale strings)
	self:LoadLocales( frame, inst, inst._meta.locale, _LG.base )


	-- --------- relies on player_login ----------
	
	-- instance...
	_inst.instance	= _inst.lib.aao and _inst.lib.aao:NewAddon(_inst.name, unpack(_inst.lib.aaoembed)) or { }
	_inst.menufunc	= function(value) _inst.instance:ExecChatCommandAce(value) end
	_inst.menu  = { handler = _inst.instance, type = "group", args = {
			main	= {	type = "execute", order = 10, name = _inst.L["Main Window"], desc = _inst.L["Show Main Window"],
						passValue = nil, func = _inst.menufunc,														},
			options	= {	type = "execute", order = 10, name = _inst.L["Options"], desc = _inst.L["Show Options"],
						passValue = "options", func = _inst.menufunc,												},
			help	= {	type = "execute", order = 20, name = _inst.L["Help"], desc = _inst.L["Show Help"],
						passValue = "help", func = _inst.menufunc,													},
			hide	= {	type = "toggle",  order = -3,  name = _inst.L["Hide minimap icon"], desc = _inst.L["Hide Icon"],
						get = function() return _inst.db.profile.minimap.show ~= 1 end,
						passValue = "hide", set = _inst.menufunc,													}, }, }

	if _inst.instance then											-- ace
		_inst.instance._karma				= inst
		_inst.instance._L					= _inst.L
		_inst.instance.db					= _inst.db
		_inst.instance.icon					= inst._meta.icon
		_inst.instance.title				= inst._meta.title
		_inst.instance.lable				= inst._meta.title
		_inst.instance.version				= inst._meta.version
		_inst.instance.ExecChatCommandAce	= LibKarmaAce.ExecChatCommandAce
		_inst.instance.ExecMenuCommandAce	= LibKarmaAce.ExecMenuCommandAce
		_inst.instance.OnShowMenuAce		= LibKarmaAce.OnShowMenuAce
		_inst.instance.OnMenuRequest		= _inst.menu
		_inst.instance.OnCommandAce			= LibKarmaAce.OnCommandAce
		_inst.instance.OnInitialize			= LibKarmaAce.OnInitialize
		_inst.instance.OnUpdateFuBarTooltip	= LibKarmaAce.OnUpdateFuBarTooltip
		_inst.instance.OnFuBarClick			= LibKarmaAce.OnFuBarClick
		_inst.instance.OnTooltipShow		= function(frame) _inst.instance:OnUpdateFuBarTooltip(frame) end
		_inst.instance.OnClick				= function(frame,button) LibKarmaAce.OnClick(_inst.instance, frame, button) end
	end
	if _inst.lib.ldb then											-- libdatabroker
		_inst.instance.type					= "launcher"
		_G[_inst.nameLDB]					= _inst.lib.ldb:NewDataObject(_inst.instance.title, _inst.instance)
	end
	if _inst.lib.fu and _inst.lib.aao then							-- fubar via ace
		_inst.lib.aao:EmbedLibrary(_inst.instance, "LibFuBarPlugin-3.0", true)
		_inst.instance:SetFuBarOption("hasIcon", true)
		_inst.instance:SetFuBarOption("iconPath", _inst.instance.icon)
		_inst.instance:SetFuBarOption("hasNoColor", true)
		_inst.instance:SetFuBarOption("hideMenuTitle", true)
		_inst.instance:SetFuBarOption("independentProfile", true)
		_inst.instance:SetFuBarOption("clickableTooltip", true)
		_inst.instance:SetFuBarOption("cannotDetachTooltip", true)
		_inst.instance:SetFuBarOption("hideWithoutStandby", true)
		_inst.instance:SetFuBarOption("defaultPosition", "CENTER")
		_inst.instance:SetFuBarOption("configType", "Dewdrop-2.0")
	end	
	if not _inst.lib.fu then										-- no fubar, make our own minimap icon and add menu options
		_inst.instance.Hide = LibKarmaAce.Hide
		_inst.instance.Show = LibKarmaAce.Show
		_inst.minimap = LibKarmaUI:GenerateMinimapButton( frame, _inst.instance, _inst.db.profile.minimap )
		_inst.minimap:Reposition()
	end
	if not _inst.lib.aao and _inst.instance.OnInitialize then _inst.instance:OnInitialize()	end
	if CT_RegisterMod then											-- ct mod and related
		CT_RegisterMod(inst._meta.title, "Display window", 5, self._meta.icon,
			self._meta.desc, "switch", _inst.instance, function(self) self:ExecChatCommandAce() end )
	end
end


function LibKarmaAce:ExecMenuCommandAce( t )
	local _args = self._karma._acelib.menu.args
	t = ((type(t) == "string") and _args[t] or t) or _args.main
	if not t or type(t) ~= "table" then return end
	if t.type == "execute" then
		return self._karma:SafeCall(t.func, t.passValue)
	end
end

function LibKarmaAce:ExecChatCommandAce( cmd )
	local func = SlashCmdList[strupper(self._karma._instance.name)]
	if func then self._karma:SafeCall(func, cmd or "") end	
end

function LibKarmaAce:OnCommandAce( msg, cmd, args )
	local _inst = self._karma._acelib
	if cmd == "hide" then
		local isShown = ((_inst.lib.fu and _inst.lib.aao) and self:GetFrame():IsShown()) or (_inst.minimap and _inst.minimap:IsVisible())
		if not isShown then	self:Show()	else self:Hide() end
		return true
	elseif cmd == "help" then
		self._karma:Print((self._karma._meta.slash or ("/" .. self._karma._meta.short)) .. " hide - Hides the icon.")
	end
end

function LibKarmaAce:OnShowMenuAce( frame )
	local _lib,_menu = self._karma._acelib.lib,self.OnMenuRequest
	if not _menu then return end	
	if type(_menu) == "table" then 
		if _lib.dd then _lib.dd:Open(frame, "children", function() _lib.dd:FeedAceOptionsTable(_menu) end) end
	elseif type(_menu) == "function" then
		self._karma:SafeCall(_menu)
	end
end

function LibKarmaAce:Hide()
	local _inst = self._karma._acelib
	_inst.minimap:Hide()
end

function LibKarmaAce:Show()
	local _inst = self._karma._acelib
	_inst.minimap:Show()
end

function LibKarmaAce:OnUpdateFuBarTooltip(f)
	f = f or GameTooltip
	f:AddLine(self._L[self.title]);
	f:AddLine(self._L["ADDON_TOOLTIP"], 0.2, 1, 0.2, 1);
end

function LibKarmaAce:OnFuBarClick(button)
	if button == "LeftButton" then self:ExecMenuCommandAce( IsShiftKeyDown() and "options" ) end
end

function LibKarmaAce:OnClick(frame,button)
	if button == "RightButton" then	self:OnShowMenuAce(frame) end
	self:OnFuBarClick(button)
end

function LibKarmaAce:OnInitialize( )
	local _inst = self._karma._acelib
	if _inst.menu and _inst.lib.fu and _inst.lib.aao then
		self._karma:ArgsToTable(_inst.menu.args, _inst.lib.fu:GetEmbedRockConfigOptions(_inst.instance))
		for i, v in pairs (_inst.menu.args) do
			if v.type == "boolean" then v.type = "toggle" end
			if v.type == "choice" then v.type = "text" end
			if v.choices then v.validate = v.choices end
			if i == "hide" then v.name = "Hide" end
		end
	end
end
