﻿
TT_Button = LibKarmaUI:GetInstance( TellTrack, {
	addItemInfo = { func = nil, value = { }, },
	funcMenuOnClick	= function( frame ) TT_Button:Menu_OnClick(frame) end,
})

function TT_Button:ToggleValue(name, v)
	local tt = TellTrack
	local o = tt._options
	tt:Debug("TT_Button:ToggleValue", name, v, old, new )

	local type = TellTrack_cmdlist[name]
	name = type and type.var
	if not name then return end
	local old = o[name]
	v = (v=="on" or v=="1" or v==1) and 1 or ((v=="off" or v=="0" or v==0) and 0 or ((old==1) and 0 or 1))
	
	if old ~= v then
		o[name] = v
		if name~="Enable" and type[v] then tt:Print(type[v]) end
		return true
	end
	return false
end
	
function TT_Button:OnAction( frame, _type, value )
	local tt = TellTrack
	local o = tt._options
	_type = _type or (frame and frame._type); value = value or (frame and frame._value)
	
	local changed = self:ToggleValue(_type, value)
	
	if _type == "enable" then
		if o.Enable == 0 then
			TellTrackFrame:Hide()
		else
			TellTrackFrame:Show()
		end
	elseif _type == "info" then
		tt:Print_Help()
	elseif _type == "invert" then
		if changed then
			tt:ChangeArrayOffset((o.ListInvert == 1) and o.ListSize or 1)
			tt:UpdateTellTrackButtonsText()
		end
	elseif _type == "hidewhispers" then
		if o.HideWhispers == 1 then
			tt:HideWhispersInOtherFrames()
		end
	elseif _type == "timestamps" then
		tt:RedrawWhisperFrame()
	elseif _type == "clearall" then
		local db = tt._db
		tt._list = { }; db.Log[o.ListProfile] = tt._list
		tt:UpdateTellTrackButtonsText()
	elseif _type == "border" then
		self:UpdateBorderVisibility()
	elseif _type == "linenums" then
		tt:UpdateTellTrackButtonsText()
	elseif _type == "showall" then
		tt:ShowConversationWith(tt._current.name, true)
	elseif _type == "createchatf" then
		tt:CreateWhisperChatFrame()
	elseif _type == "whisper" then
		local item = value and tt._list[value]
		if not item then return false end
		tt:InitiateWhisperToTarget(item.name)
	elseif _type == "whisperlast" then
		if not o.LastTell then return false end
		tt:InitiateWhisperToTarget(o.LastTell)
	elseif _type == "showconv" then
		local item = value and tt._list[value]
		if not item then return false end
		tt:ShowConversationWith(item.name, false)
	elseif _type == "who" then
		local item = value and tt._list[value]
		if not item then return false end
		SendWho("n-\""..item.dispName.."\"")
	elseif _type == "invite" then
		local item = value and tt._list[value]
		if not item then return false end
		InviteUnit(item.name)
	elseif _type == "addfriend" then
		local item = value and tt._list[value]
		if not item then return false end
		AddFriend(item.name)
	elseif _type == "delete" then
		local item = value and tt._list[value]
		if not item then return false end
		tremove(tt._list, value)
		tt:UpdateTellTrackButtonsText()
	elseif TellTrack_cmdlist[_type]~=nil then
		return true									-- handled even if no code
	else
		return false								-- not handled
	end
	
	return true										-- handled in the list
end


-- ************** menus **************

function TT_Button:Menu_OnClick( frame )
	local v = frame.value
	if not v then return end
--	TellTrack:DebugTable("TT_Button:Menu_OnClick", v, frame:GetName(), v.parent )
	if v.frameName then
--		RT_Dialog:Show(v.frameName, v.type, v.what, v.raidid, v.itemid, v.playerid, v.zone, v.boss)
	else
		self:OnAction(v.parent, v.type, v.value)
		HideDropDownMenu(2)
	end
end

function TT_LineTemplate_RightClickMenu_Initialize( frame, level )
	if not level then return end
	local parent = frame._parent or frame:GetParent()
	local ttb = TT_Button
	local inst = ttb._karma

	ttb._rcmenu = ttb._rcmenu or {
		{ text = "   " .. inst.L["Tell Track"], isTitle = 1, },
		{ type = "whisper",		text = TT_MENU_WHISPER, field = "playerid", },
		{ type = "showconv",	text = TT_MENU_SHOWCONV, field = "playerid", },
		{ type = "who",			text = TT_MENU_WHO, field = "playerid", },
		{ type = "invite",		text = TT_MENU_GRPINV, field = "playerid", },
		{ type = "addfriend",	text = TT_MENU_ADDFRIEND, field = "playerid", },
		{ type = "delete",		text = TT_MENU_DELETE, field = "playerid", },
		{ text = "|cffcccccc--------------|r", disabled = 1, notClickable = 1, },
		{ type = "clearall",	text = TT_MENU_DELETE_ALL, },
		{ type = "invert",		text = TT_MENU_INVERT, },
		{ type = "showall",		text = TT_MENU_SHOWWHISPERS, },
		{ type = "createchatf",	text = TT_MENU_CREATEFRAME, },
		{ type = "border",		text = TT_HELP_BORDER, },		
		{ type = "linenums",	text = TT_HELP_LINENUMS, },		
		{ text = "", disabled = 1, notClickable = 1, },
		{ text = TT_MENU_CANCEL, func = function() end, },
	}
	for i,v in pairs(ttb._rcmenu) do
		v.func = v.func or ttb.funcMenuOnClick
		v.value = v.value or { }
		v.value.type = v.type
		v.value.value = v.val or ((v.field~=nil and parent) and parent[v.field])
		UIDropDownMenu_AddButton(v)
	end
end


-- ************** buttons **************

function TT_Button:OnClick( frame, button )
	local parent = frame._parent or frame:GetParent()
	if self._super.OnClick( self, frame, button ) then return true end
	
	local o = self._karma._options

	if frame.type == "player" then
		TellTrack:TextButton_OnClick(frame, button)
	elseif frame.type == "arrow" then
		local isUp = (frame.what == "up")
		if button == "RightButton" then
			TellTrack:ChangeArrayOffset( isUp and 1 or o.ListSize )
		elseif button == "LeftButton" then
			TellTrack:ChangeArrayOffset( o.ListOffset + (TellTrackFrame.ButtonCount * (isUp and -1 or 1)) )
		else
			return
		end
		TellTrack:UpdateTellTrackButtonsText()
	elseif frame.type == "qbutton" then
		self:OnAction(frame, "info")
	end
end

function TellTrack:TextButton_OnClick(frame, button)
--	TellTrack:DebugTable("TT_Button:OnEnter", frame:GetName(), frame )
	if not frame.item then return end
	if button == "LeftButton" then
		if (IsShiftKeyDown() and IsAltKeyDown()) then
			TT_Button:OnAction(frame, "delete", frame.playerid)
		elseif (IsShiftKeyDown()) then
			TT_Button:OnAction(frame, "who", frame.playerid)
		elseif (IsAltKeyDown()) then
			TT_Button:OnAction(frame, "invite", frame.playerid)
		elseif (IsControlKeyDown()) then
			TT_Button:OnAction(frame, "addfriend", frame.playerid)
		else
			local name = frame.item.name
			local eb = SELECTED_DOCK_FRAME.editBox
			if (self._options.WhisperFirst == 1) then
				if (eb:IsVisible()) and (eb:GetAttribute("chatType") == "WHISPER") and (strlower(eb:GetAttribute("tellTarget")) == strlower(name)) then
					self:ShowConversationWith(name, false)
				else
					self:InitiateWhisperToTarget(name)
				end
			else
				if (SELECTED_DOCK_FRAME == getglobal(self._chat.frame)) and (strlower(self._current.name) == strlower(name)) then
					self:InitiateWhisperToTarget(name)
				else
					self:ShowConversationWith(name, false)
				end
			end
		end
	end
end


function TT_Button:OnEnter( frame )
	local parent = frame._parent or frame:GetParent()
	local title, text, f
--	TellTrack:DebugTable("TT_Button:OnEnter", frame:GetName(), frame )
	
--	TellTrack:SetBorderVisibility( 1 )
--	f = getglobal(parent:GetParent():GetName().."Tab")
--	if f then f:Show() end

	self._super.OnEnter(self, frame, title, text, true )
end


function TT_Button:OnLeave( frame )
	parent = parent or frame:GetParent()
	local f
	
--	TellTrack:SetBorderVisibility( 0 )
--	f = getglobal(parent:GetParent():GetName().."Tab")
--	if f then f:Hide() end

	self._super.OnLeave(self, frame)
end

function TellTrack:ChangeArrayOffset(offset)
	local o = self._options
--	self:Debug("ChangeArrayOffset",offset)
	if offset <= 0 then												-- lower bounds
		offset = 1
	end
	local capSize = o.ListSize - TellTrackFrame.ButtonCount + 1		-- upper bounds
	if offset > capSize then
		offset = capSize
	end
	o.ListOffset = offset
end

function TT_Button:OnMouseWheel(frame, v)
	local tt = TellTrack
	local o,list = tt._options,tt._list

	local v = v < 0 and 1 or (v > 0 and -1 or 0)
	tt:ChangeArrayOffset(o.ListOffset -  v)
	tt:UpdateTellTrackButtonsText()
end

function TT_Button:OnSizeChanged( frame )
	local parent = frame._parent or frame:GetParent()
	local fname = frame and frame:GetName()
	
	local tt = TellTrack
	local o,list = tt._options,tt._list	
	if not fname or not list then return end				-- onsizechange can fire before tt is initialized

	if frame.type == "mainframe" then		
		local height = frame:GetHeight() - 44				-- insets and arrow buttons
		local count = floor(height / 20)
		frame.ButtonCount = frame.ButtonCount or 0
		
		if count ~= frame.ButtonCount then
			local max, id = o.ListSize, #list
			local oh = frame.ButtonCount - id; oh = (oh < 0) and 0 or oh;
			if o.ListInvert ~= 1 then
				o.ListOffset = (o.ListOffset + (frame.ButtonCount - count)) - oh;
			else
				o.ListOffset = id + oh
			end
			tt:ChangeArrayOffset(o.ListOffset)

			frame.ButtonCount = count
			for i=1, o.ListSize do
				local sline = "TellTrack"..i
				local line = getglobal(sline)
				if i > frame.ButtonCount then line:Hide() else line:Show() end
			end
			tt:UpdateTellTrackButtonsText()
		end

		local offset = floor((height - (count * 20) + 20) / 2)
		TellTrackFrameArrowUpButton:SetHeight(offset)
		TellTrackFrameArrowDownButton:SetHeight(offset)
	end
end


function TT_Button:UpdateBorderVisibility()
	if TellTrack._options.Border == 1 then
		TellTrackFrameBackground:Hide()
		TellTrackFrameArrowUpButton:Hide()
		TellTrackFrameArrowDownButton:Hide()
		TellTrackFrame:SetHitRectInsets(10, 10, 10+TellTrackFrameArrowUpButton:GetHeight(), 10+TellTrackFrameArrowDownButton:GetHeight())
	else
		TellTrackFrameBackground:Show()
		TellTrackFrameArrowUpButton:Show()
		TellTrackFrameArrowDownButton:Show()
		TellTrackFrame:SetHitRectInsets(0, 0, 0, 0)
	end
end
