--[[
	Allows you to keep track of people you have had whisper conversations with.
]]

-- Variables
local TellTrack_WhisperMessages = { }
local TellTrack_OfflinePlayers = { }

-- hooked funtions
local SavedSendChatMessage = nil
local SavedFCF_SelectDockFrame = nil
local SavedChatFrame_OpenChat = nil
local SavedFCF_Close = nil
local SavedFCF_OpenNewWindow = nil

SELECTED_CHAT_FRAME = DEFAULT_CHAT_FRAME
-- executed on load, calls general set-up functions
function TellTrack:OnLoadCustom( frame )
	self:AddSlashCommand( nil, "/ttrack" )
	SlashCmdList["TELLTRACKRETELL"] = TellTrack_WhisperToPreviousTarget
	self:AddSlashCommand( "RETELL", "/retell", true )
	self:AddSlashCommand( "RETELL", "/re" )
end

function TellTrack:OnPlayerLogin( frame )
	-- these should definately not fire until setup is complete (after player_login)
	frame:RegisterEvent("PLAYER_ENTERING_WORLD")
	frame:RegisterEvent("CHAT_MSG_WHISPER")
	frame:RegisterEvent("CHAT_MSG_WHISPER_INFORM")
	frame:RegisterEvent("CHAT_MSG_SYSTEM")	

	local db,o = self._db,self._options
	local _inst = self._acelib
	self.L = _inst.L
	self.LR = _inst.LR
	
	-- init vars	
	o.Realm,o.Race,o.Player,o.Faction = GetCVar("realmName"),UnitRace("player"),(UnitName("Player")),"Alliance" 
	for k,v in pairs({"Orc","Tauren","Troll","Undead"}) do if o.Race == v then o.Faction = "Horde"; break; end end
	o.ListProfile = o.Realm .. " - " .. o.Faction
	o.PlayerProfile = o.Player .. " - " .. o.Realm

	-- curent conversation
	self._current = { name = "", showAll = true, }

	-- load frame list
	self._chat = db.Chat[o.PlayerProfile] or { }
	db.Chat[o.PlayerProfile] = self._chat
	
	-- load player list
	if o.ListSave ~= 1 then db.Log = { } end
	self._list = db.Log[o.ListProfile] or { }
	db.Log[o.ListProfile] = self._list
	
	-- update cmds and menus
	if _inst and _inst.menu then			-- remove default help option
		_inst.menu.args.help.passValue = "info"
		_inst.menu.args.options.passValue = "help"
	end

	-- hook blizz chat functions
	if SendChatMessage ~= SavedSendChatMessage then							-- Hook the chat event handler 'before'
		SavedSendChatMessage = SendChatMessage
		SendChatMessage = TellTrack_SendChatMessage
	end
	if FCF_SelectDockFrame ~= TellTrack_FCF_SelectDockFrame then			-- Hook dock frame selection 'after'
		SavedFCF_SelectDockFrame = FCF_SelectDockFrame
		FCF_SelectDockFrame = TellTrack_FCF_SelectDockFrame
	end
	if ChatFrame_OpenChat ~= TellTrack_ChatFrame_OpenChat then				-- Hook open chat to open as whisper
		SavedChatFrame_OpenChat = ChatFrame_OpenChat
		ChatFrame_OpenChat = TellTrack_ChatFrame_OpenChat
	end
	if FCF_Close ~= TellTrack_FCF_Close then								-- Hook open chat to open as whisper
		SavedFCF_Close = FCF_Close
		FCF_Close = TellTrack_FCF_Close
	end
	if FCF_OpenNewWindow ~= TellTrack_FCF_OpenNewWindow then				-- Hook open chat to open as whisper
		SavedFCF_OpenNewWindow = FCF_OpenNewWindow
		FCF_OpenNewWindow = TellTrack_FCF_OpenNewWindow
	end

	-- tweak ui	
--	getglobal(frame:GetName() .. "HeaderIcon"):SetTexture( self._meta.icon )
--	getglobal(frame:GetName() .. "HeaderTitle"):SetText( self._meta.title )
--	getglobal(frame:GetName() .. "HeaderVersion"):SetText( self._options.Color .. "v" .. self._meta.version )  -- .. " "..self._meta.locale.."|r" )
	TT_Button:OnAction(nil, "enable", o.Enable)
	TT_Button:OnSizeChanged( TellTrackFrame )
	TT_Button:UpdateBorderVisibility()
end


function TellTrack:OnCommandCustom( msg, cmd, args )
	local o = self._options
	if not cmd then
		TT_Button:OnAction(nil, "enable")
		return true
	elseif TT_Button:OnAction(nil, cmd, args) then
		return true
	elseif cmd == "help" then
		self:Print(TT_CHAT_USEAGE)
		local list = TellTrack_cmdlist
		for k,v in pairs(list) do
			self:Print("/"..self._meta.short.." "..k.." - ".. v.help)
		end
	end
end

function TellTrack:Print_Help()
	self:Print(TT_CHAT_INFO)
	self:Print(TT_CHAT_INFO1)
	self:Print(TT_CHAT_INFO2)
	self:Print(TT_CHAT_INFO3)
end


function TellTrack_WhisperToPreviousTarget(msg)
	local o = TellTrack._options
	if not o.LastTell then return end
	SendChatMessage(msg, "WHISPER", o.LastLang, o.LastTell)
end


-- Handles events
function TellTrack:OnEventCustom(frame, event, ...)
	local ar1, ar2, ar3, ar4, ar5, ar6 = select(1, ...)
	if event == "CHAT_MSG_WHISPER" or event == "CHAT_MSG_WHISPER_INFORM" then
		self:HookAllAddMessages()
		if type(ar1) ~= "string" then return end
		 
		--Special Hidden Whisper Ignores
		local len = ar1:len()
        if Guilded and len > 2 and ar1:sub(1,2) == "<G" and (len ~= 4 or ar1:sub(1,4) ~= "<GM>") then return	--Hide Guilded messages
		elseif GuildAds and len > 3 and ar1:sub(1,3) == "<GA" then return					--Hide GuildAds messages
		elseif len > 3 and ar1:sub(1,3) == "<T>" then return							--Hide Telepathy messages
        elseif len > 1 and ar1:sub(1,1) == "/" then return								--Hide AceComm messages
        elseif len > 7 and ar1:sub(1,7) == "SKP1019" then return						--Hide SKP messages
		end 
		
		if event == "CHAT_MSG_WHISPER" then
			self:HandleMessageSentOrRecieved(ar2, false)
		end
        if ar2 then
            TellTrack_OfflinePlayers[ar2] = nil
        end
		
		local etype = string.sub(event,10)
		local message = gsub(ar1, "%%", "%%%%")
--		self:Debug("TellTrack:OnEventCustom", "type",etype, "tag",ar6, "name",ar2, "msg",message, "time",self:GetTime(nil, self._update.timediff))
		tinsert(TellTrack_WhisperMessages, {type=etype, tag=ar6, name=ar2, msg=message, time=self:GetTime(nil, self._update.timediff)})
		
	elseif event == "CHAT_MSG_SYSTEM" then
		if not ar1 then return end
		local _, _, name = strfind(ar1, TT_ERR_CHAT_PLAYER_NOT_FOUND_S)
		if (name) then
			TellTrack_OfflinePlayers[name] = true
			self:UpdateTellTrackButtonsText()
			return
		end
		_, _, name = strfind(ar1, TT_ERR_FRIEND_OFFLINE_S)
		if (name) then
			TellTrack_OfflinePlayers[name] = true
			self:UpdateTellTrackButtonsText()
			return
		end
		_, _, name = strfind(ar1, TT_ERR_FRIEND_ONLINE_SS)
		if (name) then
			TellTrack_OfflinePlayers[name] = nil
			self:UpdateTellTrackButtonsText()
			return
		end
	end
end

-- adds a whisper to a frame
function TellTrack:GetTimeStamp(ts)
	local separator = "" -- ">"
	if ChatTimeStamps_TimeStamp and not ChatTimeStamps_SEPARATOR then
		separator = ""
	end
	if not ts then
		if ChatTimeStamps_LOCALTIME then
			ts = date()
		elseif Clock_GetTimeText then
			ts = Clock_GetTimeText()
		else
			ts = self:GetTime(nil, self._update.timediff)
		end
	end
	if type(ts) == "number" then
		ts = date("%H:%M:%S", ts)
	end	
	if type(ts) ~= "string" then
		ts = ""
	end
	return ts..separator.." "
end

function TellTrack:RedrawWhisperFrame( )	
	local frame = self._chat.frame and getglobal(self._chat.frame)
	if not frame then return end
	local scrollOffset, found, current = frame:GetCurrentScroll(), false, self._current
	frame:Clear()
	
	--Display only the valid whispers.
	for i,v in pairs(TellTrack_WhisperMessages) do
		if current.showAll or (strlower(v.name) == strlower(current.name)) then
			local info = ChatTypeInfo[v.type]
			local part1 = getglobal("CHAT_"..v.type.."_GET")..v.msg
			local part2 = (v.tag and _G["CHAT_FLAG_"..v.tag] or "").."|Hplayer:"..v.name.."|h".."["..v.name.."]".."|h"
			if TasteTheNaimbow_Loaded then
				part2 = "|cff"..TasteTheNaimbowExternalColor(name)..part2.."|r"
			end
			frame:AddMessage(format(part1, part2), info.r, info.g, info.b, info.id, nil, v.time)
			found = true
		end
	end
	
	frame:SetScrollOffset(scrollOffset)
	return found
end

function TellTrack:ShowConversationWith(name, showAll)
	local db,o,_chat = self._db,self._options,self._chat
	if not _chat.frame or not getglobal(_chat.frame) then
		if o.AutoCreate==0 or not self:CreateWhisperChatFrame() then return	end
	end
	local frame = _chat.frame and getglobal(_chat.frame)
	
	self._current = { name=name, showAll=showAll, }
	if not self:RedrawWhisperFrame() then
		self._current.showAll = true
		local timeStamp = o.TimeStamps
		o.TimeStamps = 0
		frame:AddMessage(format(self.L["-- No Current Conversation with %s --"],name))
		o.TimeStamps = timeStamp
	end
	_chat.name = name
	
	-- Show the frame and tab
	FCF_SetWindowName(frame, _chat.name)
    if frame.isDocked then
		FCF_SelectDockFrame(frame)
    end
end


function TellTrack_ChatFrame_AddMessage(frame, text, r, g, b, id, addToStart, ts)
	local tt = TellTrack
	local AddMessage = SavedChatFrame_AddMessages[frame:GetName()]
	
	if frame:GetName() ~= tt._chat.frame then
		AddMessage(frame, text, r, g, b, id, addToStart)
		return					-- incorrect whisper frame
	end
	
	local stamps = ChatTimeStamps_ENABLED
	ChatTimeStamps_ENABLED = 0
	if strlen(text) < 5 then
		AddMessage(frame, text, r, g, b, id, addToStart)
		ChatTimeStamps_ENABLED = stamps
		return
	end
	local timedText = text
	if (tt._options.TimeStamps == 1) then
		timedText = tt:GetTimeStamp(ts)..text
	end
	if not tt._current or tt._current.showAll then
		AddMessage(frame, timedText, r, g, b, id, addToStart)
		ChatTimeStamps_ENABLED = stamps
		return
	end
	
	local name = tt._current.name
    local namecolor = "ffffff"
    if TasteTheNaimbow_Loaded and TasteTheNaimbowExternalColor then
        namecolor = self:SafeCall(TasteTheNaimbowExternalColor, name)
    end
    --DEFAULT_CHAT_FRAME:AddMessage("Real "..string.gsub(string.gsub(text,":%d+\124","\124"),"\124","\\124"))
    --DEFAULT_CHAT_FRAME:AddMessage("Fake "..string.gsub(format(CHAT_WHISPER_GET, "|Hplayer:"..name.."|h".."["..name.."]".."|h"),"\124","\\124"))
    --DEFAULT_CHAT_FRAME:AddMessage(tostring((tt:startsWith(string.gsub(text,":%d+\124","\124"), format(CHAT_WHISPER_GET, "|Hplayer:"..name.."|h".."["..name.."]".."|h")))))
    local matchText = strlower(string.gsub(text,":%d+\124","\124"))  --remove numbers
    local Hplayer = "|Hplayer:"..name.."|h".."["..name.."]".."|h"
    local HplayerL = "[".."|Hplayer:"..name.."|h"..name.."|h".."]"
    local function nameMatch(get, name)
		local s, s2 = matchText, strlower(format(get, name));
		if type(s) ~= "string" or type(s2) ~= "string" then return false end		
		return s == s2 or (s:len() > s2:len() and string.sub(s, 1, s2:len()) == s2)
	end
	if	nameMatch(CHAT_WHISPER_GET, Hplayer) or
		nameMatch(CHAT_WHISPER_GET, CHAT_FLAG_DND..Hplayer) or
		nameMatch(CHAT_WHISPER_GET, CHAT_FLAG_AFK..Hplayer) or
		nameMatch(CHAT_WHISPER_GET, CHAT_FLAG_GM..Hplayer) or
		nameMatch(CHAT_WHISPER_INFORM_GET, Hplayer) or
		nameMatch(CHAT_WHISPER_GET, "|cff"..namecolor..Hplayer.."|r") or
		nameMatch(CHAT_WHISPER_GET, "|cff"..namecolor..CHAT_FLAG_DND..Hplayer.."|r") or
		nameMatch(CHAT_WHISPER_GET, "|cff"..namecolor..CHAT_FLAG_AFK..Hplayer.."|r") or
		nameMatch(CHAT_WHISPER_GET, "|cff"..namecolor..CHAT_FLAG_GM..Hplayer.."|r") or
		nameMatch(CHAT_WHISPER_INFORM_GET, "|cff"..namecolor..Hplayer.."|r") or
		nameMatch(CHAT_WHISPER_GET, HplayerL) or
		nameMatch(CHAT_WHISPER_GET, CHAT_FLAG_DND..HplayerL) or
		nameMatch(CHAT_WHISPER_GET, CHAT_FLAG_AFK..HplayerL) or
		nameMatch(CHAT_WHISPER_GET, CHAT_FLAG_GM..HplayerL) or
		nameMatch(CHAT_WHISPER_INFORM_GET, HplayerL) or
		nameMatch(CHAT_WHISPER_GET, "|cff"..namecolor..HplayerL.."|r") or
		nameMatch(CHAT_WHISPER_GET, "|cff"..namecolor..CHAT_FLAG_DND..HplayerL.."|r") or
		nameMatch(CHAT_WHISPER_GET, "|cff"..namecolor..CHAT_FLAG_AFK..HplayerL.."|r") or
		nameMatch(CHAT_WHISPER_GET, "|cff"..namecolor..CHAT_FLAG_GM..HplayerL.."|r") or
		nameMatch(CHAT_WHISPER_INFORM_GET, "|cff"..namecolor..HplayerL.."|r") then
		AddMessage(frame, timedText, r, g, b, id, addToStart)
		ChatTimeStamps_ENABLED = stamps
		return
	end
end


function TellTrack:HookAllAddMessages()
	if SavedChatFrame_AddMessages then return end
	
	SavedChatFrame_AddMessages = {}
	for i=1, NUM_CHAT_WINDOWS do
		local frameName = "ChatFrame"..i
		local frame = getglobal(frameName)
		if frame and (frame.AddMessage ~= TellTrack_ChatFrame_AddMessage) then
			SavedChatFrame_AddMessages[frameName] = frame.AddMessage
			frame.AddMessage = TellTrack_ChatFrame_AddMessage
		end
	end
end
		
function TellTrack:FindChatFrame( ... )
	for i=1, NUM_CHAT_WINDOWS do
		local sChatFrame = "ChatFrame"..i
		local chatFrame = getglobal(sChatFrame)
		local sName, _, _, _, _, _, bShown = GetChatWindowInfo(i)
		if select("#",...) == 0 then
			if (not bShown and not chatFrame.isDocked) or i == NUM_CHAT_WINDOWS then
				return chatFrame
			end	
		elseif bShown or chatFrame.isDocked then
			for i1 = 1, select("#",...) do
				local name = select(i1,...)
				if name and name == sName then
					return sChatFrame,sName
				end
			end
		end
	end
end 

function TellTrack:CreateWhisperChatFrame()
	local _chat, default, name = self._chat, self.L["Tell Track"]
	if _chat.frame and getglobal(_chat.frame) then return _chat.frame end
	
	_chat.frame,name = self:FindChatFrame(_chat.name, _chat.name~=default and default);	-- get if already exists
	if not _chat.frame then
		if FCF_GetNumActiveChatFrames() >= NUM_CHAT_WINDOWS then return end				-- dont get if have to take someone elses
		name = _chat.name or default
		local selected = SELECTED_DOCK_FRAME
		FCF_OpenNewWindow(name)
		FCF_SelectDockFrame(selected)
		_chat.frame = self:FindChatFrame(name)
	end
	if _chat.frame then																	-- make sure clear out
		_chat.name = name
		local chatFrame = getglobal(_chat.frame)
		ChatFrame_RemoveAllMessageGroups(chatFrame)
		ChatFrame_AddMessageGroup(chatFrame, "WHISPER")
		return true
	end
end

function TellTrack:HideWhispersInOtherFrames()
	local o, sframe = self._options, self._chat.frame
	local frame = sframe and getglobal(sframe)
	if not frame then return end
	local func = ChatFrame_RemoveMessageGroup -- (o.HideWhispers == 1) and ChatFrame_RemoveMessageGroup or ChatFrame_AddMessageGroup
	for i=1, NUM_CHAT_WINDOWS do
		local sChatFrame = "ChatFrame"..i
		local chatFrame = getglobal(sChatFrame)
		local sName, _, _, _, _, _, bShown = GetChatWindowInfo(i)
		if chatFrame and (bShown or chatFrame.isDocked) and sChatFrame ~= sframe then
			func(chatFrame, "WHISPER")
		end
	end
end


function TellTrack_SendChatMessage(text, type, language, target)
	TellTrack:SendChatMessage(text, type, language, target)
end

-- why not using _INFORM event? would it show out of order?
function TellTrack:SendChatMessage(text, type, language, target)
	local o = self._options
	if type == "WHISPER" then
		o.LastTell = target
		o.LastLang = language
		if o.Enable == 1 and strsub(text, 1, 1) ~= "<" then	-- prevent data message transfers from being used
			self:HandleMessageSentOrRecieved(target, true)
		end
	end
	if SavedSendChatMessage then
		SavedSendChatMessage(text, type, language, target)
	end
end

function TellTrack_ChatFrame_OpenChat(text, chatFrame)
	local tt = TellTrack
	local _chat, cc = tt._chat, tt._current
	if text == "" and cc and cc.name and cc.name ~= ""
			and SELECTED_CHAT_FRAME:GetName() == _chat.frame then
		tt:InitiateWhisperToTarget(cc.name)
	else
		if SavedChatFrame_OpenChat then
			SavedChatFrame_OpenChat(text, chatFrame)
		end
	end
end

function TellTrack_FCF_OpenNewWindow( name )
	if not SavedFCF_OpenNewWindow then return end
	SavedFCF_OpenNewWindow( name )
	local chatFrame = (TellTrack._options.HideWhispers == 1) and TellTrack:FindChatFrame() or nil
	if chatFrame then
		ChatFrame_RemoveMessageGroup(chatFrame, "WHISPER")
	end
end

function TellTrack_FCF_Close( chatFrame, fallBack )
	local _chat = TellTrack._chat
	local frame = fallBack or chatFrame or FCF_GetCurrentChatFrame()
	if frame and _chat and frame:GetName() == _chat.frame then
		_chat.frame = nil
	end
	if SavedFCF_Close then
		SavedFCF_Close(chatFrame, fallBack)
	end
end

function TellTrack_FCF_SelectDockFrame(frame)
	local tt = TellTrack
	local o,list = tt._options,tt._list
	
	if SavedFCF_SelectDockFrame then
		SavedFCF_SelectDockFrame(frame)
	end
	if frame:GetName() == tt._chat.frame then
		if tt._current.showAll then
			for i = 1, o.ListSize do
				if list[i] then	list[i].unread = 0 end
			end
		elseif tt._current.name ~= "" then
			for i = 1, o.ListSize do
				if list[i] and strlower(list[i].name) == strlower(tt._current.name) then
					list[i].unread = 0
				end
			end
		end
		tt:UpdateTellTrackButtonsText()
	end
	SELECTED_CHAT_FRAME = frame;		--FIXME: is necessary
end

function TellTrack:InitiateWhisperToTarget(name)
	self:InitWhisper(name, SavedChatFrame_OpenChat)
end

function TellTrack:UpdateTellTrackButtonsText()
	local list = self._list
	if not list then return end 
	local o = self._options
	local maxitems = TellTrackFrame.ButtonCount
	local listcount = #list
	local lastToFmtStr = "|cff33ff33%s|r"
	local lastFromFmtStr = "|cffff3333%s|r"
	local noNameFmtStr = "|cff666666%s|r"

	for i=1, maxitems do	
		if o.ListInvert ~= 1 then
			id = (i + o.ListOffset) - 1
		else
			id = (o.ListSize - (i + o.ListOffset)) + 2
		end
		
		local item = list[id]
		local sline = "TellTrack" .. i
		local line = getglobal(sline)
		
		if not line then
		else
			local fmt, val = noNameFmtStr, "Empty"
			local lineText = getglobal(sline.."Text")
			if not item or not item.dispName then
				line.playerid = nil
				line.item = nil		
				line.title = nil
			else
				line.title = item.dispName
				line.playerid = id
				line.item = item	
				val = item.dispName
				if not TellTrack_OfflinePlayers[val] then
					fmt = (item.sentTo) and lastToFmtStr or lastFromFmtStr
				end
				if item.unread and item.unread > 0 then
					val = "("..item.unread..") "..val
				end
				if o.LineNums == 1 then
					val = id .. ". "..val
				end
			end
			lineText:SetText(format(fmt, val))
			lineText:Show()
		end
	end
end

--[[
	1/15/05 - AnduinLothar: The last person whispered is automaticly moved to the bottom of
	the list and everytime you whisper it autoscrolls to the bottom of the list. Also if the
	list is full the top name is deleted and the new name is appended to the bottom.    
	
	1/17/05 - Added recieved/sent boolean for color on button reload.
]]--
function TellTrack:CapUTF8( s )
	if not s then return end
	local s1,len,c = "",s:len()
	for i = 1, len do
		c = s:byte(i);
		if i==1 and c<=127 then s1=s1..strupper(strchar(c));
		elseif c<=127 then	s1=s1..strlower(strchar(c));
		else				s1=s1..strchar(c); end
	end
	return s1
end

function TellTrack:HandleMessageSentOrRecieved( target, isSent )
	if not target then return end
	local o = self._options
	local cmpName,dispName = strlower(target),self:CapUTF8(target)
	local max, current = o.ListSize, self._current
	
	-- find
	local item, id = nil, 0
	for k, v in pairs(self._list) do
		if v and v.cmpName == cmpName then item,v = v,nil; end
		if v then id = id + 1; if id ~= k then self._list[id] = v; end end			-- compress as we go
	end
	while (id >= max) do tremove(self._list, 1); id = id - 1; end
	if not item then item = { name = target, cmpName = cmpName, dispName = dispName, unread = 0, } end
	id = id + 1; self._list[id] = item
	
	-- update
	item.sentTo = isSent
	if not item.unread then	item.unread = 0	end
	if not isSent and self._chat.frame then
		if not getglobal(self._chat.frame):IsVisible() or (current.name ~= target and not current.showAll) then
			item.unread = item.unread + 1
		end
	end
	
	-- change offset
	if o.ListInvert == 1 then
		if id < max - TellTrackFrame.ButtonCount and (max - id + 1) ~= o.ListOffset then
			self:ChangeArrayOffset(max-id+1)
		end
	else
		if id > TellTrackFrame.ButtonCount and (id-TellTrackFrame.ButtonCount+1) ~= o.ListOffset then
			self:ChangeArrayOffset(id-TellTrackFrame.ButtonCount+1)
		end
	end

	self:UpdateTellTrackButtonsText()
end

