﻿--[[
	Persistent Data for TellTrack, Saved Variables
]]

TellTrack = LibKarma:GetInstance( "TellTrack", {

} )

TellTrack:RegisterDB( "TellTrackDB", {
	Options = {
		Enable = 1,
		ListInvert = 0,
		ListSave = 1,
		AutoCreate = 1,
		HideWhispers = 0,
		TimeStamps = 0,
		WhisperFirst = 0,
		LineNums = 0,
		Border = 0,
		ListSize = 30,
		ShowAll = 0,
		DebugMode = 0,
		-- Internal flags
		Color = "|c0076dfff",			-- optional text accent color
		Realm = nil,					-- current realm
		Player = nil,					-- current logged in player name
		Race = nil,						-- current player race
		Faction = nil,
		ListProfile = nil,
		PlayerProfile = nil,
		LastTell = nil,
		LastLang = nil,
		ListOffset = 1,
		VersionCopy = 0,                -- [0|1]  Is imported CT_RaidTracker, one time thing very first load only
		VersionFix = 3,					-- [0...]  Current database version level
	},
	Log = { },
	Chat = { },
	Whisp = { },
} )


function TellTrack:RunVersionFix( frame )
	local db = self._db
	local log = db.Log
	local o = self._options
	o.VersionFix = o.VersionFix			-- copy and force default value to get saved

	if o.VersionCopy == 0 then
		if TellTrack_SavedList then
			self:Print("Importing TellTrack database.")
			self:ImportToDB( o, _G, "TellTrack_", false, true, { "Enabled", "HideBorder", "InvertedList", "DontSaveList",
				"AutoWhisperFrame", "HideOtherWhispers", "TimeStamps", "WhisperFirst", } )
			self:ImportToDB( nil, _G, "TellTrack_", false, true, { Chat="WhisperChatFrame", Log="SavedList",} )
		end
		o.VersionCopy = 1
	end	
	
	local t,s,s2,s3
	if o.VersionFix >= 0 and o.VersionFix <= 2 then										self:Debug("VersionFix", 1,2,3)
		if o.DontSaveList then o.DontSaveList = (o.DontSaveList == 1) and 0 or 1 end
		self:ImportRenameDB( o, { "AutoCreate","AutoWhisperFrame","CurentList","ButtonCount",
			Enable="Enabled",HideWhispers="HideOtherWhispers",Border="HideBorder",ListInvert="InvertedList",ListSave="DontSaveList", } )
		
		for k,v in pairs(log) do
			s,s2 = strsplit("_", k, 2); if s2 then s=s.." - "..s2; log[s] = v; log[k] = nil; end
			for i1,v1 in pairs(v) do
				if type(v1)=="string" then
					v1 = { name = v1, compareName = v1:lower(), unread = 0, sentTo = false, }; v[i1] = v1
				end
				if type(v1)~="table" then tremove(i1) end
				if not v1.unread then v1.unread = 0 end
				if not v1.dispName then v1.dispName = v1.name end
				if v1.compareName then v1.cmpName = v1.compareName; v1.compareName = nil; end
			end
		end
		for k,v in pairs(db.Chat) do
			for k1,v1 in pairs(v) do
				if o.VersionFix == 0 and type(v1) ~= "table" then v1 = { name=nil, frame=v1 }; v[k1] = v1 end
				if type(v1) == "table" then	db.Chat[k1.." - "..k] = v1; db.Chat[k] = nil end
			end
		end
		o.VersionFix = 3
	end

end
