local Addon, TA = ...

-- Generic Locals
local on = true
local off = false
local PerSec = 8 -- run the Queue scan X times a second
local AnnounceDupeTime = 1 -- Duplicate announce filter time (if same spell happens within x seconds by same person it won't announce it)
local ToTell = false -- flag if something to tattle happens

-- Addon Settings
TauntAware_Settings = {}
local TAS = nil 
TauntAware_Default_Settings = {
	Enable = on,
	Full = off,
	MF = on,
	FadeDelay = 15,
	TauntsOnly = "on", -- "on", "off", "monitor"
	Links = on,
	Scan = on,
	ScanDelay = 5,
	Tattle = off,
	TatMode = "GROUP", -- either WHISPER, GROUP, SUMMARY (summary just prints to you)
}

TauntAware_PC = {}

-- Bill's Utils
local SJprint = BillsUtils.SJprint
local addOptionMt = BillsUtils.addOptionMt
local StatColor = BillsUtils.StatColor
local OptSaveTF = BillsUtils.OptSaveTF
local OptSaveVal = BillsUtils.OptSaveVal
local CCC = BillsUtils.CCC

BillsUtils.Locals[#BillsUtils.Locals +1] = function ()
	SJprint = BillsUtils.SJprint
	addOptionMt = BillsUtils.addOptionMt
	StatColor = BillsUtils.StatColor
	OptSaveTF = BillsUtils.OptSaveTF
	OptSaveVal = BillsUtils.OptSaveVal
	CCC = BillsUtils.CCC
end

-- Local Misc Functions


-- Local text colors
local yel = "|cFFFFFF00"
local wht = "|cFFFFFFFF"
local blu = "|cFF00FFFF"
local red = "|cFFFF0000"
local grn = "|cFF00FF00"
local res = "|r"

local SpellList = {}
-- SpellId 

SpellList = {
	--DRUID
	--SPELL_CAST_SUCCESS
	[6795] = true,	-- Growl
	[5209] = true,	-- Challenging Roar

	--HUNTER
	--SPELL_CAST_SUCCESS
	[34477] = true,	-- Misdirection
	[20736] = true,	-- Distracting Shot

	--MAGE

	--PALADIN
	--SPELL_CAST_SUCCESS
	[31789] = true,	-- Righteous Defense
	[62124] = true,	-- Hand of Reckoning
	[25780] = true,	-- Righteous Fury

	--PRIEST
	
	--ROGUE
	--SPELL_CAST_SUCCESS
	[57934] = true,	-- Tricks of the Trade

	--SHAMAN
	--SPELL_CAST_SUCCESS
	[8056] = true,	-- Frost Shock
	--"SPELL_AURA_APPLIED"
	[73684] = true,	-- Unleash Earth

	--WARLOCK

	--WARRIOR
	--SPELL_CAST_SUCCESS
	[355] = true,	-- Taunt
	[1161] = true,	-- Fury
	[57755] = true,	-- Heroic Throw
	[71] = true,	-- Defensive Stance

	--DEATHKNIGHT
	--SPELL_CAST_SUCCESS
	[48263] = true,	-- Blood Presence
	[49576] = true,	-- Death Grip
	[56222] =  true,	-- Dark Command

	--PETS
	-- Warlock Pets
	[17735] = true,	-- Suffering
	[3716] = true,	-- Torment
	-- Hunter Pets
	[2649] = true,	-- Growl
	[53477] = true,	-- Taunt
	[24394] = true,	-- Intimidation
	[63900] = true,	-- Thunderstomp
}

local ScanSpells = {
	[25780] = true,	-- Pally	Righteous Fury
	[48263] = true,	-- DK		Blood Presence
	[71] = true,	-- War 		Defensive Stance
}

local LastPartyMembers ={}
TA.ScanGroup = function( UserCalled )
	local PNum = GetNumPartyMembers()
	local RNum = GetNumRaidMembers()
	local Type = ""
	local Count = 0
	local msg
			
	if RNum > 0 then
		Type = "raid"
		Count = RNum
	elseif PNum > 0 then
		Type = "party"
		Count = PNum
	else
		return
	end
	
	local changed = false
	
	if Count ~= #LastPartyMembers then
		changed = true
	else
		for x = 1, Count do
			if LastPartyMembers[x] ~= UnitName(Type..tostring(x)) then
				changed = true
			end
		end
	end
		
	if not(changed) and not(UserCalled) then
		return
	end
	
	if UserCalled then
		msg = ("%sTaunt Aware|r scan started on %d group members"):format( yel, Type == "party" and Count + 1 or Count )
	else
		msg = ("%sTaunt Aware|r auto scan started on %d group members"):format( yel, Type == "party" and Count + 1 or Count )
	end
	
	if TAS.MF then
		if TA.MF:GetTimeVisible() ~= TAS.FadeDelay then
			TA.MF:SetTimeVisible( TAS.FadeDelay )
		end
		TA.MF:AddMessage( msg )
	else	
		print( msg )
	end
	
	table.wipe(LastPartyMembers)
	local msg
	for x = 1, Count do
		LastPartyMembers[x] = UnitName(Type..tostring(x))
		local role = UnitGroupRolesAssigned(Type..tostring(x))
		if role ~= "TANK" then
			for y = 1, 40 do
				local name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, isStealable, shouldConsolidate, spellId = UnitAura( Type..tostring(x), y)
				if not spellId then
					break
				end
				if ScanSpells[spellId] then
					local _, class = UnitClass(Type..tostring(x))
					local charName = UnitName(Type..tostring(x))
					if TAS.Links then
						msg = ("%s<Taunt Aware> %s|Hplayer:%s|h%s|h|r has |cff71d5ff|Hspell:%s|h[%s]|h|r on"):format(yel, CCC(class), charName, charName, spellId, name)
					else
						msg = ("%s<Taunt Aware> %s%s|r has |cff71d5ff%s|r on"):format(yel, CCC(class), charName, name)
					end
					if TAS.MF then
						if TA.MF:GetTimeVisible() ~= TAS.FadeDelay then
							TA.MF:SetTimeVisible( TAS.FadeDelay )
						end
						TA.MF:AddMessage( msg )
					else	
						print( msg )
					end
				end
			end
		end
	end
	
	if Type == "party" then
		local role = UnitGroupRolesAssigned("player")
		if role ~= "TANK" then
			for y = 1, 40 do
				local name, rank, icon, count, debuffType, duration, expirationTime, unitCaster, isStealable, shouldConsolidate, spellId = UnitAura( "player" , y)
				if not spellId then
					break
				end
				if ScanSpells[spellId] then
					local _, class = UnitClass("player")
					local charName = UnitName("player")
					if TAS.Links then
						msg = ("%s<Taunt Aware> %s|Hplayer:%s|h%s|h|r has |cff71d5ff|Hspell:%s|h[%s]|h|r on"):format(yel, CCC(class), charName, charName, spellId, name)
					else
						msg = ("%s<Taunt Aware> %s%s|r has |cff71d5ff%s|r on"):format(yel, CCC(class), charName, name)
					end
					if TAS.MF then
						if TA.MF:GetTimeVisible() ~= TAS.FadeDelay then
							TA.MF:SetTimeVisible( TAS.FadeDelay )
						end
						TA.MF:AddMessage( msg )
					else	
						print( msg )
					end
				end
			end
		end
	end
	
	if UserCalled then
		msg = ("%sTaunt Aware|r scan finished on %d group members"):format( yel, Type == "party" and Count + 1 or Count )
	else
		msg = ("%sTaunt Aware|r auto scan finished on %d group members"):format( yel, Type == "party" and Count + 1 or Count )
	end
	
	if TAS.MF then
		if TA.MF:GetTimeVisible() ~= TAS.FadeDelay then
			TA.MF:SetTimeVisible( TAS.FadeDelay )
		end
		TA.MF:AddMessage( msg )
	else	
		print( msg )
	end
end

local scanTool = CreateFrame( "GameTooltip", "ScanTooltip", nil, "GameTooltipTemplate" )
scanTool:SetOwner( WorldFrame, "ANCHOR_NONE" )
local scanText = _G["ScanTooltipTextLeft2"] -- This is the line with <[Player]'s Pet>

function getPetOwner(petName)
	scanTool:ClearLines()
	scanTool:SetUnit(petName)
	local ownerText = scanText:GetText()
	if not ownerText then return false end
	local owner, _ = string.split("'",ownerText) -- english
	if UnitExists(owner) then return owner end
	owner = { string.split(" ", ownerText) }
	for x = #owner, 1, -1 do
		if UnitExists(owner[x]) then
			return owner[x]
		end
	end
	
	return false -- This is for error catching 
end

local Queue = {}
local ScanDelay = false

TA.Frame = CreateFrame("Frame")
TA.Frame:RegisterEvent("ADDON_LOADED")
TA.Frame:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
TA.Frame:RegisterEvent("PARTY_MEMBERS_CHANGED")
TA.Frame:RegisterEvent("RAID_ROSTER_UPDATE")

TA.Frame:SetScript("OnEvent",function(self, event, ...)
	local arg = ...
	if event == "ADDON_LOADED" and arg == Addon then
		SJprint(yel, "Taunt Aware v",red, GetAddOnMetadata(Addon, "Version"), yel, "loaded", res)
		addOptionMt( TauntAware_Settings, TauntAware_Default_Settings )
		TAS = TauntAware_Settings
		local realm = GetRealmName()
		if not TauntAware_PC[realm] then
			TauntAware_PC[realm] = {}
		end
		local player = UnitName("player")
		if not TauntAware_PC[realm][player] then
			TauntAware_PC[realm][player] = {}
		end
		PC = TauntAware_PC[realm][player]
		if not(PC.MsgFrameSet) then
			PC.MsgFrameSet = true
			TA.MsgFrameUnlock()
			TA.MF:AddMessage("Move this frame to where you would like then type \"/tamf lock\" to save the position", 1, 1, 1 )
		else
			TA.MsgFrameLock()
		end
		
		-- variable upgrade here
		if type(TAS.TauntsOnly) == "boolean" then
			if TAS.TauntsOnly then
				TA.CmdLine( "tauntsonly on")
			else
				TA.CmdLine( "tauntsonly off")
			end
		end
		
		TA.TAS = TAS
		TA.TAD = TAD
				
		return self, event, ...
	elseif event == "ADDON_LOADED" then
		return self, event, ...
	end
	
	if not(TAS.Enable) then return end
	if event == "COMBAT_LOG_EVENT_UNFILTERED" then
		Queue[#Queue +1] = { ... }
		return
	end
	if (event == "PARTY_MEMBERS_CHANGED" or event == "RAID_ROSTER_UPDATE") and TAS.Scan then
		if not( ScanDelay ) then
			ScanDelay = TAS.ScanDelay
		end
		return
	end	
	return
end)

local e = 0
local last = {}
local TattleQueue = {}
local TauntsOnly = ""


TA.Frame:SetScript("OnUpdate", function(self, elapsed)
	e = e + elapsed
	if e < 1/PerSec then
		return
	end
	e = 0
	
	if not(TAS.Enable) then return end
	
	if ScanDelay then
		ScanDelay = ScanDelay - elapsed
		if ScanDelay < 0 then
			ScanDelay = false
			TA.ScanGroup()
		end
	end
	
	
	if TauntsOnly ~= TAS.TauntsOnly then
		TauntsOnly = TAS.TauntsOnly
		local val
		if TAS.TauntsOnly == "on" then
			val = nil
		elseif TAS.TauntsOnly == "monitor" then
			val = false	
		else
			val = true			
		end
		SpellList[34477] = val	-- Hunter	Misdirection
		SpellList[57934] = val	-- Rogue	Tricks of the Trade
		SpellList[8056] = val	-- Shaman	Frost Shock
	end
	
	local PlayerRole = UnitGroupRolesAssigned("player") -- why test on each queue loop?
	while #Queue > 0 do
		local timestamp, eventType, hidecaster, sourceGUID, sourceName, sourceFlags, sourceFlags2, destGUID, destName, destFlags, destFlags2, spellId, spellName = unpack(Queue[1])
		local ValidUnit = UnitExists(sourceName)
		local ValidSpellWarn = type(SpellList[spellId]) == "boolean"
		local ValidEvent = eventType == "SPELL_CAST_SUCCESS" or eventType == "SPELL_AURA_APPLIED"
		
		if  ValidUnit and ValidSpellWarn and ValidEvent then
			local B = tonumber(sourceGUID:sub(5,5), 16);
			local maskedB = B % 8; -- x % 8 has the same effect as x & 0x7 on numbers <= 0xf
			-- local knownTypes = {[0]="player", [3]="NPC", [4]="pet", [5]="vehicle"};
	
			local Self = UnitIsUnit(sourceName, "player")
			local SelfPet = UnitIsUnit(sourceName, "pet")
			local PC = maskedB == 0 
			local Pet = maskedB == 4
			
			local Announce = false
			if TAS.Full or PlayerRole == "TANK" then
				Announce = true
			elseif PlayerRole == "DAMAGER" and (Self or SelfPet) then
				SJprint(red, "Are You supposed to be taunting?")
				Announce = true
			elseif PlayerRole == "HEALER" then
				--whatever for healers
			elseif PlayerRole == "NONE" then
				Announce = true
			end
			
			--Duplicate announce check
			if Announce and last.sourceName == sourceName and last.spellId == spellId and (timestamp - last.timestamp < AnnounceDupeTime ) then
				Announce = false
			end
				
			if Announce then
				last.sourceName = sourceName
				last.spellId = spellId
				last.timestamp = timestamp
				
				local _, sourceClass = UnitClass(sourceName)
				local name = ""
				local PetOwner, PetOwnerClass
				local msg = ""
								
				if Pet then
					PetOwner = getPetOwner(sourceName)
					_, PetOwnerClass = UnitClass( PetOwner )
				end
				
				if TAS.Links then
					spellName = "|cff71d5ff|Hspell:"..spellId.."|h["..spellName.."]|h|r" -- Create Spell Link
					if Pet and PetOwner then
						name = ("%s|Hplayer:%s|h[%s]|h %s%s "):format( CCC(PetOwnerClass), PetOwner, PetOwner, CCC(sourceClass), sourceName )
					elseif Pet then
						name = ("PET: %s%s "):format( CCC(sourceClass), sourceName )
					else
						name = ("%s|Hplayer:%s|h[%s]|h"):format(CCC(sourceClass), sourceName, sourceName)
					end
				else
					if Pet and PetOwner then
						name = ("%s%s %s%s"):format( CCC(PetOwnerClass), PetOwner, sourceClass, sourceName )
					elseif Pet then
						name = ("PET: %s%s "):format( CCC(sourceClass), sourceName )
					else
						name = ("%s%s "):format( CCC(sourceClass), sourceName )
					end
				end
				
				if destName and destName ~= sourceName then
					msg = string.format("|cFFFFFF00<Taunt Aware> %s|cFFFFFFFF casts %s on |cFFFF0000%s|r", name, spellName, destName )
				else
					msg = string.format("|cFFFFFF00<Taunt Aware> %s|cFFFFFFFF casts %s|r", name, spellName )
				end
		
				
				if TAS.MF then
					if TA.MF:GetTimeVisible() ~= TAS.FadeDelay then
						TA.MF:SetTimeVisible( TAS.FadeDelay )
					end
					TA.MF:AddMessage( msg )
				else
					print( msg )
				end
				
				if TAS.Tattle and SpellList[spellId] then -- have to test spell ID because people now can get warned of high threat actions but not tattle them
					if Pet or UnitGroupRolesAssigned( sourceName ) ~= "TANK" then
						ToTell = true
						if not(TattleQueue[sourceName]) then
							TattleQueue[sourceName] = {}
						end
						if not(TattleQueue[sourceName][spellId]) then
							TattleQueue[sourceName][spellId] = 0
						end
						TattleQueue[sourceName][spellId] = TattleQueue[sourceName][spellId] + 1
					end
				end
				
			end -- end of  if announce
		end --end of unit check
		table.remove(Queue, 1)
	end -- end of while 
	
	if TAS.Tattle and ToTell and not( InCombatLockdown() ) then
		ToTell = false
		local ChatType = false
		if TAS.TatMode == "GROUP" then
			if GetNumRaidMembers() > 0 then
				ChatType = "RAID"
			elseif GetNumPartyMembers() > 0 then
				ChatType = "PARTY"
			end
		elseif TAS.TatMode == "WHISPER" then
			ChatType = "WHISPER"
		end
		
		for Name,Table in pairs(TattleQueue) do 
			for SpellId,Count in pairs(Table) do
				if SpellList[SpellId] then
					local SpellLink = GetSpellLink(SpellId)
					local msg, ChatTarget
										
					if UnitInParty(Name) or UnitInRaid(Name) or UnitIsUnit("player", Name) then
						ChatTarget = Name
						msg = ("<Taunt Aware> %s casted %s %s times last fight"):format( Name, SpellLink, Count )
					else
						local PetOwner = getPetOwner( Name )
						ChatTarget = PetOwner
						msg = ("<Taunt Aware> %s %s casted %s %s times last fight"):format( PetOwner, Name, SpellLink, Count )	
					end	
					
					if ChatType then
						if ChatType == "PARTY" or ChatType == "RAID" then
							SendChatMessage( msg ,ChatType )
						elseif ChatType == "WHISPER" then
							if ChatTarget then
								SendChatMessage( msg, ChatType, nil, ChatTarget)
							end
						else
							if TAS.MF then
								if TA.MF:GetTimeVisible() ~= TAS.FadeDelay then
									TA.MF:SetTimeVisible( TAS.FadeDelay )
								end
								TA.MF:AddMessage( msg )
							else
								print( msg )
							end
						end
					else
						if TAS.MF then
							if TA.MF:GetTimeVisible() ~= TAS.FadeDelay then
								TA.MF:SetTimeVisible( TAS.FadeDelay )
							end
							TA.MF:AddMessage( msg )
						else
							print( msg )
						end
					end
				end
			end
		end
		table.wipe(TattleQueue)
	end
end)

TA.CmdLine = function( msg )
	local cmd,arg = string.split(" ", msg)
	cmd = cmd:lower()
	
	if cmd =="config" then
		InterfaceOptionsFrame_OpenToCategory( TA.panel )
		return
	end

	if cmd == "scannow" then
		TA.ScanGroup(true)
		return
	end

	if not(TAS.Enable) and cmd ~= "enable" then
		print(" ")
		SJprint( yel, "Taunt Aware", res)
		SJprint( yel, "  This addon is ", red, "DISABLED", res)
		SJprint( yel, "  Type: ", blu, "/ta enable on", res)
		SJprint( yel, "  to enable.", res)
		return
	end

	--On/Off True/False values
	local Command = {"Enable", "Full", "Links", "Scan", "Tattle",}
	
	for x = 1, #Command do
		if cmd == string.lower(Command[x]) then
			OptSaveTF( TAS, Command[x], arg)
			SJprint(  yel, "Taunt Aware:", Command[x],"is", StatColor( TAS[Command[x]] ), res)
			return
		end
	end
	
	if cmd == "tauntsonly" then
		if arg == "on" or arg == "off" or arg == "monitor" then
			TAS.TauntsOnly = arg
		end
		SJprint(  yel, "Taunt Aware:", blu, "TauntsOnly|r is", TAS.TauntsOnly == "off" and red or grn, TAS.TauntsOnly , res)
		SJprint(  yel, "Taunt Aware:|r valid modes are ", blu, "on, off, monitor", res)
		return
	end
	
	if cmd == "mf" then
		if arg == "unlock" then
			TA.MsgFrameUnlock()
			return
		elseif arg == "lock" then
			TA.MsgFrameLock()
			return
		end
		OptSaveTF( TAS, "MF", arg)
		SJprint( yel, "Taunt Aware:", blu, "MF", wht, "is", StatColor( TAS.MF ), res)
		return
	end
	
	if cmd == "scandelay" then
		OptSaveVal( TAS, "ScanDelay", arg, 1, 60 )
		SJprint( yel, "Taunt Aware: ScanDelay is", grn, TAS.ScanDelay, yel, "second(s).", res)
		return
	end
	
	if cmd == "fadedelay" then
		OptSaveVal( TAS, "FadeDelay", arg, 1, 60 )
		SJprint( yel, "Taunt Aware: FadeDelay is", grn, TAS.FadeDelay, yel, "second(s).", res)
		return
	end
	
	if cmd == "tatmode" then
		if arg then
			local Mode = string.upper(arg)
			if Mode == "GROUP" or Mode == "WHISPER" or Mode == "SUMMARY" then
				TAS.TatMode = Mode
			else
				SJprint(  yel, "Taunt Aware:", red, Mode, wht, "is not a valid Tattle Mode")
				SJprint(  yel, "Taunt Aware:", wht, "Valid modes are", blu, "GROUP   WHISPER   SUMMARY")
				return
			end
		end
		SJprint(yel, "Taunt Aware:", blu,"TatMode", wht, "is", grn, TAS.TatMode, res)
		return
	end
	
	if cmd == "" then
		print(" ")
		SJprint( yel, "________________________________________", res)
		SJprint( yel, "Taunt Aware", res)
		SJprint( blu, "     Enable", wht, "is", StatColor(TAS.Enable), res)
		SJprint( blu, "     Full", wht, "alerts are", StatColor(TAS.Full), res)
		SJprint( blu, "     MF", wht, "is", StatColor(TAS.MF), res)
		SJprint( blu, "     FadeDelay", wht, "is", grn, TAS.FadeDelay, wht, "seconds", res)
		SJprint( blu, "     TauntsOnly", wht, "is set", grn, TAS.TauntsOnly, res)
		SJprint( blu, "     Links ", wht, "for abilities are", StatColor(TAS.Links), res)
		SJprint( blu, "     Scan ", wht, "on party change is", StatColor(TAS.Scan), res)
		SJprint( blu, "     Tattle ", wht, "on non tank taunts is", StatColor(TAS.Tattle), res)
		SJprint( blu, "     TatMode ", wht, "What channel you want to tattle to (GROUP   WHISPER   SUMMARY) is", grn, (TAS.TatMode), res)
		SJprint( yel, "Available commands are listed above in", blu, "BLUE.", res)
		SJprint( yel, "Type", blu, "/ta scannow", yel, "or", blu, "/tascan", yel, "to run a group scan",  res)
		SJprint( yel, "Type", blu, "/ta help", yel, "or", blu, "/ta cmdlist", yel, "for an explanation of the commands",  res)
		SJprint( yel, "Type", blu, "/ta config", yel, "to open the GUI config screen.", res)
		SJprint( yel, "________________________________________", res)
		return
	end

	if cmd == "help" or cmd == "cmdlist" then
		print(" ")
		SJprint( yel, "________________________________________", res)
		SJprint( yel, "Taunt Aware", res)
		SJprint( blu, "     Enable", wht, "Enable the addon to function [on/off]", res)
		SJprint( blu, "     Full", wht, "Alerts no matter your role [on/off]", res)
		SJprint( blu, "     MF", wht, "use the new movable message fram to alert to taunts [on/off/lock/unlock]", res)
		SJprint( blu, "     FadeDelay", wht, "how long the messages stay in the above frame[1-60 seconds]", res)
		SJprint( blu, "     TauntsOnly", wht, "select what to do about high threat actions on = ignore  off = tattle  monitor = alert just yourself", res)
		SJprint( blu, "     Links ", wht, "enable spell/ player links when able [on/off]", res)
		SJprint( blu, "     Scan ", wht, "Scan the non tank group members for threat increasing abilities on a group change [on/off]", res)
		SJprint( blu, "     Tattle ", wht, "on non tank taunts [on/off]", res)
		SJprint( blu, "     TatMode ", wht, "What channel you want to tattle to (GROUP   WHISPER   SUMMARY)", res)
		SJprint( yel, "Available commands are listed above in", blu, "BLUE.", res)
		SJprint( yel, "Type", blu, "/ta scannow", yel, "or", blu, "/tascan", yel, "to run a group scan",  res)
		SJprint( yel, "Type", blu, "/ta config", yel, "to open the GUI config screen.", res)
		SJprint( yel, "________________________________________", res)
	end
	
	print(" ")
	SJprint( yel, "  Taunt Aware", res)
	SJprint( yel, "  Error: ", red, cmd, yel, " is not a valid command", res)
	SJprint( yel, "  Type: ", blu, "/ta", yel, "for the addon status and command list", res)
	SJprint( yel, "  Type: ", blu, "/ta cmdlist", yel, "for command list help", res)
	SJprint( yel, "Type", blu, "/ta config", yel, "to open the GUI config screen.", res)

	return
end

local Backdrop={
	bgFile = "Interface\\DialogFrame\\UI-DialogBox-Background",
	edgeFile="Interface\\DialogFrame\\UI-DialogBox-Border",
	tile = true,
	tileSize = 16,
	edgeSize = 16,
	insets = {
		left = 0,
		right = 0,
		top = 0,
		bottom = 0
	}
}

local OnMouseDown = function(self, button)
	if button == "LeftButton" then
		self:StartMoving()
		self.isMoving = true
		self.hasMoved = false
	elseif button == "RightButton" then
		self:StartSizing()
		self.isMoving = true
		self.hasMoved = false
	end
end

local OnMouseUp = function(self)
    if ( self.isMoving ) then
        self:StopMovingOrSizing();
        self.isMoving = false;
        self.hasMoved = true;
    end
end

TA.MF = CreateFrame("MessageFrame", "TAMsgFrame")
local MF = TA.MF
MF:SetFrameStrata("DIALOG")
MF:SetToplevel(true)
MF:SetSize(UIParent:GetWidth() / 4, 50)
MF:SetTimeVisible(15)
MF:SetFadeDuration(5)
MF:SetFading(true)
MF:SetClampedToScreen(true)
MF:SetInsertMode("BOTTOM")
MF:SetIndentedWordWrap(true)
MF:SetFontObject(GameFontNormalSmall)
MF:SetJustifyH("LEFT")
MF:SetPoint("CENTER", UIParent, "CENTER" )
MF:Show()
MF:SetMovable(true)
MF:SetResizable(true)
MF:SetMinResize( 30, 30 )
MF:RegisterForDrag("LeftButton","RightButton")
MF:SetScript("OnMouseDown",OnMouseDown)
MF:SetScript("OnMouseUp",OnMouseUp)
MF.Title = MF:CreateFontString( nil , "OVERLAY", "GameFontHighlight")
MF.Title:SetPoint( "TOP", MF, "TOP", 0, -6 )
MF.Title:SetJustifyH( "CENTER" )
MF.Title:SetJustifyV( "MIDDLE" )
MF.Title:SetText("Taunt Aware")

TA.MsgFrameLock = function()
	MF:EnableMouse(false)
	MF:SetBackdrop( nil )
	MF.Title:Hide()
end

TA.MsgFrameUnlock = function()
	MF:EnableMouse(true)
	MF:SetBackdrop( Backdrop )
	MF.Title:Show()
end


SLASH_TA1 = "/ta"
SlashCmdList["TA"] = function(msg)
	TA.CmdLine(msg)
end

SLASH_TASCAN1 = "/tascan"
SlashCmdList["TASCAN"] = function(msg)
	TA.ScanGroup(true)
end

SLASH_TAMF1 = "/tamf"
SlashCmdList["TAMF"] = function(msg)
	local cmd, data = string.split(" ", msg, 2)
	cmd = string.lower( cmd )
	if cmd == "unlock" then
		TA.MsgFrameUnlock()
		SJprint( yel, "Taunt Aware", wht, "Left Button moves the frame, Right button resizes the frame \n type \"/tamf lock\" when you are done moving the frame" )
		return
	elseif cmd == "lock" then
		TA.MsgFrameLock()
		return
	end
	OptSaveTF( TAS, "MF", cmd)
	SJprint( yel, "Taunt Aware:", blu, "MF", wht, "is", StatColor( TAS.MF ), res)
	return
end