local AddonName, TA = ...

-- Config Panel Text Strings
TA.Text={
Title = "Taunt Aware",
TitleSub = "Change how Taunt Aware behaves by setting the options below",
Enable = "Enable the Add On to function",
Full = "Enable full warnings (if you are not a tank)",
MF = "Use the Message Frame instead of chat for alerts",
FadeDelay  = "                            How long the messages display in the frame [1-60 secs]",
TauntsOnly = "Select how to react to high threat actions ( on = ignore, off = tattle, monitor = just alert yourself )",
Links = "Show skill links instead of just skill names",
Scan = "Scan the group for threat increasing abilities when members change",
ScanDelay = "                                    Wait how long after members change for the scan [1-60 secs]",
Tattle = "Alert other people when fight is over to taunts used by non tanks",
TatMode = "How to send the alert [GROUP/WHISPER/SUMMARY](Summary just outputs to you)",
}

-- Bill's Utils
local ChkBox = BillsUtils.ChkBox
local ChkBoxSave = BillsUtils.ChkBoxSave
local CheckClick = BillsUtils.CheckClick
local SliderSave = BillsUtils.SliderSave
local SliderMW = BillsUtils.SliderMW
local Slider = BillsUtils.Slider
local SliderEditBox = BillsUtils.SliderEditBox
local SJprint = BillsUtils.SJprint


local X = 16 -- standard Horizontal Spacing
local Y = 35 -- standard Vertical spacing 26
local TxtY = 13



-- General Settings / functions
local TAS = TauntAware_Settings
local TAD

TA.ConfigFrame = CreateFrame("Frame")
TA.ConfigFrame:RegisterEvent("ADDON_LOADED")

TA.ConfigFrame:SetScript("OnEvent",function(self, event, ...)
	local arg = ...
	if event ~= "ADDON_LOADED" and arg ~= AddonName then return end
	TAS = TA.TAS
	TAD = TA.TAD
end)

TA.Checkclick = function()
	PlaySound( "GAMEGENERICBUTTONPRESS" )
end

--Panel
TA.panel = CreateFrame( "Frame", "TauntAwareConfig", UIParent )
local me = TA.panel
me:SetScript("OnLoad", function()
	me.init()
end)


me.name = "Taunt Aware"

-- Pane title
local Title = me:CreateFontString( nil, "ARTWORK", "GameFontNormalLarge" )
Title:SetPoint( "TOPLEFT", 16, -16 )
Title:SetText( TA.Text.Title )
local SubText = me:CreateFontString( nil, "ARTWORK", "GameFontHighlightSmall" )
SubText:SetPoint( "TOPLEFT", Title, "BOTTOMLEFT", 0, -8 )
SubText:SetPoint( "RIGHT", -32, 0 )
SubText:SetHeight( 32 )
SubText:SetJustifyH( "LEFT" )
SubText:SetJustifyV( "TOP" )
SubText:SetText( TA.Text.TitleSub )

-- Check Boxes & Text
local last = SubText
local Command = {"Enable", "Full", "MF",}
for x = 1, #Command do
	me[ Command[x] ] = ChkBox( last , "TauntAwareCfg", Command[x] , me, CheckClick, TA.Text )
	last = me[ Command[x] ]
end

me.FadeDelay = Slider( last , "TauntAwareCfg", "FadeDelay", me , SliderMW , TA.Text, 1, 60, 1 )
last = me.FadeDelay
me.FadeDelay.Val = SliderEditBox( last , "TauntAwareCfg", "FadeDelay", me )

--"TauntsOnly" goes here
--local items = {}
local TauntsOnlyVal
local level = 1

local function OnClick(self)
	local index = self:GetID()
	UIDropDownMenu_SetSelectedID( UIDROPDOWNMENU_OPEN_MENU, index)
	local TauntsOnlyModes = {"on", "off", "monitor" }
	TauntsOnlyVal = TauntsOnlyModes[index]
end

local function initialize(self, level)
	local info, selected
	local Command = {"on", "off", "monitor" }
	
	if TAS.TauntsOnly == "on" then
		selected = 1
	elseif TAS.TauntsOnly == "off" then
		selected = 2
	else
		selected = 3
	end	
		
	for count = 1, #Command  do
		info = UIDropDownMenu_CreateInfo()
		info.text = Command[count]
		info.value = Command[count]
		info.func = OnClick
		if count == selected then
			TauntsOnlyVal = count
			info.checked = true
		end	
		UIDropDownMenu_AddButton(info, level)
	end
	
	UIDropDownMenu_SetSelectedID( UIDROPDOWNMENU_INIT_MENU , selected ) 
end

local TauntsOnlyText = me:CreateFontString( nil, "ARTWORK", "GameFontHighlightSmall" )
TauntsOnlyText:SetPoint( "TOPLEFT", last, "BOTTOMLEFT", 0, -0 )
TauntsOnlyText:SetPoint( "RIGHT", -32, 0 )
TauntsOnlyText:SetHeight( 32 )
TauntsOnlyText:SetJustifyH( "LEFT" )
TauntsOnlyText:SetJustifyV( "CENTER" )
TauntsOnlyText:SetText( TA.Text.TauntsOnly )

last = TauntsOnlyText

me.TauntsOnly = CreateFrame("Button", "TauntAwareCfgTauntsOnly", me, "UIDropDownMenuTemplate")
me.TauntsOnly.displayMode = "MENU"
me.TauntsOnly:ClearAllPoints()
me.TauntsOnly:SetPoint("TOPLEFT", last, "BOTTOMLEFT", 0, 0)
UIDropDownMenu_Initialize( me.TauntsOnly, initialize)
UIDropDownMenu_SetWidth( me.TauntsOnly, 100);
UIDropDownMenu_SetButtonWidth( me.TauntsOnly, 124)
UIDropDownMenu_JustifyText( me.TauntsOnly, "LEFT")
		
last = me.TauntsOnly

Command = { "Links", "Scan"}
for x = 1, #Command do
	me[ Command[x] ] = ChkBox( last , "TauntAwareCfg", Command[x] , me, CheckClick, TA.Text )
	last = me[ Command[x] ]
end
	
me.ScanDelay = Slider( last , "TauntAwareCfg", "ScanDelay", me , SliderMW , TA.Text, 1, 60, 1 )
last = me.ScanDelay
me.ScanDelay.Val = SliderEditBox( last , "TauntAwareCfg", "ScanDelay", me )
	
me.Tattle = ChkBox( last , "TauntAwareCfg", "Tattle" , me, CheckClick, TA.Text )
last = me.Tattle

--local items = {}
local TatModeVal
local level = 1

local function OnClick(self)
	local index = self:GetID()
	UIDropDownMenu_SetSelectedID( UIDROPDOWNMENU_OPEN_MENU, index)
	local TatModes = {"GROUP", "WHISPER", "SUMMARY" }
	TatModeVal = TatModes[index]
end

local function initialize(self, level)
	local info, selected
	local Command = {"GROUP", "WHISPER", "SUMMARY" }
	
	if TAS.TatMode == "GROUP" then
		selected = 1
	elseif TAS.TatMode == "WHISPER" then
		selected = 2
	else
		selected = 3
	end	
		
	for count = 1, #Command  do
		info = UIDropDownMenu_CreateInfo()
		info.text = Command[count]
		info.value = Command[count]
		info.func = OnClick
		if count == selected then
			TatModeVal = count
			info.checked = true
		end	
		UIDropDownMenu_AddButton(info, level)
	end
	
	UIDropDownMenu_SetSelectedID( UIDROPDOWNMENU_INIT_MENU , selected ) 
end

local TatModeText = me:CreateFontString( nil, "ARTWORK", "GameFontHighlightSmall" )
TatModeText:SetPoint( "TOPLEFT", last, "BOTTOMLEFT", 0, -0 )
TatModeText:SetPoint( "RIGHT", -32, 0 )
TatModeText:SetHeight( 32 )
TatModeText:SetJustifyH( "LEFT" )
TatModeText:SetJustifyV( "CENTER" )
TatModeText:SetText( TA.Text.TatMode )

last = TatModeText

me.TatMode = CreateFrame("Button", "TauntAwareCfgTatMode", me, "UIDropDownMenuTemplate")
me.TatMode.displayMode = "MENU"
me.TatMode:ClearAllPoints()
me.TatMode:SetPoint("TOPLEFT", last, "BOTTOMLEFT", 0, 0)
UIDropDownMenu_Initialize( me.TatMode, initialize)
UIDropDownMenu_SetWidth( me.TatMode, 100);
UIDropDownMenu_SetButtonWidth( me.TatMode, 124)
UIDropDownMenu_JustifyText( me.TatMode, "LEFT")
		
last = me.TatMode




--	End of frame



-- XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
-- X  Init / Reset the config panel to match current settings                                                     X
-- XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
--

me.Init = function(...)
	me.Enable:SetChecked( TAS.Enable )
	me.Full:SetChecked( TAS.Full )
	me.MF:SetChecked( TAS.MF )
	me.FadeDelay:SetValue( TAS.FadeDelay)
	me.FadeDelay.Val:SetCursorPosition( 0 )
	me.FadeDelay.Val:SetNumber( TAS.FadeDelay )
	ToggleDropDownMenu( nil, nil, me.TauntsOnly ) 
	ToggleDropDownMenu( nil, nil, me.TauntsOnly )
	if UIDROPDOWNMENU_OPEN_MENU == me.TauntsOnly then
		ToggleDropDownMenu( nil, nil, me.TauntsOnly )
	end
	me.Links:SetChecked( TAS.Links )
	me.Scan:SetChecked( TAS.Scan )
	me.ScanDelay:SetValue( TAS.ScanDelay)
	me.ScanDelay.Val:SetCursorPosition( 0 )
	me.ScanDelay.Val:SetNumber( TAS.ScanDelay )
	me.Tattle:SetChecked( TAS.Tattle )
	ToggleDropDownMenu( nil, nil, me.TatMode ) 
	ToggleDropDownMenu( nil, nil, me.TatMode )
	if UIDROPDOWNMENU_OPEN_MENU == me.TatMode then
		ToggleDropDownMenu( nil, nil, me.TatMode )
	end
	
end

-- Reset config panel and settings to DEFAULT
me.Reset = function(...)
	local Command = {"Enable", "Full", "MF", "FadeDelay", "TauntsOnly", "AlertTauntsOnly", "TattleTauntsOnly", "Links", "Scan", "ScanDelay", "Tattle", "TatMode"}
	for x = 1, #Command do
		TAS.Command[x] = TAD.Command[x]
	end
	me.Init()
end



me.refresh = function(self)
	me.Init()
end

me.default = function (self)
	me.Reset()
end

me.cancel = function (self)
	me.Init()
end


-- Save settings from config panel
me.okay = function(self)
	local Command = {"Enable", "Full", "MF", "Links", "Scan", "Tattle"}
	for x = 1, #Command do
		ChkBoxSave( me, Command[x], TAS)
	end
		SliderSave( me, "FadeDelay", TAS) -- Throttle Time Slider
		SliderSave( me, "ScanDelay", TAS) -- Throttle Time Slider
	
	if TAS.TauntsOnly ~= TauntsOnlyVal then
		TAS.TauntsOnly = TauntsOnlyVal
		if TAS.TauntsOnly == "on" then
			TAS.AlertTauntsOnly = on
			TAS.TattleTauntsOnly = on
		elseif TTAS.TauntsOnly == "off" then
			TAS.AlertTauntsOnly = off
			TAS.TattleTauntsOnly = off
		else
			TAS.AlertTauntsOnly = off
			TAS.TattleTauntsOnly = on
		end
	end
	
	if TAS.TatMode ~= TatModeVal then
		TAS.TatMode = TatModeVal
	end
	
	NickAlert.EventManager()
end

-- Register the config panel
InterfaceOptions_AddCategory( me )
