﻿--  ===============================
--	Tabard Addict - TabardAddict.lua
--	By: gmz323(Greg)
--  ===============================

-- Constants
local TABARD_ADDICT_VERSION = "2.07"
local TABARD_ADDICT_DATA_ROWS = 87

-- Locals
local TabardAddictServerData = {} -- equip data from server
local TabardAddictServerData_tooltiptable = {} -- table for tooltip display
local TabardAddictDoServerQuery;
local TabardAddictUpdateSuggestTable;

local CurrentTabardEntry_line = 0;
local CurrentTabardEntries_itemID = {};
local CurrentTabardEntries_itemLink = {};
local CurrentTabardSuggest_line = 0;
local CurrentTabardSuggest_itemID = {}; 
local CurrentTabardSuggest_itemLink = {};
local InfoFrameCurrent_itemID = 0;

local tempDisplayData = {} -- temp table built to show subset of data
local tempDisplayData_rowcount;
local tempSuggestData = {} -- temp table built to show subset of data
local tempSuggestData_rowcount;
local tempAchievementTooltipData = {} -- table holding achievement tooltip data
local tabardsEquipped = 0;
local taNameFilter = "";
local taLineAdded = false;
local taPlayerFaction = 0; -- 1=alliance, 2=horde
local taPlayerLevel = 0;
local taSuggestString = "";

-- Localized Strings
local L = TabardAddictLocalization;

-- config table defaults - saved per character
local TabardAddictConfigDefaults = 
	{
		CB_AO = 1,
		CB_HO = 1,
		CB_EQ = 1,
		CB_TCG = 1,
		CB_Other = 1,
		CB_NA = 1,
		CB_PVP = 1,
		CB_BCF = 1,
		CB_WotLKF = 1,
		CB_ATF = 1,
		CB_CF = 1,
		CB_SUGG_ACH = 1,
		CB_SUGG_QST = 1,
		CB_SUGG_CUR = 1,
		CB_INFO_EQUIP = 1,
	};

-- Slash commands
SLASH_TABARDADDICT1 = "/ta"
SLASH_TABARDADDICT2 = "/tabardaddict"

SlashCmdList["TABARDADDICT"] = function(msg, editbox)
	if frameTabardAddict:IsShown() then
		frameTabardAddict:Hide()
	else
		frameTabardAddict:Show()
	end
end

-- Debugging
local debugMode = false;

-- copied from ModelFrames.lua
local _, playerRaceSex = UnitRace("player");
do
	if ( UnitSex("player") == 2 ) then
		playerRaceSex = playerRaceSex.."Male";
	else
		playerRaceSex = playerRaceSex.."Female";
	end
end
	
--*****************************************************************************
--*****************************************************************************
local function DressUpTexturePath(raceFileName)
    -- Orc texture as default
    if ( not raceFileName ) then
        raceFileName = "Orc";
    end
 
    return "Interface\\DressUpFrame\\DressUpBackground-"..raceFileName;
end
 
--*****************************************************************************
--***************************************************************************** 
function SetTADressUpBackground()
    local race, fileName = UnitRace("player");
    local texture = DressUpTexturePath(fileName);
    TADressUpBackgroundTop:SetTexture(texture..1);
end

--*****************************************************************************
--*****************************************************************************
local function TabardAddict_GetStandingTxt(standingID)
	local standingTxt;
	
	local gender = UnitSex("player");

	if (standingID >= 1 and standingID <= 8) then
		if (gender == 3 ) then --female - important for non-us locale
			standingTxt = _G['FACTION_STANDING_LABEL'..standingID..'_FEMALE'];
		else
			standingTxt = _G['FACTION_STANDING_LABEL'..standingID];
		end;
	else
		standingTxt = "";
	end;
	
	return standingTxt;
end;

--*****************************************************************************
--*****************************************************************************
local function TabardAddict_BuildTooltipData()

	-- 621 - first tabard achievement
	local achievementID = 621;
	local i = 1;

	if (debugMode) then
		print("BuildTooltipData");
	end;
	
	while (achievementID ~= nil)
	do
		if (debugMode) then
			print("achievementID: " .. tostring(achievementID));
		end;
		local id, name, points, completed, month, day, year, description, flags, icon, rewardText, isGuildAch = GetAchievementInfo(achievementID);
		if (id ~= nil) then
			tempAchievementTooltipData[i] = {};
			tempAchievementTooltipData[i][1] = completed;
			tempAchievementTooltipData[i][2] = name;
			i = i + 1;
			local nextID, completed = GetNextAchievement(id);
			achievementID = nextID;
		else
			achievementID = nil;
		end;
	end;
	
end;

--*****************************************************************************
--*****************************************************************************
local function TabardAddict_CheckReputationRequirement(itemID)
	-- return 1(suggest) or 0(don't suggest)
	
	-- get reputation for this tabards faction -faction id in taTabardReqmtData[itemID][3]
	local name, description, standingID, barMin, barMax, barValue, atWarWith, canToggleAtWar, isHeader, isCollapsed, hasRep, isWatched, isChild = GetFactionInfoByID(taTabardReqmtData[itemID][3]);
	
	-- handle bad faction lookup
	if (name == nil) then
	  return 0;
	end;
	
	-- compare against required level - level in [4]
	if (standingID >= taTabardReqmtData[itemID][4]) then
		-- set taSuggestString - parse part of string out of FACTION_STANDING_CHANGED
		local findToken = string.find(FACTION_STANDING_CHANGED,"%%");
		local strFaction = string.sub(FACTION_STANDING_CHANGED, findToken, -2);
		taSuggestString = string.format(strFaction, TabardAddict_GetStandingTxt(taTabardReqmtData[itemID][4]), name);
		return 1;
	else
		return 0;
	end;
end;

--*****************************************************************************
--*****************************************************************************
local function TabardAddict_CheckQuestRequirement(itemID)
	-- return 1(suggest) or 0(don't suggest)
	
	-- get quest name from questid - taTabardReqmtData[itemID][3]
	-- get quest level from - taTabardReqmtData[itemID][4]
	local playerLevel = UnitLevel("player");
	
	if (playerLevel >=  taTabardReqmtData[itemID][4]) then
		if (1) then --quest config
			taSuggestString = L.SUGG_QUEST_TXT .. " " .. taTabardReqmtData[itemID][3];
			return 1;
		else
			return 0;
		end;
	end;
	return 0;
end;

--*****************************************************************************
--*****************************************************************************
local function TabardAddict_CheckAchievementRequirement(itemID)
	-- return 1(suggest) or 0(don't suggest)
	
	-- get achievement name from achievementid - taTabardReqmtData[itemID][3]
	-- get achievement level from taTabardReqmtData[itemID][4]
	local playerLevel = UnitLevel("player");

	-- achievement levels are currently 0 - update!!!
	if (playerLevel >=  taTabardReqmtData[itemID][4]) then
		-- get achievement name
		local id, name, points, completed, month, day, year, description, flags, icon, rewardText, isGuildAch = GetAchievementInfo(taTabardReqmtData[itemID][3]);
		if (name == nil) then
			return 0;
		end;
		taSuggestString = L.SUGG_ACHV_TXT .. name;
		return 1;
	else
		return 0;
	end;
end;

--*****************************************************************************
--*****************************************************************************
local function TabardAddict_CheckCurrencyRequirement(itemID)
	-- return 1(suggest) or 0(don't suggest)
	
	-- currency amount and name string - taTabardReqmtData[itemID][3]
	-- required level - taTabardReqmtData[itemID][4]
	local playerLevel = UnitLevel("player");
	if (playerLevel >=  taTabardReqmtData[itemID][4]) then
		taSuggestString = L.SUGG_CURRENCY_TXT .. taTabardReqmtData[itemID][3];
		return 1;
	else
		return 0;
	end;
end;

--*****************************************************************************
--*****************************************************************************
local function TabardAddict_CheckDropRequirement(itemID)
	-- return 1(suggest) or 0(don't suggest)
	
	-- mob id taTabardReqmtData[itemID][3]
	-- mob level taTabardReqmtData[itemID][4]
	local playerLevel = UnitLevel("player");
	if (playerLevel >=  taTabardReqmtData[itemID][4]) then
		-- set taSuggestString
		taSuggestString = L.SUGG_DROP_TXT .. taTabardReqmtData[itemID][3] .. " (" .. LEVEL_ABBR .. " " .. taTabardReqmtData[itemID][4] .. ")";
		return 1;
	else
		return 0;
	end;
end;

--*****************************************************************************
--*****************************************************************************
local function TabardAddict_CheckSpecialRequirement(itemID)

	-- handle the midsummer event tabards - 35279, 35280
	-- if one has been equipped dont suggest the other
	if (itemID == 35279) then
		if (TabardAddictServerData[35280] == true) then
			return 0; -- can't equip both tabards
		else
			return 1;
		end;
	end;
	if (itemID == 35280) then
		if (TabardAddictServerData[35279] == true) then
			return 0; -- can't equip both tabards
		else
			return 1;
		end;
	end;
	
	-- handle paladin blood elf
	if (itemID == 25549) then
		local class, classFileName = UnitClass("player");
		local race, raceFileName = UnitRace("player");
		
		if ( (strupper(classFileName) == "PALADIN") and (strupper(raceFileName) == "BLOODELF") ) then
			return 1;
		else
			return 0;
		end;
	end;
	
	-- handle draenei only
	if (itemID == 24344) then
		local race, raceFileName = UnitRace("player");
		
		if (strupper(raceFileName) == "DRAENEI") then
			return 1;
		else
			return 0;
		end;
	end;
	
	-- handle Battle of the Crimson Watch rewards
	-- if one has been equipped dont suggest the other
	if (itemID == 31404) then
		if (TabardAddictServerData[31405] == true) then
			return 0; -- can't equip both tabards
		else
			return 1;
		end;
	end;
	if (itemID == 31405) then
		if (TabardAddictServerData[31404] == true) then
			return 0; -- can't equip both tabards
		else
			return 1;
		end;
	end;
	
	return 1;
end;

--*****************************************************************************
--*****************************************************************************
local function TabardAddict_PopulateDisplayTable()
	
	local maintableRow, j, displayThisRow;
	
	wipe(tempDisplayData);
	
	tempDisplayData_rowcount = 0;
	
	-- This creates a temp table by joining local tabard data and server results
	for maintableRow in ipairs(taTabardData)
	do
		-- determine if this row should be displayed -- by Tabard Type
		if ((taTabardData[maintableRow][5] == 0) and (TabardAddictConfig.CB_Other == 1)) then
			displayThisRow = 1;
		elseif ((taTabardData[maintableRow][5] == 1) and (TabardAddictConfig.CB_PVP == 1)) then
			displayThisRow = 1; 	
		elseif ((taTabardData[maintableRow][5] == 2) and (TabardAddictConfig.CB_Other == 1)) then
			displayThisRow = 1; 	
		elseif ((taTabardData[maintableRow][5] == 3) and (TabardAddictConfig.CB_TCG == 1)) then
			displayThisRow = 1; 
		elseif ((taTabardData[maintableRow][5] == 4) and (TabardAddictConfig.CB_NA == 1)) then
			displayThisRow = 1; 
		elseif ((taTabardData[maintableRow][5] == 6) and (TabardAddictConfig.CB_BCF == 1)) then
			displayThisRow = 1; 
		elseif ((taTabardData[maintableRow][5] == 7) and (TabardAddictConfig.CB_WotLKF == 1)) then
			displayThisRow = 1; 
		elseif ((taTabardData[maintableRow][5] == 8) and (TabardAddictConfig.CB_ATF == 1)) then
			displayThisRow = 1; 
		elseif ((taTabardData[maintableRow][5] == 9) and (TabardAddictConfig.CB_CF == 1)) then
			displayThisRow = 1; 	
		else
			displayThisRow = 0;
		end;
		
		-- determine if this row should be filtered -- Filter out by Alliance/Horde
		if ((taTabardData[maintableRow][6] == 1) and (TabardAddictConfig.CB_AO == 0)) then
			displayThisRow = 0;
		elseif ((taTabardData[maintableRow][6] == 2) and (TabardAddictConfig.CB_HO == 0)) then
			displayThisRow = 0; 
		end;
		-- hide equipped tabards
		local iID = taTabardData[maintableRow][1];
		if (iID ~= nil) then
			if ( (TabardAddictServerData[iID] == true ) and (TabardAddictConfig.CB_EQ == 0)) then
				displayThisRow = 0; 
			end;
		end;
		
		-- handle search box
		if ((displayThisRow == 1) and (taNameFilter ~= "")) then
			if( string.find(string.lower(taTabardData[maintableRow][2]),string.lower(taNameFilter)) == nil ) then
				displayThisRow = 0;
			end;
		end;
		
		if (displayThisRow == 1) then
			tempDisplayData_rowcount = tempDisplayData_rowcount + 1;
			tempDisplayData[tempDisplayData_rowcount] = {};     -- create a new row
			for j=1,4 do -- copy first 4 column
				tempDisplayData[tempDisplayData_rowcount][j] = taTabardData[maintableRow][j];
			end
			-- column 6 - tabard type
			tempDisplayData[tempDisplayData_rowcount][6] = taTabardData[maintableRow][5];
			-- column 7 - alliance or horde indicator
			tempDisplayData[tempDisplayData_rowcount][7] = taTabardData[maintableRow][6];
		  
			-- init equipped bool
			tempDisplayData[tempDisplayData_rowcount][5] = false;
			
			-- set equipped bool from server data
			local iID = taTabardData[maintableRow][1];
			if (iID ~= nil) then
				tempDisplayData[tempDisplayData_rowcount][5] = TabardAddictServerData[iID];
			end;
			
		end;
    end;
	TabardAddictTab1.taTabardTotalShowing:SetText(string.format(L.TABARDS_SHOWN, tempDisplayData_rowcount));
end;

--*****************************************************************************
--*****************************************************************************
local function TabardAddict_PopulateSuggestionsTable()

	-- if the suggest table is nil force an update
	if (tempSuggestData == nil) then
		TabardAddictUpdateSuggestTable = true;
	end;
	
	-- Only need to populate this table once - and when server date is rechecked
	if (TabardAddictUpdateSuggestTable == true) then
	
		if (debugMode) then
			print("Tabard Addict: PopulateSuggestionsTable() called");
		end;
	
		local maintableRow, j, suggestThisRow;
		wipe(tempSuggestData);
		tempSuggestData_rowcount = 0;
		TabardAddictUpdateSuggestTable = false;
		
		-- This creates a temp table by joining local tabard data and server results
		for maintableRow in ipairs(taTabardData)
		do
			-- init var
			suggestThisRow = 0;
			--get item id
			local iID = taTabardData[maintableRow][1];
			
			-- check if been equipped
			if (TabardAddictServerData[iID] == false) then
				suggestThisRow = 1;
			end;
			-- check if currently available 
			if (suggestThisRow == 1) then
				if (taTabardReqmtData[iID][0] ~= 1) then
					suggestThisRow = 0;
				end;
			end;
			-- check alliance(1) and horde(2) factions
			if (suggestThisRow == 1) then
				if (taTabardReqmtData[iID][1] == 1 and taPlayerFaction ~= 1 ) then
					suggestThisRow = 0;
				elseif (taTabardReqmtData[iID][1] == 2 and taPlayerFaction ~= 2 ) then
					suggestThisRow = 0;
				else
					suggestThisRow = 1;
				end;
			end;
			
			-- init Suggestion String
			taSuggestString = "";
			
			-- check requirements
			if (suggestThisRow == 1) then
				-- check the rep/quest/etc requirements
				if (taTabardReqmtData[iID][2] == 0) then
					suggestThisRow = 1;
					taSuggestString = L.SUGG_NOREQ_TXT;
				elseif (taTabardReqmtData[iID][2] == 1) then
					-- requires reputation 
					suggestThisRow = TabardAddict_CheckReputationRequirement(iID);
				elseif (taTabardReqmtData[iID][2] == 2 and TabardAddictConfig.CB_SUGG_QST == 1) then
					-- requires quest completion
					suggestThisRow = TabardAddict_CheckQuestRequirement(iID);
				elseif (taTabardReqmtData[iID][2] == 3 and TabardAddictConfig.CB_SUGG_ACH == 1) then
					-- requires achievement completion
					suggestThisRow = TabardAddict_CheckAchievementRequirement(iID);
				elseif (taTabardReqmtData[iID][2] == 4 and TabardAddictConfig.CB_SUGG_CUR == 1) then
					-- requires currency to purchase
					suggestThisRow = TabardAddict_CheckCurrencyRequirement(iID);
				elseif (taTabardReqmtData[iID][2] == 5) then
					-- requires drop from mob
					suggestThisRow = TabardAddict_CheckDropRequirement(iID);
				else
					suggestThisRow = 0;
				end;
			end;
			
			-- handle special cases - class/race tabards, event tabards, etc...
			if (suggestThisRow == 1) then
				if (taTabardReqmtSpecial[iID]) then
					suggestThisRow = TabardAddict_CheckSpecialRequirement(iID);
				end;
			end;
			
			-- add to table if passed all the checks
			if (suggestThisRow == 1) then
				tempSuggestData_rowcount = tempSuggestData_rowcount + 1;
				tempSuggestData[tempSuggestData_rowcount] = {};     -- create a new row
				for j=1,4 do -- copy first 4 column
					tempSuggestData[tempSuggestData_rowcount][j] = taTabardData[maintableRow][j];
				end;
				-- column 5 - been equipped - must be false
				tempSuggestData[tempSuggestData_rowcount][5] = false;
				-- column 6 - tabard type
				tempSuggestData[tempSuggestData_rowcount][6] = taTabardData[maintableRow][5];
				-- column 7 - alliance or horde indicator
				tempSuggestData[tempSuggestData_rowcount][7] = taTabardData[maintableRow][6];
				-- column 8 - suggestion test string to be displayed
				tempSuggestData[tempSuggestData_rowcount][8] = taSuggestString;
			end;
		end;
	end;
	TabardAddictTab4.taTabardTotalShowing:SetText(string.format(L.TABARDS_SUGGESTED, tempSuggestData_rowcount));
end;

--*****************************************************************************
--*****************************************************************************
local function TabardAddict_SortDisplayTable()

	-- currently sorting only on tabard name
	table.sort(tempDisplayData, function(a,b) return a[2]<b[2] end);
	
end;
--
local function TabardAddict_SortSuggestionsTable()

	-- currently sorting only on tabard name
	table.sort(tempSuggestData, function(a,b) return a[2]<b[2] end);
	
end;

--*****************************************************************************
--*****************************************************************************
local function TabardAddict_CleanConfigVars()
	
	local key, value;

	-- loop through the client stored variables - remove those no longer used
	for key,value in pairs(TabardAddictConfig) do 
		if (TabardAddictConfigDefaults[key] == nil) then
			TabardAddictConfig[key] = nil;
			if (debugMode) then
				print("Tabard Addict - Removing old config value: " .. key);
			end;
		end;
	end;
	
end;

--*****************************************************************************
--*****************************************************************************
function TabardAddict_OnEvent(self, event, ...)
	
	
	-- Check if player changed tabard
	if (event == "PLAYER_EQUIPMENT_CHANGED") then
		
		local slot, hasItem = ...;
		if hasItem == nil then 
			hasItem = 0;
		end;
		
		-- addon is shown - do an update and return to tab1
		if frameTabardAddict:IsShown() then	
			-- if tabard slot and item put into slot - refresh listing and count
			if ( (slot == INVSLOT_TABARD) and (hasItem == 1) ) then
				TabardAddictInfoFrame:Hide();
				TabardAddictDoServerQuery = true;
				TabardAddict_OnShow(self);
			end;
			if (debugMode) then
				print("Registered Event = " .. event .. "; slot = " .. slot .. " hasItem = " .. hasItem);
			end;
		else
			-- addon not shown - updated on next show event
			if ( (slot == INVSLOT_TABARD) and (hasItem == 1) ) then
				TabardAddictInfoFrame:Hide();
				TabardAddictDoServerQuery = true;
			end;
			if (debugMode) then
				print("Not Shown - Registered Event = " .. event .. "; slot = " .. slot .. " hasItem = " .. hasItem);
			end;
		end;
	end;
	if (event == "ADDON_LOADED") then
		local arg1 = ...;
		
		if (arg1 == "TabardAddict") then
			--Show/Hide character frame launcher
			frameTabardAddictCharFrameLauncher:Show();
			
			-- check for nil global config values - if not exist then default to on (1)
			if (TabardAddictConfig == nil) then
				TabardAddictConfig = TabardAddictConfigDefaults;
			end;
			-- check for nil on each config item - in case a new one is added
			if (TabardAddictConfig.CB_AO == nil) then
				TabardAddictConfig.CB_AO = TabardAddictConfigDefaults.CB_AO;
			end;
			if (TabardAddictConfig.CB_HO == nil) then
				TabardAddictConfig.CB_HO  = TabardAddictConfigDefaults.CB_HO;
			end;
			if (TabardAddictConfig.CB_EQ == nil) then
				TabardAddictConfig.CB_EQ  = TabardAddictConfigDefaults.CB_EQ;
			end;
			if (TabardAddictConfig.CB_TCG == nil) then
				TabardAddictConfig.CB_TCG = TabardAddictConfigDefaults.CB_TCG;
			end;
			if (TabardAddictConfig.CB_Other == nil) then
				TabardAddictConfig.CB_Other = TabardAddictConfigDefaults.CB_Other;
			end;
			if (TabardAddictConfig.CB_NA == nil) then
				TabardAddictConfig.CB_NA = TabardAddictConfigDefaults.CB_NA;
			end;
			if (TabardAddictConfig.CB_PVP == nil) then
				TabardAddictConfig.CB_PVP = TabardAddictConfigDefaults.CB_PVP;
			end;
			if (TabardAddictConfig.CB_BCF == nil) then
				TabardAddictConfig.CB_BCF = TabardAddictConfigDefaults.CB_BCF;
			end;
			if (TabardAddictConfig.CB_WotLKF == nil) then
				TabardAddictConfig.CB_WotLKF = TabardAddictConfigDefaults.CB_WotLKF;
			end;
			if (TabardAddictConfig.CB_ATF == nil) then
				TabardAddictConfig.CB_ATF = TabardAddictConfigDefaults.CB_ATF;
			end;
			if (TabardAddictConfig.CB_CF == nil) then
				TabardAddictConfig.CB_CF = TabardAddictConfigDefaults.CB_CF;
			end;
			if (TabardAddictConfig.CB_SUGG_ACH == nil) then
				TabardAddictConfig.CB_SUGG_ACH = TabardAddictConfigDefaults.CB_SUGG_ACH;
			end;
			if (TabardAddictConfig.CB_SUGG_QST == nil) then
				TabardAddictConfig.CB_SUGG_QST = TabardAddictConfigDefaults.CB_SUGG_QST;
			end;
			if (TabardAddictConfig.CB_SUGG_CUR == nil) then
				TabardAddictConfig.CB_SUGG_CUR = TabardAddictConfigDefaults.CB_SUGG_CUR;
			end;
			if (TabardAddictConfig.CB_INFO_EQUIP == nil) then
				TabardAddictConfig.CB_INFO_EQUIP = TabardAddictConfigDefaults.CB_INFO_EQUIP;
			end;
			
			-- cleanup old config vars
			TabardAddict_CleanConfigVars();
			
		end;
	end;
	if (event == "UPDATE_FACTION") then
		-- do server query in case player has gained enough rep for a new tabard
		TabardAddictDoServerQuery = true;
	end;
end
 
--*****************************************************************************
--*****************************************************************************
function TabardAddict_GetServerData() 

	local j,m,n,r,a,b;
	
	wipe(TabardAddictServerData);
	
	-- force update of Suggest table
	TabardAddictUpdateSuggestTable = true;
	
	-- id 1020 = ten tabards achievement
	a=GetAchievementCriteriaInfo 
	for b=1,TABARD_ADDICT_DATA_ROWS
	do 
		_,_,_,_,_,_,_,_,_,j = a(1020,b); 
		n,_,m,_,_,_,_,r,_,_ = a(j);
		TabardAddictServerData[r] = m; -- save "criteria met" true/false
		-- update tooltip table
		TabardAddictServerData_tooltiptable[r] = m;  -- save "criteria met" true/false
		if (m == true) then
			-- increment total tabards equipped
			tabardsEquipped=tabardsEquipped + 1;
		end;
	end;
	-- Build tooltip data
	TabardAddict_BuildTooltipData();
end;

--*****************************************************************************
--*****************************************************************************
function TabardAddictScrollBar_Update()
	local line; -- 1 through 8 of our window to scroll
	local lineplusoffset; -- an index into our data calculated from the scroll offset
	
	FauxScrollFrame_Update(TabardAddictScrollBar,tempDisplayData_rowcount,8,40);
	for line=1,8 
	do
		lineplusoffset = line + FauxScrollFrame_GetOffset(TabardAddictScrollBar);
		
		-- set alpha values for each row
		getglobal("TabardAddictEntry"..line).TabardAddictButtonBack:SetAlpha(0.35);
		getglobal("TabardAddictEntry"..line).TabardAddictButtonHighlight:SetAlpha(0.70);
		
		if lineplusoffset <= tempDisplayData_rowcount then
			getglobal("TabardAddictEntry"..line):Enable();
			getglobal("TabardAddictEntry"..line).TabardName:SetText(tempDisplayData[lineplusoffset][2]);
			getglobal("TabardAddictEntry"..line).TabardName:Show();
			
			-- check if equipped
			if (tempDisplayData[lineplusoffset][5] == true) then
				getglobal("TabardAddictEntry"..line).TabardEquipped:SetText(L.BEEN_EQUIPPED.."|cff00FF00"..L.YES.."|r");
				-- show overlay on equipped tabards
				getglobal("TabardAddictEntry"..line).TabardIconOverlay:Show(); 
				getglobal("TabardAddictEntry"..line).TabardIconOverlay:SetDrawLayer("OVERLAY",5);
			else
				getglobal("TabardAddictEntry"..line).TabardEquipped:SetText(L.BEEN_EQUIPPED.."|cffFF0000"..L.NO.."|r");
				getglobal("TabardAddictEntry"..line).TabardIconOverlay:Hide();
			end
			getglobal("TabardAddictEntry"..line).TabardEquipped:Show();
			
			-- set tabard icon texture
			getglobal("TabardAddictEntry"..line).TabardIcon:SetTexture(tempDisplayData[lineplusoffset][4]);
			getglobal("TabardAddictEntry"..line).TabardIcon:Show();
			
			-- set local vars
			CurrentTabardEntries_itemID[line] = tempDisplayData[lineplusoffset][1];
			CurrentTabardEntries_itemLink[line] = tempDisplayData[lineplusoffset][3];
			
			-- set faction icon
			if (tempDisplayData[lineplusoffset][7] == 2) then
				getglobal("TabardAddictEntry"..line).TabardFactionIcon:SetTexture("Interface\\BattlefieldFrame\\Battleground-Horde.png");
				getglobal("TabardAddictEntry"..line).TabardFactionIcon:Show();
				getglobal("TabardAddictEntry"..line).TabardFactionIcon:SetDrawLayer("OVERLAY",7);
			elseif (tempDisplayData[lineplusoffset][7] == 1) then
				getglobal("TabardAddictEntry"..line).TabardFactionIcon:SetTexture("Interface\\BattlefieldFrame\\Battleground-Alliance.png");
				getglobal("TabardAddictEntry"..line).TabardFactionIcon:Show();
				getglobal("TabardAddictEntry"..line).TabardFactionIcon:SetDrawLayer("OVERLAY",7);
			else
				getglobal("TabardAddictEntry"..line).TabardFactionIcon:Hide();
			end;
			
			-- update tooltip
			if (CurrentTabardEntry_line > 0) then
				TabardAddictEntryButton_OnEnter(CurrentTabardEntry_line);
			end;
			
		else
			getglobal("TabardAddictEntry"..line):Disable();
			getglobal("TabardAddictEntry"..line).TabardName:Hide();
			getglobal("TabardAddictEntry"..line).TabardEquipped:Hide();
			getglobal("TabardAddictEntry"..line).TabardIcon:Hide();
			getglobal("TabardAddictEntry"..line).TabardIconOverlay:Hide();
			getglobal("TabardAddictEntry"..line).TabardFactionIcon:Hide();
			-- set local vars
			CurrentTabardEntries_itemID[line] = 0;
			CurrentTabardEntries_itemLink[line] = 0;
			
			-- warn user
			if ((tempDisplayData_rowcount == 0) and (line == 2)) then
				getglobal("TabardAddictEntry"..line).TabardName:SetText(L.ERROR1);
				getglobal("TabardAddictEntry"..line).TabardName:Show();
			end;
		end;
	end;
end;

--*****************************************************************************
--*****************************************************************************
function TabardAddictScrollBar2_Update()
	
	local line; -- 1 through 8 of our window to scroll
	local lineplusoffset; -- an index into our data calculated from the scroll offset
	
	FauxScrollFrame_Update(TabardAddictScrollBar2,tempSuggestData_rowcount,8,40);

	for line=1,8 
	do
		lineplusoffset = line + FauxScrollFrame_GetOffset(TabardAddictScrollBar2);
		
		-- set alpha values for each row
		getglobal("TabardAddictSugg"..line).TabardAddictButtonBack:SetAlpha(0.35);
		getglobal("TabardAddictSugg"..line).TabardAddictButtonHighlight:SetAlpha(0.70);
		
		if (lineplusoffset <= tempSuggestData_rowcount) then
			getglobal("TabardAddictSugg"..line):Enable();
			getglobal("TabardAddictSugg"..line).TabardName:SetText(tempSuggestData[lineplusoffset][2]);
			getglobal("TabardAddictSugg"..line).TabardName:Show();

			-- set suggestion text
			local displayStr = tempSuggestData[lineplusoffset][8];
			getglobal("TabardAddictSugg"..line).TabardEquipped:SetText(displayStr);
			getglobal("TabardAddictSugg"..line).TabardEquipped:Show();
			
			-- set tabard icon texture
			getglobal("TabardAddictSugg"..line).TabardIcon:SetTexture(tempSuggestData[lineplusoffset][4]);
			getglobal("TabardAddictSugg"..line).TabardIcon:Show();
			
			-- set overlay texture??
			--getglobal("TabardAddictSugg"..line).TabardIconSuggOverlay:Show();
			
			-- set local vars
			CurrentTabardSuggest_itemID[line] = tempSuggestData[lineplusoffset][1];
			CurrentTabardSuggest_itemLink[line] = tempSuggestData[lineplusoffset][3];
			
			-- set faction icon
			if (tempSuggestData[lineplusoffset][7] == 2) then
				getglobal("TabardAddictSugg"..line).TabardFactionIcon:SetTexture("Interface\\BattlefieldFrame\\Battleground-Horde.png");
				getglobal("TabardAddictSugg"..line).TabardFactionIcon:Show();
				getglobal("TabardAddictSugg"..line).TabardFactionIcon:SetDrawLayer("OVERLAY",7);
			elseif (tempSuggestData[lineplusoffset][7] == 1) then
				getglobal("TabardAddictSugg"..line).TabardFactionIcon:SetTexture("Interface\\BattlefieldFrame\\Battleground-Alliance.png");
				getglobal("TabardAddictSugg"..line).TabardFactionIcon:Show();
				getglobal("TabardAddictSugg"..line).TabardFactionIcon:SetDrawLayer("OVERLAY",7);
			else
				getglobal("TabardAddictSugg"..line).TabardFactionIcon:Hide();
			end;
			
			-- update tooltip
			if (CurrentTabardSuggest_line > 0) then
				TabardAddictSuggButton_OnEnter(CurrentTabardSuggest_line);
			end;
		else
			getglobal("TabardAddictSugg"..line):Disable();
			getglobal("TabardAddictSugg"..line).TabardName:Hide();
			getglobal("TabardAddictSugg"..line).TabardEquipped:Hide();
			getglobal("TabardAddictSugg"..line).TabardIcon:Hide();
			getglobal("TabardAddictSugg"..line).TabardIconOverlay:Hide();
			getglobal("TabardAddictSugg"..line).TabardFactionIcon:Hide();
			-- set local vars
			CurrentTabardSuggest_itemID[line] = 0;
			CurrentTabardSuggest_itemLink[line] = 0;
			
			-- if no suggestions to show - display message to user
			if ((tempSuggestData_rowcount == 0) and (line == 2)) then
				getglobal("TabardAddictSugg"..line).TabardName:SetText(L.ERROR2);
				getglobal("TabardAddictSugg"..line).TabardName:Show();
			end;
		end;
	end;
end;

--*****************************************************************************
--*****************************************************************************
function TabardAddictHideInfoButtons()
	for row=1,8
	do
		getglobal("TabardAddictInfo"..row):Hide();
		getglobal("TabardAddictSuggInfo"..row):Hide();
	end;
end;

--*****************************************************************************
--*****************************************************************************
function TabardAddictEntryButton_OnEnter(line)
	CurrentTabardEntry_line = line;
	CurrentTabardSuggest_line = 0;
	-- Hide all info buttons 
	TabardAddictHideInfoButtons();
	-- Show Info button
	getglobal("TabardAddictInfo"..line):Show();
	
	if (debugMode) then
		print(tostring(GetTime()) .. " EntryButton - OnEnter handled - line:" .. tostring(line));
	end;
end;
--
function TabardAddictSuggButton_OnEnter(line)
	CurrentTabardSuggest_line = line;
	CurrentTabardEntry_line = 0;
	-- Hide all info buttons 
	TabardAddictHideInfoButtons();
	-- Show Info button
	getglobal("TabardAddictSuggInfo"..line):Show();
	
	if (debugMode) then
		print(tostring(GetTime()) .. " SuggButton - OnEnter handled - line:" .. tostring(line));
	end;
end;
--*****************************************************************************
--*****************************************************************************
function TabardAddictEntryButton_OnLeave()
	ResetCursor();
	GameTooltip:Hide();
	
	if (debugMode) then
		print(tostring(GetTime()) .. " EntryButton - OnLeave handled");
	end;
	
	if (CurrentTabardEntry_line == 0) then
		return;
	end;
	
	-- Hide all info buttons if not over one
	if (getglobal("TabardAddictInfo"..CurrentTabardEntry_line):IsMouseOver() == false) then
		TabardAddictHideInfoButtons();
		CurrentTabardEntry_line = 0;
	end;
	
end;
--
function TabardAddictSuggButton_OnLeave()
	ResetCursor();
	GameTooltip:Hide();
	
	if (debugMode) then
		print(tostring(GetTime()) .. " SuggButton - OnLeave handled");
	end;
	
	if (CurrentTabardSuggest_line == 0) then
		return;
	end;
	
	-- Hide all info buttons if not over one
	if (getglobal("TabardAddictSuggInfo"..CurrentTabardSuggest_line):IsMouseOver() == false) then
		TabardAddictHideInfoButtons();
		CurrentTabardSuggest_line = 0;
	end;
	
end;
--*****************************************************************************
--*****************************************************************************
function TabardAddictEntryButton_OnUpdate(line)
	
	local itemID = CurrentTabardEntries_itemID[line];
	
	-- Show tooltip if over tabard icon
	if ( (MouseIsOver(getglobal("TabardAddictEntry"..line).TabardIcon)) and (itemID > 0) ) then
		-- Hide info frame
		TabardAddictInfoFrame:Hide();
		
		GameTooltip:SetOwner(frameTabardAddict, "ANCHOR_RIGHT", 0, -120);
		GameTooltip:SetHyperlink("item:"..itemID);
		GameTooltip:Show();
		-- if ctrl is down show inspect cursor else reset it
		if ( IsModifiedClick("DRESSUP") ) then
			ShowInspectCursor();
		else
			ResetCursor();
		end;
	else
		-- not over icon - hide tooltip and reset cursor
		GameTooltip:Hide();
		ResetCursor();
	end;
	
end;
--
function TabardAddictSuggButton_OnUpdate(line)

	local itemID = CurrentTabardSuggest_itemID[line];
	
	-- Show tooltip if over tabard icon
	if ( (MouseIsOver(getglobal("TabardAddictSugg"..line).TabardIcon)) and (itemID > 0) ) then
		-- Hide info frame
		TabardAddictInfoFrame:Hide();
		
		GameTooltip:SetOwner(frameTabardAddict, "ANCHOR_RIGHT", 0, -120);
		GameTooltip:SetHyperlink("item:"..itemID);
		GameTooltip:Show();
		-- if ctrl is down show inspect cursor else reset it
		if ( IsModifiedClick("DRESSUP") ) then
			ShowInspectCursor();
		else
			ResetCursor();
		end;
	else
		-- not over icon - hide tooltip and reset cursor
		GameTooltip:Hide();
		ResetCursor();
	end;
end;

--*****************************************************************************
--*****************************************************************************
function TabardAddictEntryButton_OnModifiedClick(line)
	local itemID = CurrentTabardEntries_itemID[line];
	local itemLink = CurrentTabardEntries_itemLink[line];
	
	-- If there was a DRESSUP or CHATLINK click over a tabard icon handle it
	if ( (MouseIsOver(getglobal("TabardAddictEntry"..line).TabardIcon)) and (itemID > 0) ) then
		if ( IsModifiedClick("DRESSUP") ) then
			DressUpItemLink(itemID);
		elseif ( IsModifiedClick("CHATLINK") ) then
			if (ChatEdit_GetActiveWindow()) then
				ChatEdit_InsertLink(itemLink);
			end;
		end;
	end;
end;
--
function TabardAddictSuggButton_OnModifiedClick(line)
	local itemID = CurrentTabardSuggest_itemID[line];
	local itemLink = CurrentTabardSuggest_itemLink[line];
	
	-- If there was a DRESSUP or CHATLINK click over a tabard icon handle it
	if ( (MouseIsOver(getglobal("TabardAddictSugg"..line).TabardIcon)) and (itemID > 0) ) then
		if ( IsModifiedClick("DRESSUP") ) then
			DressUpItemLink(itemID);
		elseif ( IsModifiedClick("CHATLINK") ) then
			if (ChatEdit_GetActiveWindow()) then
				ChatEdit_InsertLink(itemLink);
			end;
		end;
	end;
end;

--*****************************************************************************
--*****************************************************************************
function TabardAddictTab_OnClick(self, tabID)
	if ( not tabID ) then
		tabID = self:GetID();
	end;
	PanelTemplates_SetTab(frameTabardAddict, tabID);
	taNameFilter = "";
	TabardAddictHideInfoButtons();
	CurrentTabardEntry_line = 0;
	CurrentTabardSuggest_line = 0;
	-- Hide info frame
	if (TabardAddictInfoFrame:IsShown()) then
		TabardAddictInfoFrame:Hide();
	end;
	
	
	if ( tabID == 1 ) then
		-- Tabards tab clicked
		TabardAddictScrollBar:Show();
		TabardAddictScrollBar2:Hide();
		TabardAddictTab1:Show();
		TabardAddictTab2:Hide();
		TabardAddictTab3:Hide();
		TabardAddictTab4:Hide();
		-- populate the display table
		TabardAddict_PopulateDisplayTable();
		-- sort the display table
		TabardAddict_SortDisplayTable();
		-- initial display
		TabardAddictScrollBar_Update();
		TabardAddictShowTabards();
		TabardAddictHideSuggestions();
	elseif ( tabID == 2 ) then
		-- Config tab clicked
		TabardAddictScrollBar:Hide();
		TabardAddictScrollBar2:Hide();
		TabardAddictTab1:Hide();
		TabardAddictTab2:Show();
		TabardAddictTab3:Hide();
		TabardAddictTab4:Hide();
		-- set checkbox values
		CheckButtonAO:SetChecked(TabardAddictConfig.CB_AO);
		CheckButtonHO:SetChecked(TabardAddictConfig.CB_HO);
		CheckButtonEQ:SetChecked(TabardAddictConfig.CB_EQ);
		CheckButtonTCG:SetChecked(TabardAddictConfig.CB_TCG);
		CheckButtonOther:SetChecked(TabardAddictConfig.CB_Other);
		CheckButtonNA:SetChecked(TabardAddictConfig.CB_NA);
		CheckButtonPVP:SetChecked(TabardAddictConfig.CB_PVP);
		CheckButtonBCF:SetChecked(TabardAddictConfig.CB_BCF);
		CheckButtonWotLKF:SetChecked(TabardAddictConfig.CB_WotLKF);
		CheckButtonATF:SetChecked(TabardAddictConfig.CB_ATF);
		CheckButtonCF:SetChecked(TabardAddictConfig.CB_CF);
		CheckButtonSuggAch:SetChecked(TabardAddictConfig.CB_SUGG_ACH);
		CheckButtonSuggQst:SetChecked(TabardAddictConfig.CB_SUGG_QST);
		CheckButtonSuggCur:SetChecked(TabardAddictConfig.CB_SUGG_CUR);
		TabardAddictHideTabards();
		TabardAddictHideSuggestions();
	elseif ( tabID == 3 ) then
		-- About tab clicked
		TabardAddictScrollBar:Hide();
		TabardAddictScrollBar2:Hide();
		TabardAddictTab1:Hide();
		TabardAddictTab2:Hide();
		TabardAddictTab3:Show();
		TabardAddictTab4:Hide();
		TabardAddictHideTabards();
		TabardAddictHideSuggestions();
	elseif ( tabID == 4 ) then	
		-- Suggestions tab clicked
		TabardAddictScrollBar:Hide();
		TabardAddictScrollBar2:Show();
		TabardAddictTab1:Hide();
		TabardAddictTab2:Hide();
		TabardAddictTab3:Hide();
		TabardAddictTab4:Show();
		-- populate the suggestions table
		TabardAddict_PopulateSuggestionsTable();
		-- sort the suggestions table
		TabardAddict_SortSuggestionsTable();
		-- initial display
		TabardAddictHideTabards();
		TabardAddictShowSuggestions();
		TabardAddictScrollBar2_Update();
	end;
	PlaySound("igCharacterInfoTab");
end;

--*****************************************************************************
--*****************************************************************************
function TabardAddictInfoButton_OnClick()
	PlaySound("igInventoryRotateCharacter");
	
	if (TabardAddictInfoFrame:IsShown() == nil) then
		TabardAddictInfoFrame:Show();
		CheckButtonInfoDressUp.fs:SetText(L.CONFIG_INFO_EQUIP);
		CheckButtonInfoDressUp:SetChecked(TabardAddictConfig.CB_INFO_EQUIP);
	end;
	
	-- Get Item ID
	local itemID = 0, itemName;
	InfoFrameCurrent_itemID = 0;
	
	if (CurrentTabardEntry_line > 0) then
		itemID = CurrentTabardEntries_itemID[CurrentTabardEntry_line];
		itemName = getglobal("TabardAddictEntry"..CurrentTabardEntry_line).TabardName:GetText();
	elseif (CurrentTabardSuggest_line > 0) then
		itemID = CurrentTabardSuggest_itemID[CurrentTabardSuggest_line];
		itemName = getglobal("TabardAddictSugg"..CurrentTabardSuggest_line).TabardName:GetText();
	else 
		return;
	end;
	
	TabardAddictInfoFrame.TabardAddictInfoName:SetText(itemName);
	TabardAddictInfoFrame.EditBox:SetText(L.ITEM_INFO_URL..tostring(itemID));
	
	-- save Item ID
	InfoFrameCurrent_itemID = itemID;
	
	-- TryOn item
	if (CheckButtonInfoDressUp:GetChecked() == 1) then
		TabardAddictDressUpModel:Dress();
	else
		TabardAddictDressUpModel:Undress();
	end;
	TabardAddictDressUpModel:TryOn(itemID);
	
	-- debug
	if (debugMode) then
		local x,y,z = TabardAddictDressUpModel:GetPosition();
		print("x,y,z position = " .. tostring(x) .. ", " .. tostring(y) .. ", " .. tostring(z));
	end;
	
end;

--*****************************************************************************
--*****************************************************************************
function TabardAddict_InfoFrameShowEquipment_OnClick(self)
	
	-- Get Tabard Item
	if (CheckButtonInfoDressUp:GetChecked() == 1) then
		TabardAddictConfig.CB_INFO_EQUIP = 1; -- save config setting 
		TabardAddictDressUpModel:Dress();
		TabardAddictDressUpModel:TryOn(InfoFrameCurrent_itemID);
	else
		TabardAddictConfig.CB_INFO_EQUIP = 0; -- save config setting
		TabardAddictDressUpModel:Undress();
		TabardAddictDressUpModel:TryOn(InfoFrameCurrent_itemID);
	end;

end;

--*****************************************************************************
--*****************************************************************************
function TabardAddictLauncher_OnClick(self)

	PlaySound("igMainMenuOptionCheckBoxOn");
	
	if frameTabardAddict:IsShown() then
		frameTabardAddict:Hide()
	else
		frameTabardAddict:Show()
	end;
end;

--*****************************************************************************
--*****************************************************************************
function TabardAddict_OnShow(self)
	
	local tabardsNextAchievement = 0;
	
	PlaySound("igCharacterInfoOpen");
	
	-- set description text
	TabardAddictTab1.taDescText:SetText(string.format(L.TABARD_TITLE, UnitName("player")));
	
	if (TabardAddictDoServerQuery == true) then
		-- reset # of equipped tabards
		tabardsEquipped = 0;
		-- query server for data
		TabardAddict_GetServerData();
		TabardAddictDoServerQuery = false;
	end;

	-- populate counts
	if (tabardsEquipped >= 30) then
		tabardsNextAchievement = "NA";
	elseif (tabardsEquipped >= 25) then
		tabardsNextAchievement = 30;
	elseif (tabardsEquipped >= 10) then
		tabardsNextAchievement = 25;
	elseif (tabardsEquipped >= 1) then
		tabardsNextAchievement = 10;
	else
		tabardsNextAchievement = 1;
	end;
	
	-- populate the display table
	TabardAddict_PopulateDisplayTable();
	-- sort the display table
	TabardAddict_SortDisplayTable();
	-- initial display
	TabardAddictScrollBar_Update();
	-- populate the suggestions table
	TabardAddict_PopulateSuggestionsTable();
	-- sort the suggestions table
	TabardAddict_SortSuggestionsTable();
	
	
	
		-- populate equipped count and next achievement text
	if (tabardsEquipped >= 30) then
		TabardAddictTab1.taTabardTotalText:SetText(string.format(L.TABARD_COUNTS_2, tabardsEquipped));
		TabardAddictTab4.taTabardTotalText:SetText(string.format(L.TABARD_COUNTS_2, tabardsEquipped));
	else
		TabardAddictTab1.taTabardTotalText:SetText(string.format(L.TABARD_COUNTS, tabardsEquipped, tabardsNextAchievement));
		TabardAddictTab4.taTabardTotalText:SetText(string.format(L.TABARD_COUNTS, tabardsEquipped, tabardsNextAchievement));
	end;
	
	-- show/hide panels
	TabardAddictTab1:Show();
	TabardAddictTab2:Hide();
	TabardAddictTab3:Hide();
	TabardAddictTab4:Hide();
	PanelTemplates_SetTab(frameTabardAddict, 1);
	TabardAddictShowTabards();
	TabardAddictHideSuggestions();
	
	--set DressUp model and position
	TabardAddictDressUpModel:SetUnit("player");
	local settings;
	local hasAlternateForm, inAlternateForm = HasAlternateForm();
	if ( (hasAlternateForm==true) and (inAlternateForm==true) ) then
		settings = taDressUpSettings[playerRaceSex.."Alt"];
		-- debug
		if (debugMode) then
			print("loading: " .. playerRaceSex .. "Alt");
		end;
	else
		settings = taDressUpSettings[playerRaceSex];
		-- debug
		if (debugMode) then
			print("loading: " .. playerRaceSex);
		end;
	end
	
	TabardAddictDressUpModel:SetPortraitZoom(settings.zoom);
	TabardAddictDressUpModel.zoomLevel  = settings.zoom;
	TabardAddictDressUpModel:SetPosition(settings.x, settings.y, settings.z);
	
end;

--*****************************************************************************
--*****************************************************************************
function TabardAddictLauncher_OnLoad(self)

	--Show/Hide character frame launcher
	frameTabardAddictCharFrameLauncher:Show();

end;


--*****************************************************************************
--*****************************************************************************
function TabardAddict_OnHide(self)

	PlaySound("igCharacterInfoClose");
	taNameFilter = "";
	TabardAddictHideInfoButtons();
	CurrentTabardEntry_line = 0;
	CurrentTabardSuggest_line = 0;
	-- Hide info frame
	if (TabardAddictInfoFrame:IsShown()) then
		TabardAddictInfoFrame:Hide();
	end;
	
end;

--*****************************************************************************
--*****************************************************************************
function TabardAddictShowTabards()
	local line;
	for line=1,8 do
		getglobal("TabardAddictEntry"..line):Show();
	end;
end;
--
function TabardAddictShowSuggestions()
	local line;
	for line=1,8 do
		getglobal("TabardAddictSugg"..line):Show();
	end;
end;

--*****************************************************************************
--*****************************************************************************
function TabardAddictHideTabards()
	local line;
	for line=1,8 do
		getglobal("TabardAddictEntry"..line):Hide();
	end;
end;
--
function TabardAddictHideSuggestions()
	local line;
	for line=1,8 do
		getglobal("TabardAddictSugg"..line):Hide();
	end;
end;
--*****************************************************************************
--*****************************************************************************
function TabardAddict_SetConfigVariables(self)

	-- play checkbox sound
	if self.checked then
        PlaySound("igMainMenuOptionCheckBoxOn");
    else 
        PlaySound("igMainMenuOptionCheckBoxOff");
    end;

	if (CheckButtonAO:GetChecked() == 1) then
		TabardAddictConfig.CB_AO = 1;
	else
		TabardAddictConfig.CB_AO = 0;
	end;
	if (CheckButtonHO:GetChecked() == 1) then
		TabardAddictConfig.CB_HO = 1;
	else
		TabardAddictConfig.CB_HO = 0;
	end;
	if (CheckButtonEQ:GetChecked() == 1) then
		TabardAddictConfig.CB_EQ = 1;
	else
		TabardAddictConfig.CB_EQ = 0;
	end;
	if (CheckButtonTCG:GetChecked() == 1) then
		TabardAddictConfig.CB_TCG = 1;
	else
		TabardAddictConfig.CB_TCG = 0;
	end;
	if (CheckButtonOther:GetChecked() == 1) then
		TabardAddictConfig.CB_Other = 1;
	else
		TabardAddictConfig.CB_Other = 0;
	end;
	if (CheckButtonNA:GetChecked() == 1) then
		TabardAddictConfig.CB_NA = 1;
	else
		TabardAddictConfig.CB_NA = 0;
	end;
	if (CheckButtonPVP:GetChecked() == 1) then
		TabardAddictConfig.CB_PVP = 1;
	else
		TabardAddictConfig.CB_PVP = 0;
	end;
	if (CheckButtonBCF:GetChecked() == 1) then
		TabardAddictConfig.CB_BCF = 1;
	else
		TabardAddictConfig.CB_BCF = 0;
	end;
	if (CheckButtonWotLKF:GetChecked() == 1) then
		TabardAddictConfig.CB_WotLKF = 1;
	else
		TabardAddictConfig.CB_WotLKF = 0;
	end;
	if (CheckButtonATF:GetChecked() == 1) then
		TabardAddictConfig.CB_ATF = 1;
	else
		TabardAddictConfig.CB_ATF = 0;
	end;
	if (CheckButtonCF:GetChecked() == 1) then
		TabardAddictConfig.CB_CF = 1;
	else
		TabardAddictConfig.CB_CF = 0;
	end;
	if (CheckButtonSuggAch:GetChecked() == 1) then
		TabardAddictConfig.CB_SUGG_ACH = 1;
		TabardAddictUpdateSuggestTable = true;
	else
		TabardAddictConfig.CB_SUGG_ACH = 0;
		TabardAddictUpdateSuggestTable = true;
	end;
	if (CheckButtonSuggQst:GetChecked() == 1) then
		TabardAddictConfig.CB_SUGG_QST = 1;
		TabardAddictUpdateSuggestTable = true;
	else
		TabardAddictConfig.CB_SUGG_QST = 0;
		TabardAddictUpdateSuggestTable = true;
	end;
	if (CheckButtonSuggCur:GetChecked() == 1) then
		TabardAddictConfig.CB_SUGG_CUR = 1;
		TabardAddictUpdateSuggestTable = true;
	else
		TabardAddictConfig.CB_SUGG_CUR = 0;
		TabardAddictUpdateSuggestTable = true;
	end;
end;

--*****************************************************************************
--*****************************************************************************
function TabardAddict_ConfigOnEnter(self)

	local name = self:GetName();
	
	if (debugMode) then
		print("TabardAddict_ConfigOnEnter = " .. name);
	end;
	
	GameTooltip:SetOwner(self, "ANCHOR_RIGHT");
	-- Show tooltip based on config item name
	GameTooltip:SetText(taTabardConfigTip[name], 1.0,1.0,1.0,1,1);
end;

--*****************************************************************************
--*****************************************************************************
function TabardAddict_TotalText_OnEnter(self)

	local tableRow;
	
	-- Populate Achievement Completion tooltip
	GameTooltip:SetOwner(self, "ANCHOR_RIGHT", 15, -50);
	GameTooltip:SetText(YELLOW_FONT_COLOR_CODE..L.ACHV_TT_TITLE..FONT_COLOR_CODE_CLOSE);
	GameTooltip:AddLine(" ");
	
	for tableRow in ipairs(tempAchievementTooltipData)
	do
		-- Check if achievement completed
		if (tempAchievementTooltipData[tableRow][1] == true) then
			GameTooltip:AddLine(tempAchievementTooltipData[tableRow][2], GREEN_FONT_COLOR.r, GREEN_FONT_COLOR.g, GREEN_FONT_COLOR.b, 1);
			GameTooltip:AddTexture("Interface\\RAIDFRAME\\ReadyCheck-Ready");
		else
			GameTooltip:AddLine(tempAchievementTooltipData[tableRow][2], GRAY_FONT_COLOR.r, GRAY_FONT_COLOR.g, GRAY_FONT_COLOR.b, 1);
			GameTooltip:AddTexture(" ");
		end;
	end;
	
	GameTooltip:Show();
end;

--*****************************************************************************
--*****************************************************************************
function TabardAddict_OnTextChanged(self)
	local text = self:GetText();
	
	if ( text == SEARCH ) then
		taNameFilter = "";
		return;
	end;
	
	taNameFilter = text;
	-- get rid of right and left brackets
	taNameFilter=string.gsub(taNameFilter, "%[", "");
	taNameFilter=string.gsub(taNameFilter, "%]", "");
	-- populate the display table
	TabardAddict_PopulateDisplayTable();
	-- sort the display table
	TabardAddict_SortDisplayTable();
	-- initial display
	TabardAddictScrollBar_Update();
end

--*****************************************************************************
--*****************************************************************************
local function OnTooltipSetItem(tooltip, ...)
	
	local itemName, itemLink = tooltip:GetItem();
	-- exit if itemLink is nil - client has not cached item yet
	if (itemLink == nil) then
		return;
	end;
	-- parse itemID from link
	local _, _, _, _, itemID, _, _, _, _, _, _, _, _, _ = string.find(itemLink, "|?c?f?f?(%x*)|?H?([^:]*):?(%d+):?(%d*):?(%d*):?(%d*):?(%d*):?(%d*):?(%-?%d*):?(%-?%d*):?(%d*)|?h?%[?([^%[%]]*)%]?|?h?|?r?");
	
	-- check if need to get data from server
	if (TabardAddictDoServerQuery == true) then
		-- reset # of equipped tabards
		tabardsEquipped = 0;
		-- query server for data
		TabardAddict_GetServerData();
		TabardAddictDoServerQuery = false;
	end;
	
	-- check if itemID in tooltiptable before adding text to tooltip
	if ( TabardAddictServerData_tooltiptable[tonumber(itemID)] ~= nill ) then
		if not taLineAdded then
			local ttString = L.STR_TABARD .. L.BEEN_EQUIPPED;
			if (TabardAddictServerData_tooltiptable[tonumber(itemID)] == true) then
				ttString = ttString .. "|cff00FF00" .. L.YES .. "|r";
			else
				ttString = ttString .. "|cffFF0000" ..L.NO .. "|r"
			end;
			tooltip:AddLine(ttString);
			taLineAdded = true;
		end;
	end; 
end;

--*****************************************************************************
--*****************************************************************************
local function OnTooltipCleared(tooltip, ...)
	taLineAdded = false;
end;

--*****************************************************************************
--*****************************************************************************
function TabardAddict_OnLoad(self)

	if (debugMode) then
		print("TabardAddict_OnLoad: "..self:GetName());
	end;

	-- Register the frame so it can be dragged
	self:RegisterForDrag("LeftButton");

	-- Register Events
	self:RegisterEvent("PLAYER_EQUIPMENT_CHANGED");
	self:RegisterEvent("ADDON_LOADED");
	self:RegisterEvent("UPDATE_FACTION");
	
	-- HookScripts for in-game tooltips
	GameTooltip:HookScript("OnTooltipSetItem", OnTooltipSetItem);
	GameTooltip:HookScript("OnTooltipCleared", OnTooltipCleared);
	
	-- init variables
	TabardAddictDoServerQuery = true;
	TabardAddictUpdateSuggestTable = true;
	
	-- Tab Handling code
	PanelTemplates_SetNumTabs(self, 4);
	PanelTemplates_SetTab(self, 1);
	
	-- show/hide panels
	TabardAddictTab1:Show();
	TabardAddictTab2:Hide();
	TabardAddictTab3:Hide();
	TabardAddictTab4:Hide();
	
	-- update portrait emblem
	SetPortraitToTexture(self.taTabardEmblem, "Interface\\ICONS\\INV_Chest_Cloth_30")
	
	self.taTitleText:SetText(L.ADDON_TITLE);
	TabardAddictTab3.taVersionText:SetText("v"..TABARD_ADDICT_VERSION);
	
	-- set addon text
	self.Tab1Label:SetText(L.TAB1_LABEL);
	self.Tab2Label:SetText(L.TAB2_LABEL);
	self.Tab3Label:SetText(L.TAB3_LABEL);
	self.Tab4Label:SetText(L.TAB4_LABEL);
	
	TabardAddictTab2.taConfigDescText:SetText(L.CONFIG_TITLE);
	TabardAddictTab2.fsTabardTypes:SetText(L.CONFIG_HDR1);
	TabardAddictTab2.fsTabardFilter:SetText(L.CONFIG_HDR2);
	TabardAddictTab2.fsTabardSugg:SetText(L.CONFIG_HDR3);
	CheckButtonAO.fs:SetText(L.CONFIG_AO);
	CheckButtonHO.fs:SetText(L.CONFIG_HO);
	CheckButtonEQ.fs:SetText(L.CONFIG_EQ);
	CheckButtonTCG.fs:SetText(L.CONFIG_TCG);
	CheckButtonPVP.fs:SetText(L.CONFIG_PVP);
	CheckButtonBCF.fs:SetText(L.CONFIG_BCF);
	CheckButtonWotLKF.fs:SetText(L.CONFIG_WOTLK);
	CheckButtonATF.fs:SetText(L.CONFIG_ATF);
	CheckButtonCF.fs:SetText(L.CONFIG_CF);
	CheckButtonNA.fs:SetText(L.CONFIG_NA);
	CheckButtonOther.fs:SetText(L.CONFIG_OTHER);
	CheckButtonSuggAch.fs:SetText(L.CONFIG_SUGG_ACH);
	CheckButtonSuggQst.fs:SetText(L.CONFIG_SUGG_QST);
	CheckButtonSuggCur.fs:SetText(L.CONFIG_SUGG_CUR);
	
	TabardAddictTab3.taAboutDescText:SetText(L.ABOUT_TITLE);
	TabardAddictTab3.hdr1:SetText(L.ABOUT_HDR1);
	TabardAddictAboutInfo:SetText(L.ABOUT_TXT);
	
	TabardAddictTab4.taSuggestDescText:SetText(L.SUGGESTIONS_TITLE);
	
	
	-- set alliance or horde background
	local englishFaction = UnitFactionGroup("player");
	if ( englishFaction == "Horde" ) then  -- horde
		TabardAddictBGFaction:Show();
		TabardAddictBGFaction2:Hide();
		TabardAddictBGFactionSugg:Show();
		TabardAddictBGFactionSugg2:Hide();
		taPlayerFaction = 2;
	else  -- alliance - change this else to handle 1-10 pandaren
		TabardAddictBGFaction:Hide();
		TabardAddictBGFaction2:Show();
		TabardAddictBGFactionSugg:Hide();
		TabardAddictBGFactionSugg2:Show();
		taPlayerFaction = 1;
	end;
	
	-- init name filter
	taNameFilter = "";
end;


