local ADDON, data = ...

local BEAR_COUNT = 3
local BEARS = {33655, 29418, 33654}
local DANCE = 69
local BEAR_POSITIONS = {
    {
        position = {-2.7, 0, -1.2},
        rotation = 0,
    },
    {
        position = {-4, -1, -1.2},
        rotation = -1.67,
    },
    {
        position = {-2.7, 0, -1.2},
        rotation = 0,
    },
    {
        position = {-4, 1, -1.2},
        rotation = 1.67,
    },
}

local FLYINGMACHINE = 8011
local FLYINGMACHINE_POSITIONS = {
    position = {-19, 2, 5.5},
    rotation = 1.67,
}

local ROCKET_COUNT = 2
local ROCKET = 30177
local ROCKET_POSITIONS = {
    {
        position = {-4.5, 1.2, 0},
        rotation = 1.67,
    },
    {
        position = {-4.5, -1.2, 0},
        rotation = -1.67,
    }
}
local ROCKET_PARAMS = {
    {
        posx = -200,
        posy = -25,
        velocity = 3,
        delay = 0.5,
    },
    {
        posx = UIParent:GetWidth()+200,
        posy = -135,
        velocity = -3.6,
        delay = 5.9,
    },
}

local CONGRATS_PARAMS = {
    grow = {ratio = 1.008, done = function(n) return n>1.15 end},
    shrink = {ratio = 0.987, done = function(n) return n<0.95 end},
    disappear = {ratio = 0.92, done = function(n) return n<0.2 end},
}
local CONGRATS_COUNT = 1
local STOP_CONGRATULATING = 14.2


------------------------------------------------------------------

local function ShowBear (f, n)  -- frame, bear number
    f:SetDisplayInfo (BEARS[n])
    f:SetAnimation (DANCE, -1)
end

------------------------------------------------------------------

local function AdjustBear (f, n)    -- frame, position number
    f:SetPosition (unpack(BEAR_POSITIONS[n].position))
    f:SetRotation (BEAR_POSITIONS[n].rotation)
    f.pos = n
end

------------------------------------------------------------------

local function CreateBear ()
    local f = CreateFrame ("PlayerModel", nil, UIParent)
    --f:SetPoint ("CENTER",UIParent,"CENTER")
    f:SetSize (450,500)
    f:SetFrameStrata ('TOOLTIP')
    f:SetAnimation (DANCE, -1)
    f:Hide()
    
    f.ShowBear = ShowBear
    f.AdjustBear = AdjustBear
        
    f:SetScript ("OnAnimFinished", function (self,...)
        if self.pos == #BEAR_POSITIONS then
            self:ClearModel ()
            self:Hide()
        else
            self:AdjustBear (self.pos+1)
        end
    end)
    
    return f
end

------------------------------------------------------------------

local function CreateAirplane ()
    local W,H = 400,400
    local f = CreateFrame ("PlayerModel", nil, UIParent)
    f:SetFrameStrata ('TOOLTIP')
    --f:SetPoint ("CENTER",UIParent,"CENTER")
    f:SetSize (W,H)
    f:Hide()
    
    f:SetDisplayInfo (FLYINGMACHINE)
    f:SetPosition (unpack(AIRPLANE_POSITIONS.position))
    f:SetRotation (AIRPLANE_POSITIONS.rotation)
    
    function f:StartAirplane ()
        self.pos = -self:GetWidth()
        self.velocity = 14
        self:SetPoint ("TOPLEFT", UIParent, "TOPLEFT", self.pos, 0)
        self:Show()        
    end
    
    f:SetScript ("OnUpdate", function (self, elapsed,...)
        
    end)
    
    return f
end

------------------------------------------------------------------

local function CreateRocket (idx)
    local W,H = 300, 150
    local f = CreateFrame ("PlayerModel", nil, UIParent)
    f:SetFrameStrata ('TOOLTIP')
    --f:SetPoint ("CENTER",UIParent,"CENTER")
    f:SetSize (W,H)
    f:Hide()
    
    f:SetDisplayInfo (ROCKET)
    f:SetPosition (unpack(ROCKET_POSITIONS[idx].position))
    f:SetRotation (ROCKET_POSITIONS[idx].rotation)
    
    function f:RockIt (params)
        self.posx = params.posx
        self.posy = params.posy
        self.velocity = params.velocity
        self.delay = params.delay
        self.elapsed = 0
        self:Show()     

        f:SetScript ("OnUpdate", function (self, elapsed,...)
            self.elapsed = self.elapsed + elapsed
            if self.elapsed < self.delay then return end
            
            self.posx = self.posx + self.velocity
            self:SetPoint ("TOPLEFT", UIParent, "TOPLEFT", self.posx, self.posy)
            
            if abs(self.posx+self:GetWidth())<10 or abs(UIParent:GetWidth()-self.posx)<10 then
                self:SetScript ("OnUpdate", nil)
                self:Hide()
            end
        end)        
    end
    
    return f
end

------------------------------------------------------------------

local function CreateCongrats ()
    local W,H = 800, 200
    local f = CreateFrame ("Frame", nil, UIParent)
    f:SetFrameStrata ('TOOLTIP')
    f:SetPoint ("CENTER",UIParent,"CENTER", 0, 150)
    f:SetSize (W,H)
    f:Hide()
    
    f.txt = f:CreateTexture ("Texture")
    f.txt:SetTexture ('Interface\\Addons\\'..ADDON..'\\surprise1')
    f.txt:SetAllPoints (f)
    
    function f:Congratulate (delay)
        self.scale = 1
        self.alpha = 1
        self.delay = delay
        self.elapsed = 0
        self.action = 'grow'
        self:Show()
        
        f:SetScript ("OnUpdate", function (self, elapsed,...)
            self.elapsed = self.elapsed + elapsed
            if self.elapsed < self.delay then return end
            
            --self:Show()
            --self:SetScale (self.scale)
            self:SetSize (800*self.scale, 200*self.scale)
            --self:SetAlpha (self.alpha)

            
            self.scale = self.scale * CONGRATS_PARAMS[self.action].ratio
            --f:SetPoint ("CENTER",UIParent,"CENTER", 0, 0) --165 - self.scale*35)
            
            if CONGRATS_PARAMS[self.action].done (self.scale) then
                if self.action=='disappear' then
                    self:SetScript ("OnUpdate", nil)
                    self:Hide()
                else
                    if self.elapsed > STOP_CONGRATULATING then
                        self.action = 'disappear'
                    else
                        if self.action=='grow' then 
                            self.action = 'shrink'
                        elseif self.action=='shrink' then
                            self.action = 'grow'                            
                        end
                    end
                end
            end
            
            --self.scale = self.scale * 1.015
            --self.alpha = self.alpha - 0.03
            
            --[[if self.alpha < 0.5 then
                self:SetScript ("OnUpdate", nil)
                self:Hide()
            end]]
            --[[if self.elapsed > 9 then
                self:SetScript ("OnUpdate", nil)
                self:Hide()
            end]]
        end)        
    end
    
    
    return f
end

------------------------------------------------------------------

do 
    -- Bears!
    tblBears = {}
    for i=1,BEAR_COUNT do
        tblBears[i] = CreateBear()
    end
    
    tblBears[1]:SetPoint ("CENTER", UIParent, "CENTER", 0, -130)
    tblBears[2]:SetPoint ("LEFT", tblBears[1], "RIGHT")
    tblBears[3]:SetPoint ("RIGHT", tblBears[1], "LEFT")
    
    -- Rockets!
    tblRockets = {}
    for i=1,ROCKET_COUNT do
        tblRockets[i] = CreateRocket(i)
    end
    
    -- Congrats!
    tblCongrats = {}
    for i=1,CONGRATS_COUNT do
        tblCongrats[i] = CreateCongrats()
    end

    -- Stuff!
    function Surprise ()
        -- Bears!
        for i=1,BEAR_COUNT do
            tblBears[i]:ShowBear(i)
            tblBears[i]:AdjustBear (1)
            tblBears[i]:Show ()
        end
        
        -- Rockets!
        for i=1,ROCKET_COUNT do
            tblRockets[i]:RockIt (ROCKET_PARAMS[i])
            --tblRockets[i]:RockIt (0, 3)
        end
        
        -- Congrats!
        for i=1,CONGRATS_COUNT do
            tblCongrats[i]:Congratulate ((i-1)*0.3)
        end
        
    end
    
    frmSurprise = CreateFrame ("Frame", 'frmSurprise', UIParent)
    frmSurprise:RegisterEvent ("COMBAT_LOG_EVENT_UNFILTERED")
    --frmSurprise:RegisterEvent ("PLAYER_ENTERING_WORLD")
    frmSurprise:SetScript ("OnEvent", function  (bla, e, timeStamp, event, hideCaster, srcGuid, srcName, srcFlags, srcRaidFlags, dstGuid, dstName, dstFlags, dstRaidFlags, ...)
        if e=="COMBAT_LOG_EVENT_UNFILTERED" then
			if event=='UNIT_DIED' and (dstName=="Lei Shen" or dstName=="Garrosh Hellscream") then
				Surprise ()
			end
		--[[elseif e=="PLAYER_ENTERING_WORLD" then
			if (random(20)==1) then
				FaceSwap ()
			end]]
		end
    end)    
end

------------------------------------------------------------------

local lstLines = {
    random = {
        "You never know where the camel is.",
        "You truly are a complete noob.",
        "You are not prepared!",
        "You should invest in Venture Co. stocks, they've had a very profitable year.",
        "I've got an add-on for that.",
        "Do you know how many interior designers it takes to change a light bulb?",
        "G'day, mate!",
        "Your armour looks fabulous.",
        "Never gonna give you up, never gonna let you down...",
        "Of all the boss fights in all the dungeons in all of Azeroth, she had to walk into mine.",
        "I came, I pulled, I looted.",
        "A goblin always pays his debts!",
        "Yo momma is so fat, when she stands in Orgrimmar I can melee her from Stormwind!",
        "Have you been to Sweden this year?",
        "Well, this escalated quickly.",
        "Zug zug!",
        "You should get exalted with Ponyville, you get a great mount.",
        "Have you tried turning it off and on again?",
        "Welcome to Jamaica, mon, have a nice day.",
        "Once completely uninstalled, please reboot your computer.",
        "It won't get better if you pick at it.",
        "Are you pondering what I'm pondering, "..UnitName('player').."?",
        "You're a wizard, Harry!",
        "You will die a fiery death!",
        "Flee in terror!",
        "If you build it, he will come.",
        "Dude, Teemo is SO overpowered!.",
        "Ni! Ni! Ni!",
        "<Malsomnus Productions> now recruiting undead females for the filming of Ghouls Gone Wild! Must be level 18 or higher to apply.",
        "Dude, where's my mount?",
        "Seriously, move out of the fire!",
        "Heal me baby one more time.",
        "Remember, battle pets are for external use only.",
        "In Soviet Russia, boss loots you.",
        "A friend who rolls Greed is a friend indeed.",
        "WTB weapon glow 2g!",
        "The plums aren't real.",
        "You must construct additional pylons.",
        "Hello? Can anyone hear me?",
        "Ho, the Megapode!",
        "Don't forget to bring your towel!",
        "They all float down here.",
        "Where do I find Mankrik's wife?",
        "Quantum mechanics are people who repair quantums, right?",
        "Faster, faster!",
        "Must... kill... all... humans...",
        "Good evening, do you have a moment to hear about our lord and saviour Y'Shaarj?",
        "Join us...",
        "Ia ia C'thulhu Fhtagn!",
        "Help, I'm stuck!",
        "Ding!",
        "Grats!",
        "Time flies like a banana.",
        "Thank you, but I already have a penguin.",
        "Every time you post feedback on an add-on, a kitten gets its wings!",
        "Semicolon, hyphen, close-parenthesis.",
        "When in doubt, blame the warlock.",
        "As they say, \"Find a pin and pick it up, and all day long you'll have a pin!\"",
        "Beware of the leopard.",
        "Stale cheesecake is hollow succour to a man bereft of ostrich.",
        "It's never too late to build a time machine.",
        "I don't know if you know this, but bear cubs are precious and soft.",
		"Ahhh, my spleen!",
        "Good luck with your robot!",
		
    },
    
    creepy = {
        "DIE",
        "DIE!!!",
        "run",
        "flee",
        "suffer",
        "you cannot escape",
        "you cannot hide",
        "you will die",
        "you're already dead",
        "they are watching",
        "they can see you",
        "they will find you",
        "they're almost here",
        "they're after you",
        "don't blink",
        "behind you",
        "don't look back",
        "it's already too late",
        "death is coming",
        "the end is near",
        "it's over",
        
    },
}

local Today = {}
do
    local weekday, month, day, year = CalendarGetDate ()
    Today.weekday = weekyday
    Today.day = day
    Today.month = month
    Today.year = year

    Today.isCreepy = (weekday==6 and day==13) or (day==31 and month==10)
end

function PickRandom (tbl)
    return tbl[random(#tbl)]
end
    
-- The Whisperer!
do
    local f = CreateFrame ("Frame", 'frmWhisperer', UIParent)
    
    -- Init according to date
    if (false--[[Today.isCreepy]]) then     -- I don't know, man, I'm afraid people will think it's just stupid and not creepy... better leave it out for now
        -- Friday the 13th!
        f.minWait = 20
        f.maxWait = 80
        f.lines = lstLines.creepy
        f.color = {r=1, g=0, b=0}
        
        f.format = function (txt)
            --local msg = format (CHAT_CHANNEL_SEND, 0, 'Hell') .. txt
            --local msg = format (CHAT_WHISPER_GET, 'A voice') .. txt
            local msg = txt
            if (CHAT_TIMESTAMP_FORMAT) then 
                msg = string.gsub(CHAT_TIMESTAMP_FORMAT, "%%.", "??") .. msg;
            end
            return msg
        end
    else
        f.minWait = 30
        f.maxWait = 120
        f.lines = lstLines.random
        f.color = ChatTypeInfo.MONSTER_WHISPER --{r=ChatTypeInfo.MONSTER_WHISPER.r, g=ChatTypeInfo.MONSTER_WHISPER.g, b=ChatTypeInfo.MONSTER_WHISPER.b}
        
        f.format = function (txt)
            local msg = format (CHAT_WHISPER_GET, 'A mysterious voice') .. txt
            if (CHAT_TIMESTAMP_FORMAT) then 
                msg = BetterDate(CHAT_TIMESTAMP_FORMAT, time()) .. msg;
            end
            return msg
        end
    end
    
    -- Timer via animation group
    f.animGroup = f:CreateAnimationGroup()
    f.anim = f.animGroup:CreateAnimation()
    f.animGroup:SetScript ("OnFinished", function (self, requested)
        if _G.UnitAffectingCombat('player') then
            frmWhisperer:QueueRandomWhisper (3)
        else
            frmWhisperer:WhisperRandom ()
            frmWhisperer:QueueRandomWhisper ()
        end
    end)
    
    
    function f:QueueRandomWhisper (minutes)
        minutes = minutes or (math.floor(random()*(self.maxWait-self.minWait)) + self.minWait)
        self.anim:SetDuration (minutes * 60)
        self.animGroup:Play ()
    end
    f:QueueRandomWhisper ()
    
    
    function f:WhisperRandom ()
        -- Occasionally, instead of whispering let's just face swap!
		if (random(2)==1) then
			FaceSwap ()
		else
			local msg = self.format (PickRandom (self.lines))
			ChatFrame1:AddMessage (msg, self.color.r, self.color.g, self.color.b)
		end
    end
    
    f.animGroup:Play ()
    
    
end

--------------------------------------------------------------------------------

function FaceSwap ()
	local n = random(8)
	SetPortraitToTexture (PlayerFrame.portrait, 'Interface\\Addons\\'..ADDON..'\\f'..n)
end

--[[



models to check out:

anthricystchangefx 0
arcanepower_state_chest 0
banish_chest_yellow 0
blackshot_missile
dragonflamebreath
faeriefire_impact       38512
firenova_area
fireshot_missile
levelup
missile_bomb


]]

--[[

if f then
   f:Hide()
   f = nil
else
   n = 40000
end

for n=10000,40000 do
   f:SetDisplayInfo (n)
   if f:GetModel():match('bear') then
      print (f:GetModel(),n)
   end
end]]