DailyItem_ADDONNAME = "DailyItems";
DailyItem_MacroNAME = "DailyItem";
DailyItem_VERSION = GetAddOnMetadata("DailyItems", "Version");
DI_Paranoia = 0;

-- These only apply if we have soething to look for - ie if the subzone is nul we dont get the Weight for the subzone (NOT IMPLEMENTED)
-- Weight 64 We have the correct target
-- Weight 32 We are in the correct subzone
-- Weight 16 We are in the correct zone
-- Weight 8  We dont filter on target but we have it as a target
-- Weight 4
-- Weight 2  used at -ve
-- Weight 1  used at -ve
-- Weight -1  We have no item to use - ie its a Target only quest - I think these all have zones/subzones so it just reduces the 48 weght to 47
-- Weight -2  We have no quest to match ie its an Item only - unless its no quest no item... so thats a general target something - not used at moment

SLASH_DAILYITEM1, SLASH_DAILYITEM2 = '/dailyitem', '/di';
function SlashCmdList.DAILYITEM(msg)
	if (strlower(msg) == "zone") then
		DailyItem_Print("Zone = ["..GetRealZoneText().."]");
		DailyItem_Print("SubZone = ["..GetSubZoneText().."]");
	elseif (strlower(msg) == "update") then
		print ("Force update");
		DI_Paranoia = 1;
		DailyItem_Go();
	elseif (strlower(msg) == "add") then
		print ("Recreate Macro");
		DailyItem_MakeMacro(); -- Used to debug the Macro creation
	elseif (strlower(msg) == "quiet") then
		DI_Paranoia = 0;
	elseif (strlower(msg) == "normal") then
		DI_Paranoia = 2;
	elseif (strlower(msg) == "super") then
		DI_Paranoia = 5;
	elseif (strlower(msg) == "trick") then
		print ("Adding blacksmith hammer Item to database" );

DailyItem_AddArrayLine("Stormwind City","",44094,nul,0,nul);--The Blessed Hammer of Grace()
DailyItem_AddArrayLine("Stormwind City","Old Town",2862,nul,0,29433);--Rough Sharpening Stone(Test Your Stength)
DailyItem_AddArrayLine("Stormwind City","Old Town",5956,nul,0,29433);--Blacksmith Hammer(Test Your Stength)
DailyItem_AddArrayLine("Stormwind City","",1251,"Master Wood",2,29433);--Linen Bandage(Test Your Stength)
DailyItem_AddArrayLine("Stormwind City","",2901,"Training Dummy",1,29433);--Mining Pick(Test Your Stength)
DailyItem_AddArrayLine("Stormwind City","The Canals",nul,"Canal Crab",2,nul);--()
DailyItem_AddArrayLine("Stormwind City","Trade District","Coarse Sharpening Stone","Blacksmithing",16,29433);--(Nibbler, No!)

	else
		print("Daily items version ",DailyItem_VERSION)
		print ("Daily item slash commands are");
		print ("Zone        Show the zone and subzone you are in ");
		print ("update      Show which Macro it has selected ");
		print ("normal      Show you if it didnt actually find quest to create a Macro for");
		print ("super       Super noisy - shows you everything ");
		print ("Macro       Recreate the base Macro - just in case you delete it");
		print ("Trick       Add some false items to the database (for debug you'll have to reload to get rid of them )");
		print ("quiet       Turns off the detailed messages turned on by update");
		print ("What you entered was '", msg, "'")
	end

end

-- I want this to run when you log in, update bag contents, swap zones, or change targets.

function DailyItem_OnLoad(self)
	self:RegisterEvent("PLAYER_LOGIN");
	self:RegisterEvent("BAG_UPDATE");  -- Something added to bag
	self:RegisterEvent("ZONE_CHANGED");
	self:RegisterEvent("PLAYER_TARGET_CHANGED");
    self:RegisterEvent("QUEST_ACCEPTED"); -- Becauce at least on some quests you get the item in the bag BEFORE you get given the quest
end

function DailyItem_MakeMacro()
	local numGenMacros, numCharMacros = GetNumMacros();
	if (GetMacroIndexByName(DailyItem_MacroNAME) == 0) then
		if (numGenMacros < 36) then
			CreateMacro(DailyItem_MacroNAME, "INV_MISC_QUESTIONMARK" , "", nil)
		else
			DailyItem_Print("You have 36 General Macros. Cannot add "..DailyItem_MacroNAME.."!");
		end
	end
end

-- Accessor functions
function DI_Zone(Index)
	return DailyItem_Quests[Index][1];
end
function DI_SubZone(Index)
	return DailyItem_Quests[Index][2];
end
function DI_Item(Index)
	return DailyItem_Quests[Index][3];
end
function DI_Target(Index)
	return DailyItem_Quests[Index][4];
end
function DI_TargetType(Index)
	return DailyItem_Quests[Index][5];
end
function DI_Quest(Index)
	return DailyItem_Quests[Index][6];
end

function DailyItem_OnEvent(self, event)
    if DI_Paranoia>2 then print(event,InCombatLockdown()); end
	if (InCombatLockdown()) then return; end
	if (event == "PLAYER_LOGIN") then
		DailyItem_MakeMacro();
		DailyItem_MakeArrays();
		DIQuestsLength = table.getn(DailyItem_Quests);
		DailyItem_Print("DailyItems Databese:\nQuests - "..DIQuestsLength);
	end
	DailyItem_Go();
end

function DailyItem_Print(msg)
	if ((msg) and (strlen(msg) > 0)) then
		if (DEFAULT_CHAT_FRAME) then
			DEFAULT_CHAT_FRAME:AddMessage(msg, 1, 1, 0);
		end
	end
end

function DailyItem_NumFromLink(itemLink)
	if (not itemLink) then
		return nil;
	end
	local _, _, itemNumber = strfind(itemLink, "item:(%d+):");
	return itemNumber;
end

function DailyItem_IsZone(Index)
	if not DI_Zone(Index) then
		return true;
	elseif DI_Zone(Index) == GetRealZoneText() then
		if DI_Paranoia>4 then print("Found Zone ", Index, GetRealZoneText() ) ; end
		DI_Weight = DI_Weight + 16;
		return true;
	else
		return false;
	end
end

function DailyItem_IsSubZone(Index)
	if not DI_SubZone(Index) then
		return true;
	elseif DI_SubZone(Index) == GetSubZoneText() then
		if DI_Paranoia>4 then print("Found subZone ", Index, GetSubZoneText() ) ; end
		DI_Weight = DI_Weight + 32;
		return true;
	else
		return false;
	end
end

function DailyItem_IsItemInBags(Index)
	local itemID = DI_Item(Index)
	if DI_TargetType(Index) == 16  then -- We need to make it - so see if we have enough
		count = GetItemCount(itemID)
		if count then
			if count == 3 then
				return false; -- got them dont make them
			else
				return true;
			end
		else
			return true
		end
	end


	for bagID = 0, 4, 1 do
		local bagSlotCnt = GetContainerNumSlots(bagID);
		if (bagSlotCnt > 0) then
			for slot = 1, bagSlotCnt, 1 do
				local itemLink = GetContainerItemLink(bagID, slot);
				local itemNumber = tonumber(DailyItem_NumFromLink(itemLink));
				if (itemNumber) and (itemID == itemNumber) then
					if DI_Paranoia >2 then print("We found ", itemID, " In bag ", bigID, " slot " , slot); end
					return true;
				end
			end
		end
	end
	if DI_Paranoia>4 then print("Did not find item in bag", Index,itemID ) ; end

	return false;
end

function DailyItem_IsItemWorn(itemID)
	for equipID = 0, 19, 1 do
		local itemNumber = GetInventoryItemID("player",equipID);
		if (itemNumber) then
			if (itemID == itemNumber) then
		if DI_Paranoia >2 then print("We found ", itemID, " In slot ", equipID); end
				return true;
			end
		end
	end
	return false;
end

function DailyItem_IsMatchTarget(Index )
	-- if there is no target to look for or we are going to target then we have a match
	if DI_Paranoia>3 then print("Checking if ", DI_Target(Index) ,"or",  DI_TargetType(Index) ,"~=0 ") ; end

	if not DI_Target(Index) then -- nothing to check just say match
		return true;
	end

	if DI_TargetType(Index) == 16  then -- We need to make it Shpuld check if we have already
		return true;
	end
	if DI_TargetType(Index) == 1  or DI_TargetType(Index) == 3  or DI_TargetType(Index) == 5 or DI_TargetType(Index) == 7 or DI_TargetType(Index) == 9 then-- Filter
		if DI_Target(Index) == UnitName("target") then
			DI_Weight = DI_Weight + 64;
			return true;
		else
			return false;
		end
	end
	-- if we get here then check if we have something to look for but we are not filtering on it - If we can see it then increase the weight a little - I wonder if this should be more than the zone (in which case we could use 64)
		if DI_Target(Index) == UnitName("target") then
			DI_Weight = DI_Weight + 8;
		end
	return true;
end


function DailyItem_IsMatchQuest(Index)
	-- if its just an item without a quest then it matches at a lower Weight
	if not DI_Quest(Index) then
		DI_Weight = DI_Weight - 2
		return true;
	end
	local numQuests = GetNumQuestLogEntries(); -- Get the number of quests in my quest log
	for questNo = 1, numQuests -- Now, cycle through each quest in the quest log
	do
		--local questTitle, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily = GetQuestLogTitle(questNo); -- Get the information about each line in the quest log
		-- So I know which parts i look at commented out the parts I dont use
		local _ , _ , _ , _ , isHeader, _ , isComplete, _ = GetQuestLogTitle(questNo); -- Get the information about each line in the quest log

		if (not isHeader) then-- Ignore the lines that are just headers rather than actual quests
			local questID = tonumber(GetQuestLink(questNo):match("\124Hquest:(%d+):")); -- Get the actual quest ID
			if ((isComplete) and (questID + DI_Quest(Index) == 0)) or ((not isComplete) and (questID == DI_Quest(Index))) then -- Check if the current DB line matches the current quest (Negative means match complete quest)
				if DI_Paranoia>4 then print("Found Quest in log ", DI_Quest(Index) ) ; end
				return true;
			end
		end
	end
	--- we've looked at all our current quests but not found a match
	return false;

end



function EquipIt(Index)
	if (IsEquippableItem(DI_Item(Index))) then
		return "\n/equip item:"..DI_Item(Index);
	else
		return "";
	end
end

function UseIt(Index)
	if DI_Item(Index) then
		return "\n/use item:"..DI_Item(Index);
	else
		return "";
	end
end


function TargetIt(Index)
	RC=""
	if DI_Target(Index) then
		if DI_TargetType(Index) == 1 then
			if (DI_Target(Index) == UnitName("target")) then  -- So we want to target but we are targetted so dont bother re-targetting - I think this is handled by the NoExists in the Macro anyway
				return "";
			else  -- - as if we have a target then (I think) the [noexists] means nothing happens anyway
				return "\n/target [noexists] "..DI_Target(Index);
			end
		elseif (DI_TargetType(Index) == 2) then -- Retarget no matter what This does NOT work very well on the few quests I've tried it on
			return "\n/target "..DI_Target(Index);
		else -- Default target type - I think this is the original code (I re-structured a lot) - but since the Macro isnt written UNLESS the target is already targetted I'm  not so sure that this does anything useful (as Noexists stops the retarget)
			return "\n/target [noexists] "..DI_Target(Index);
		end
	else -- nothing to target
		return "";
	end
end


function DailyItem_Go()
	local MacroText;

	local FinalWeight;
	local FinalMacroText;

	local FinalIcon;
	local Icon;
	FinalMacroText = "";
	FinalWeight = -64;  -- Force the first loop to overwrite the Macro if one is found
	-- Process the database inthe outmost loop so that the LAST one found is the one we will keep - I think the previous version of code would of matched the last version in our current quest table
	for Index = 1, DIQuestsLength -- Cycle through all quests in the database
	do
		if( DI_Paranoia>2) then print("Checking ", Index, DI_Zone(Index), DI_SubZone(Index), DI_Item(Index), DI_Quest(Index) ); end

		DI_Weight = 0;
		MacroText = "";
		Icon = "INV_MISC_QUESTIONMARK";
		if DailyItem_IsMatchQuest(Index) then
			if DailyItem_IsZone(Index ) and DailyItem_IsSubZone(Index ) and DailyItem_IsMatchTarget(Index ) then -- Check if we're in the right part of the world and we are targetting the right thing
				if (DI_Item(Index)) then -- Check if there is an associated item to use
					if DI_Paranoia>3 then print("DB ", Index, " is in zone:", DI_Zone(Index), " Subzone:" , DI_SubZone(Index),DI_Item(Index)," and we have the target ", DI_Target(Index) , " of type ", DI_TargetType(Index) ) ; end
					if DailyItem_IsItemInBags(Index) and IsEquippableItem(DI_Item(Index)) then-- we have it in our bags but it should be equipped (trigger will fire when equipped)
						MacroText = EquipIt(Index);
						if( DI_Paranoia>2) then print(MacroText, Icon, " due to EI ", Index, DI_Quest (Index), DI_Item(Index), DI_Weight, FinalWeight); end
					elseif DailyItem_IsItemInBags(Index)  or DailyItem_IsItemWorn(DI_Item(Index)) then  -- Do we have the item? (we have checked if it should be equipped so it does not matter where it is)
						-- if so then the Macro will be Target then Use (the functions work out what to do)
						if DI_TargetType(Index) ==16 then
							MacroText = DI_MakeIt(Index, Icon)
						else
							MacroText = TargetIt(Index)..UseIt(Index, Icon) ;
						end
						if( DI_Paranoia>0) then print(MacroText, Icon, " due to ", Index, DI_Quest (Index), DI_Item(Index), DI_Weight, FinalWeight); end
					end -- Check for item
				else -- So there is no item for this quest
					DI_Weight = DI_Weight - 1
					Icon = "ABILITY_HUNTER_SNIPERSHOT"
					MacroText = TargetIt(Index)..UseIt(Index);
					if( DI_Paranoia>2) then print(MacroText, Icon, " due to NI", Index, DI_Quest (Index), DI_Item(Index), DI_Weight, FinalWeight); end
				end -- Is there an item associated with quest
			end -- Zonecheck
		end -- Found a match to the current Database quest

		if MacroText ~= "" then
			if DI_Weight >= FinalWeight then
				if DI_Paranoia>1 then print("Weight, FW", DI_Weight, FinalWeight, MacroText, FinalMacroText, FinalIcon,Icon); end
				FinalWeight = DI_Weight;
				FinalMacroText = MacroText;
				FinalIcon = Icon;
			end
		end
	end -- Cycling through each quest in my log

	if (FinalMacroText ~= "" )  then -- So, we've decided what we want in our Macro, so write it out (only if there's something to write)
		EditMacro(DailyItem_MacroNAME, nil, FinalIcon , "#showtooltip\n"..FinalMacroText, nil, nil);
	else
		if DI_Paranoia>1 then print("Nothing found"); end
		--EditMacro(DailyItem_MacroNAME, nil, "INV_MISC_QUESTIONMARK", "/sleep", nil, nil);
	end -- Writing out Macro
end -- End of the main function.



function DI_MakeIt(Index)
	if ATSW_AddJobLL then
		-- ATSW loads the queue when the frame becoes visible visible so we need to do some of the loading of the frame etc I've hardcoded that three are required
		if DI_ATSWQueued(Index)>=3 then
			return "/cast "..DI_Target(Index)
		else
			return "/cast "..DI_Target(Index).."\n/run ATSW_AddJobLL('"..DI_Item(Index).."', 3)\n/run ATSWFrame_Update()\n/run DailyItem_Go()"
		end
	else
		return "/cast "..DI_Target(Index)
	end
end


function DI_ATSWQueued(Index)
	local i, skillname, key,TheTable
	local player_name=UnitName("player")
	local profession = DI_Target(Index)
	local atsw_playerqueues
	for key,TheTable  in pairs(atsw_savedqueue) do
		--print(1,key,TheTable ,player_name)
		if strlower(player_name) == strlower(key) then
			atsw_playerqueues = TheTable
		end
	end
	if atsw_playerqueues then
		local atsw_playerprofessionqueue
		atsw_playerprofessionqueue=atsw_queue[atsw_displayedgroup];
		for key,TheTable  in pairs(atsw_playerqueues) do
			if strlower(profession) == strlower(key) then
				atsw_playerprofessionqueue = TheTable
			end
			--print(2,key,TheTable ,profession )
		end
		if atsw_playerprofessionqueue then
--			for key,TheTable in pairs(atsw_playerprofessionqueue) do
				--print(3,i,j)
--			end
			skillname = DI_Item(Index)
			for i=1,#atsw_playerprofessionqueue,1 do
				if DI_Paranoia >= 1 then print("Looking at ", i, atsw_playerprofessionqueue[i].name, skillname , " items queued"); end
				if(strlower(atsw_playerprofessionqueue[i].name)==strlower(skillname)) then
					if DI_Paranoia >= 1 then print("Found ", atsw_playerprofessionqueue[i].count, skillname , " items queued"); end
					return atsw_playerprofessionqueue[i].count
				end
			end
		end
	end
	if DI_Paranoia >= 1 then print("Found ", 0, skillname , " items queued"); end
	return 0
end
