-- Last Update: 17/06/2010
-- DailyItem Version: 0.93

--[[ 
This is the array containing the data: Zone - SubZone - ItemID - Target - Aim
- Zone/SubZone - ANY means it doesn't matter what zone or subzone you are in
- ItemID - the Item number to search for in bags and equipped
- Target - Only use the item if your have this targetted or (see next)
- Aim - for fast moving targets, will attempt to target before using item

The further down the list the higher the priority (by overwriting previous ones)
As such the more generic the zone and target, the higher up it should go.  Also
aimed entries should go above non-aimed.
--]]

function DailyItem_AddArrayLine(Zone,SubZone,Item,Target,Aim,Quest)
  local index = table.getn(DailyItem_LocalItems) + 1;
  DailyItem_LocalItems[index] = {Zone,SubZone,Item,Target,Aim,Quest};
end

	
function DailyItem_MakeArray()
  DailyItem_LocalItems = {};
-- DailyItem_AddArrayLine(Zone,SubZone,Item,Target,Aim,Quest);

-- Random items you may find you've picked up and want to use (low priority):

  DailyItem_AddArrayLine(nul,nul,28455,nul,0,nul); -- Archmage Vargoth
  DailyItem_AddArrayLine(nul,nul,45061,nul,0,nul); -- Foam Sword
  DailyItem_AddArrayLine(nul,nul,45176,nul,0,nul); -- Foam Sword
  DailyItem_AddArrayLine(nul,nul,45177,nul,0,nul); -- Foam Sword
  DailyItem_AddArrayLine(nul,nul,45178,nul,0,nul); -- Foam Sword
  DailyItem_AddArrayLine(nul,nul,45179,nul,0,nul); -- Foam Sword

-- Next, the items that are actually from daily quests

  DailyItem_AddArrayLine(nul,nul,32971,nul,0,nul); -- Water Bucket
  DailyItem_AddArrayLine(nul,nul,33306,nul,0,nul); -- Ram Racing Reins
  DailyItem_AddArrayLine(nul,nul,41989,nul,0,nul); -- Vrykul Amulet (Jewelcrafting Daily)
  DailyItem_AddArrayLine(nul,nul,42104,nul,0,nul); -- Northern Ivory (Jewelcrafting Daily)
  DailyItem_AddArrayLine(nul,nul,42105,nul,0,nul); -- Iron Dwarf Brooch (Jewelcrafting Daily)
  DailyItem_AddArrayLine(nul,nul,42106,nul,0,nul); -- Proto Dragon Bone (Jewelcrafting Daily)
  DailyItem_AddArrayLine(nul,nul,42107,nul,0,nul); -- Elemental Armor Scrap (Jewelcrafting Daily)
  DailyItem_AddArrayLine(nul,nul,42108,nul,0,nul); -- Scourge Curio (Jewelcrafting Daily)
  DailyItem_AddArrayLine(nul,nul,43147,nul,0,nul); -- Stew Cookpot (Cooking Daily)
  DailyItem_AddArrayLine(DAL,nul,46007,nul,0,nul); -- Bag of Fishing Treasures (Cooking Daily Reward)
  DailyItem_AddArrayLine(DAL,nul,49667,nul,0,nul); -- Waterlogged Recipe (Cooking Daily Reward)
  DailyItem_AddArrayLine(DAL,nul,48679,nul,0,nul); -- Waterlogged Recipe (Cooking Daily Reward)
  DailyItem_AddArrayLine(DAL,nul,48681,nul,0,nul); -- Waterlogged Recipe (Cooking Daily Reward)
  DailyItem_AddArrayLine(DAL,nul,45328,nul,0,nul); -- Bloated Slippery Eel (Fishing Daily)
  DailyItem_AddArrayLine(DAL,nul,46004,nul,0,nul); -- Sealed Vial of Poison (Fishing Daily)
  DailyItem_AddArrayLine(HBF,SOS,20387,nul,0,nul); -- Forsaken Stink Bomb Cluster (Hallow's End)
  DailyItem_AddArrayLine(HFJ,TSH,34127,nul,0,nul); -- Tasty Reef Fish (The Kalu'ak)
  DailyItem_AddArrayLine(HFJ,"",40946,nul,0,nul);  -- Anuniaq's Net (The Kalu'ak)
  DailyItem_AddArrayLine(HFJ,WBL,45005,nul,0,nul); -- Everburning Ember (Argent Tournament)
  DailyItem_AddArrayLine(SHB,RVH,45902,nul,0,nul); -- Phantom Ghostfish (Cooking Daily)
  DailyItem_AddArrayLine(ICE,NJV,42480,nul,0,nul); -- Ebon Blade Banner (Leave Our Mark)
  DailyItem_AddArrayLine(ICE,MDG,44009,nul,0,nul); -- Flesh Giant Spine (Neutralizing the Plague)
  DailyItem_AddArrayLine(ICE,MDG,44010,nul,0,nul); -- Pustulant Spinal Fluid (Neutralizing the Plague)
  DailyItem_AddArrayLine(ICE,TBF,43968,nul,0,13288); -- Abomination Reanimation Kit (That's Abominable!)
  DailyItem_AddArrayLine(ICE,TBF,43968,nul,0,13289); -- Abomination Reanimation Kit (That's Abominable!)
  DailyItem_AddArrayLine(ICE,TBF,43968,nul,0,13264); -- Abomination Reanimation Kit (That's Abominable!)
  DailyItem_AddArrayLine(ICE,TBF,43968,nul,0,13276); -- Abomination Reanimation Kit (That's Abominable!)
  DailyItem_AddArrayLine(ICE,TBF,43608,nul,0,13261); -- Copperclaw's Volatile Oil (Volatility)
  DailyItem_AddArrayLine(ICE,TBF,43608,nul,0,13239); -- Copperclaw's Volatile Oil (Volatility)
  DailyItem_AddArrayLine(ICE,ADG,44476,nul,0,13346); -- Alumeth's Skull (No Rest For The Wicked)
  DailyItem_AddArrayLine(ICE,ADG,44480,nul,0,13346); -- Alumeth's Remains (No Rest For The Wicked)
  DailyItem_AddArrayLine(ICE,ADG,44476,nul,0,13350); -- Alumeth's Skull (No Rest For The Wicked)
  DailyItem_AddArrayLine(ICE,ADG,44480,nul,0,13350); -- Alumeth's Remains (No Rest For The Wicked)
  DailyItem_AddArrayLine(ICE,ADG,44476,nul,0,13367); -- Alumeth's Skull (No Rest For The Wicked)
  DailyItem_AddArrayLine(ICE,ADG,44480,nul,0,13367); -- Alumeth's Remains (No Rest For The Wicked)
  DailyItem_AddArrayLine(ICE,ADG,44476,nul,0,13368); -- Alumeth's Skull (No Rest For The Wicked)
  DailyItem_AddArrayLine(ICE,ADG,44480,nul,0,13368); -- Alumeth's Remains (No Rest For The Wicked)
  DailyItem_AddArrayLine(ICE,ADG,44304,nul,0,nul); -- Writhing Mass
  DailyItem_AddArrayLine(ICE,ADG,44246,DSJ,0,nul); -- Orb of Illusion
  DailyItem_AddArrayLine(ICE,ADG,44433,ESM,0,nul); -- Rod of Siphoning
  DailyItem_AddArrayLine(ICE,ADG,44307,nul,0,13321); -- Diluted Cult Tonic (Retest Now)
  DailyItem_AddArrayLine(ICE,ADG,44307,nul,0,13322); -- Diluted Cult Tonic (Retest Now)
  DailyItem_AddArrayLine(ICE,ADG,44307,nul,0,13356); -- Diluted Cult Tonic (Retest Now)
  DailyItem_AddArrayLine(ICE,ADG,44307,nul,0,13357); -- Diluted Cult Tonic (Retest Now)
  DailyItem_AddArrayLine(ICE,ADG,44301,nul,0,13321); -- Tainted Essence (Retest Now)
  DailyItem_AddArrayLine(ICE,ADG,44301,nul,0,13322); -- Tainted Essence (Retest Now)
  DailyItem_AddArrayLine(ICE,ADG,44301,nul,0,13356); -- Tainted Essence (Retest Now)
  DailyItem_AddArrayLine(ICE,ADG,44301,nul,0,13357); -- Tainted Essence (Retest Now)
  DailyItem_AddArrayLine(ICE,VFH,44212,SRF,1,13313); -- SGM-3
  DailyItem_AddArrayLine(ICE,VFH,44212,SRF,1,13331); -- SGM-3
  DailyItem_AddArrayLine(ICE,DRS,38556,nul,0,nul);
  DailyItem_AddArrayLine(ZLD,KOL,38556,nul,0,nul);
  DailyItem_AddArrayLine(NAG,HAL,38556,nul,0,nul);
  DailyItem_AddArrayLine(IQD,"",34489,nul,0,nul);
  DailyItem_AddArrayLine(IQD,SRH,34338,nul,0,nul);
  DailyItem_AddArrayLine(IQD,SRA,34500,nul,0,nul);
  DailyItem_AddArrayLine(IQD,TBO,34489,nul,0,nul);
  DailyItem_AddArrayLine(IQD,TSO,34489,nul,0,nul);
  DailyItem_AddArrayLine(IQD,TDC,34489,nul,0,nul);
  DailyItem_AddArrayLine(IQD,TDS,34533,nul,0,nul);
  DailyItem_AddArrayLine(IQD,TDS,34414,EOH,0,nul);
  DailyItem_AddArrayLine(IQD,GGC,34533,nul,0,nul);
  DailyItem_AddArrayLine(IQD,GGC,34483,nul,0,nul);
  DailyItem_AddArrayLine(IQD,DSV,34533,nul,0,nul);
  DailyItem_AddArrayLine(IQD,DES,34475,nul,0,nul);
  DailyItem_AddArrayLine(IQD,nul,34368,ERS,0,nul);
  DailyItem_AddArrayLine(TKF,RTR,34255,nul,0,nul);
  DailyItem_AddArrayLine(TSP,FJA,42246,nul,0,nul);
  DailyItem_AddArrayLine(TSP,THF,42164,nul,0,nul);
  DailyItem_AddArrayLine(TSP,VAW,42769,WWM,1,13003); -- Spear of Hodir (Thrusting Hodir's Spear)
  DailyItem_AddArrayLine(TSP,VAW,42479,CFW,0,nul);
  DailyItem_AddArrayLine(TSP,VAW,42774,RJM,0,nul);
  DailyItem_AddArrayLine(TSP,TFM,42837,EVK,1,nul);
  DailyItem_AddArrayLine(TSP,GMB,46885,SBF,1,nul); -- Weighted Net (Argent Tournament)
  DailyItem_AddArrayLine(TSP,TPF,42499,nul,0,nul); -- Reins of the Warbear Matriarch (Back to the Pit)
  DailyItem_AddArrayLine(DRB,DML,45000,nul,0,nul);
  DailyItem_AddArrayLine(COS,"",37888,nul,0,nul);
  DailyItem_AddArrayLine(DUR,"",33096,nul,0,nul);
  DailyItem_AddArrayLine(ULD,SOI,46029,nul,0,nul);
  DailyItem_AddArrayLine(GZH,AWL,44986,nul,0,nul);
  DailyItem_AddArrayLine(BNT,COL,35506,NDH,1,nul);
  DailyItem_AddArrayLine(BNT,NEX,35506,NDH,1,nul);

-- The Occulus drakes

  DailyItem_AddArrayLine(nul,nul,37815,nul,0,nul);
  DailyItem_AddArrayLine(nul,nul,37860,nul,0,nul);
  DailyItem_AddArrayLine(nul,nul,37859,nul,0,nul);

-- Now for items you will use again and again in PvP battles:

  DailyItem_AddArrayLine(SOA,nul,39213,nul,0,nul); -- Massive Seaforium Charge
  DailyItem_AddArrayLine(WTG,nul,42986,nul,0,nul); -- The RP-GG
  DailyItem_AddArrayLine(IOC,nul,46847,nul,0,nul); -- Seaforium Bombs
  DailyItem_AddArrayLine(IOC,nul,47030,nul,0,nul); -- Huge Seaforium Bombs

-- Other repeated stuff

  DailyItem_AddArrayLine(ICC,nul,49278,nul,0,nul); -- Goblin Rocket Pack (ICC Gunship)

end