DailyItem_ADDONNAME = "DailyItems";
DailyItem_MACRONAME = "DailyItem";
DailyItem_VERSION = "0.93-20100617";

SLASH_DAILYITEM1, SLASH_DAILYITEM2 = '/dailyitem', '/di';
function SlashCmdList.DAILYITEM(msg)
  if (msg == "zone") then
    DailyItem_Print("Zone = ["..GetRealZoneText().."]");
    DailyItem_Print("SubZone = ["..GetSubZoneText().."]");
  else
    DailyItem_QuestComplete();
  end
end

-- I want this to run when you log in, update bag contents, swap zones, or change targets.

function DailyItem_OnLoad()
  this:RegisterEvent("PLAYER_LOGIN");
  this:RegisterEvent("BAG_UPDATE");
  this:RegisterEvent("ZONE_CHANGED");
  this:RegisterEvent("PLAYER_TARGET_CHANGED");
end

function DailyItem_OnEvent()
  if (InCombatLockdown()) then return; end

  if (event == "PLAYER_LOGIN") then
    if (GetMacroIndexByName(DailyItem_MACRONAME) == 0) then
      local numGenMacros, numCharMacros = GetNumMacros();
      if (numGenMacros < 36) then
        CreateMacro(DailyItem_MACRONAME, 12, "", nil, nil)
      else
        DailyItem_Print("You have 36 General Macros. Cannot add "..DailyItem_MACRONAME.."!");
      end
    end
  end
  DailyItem_MakeArray();
  DailyItem_Go();
end

function DailyItem_Print(msg)
  if ((msg) and (strlen(msg) > 0)) then
    if (DEFAULT_CHAT_FRAME) then
      DEFAULT_CHAT_FRAME:AddMessage(msg, 1, 1, 0);
    end
  end
end

function DailyItem_QuestComplete(questID)
  local numEntries, numQuests = GetNumQuestLogEntries();
  local retval = true;
  for dailyindex = 1,numEntries do
    local questTitle, level, questTag, suggestedGroup, isHeader, isCollapsed, isComplete, isDaily = GetQuestLogTitle(dailyindex);
    if (not isHeader) then
      if (questID) then
        local checkQuestID = GetQuestLink(dailyindex):match("\124Hquest:(%d+):");
        if (tonumber(checkQuestID) == questID) then
          if (not isComplete) then
            retval = false;
          end
        end
      elseif (isDaily) then
        if (isComplete) then
          DailyItem_Print("Completed Daily = "..GetQuestLink(dailyindex));
        end
      end
    end
  end
  return retval;
end

function DailyItem_Go()

  macroText = "";

  for index = 1, table.getn(DailyItem_LocalItems), 1 do
    if (DailyItem_LocalItems[index][1] == GetRealZoneText()) or (not DailyItem_LocalItems[index][1]) then
      if (DailyItem_LocalItems[index][2] == GetSubZoneText()) or (not DailyItem_LocalItems[index][2]) then
        if (not DailyItem_LocalItems[index][6]) or (not DailyItem_QuestComplete(DailyItem_LocalItems[index][6])) then

-- First check through bags

          for bagID = 0, 4, 1 do
            local bagSlotCnt = GetContainerNumSlots(bagID);
            if (bagSlotCnt > 0) then
              for slot = 1, bagSlotCnt, 1 do
                local itemLink = GetContainerItemLink(bagID, slot);
                local itemNumber = tonumber(DailyItem_NumFromLink(itemLink));
                if (itemNumber) then
                  if (DailyItem_LocalItems[index][3] == itemNumber) then
                    if (not DailyItem_LocalItems[index][4]) or ((DailyItem_LocalItems[index][4] == UnitName("target")) and (DailyItem_LocalItems[index][5] == 0)) then
                      macroText = "#showtooltip\n/use item:"..itemNumber;
                    elseif (DailyItem_LocalItems[index][5] ~= 0) then
                      macroText = "#showtooltip\n/target [noexists] "..DailyItem_LocalItems[index][4].."\n/use item:"..itemNumber;
                    end
                  end
                end
              end
            end
          end

-- Then check for equipped items

          for equipID = 0, 19, 1 do 
            local itemNumber = GetInventoryItemID("player",equipID);
            if (itemNumber) then 
              if (DailyItem_LocalItems[index][3] == itemNumber) then
                if (not DailyItem_LocalItems[index][4]) or ((DailyItem_LocalItems[index][4] == UnitName("target")) and (DailyItem_LocalItems[index][5] == 0)) then
                  macroText = "#showtooltip\n/use item:"..itemNumber;
                elseif (DailyItem_LocalItems[index][5] ~= 0) then
                  macroText = "#showtooltip\n/target [noexists] "..DailyItem_LocalItems[index][4].."\n/use item:"..itemNumber;
                end
              end
            end
          end

        end
      end
    end
  end

  if (macroText) then
    EditMacro(DailyItem_MACRONAME, DailyItem_MACRONAME, 1, macroText, nil, nil);
  end
end

function DailyItem_NumFromLink(itemLink)
  if (not itemLink) then
    return nil;
  end
  local _, _, itemNumber = strfind(itemLink, "item:(%d+):");
  return itemNumber;
end
