--[[
    Soundtrack addon for World of Warcraft

    Zone events functions.
    Functions that manage zone change events.
]]

-- Finds the continent name, based on the zone name
local function FindContinentByZone(zoneName)
    -- TODO : Search zone list instead of relying on map
    local eventTable = Soundtrack.Events.GetTable("Zone");

	inInstance, instanceType = IsInInstance();
	if inInstance then
		if instanceType == "arena" or instanceType == "pvp" then
			return "PvP";
		end
		if instanceType == "party" or instanceType == "raid" then
			return "Instances";
		end
	end
	
    if eventTable then 
        for k, v in pairs(eventTable) do
            -- Find tracks to remove
            if string.find(k, zoneName) then
                local i1, i2  = string.find(k, "[^/]*/");
                if i1 and i2 then
                    return string.sub(k, i1, i2-1);
                end
            end
        end
    end
    return "Instances";  -- Uncategorized stuff, usually is outside part of an instance
end

-- After migration, zone events have no priorities set. We only
-- discover them as we figure out which parent zones exist
local function AssignPriority(tableName, eventName, priority)
    local event = Soundtrack.GetEventByName(tableName, eventName)
    if event then
        event.priority = priority
    end

end

-- IsInInstance()

local function OnZoneChanged()
    
    local zoneText = GetRealZoneText();
    local continentText = FindContinentByZone(zoneText);    
    local zoneSubText = GetSubZoneText();
    local minimapZoneText = GetMinimapZoneText();
    
    Soundtrack.TraceZones("continentText: " .. continentText);
    Soundtrack.TraceZones("zoneText: " .. zoneText);
    Soundtrack.TraceZones("zoneSubText: " .. zoneSubText);
    Soundtrack.TraceZones("minimapZoneText:" .. minimapZoneText);
    
    -- Construct full zone path
    
    local zoneText1, zoneText2, zoneText3, zoneText4;
    
    local zonePath;
        
    if not Soundtrack.IsNullOrEmpty(continentText) then
        zoneText1 = continentText;
		Soundtrack.TraceZones("zoneText1: " .. zoneText1);
        zonePath = continentText;
    end
        
    if not Soundtrack.IsNullOrEmpty(zoneText) then
        zoneText2 = continentText .. "/" .. zoneText;
		Soundtrack.TraceZones("zoneText2: " .. zoneText2);
        zonePath = zoneText2;
        Soundtrack.Events.RenameEvent("Zone", zoneText, zoneText2);
    end
    

    if zoneText ~= zoneSubText and not Soundtrack.IsNullOrEmpty(zoneSubText) then
        zoneText3 = zonePath .. "/" .. zoneSubText;
		Soundtrack.TraceZones("zoneText3: " .. zoneText3);
        zonePath = zoneText3;
        Soundtrack.Events.RenameEvent("Zone", zoneSubText, zoneText3);
    end
    
    if zoneText ~= minimapZoneText and zoneSubText ~= minimapZoneText and not Soundtrack.IsNullOrEmpty(minimapZoneText) then
        zoneText4 = zonePath .. "/" .. minimapZoneText;
		Soundtrack.TraceZones("zoneText4: " .. zoneText4);
        zonePath = zoneText4;
        Soundtrack.Events.RenameEvent("Zone", minimapZoneText, zoneText4);
    end
    
    Soundtrack.TraceZones("Zone: " .. zonePath);
    
    if zoneText4 then
        if Soundtrack.Settings.AutoAddZones then
			local eventTable = Soundtrack.Events.GetTable("Zone")
			if eventTable[zoneText4] == nil then
				Soundtrack.AddEvent("Zone", zoneText4, 4, true)
			end
        end
		AssignPriority("Zone", zoneText4, 4)
        Soundtrack.PlayEvent("Zone", zoneText4);
    else
        Soundtrack.StopEventAtLevel(4);
    end
    
    if zoneText3 then
        if Soundtrack.Settings.AutoAddZones then
			local eventTable = Soundtrack.Events.GetTable("Zone")
			if eventTable[zoneText3] == nil then
				Soundtrack.AddEvent("Zone", zoneText3, 3, true)
			end
        end
		AssignPriority("Zone", zoneText3, 3)
        Soundtrack.PlayEvent("Zone", zoneText3);
    else
        Soundtrack.StopEventAtLevel(3);
    end
    
    if zoneText2 then
        if Soundtrack.Settings.AutoAddZones then
			local eventTable = Soundtrack.Events.GetTable("Zone")
			if eventTable[zoneText2] == nil then
				Soundtrack.AddEvent("Zone", zoneText2, 2, true)
			end
        end
		AssignPriority("Zone", zoneText2, 2)
        Soundtrack.PlayEvent("Zone", zoneText2);
    else        
        Soundtrack.StopEventAtLevel(2);
    end
    
    if zoneText1 then
        if Soundtrack.Settings.AutoAddZones then
			local eventTable = Soundtrack.Events.GetTable("Zone")
			if eventTable[zoneText1] == nil then
				Soundtrack.AddEvent("Zone", zoneText1, 1, true)
			end
        end
		AssignPriority("Zone", zoneText1, 1)
        Soundtrack.PlayEvent("Zone", zoneText1);
    else        
        Soundtrack.StopEventAtLevel(1);
    end
   
end



Soundtrack.ZoneEvents = 
{
}

function Soundtrack.ZoneEvents.OnLoad()
    this:RegisterEvent("ZONE_CHANGED_NEW_AREA")
    this:RegisterEvent("ZONE_CHANGED")
    this:RegisterEvent("ZONE_CHANGED_INDOORS")
    this:RegisterEvent("PLAYER_REGEN_ENABLED")
    this:RegisterEvent("MINIMAP_ZONE_CHANGED")
    this:RegisterEvent("VARIABLES_LOADED")
end
    
function Soundtrack.ZoneEvents.OnEvent(arg1, arg2)
    if not Soundtrack.Settings.EnableZoneMusic then
        return
    end
	
	Soundtrack.Trace(event);
	
    if event == "ZONE_CHANGED" or 
       event == "ZONE_CHANGED_INDOORS" or
	   event == "ZONE_CHANGED_NEW_AREA" or
       event == "MINIMAP_ZONE_CHANGED" or
       event == "VARIABLES_LOADED" then
		Soundtrack.TraceZones("Event: "..event);
        OnZoneChanged()
    end
end    

function Soundtrack.ZoneEvents.Initialize()
    -- Add default zones
    local continentNames = { GetMapContinents() }
    
    local tableName = Soundtrack.Events.GetTable("Zone");
    
    Soundtrack.AddEvent("Zone", "Instances", 1, true);
	Soundtrack.AddEvent("Zone", "PvP", 1, true);
	Soundtrack.AddEvent("Zone", "Uncategorized", 1, true);
    
    for i,continentName in ipairs(continentNames) do      
        Soundtrack.AddEvent("Zone", continentName, 1, true);
        local zoneNames = { GetMapZones(i) };
        for j,zoneName in ipairs(zoneNames) do
            local oldName = zoneName;
            local newName = continentName .. "/" .. zoneName;
            
            Soundtrack.Events.RenameEvent("Zone", oldName, newName); 
            Soundtrack.AddEvent("Zone", newName, 2, true);
            Soundtrack.Events.DeleteEvent("Zone", oldName);
        end
    end 
       
end