/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;

public class SoundtrackMusicGUI
extends JFrame {
    private Junction junc;
    private Soundtrack st;
    private File curAddDir;
    private boolean enableJunc = true;
    private JMenuItem AboutJunctions;
    private JMenuItem AddFile;
    private JMenuItem AddFolder;
    private JMenuItem CreateSoundtrackMusic;
    private JMenuItem DeleteFile;
    private JMenu DeleteFiles;
    private JMenuItem DeleteFolder;
    private JCheckBoxMenuItem EnableJunctions;
    private JMenuItem ExitManager;
    private JSeparator FileMenuSeparator;
    private JMenu HelpMenu;
    private JMenuBar MenuBar;
    private JMenu OptionsMenu;
    private JScrollPane ScrollPanel;
    private JTextArea TextArea;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;

    public SoundtrackMusicGUI() {
        this.initComponents();
        try {
            this.junc = new Junction(this.TextArea);
        }
        catch (Exception ex) {
            Logger.getLogger(SoundtrackMusicGUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.st = new Soundtrack(this.TextArea);
        if (this.st.getWrongFolder()) {
            JOptionPane.showMessageDialog(this, "Soundtrack addon is not in World of Warcraft\\Interface\\Addons.\n\nSoundtrack is in " + this.st.getAddonDir() + ".\n\n" + "Please move to the correct folder, then run Soundtrack Music Manager.", "Soundtrack in wrong folder", 0);
            System.exit(0);
        }
        JOptionPane.showMessageDialog(this, "Welcome to Soundtrack Music Manager!\n\nJunctions enabled.\n\nClick Options to change.\nClick Help for more information about Junctions.");
    }

    private void initComponents() {
        this.ScrollPanel = new JScrollPane();
        this.TextArea = new JTextArea();
        this.MenuBar = new JMenuBar();
        this.DeleteFiles = new JMenu();
        this.AddFile = new JMenuItem();
        this.AddFolder = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.DeleteFile = new JMenuItem();
        this.DeleteFolder = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.CreateSoundtrackMusic = new JMenuItem();
        this.FileMenuSeparator = new JSeparator();
        this.ExitManager = new JMenuItem();
        this.OptionsMenu = new JMenu();
        this.EnableJunctions = new JCheckBoxMenuItem();
        this.HelpMenu = new JMenu();
        this.AboutJunctions = new JMenuItem();
        this.setDefaultCloseOperation(3);
        this.setTitle("Soundtrack Music Manager");
        this.setFocusCycleRoot(false);
        this.setForeground(Color.white);
        this.setLocationByPlatform(true);
        this.TextArea.setColumns(20);
        this.TextArea.setEditable(false);
        this.TextArea.setRows(5);
        this.TextArea.setText("Soundtrack Music Manager\n  Created by Lunaqua\n  Source Code by Yess (Epic Music Player)\n\nSoundtrack: Music Addon for World of Warcraft\n  Created by Morricone\n  Maintenance by FluffyBearLina\n  Maintained by Lunaqua\n\nFound at:\nhttp://wow.curse.com/downloads/wow-addons/details/soundtrack.aspx\n\n");
        this.ScrollPanel.setViewportView(this.TextArea);
        this.DeleteFiles.setText("File");
        this.AddFile.setIcon(new ImageIcon(this.getClass().getResource("/Icons/Add File.png")));
        this.AddFile.setText("Add MP3 File(s)");
        this.AddFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SoundtrackMusicGUI.this.AddFileActionPerformed(evt);
            }
        });
        this.DeleteFiles.add(this.AddFile);
        this.AddFolder.setIcon(new ImageIcon(this.getClass().getResource("/Icons/Add Folder.png")));
        this.AddFolder.setText("Add Music Folder(s)");
        this.AddFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SoundtrackMusicGUI.this.AddFolderActionPerformed(evt);
            }
        });
        this.DeleteFiles.add(this.AddFolder);
        this.DeleteFiles.add(this.jSeparator2);
        this.DeleteFile.setIcon(new ImageIcon(this.getClass().getResource("/Icons/Delete File.png")));
        this.DeleteFile.setText("Delete MP3 File(s)");
        this.DeleteFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SoundtrackMusicGUI.this.DeleteFileActionPerformed(evt);
            }
        });
        this.DeleteFiles.add(this.DeleteFile);
        this.DeleteFolder.setIcon(new ImageIcon(this.getClass().getResource("/Icons/Delete Folder.png")));
        this.DeleteFolder.setText("Delete Music Folder(s)");
        this.DeleteFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SoundtrackMusicGUI.this.DeleteFolderActionPerformed(evt);
            }
        });
        this.DeleteFiles.add(this.DeleteFolder);
        this.DeleteFiles.add(this.jSeparator1);
        this.CreateSoundtrackMusic.setIcon(new ImageIcon(this.getClass().getResource("/Icons/Add SoundtrackMusic Folder.png")));
        this.CreateSoundtrackMusic.setText("Create SoundtrackMusic Folder");
        this.CreateSoundtrackMusic.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SoundtrackMusicGUI.this.CreateSoundtrackMusicActionPerformed(evt);
            }
        });
        this.DeleteFiles.add(this.CreateSoundtrackMusic);
        this.DeleteFiles.add(this.FileMenuSeparator);
        this.ExitManager.setText("Exit Manager");
        this.ExitManager.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SoundtrackMusicGUI.this.ExitManagerActionPerformed(evt);
            }
        });
        this.DeleteFiles.add(this.ExitManager);
        this.MenuBar.add(this.DeleteFiles);
        this.OptionsMenu.setText("Options");
        this.EnableJunctions.setSelected(true);
        this.EnableJunctions.setText("Enable Junctions");
        this.EnableJunctions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SoundtrackMusicGUI.this.EnableJunctionsActionPerformed(evt);
            }
        });
        this.OptionsMenu.add(this.EnableJunctions);
        this.MenuBar.add(this.OptionsMenu);
        this.HelpMenu.setText("Help");
        this.AboutJunctions.setText("About Junctions");
        this.AboutJunctions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SoundtrackMusicGUI.this.AboutJunctionsActionPerformed(evt);
            }
        });
        this.HelpMenu.add(this.AboutJunctions);
        this.MenuBar.add(this.HelpMenu);
        this.setJMenuBar(this.MenuBar);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.ScrollPanel, -1, 537, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.ScrollPanel, -1, 285, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void AddFolderActionPerformed(ActionEvent evt) {
        JFileChooser jf = new JFileChooser();
        jf.setFileSelectionMode(1);
        jf.setMultiSelectionEnabled(true);
        if (this.curAddDir == null) {
            jf.setCurrentDirectory(this.curAddDir);
        }
        int returnVal = jf.showOpenDialog(this);
        this.curAddDir = jf.getCurrentDirectory();
        File[] files = jf.getSelectedFiles();
        this.st.resetCounts();
        int junccount = 0;
        if (returnVal == 0) {
            int i;
            if (this.enableJunc) {
                try {
                    for (i = 0; i < files.length; ++i) {
                        File destf = new File(this.st.getMusicDir() + "\\" + files[i].getName());
                        String linkname = destf.getParentFile() + "\\j-" + destf.getName();
                        this.junc.createlink(linkname, files[i].getPath());
                        this.st.Log("Creating junction to " + destf.getPath());
                        ++junccount;
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(SoundtrackMusicGUI.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            if (!this.enableJunc) {
                for (i = 0; i < files.length; ++i) {
                    File f = files[i];
                    String psrcpath = f.getPath();
                    String musDirName = f.getName();
                    String destpath = this.st.getMusicDir().getPath() + "\\" + musDirName;
                    this.st.CopyAddFiles(psrcpath, destpath);
                }
            }
        }
        if (junccount > 0) {
            this.st.Log("Summary: Added " + junccount + " junction(s).\n");
        } else {
            this.st.Log("Summary: Added " + this.st.getmp3count() + " mp3 file(s).\n");
        }
    }

    private void ExitManagerActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void EnableJunctionsActionPerformed(ActionEvent evt) {
        this.enableJunc = this.EnableJunctions.isSelected();
    }

    private void AboutJunctionsActionPerformed(ActionEvent evt) {
        JOptionPane.showMessageDialog(this, "Junctions create a link (NTFS Junction Point) from one folder to another folder.\n\nTo delete a junction, go to SoundtrackMusic and manually delete it.\n\nWARNING: When deleteing a Junction Point or a folder containing a Junction Point\nin Windows XP, ALWAYS use Shift+Del to safely delete the link. If not, it is\npossible to delete the linked folder, and thus the music inside of the folder.\n\nFor more information, see:\nhttp://en.wikipedia.org/wiki/NTFS_junction_point", "About Junctions", -1);
    }

    private void AddFileActionPerformed(ActionEvent evt) {
        JFileChooser jf = new JFileChooser();
        jf.setFileSelectionMode(2);
        jf.setMultiSelectionEnabled(true);
        if (this.curAddDir == null) {
            jf.setCurrentDirectory(this.curAddDir);
        }
        int returnVal = jf.showOpenDialog(this);
        this.curAddDir = jf.getCurrentDirectory();
        File[] files = jf.getSelectedFiles();
        this.st.resetCounts();
        if (returnVal == 0) {
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                String srcpath = f.getPath();
                String musFileName = f.getName();
                String destpath = this.st.getMusicDir().getPath() + "\\" + musFileName;
                this.st.CopyAddFiles(srcpath, destpath);
            }
        }
        this.st.Log("Summary: Added " + this.st.getmp3count() + " mp3 file(s).\n");
    }

    private void DeleteFileActionPerformed(ActionEvent evt) {
        JFileChooser jf = new JFileChooser();
        jf.setFileSelectionMode(2);
        jf.setMultiSelectionEnabled(true);
        jf.setCurrentDirectory(this.st.getMusicDir());
        int returnVal = jf.showOpenDialog(this);
        File[] files = jf.getSelectedFiles();
        this.st.resetCounts();
        if (returnVal == 0) {
            for (int i = 0; i < files.length; ++i) {
                File f = files[i];
                String musFileName = f.getName();
                String destpath = this.st.getMusicDir().getPath() + "\\" + musFileName;
                this.st.DeleteFiles(destpath);
            }
        }
        this.st.Log("Summary: Deleted " + this.st.getmp3count() + " mp3 file(s).\n");
    }

    private void DeleteFolderActionPerformed(ActionEvent evt) {
        JFileChooser jf = new JFileChooser();
        jf.setFileSelectionMode(1);
        jf.setMultiSelectionEnabled(true);
        jf.setCurrentDirectory(this.st.getMusicDir());
        int returnVal = jf.showOpenDialog(this);
        File[] files = jf.getSelectedFiles();
        this.st.resetCounts();
        int junccount = 0;
        if (returnVal == 0) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].getName().contains("j-") || files[i].getName().contains("junction-")) {
                    boolean deleted = files[i].delete();
                    ++junccount;
                    continue;
                }
                File f = files[i];
                String musDirName = f.getName();
                File destpath = new File(this.st.getMusicDir().getPath() + "\\" + musDirName);
                this.st.DeleteFiles(destpath.getPath());
                destpath.delete();
            }
        }
        this.st.Log("Summary: Deleted " + junccount + " junction(s).");
        this.st.Log("Summary: Deleted " + this.st.getmp3count() + " mp3 file(s).\n");
    }

    private void CreateSoundtrackMusicActionPerformed(ActionEvent evt) {
        this.st.CopyAddFiles(this.st.getAddonDir().getPath() + "\\SoundtrackMusic", this.st.getMusicDir().getPath());
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new SoundtrackMusicGUI().setVisible(true);
            }
        });
    }
}

