/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextArea;

public class Soundtrack {
    private File addonDir;
    private File musicDir;
    private boolean wrongFolder;
    private int mp3count;
    private JTextArea TextArea;

    public Soundtrack(JTextArea jta) {
        this.setDirectories();
        this.resetCounts();
        this.setTextArea(jta);
    }

    private void setDirectories() {
        this.wrongFolder = false;
        String curDir = System.getProperty("user.dir");
        curDir = curDir.substring(0, curDir.length() - 14);
        this.addonDir = new File(curDir);
        String d = curDir.substring(curDir.length() - 6 - 11);
        if (!d.equalsIgnoreCase("addons\\soundtrack")) {
            this.wrongFolder = true;
        }
        this.musicDir = new File(this.addonDir + "Music");
        if (!this.musicDir.exists()) {
            this.musicDir.mkdir();
        }
    }

    public File getAddonDir() {
        return this.addonDir;
    }

    public File getMusicDir() {
        return this.musicDir;
    }

    public int getmp3count() {
        return this.mp3count;
    }

    public void resetCounts() {
        this.mp3count = 0;
    }

    public boolean getWrongFolder() {
        return this.wrongFolder;
    }

    private void setTextArea(JTextArea jta) {
        this.TextArea = jta;
    }

    public void CopyAddFiles(String strPath, String dstPath) {
        File src = new File(strPath);
        File dest = new File(dstPath);
        if (src.isDirectory()) {
            boolean created = dest.mkdirs();
            String[] list = src.list();
            for (int i = 0; i < list.length; ++i) {
                String dest1 = dest.getAbsolutePath() + File.separator + list[i];
                String src1 = src.getAbsolutePath() + File.separator + list[i];
                this.CopyAddFiles(src1, dest1);
            }
        } else {
            try {
                String ext = src.getName().toUpperCase();
                if (ext.endsWith(".MP3") || ext.endsWith(".TOC")) {
                    if (ext.endsWith(".MP3")) {
                        this.Log("Copying " + src.getName() + "   (" + src.getPath() + ")");
                        ++this.mp3count;
                    }
                } else {
                    return;
                }
                FileChannel sourceChannel = new FileInputStream(src).getChannel();
                FileChannel targetChannel = new FileOutputStream(dest).getChannel();
                sourceChannel.transferTo(0L, sourceChannel.size(), targetChannel);
                sourceChannel.close();
                targetChannel.close();
            }
            catch (IOException ex) {
                Logger.getLogger(SoundtrackMusicGUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void DeleteFiles(String strPath) {
        File src = new File(strPath);
        if (src.isDirectory()) {
            String[] list = src.list();
            for (int i = 0; i < list.length; ++i) {
                String src1 = src.getAbsolutePath() + File.separator + list[i];
                this.DeleteFiles(src1);
                src.delete();
            }
        } else {
            String ext = src.getName().toUpperCase();
            if (ext.endsWith(".MP3")) {
                this.Log("Deleting " + src.getName() + "   (" + src.getPath() + ")");
                ++this.mp3count;
                src.delete();
            } else {
                return;
            }
        }
    }

    public void Log(String str) {
        this.TextArea.append(str + "\n");
        this.TextArea.validate();
    }
}

