--[[

    
    SoulSpeak reacts to various soul events using emotes and quotes!
    Copyright (C) 2007-2010 Lilih @ The Venture Co. (EU)

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

    
--]]

local _, class = UnitClass("player")
if class ~= "WARLOCK" then return end

local L = LibStub("AceLocale-3.0"):GetLocale("SoulSpeak")
SoulSpeak = LibStub("AceAddon-3.0"):NewAddon("SoulSpeak", 'AceEvent-3.0', 'AceConsole-3.0')

local SoulSpeak = SoulSpeak
local dropDownMenu, db
local SSamount
local SStarget = ""
local targetClass, englishClass
local genderTable
local	SSgenderTable1
local	SSgenderTable2
local	SSgenderTable3
local	SSgenderTable4
local DemonName = ""
local SSid = 6265
local HSspell = GetSpellInfo(8690)
local RSOspell = GetSpellInfo(58887)
local RSUspell = GetSpellInfo(698)
local SSRspell = GetSpellInfo(47883)
local summonFGRD = GetSpellInfo(30146)
local summonFEL = GetSpellInfo(691)
local summonIMP = GetSpellInfo(688)
local summonSUC = GetSpellInfo(712)
local summonVOID = GetSpellInfo(697)
local summonVOIDnomana = GetSpellInfo(25112)

local HearthstoneStyles = {
	"|cff00ff00"..L.HSBLINK, "|cffffd200"..L.HSSMILE, "|cffff6b00"..L.HSGOING, "|cffff2f32"..L.HSYAWN,
	"|cfff58cba"..L.HSWAVE, "|cffffdbad"..L.HSFAREWELL, "|cff7777aa"..L.HSTIRED, "|cff00ff00"..L.HSSMIRK,
	"|cffffd200"..L.HSPRAISE, "|cffff6b00"..L.HSLOVE,	"|cffff2f32"..L.HSLOST, "|cfff58cba"..L.HSKISS,
	"|cffffdbad"..L.HSGAZE,	"|cff7777aa"..L.HSABSENT,
}
local HearthstoneEmotes = {
	"BLINK", "SMILE", "GOING", "YAWN", "WAVE", "BYE", "TIRED",
	"SMIRK", "PRAISE", "LOVE", "LOST", "KISS", "GAZE", "ABSENT",
}
local ResurrectedStyles = {
	"|cff00ff00"..L.REZTHANK, "|cffffd200"..L.REZHUG, "|cffff6b00"..L.REZBLINK, "|cffff2f32"..L.REZKISS,
	"|cfff58cba"..L.REZSMILE, "|cffffdbad"..L.REZPRAISE, "|cff7777aa"..L.REZLOVE, "|cff00ff00"..L.REZGAZE,
	"|cffffd200"..L.REZABSENT, "|cffff6b00"..L.REZPURR, "|cffff2f32"..L.REZSEXY, "|cfff58cba"..L.REZDANCE,
}
local ResurrectedEmotes = {
	"THANK", "HUG", "BLINK", "KISS", "SMILE", "PRAISE",
	"LOVE", "GAZE", "ABSENT", "PURR", "SEXY", "DANCE",
}
local PartyChannels = {
	('PARTY'), ('SAY'), ('YELL'),
}
local PartyQuoteChannels = {
	"|cffaaeeff"..L.PARTY, L.SAY, "|cffff2f32"..L.YELL,
}
local RaidChannels = {
	('PARTY'), ('RAID'), ('SAY'), ('YELL'),
}
local RaidQuoteChannels = {
	"|cffaaeeff"..L.PARTY, "|cffff6b00"..L.RAID, L.SAY, "|cffff2f32"..L.YELL,
}
local SoloChannels = {
	('CHAT'), ('SAY'), ('YELL'),
}
local SoloQuoteChannels = {
	"|cffffdbad"..L.CHAT, L.SAY, "|cffff2f32"..L.YELL,
}
local SoulSoloChannels = {
	('CHAT'), ('SAY'), ('SAY'), ('YELL'), ('YELL'),
}
local SoulSoloQuoteChannels = {
	"|cffffdbad"..L.CHAT, L.SAY, L.SAYWHISPER, "|cffff2f32"..L.YELL, "|cffff2f32"..L.YELLWHISPER,
}
local SoulPartyChannels = {
	('PARTY'), ('PARTY'), ('SAY'), ('SAY'), ('YELL'), ('YELL'),
}
local SoulPartyQuoteChannels = {
	"|cffaaeeff"..L.PARTY, "|cffaaeeff"..L.PARTYWHISPER, L.SAY, L.SAYWHISPER, "|cffff2f32"..L.YELL, "|cffff2f32"..L.YELLWHISPER,
}
local SoulRaidChannels = {
	('PARTY'), ('PARTY'), ('RAID'), ('RAID'), ('SAY'), ('SAY'), ('YELL'), ('YELL'),
}
local SoulRaidQuoteChannels = {
	"|cffaaeeff"..L.PARTY, "|cffaaeeff"..L.PARTYWHISPER, "|cffff6b00"..L.RAID, "|cffff6b00"..L.RAIDWHISPER, L.SAY,
	L.SAYWHISPER, "|cffff2f32"..L.YELL, "|cffff2f32"..L.YELLWHISPER,
}

local toggle_option = { 
	name = function(info) return SoulSpeak:GetName(info) end,
	desc = function(info) if string.find(info[#info], L.FGRD) then return db.SUMfgrdQuotes[tonumber(string.match(info[#info], "%d%d"))]
	elseif string.find(info[#info], L.FEL) then return db.SUMfelQuotes[tonumber(string.match(info[#info], "%d%d"))]
	elseif string.find(info[#info], L.IMP) then return db.SUMimpQuotes[tonumber(string.match(info[#info], "%d%d"))]
	elseif string.find(info[#info], L.SUC) then return db.SUMsucQuotes[tonumber(string.match(info[#info], "%d%d"))]
	elseif string.find(info[#info], L.VOID) then return db.SUMvoidQuotes[tonumber(string.match(info[#info], "%d%d"))]
	elseif string.find(info[#info], L.EMOTE) then return db.SoulstoneEmotes[tonumber(string.match(info[#info], "%d%d"))]
	elseif string.find(info[#info], L.QUOTE) then return db.SoulstoneQuotes[tonumber(string.match(info[#info], "%d%d"))]
	elseif string.find(info[#info], L.WHISPER) then return db.SoulstoneWhispers[tonumber(string.match(info[#info], "%d%d"))]
	elseif string.find(info[#info], L.RITUALSOULS) then return db.RitualSoulsQuotes[tonumber(string.match(info[#info], "%d%d"))]
	elseif string.find(info[#info], L.RITUALSUMMONING) then return db.RitualSummoningQuotes[tonumber(string.match(info[#info], "%d%d"))] end
	end,
	type = "input", get = "getSSopt", set = "setSSopt", disabled = "disSSopt",
}

local SoulSpeakBlock = LibStub("LibDataBroker-1.1"):NewDataObject("SoulSpeak", {
	type = "data source", icon = "Interface\\Icons\\Spell_Shadow_SoulGem",
	OnClick = function(self, button)
		if button == "LeftButton" and IsAltKeyDown() then
				RestartGx()
		elseif button == "RightButton" then
			if IsAltKeyDown() then
				ReloadUI()
			else
				SoulSpeak:OpenOptions()
			end
		end
	end,
	OnTooltipShow = function(tooltip)	
		SoulSpeak:UpdateSoulShardBlockText()
		local color = "|cffff0000"
		tooltip:AddLine("SoulSpeak")
		tooltip:AddLine(" ")
		if db.SSmaxDelete == true then
			local SSpercent = 100 / db.SSmaxScale
			if SSamount * SSpercent >= 83 then color = "|cff00ff00"
			elseif (SSamount * SSpercent >= 67) and (SSamount * SSpercent < 83) then color ="|cff7fff7f"
			elseif (SSamount * SSpercent >= 50) and (SSamount * SSpercent < 67) then color = "|cffffff00"
			elseif (SSamount * SSpercent >= 33) and (SSamount * SSpercent < 50) then color = "|cffffff78"
			elseif (SSamount * SSpercent >= 17) and (SSamount * SSpercent < 33) then color = "|cffff6b00"
			end
			tooltip:AddDoubleLine("\124TInterface\\Icons\\Inv_misc_bag_soulbag:14\124t |cffffffff"..L.SOULSHARDAMOUNT, "|cffffffff["..color..SSamount.."/"..db.SSmaxScale.."|cffffffff]")
		else
			tooltip:AddDoubleLine("\124TInterface\\Icons\\Inv_misc_bag_soulbag:14\124t |cffffffff"..L.SOULSHARDAMOUNT, "|cffffffff[|cff00ff00"..SSamount.."|cffffffff]")
		end
		tooltip:AddLine(" ")
		if db.SSmaxDelete == true then
			tooltip:AddDoubleLine("\124TInterface\\Icons\\Inv_misc_gem_amethyst_02:14\124t |cffffffff"..L.DESTROYSHARDS,"|cffffffff[|cFF00FF00"..L.ON.."|cffffffff]")
		else
			tooltip:AddDoubleLine("\124TInterface\\Icons\\Inv_misc_gem_amethyst_02:14\124t |cffffffff"..L.DESTROYSHARDS,"|cffffffff[|cffff0000"..L.OFF.."|cffffffff]")
		end
		color = "|cffff0000"
		if db.Hearthstone == true then
			if db.HearthstoneFrequency == 100 then color = "|cff00ff00"
			elseif db.HearthstoneFrequency >= 75 and db.HearthstoneFrequency < 100 then color = "|cff7fff7f"
			elseif db.HearthstoneFrequency >= 50 and db.HearthstoneFrequency < 75 then color = "|cffffff00"
			elseif db.HearthstoneFrequency >= 25 and db.HearthstoneFrequency < 50 then color = "|cffffff78"
			elseif db.HearthstoneFrequency >= 1 and db.HearthstoneFrequency < 25 then color = "|cffff6b00"
			end
			tooltip:AddDoubleLine("\124TInterface\\Icons\\Inv_misc_rune_01:14\124t |cffffffff"..L.HEARTHSTONE.." "..L.EMOTE,"|cffffffff["..color..db.HearthstoneFrequency.."%|cffffffff]")
		else
			tooltip:AddDoubleLine("\124TInterface\\Icons\\Inv_misc_rune_01:14\124t |cffffffff"..L.HEARTHSTONE.." "..L.EMOTE,"|cffffffff["..color..L.OFF.."|cffffffff]")
		end
		color = "|cffff0000"
		if db.Soulstone == true then
			if db.SoulstoneEmoteFrequency == 100 then color = "|cff00ff00"
			elseif db.SoulstoneEmoteFrequency >= 75 and db.SoulstoneEmoteFrequency < 100 then color = "|cff7fff7f"
			elseif db.SoulstoneEmoteFrequency >= 50 and db.SoulstoneEmoteFrequency < 75 then color = "|cffffff00"
			elseif db.SoulstoneEmoteFrequency >= 25 and db.SoulstoneEmoteFrequency < 50 then color = "|cffffff78"
			elseif db.SoulstoneEmoteFrequency >= 1 and db.SoulstoneEmoteFrequency < 25 then color = "|cffff6b00"
			end
			tooltip:AddDoubleLine("\124TInterface\\Icons\\Spell_Shadow_SoulGem:14\124t |cffffffff"..L.SSR.." "..L.EMOTE,"|cffffffff["..color..db.SoulstoneEmoteFrequency.."%|cffffffff]")
			if db.SoulstoneQuoteFrequency == 100 then color = "|cff00ff00"
			elseif db.SoulstoneQuoteFrequency >= 75 and db.SoulstoneQuoteFrequency < 100 then color = "|cff7fff7f"
			elseif db.SoulstoneQuoteFrequency >= 50 and db.SoulstoneQuoteFrequency < 75 then color = "|cffffff00"
			elseif db.SoulstoneQuoteFrequency >= 25 and db.SoulstoneQuoteFrequency < 50 then color = "|cffffff78"
			elseif db.SoulstoneQuoteFrequency >= 1 and db.SoulstoneQuoteFrequency < 25 then color = "|cffff6b00"
			end
			tooltip:AddDoubleLine("\124TInterface\\Icons\\Spell_Shadow_SoulGem:14\124t |cffffffff"..L.SSR.." "..L.QUOTE,"|cffffffff["..color..db.SoulstoneQuoteFrequency.."%|cffffffff]")
			if db.SoulstoneWhisperFrequency == 100 then color = "|cff00ff00"
			elseif db.SoulstoneWhisperFrequency >= 75 and db.SoulstoneWhisperFrequency < 100 then color = "|cff7fff7f"
			elseif db.SoulstoneWhisperFrequency >= 50 and db.SoulstoneWhisperFrequency < 75 then color = "|cffffff00"
			elseif db.SoulstoneWhisperFrequency >= 25 and db.SoulstoneWhisperFrequency < 50 then color = "|cffffff78"
			elseif db.SoulstoneWhisperFrequency >= 1 and db.SoulstoneWhisperFrequency < 25 then color = "|cffff6b00"
			end
			tooltip:AddDoubleLine("\124TInterface\\Icons\\Spell_Shadow_SoulGem:14\124t |cffffffff"..L.SSR.." "..L.WHISPER,"|cffffffff["..color..db.SoulstoneWhisperFrequency.."%|cffffffff]")
		else
			tooltip:AddDoubleLine("\124TInterface\\Icons\\Spell_Shadow_SoulGem:14\124t |cffffffff"..L.SSR,"|cffffffff["..color..L.OFF.."|cffffffff]")
		end
		color = "|cffff0000"
		if db.RitualSouls == true then
			if db.RitualSoulsFrequency == 100 then color = "|cff00ff00"
			elseif db.RitualSoulsFrequency >= 75 and db.RitualSoulsFrequency < 100 then color = "|cff7fff7f"
			elseif db.RitualSoulsFrequency >= 50 and db.RitualSoulsFrequency < 75 then color = "|cffffff00"
			elseif db.RitualSoulsFrequency >= 25 and db.RitualSoulsFrequency < 50 then color = "|cffffff78"
			elseif db.RitualSoulsFrequency >= 1 and db.RitualSoulsFrequency < 25 then color = "|cffff6b00"
			end
			tooltip:AddDoubleLine("\124TInterface\\Icons\\Spell_Shadow_shadesofdarkness:14\124t |cffffffff"..L.RITUALSOULS.." "..L.QUOTE,"|cffffffff["..color..db.RitualSoulsFrequency.."%|cffffffff]")
		else
			tooltip:AddDoubleLine("\124TInterface\\Icons\\Spell_Shadow_shadesofdarkness:14\124t |cffffffff"..L.RITUALSOULS.." "..L.QUOTE,"|cffffffff["..color..L.OFF.."|cffffffff]")
		end
		color = "|cffff0000"
		if db.RitualSummoning == true then
			if db.RitualSummoningFrequency == 100 then color = "|cff00ff00"
			elseif db.RitualSummoningFrequency >= 75 and db.RitualSummoningFrequency < 100 then color = "|cff7fff7f"
			elseif db.RitualSummoningFrequency >= 50 and db.RitualSummoningFrequency < 75 then color = "|cffffff00"
			elseif db.RitualSummoningFrequency >= 25 and db.RitualSummoningFrequency < 50 then color = "|cffffff78"
			elseif db.RitualSummoningFrequency >= 1 and db.RitualSummoningFrequency < 25 then color = "|cffff6b00"
			end
			tooltip:AddDoubleLine("\124TInterface\\Icons\\Spell_Shadow_twilight:14\124t |cffffffff"..L.RITUALSUMMONING.." "..L.QUOTE,"|cffffffff["..color..db.RitualSummoningFrequency.."%|cffffffff]")
		else
			tooltip:AddDoubleLine("\124TInterface\\Icons\\Spell_Shadow_twilight:14\124t |cffffffff"..L.RITUALSUMMONING.." "..L.QUOTE,"|cffffffff["..color..L.OFF.."|cffffffff]")
		end
		color = "|cffff0000"
		if db.SUM == true then
			if db.SUMfrequency == 100 then color = "|cff00ff00"
			elseif db.SUMfrequency >= 75 and db.SUMfrequency < 100 then color = "|cff7fff7f"
			elseif db.SUMfrequency >= 50 and db.SUMfrequency < 75 then color = "|cffffff00"
			elseif db.SUMfrequency >= 25 and db.SUMfrequency < 50 then color = "|cffffff78"
			elseif db.SUMfrequency >= 1 and db.SUMfrequency < 25 then color = "|cffff6b00"
			end
			tooltip:AddDoubleLine(db.lastSUMicon.."4\124t |cffffffff"..L.SUMMONS.." "..L.QUOTE,"|cffffffff["..color..db.SUMfrequency.."%|cffffffff]")
		else
			tooltip:AddDoubleLine(db.lastSUMicon.."4\124t |cffffffff"..L.SUMMONS.." "..L.QUOTE,"|cffffffff["..color..L.OFF.."|cffffffff]")
		end
		color = "|cffff0000"
		if db.Resurrected == true then
			if db.RESfrequency == 100 then color = "|cff00ff00"
			elseif db.RESfrequency >= 75 and db.RESfrequency < 100 then color = "|cff7fff7f"
			elseif db.RESfrequency >= 50 and db.RESfrequency < 75 then color = "|cffffff00"
			elseif db.RESfrequency >= 25 and db.RESfrequency < 50 then color = "|cffffff78"
			elseif db.RESfrequency >= 1 and db.RESfrequency < 25 then color = "|cffff6b00"
			end
			tooltip:AddDoubleLine("\124TInterface\\Icons\\Spell_holy_resurrection:14\124t |cffffffff"..L.RESURRECTED.." "..L.EMOTE,"|cffffffff["..color..db.RESfrequency.."%|cffffffff]")
		else
			tooltip:AddDoubleLine("\124TInterface\\Icons\\Spell_holy_resurrection:14\124t |cffffffff"..L.RESURRECTED.." "..L.EMOTE,"|cffffffff["..color..L.OFF.."|cffffffff]")
		end
		tooltip:AddLine(" ")
		tooltip:AddLine("|cffeda55f"..L.RIGHTCLICK.."|r "..L.FOROPTIONS, 0.2, 1, 0.2)
		tooltip:AddLine("|cffeda55f"..L.ALTCLICK.."|r "..L.RESTARTGFX, 0.2, 1, 0.2)
		tooltip:AddLine("|cffeda55f"..L.ALTRIGHTCLICK.."|r "..L.RELOADUI, 0.2, 1, 0.2)
	end,
})

local options = {
	handler = SoulSpeak,
  type = "group",
  args = {
   	basicDesc = {
			order = 1,
			type = 'description',
			name = "\124TInterface\\Icons\\Spell_Shadow_SoulGem:14\124t |cffB0A0ffSoulSpeak reacts to various soul events using emotes and quotes! Builtin support for LDB(Broker) panels.",
		},
		SoulShardManagementHeader = {
			order = 2,
			type = 'header',
			name = "\124TInterface\\Icons\\Inv_misc_gem_amethyst_02:16\124t "..L.SSMANAGEMENT,
		},      	
    SSmaxDelete = {
     	type = "toggle",
      name = L.DESTROYSHARDS,
        desc = L.DESTROYSHARDSIFVALUE,
        order = 3,
        get = "getSSopt",
        set = "setSSopt",
    },
    SSinstaDelete = {
     	type = "execute",
      name = L.DESTROYSHARDS,
      desc = L.DESTROYSHARDSOVER,
      order = 4,
			func = "BAG_UPDATE",
      disabled = "disSSopt",
    },    
		SSmaxScale = {
			order = 5,
			type = "range",
			name = L.SOULSHARDS,
			desc = L.MAXSHARDS,
			min = 1, max = 32, step = 1,
      get = "getSSopt",
      set = "setSSopt",
      disabled = "disSSopt",
		},
    HearthstoneSubFrame = {
			type = 'group',
			name = L.HEARTHSTONE.." "..string.lower(L.EMOTES),
			desc = L.ENABLESELECTEMOTE,
			order = 1,
			args = {
				header = {
					type = "header",
					name = "\124TInterface\\Icons\\Inv_misc_rune_01:16\124t "..L.HEARTHSTONE.." "..L.MANAGEMENT,
					order = 0,
				},			
    		Hearthstone = {
     			type = "toggle",
     			name = L.USE,
     			desc = L.EMOTEWITHYOURHS,
     			order = 2,
        	get = "getSSopt",
        	set = "setSSopt",
    		},
				HearthstoneFrequency = {
					order = 3,
					type = "range",
					name = L.FREQUENCY,
					desc = L.FREQDESC,
					min = 1, max = 100, step = 1,
      		get = "getSSopt",
      		set = "setSSopt",
					disabled = "disSSopt",
				},
    		morningHearthstone = {
    			type = "toggle",
      		name = L.HSMORNING,
      		order = 4,
        	get = "getSSopt",
      		set = "setSSopt",
        	disabled = "disSSopt",
    		},      								
				morningEmotes = {
					type = 'select',
					name = L.SELECTEDEMOTE,
					desc = L.SELECTMORNING,
					order = 5,
        	get = "getSSopt",
      		set = "setSSopt",
					values = HearthstoneStyles,
        	disabled = "disSSopt",
				},
    		afternoonHearthstone = {
    			type = "toggle",
      		name = L.HSAFTERNOON,
      		order = 6,
        	get = "getSSopt",
      		set = "setSSopt",
        	disabled = "disSSopt",
    		},      								
				afternoonEmotes = {
					type = 'select',
					name = L.SELECTEDEMOTE,
					desc = L.SELECTAFTERNOON,
					order = 7,
        	get = "getSSopt",
      		set = "setSSopt",
					values = HearthstoneStyles,
        	disabled = "disSSopt",
				},
    		eveningHearthstone = {
    			type = "toggle",
      		name = L.HSEVENING,
      		order = 8,
        	get = "getSSopt",
      		set = "setSSopt",
        	disabled = "disSSopt",
    		},      								
				eveningEmotes = {
					type = 'select',
					name = L.SELECTEDEMOTE,
					desc = L.SELECTEVENING,
					order = 9,
        	get = "getSSopt",
      		set = "setSSopt",
					values = HearthstoneStyles,
        	disabled = "disSSopt",
				},
    		nightHearthstone = {
    			type = "toggle",
      		name = L.HSNIGHT,
      		order = 10,
        	get = "getSSopt",
      		set = "setSSopt",
        	disabled = "disSSopt",
    		},      								
				nightEmotes = {
					type = 'select',
					name = L.SELECTEDEMOTE,
					desc = L.SELECTNIGHT,
					order = 11,
        	get = "getSSopt",
      		set = "setSSopt",
					values = HearthstoneStyles,
        	disabled = "disSSopt",
				},
    		randomHearthstone = {
    			type = "toggle",
      		name = L.USE.." "..L.RANDOM.." "..L.EMOTE,
      		order = 12,
        	get = "getSSopt",
					set = "setSSopt",
        	disabled = "disSSopt",
    		},
  		},
		},
    SoulstoneSubFrame = {
			type = 'group',
			name = L.SSR,
			desc = L.ENABLESELECTCHANNELS,
				order = 2,
			args = {
				header = {
					type = "header",
					name = "\124TInterface\\Icons\\Spell_Shadow_SoulGem:16\124t "..L.SSR.." "..L.MANAGEMENT,
					order = 0,
				},			
				Soulstone = {
    			type = "toggle",
      		name = L.USE,
      		desc = L.QUOTESCASTING,
					order = 1,
        	get = "getSSopt",
        	set = "setSSopt",
 				},
				SoulstoneTab = {
 					type = "description",
   				name = "",
					order = 2,
    		}, 					
    		SoulstoneParty = {
    			type = "toggle",
      		name = L.INPARTY,
      		desc = L.USEQUOTESPARTY,
					order = 3,
        	get = "getSSopt",
      		set = "setSSopt",
        	disabled = "disSSopt",
    		},
				SoulstonePartyChannels = {
					type = 'select',
					name = L.SELECTEDCHANNEL,
					desc = L.SELECTCHANNEL,
					order = 4,
      		get = "getSSopt",
      		set = "setSSopt",
					values = SoulPartyQuoteChannels,
        	disabled = "disSSopt",
				},
    		SoulstoneRaid = {
    			type = "toggle",
      		name = L.INRAID,
      		desc = L.USEQUOTESRAID,
					order = 5,
        	get = "getSSopt",
      		set = "setSSopt",
        	disabled = "disSSopt",
    		},
				SoulstoneRaidChannels = {
					type = 'select',
					name = L.SELECTEDCHANNEL,
					desc = L.SELECTCHANNEL,
					order = 6,
      		get = "getSSopt",
      		set = "setSSopt",
					values = SoulRaidQuoteChannels,
        	disabled = "disSSopt",
				},				
    		SoulstoneSolo = {
    			type = "toggle",
      		name = L.BYOURSELF,
      		desc = L.USEQUOTESOLO,
					order = 7,
        	get = "getSSopt",
      		set = "setSSopt",
        	disabled = "disSSopt",
    		},
				SoulstoneSoloChannels = {
					type = 'select',
					name = L.SELECTEDCHANNEL,
					desc = L.SELECTCHANNEL,
					order = 8,
      		get = "getSSopt",
      		set = "setSSopt",
					values = SoulSoloQuoteChannels,
        	disabled = "disSSopt",
				},
				SoulstoneSelf = {
 					type = "toggle",
   				name = L.ONYOURSELF,
   				desc = L.USEMOTEYOURSELF,
					order = 9,
        	get = "getSSopt",
      		set = "setSSopt",
        	disabled = "disSSopt",
    		},
				SoulstoneEmotesSubFrame = {
					type = 'group',
					name = L.EMOTES,
					desc = L.CLICKEDIT,
					order = 10,
					args = {
						header = {
							type = "header",
							name = "\124TInterface\\Icons\\Spell_Shadow_SoulGem:16\124t "..L.SOULSTONE.." "..L.EMOTES.." "..L.MANAGEMENT,
							order = 0,
						},					
						SoulstoneEMmaxScale = {
							order = 1,
							type = "range",
							name = L.ENABLEDEMOTES,			
							desc = L.MAXTOUSE,
							min = 1, max = 16, step = 1,
        			get = "getSSopt",
        			set = "setSSopt",
        			disabled = "disSSopt",
    				},
    				SoulstoneEmoteFrequency = {
							order = 2,
							type = "range",
							name = L.FREQUENCY,
							desc = L.FREQDESC,
							min = 1, max = 100, step = 1,
      				get = "getSSopt",
      				set = "setSSopt",
							disabled = "disSSopt",
						},
  					SoulstoneEmoteTab = {
    					type = "description",
      				name = "|cFF00FF00"..L.TAGDESCPLAYER.." |cff7fff7f"..L.ONLY.." |cFF00FF00"..L.AND.." |cff7fff7f"..L.NOT.." |cFF00FF00"..L.CASESENSITIVE,
      				desc = " ",
      				order = 3,
						},						
						SSemoteGroup = {
							type = "group",
							name = " ",
							guiInline = true,
							order = 4,
							childGroups = "input",
							args = {
								[L.SOULSTONE.." "..L.EMOTE.." #01"] = toggle_option,
								[L.SOULSTONE.." "..L.EMOTE.." #02"] = toggle_option,
								[L.SOULSTONE.." "..L.EMOTE.." #03"] = toggle_option,
								[L.SOULSTONE.." "..L.EMOTE.." #04"] = toggle_option,
								[L.SOULSTONE.." "..L.EMOTE.." #05"] = toggle_option,
								[L.SOULSTONE.." "..L.EMOTE.." #06"] = toggle_option,
								[L.SOULSTONE.." "..L.EMOTE.." #07"] = toggle_option,
								[L.SOULSTONE.." "..L.EMOTE.." #08"] = toggle_option,
								[L.SOULSTONE.." "..L.EMOTE.." #09"] = toggle_option,
								[L.SOULSTONE.." "..L.EMOTE.." #10"] = toggle_option,
								[L.SOULSTONE.." "..L.EMOTE.." #11"] = toggle_option,
								[L.SOULSTONE.." "..L.EMOTE.." #12"] = toggle_option,
								[L.SOULSTONE.." "..L.EMOTE.." #13"] = toggle_option,
								[L.SOULSTONE.." "..L.EMOTE.." #14"] = toggle_option,
								[L.SOULSTONE.." "..L.EMOTE.." #15"] = toggle_option,
								[L.SOULSTONE.." "..L.EMOTE.." #16"] = toggle_option,
							},
						},
  	  		},  	  			
  	  	},
				SoulstoneQuotesSubFrame = {
					type = 'group',
					name = L.QUOTES,
					desc = L.CLICKEDIT,
							order = 12,
					args = {
						header = {
							type = "header",
							name = "\124TInterface\\Icons\\Spell_Shadow_SoulGem:16\124t "..L.SOULSTONE.." "..L.QUOTES.." "..L.MANAGEMENT,
							order = 0,
						},					
						SoulstoneQuotesmaxScale = {
							order = 1,
							type = "range",
							name = L.ENABLEDQUOTES,			
							desc = L.MAXTOUSE,
							min = 1, max = 22, step = 1,
        			get = "getSSopt",
        			set = "setSSopt",
        			disabled = "disSSopt",
						},
						SoulstoneQuoteFrequency = {
							order = 2,
							type = "range",
							name = L.FREQUENCY,
							desc = L.FREQDESC,
							min = 1, max = 100, step = 1,
      				get = "getSSopt",
      				set = "setSSopt",
							disabled = "disSSopt",
						},
  					SoulstoneQuoteTab = {
    					type = "description",
      				name = "|cFF00FF00"..L.TAGDESCTARGET.." |cff7fff7f"..L.ONLY.." |cFF00FF00"..L.AND.." |cff7fff7f"..L.NOT.." |cFF00FF00"..L.CASESENSITIVE,
      				desc = " ",
      				order = 3,
						},
						SSquoteGroup = {
							type = "group",
							name = " ",
							guiInline = true,
							order = 4,
							childGroups = "input",
							args = {
								[L.SOULSTONE.." "..L.QUOTE.." #01"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #02"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #03"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #04"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #05"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #06"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #07"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #08"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #09"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #10"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #11"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #12"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #13"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #14"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #15"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #16"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #17"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #18"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #19"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #20"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #21"] = toggle_option,
								[L.SOULSTONE.." "..L.QUOTE.." #22"] = toggle_option,
							},
						},						
  	  		},
  	  	},
				SoulstoneWhispersSubFrame = {
					type = 'group',
					name = L.WHISPERS,
					desc = L.CLICKEDIT,
					order = 13,
					args = {
						header = {
							type = "header",
							name = "\124TInterface\\Icons\\Spell_Shadow_SoulGem:16\124t "..L.SOULSTONE.." "..L.WHISPERS.." "..L.MANAGEMENT,
							order = 0,
						},					
						SoulstoneWhispersmaxScale = {
							order = 1,
							type = "range",
							name = L.ENABLEDWHISPERS,			
							desc = L.MAXTOUSE,
							min = 1, max = 18, step = 1,
        			get = "getSSopt",
        			set = "setSSopt",
        			disabled = "disSSopt",
						},
						SoulstoneWhisperFrequency = {
							order = 2,
							type = "range",
							name = L.FREQUENCY,
							desc = L.FREQDESC,
							min = 1, max = 100, step = 1,
      				get = "getSSopt",
      				set = "setSSopt",
							disabled = "disSSopt",
						},
  					SoulstoneWhisperTab = {
    					type = "description",
      				name = "|cFF00FF00"..L.TAGDESCTARGET.." |cff7fff7f"..L.ONLY.." |cFF00FF00"..L.AND.." |cff7fff7f"..L.NOT.." |cFF00FF00"..L.CASESENSITIVE,
      				desc = " ",
      				order = 3,
						},
						SSwhisperGroup = {
							type = "group",
							name = " ",
							guiInline = true,
							order = 4,
							childGroups = "input",
							args = {
								[L.SOULSTONE.." "..L.WHISPER.." #01"] = toggle_option,
								[L.SOULSTONE.." "..L.WHISPER.." #02"] = toggle_option,
								[L.SOULSTONE.." "..L.WHISPER.." #03"] = toggle_option,
								[L.SOULSTONE.." "..L.WHISPER.." #04"] = toggle_option,
								[L.SOULSTONE.." "..L.WHISPER.." #05"] = toggle_option,
								[L.SOULSTONE.." "..L.WHISPER.." #06"] = toggle_option,
								[L.SOULSTONE.." "..L.WHISPER.." #07"] = toggle_option,
								[L.SOULSTONE.." "..L.WHISPER.." #08"] = toggle_option,
								[L.SOULSTONE.." "..L.WHISPER.." #09"] = toggle_option,
								[L.SOULSTONE.." "..L.WHISPER.." #10"] = toggle_option,
								[L.SOULSTONE.." "..L.WHISPER.." #11"] = toggle_option,
								[L.SOULSTONE.." "..L.WHISPER.." #12"] = toggle_option,
								[L.SOULSTONE.." "..L.WHISPER.." #13"] = toggle_option,
								[L.SOULSTONE.." "..L.WHISPER.." #14"] = toggle_option,
								[L.SOULSTONE.." "..L.WHISPER.." #15"] = toggle_option,
								[L.SOULSTONE.." "..L.WHISPER.." #16"] = toggle_option,
								[L.SOULSTONE.." "..L.WHISPER.." #17"] = toggle_option,
								[L.SOULSTONE.." "..L.WHISPER.." #18"] = toggle_option,
							},
						},
  	  		},	
  	  	},
  		},
		},
    RitualSoulsSubFrame = {
			type = 'group',
			name = L.RITUALSOULS,
			desc = L.ENABLESELECTCHANNELS,
			order = 3,
			args = {
				header = {
					type = "header",
					name = "\124TInterface\\Icons\\Spell_Shadow_shadesofdarkness:16\124t "..L.RITUALSOULS.." "..L.MANAGEMENT,
					order = 0,
				},			
				RitualSouls = {
    			type = "toggle",
      		name = L.USE,
      		desc = L.QUOTESCASTING,
					order = 1,
        	get = "getSSopt",
        	set = "setSSopt",
 				},
				RitualSoulsFrequency = {
					order = 2,
					type = "range",
					name = L.FREQUENCY,
					desc = L.FREQDESC,
					min = 1, max = 100, step = 1,
      		get = "getSSopt",
      		set = "setSSopt",
					disabled = "disSSopt",
				},
    		RitualSoulsParty = {
    			type = "toggle",
      		name = L.INPARTY,
      		desc = L.USEQUOTESPARTY,
					order = 3,
        	get = "getSSopt",
      		set = "setSSopt",
					disabled = "disSSopt",
    		},
				RitualSoulsPartyChannels = {
					type = 'select',
					name = L.SELECTEDCHANNEL,
					desc = L.SELECTCHANNEL,
					order = 4,
      		get = "getSSopt",
      		set = "setSSopt",
					values = PartyQuoteChannels,
					disabled = "disSSopt",
				},
    		RitualSoulsRaid = {
    			type = "toggle",
      		name = L.INRAID,
      		desc = L.USEQUOTESRAID,
					order = 5,
        	get = "getSSopt",
      		set = "setSSopt",
					disabled = "disSSopt",
    		},
				RitualSoulsRaidChannels = {
					type = 'select',
					name = L.SELECTEDCHANNEL,
					desc = L.SELECTCHANNEL,
					order = 6,
      		get = "getSSopt",
      		set = "setSSopt",
					values = RaidQuoteChannels,
					disabled = "disSSopt",
				},
				RitualSoulsChatFrame = {
 					type = "toggle",
   				name = L.INCHAT,
   				desc = L.SENDCHAT,
					order = 7,
        	get = "getSSopt",
      		set = "setSSopt",
					disabled = "disSSopt",
    		},
    		RitualSoulsHelpme = {
    			type = "toggle",
      		name = L.HELPME,
      		desc = L.EMOTESCASTING,
					order = 8,
        	get = "getSSopt",
					set = "setSSopt",
					disabled = "disSSopt",
    		},				
				RitualSoulsQuotesSubFrame = {
					type = 'group',
					name = L.QUOTES,
					desc = L.CLICKEDIT,
					order = 9,
					args = {
						header = {
							type = "header",
							name = "\124TInterface\\Icons\\Spell_Shadow_shadesofdarkness:16\124t "..L.RITUALSOULS.." "..L.QUOTES.." "..L.MANAGEMENT,
							order = 10,
						},																	
						RitualSoulsQuotesmaxScale = {
							order = 11,
							type = "range",
							name = L.ENABLEDQUOTES,			
							desc = L.MAXTOUSE,
							min = 1, max = 20, step = 1,
        			get = "getSSopt",
        			set = "setSSopt",
        			disabled = "disSSopt",
						},					
  					RitualSoulsQuoteTab = {
    					type = "description",
      				name = "|cFF00FF00"..L.TAGDESCPLAYER.." |cff7fff7f"..L.ONLY.." |cFF00FF00"..L.AND.." |cff7fff7f"..L.NOT.." |cFF00FF00"..L.CASESENSITIVE,
      				desc = " ",
      				order = 12,
						},
						RSOquoteGroup = {
							type = "group",
							name = " ",
							guiInline = true,
							order = 13,
							childGroups = "input",
							args = {
								[L.RITUALSOULS.." #01"] = toggle_option,
								[L.RITUALSOULS.." #02"] = toggle_option,
								[L.RITUALSOULS.." #03"] = toggle_option,
								[L.RITUALSOULS.." #04"] = toggle_option,
								[L.RITUALSOULS.." #05"] = toggle_option,
								[L.RITUALSOULS.." #06"] = toggle_option,
								[L.RITUALSOULS.." #07"] = toggle_option,
								[L.RITUALSOULS.." #08"] = toggle_option,
								[L.RITUALSOULS.." #09"] = toggle_option,
								[L.RITUALSOULS.." #10"] = toggle_option,
								[L.RITUALSOULS.." #11"] = toggle_option,
								[L.RITUALSOULS.." #12"] = toggle_option,
								[L.RITUALSOULS.." #13"] = toggle_option,
								[L.RITUALSOULS.." #14"] = toggle_option,
								[L.RITUALSOULS.." #15"] = toggle_option,
								[L.RITUALSOULS.." #16"] = toggle_option,
								[L.RITUALSOULS.." #17"] = toggle_option,
								[L.RITUALSOULS.." #18"] = toggle_option,
								[L.RITUALSOULS.." #19"] = toggle_option,
								[L.RITUALSOULS.." #20"] = toggle_option,
							},
						},
  	  		},
  	  	},  	  		  	  		
  		},
		},
  	RitualSummoningSubFrame = {
			type = 'group',
			name = L.RITUALSUMMONING,
			desc = L.ENABLESELECTCHANNELS,
			order = 4,
			args = {
				header = {
					type = "header",
					name = "\124TInterface\\Icons\\Spell_Shadow_twilight:16\124t "..L.RITUALSUMMONING.." "..L.MANAGEMENT,
					order = 0,
				},			
				RitualSummoning = {
    			type = "toggle",
      		name = L.USE,
      		desc = L.QUOTESCASTING,
					order = 1,
        	get = "getSSopt",
        	set = "setSSopt",
    		},
				RitualSummoningFrequency = {
					order = 2,
					type = "range",
					name = L.FREQUENCY,
					desc = L.FREQDESC,
					min = 1, max = 100, step = 1,
      		get = "getSSopt",
      		set = "setSSopt",
					disabled = "disSSopt",
				},
    		RitualSummoningParty = {
    			type = "toggle",
      		name = L.INPARTY,
      		desc = L.USEQUOTESPARTY,
					order = 3,
        	get = "getSSopt",
        	set = "setSSopt",
					disabled = "disSSopt",
    		},
				RitualSummoningPartyChannels = {
					type = 'select',
					name = L.SELECTEDCHANNEL,
					desc = L.SELECTCHANNEL,
					order = 4,
      		get = "getSSopt",
      		set = "setSSopt",
					values = PartyQuoteChannels,
					disabled = "disSSopt",
				},
    		RitualSummoningRaid = {
    			type = "toggle",
      		name = L.INRAID,
      		desc = L.USEQUOTESRAID,
					order = 5,
        	get = "getSSopt",
        	set = "setSSopt",
					disabled = "disSSopt",
    		},
				RitualSummoningRaidChannels = {
					type = 'select',
					name = L.SELECTEDCHANNEL,
					desc = L.SELECTCHANNEL,
					order = 6,
      		get = "getSSopt",
      		set = "setSSopt",
					values = RaidQuoteChannels,
					disabled = "disSSopt",
				},
				RitualSummoningChatFrame = {
    			type = "toggle",
      		name = L.INCHAT,
      		desc = L.SENDCHAT,
					order = 7,
        	get = "getSSopt",
        	set = "setSSopt",
					disabled = "disSSopt",
    		},
				RitualSummoningHelpme = {
    			type = "toggle",
      		name = L.HELPME,
      		desc = L.EMOTESCASTING,
					order = 8,
        	get = "getSSopt",
					set = "setSSopt",
					disabled = "disSSopt",
    		},    		
				RitualSummoningQuotesSubFrame = {
					type = 'group',
					name = L.QUOTES,
					desc = L.CLICKEDIT,
					order = 9,
					args = {
						header = {
							type = "header",
							name = "\124TInterface\\Icons\\Spell_Shadow_twilight:16\124t "..L.RITUALSUMMONING.." "..L.QUOTES.." "..L.MANAGEMENT,
							order = 10,
						},												
						RitualSummoningQuotesmaxScale = {
							order = 11,
							type = "range",
							name = L.ENABLEDQUOTES,			
							desc = L.MAXTOUSE,
							min = 1, max = 32, step = 1,
        			get = "getSSopt",
        			set = "setSSopt",
							disabled = "disSSopt",
						},					
  					RitualSummoningQuoteTab = {
    					type = "description",
      				name = "|cFF00FF00"..L.TAGDESCPLAYER.." |cff7fff7f"..L.ONLY.." |cFF00FF00"..L.AND.." |cff7fff7f"..L.NOT.." |cFF00FF00"..L.CASESENSITIVE,
      				desc = " ",
      				order = 12,
						},
						RSUquoteGroup = {
							type = "group",
							name = " ",
							guiInline = true,
							order = 13,
							childGroups = "input",
							args = {
								[L.RITUALSUMMONING.." #01"] = toggle_option,
								[L.RITUALSUMMONING.." #02"] = toggle_option,
								[L.RITUALSUMMONING.." #03"] = toggle_option,
								[L.RITUALSUMMONING.." #04"] = toggle_option,
								[L.RITUALSUMMONING.." #05"] = toggle_option,
								[L.RITUALSUMMONING.." #06"] = toggle_option,
								[L.RITUALSUMMONING.." #07"] = toggle_option,
								[L.RITUALSUMMONING.." #08"] = toggle_option,
								[L.RITUALSUMMONING.." #09"] = toggle_option,
								[L.RITUALSUMMONING.." #10"] = toggle_option,
								[L.RITUALSUMMONING.." #11"] = toggle_option,
								[L.RITUALSUMMONING.." #12"] = toggle_option,
								[L.RITUALSUMMONING.." #13"] = toggle_option,
								[L.RITUALSUMMONING.." #14"] = toggle_option,
								[L.RITUALSUMMONING.." #15"] = toggle_option,
								[L.RITUALSUMMONING.." #16"] = toggle_option,
								[L.RITUALSUMMONING.." #17"] = toggle_option,
								[L.RITUALSUMMONING.." #18"] = toggle_option,
								[L.RITUALSUMMONING.." #19"] = toggle_option,
								[L.RITUALSUMMONING.." #20"] = toggle_option,
								[L.RITUALSUMMONING.." #21"] = toggle_option,
								[L.RITUALSUMMONING.." #22"] = toggle_option,
								[L.RITUALSUMMONING.." #23"] = toggle_option,
								[L.RITUALSUMMONING.." #24"] = toggle_option,
								[L.RITUALSUMMONING.." #25"] = toggle_option,
								[L.RITUALSUMMONING.." #26"] = toggle_option,
								[L.RITUALSUMMONING.." #27"] = toggle_option,
								[L.RITUALSUMMONING.." #28"] = toggle_option,
								[L.RITUALSUMMONING.." #29"] = toggle_option,
								[L.RITUALSUMMONING.." #30"] = toggle_option,
								[L.RITUALSUMMONING.." #31"] = toggle_option,
								[L.RITUALSUMMONING.." #32"] = toggle_option,
							},
						},
  	  		},
    		},
    	},
    },
		sumSubFrame = {
			type = 'group',
			name = L.SUMMONS,
			desc = L.ENABLESELECTCHANNELS,
			order = 5,
			args = {    	
				header = {
					type = "header",
					name = function(info) return db.lastSUMicon.."6\124t "..L.SUMMONS.." "..L.MANAGEMENT end,
					order = 0,
				},
    		SUM = {
    			type = "toggle",
      		name = L.USE,
      		desc = L.QUOTES..L.EMOTESUM,
      		order = 1,
        	get = "getSSopt",
        	set = "setSSopt",
    		},
				SUMfrequency = {
					order = 2,
					type = "range",
					name = L.FREQUENCY,
					desc = L.FREQDESC,
					min = 1, max = 100, step = 1,
      		get = "getSSopt",
      		set = "setSSopt",
					disabled = "disSSopt",
				},
    		SUMparty = {
    			type = "toggle",
      		name = L.INPARTY,
      		desc = L.USEQUOTESPARTY,
					order = 3,
        	get = "getSSopt",
      		set = "setSSopt",
        	disabled = "disSSopt",
    		},
				SUMpartyChannels = {
					type = 'select',
					name = L.SELECTEDCHANNEL,
					desc = L.SELECTCHANNEL,
					order = 4,
      		get = "getSSopt",
      		set = "setSSopt",
					values = PartyQuoteChannels,
        	disabled = "disSSopt",
				},
    		SUMraid = {
    			type = "toggle",
      		name = L.INRAID,
      		desc = L.USEQUOTESRAID,
					order = 5,
        	get = "getSSopt",
      		set = "setSSopt",
        	disabled = "disSSopt",
    		},
				SUMraidChannels = {
					type = 'select',
					name = L.SELECTEDCHANNEL,
					desc = L.SELECTCHANNEL,
					order = 6,
      		get = "getSSopt",
      		set = "setSSopt",
					values = RaidQuoteChannels,
        	disabled = "disSSopt",
				},				
    		SUMsolo = {
    			type = "toggle",
      		name = L.BYOURSELF,
      		desc = L.USEQUOTESOLO,
					order = 7,
        	get = "getSSopt",
      		set = "setSSopt",
        	disabled = "disSSopt",
    		},
				SUMsoloChannels = {
					type = 'select',
					name = L.SELECTEDCHANNEL,
					desc = L.SELECTCHANNEL,
					order = 8,
      		get = "getSSopt",
      		set = "setSSopt",
					values = SoloQuoteChannels,
        	disabled = "disSSopt",
				},
				FGRDquotesSubFrame = {
					type = 'group',
					name = L.FGRD.." "..string.lower(L.QUOTES),
					desc = L.CLICKEDIT,
					order = 9,
					args = {
						header = {
							type = "header",
							name = "\124TInterface\\Icons\\Spell_Shadow_summonfelguard:16\124t "..L.FGRD.." "..L.QUOTES.." "..L.MANAGEMENT,
							order = 10,
						},												
						SUMfgrdQuotesmaxScale = {
							order = 11,
							type = "range",
							name = L.ENABLEDQUOTES,			
							desc = L.MAXTOUSE,
							min = 1, max = 8, step = 1,
        			get = "getSSopt",
        			set = "setSSopt",
							disabled = "disSSopt",
						},					
  					FGRDquoteTab = {
    					type = "description",
      				name = function()
      					return "|cFF00FF00"..L.TAGDESCPLAYER.." |cff7fff7f"..L.ONLY.." |cFF00FF00"..L.AND.." |cff7fff7f"..L.NOT.." |cFF00FF00"..L.CASESENSITIVE..L.IFNONAME.."\n"..L.FGRD..L.NAMEDETECT.."|cffff0000<"..db.SUMfgrd..">"
      					end,
      				desc = " ",
      				order = 12,
						},						
						FGRDquoteGroup = {
							type = "group",
							name = " ",
							guiInline = true,
							order = 13,
							childGroups = "input",
							args = {
								[L.FGRD.." #01"] = toggle_option,
								[L.FGRD.." #02"] = toggle_option,
								[L.FGRD.." #03"] = toggle_option,
								[L.FGRD.." #04"] = toggle_option,
								[L.FGRD.." #05"] = toggle_option,
								[L.FGRD.." #06"] = toggle_option,
								[L.FGRD.." #07"] = toggle_option,
								[L.FGRD.." #08"] = toggle_option,
							},
						},
  	  		},
  	  	},
				FELquotesSubFrame = {
					type = 'group',
					name = L.FEL.." "..string.lower(L.QUOTES),
					desc = L.CLICKEDIT,
					order = 14,
					args = {
						header = {
							type = "header",
							name = "\124TInterface\\Icons\\Spell_Shadow_summonfelhunter:16\124t "..L.FEL.." "..L.QUOTES.." "..L.MANAGEMENT,
							order = 15,
						},												
						SUMfelQuotesmaxScale = {
							order = 16,
							type = "range",
							name = L.ENABLEDQUOTES,			
							desc = L.MAXTOUSE,
							min = 1, max = 8, step = 1,
        			get = "getSSopt",
        			set = "setSSopt",
							disabled = "disSSopt",
						},					
  					FELquoteTab = {
    					type = "description",
      				name = function()
      					return "|cFF00FF00"..L.TAGDESCPLAYER.." |cff7fff7f"..L.ONLY.." |cFF00FF00"..L.AND.." |cff7fff7f"..L.NOT.." |cFF00FF00"..L.CASESENSITIVE..L.IFNONAME.."\n"..L.FEL..L.NAMEDETECT.."|cffff0000<"..db.SUMfel..">"
      					end,
      				desc = " ",
      				order = 17,
						},						
						FELquoteGroup = {
							type = "group",
							name = " ",
							guiInline = true,
							order = 18,
							childGroups = "input",
							args = {
								[L.FEL.." #01"] = toggle_option,
								[L.FEL.." #02"] = toggle_option,
								[L.FEL.." #03"] = toggle_option,
								[L.FEL.." #04"] = toggle_option,
								[L.FEL.." #05"] = toggle_option,
								[L.FEL.." #06"] = toggle_option,
								[L.FEL.." #07"] = toggle_option,
								[L.FEL.." #08"] = toggle_option,
							},
						},
  	  		},
  	  	},
				IMPquotesSubFrame = {
					type = 'group',
					name = L.IMP.." "..string.lower(L.QUOTES),
					desc = L.CLICKEDIT,
					order = 19,
					args = {
						header = {
							type = "header",
							name = "\124TInterface\\Icons\\Spell_Shadow_summonimp:16\124t "..L.IMP.." "..L.QUOTES.." "..L.MANAGEMENT,
							order = 20,
						},												
						SUMimpQuotesmaxScale = {
							order = 21,
							type = "range",
							name = L.ENABLEDQUOTES,			
							desc = L.MAXTOUSE,
							min = 1, max = 18, step = 1,
        			get = "getSSopt",
        			set = "setSSopt",
							disabled = "disSSopt",
						},					
  					IMPquoteTab = {
    					type = "description",
      				name = function()
      					return "|cFF00FF00"..L.TAGDESCPLAYER.." |cff7fff7f"..L.ONLY.." |cFF00FF00"..L.AND.." |cff7fff7f"..L.NOT.." |cFF00FF00"..L.CASESENSITIVE..L.IFNONAME.."\n"..L.IMP..L.NAMEDETECT.."|cffff0000<"..db.SUMimp..">"
      					end,
      				desc = " ",
      				order = 22,
						},						
						IMPquoteGroup = {
							type = "group",
							name = " ",
							guiInline = true,
							order = 23,
							childGroups = "input",
							args = {
								[L.IMP.." #01"] = toggle_option,
								[L.IMP.." #02"] = toggle_option,
								[L.IMP.." #03"] = toggle_option,
								[L.IMP.." #04"] = toggle_option,
								[L.IMP.." #05"] = toggle_option,
								[L.IMP.." #06"] = toggle_option,
								[L.IMP.." #07"] = toggle_option,
								[L.IMP.." #08"] = toggle_option,
								[L.IMP.." #09"] = toggle_option,
								[L.IMP.." #10"] = toggle_option,
								[L.IMP.." #11"] = toggle_option,
								[L.IMP.." #12"] = toggle_option,
								[L.IMP.." #13"] = toggle_option,
								[L.IMP.." #14"] = toggle_option,
								[L.IMP.." #15"] = toggle_option,
								[L.IMP.." #16"] = toggle_option,
								[L.IMP.." #17"] = toggle_option,
								[L.IMP.." #18"] = toggle_option,
							},
						},
  	  		},
  	  	},
				SUCquotesSubFrame = {
					type = 'group',
					name = L.SUC.." "..string.lower(L.QUOTES),
					desc = L.CLICKEDIT,
					order = 24,
					args = {
						header = {
							type = "header",
							name = "\124TInterface\\Icons\\Spell_Shadow_summonsuccubus:16\124t "..L.SUC.." "..L.QUOTES.." "..L.MANAGEMENT,
							order = 25,
						},												
						SUMsucQuotesmaxScale = {
							order = 26,
							type = "range",
							name = L.ENABLEDQUOTES,			
							desc = L.MAXTOUSE,
							min = 1, max = 12, step = 1,
        			get = "getSSopt",
        			set = "setSSopt",
							disabled = "disSSopt",
						},					
  					SUCquoteTab = {
    					type = "description",
      				name = function()
      					return "|cFF00FF00"..L.TAGDESCPLAYER.." |cff7fff7f"..L.ONLY.." |cFF00FF00"..L.AND.." |cff7fff7f"..L.NOT.." |cFF00FF00"..L.CASESENSITIVE..L.IFNONAME.."\n"..L.SUC..L.NAMEDETECT.."|cffff0000<"..db.SUMsuc..">"
      					end,
      				desc = " ",
      				order = 27,
						},						
						SUCquoteGroup = {
							type = "group",
							name = " ",
							guiInline = true,
							order = 28,
							childGroups = "input",
							args = {
								[L.SUC.." #01"] = toggle_option,
								[L.SUC.." #02"] = toggle_option,
								[L.SUC.." #03"] = toggle_option,
								[L.SUC.." #04"] = toggle_option,
								[L.SUC.." #05"] = toggle_option,
								[L.SUC.." #06"] = toggle_option,
								[L.SUC.." #07"] = toggle_option,
								[L.SUC.." #08"] = toggle_option,
								[L.SUC.." #09"] = toggle_option,
								[L.SUC.." #10"] = toggle_option,
								[L.SUC.." #11"] = toggle_option,
								[L.SUC.." #12"] = toggle_option,
							},
						},
  	  		},
  	  	},
				VOIDquotesSubFrame = {
					type = 'group',
					name = L.VOID.." "..string.lower(L.QUOTES),
					desc = L.CLICKEDIT,
					order = 29,
					args = {
						header = {
							type = "header",
							name = "\124TInterface\\Icons\\Spell_Shadow_summonvoidwalker:16\124t "..L.VOID.." "..L.QUOTES.." "..L.MANAGEMENT,
							order = 30,
						},												
						SUMvoidQuotesmaxScale = {
							order = 31,
							type = "range",
							name = L.ENABLEDQUOTES,			
							desc = L.MAXTOUSE,
							min = 1, max = 10, step = 1,
        			get = "getSSopt",
        			set = "setSSopt",
							disabled = "disSSopt",
						},					
  					VOIDquoteTab = {
    					type = "description",
      				name = function()
      					return "|cFF00FF00"..L.TAGDESCPLAYER.." |cff7fff7f"..L.ONLY.." |cFF00FF00"..L.AND.." |cff7fff7f"..L.NOT.." |cFF00FF00"..L.CASESENSITIVE..L.IFNONAME.."\n"..L.VOID..L.NAMEDETECT.."|cffff0000<"..db.SUMvoid..">"
      					end,
      				desc = " ",
      				order = 32,
						},						
						VOIDquoteGroup = {
							type = "group",
							name = " ",
							guiInline = true,
							order = 33,
							childGroups = "input",
							args = {
								[L.VOID.." #01"] = toggle_option,
								[L.VOID.." #02"] = toggle_option,
								[L.VOID.." #03"] = toggle_option,
								[L.VOID.." #04"] = toggle_option,
								[L.VOID.." #05"] = toggle_option,
								[L.VOID.." #06"] = toggle_option,
								[L.VOID.." #07"] = toggle_option,
								[L.VOID.." #08"] = toggle_option,
								[L.VOID.." #09"] = toggle_option,
								[L.VOID.." #10"] = toggle_option,
							},
						},
  	  		},
  	  	},
  	  },
    },
  	ResurrectedSubFrame = {
			type = 'group',
			name = L.RESURRECTED.." "..string.lower(L.EMOTES),
			desc = L.ENABLESELECTEMOTE,
			order = 6,
			args = {    	
				header = {
					type = "header",
					name = "\124TInterface\\Icons\\Spell_holy_resurrection:18\124t "..L.RESURRECTED.." "..L.MANAGEMENT,
					order = 0,
				},
    		Resurrected = {
    			type = "toggle",
      		name = L.USE,
      		desc = L.EMOTEREZ,
      		order = 1,
        	get = "getSSopt",
        	set = "setSSopt",
    		},
				RESfrequency = {
					order = 2,
					type = "range",
					name = L.FREQUENCY,
					desc = L.FREQDESC,
					min = 1, max = 100, step = 1,
      		get = "getSSopt",
      		set = "setSSopt",
					disabled = "disSSopt",
				},
    		RESparty = {
    			type = "toggle",
      		name = L.INPARTY,
      		desc = L.EMOTEPARTY,
      		order = 3,
        	get = "getSSopt",
					set = "setSSopt",
					disabled = "disSSopt",
    		},
				RESpartyEmotes = {
					type = 'select',
					name = L.SELECTEDEMOTE,
					desc = L.SELECTREZEMOTE,
					order = 4,
        	get = "getSSopt",
					set = "setSSopt",
					values = ResurrectedStyles,
        	disabled = "disSSopt",
				},
    		RESraid = {
    			type = "toggle",
      		name = L.INRAID,
      		desc = L.EMOTERAID,
      		order = 5,
        	get = "getSSopt",
					set = "setSSopt",
					disabled = "disSSopt",
    		},
				RESraidEmotes = {
					type = 'select',
					name = L.SELECTEDEMOTE,
					desc = L.SELECTREZEMOTE,
					order = 6,
        	get = "getSSopt",
					set = "setSSopt",
					values = ResurrectedStyles,
					disabled = "disSSopt",
				},
    		RESsolo = {
    			type = "toggle",
      		name = L.BYOURSELF,
      		desc = L.EMOTESOLO,
      		order = 7,
        	get = "getSSopt",
					set = "setSSopt",
					disabled = "disSSopt",
    		},
				RESsoloEmotes = {
					type = 'select',
					name = L.SELECTEDEMOTE,
					desc = L.SELECTREZEMOTE,
					order = 8,
        	get = "getSSopt",
					set = "setSSopt",
					values = ResurrectedStyles,
					disabled = "disSSopt",
				},
    		RESrandom = {
    			type = "toggle",
      		name = L.USE.." "..L.RANDOM.." "..L.EMOTE,
      		order = 9,
        	get = "getSSopt",
					set = "setSSopt",
        	disabled = "disSSopt",
    		},
    	},
    },
    AboutFrame = {
			type = "group",
			name = L.ABOUT,
   		desc = L.CLICKREAD,			
			order = 7,
			args = {
				header = {
					type = "header",
					name = L.ABOUT,
					order = 0,
				},
				logo = {
					type = "description",
					name = "\124TInterface\\Icons\\Spell_Shadow_SoulGem:64\124t",
					order = 1,
				},				
				logdesc = {
					type = "description",
					name = L["ABOUT_TEXT"],
					order = 2,
				},								
			},
		},
	},
}

local mainoptions = {
	handler = SoulSpeak,
  type = "group",
  args = {
   	SSbasicDesc = {
			order = 1,
			type = 'description',
			name = "\124TInterface\\Icons\\Spell_Shadow_SoulGem:14\124t |cffB0A0ffSoulSpeak (v|r"..GetAddOnMetadata("SoulSpeak", "version").."|cffB0A0ff) reacts to various soul events using emotes and quotes! Builtin support for LDB(Broker) panels.",
		},
	SSoptionsHeader = {
			order = 2,
			type = 'header',
			name = "",
		},		
    SSoptionsButton = {
     	type = "execute",
      name = L.OPTIONS,
      order = 3,
			func = "OpenOptions",
    },    
	},
}

local defaults = {
	profile =  {
		SSmaxScale = 28,
		SSmaxDelete = false,

    Hearthstone = true,
    morningHearthstone = true,
    afternoonHearthstone = true,
    eveningHearthstone = true,
    nightHearthstone = true,
    randomHearthstone = false,
    morningEmotes = { Emote = 1 },
    afternoonEmotes = { Emote = 2 },
    eveningEmotes = { Emote = 3 },
    nightEmotes = { Emote = 4 },
    HearthstoneFrequency = 50,

    RitualSouls = true,
    RitualSoulsHelpme = true,
    RitualSoulsParty = true,
    RitualSoulsRaid = true,
    RitualSoulsChatFrame = false,
    RitualSoulsPartyChannels = { Channel = 1 },
    RitualSoulsRaidChannels = { Channel = 2 },
    RitualSoulsQuotesmaxScale = 20,
    RitualSoulsFrequency = 100,
    lastRSOquote = "",

    RitualSummoning = true,
    RitualSummoningHelpme = true,
    RitualSummoningParty = true,
    RitualSummoningRaid = true,
    RitualSummoningChatFrame = false,
    RitualSummoningPartyChannels = { Channel = 1 },
    RitualSummoningRaidChannels = { Channel = 2 },
    RitualSummoningQuotesmaxScale = 31,
    RitualSummoningFrequency = 100,
    lastRSUquote = "",

    Soulstone = true,
    SoulstoneParty = true,
    SoulstoneRaid = true,
    SoulstoneSelf = true,
    SoulstoneSolo = true,
    SoulstoneEmoteFrequency = 25,
    SoulstoneQuoteFrequency = 50,
    SoulstoneWhisperFrequency = 75,
    SoulstonePartyChannels = { Channel = 1 },
    SoulstoneRaidChannels = { Channel = 4 },
    SoulstoneSoloChannels = { Channel = 3 },
    SoulstoneEMmaxScale = 15,
    SoulstoneQuotesmaxScale = 21,
    SoulstoneWhispersmaxScale = 18,
    lastSSRemote = "",
    lastSSRquote = "",
    lastSSRwhisper = "",

		SUM = true,
		SUMparty = true,
		SUMraid = true,
		SUMsolo = true,
		SUMfrequency = 20,
		SUMpartyChannels = { Channel = 2 },
		SUMraidChannels = { Channel = 3 },
		SUMsoloChannels = { Channel = 2 },
		SUMfgrdQuotesmaxScale = 6,
		SUMfelQuotesmaxScale = 6,
		SUMimpQuotesmaxScale = 18,
		SUMsucQuotesmaxScale = 12,
		SUMvoidQuotesmaxScale = 10,
		SUMfgrd = "noname",
		SUMfel = "noname",
		SUMimp = "noname",
		SUMsuc = "noname",
		SUMvoid = "noname",
		lastSUMicon = "\124TInterface\\Icons\\Spell_Shadow_summonimp:1",
		lastFGRDquote = "",
		lastFELquote = "",
		lastIMPquote = "",
		lastSUCquote = "",
		lastVOIDquote = "",

    Resurrected = true,
    RESparty = true,
    RESraid = true,
    RESsolo = true,
    RESplayer = "",
    RESfrequency = 100,
    RESrandom = false,
    RESpartyEmotes = { Emote = 1 },
    RESraidEmotes = { Emote = 1 },
    RESsoloEmotes = { Emote = 1 },

    RitualSoulsQuotes = {
			L.RSOquote1,
			L.RSOquote2,
			L.RSOquote3,
			L.RSOquote4,
			L.RSOquote5,
			L.RSOquote6,
			L.RSOquote7,
			L.RSOquote8,
			L.RSOquote9,																					
			L.RSOquote10,
			L.RSOquote11,
			L.RSOquote12,
			L.RSOquote13,
			L.RSOquote14,
			L.RSOquote15,
			L.RSOquote16,
			L.RSOquote17,
			L.RSOquote18,
			L.RSOquote19,
			L.RSOquote20,
    },
		RitualSummoningQuotes = {
			L.RSUquote1,
			L.RSUquote2,
			L.RSUquote3,
			L.RSUquote4,
			L.RSUquote5,
			L.RSUquote6,
			L.RSUquote7,
			L.RSUquote8,
			L.RSUquote9,
			L.RSUquote10,
			L.RSUquote11,
			L.RSUquote12,
			L.RSUquote13,
			L.RSUquote14,
			L.RSUquote15,
			L.RSUquote16,
			L.RSUquote17,
			L.RSUquote18,
			L.RSUquote19,
			L.RSUquote20,
			L.RSUquote21,
			L.RSUquote22,
			L.RSUquote23,
			L.RSUquote24,
			L.RSUquote25,
			L.RSUquote26,
			L.RSUquote27,
			L.RSUquote28,
			L.RSUquote29,
			L.RSUquote30,
			L.RSUquote31,
    },
		SoulstoneEmotes = {
			L.SSEquote1,
			L.SSEquote2,
			L.SSEquote3,
			L.SSEquote4,
			L.SSEquote5,
			L.SSEquote6,
			L.SSEquote7,
			L.SSEquote8,
			L.SSEquote9,																					
			L.SSEquote10,
			L.SSEquote11,
			L.SSEquote12,
			L.SSEquote13,
			L.SSEquote14,
			L.SSEquote15,
    },
		SoulstoneQuotes = {
			L.SSQquote1,
			L.SSQquote2,
			L.SSQquote3,
			L.SSQquote4,
			L.SSQquote5,
			L.SSQquote6,
			L.SSQquote7,
			L.SSQquote8,
			L.SSQquote9,																					
			L.SSQquote10,
			L.SSQquote11,
			L.SSQquote12,
			L.SSQquote13,
			L.SSQquote14,
			L.SSQquote15,
			L.SSQquote16,
			L.SSQquote17,
			L.SSQquote18,
			L.SSQquote19,
			L.SSQquote20,
			L.SSQquote21,
    },
		SoulstoneWhispers = {
			L.SSWquote1,
			L.SSWquote2,
			L.SSWquote3,
			L.SSWquote4,
			L.SSWquote5,
			L.SSWquote6,
			L.SSWquote7,
			L.SSWquote8,
			L.SSWquote9,																					
			L.SSWquote10,
			L.SSWquote11,
			L.SSWquote12,
			L.SSWquote13,
			L.SSWquote14,
			L.SSWquote15,
			L.SSWquote16,
			L.SSWquote17,
			L.SSWquote18,
    },
    SUMfgrdQuotes = {
    	L.FGRDquote1,
    	L.FGRDquote2,
    	L.FGRDquote3,
    	L.FGRDquote4,
    	L.FGRDquote5,
    	L.FGRDquote6,
    },
    SUMfelQuotes = {
    	L.FELquote1,
    	L.FELquote2,
    	L.FELquote3,
    	L.FELquote4,
    	L.FELquote5,
    	L.FELquote6,
    },
    SUMimpQuotes = {
    	L.IMPquote1,
    	L.IMPquote2,
    	L.IMPquote3,
    	L.IMPquote4,
    	L.IMPquote5,
    	L.IMPquote6,
    	L.IMPquote7,
    	L.IMPquote8,
    	L.IMPquote9,
    	L.IMPquote10,
    	L.IMPquote11,
    	L.IMPquote12,
    	L.IMPquote13,
    	L.IMPquote14,
    	L.IMPquote15,
    	L.IMPquote16,
    	L.IMPquote17,
    	L.IMPquote18,
    },
    SUMsucQuotes = {
    	L.SUCquote1,
    	L.SUCquote2,
    	L.SUCquote3,
    	L.SUCquote4,
    	L.SUCquote5,
    	L.SUCquote6,
    	L.SUCquote7,
    	L.SUCquote8,
    	L.SUCquote9,
    	L.SUCquote10,
    	L.SUCquote11,
    	L.SUCquote12,
    },
    SUMvoidQuotes = {
    	L.VOIDquote1,
    	L.VOIDquote2,
    	L.VOIDquote3,
    	L.VOIDquote4,
    	L.VOIDquote5,
    	L.VOIDquote6,
    	L.VOIDquote7,
    	L.VOIDquote8,
    	L.VOIDquote9,
    	L.VOIDquote10,
    }
  },
}

local function txtReplace(txt)
	local playerClass, englishClass = UnitClass("player")
	txt = txt:gsub(L.PLAYER, UnitName("player"))
	if DemonName ~= "noname" then
		txt = txt:gsub(L.PET, DemonName)
	else
		txt = txt:gsub(L.PET, "...")
	end
	if SStarget == "" or SStarget == UnitName("player") then	
		local genderTable = { L.IT, L.HE, L.SHE }
		local gender = string.match(txt, genderTable[UnitSex("player")])
		if gender ~= nil then
			txt = txt:gsub(L.HESHE, gender)
			gender = nil
		end
		genderTable = { L.ITS, L.HIM, L.HER }	
		gender = string.match(txt, genderTable[UnitSex("player")])
		if gender ~= nil then
			txt = txt:gsub(L.HIMHER, gender)
			gender = nil
		end
		genderTable = { L.ITS, L.HIS, L.HER }	
		gender = string.match(txt, genderTable[UnitSex("player")])
		if gender ~= nil then
			txt = txt:gsub(L.HISHER, gender)
			gender = nil
		end
		genderTable = { L.ITS, L.HIS, L.HERS }	
		gender = string.match(txt, genderTable[UnitSex("player")])
		if gender ~= nil then
			txt = txt:gsub(L.HISHERS, gender)
			gender = nil
		end		
		if UnitName("target") ~= nil then
			local targetClass, englishClass = UnitClass("target")	
			txt = txt:gsub(L.TARGET, (UnitName("target")))
			txt = txt:gsub(L.TARGETCLASS, targetClass)
		else
			txt = txt:gsub(L.TARGET, L.NOTARGET)
			txt = txt:gsub(L.TARGETCLASS, L.NOTARGET)
		end		
	elseif SStarget ~= "" then
		txt = txt:gsub(L.TARGET, (SStarget))
		txt = txt:gsub(L.TARGETCLASS, targetClass)
		local gender = string.match(txt, SSgenderTable1)
		if gender ~= nil then
			txt = txt:gsub(L.HESHE, gender)
			gender = nil
		end
		gender = string.match(txt, SSgenderTable2)
		if gender ~= nil then
			txt = txt:gsub(L.HIMHER, gender)
			gender = nil
		end
		gender = string.match(txt, SSgenderTable3)
		if gender ~= nil then
			txt = txt:gsub(L.HISHER, gender)
			gender = nil
		end
		gender = string.match(txt, SSgenderTable4)
		if gender ~= nil then
			txt = txt:gsub(L.HISHERS, gender)
			gender = nil
		end
	end	
	return txt
end

function SoulSpeak:OnInitialize()
	self.db = LibStub("AceDB-3.0"):New("SoulSpeakDB", defaults)
  db = self.db.profile
	SoulSpeak.db.RegisterCallback(self, "OnProfileChanged", "OnProfileChanged")
	SoulSpeak.db.RegisterCallback(self, "OnProfileCopied", "OnProfileChanged")
	SoulSpeak.db.RegisterCallback(self, "OnProfileReset", "OnProfileChanged")
	AceConfig = LibStub("AceConfig-3.0")
	AceConfigDialog = LibStub("AceConfigDialog-3.0")
  options.args.profile = LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db)
  optFrame = AceConfigDialog:AddToBlizOptions("Options", "SoulSpeak")
  AceConfig:RegisterOptionsTable("SoulSpeak", options)
  AceConfig:RegisterOptionsTable("Options", mainoptions)
  self:RegisterChatCommand("ss", "ChatCommand")
  self:RegisterChatCommand("soulspeak", "ChatCommand")
	SoulSpeak:Print("|cffB0A0ff<SoulSpeak>|r v|cffffd200"..GetAddOnMetadata("SoulSpeak", "version").."|r initialized. Type /ss for options.");
end

function SoulSpeak:OnProfileChanged(event, database, newProfileKey)
	self.db = LibStub("AceDB-3.0"):New("SoulSpeakDB", defaults)
  db = self.db.profile
 	SoulSpeak.db.RegisterCallback(self, "OnProfileChanged", "OnProfileChanged")
	SoulSpeak.db.RegisterCallback(self, "OnProfileCopied", "OnProfileChanged")
	SoulSpeak.db.RegisterCallback(self, "OnProfileReset", "OnProfileChanged")
	AceConfig = LibStub("AceConfig-3.0")
	AceConfigDialog = LibStub("AceConfigDialog-3.0")  
  options.args.profile = LibStub("AceDBOptions-3.0"):GetOptionsTable(self.db)
	SoulSpeak:UpdateSoulShardBlockText()
end

function SoulSpeak:OnEnable()
	self:RegisterEvent("UNIT_PET")
	self:RegisterEvent("BAG_UPDATE")
	self:RegisterEvent("PLAYER_ALIVE")
	self:RegisterEvent("PLAYER_UNGHOST")
	self:RegisterEvent("RESURRECT_REQUEST")
	self:RegisterEvent("UNIT_SPELLCAST_SENT")
	self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
	SoulSpeak:UpdateSoulShardBlockText()
end

function SoulSpeak:GetName(info)
	local n = info[#info]
	return (n)
end

function SoulSpeak:UpdateSoulShardBlockText()
	SSamount = GetItemCount(SSid)
	if db.SSmaxDelete == true then
		local SSpercent = 100 / db.SSmaxScale
		if SSamount * SSpercent >= 83 then
			SoulSpeakBlock.text = "|cff00ff00"..SSamount.."/"..db.SSmaxScale
		elseif (SSamount * SSpercent >= 67) and (SSamount * SSpercent < 83) then
			SoulSpeakBlock.text = "|cff7fff7f"..SSamount.."/"..db.SSmaxScale
		elseif (SSamount * SSpercent >= 50) and (SSamount * SSpercent < 67) then
			SoulSpeakBlock.text = "|cffffff00"..SSamount.."/"..db.SSmaxScale
		elseif (SSamount * SSpercent >= 33) and (SSamount * SSpercent < 50) then
			SoulSpeakBlock.text = "|cffffff78"..SSamount.."/"..db.SSmaxScale
		elseif (SSamount * SSpercent >= 17) and (SSamount * SSpercent < 33) then
			SoulSpeakBlock.text = "|cffff6b00"..SSamount.."/"..db.SSmaxScale						
		else
			SoulSpeakBlock.text = "|cffff0000"..SSamount.."/"..db.SSmaxScale
		end
	else
		SoulSpeakBlock.text = SSamount
	end
end

function SoulSpeak:ChatCommand(input)
	if not input or input:trim() == "" then
		SoulSpeak:OpenOptions()
	else
  	InterfaceOptionsFrame:Hide()
    LibStub("AceConfigCmd-3.0").HandleCommand(SoulSpeak, "ss", "soulspeak", input)
	end
end

function SoulSpeak:OpenOptions()
	PlaySound("igSpellBookOpen")
	AceConfigDialog:SetDefaultSize("SoulSpeak", 730, 540)
	AceConfigDialog:Open("SoulSpeak")
end

function SoulSpeak:BAG_UPDATE()
	if db.SSmaxDelete == true then
		SSamount = GetItemCount(SSid)			
		if SSamount > db.SSmaxScale and db.SSmaxDelete == true then
			local d = GetItemCount(SSid) - db.SSmaxScale
			for Bag=0,4 do
				for Slot = 1, GetContainerNumSlots(Bag) do
					if (d > 0) then
						link = GetContainerItemLink(Bag,Slot)
						if link and string.find(link, SSid) then
							PickupContainerItem(Bag, Slot)
							DeleteCursorItem()
							d = d - 1
						end
					end
				end
			end
		end
	end
	SSamount = GetItemCount(SSid)
	SoulSpeak:UpdateSoulShardBlockText()
end

function SoulSpeak:UNIT_SPELLCAST_SENT()
	if db.Hearthstone == true and arg2 == HSspell and random(1,100) <= db.HearthstoneFrequency then
		local hour,minute = GetGameTime()
		local second = (hour * 3600) + (minute * 60)
		if (second >= 0 and second < 21600) and db.nightHearthstone == true  then
			if db.randomHearthstone == true then DoEmote(HearthstoneEmotes[random(1,14)])
			else
				DoEmote(HearthstoneEmotes[db.nightEmotes.Emote])
			end
		elseif (second >= 21600 and second < 43200) and db.morningHearthstone == true then
			if db.randomHearthstone == true then
				DoEmote(HearthstoneEmotes[random(1,14)])
			else
				DoEmote(HearthstoneEmotes[db.morningEmotes.Emote])
			end
		elseif (second >= 43200 and second < 64800) and db.afternoonHearthstone == true then
			if db.randomHearthstone == true then
				DoEmote(HearthstoneEmotes[random(1,14)])
			else
				DoEmote(HearthstoneEmotes[db.afternoonEmotes.Emote])
			end
		elseif (second >= 64800 and second <= 86400) and db.eveningHearthstone == true then
			if db.randomHearthstone == true then
				DoEmote(HearthstoneEmotes[random(1,14)])
			else
				DoEmote(HearthstoneEmotes[db.eveningEmotes.Emote])
			end
		end
	end

	if db.Soulstone == true and arg1 == "player" and arg2 == SSRspell then SStarget = arg4
	if UnitName("target") and arg4 == nil then
		SStarget = UnitName("target") end
	targetClass, englishClass = UnitClass("target")
	genderTable = { L.IT, L.HE, L.SHE }
	SSgenderTable1 = genderTable[UnitSex("target")]
	genderTable = { L.ITS, L.HIM, L.HER }
	SSgenderTable2 = genderTable[UnitSex("target")]
	genderTable = { L.ITS, L.HIS, L.HER }
	SSgenderTable3 = genderTable[UnitSex("target")]
	genderTable = { L.ITS, L.HIS, L.HERS }
	SSgenderTable4 = genderTable[UnitSex("target")]
	else SStarget = "" end

	if db.RitualSouls == true and arg2 == RSOspell and random(1,100) <= db.RitualSoulsFrequency then
		local i = 0		
		if db.RitualSoulsQuotesmaxScale == 1 then i = 1
		else
			repeat 
				i = random(1,db.RitualSoulsQuotesmaxScale)
  		until i ~= db.lastRSOquote
		end
		db.lastRSOquote = i
		if GetNumRaidMembers() > 0 and db.RitualSoulsRaid == true then
			if db.RitualSoulsQuotes[i] ~= "" then
				SendChatMessage(txtReplace(db.RitualSoulsQuotes[i]),RaidChannels[db.RitualSoulsRaidChannels.Channel])
			else
				self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)				
			end
		elseif GetNumPartyMembers() > 0 and db.RitualSoulsParty == true then
			if db.RitualSoulsQuotes[i] ~= "" then
				SendChatMessage(txtReplace(db.RitualSoulsQuotes[i]),PartyChannels[db.RitualSoulsPartyChannels.Channel])
			else
				self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)				
			end
		elseif db.RitualSoulsChatFrame == true then
			if db.RitualSoulsQuotes[i] ~= "" then
				self:Print("|cffff0000"..L.CHATONLY.." |cffB0A0ff"..txtReplace(db.RitualSoulsQuotes[i]))
			else
				self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)
			end
		end
	end

	if db.RitualSummoning == true and arg2 == RSUspell and random(1,100) <= db.RitualSummoningFrequency then
		local i = 0
		if db.RitualSummoningQuotesmaxScale == 1 then i = 1
		else
			repeat 
				i = random(1,db.RitualSummoningQuotesmaxScale)
  		until i ~= db.lastRSUquote
		end
		db.lastRSUquote = i
		if GetNumRaidMembers() > 0 and db.RitualSummoningRaid == true then
			if db.RitualSummoningQuotes[i] ~= "" then
				SendChatMessage(txtReplace(db.RitualSummoningQuotes[i]),RaidChannels[db.RitualSummoningRaidChannels.Channel])
			else
				self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)				
			end
		elseif GetNumPartyMembers() > 0 and db.RitualSummoningParty == true then
			if db.RitualSummoningQuotes[i] ~= "" then
				SendChatMessage(txtReplace(db.RitualSummoningQuotes[i]),PartyChannels[db.RitualSummoningPartyChannels.Channel])
			else
				self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)				
			end
		elseif db.RitualSummoningChatFrame == true then
			if db.RitualSummoningQuotes[i] ~= "" then
				self:Print("|cffff0000"..L.CHATONLY.." |cffB0A0ff"..txtReplace(db.RitualSummoningQuotes[i]))
			else
				self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)
			end
		end
	end

	if db.SUM == true then
		if arg2 == summonFGRD and random(1,100) <= db.SUMfrequency then
			local i = 0
			if db.SUMfgrdQuotesmaxScale == 1 then i = 1
			else
				repeat 
					i = random(1,db.SUMfgrdQuotesmaxScale)
  			until i ~= db.lastFGRDquote
			end
			db.lastFGRDquote = i
			DemonName = db.SUMfgrd
			if GetNumRaidMembers() > 0 and db.SUMraid == true then
				if db.SUMfgrdQuotes[i] ~= "" then
					SendChatMessage(txtReplace(db.SUMfgrdQuotes[i]),RaidChannels[db.SUMraidChannels.Channel])
				else
					self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)				
				end
			elseif GetNumPartyMembers() > 0 and db.SUMparty == true then
				if db.SUMfgrdQuotes[i] ~= "" then
					SendChatMessage(txtReplace(db.SUMfgrdQuotes[i]),PartyChannels[db.SUMpartyChannels.Channel])
				else
					self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)				
				end
			elseif db.SUMsolo == true then
				if db.SUMsoloChannels.Channel == 1 then
					if db.SUMfgrdQuotes[i] ~= "" then
						self:Print("|cffff0000"..L.CHATONLY.." |cffB0A0ff"..txtReplace(db.SUMfgrdQuotes[i]))
					else
						self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)
					end					
				else
					if db.SUMfgrdQuotes[i] ~= "" then
						SendChatMessage(txtReplace(db.SUMfgrdQuotes[i]),SoloChannels[db.SUMsoloChannels.Channel])
					else
						self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)												
					end
				end
			end
		elseif arg2 == summonFEL and random(1,100) <= db.SUMfrequency then
			local i = 0
			if db.SUMfelQuotesmaxScale == 1 then i = 1
			else
				repeat 
					i = random(1,db.SUMfelQuotesmaxScale)
  			until i ~= db.lastFELquote
			end
			db.lastFELquote = i
			DemonName = db.SUMfel
			if GetNumRaidMembers() > 0 and db.SUMraid == true then
				if db.SUMfelQuotes[i] ~= "" then
					SendChatMessage(txtReplace(db.SUMfelQuotes[i]),RaidChannels[db.SUMraidChannels.Channel])
				else
					self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)				
				end
			elseif GetNumPartyMembers() > 0 and db.SUMparty == true then
				if db.SUMfelQuotes[i] ~= "" then
					SendChatMessage(txtReplace(db.SUMfelQuotes[i]),PartyChannels[db.SUMpartyChannels.Channel])
				else
					self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)				
				end
			elseif db.SUMsolo == true then
				if db.SUMsoloChannels.Channel == 1 then
					if db.SUMfelQuotes[i] ~= "" then
						self:Print("|cffff0000"..L.CHATONLY.." |cffB0A0ff"..txtReplace(db.SUMfelQuotes[i]))
					else
						self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)
					end					
				else
					if db.SUMfelQuotes[i] ~= "" then
						SendChatMessage(txtReplace(db.SUMfelQuotes[i]),SoloChannels[db.SUMsoloChannels.Channel])
					else
						self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)												
					end
				end
			end
		elseif arg2 == summonIMP and random(1,100) <= db.SUMfrequency then
			local i = 0
			if db.SUMimpQuotesmaxScale == 1 then i = 1
			else
				repeat 
					i = random(1,db.SUMimpQuotesmaxScale)
  			until i ~= db.lastIMPquote
			end
			db.lastIMPquote = i
			DemonName = db.SUMimp
			if GetNumRaidMembers() > 0 and db.SUMraid == true then
				if db.SUMimpQuotes[i] ~= "" then
					SendChatMessage(txtReplace(db.SUMimpQuotes[i]),RaidChannels[db.SUMraidChannels.Channel])
				else
					self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)				
				end
			elseif GetNumPartyMembers() > 0 and db.SUMparty == true then
				if db.SUMimpQuotes[i] ~= "" then
					SendChatMessage(txtReplace(db.SUMimpQuotes[i]),PartyChannels[db.SUMpartyChannels.Channel])
				else
					self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)				
				end
			elseif db.SUMsolo == true then
				if db.SUMsoloChannels.Channel == 1 then
					if db.SUMimpQuotes[i] ~= "" then
						self:Print("|cffff0000"..L.CHATONLY.." |cffB0A0ff"..txtReplace(db.SUMimpQuotes[i]))
					else
						self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)
					end					
				else
					if db.SUMimpQuotes[i] ~= "" then
						SendChatMessage(txtReplace(db.SUMimpQuotes[i]),SoloChannels[db.SUMsoloChannels.Channel])
					else
						self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)												
					end
				end
			end
		elseif arg2 == summonSUC and random(1,100) <= db.SUMfrequency then
			local i = 0
			if db.SUMsucQuotesmaxScale == 1 then i = 1
			else
				repeat 
					i = random(1,db.SUMsucQuotesmaxScale)
  			until i ~= db.lastSUCquote
			end
			db.lastSUCquote = i
			DemonName = db.SUMsuc
			if GetNumRaidMembers() > 0 and db.SUMraid == true then
				if db.SUMsucQuotes[i] ~= "" then
					SendChatMessage(txtReplace(db.SUMsucQuotes[i]),RaidChannels[db.SUMraidChannels.Channel])
				else
					self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)				
				end
			elseif GetNumPartyMembers() > 0 and db.SUMparty == true then
				if db.SUMsucQuotes[i] ~= "" then
					SendChatMessage(txtReplace(db.SUMsucQuotes[i]),PartyChannels[db.SUMpartyChannels.Channel])
				else
					self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)				
				end
			elseif db.SUMsolo == true then
				if db.SUMsoloChannels.Channel == 1 then
					if db.SUMsucQuotes[i] ~= "" then
						self:Print("|cffff0000"..L.CHATONLY.." |cffB0A0ff"..txtReplace(db.SUMsucQuotes[i]))
					else
						self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)
					end					
				else
					if db.SUMsucQuotes[i] ~= "" then
						SendChatMessage(txtReplace(db.SUMsucQuotes[i]),SoloChannels[db.SUMsoloChannels.Channel])
					else
						self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)												
					end
				end
			end
		elseif (arg2 == summonVOID or arg2 == summonVOIDnomana) and random(1,100) <= db.SUMfrequency then
			local i = 0
			if db.SUMvoidQuotesmaxScale == 1 then i = 1
			else
				repeat 
					i = random(1,db.SUMvoidQuotesmaxScale)
  			until i ~= db.lastVOIDquote
			end
			db.lastVOIDquote = i
			DemonName = db.SUMvoid
			if GetNumRaidMembers() > 0 and db.SUMraid == true then
				if db.SUMvoidQuotes[i] ~= "" then
					SendChatMessage(txtReplace(db.SUMvoidQuotes[i]),RaidChannels[db.SUMraidChannels.Channel])
				else
					self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)				
				end
			elseif GetNumPartyMembers() > 0 and db.SUMparty == true then
				if db.SUMvoidQuotes[i] ~= "" then
					SendChatMessage(txtReplace(db.SUMvoidQuotes[i]),PartyChannels[db.SUMpartyChannels.Channel])
				else
					self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)				
				end
			elseif db.SUMsolo == true then
				if db.SUMsoloChannels.Channel == 1 then
					if db.SUMvoidQuotes[i] ~= "" then
						self:Print("|cffff0000"..L.CHATONLY.." |cffB0A0ff"..txtReplace(db.SUMvoidQuotes[i]))
					else
						self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)
					end					
				else
					if db.SUMvoidQuotes[i] ~= "" then
						SendChatMessage(txtReplace(db.SUMvoidQuotes[i]),SoloChannels[db.SUMsoloChannels.Channel])
					else
						self:Print("|cffff0000"..L.WARNING.." |cffB0A0ff"..L.EMPTYQUOTE)												
					end
				end
			end
		end
	end
end

function SoulSpeak:UNIT_SPELLCAST_SUCCEEDED()
	if db.RitualSouls == true and db.RitualSoulsHelpme == true and arg1 == "player" and arg2 == RSOspell then
		if GetNumPartyMembers() > 0 and random(1,100) <= db.RitualSoulsFrequency then
			DoEmote("HELPME")
		end
	elseif db.RitualSummoning == true and db.RitualSummoningHelpme == true and arg1 == "player" and arg2 == RSUspell then
		if GetNumPartyMembers() > 0 and random(1,100) <= db.RitualSummoningFrequency then
			DoEmote("HELPME")
		end
	end

	if db.Soulstone == true and arg1 == "player" and arg2 == SSRspell then
		if SStarget == UnitName("player") and db.SoulstoneSelf == true and random(1,100) <= db.SoulstoneEmoteFrequency then
			local i = 0
			if db.SoulstoneEMmaxScale == 1 then i = 1
			else
				repeat 
					i = random(1,db.SoulstoneEMmaxScale)
  			until i ~= db.lastSSRemote
  		end
  		if db.SoulstoneEmotes[i] ~= "" then
				SendChatMessage(txtReplace(db.SoulstoneEmotes[i]),"EMOTE",nil,"SAY")
			end
			db.lastSSRemote = i
		elseif SStarget ~= "" and SStarget ~= UnitName("player") then
			local iq = 0
			local iw = 0			
			if db.SoulstoneQuotesmaxScale == 1 then iq = 1
			else
				repeat 
					iq = random(1,db.SoulstoneQuotesmaxScale)
  			until iq ~= db.lastSSRquote
  		end
  		if db.SoulstoneWhispersmaxScale == 1 then iw = 1
  		else
				repeat 
					iw = random(1,db.SoulstoneWhispersmaxScale)
  			until iw ~= db.lastSSRwhisper
  		end
			db.lastSSRquote = iq  		
			db.lastSSRwhisper = iw
			if GetNumRaidMembers() > 0 and db.SoulstoneRaid == true then
				if (db.SoulstoneRaidChannels.Channel == 1 or db.SoulstoneRaidChannels.Channel == 3 or db.SoulstoneRaidChannels.Channel == 5 or db.SoulstoneRaidChannels.Channel == 7) then
					if db.SoulstoneQuotes[iq] ~= "" and random(1,100) <= db.SoulstoneQuoteFrequency then
						SendChatMessage(txtReplace(db.SoulstoneQuotes[iq]),SoulRaidChannels[db.SoulstoneRaidChannels.Channel])
					end
				elseif db.SoulstoneRaidChannels.Channel == 2 or db.SoulstoneRaidChannels.Channel == 4 or db.SoulstoneRaidChannels.Channel == 6 or db.SoulstoneRaidChannels.Channel == 8 then
					if db.SoulstoneQuotes[iq] ~= "" and random(1,100) <= db.SoulstoneQuoteFrequency then
						SendChatMessage(txtReplace(db.SoulstoneQuotes[iq]),SoulRaidChannels[db.SoulstoneRaidChannels.Channel])
					end
					if db.SoulstoneWhispers[iw] ~= "" and random(1,100) <= db.SoulstoneWhisperFrequency then
						SendChatMessage(txtReplace(db.SoulstoneWhispers[iw]),"WHISPER",nil,SStarget)
					end
				end
			elseif GetNumPartyMembers() > 0 and db.SoulstoneParty == true then
				if db.SoulstonePartyChannels.Channel == 1 or db.SoulstonePartyChannels.Channel == 3 or db.SoulstonePartyChannels.Channel == 5 then
					if db.SoulstoneQuotes[iq] ~= "" and random(1,100) <= db.SoulstoneQuoteFrequency then
						SendChatMessage(txtReplace(db.SoulstoneQuotes[iq]),SoulPartyChannels[db.SoulstonePartyChannels.Channel])
					end
				elseif db.SoulstonePartyChannels.Channel == 2 or db.SoulstonePartyChannels.Channel == 4 or db.SoulstonePartyChannels.Channel == 6 then
					if db.SoulstoneQuotes[iq] ~= "" and random(1,100) <= db.SoulstoneQuoteFrequency then
						SendChatMessage(txtReplace(db.SoulstoneQuotes[iq]),SoulPartyChannels[db.SoulstonePartyChannels.Channel])
					end
					if db.SoulstoneWhispers[iw] ~= "" and random(1,100) <= db.SoulstoneWhisperFrequency then
						SendChatMessage(txtReplace(db.SoulstoneWhispers[iw]),"WHISPER",nil,SStarget)
					end
				end
			elseif db.SoulstoneSolo == true then
				if db.SoulstoneSoloChannels.Channel == 1 then
					if db.SoulstoneQuotes[iq] ~= "" and random(1,100) <= db.SoulstoneQuoteFrequency then
						self:Print("|cffff0000"..L.CHATONLY.." |cffB0A0ff"..txtReplace(db.SoulstoneQuotes[iq]))
					end
				elseif db.SoulstoneSoloChannels.Channel == 2 or db.SoulstoneSoloChannels.Channel == 4 then
					if db.SoulstoneQuotes[iq] ~= "" and random(1,100) <= db.SoulstoneQuoteFrequency then
						SendChatMessage(txtReplace(db.SoulstoneQuotes[iq]),SoulSoloChannels[db.SoulstoneSoloChannels.Channel])
					end
				elseif db.SoulstoneSoloChannels.Channel == 3 or db.SoulstoneSoloChannels.Channel == 5 then
					if db.SoulstoneQuotes[iq] ~= "" and random(1,100) <= db.SoulstoneQuoteFrequency then
						SendChatMessage(txtReplace(db.SoulstoneQuotes[iq]),SoulSoloChannels[db.SoulstoneSoloChannels.Channel])
					end
					if db.SoulstoneWhispers[iw] ~= "" and random(1,100) <= db.SoulstoneWhisperFrequency then
						SendChatMessage(txtReplace(db.SoulstoneWhispers[iw]),"WHISPER",nil,SStarget)
					end
				end
			end	
		SStarget = ""			
		end
	end

	if arg1 == "player" and (arg2 == summonFGRD or arg2 == summonFEL or arg2 == summonIMP or arg2 == summonSUC or arg2 == summonVOID or arg2 == summonVOIDnomana) then
		if arg2 == summonFGRD then db.lastSUMicon = "\124TInterface\\Icons\\Spell_Shadow_summonfelguard:1"
		elseif arg2 == summonFEL then db.lastSUMicon = "\124TInterface\\Icons\\Spell_Shadow_summonfelhunter:1"
		elseif arg2 == summonIMP then db.lastSUMicon = "\124TInterface\\Icons\\Spell_Shadow_summonimp:1"
		elseif arg2 == summonSUC then db.lastSUMicon = "\124TInterface\\Icons\\Spell_Shadow_summonsuccubus:1"
		elseif arg2 == summonVOID or arg2 == summonVOIDnomana then db.lastSUMicon = "\124TInterface\\Icons\\Spell_Shadow_summonvoidwalker:1"
		end
	end
end

function SoulSpeak:UNIT_PET()
	if arg1 == "player" and (UnitName("pet")) ~= "Unknown" then
		if UnitCreatureFamily("pet") == L.FGRD and (UnitName("pet")) ~= db.SUMfgrd then
			db.SUMfgrd = (UnitName("pet"))
			SoulSpeak:Print("|cffB0A0ffFelguard's name saved as |cffff0000<"..db.SUMfgrd..">")
		elseif UnitCreatureFamily("pet") == L.FEL and (UnitName("pet")) ~= db.SUMfel then
			db.SUMfel = (UnitName("pet"))
			SoulSpeak:Print("|cffB0A0ffFelhunter's name saved as |cffff0000<"..db.SUMfel..">")
		elseif UnitCreatureFamily("pet") == L.IMP and (UnitName("pet")) ~= db.SUMimp then
			db.SUMimp = (UnitName("pet"))
			SoulSpeak:Print("|cffB0A0ffImp's name saved as |cffff0000<"..db.SUMimp..">")
		elseif UnitCreatureFamily("pet") == L.SUC and (UnitName("pet")) ~= db.SUMsuc then
			db.SUMsuc = (UnitName("pet"))
			SoulSpeak:Print("|cffB0A0ffSuccubus's name saved as |cffff0000<"..db.SUMsuc..">")
		elseif UnitCreatureFamily("pet") == L.VOID and (UnitName("pet")) ~= db.SUMvoid then
			db.SUMvoid = (UnitName("pet"))
			SoulSpeak:Print("|cffB0A0ffVoidwalker's name saved as |cffff0000<"..db.SUMvoid..">")
		end
	end
end

function SoulSpeak:RESURRECT_REQUEST()
	if db.Resurrected == true and arg1 ~= nil then
		if GetNumRaidMembers() > 0 and db.RESraid == true then
			db.RESplayer = arg1
		elseif GetNumPartyMembers() > 0 and db.RESparty == true then
			db.RESplayer = arg1
		elseif db.RESsolo == true then
			db.RESplayer = arg1
		else db.RESplayer = ""
		end
	end
end

function SoulSpeak:PLAYER_UNGHOST()
	if db.Resurrected == true and db.RESplayer ~= "" and random(1,100) <= db.RESfrequency then
		if GetNumRaidMembers() > 0 and db.RESraid == true then
			if db.RESrandom == true then
				DoEmote(ResurrectedEmotes[random(1,12)],db.RESplayer)
			else
				DoEmote(ResurrectedEmotes[db.RESraidEmotes.Emote],db.RESplayer)
			end
		elseif GetNumPartyMembers() > 0 and db.RESparty == true then
			if db.RESrandom == true then
				DoEmote(ResurrectedEmotes[random(1,12)],db.RESplayer)
			else
				DoEmote(ResurrectedEmotes[db.RESpartyEmotes.Emote],db.RESplayer)
			end
		elseif db.RESsolo == true then
			if db.RESrandom == true then
				DoEmote(ResurrectedEmotes[random(1,12)],db.RESplayer)
			else
				DoEmote(ResurrectedEmotes[db.RESsoloEmotes.Emote],db.RESplayer)
			end
		end
		db.RESplayer = ""
	end
end

function SoulSpeak:PLAYER_ALIVE()
	if db.Resurrected == true and db.RESplayer ~= "" and random(1,100) <= db.RESfrequency then
		if GetNumRaidMembers() > 0 and db.RESraid == true then
			if db.RESrandom == true then
				DoEmote(ResurrectedEmotes[random(1,12)],db.RESplayer)
			else
				DoEmote(ResurrectedEmotes[db.RESraidEmotes.Emote],db.RESplayer)
			end
		elseif GetNumPartyMembers() > 0 and db.RESparty == true then
			if db.RESrandom == true then
				DoEmote(ResurrectedEmotes[random(1,12)],db.RESplayer)
			else
				DoEmote(ResurrectedEmotes[db.RESpartyEmotes.Emote],db.RESplayer)
			end
		elseif db.RESsolo == true then
			if db.RESrandom == true then
				DoEmote(ResurrectedEmotes[random(1,12)],db.RESplayer)
			else
				DoEmote(ResurrectedEmotes[db.RESsoloEmotes.Emote],db.RESplayer)
			end
		end
		db.RESplayer = ""
	end
end

function SoulSpeak:getSSopt(info, ...)
	if string.find(info[#info], "Emotes") then return db[info[#info]].Emote
	elseif string.find(info[#info], "Channels") then return db[info[#info]].Channel
	elseif string.find(info[#info], L.EMOTE) then return db.SoulstoneEmotes[tonumber(string.match(info[#info], "%d%d"))]
	elseif string.find(info[#info], L.QUOTE) then return db.SoulstoneQuotes[tonumber(string.match(info[#info], "%d%d"))]
	elseif string.find(info[#info], L.WHISPER) then return db.SoulstoneWhispers[tonumber(string.match(info[#info], "%d%d"))]
	elseif string.find(info[#info], L.RITUALSOULS) then return db.RitualSoulsQuotes[tonumber(string.match(info[#info], "%d%d"))]
	elseif string.find(info[#info], L.RITUALSUMMONING) then return db.RitualSummoningQuotes[tonumber(string.match(info[#info], "%d%d"))]
	elseif string.find(info[#info], L.FGRD) then return db.SUMfgrdQuotes[tonumber(string.match(info[#info], "%d%d"))]
	elseif string.find(info[#info], L.FEL) then return db.SUMfelQuotes[tonumber(string.match(info[#info], "%d%d"))]
	elseif string.find(info[#info], L.IMP) then return db.SUMimpQuotes[tonumber(string.match(info[#info], "%d%d"))]
	elseif string.find(info[#info], L.SUC) then return db.SUMsucQuotes[tonumber(string.match(info[#info], "%d%d"))]
	elseif string.find(info[#info], L.VOID) then return db.SUMvoidQuotes[tonumber(string.match(info[#info], "%d%d"))]
	else return db[info[#info]] end
end

function SoulSpeak:setSSopt(info, newValue)
	PlaySound("UChatScrollButton")
	if string.find(info[#info], "Emotes") then db[info[#info]].Emote = newValue
	elseif string.find(info[#info], "Channels") then db[info[#info]].Channel = newValue

	elseif string.find(info[#info], L.EMOTE) then db.SoulstoneEmotes[tonumber(string.match(info[#info], "%d%d"))] = newValue
	elseif string.find(info[#info], L.QUOTE) then db.SoulstoneQuotes[tonumber(string.match(info[#info], "%d%d"))] = newValue
	elseif string.find(info[#info], L.WHISPER) then db.SoulstoneWhispers[tonumber(string.match(info[#info], "%d%d"))] = newValue
	elseif string.find(info[#info], L.RITUALSOULS) then db.RitualSoulsQuotes[tonumber(string.match(info[#info], "%d%d"))] = newValue
	elseif string.find(info[#info], L.RITUALSUMMONING) then db.RitualSummoningQuotes[tonumber(string.match(info[#info], "%d%d"))] = newValue
	elseif string.find(info[#info], L.FGRD) then db.SUMfgrdQuotes[tonumber(string.match(info[#info], "%d%d"))] = newValue
	elseif string.find(info[#info], L.FEL) then db.SUMfelQuotes[tonumber(string.match(info[#info], "%d%d"))] = newValue
	elseif string.find(info[#info], L.IMP) then db.SUMimpQuotes[tonumber(string.match(info[#info], "%d%d"))] = newValue
	elseif string.find(info[#info], L.SUC) then db.SUMsucQuotes[tonumber(string.match(info[#info], "%d%d"))] = newValue
	elseif string.find(info[#info], L.VOID) then db.SUMvoidQuotes[tonumber(string.match(info[#info], "%d%d"))] = newValue

	elseif info[#info] == "morningHearthstone" then
		if db.Hearthstone == true and newValue == false and db.afternoonHearthstone == false and db.eveningHearthstone == false and db.nightHearthstone == false then db.morningHearthstone = true
		elseif newValue == true then db.morningHearthstone = true
    else db.morningHearthstone = false end
 	elseif info[#info] == "afternoonHearthstone" then
 		if db.Hearthstone == true and newValue == false and db.morningHearthstone == false and db.eveningHearthstone == false and db.nightHearthstone == false then db.afternoonHearthstone = true
		elseif newValue == true then db.afternoonHearthstone = true
    else db.afternoonHearthstone = false end
 	elseif info[#info] == "eveningHearthstone" then
 		if db.Hearthstone == true and newValue == false and db.morningHearthstone == false and db.afternoonHearthstone == false and db.nightHearthstone == false then db.eveningHearthstone = true
		elseif newValue == true then db.eveningHearthstone = true
    else db.eveningHearthstone = false end
 	elseif info[#info] == "nightHearthstone" then
 		if db.Hearthstone == true and newValue == false and db.morningHearthstone == false and db.afternoonHearthstone == false and db.eveningHearthstone == false then db.nightHearthstone = true
		elseif newValue == true then db.nightHearthstone = true
 		else db.nightHearthstone = false end

 	elseif info[#info] == "SoulstoneParty" then
 		if db.Soulstone == true and newValue == false and db.SoulstoneSelf == false and db.SoulstoneRaid == false and db.SoulstoneSolo == false then db.SoulstoneParty = true
		elseif newValue == true then db.SoulstoneParty = true
    else db.SoulstoneParty = false end
 	elseif info[#info] == "SoulstoneRaid" then
 		if db.Soulstone == true and newValue == false and db.SoulstoneSelf == false and db.SoulstoneParty == false and db.SoulstoneSolo == false then db.SoulstoneRaid = true
		elseif newValue == true then db.SoulstoneRaid = true
    else db.SoulstoneRaid = false end
 	elseif info[#info] == "SoulstoneSolo" then
 		if db.Soulstone == true and newValue == false and db.SoulstoneSelf == false and db.SoulstoneParty == false and db.SoulstoneRaid == false then db.SoulstoneSolo = true
		elseif newValue == true then db.SoulstoneSolo = true
    else db.SoulstoneSolo = false end
 	elseif info[#info] == "SoulstoneSelf" then
	 	if db.Soulstone == true and newValue == false and db.SoulstoneParty == false and db.SoulstoneRaid == false and db.SoulstoneSolo == false then db.SoulstoneSelf = true
		elseif newValue == true then db.SoulstoneSelf = true
    else db.SoulstoneSelf = false end

	elseif info[#info] == "RitualSoulsParty" then
		if newValue == false and db.RitualSoulsRaid == false and db.RitualSoulsChatFrame == false then db.RitualSoulsParty = true
		elseif newValue == true then db.RitualSoulsParty = true
		else db.RitualSoulsParty = false end
	elseif info[#info] == "RitualSoulsRaid" then
  	if newValue == false and db.RitualSoulsParty == false and db.RitualSoulsChatFrame == false then db.RitualSoulsRaid = true
		elseif newValue == true then db.RitualSoulsRaid = true
  	else db.RitualSoulsRaid = false end
	elseif info[#info] == "RitualSoulsChatFrame" then
		if newValue == false and db.RitualSoulsParty == false and db.RitualSoulsRaid == false then db.RitualSoulsChatFrame = true
		elseif newValue == true then db.RitualSoulsChatFrame = true
  	else db.RitualSoulsChatFrame = false end
  	
	elseif info[#info] == "RitualSummoningParty" then
		if newValue == false and db.RitualSummoningRaid == false and db.RitualSummoningChatFrame == false then db.RitualSummoningParty = true
		elseif newValue == true then db.RitualSummoningParty = true
		else db.RitualSummoningParty = false end
	elseif info[#info] == "RitualSummoningRaid" then
		if newValue == false and db.RitualSummoningParty == false and db.RitualSummoningChatFrame == false then db.RitualSummoningRaid = true
		elseif newValue == true then db.RitualSummoningRaid = true
		else db.RitualSummoningRaid = false end
	elseif info[#info] == "RitualSummoningChatFrame" then
		if newValue == false and db.RitualSummoningParty == false and db.RitualSummoningRaid == false then db.RitualSummoningChatFrame = true
		elseif newValue == true then db.RitualSummoningChatFrame = true
		else db.RitualSummoningChatFrame = false end
		
	elseif info[#info] == "SUMparty" then
		if db.SUM == true and newValue == false and db.SUMraid == false and db.SUMsolo == false then db.SUMparty = true
		elseif newValue == true then db.SUMparty = true
		else db.SUMparty = false end
	elseif info[#info] == "SUMraid" then
		if db.SUM == true and newValue == false and db.SUMparty == false and db.SUMsolo == false then db.SUMraid = true
		elseif newValue == true then db.SUMraid = true
		else db.SUMraid = false end
	elseif info[#info] == "SUMsolo" then
		if db.SUM == true and newValue == false and db.SUMparty == false and db.SUMraid == false then db.SUMsolo = true
		elseif newValue == true then db.SUMsolo = true
		else db.SUMsolo = false end

	elseif info[#info] == "RESparty" then
		if newValue == false and db.RESraid == false and db.RESsolo == false then db.RESparty = true
		elseif newValue == true then db.RESparty = true
		else db.RESparty = false end
	elseif info[#info] == "RESraid" then
		if newValue == false and db.RESparty == false and db.RESsolo == false then db.RESraid = true
		elseif newValue == true then db.RESraid = true
		else db.RESraid = false end
	elseif info[#info] == "RESsolo" then
		if newValue == false and db.RESparty == false and db.RESraid == false then db.RESsolo = true
		elseif newValue == true then db.RESsolo = true
		else db.RESsolo = false end      		

	else
		db[info[#info]] = newValue
		if info[#info] == "SSmaxDelete" or info[#info] == "SSmaxScale" then SoulSpeak:UpdateSoulShardBlockText() end
	end
end

function SoulSpeak:disSSopt(info, ...)
	if info[#info] == "SSinstaDelete" then return (db.SSmaxScale == GetItemCount(SSid) or db.SSmaxScale > GetItemCount(SSid))
	elseif info[#info] == "SSmaxScale" then return (db.SSmaxDelete == false)

	elseif info[#info] == "morningEmotes" then return (db.Hearthstone == false or db.morningHearthstone == false or db.randomHearthstone == true)
	elseif info[#info] == "afternoonEmotes" then return (db.Hearthstone == false or db.afternoonHearthstone == false or db.randomHearthstone == true)
	elseif info[#info] == "eveningEmotes" then return (db.Hearthstone == false or db.eveningHearthstone == false or db.randomHearthstone == true)
	elseif info[#info] == "nightEmotes" then return (db.Hearthstone == false or db.nightHearthstone == false or db.randomHearthstone == true)
	elseif string.find(info[#info], L.HEARTHSTONE) then return (db.Hearthstone == false)

	elseif string.find(info[#info], L.EMOTE) then return (db.Soulstone == false or (db.SoulstoneEMmaxScale < tonumber(string.match(info[#info], "%d%d")) ))
	elseif string.find(info[#info], L.QUOTE) then return (db.Soulstone == false or (db.SoulstoneQuotesmaxScale < tonumber(string.match(info[#info], "%d%d")) ))
	elseif string.find(info[#info], L.WHISPER) then return (db.Soulstone == false or (db.SoulstoneWhispersmaxScale < tonumber(string.match(info[#info], "%d%d")) ))
	elseif string.find(info[#info], L.RITUALSOULS) then return (db.RitualSouls == false or (db.RitualSoulsQuotesmaxScale < tonumber(string.match(info[#info], "%d%d")) ))
	elseif string.find(info[#info], L.RITUALSUMMONING) then return (db.RitualSummoning == false or (db.RitualSummoningQuotesmaxScale < tonumber(string.match(info[#info], "%d%d")) ))

	elseif info[#info] == "SoulstonePartyChannels" then return (db.Soulstone == false or db.SoulstoneParty == false)
	elseif info[#info] == "SoulstoneRaidChannels" then return (db.Soulstone == false or db.SoulstoneRaid == false)
	elseif info[#info] == "SoulstoneSoloChannels" then return (db.Soulstone == false or db.SoulstoneSolo == false)
	elseif string.find(info[#info], L.SOULSTONE) then return (db.Soulstone == false)	

	elseif info[#info] == "RitualSoulsPartyChannels" then return (db.RitualSouls == false or db.RitualSoulsParty == false)
	elseif info[#info] == "RitualSoulsRaidChannels" then return (db.RitualSouls == false or db.RitualSoulsRaid == false)
	elseif string.find(info[#info], "RitualSouls") then return (db.RitualSouls == false)

	elseif info[#info] == "RitualSummoningPartyChannels" then return (db.RitualSummoning == false or db.RitualSummoningParty == false)
	elseif info[#info] == "RitualSummoningRaidChannels" then return (db.RitualSummoning == false or db.RitualSummoningRaid == false)
	elseif string.find(info[#info], "RitualSummoning") then return (db.RitualSummoning == false)

	elseif (info[#info] == "SUMfelQuotesmaxScale" or info[#info] == "SUMimpQuotesmaxScale" or info[#info] == "SUMvoidQuotesmaxScale" or info[#info] == "SUMsucQuotesmaxScale") then return (db.SUM == false)
	elseif string.find(info[#info], L.FGRD) then return (db.SUM == false or (db.SUMfgrdQuotesmaxScale < tonumber(string.match(info[#info], "%d%d")) ))
	elseif string.find(info[#info], L.FEL) then return (db.SUM == false or (db.SUMfelQuotesmaxScale < tonumber(string.match(info[#info], "%d%d")) ))
	elseif string.find(info[#info], L.IMP) then return (db.SUM == false or (db.SUMimpQuotesmaxScale < tonumber(string.match(info[#info], "%d%d")) ))
	elseif string.find(info[#info], L.SUC) then return (db.SUM == false or (db.SUMsucQuotesmaxScale < tonumber(string.match(info[#info], "%d%d")) ))
	elseif string.find(info[#info], L.VOID) then return (db.SUM == false or (db.SUMvoidQuotesmaxScale < tonumber(string.match(info[#info], "%d%d")) ))

	elseif (info[#info] == "RESfrequency" or info[#info] == "RESrandom" ) then return (db.Resurrected == false)
	elseif info[#info] == "RESpartyEmotes" then return (db.Resurrected == false or db.RESparty == false or db.RESrandom == true)
	elseif info[#info] == "RESraidEmotes" then return (db.Resurrected == false or db.RESraid == false or db.RESrandom == true)
	elseif info[#info] == "RESsoloEmotes" then return (db.Resurrected == false or db.RESsolo == false or db.RESrandom == true)
	elseif string.find(info[#info], "RES") then return (db.Resurrected == false)

	elseif info[#info] == "SUMpartyChannels"	then return (db.SUM == false or db.SUMparty == false)
	elseif info[#info] == "SUMraidChannels" then	return (db.SUM == false or db.SUMraid == false)
	elseif info[#info] == "SUMsoloChannels" then return (db.SUM == false or db.SUMsolo == false)
	else return (db.SUM == false)
	end
end