SMARTBUFF_PLAYERCLASS = nil;
SMARTBUFF_BUFFLIST = nil;
SMARTBUFF_PATTERNS = nil;

-- Buff types
SMARTBUFF_CONST_GROUP     = "GROUP";
SMARTBUFF_CONST_SELF      = "SELF";
SMARTBUFF_CONST_FORCESELF = "FORCESELF";
SMARTBUFF_CONST_TRACK     = "TRACK";
SMARTBUFF_CONST_WEAPON    = "WEAPON";
SMARTBUFF_CONST_INV       = "INVENTORY";
SMARTBUFF_CONST_FOOD      = "FOOD";


function SMARTBUFF_InitItemList()
  -- Reagents
  SMARTBUFF_WILDBERRIES         = GetItemInfo(17021); --"Wild Berries"
  SMARTBUFF_WILDTHORNROOT       = GetItemInfo(17026); --"Wild Thornroot"
  SMARTBUFF_WILDQUILLVINE       = GetItemInfo(22148); --"Wild Quillvine"
  SMARTBUFF_ARCANEPOWDER        = GetItemInfo(17020); --"Arcane Powder"
  SMARTBUFF_HOLYCANDLE          = GetItemInfo(17028); --"Holy Candle"
  SMARTBUFF_SACREDCANDLE        = GetItemInfo(17029); --"Sacred Candle"
  SMARTBUFF_SYMBOLOFKINGS       = GetItemInfo(21177); --"Symbol of Kings"
  
  -- Stones and oils
  SMARTBUFF_SSROUGH             = GetItemInfo(2862);  --"Rough Sharpening Stone"
  SMARTBUFF_SSCOARSE            = GetItemInfo(2863);  --"Coarse Sharpening Stone"
  SMARTBUFF_SSHEAVY             = GetItemInfo(2871);  --"Heavy Sharpening Stone"
  SMARTBUFF_SSSOLID             = GetItemInfo(7964);  --"Solid Sharpening Stone"
  SMARTBUFF_SSDENSE             = GetItemInfo(12404); --"Dense Sharpening Stone"
  SMARTBUFF_SSELEMENTAL         = GetItemInfo(18262); --"Elemental Sharpening Stone"
  SMARTBUFF_SSFEL               = GetItemInfo(23528); --"Fel Sharpening Stone"
  SMARTBUFF_SSADAMANTITE        = GetItemInfo(23529); --"Adamantite Sharpening Stone"
  SMARTBUFF_WSROUGH             = GetItemInfo(3239);  --"Rough Weightstone"
  SMARTBUFF_WSCOARSE            = GetItemInfo(3240);  --"Coarse Weightstone"
  SMARTBUFF_WSHEAVY             = GetItemInfo(3241);  --"Heavy Weightstone"
  SMARTBUFF_WSSOLID             = GetItemInfo(7965);  --"Solid Weightstone"
  SMARTBUFF_WSDENSE             = GetItemInfo(12643); --"Dense Weightstone"
  SMARTBUFF_WSFEL               = GetItemInfo(28420); --"Fel Weightstone"
  SMARTBUFF_WSADAMANTITE        = GetItemInfo(28421); --"Adamantite Weightstone"
  SMARTBUFF_SHADOWOIL           = GetItemInfo(3824);  --"Shadow Oil"
  SMARTBUFF_FROSTOIL            = GetItemInfo(3829);  --"Frost Oil"
  SMARTBUFF_MANAOILMINOR        = GetItemInfo(20745); --"Minor Mana Oil"
  SMARTBUFF_MANAOILLESSER       = GetItemInfo(20747); --"Lesser Mana Oil"
  SMARTBUFF_MANAOILBRILLIANT    = GetItemInfo(20748); --"Brilliant Mana Oil"
  SMARTBUFF_MANAOILSUPERIOR     = GetItemInfo(22521); --"Superior Mana Oil"
  SMARTBUFF_WIZARDOILMINOR      = GetItemInfo(20744); --"Minor Wizard Oil"
  SMARTBUFF_WIZARDOILLESSER     = GetItemInfo(20746); --"Lesser Wizard Oil"
  SMARTBUFF_WIZARDOIL           = GetItemInfo(20750); --"Wizard Oil"
  SMARTBUFF_WIZARDOILBRILLIANT  = GetItemInfo(20749); --"Brilliant Wizard Oil"
  SMARTBUFF_WIZARDOILSUPERIOR   = GetItemInfo(22522); --"Superior Wizard Oil"
  
  -- Poisons
  SMARTBUFF_INSTANTPOISON1      = GetItemInfo(6947);  --"Instant Poison"
  SMARTBUFF_INSTANTPOISON2      = GetItemInfo(6949);  --"Instant Poison II"
  SMARTBUFF_INSTANTPOISON3      = GetItemInfo(6950);  --"Instant Poison III"
  SMARTBUFF_INSTANTPOISON4      = GetItemInfo(8926);  --"Instant Poison IV"
  SMARTBUFF_INSTANTPOISON5      = GetItemInfo(8927);  --"Instant Poison V"
  SMARTBUFF_INSTANTPOISON6      = GetItemInfo(8928);  --"Instant Poison VI"
  SMARTBUFF_INSTANTPOISON7      = GetItemInfo(21927); --"Instant Poison VII"
  SMARTBUFF_WOUNDPOISON1        = GetItemInfo(10918); --"Wound Poison"
  SMARTBUFF_WOUNDPOISON2        = GetItemInfo(10920); --"Wound Poison II"
  SMARTBUFF_WOUNDPOISON3        = GetItemInfo(10921); --"Wound Poison III"
  SMARTBUFF_WOUNDPOISON4        = GetItemInfo(10922); --"Wound Poison IV"
  SMARTBUFF_WOUNDPOISON5        = GetItemInfo(22055); --"Wound Poison V"
  SMARTBUFF_MINDPOISON1         = GetItemInfo(5237);  --"Mind-numbing Poison"
  SMARTBUFF_MINDPOISON2         = GetItemInfo(6951);  --"Mind-numbing Poison II"
  SMARTBUFF_MINDPOISON3         = GetItemInfo(9186);  --"Mind-numbing Poison III"
  SMARTBUFF_DEADLYPOISON1       = GetItemInfo(2892);  --"Deadly Poison"
  SMARTBUFF_DEADLYPOISON2       = GetItemInfo(2893);  --"Deadly Poison II"
  SMARTBUFF_DEADLYPOISON3       = GetItemInfo(8984);  --"Deadly Poison III"
  SMARTBUFF_DEADLYPOISON4       = GetItemInfo(8985);  --"Deadly Poison IV"
  SMARTBUFF_DEADLYPOISON5       = GetItemInfo(20844); --"Deadly Poison V"
  SMARTBUFF_DEADLYPOISON6       = GetItemInfo(22053); --"Deadly Poison VI"
  SMARTBUFF_DEADLYPOISON7       = GetItemInfo(22054); --"Deadly Poison VII"
  SMARTBUFF_CRIPPLINGPOISON1    = GetItemInfo(3775);  --"Crippling Poison"
  SMARTBUFF_CRIPPLINGPOISON2    = GetItemInfo(3776);  --"Crippling Poison II"
  SMARTBUFF_ANESTHETICPOISON1   = GetItemInfo(21835); --"Anesthetic Poison"
  
  -- Food
  SMARTBUFF_SAGEFISHDELIGHT     = GetItemInfo(21217); --"Sagefish Delight"
  SMARTBUFF_BUZZARDBITES        = GetItemInfo(27651); --"Buzzard Bites"
  SMARTBUFF_RAVAGERDOG          = GetItemInfo(27655); --"Ravager Dog"
  SMARTBUFF_FELTAILDELIGHT      = GetItemInfo(27662); --"Feltail Delight"
  SMARTBUFF_CLAMBAR             = GetItemInfo(30155); --"Clam Bar"
  SMARTBUFF_BROILEDBLOODFIN     = GetItemInfo(33867); --"Broiled Bloodfin"
  --SMARTBUFF_KIBLERSBITE         = GetItemInfo(33874); --"Kibler's Bits"
  SMARTBUFF_SPORELINGSNACK      = GetItemInfo(27656); --"Sporeling Snack"
  SMARTBUFF_BLACKENEDSPOREFISH  = GetItemInfo(27663); --"Blackened Sporefish"
  SMARTBUFF_BLACKENEDBASILISK   = GetItemInfo(27657); --"Blackened Basilisk"
  SMARTBUFF_GRILLEDMUDFISH      = GetItemInfo(27664); --"Grilled Mudfish"
  SMARTBUFF_POACHEDBLUEFISH     = GetItemInfo(27665); --"Poached Bluefish"
  SMARTBUFF_ROASTEDCLEFTHOOF    = GetItemInfo(27658); --"Roasted Clefthoof"
  SMARTBUFF_SPICYHOTTALBUK      = GetItemInfo(33872); --"Spicy Hot Talbuk"
  SMARTBUFF_SKULLFISHSOUP       = GetItemInfo(33825); --"Skullfish Soup"
  SMARTBUFF_WARPBURGER          = GetItemInfo(27659); --"Warp Burger"
  SMARTBUFF_TALBUKSTEAK         = GetItemInfo(27660); --"Talbuk Steak"
  SMARTBUFF_GOLDENFISHSTICKS    = GetItemInfo(27666); --"Golden Fish Sticks"
  SMARTBUFF_CRUNCHYSERPENT      = GetItemInfo(31673); --"Crunchy Serpent"
  SMARTBUFF_MOKNATHALSHORTRIBS  = GetItemInfo(31672); --"Mok'Nathal Shortribs"
  SMARTBUFF_SPICYCRAWDAD        = GetItemInfo(27667); --"Spicy Crawdad"
  --SMARTBUFF_FISHERMANSFEAST     = GetItemInfo(33052); --"Fisherman's Feast"
  --SMARTBUFF_HOTAPPLECIDER       = GetItemInfo(34411); --"Hot Apple Cider"
  
  --SMARTBUFF_ = GetItemInfo(xxx); --""
  
  --if (SMARTBUFF_SACREDCANDLE) then
    --SMARTBUFF_AddMsgD(SMARTBUFF_SACREDCANDLE.." found");
  --end
  
  SMARTBUFF_AddMsgD("Item list initialized");
end


function SMARTBUFF_InitSpellIDs()
  -- Druid
  SMARTBUFF_DRUID_CAT       = GetSpellInfo(768);   --"Cat Form"
  SMARTBUFF_DRUID_MOONKIN   = GetSpellInfo(24858); --"Moonkin Form"
  SMARTBUFF_DRUID_TRACK     = GetSpellInfo(5225);  --"Track Humanoids"
  SMARTBUFF_MOTW            = GetSpellInfo(1126);  --"Mark of the Wild"
  SMARTBUFF_GOTW            = GetSpellInfo(21849); --"Gift of the Wild"
  SMARTBUFF_THORNS          = GetSpellInfo(467);   --"Thorns"
  SMARTBUFF_OMENOFCLARITY   = GetSpellInfo(16864); --"Omen of Clarity"
  SMARTBUFF_BARKSKIN        = GetSpellInfo(22812); --"Barkskin"
  SMARTBUFF_NATURESGRASP    = GetSpellInfo(16689); --"Nature's Grasp"
  SMARTBUFF_TIGERSFURY      = GetSpellInfo(5217);  --"Tiger's Fury"

  -- Priest
  SMARTBUFF_PWF             = GetSpellInfo(1243);  --"Power Word: Fortitude"
  SMARTBUFF_POF             = GetSpellInfo(21562); --"Prayer of Fortitude"
  SMARTBUFF_SP              = GetSpellInfo(976);   --"Shadow Protection"
  SMARTBUFF_POSP            = GetSpellInfo(27683); --"Prayer of Shadow Protection"
  SMARTBUFF_INNERFIRE       = GetSpellInfo(588);   --"Inner Fire"
  SMARTBUFF_DS              = GetSpellInfo(14752); --"Divine Spirit"
  SMARTBUFF_POS             = GetSpellInfo(27681); --"Prayer of Spirit"
  SMARTBUFF_PWS             = GetSpellInfo(17);    --"Power Word: Shield"
  SMARTBUFF_FEARWARD        = GetSpellInfo(6346);  --"Fear Ward"
  SMARTBUFF_ELUNESGRACE     = GetSpellInfo(2651);  --"Elune's Grace"
  SMARTBUFF_FEEDBACK        = GetSpellInfo(13896); --"Feedback"
  SMARTBUFF_SHADOWGUARD     = GetSpellInfo(18137); --"Shadowguard"
  SMARTBUFF_TOUCHOFWEAKNESS = GetSpellInfo(2652);  --"Touch of Weakness"
  SMARTBUFF_INNERFOCUS      = GetSpellInfo(14751); --"Inner Focus"
  SMARTBUFF_RENEW           = GetSpellInfo(139);   --"Renew"
  
  -- Mage
  SMARTBUFF_AI              = GetSpellInfo(1459);  --"Arcane Intellect"
  SMARTBUFF_AB              = GetSpellInfo(23028); --"Arcane Brilliance"
  SMARTBUFF_ICEARMOR        = GetSpellInfo(7302);  --"Ice Armor"
  SMARTBUFF_FROSTARMOR      = GetSpellInfo(168);   --"Frost Armor"
  SMARTBUFF_MAGEARMOR       = GetSpellInfo(6117);  --"Mage Armor"
  SMARTBUFF_MOLTENARMOR     = GetSpellInfo(30482); --"Molten Armor"
  SMARTBUFF_DAMPENMAGIC     = GetSpellInfo(604);   --"Dampen Magic"
  SMARTBUFF_AMPLIFYMAGIC    = GetSpellInfo(1008);  --"Amplify Magic"
  SMARTBUFF_MANASHIELD      = GetSpellInfo(1463);  --"Mana Shield"
  SMARTBUFF_FIREWARD        = GetSpellInfo(543);   --"Fire Ward"
  SMARTBUFF_FROSTWARD       = GetSpellInfo(6143);  --"Frost Ward"
  SMARTBUFF_ICEBARRIER      = GetSpellInfo(11426); --"Ice Barrier"
  SMARTBUFF_COMBUSTION      = GetSpellInfo(11129); --"Combustion"
  SMARTBUFF_ARCANEPOWER     = GetSpellInfo(12042); --"Arcane Power"
  SMARTBUFF_PRESENCEOFMIND  = GetSpellInfo(12043); --"Presence of Mind"
  SMARTBUFF_ICYVEINS        = GetSpellInfo(12472); --"Icy Veins"
  SMARTBUFF_SUMMONWATERELE  = GetSpellInfo(31687); --"Summon Water Elemental"
  
  -- Warlock
  SMARTBUFF_FELARMOR        = GetSpellInfo(28176); --"Fel Armor"
  SMARTBUFF_DEMONARMOR      = GetSpellInfo(706);   --"Demon Armor"
  SMARTBUFF_DEMONSKIN       = GetSpellInfo(687);   --"Demon Skin"
  SMARTBUFF_UNENDINGBREATH  = GetSpellInfo(5697);  --"Unending Breath"
  SMARTBUFF_DINVISIBILITY   = GetSpellInfo(132);   --"Detect Invisibility"
  SMARTBUFF_SOULLINK        = GetSpellInfo(19028); --"Soul Link"
  SMARTBUFF_SHADOWWARD      = GetSpellInfo(6229);  --"Shadow Ward"
  SMARTBUFF_DARKPACT        = GetSpellInfo(18220); --"Dark Pact"
  
  -- Hunter
  SMARTBUFF_TRUESHOTAURA    = GetSpellInfo(19506); --"Trueshot Aura"
  SMARTBUFF_RAPIDFIRE       = GetSpellInfo(3045);  --"Rapid Fire"
  SMARTBUFF_AOTH            = GetSpellInfo(13165); --"Aspect of the Hawk"
  SMARTBUFF_AOTM            = GetSpellInfo(13163); --"Aspect of the Monkey"
  SMARTBUFF_AOTW            = GetSpellInfo(20043); --"Aspect of the Wild"
  SMARTBUFF_AOTB            = GetSpellInfo(13161); --"Aspect of the Beast"
  SMARTBUFF_AOTC            = GetSpellInfo(5118);  --"Aspect of the Cheetah"
  SMARTBUFF_AOTP            = GetSpellInfo(13159); --"Aspect of the Pack"
  SMARTBUFF_AOTV            = GetSpellInfo(34074); --"Aspect of the Viper"
  
  -- Shaman
  SMARTBUFF_LIGHTNINGSHIELD = GetSpellInfo(324);   --"Lightning Shield"
  SMARTBUFF_WATERSHIELD     = GetSpellInfo(24398); --"Water Shield"
  SMARTBUFF_EARTHSHIELD     = GetSpellInfo(974);   --"Earth Shield"
  SMARTBUFF_ROCKBITERW      = GetSpellInfo(8017);  --"Rockbiter Weapon"
  SMARTBUFF_FROSTBRANDW     = GetSpellInfo(8033);  --"Frostbrand Weapon"
  SMARTBUFF_FLAMETONGUEW    = GetSpellInfo(8024);  --"Flametongue Weapon"
  SMARTBUFF_WINDFURYW       = GetSpellInfo(8232);  --"Windfury Weapon"
  SMARTBUFF_WATERBREATHING  = GetSpellInfo(131);   --"Water Breathing"
  
  -- Warrior
  SMARTBUFF_BATTLESHOUT     = GetSpellInfo(6673);  --"Battle Shout"
  SMARTBUFF_COMMANDINGSHOUT = GetSpellInfo(469);   --"Commanding Shout"
  SMARTBUFF_BERSERKERRAGE   = GetSpellInfo(18499); --"Berserker Rage"
  SMARTBUFF_BLOODRAGE       = GetSpellInfo(2687);  --"Bloodrage"
  SMARTBUFF_RAMPAGE         = GetSpellInfo(29801); --"Rampage"

  -- Rogue
  SMARTBUFF_BLADEFLURRY     = GetSpellInfo(13877); --"Blade Flurry"
  SMARTBUFF_SAD             = GetSpellInfo(5171);  --"Slice and Dice"
  SMARTBUFF_EVASION         = GetSpellInfo(5277);  --"Evasion"
  
  -- Paladin
  SMARTBUFF_RIGHTEOUSFURY         = GetSpellInfo(25780); --"Righteous Fury"
  SMARTBUFF_HOLYSHIELD            = GetSpellInfo(20925); --"Holy Shield"
  SMARTBUFF_BOM                   = GetSpellInfo(19740); --"Blessing of Might"
  SMARTBUFF_GBOM                  = GetSpellInfo(25782); --"Greater Blessing of Might"
  SMARTBUFF_BOW                   = GetSpellInfo(19742); --"Blessing of Wisdom"
  SMARTBUFF_GBOW                  = GetSpellInfo(25894); --"Greater Blessing of Wisdom"
  SMARTBUFF_BOSAL                 = GetSpellInfo(1038);  --"Blessing of Salvation"
  SMARTBUFF_GBOSAL                = GetSpellInfo(25895); --"Greater Blessing of Salvation"
  SMARTBUFF_BOK                   = GetSpellInfo(20217); --"Blessing of Kings"
  SMARTBUFF_GBOK                  = GetSpellInfo(25898); --"Greater Blessing of Kings"
  SMARTBUFF_BOSAN                 = GetSpellInfo(20911); --"Blessing of Sanctuary"
  SMARTBUFF_GBOSAN                = GetSpellInfo(25899); --"Greater Blessing of Sanctuary"
  SMARTBUFF_BOL                   = GetSpellInfo(19977); --"Blessing of Light"
  SMARTBUFF_GBOL                  = GetSpellInfo(25890); --"Greater Blessing of Light"
  SMARTBUFF_BOF                   = GetSpellInfo(1044);  --"Blessing of Freedom"
  SMARTBUFF_BOP                   = GetSpellInfo(1022);  --"Blessing of Protection"
  SMARTBUFF_SOCOMMAND             = GetSpellInfo(20375); --"Seal of Command"
  SMARTBUFF_SOJUSTICE             = GetSpellInfo(20164); --"Seal of Justice"
  SMARTBUFF_SOLIGHT               = GetSpellInfo(20165); --"Seal of Light"
  SMARTBUFF_SORIGHTEOUSNESS       = GetSpellInfo(20184); --"Seal of Righteousness"
  SMARTBUFF_SOWISDOM              = GetSpellInfo(20166); --"Seal of Wisdom"
  SMARTBUFF_SOTCRUSADER           = GetSpellInfo(21082); --"Seal of the Crusader"
  SMARTBUFF_SOVENGEANCE           = GetSpellInfo(31801); --"Seal of Vengeance"
  SMARTBUFF_SOBLOOD               = GetSpellInfo(31892); --"Seal of Blood"
  SMARTBUFF_DEVOTIONAURA          = GetSpellInfo(465);   --"Devotion Aura"
  SMARTBUFF_RETRIBUTIONAURA       = GetSpellInfo(7294);  --"Retribution Aura"
  SMARTBUFF_CONCENTRATIONAURA     = GetSpellInfo(19746); --"Concentration Aura"
  SMARTBUFF_SHADOWRESISTANCEAURA  = GetSpellInfo(19876); --"Shadow Resistance Aura"
  SMARTBUFF_FROSTRESISTANCEAURA   = GetSpellInfo(19888); --"Frost Resistance Aura"
  SMARTBUFF_FIRERESISTANCEAURA    = GetSpellInfo(19891); --"Fire Resistance Aura"
  SMARTBUFF_SANCTITYAURA          = GetSpellInfo(20218); --"Sanctity Aura"
  SMARTBUFF_CRUSADERAURA          = GetSpellInfo(32223); --"Crusader Aura"
  
  -- Death Knight
  --SMARTBUFF_ = GetSpellInfo(xxx); --"xxx"
  SMARTBUFF_ROCINDERGLACIER   = GetSpellInfo(53341); --"Rune of Cinderglacier"
  SMARTBUFF_ROFROSTFEVER      = GetSpellInfo(53343); --"Rune of Frostfever"
  SMARTBUFF_ROLICHBANE        = GetSpellInfo(53331); --"Rune of Lichbane"
  SMARTBUFF_ROSPELLSHATTERING = GetSpellInfo(53342); --"Rune of Spellshattering"
  SMARTBUFF_ROSWORDSHATTERING = GetSpellInfo(53323); --"Rune of Swordshattering"
  SMARTBUFF_ROFALLENCRUSADER  = GetSpellInfo(53344); --"Rune of the Fallen Crusader"
  SMARTBUFF_FROZENRUNEWEAPON  = GetSpellInfo(50406); --"Frozen Rune Weapon"
  SMARTBUFF_BLOODPRESENCE     = GetSpellInfo(48266); --"Blood Presence"
  SMARTBUFF_FROSTPRESENCE     = GetSpellInfo(48263); --"Frost Presence"
  SMARTBUFF_UNHOLYPRESENCE    = GetSpellInfo(48265); --"Unholy Presence"
  
  
  -- Tracking
  SMARTBUFF_FINDMINERALS    = GetSpellInfo(2580);  --"Find Minerals"
  SMARTBUFF_FINDHERBS       = GetSpellInfo(2383);  --"Find Herbs"
  SMARTBUFF_FINDTREASURE    = GetSpellInfo(2481);  --"Find Treasure"
  SMARTBUFF_TRACKHUMANOIDS  = GetSpellInfo(19883); --"Track Humanoids"
  SMARTBUFF_TRACKBEASTS     = GetSpellInfo(1494);  --"Track Beasts"
  SMARTBUFF_TRACKUNDEAD     = GetSpellInfo(19884); --"Track Undead"
  SMARTBUFF_TRACKHIDDEN     = GetSpellInfo(19885); --"Track Hidden"
  SMARTBUFF_TRACKELEMENTALS = GetSpellInfo(19880); --"Track Elementals"
  SMARTBUFF_TRACKDEMONS     = GetSpellInfo(19878); --"Track Demons"
  SMARTBUFF_TRACKGIANTS     = GetSpellInfo(19882); --"Track Giants"
  SMARTBUFF_TRACKDRAGONKIN  = GetSpellInfo(19879); --"Track Dragonkin"
  SMARTBUFF_SENSEDEMONS     = GetSpellInfo(5500);  --"Sense Demons"
  SMARTBUFF_SENSEUNDEAD     = GetSpellInfo(5502);  --"Sense Undead"

  -- Racial
  SMARTBUFF_STONEFORM       = GetSpellInfo(20594); --"Stoneform"
  SMARTBUFF_PRECEPTION      = GetSpellInfo(20600); --"Perception"
  SMARTBUFF_BLOODFURY       = GetSpellInfo(20572); --"Blood Fury" 33697, 33702
  SMARTBUFF_BERSERKING      = GetSpellInfo(20554); --"Berserking" 26296, 26297
  SMARTBUFF_WOTFORSAKEN     = GetSpellInfo(7744);  --"Will of the Forsaken"
  
  -- Food
  SMARTBUFF_FOOD_AURA       = GetSpellInfo(46899); --"Well Fed"
  SMARTBUFF_FOOD_SPELL      = GetSpellInfo(433);   --"Food"
  SMARTBUFF_DRINK_SPELL     = GetSpellInfo(430);   --"Drink"
  
  
  -- Misc
  SMARTBUFF_KIRUSSOV        = GetSpellInfo(46302); --"K'iru's Song of Victory"
  
  
  --if (SMARTBUFF_GOTW) then
  --  SMARTBUFF_AddMsgD(SMARTBUFF_GOTW.." found");
  --end  
  
  --SMARTBUFF_AddMsgD("Spell IDs initialized");
end


function SMARTBUFF_InitSpellList()
  if (SMARTBUFF_PLAYERCLASS == nil) then return; end
  SMARTBUFF_PATTERNS = nil;
  
  --if (SMARTBUFF_GOTW) then
  --  SMARTBUFF_AddMsgD(SMARTBUFF_GOTW.." found");
  --end
  
  -- Druid
  if (SMARTBUFF_PLAYERCLASS == "DRUID") then
    SMARTBUFF_BUFFLIST = {
      {SMARTBUFF_MOTW, 30, SMARTBUFF_CONST_GROUP, {1,10,20,30,40,50,60,70}, "WPET", SMARTBUFF_GOTW, 60, {50,60,70}, {SMARTBUFF_WILDBERRIES,SMARTBUFF_WILDTHORNROOT,SMARTBUFF_WILDQUILLVINE}},
      {SMARTBUFF_THORNS, 10, SMARTBUFF_CONST_GROUP, {6,14,24,34,44,54,64}, "HUNTER;ROGUE;MAGE;PRIEST;PALADIN;WARLOCK;WPET;" .. SMARTBUFF_DRUID_MOONKIN},
      {SMARTBUFF_OMENOFCLARITY, 30, SMARTBUFF_CONST_SELF, nil, SMARTBUFF_DRUID_MOONKIN},
      {SMARTBUFF_BARKSKIN, 0.25, SMARTBUFF_CONST_SELF, nil, SMARTBUFF_DRUID_MOONKIN},
      {SMARTBUFF_NATURESGRASP, 0.75, SMARTBUFF_CONST_FORCESELF},
      {SMARTBUFF_TIGERSFURY, 0.1, SMARTBUFF_CONST_SELF, nil, SMARTBUFF_DRUID_CAT}
    };
  end
  
  -- Priest
  if (SMARTBUFF_PLAYERCLASS == "PRIEST") then
    SMARTBUFF_BUFFLIST = {
      {SMARTBUFF_PWF, 30, SMARTBUFF_CONST_GROUP, {1,12,24,36,48,60,70}, "WPET", SMARTBUFF_POF, 60, {48,60,70}, {SMARTBUFF_HOLYCANDLE,SMARTBUFF_SACREDCANDLE,SMARTBUFF_SACREDCANDLE}},
      {SMARTBUFF_SP, 10, SMARTBUFF_CONST_GROUP, {30,42,56,68}, "WPET", SMARTBUFF_POSP, 20, {56,70}, {SMARTBUFF_SACREDCANDLE,SMARTBUFF_SACREDCANDLE}},
      {SMARTBUFF_INNERFIRE, 10, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_DS, 30, SMARTBUFF_CONST_GROUP, {40,42,54,60,70}, "ROGUE;WARRIOR;HPET;WPET", SMARTBUFF_POS, 60, {60,70}, {SMARTBUFF_SACREDCANDLE,SMARTBUFF_SACREDCANDLE}},
      {SMARTBUFF_PWS, 0.5, SMARTBUFF_CONST_GROUP, {6,12,18,24,30,36,42,48,54,60,65,70}, "MAGE;WARLOCK;ROGUE;PALADIN;WARRIOR;DRUID;HUNTER;SHAMAN;HPET;WPET"},
      {SMARTBUFF_FEARWARD, 10, SMARTBUFF_CONST_GROUP, {20}},
      {SMARTBUFF_ELUNESGRACE, 0.25, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_FEEDBACK, 0.25, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_SHADOWGUARD, 10, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_TOUCHOFWEAKNESS, 10, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_INNERFOCUS, -1, SMARTBUFF_CONST_SELF}
    };
  end
  
  -- Mage
  if (SMARTBUFF_PLAYERCLASS == "MAGE") then
    SMARTBUFF_BUFFLIST = {
      {SMARTBUFF_AI, 30, SMARTBUFF_CONST_GROUP, {1,14,28,42,56,70}, "ROGUE;WARRIOR;HPET;WPET", SMARTBUFF_AB, 60, {56,70}, {SMARTBUFF_ARCANEPOWDER,SMARTBUFF_ARCANEPOWDER}},
      {SMARTBUFF_ICEARMOR, 30, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_FROSTARMOR, 30, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_MAGEARMOR, 30, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_MOLTENARMOR, 30, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_DAMPENMAGIC, 10, SMARTBUFF_CONST_GROUP, {12,24,36,48,60,67}, "HPET;WPET"},
      {SMARTBUFF_AMPLIFYMAGIC, 10, SMARTBUFF_CONST_GROUP, {18,30,42,54,63,69}, "HPET;WPET"},
      {SMARTBUFF_MANASHIELD, 1, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_FIREWARD, 0.5, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_FROSTWARD, 0.5, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_ICEBARRIER, 1, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_COMBUSTION, -1, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_ICYVEINS, 0.33, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_ARCANEPOWER, 0.25, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_PRESENCEOFMIND, 0.165, SMARTBUFF_CONST_SELF}
    };
    SMARTBUFF_PATTERNS = SMARTBUFF_MAGE_PATTERN;
  end
  
  -- Warlock
  if (SMARTBUFF_PLAYERCLASS == "WARLOCK") then
    SMARTBUFF_BUFFLIST = {
      {SMARTBUFF_FELARMOR, 30, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_DEMONARMOR, 30, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_DEMONSKIN, 30, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_SOULLINK, 0, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_DINVISIBILITY, 10, SMARTBUFF_CONST_GROUP, {26}, "HPET;WPET"},
      {SMARTBUFF_UNENDINGBREATH, 10, SMARTBUFF_CONST_GROUP, {16}, "HPET;WPET"},
      {SMARTBUFF_SHADOWWARD, 0.5, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_DARKPACT, 0.5, SMARTBUFF_CONST_SELF}
    };
    SMARTBUFF_PATTERNS = SMARTBUFF_WARLOCK_PATTERN;
  end

  -- Hunter
  if (SMARTBUFF_PLAYERCLASS == "HUNTER") then
    SMARTBUFF_BUFFLIST = {
      {SMARTBUFF_TRUESHOTAURA, -1, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_RAPIDFIRE, 0.2, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_AOTH, -1, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_AOTM, -1, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_AOTV, -1, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_AOTW, -1, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_AOTB, -1, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_AOTC, -1, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_AOTP, -1, SMARTBUFF_CONST_SELF}
    };
    SMARTBUFF_PATTERNS = SMARTBUFF_HUNTER_PATTERN;
  end

  -- Shaman
  if (SMARTBUFF_PLAYERCLASS == "SHAMAN") then
    SMARTBUFF_BUFFLIST = {
      {SMARTBUFF_LIGHTNINGSHIELD, 10, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_WATERSHIELD, 10, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_EARTHSHIELD, 10, SMARTBUFF_CONST_GROUP, {50,60,70}, "WARRIOR;DRUID;SHAMAN;HUNTER;ROGUE;MAGE;PRIEST;PALADIN;WARLOCK;HPET;WPET"},
      {SMARTBUFF_WINDFURYW, 30, SMARTBUFF_CONST_WEAPON},
      {SMARTBUFF_FLAMETONGUEW, 30, SMARTBUFF_CONST_WEAPON},
      {SMARTBUFF_FROSTBRANDW, 30, SMARTBUFF_CONST_WEAPON},
      {SMARTBUFF_ROCKBITERW, 30, SMARTBUFF_CONST_WEAPON},
      {SMARTBUFF_WATERBREATHING, 10, SMARTBUFF_CONST_GROUP, {22}}
    };
    SMARTBUFF_PATTERNS = SMARTBUFF_SHAMAN_PATTERN;
  end

  -- Warrior
  if (SMARTBUFF_PLAYERCLASS == "WARRIOR") then
    SMARTBUFF_BUFFLIST = {
      {SMARTBUFF_BATTLESHOUT, 2, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_COMMANDINGSHOUT, 2, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_BERSERKERRAGE, 0.165, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_BLOODRAGE, 0.165, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_RAMPAGE, 0.5, SMARTBUFF_CONST_SELF}
    };
    SMARTBUFF_PATTERNS = SMARTBUFF_PALADIN_PATTERN;
  end
  
  -- Rogue
  if (SMARTBUFF_PLAYERCLASS == "ROGUE") then
    SMARTBUFF_BUFFLIST = {
      {SMARTBUFF_BLADEFLURRY, 0.165, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_SAD, 0.2, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_EVASION, 0.2, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_INSTANTPOISON7, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_INSTANTPOISON6, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_INSTANTPOISON5, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_INSTANTPOISON4, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_INSTANTPOISON3, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_INSTANTPOISON2, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_INSTANTPOISON1, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_WOUNDPOISON5, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_WOUNDPOISON4, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_WOUNDPOISON3, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_WOUNDPOISON2, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_WOUNDPOISON1, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_MINDPOISON3, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_MINDPOISON2, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_MINDPOISON1, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_DEADLYPOISON7, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_DEADLYPOISON6, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_DEADLYPOISON5, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_DEADLYPOISON4, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_DEADLYPOISON3, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_DEADLYPOISON2, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_DEADLYPOISON1, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_CRIPPLINGPOISON2, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_CRIPPLINGPOISON1, 30, SMARTBUFF_CONST_INV},
      {SMARTBUFF_ANESTHETICPOISON1, 30, SMARTBUFF_CONST_INV}
    };
  end

  -- Paladin
  if (SMARTBUFF_PLAYERCLASS == "PALADIN") then
    SMARTBUFF_BUFFLIST = {
      {SMARTBUFF_RIGHTEOUSFURY, 30, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_HOLYSHIELD, 0.165, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_BOM, 10, SMARTBUFF_CONST_GROUP, {4,12,22,32,42,52,60,70}, "DRUID;MAGE;PRIEST;SHAMAN;WARLOCK;WPET", SMARTBUFF_GBOM, 30, {52,60,70}, {SMARTBUFF_SYMBOLOFKINGS,SMARTBUFF_SYMBOLOFKINGS,SMARTBUFF_SYMBOLOFKINGS} },
      {SMARTBUFF_BOW, 10, SMARTBUFF_CONST_GROUP, {14,24,34,44,54,60,65}, "ROGUE;WARRIOR;HPET;WPET", SMARTBUFF_GBOW, 30, {54,60,65}, {SMARTBUFF_SYMBOLOFKINGS,SMARTBUFF_SYMBOLOFKINGS,SMARTBUFF_SYMBOLOFKINGS} },
      {SMARTBUFF_BOSAL, 10, SMARTBUFF_CONST_GROUP, {26}, "WARRIOR;HPET;WPET", SMARTBUFF_GBOSAL, 30, {60}, {SMARTBUFF_SYMBOLOFKINGS} },
      {SMARTBUFF_BOK, 10, SMARTBUFF_CONST_GROUP, {20}, "WPET", SMARTBUFF_GBOK, 30, {60}, {SMARTBUFF_SYMBOLOFKINGS} },
      {SMARTBUFF_BOSAN, 10, SMARTBUFF_CONST_GROUP, {30,40,50,60,70}, "DRUID;HUNTER;MAGE;PRIEST;ROGUE;SHAMAN;WARLOCK;HPET;WPET", SMARTBUFF_GBOSAN, 30, {60,70}, {SMARTBUFF_SYMBOLOFKINGS,SMARTBUFF_SYMBOLOFKINGS} },
      {SMARTBUFF_BOL, 10, SMARTBUFF_CONST_GROUP, {40,50,60,69}, "WPET", SMARTBUFF_GBOL, 30, {60,69}, {SMARTBUFF_SYMBOLOFKINGS,SMARTBUFF_SYMBOLOFKINGS} },
      --{SMARTBUFF_BOF, 0.165, SMARTBUFF_CONST_GROUP, {18}},
      --{SMARTBUFF_BOP, 1, SMARTBUFF_CONST_GROUP, {10,24,38}},
      {SMARTBUFF_SOCOMMAND, 0.5, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_SOFURY, 0.5, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_SOJUSTICE, 0.5, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_SOLIGHT, 0.5, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_SORIGHTEOUSNESS, 0.5, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_SOWISDOM, 0.5, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_SOTCRUSADER, 0.5, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_SOVENGEANCE, 0.5, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_SOBLOOD, 0.5, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_DEVOTIONAURA, -1, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_RETRIBUTIONAURA, -1, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_CONCENTRATIONAURA, -1, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_SHADOWRESISTANCEAURA, -1, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_FROSTRESISTANCEAURA, -1, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_FIRERESISTANCEAURA, -1, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_SANCTITYAURA, -1, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_CRUSADERAURA, -1, SMARTBUFF_CONST_SELF}
    };
    SMARTBUFF_PATTERNS = SMARTBUFF_PALADIN_PATTERN;
  end
  
  -- Deathknight
  if (SMARTBUFF_PLAYERCLASS == "DEATHKNIGHT") then
    SMARTBUFF_BUFFLIST = {
      --SMARTBUFF_ROCINDERGLACIER
      --SMARTBUFF_ROFROSTFEVER
      --SMARTBUFF_ROLICHBANE
      --SMARTBUFF_ROSPELLSHATTERING
      --SMARTBUFF_ROSWORDSHATTERING
      --SMARTBUFF_ROFALLENCRUSADER
      {SMARTBUFF_FROZENRUNEWEAPON, 10, SMARTBUFF_CONST_WEAPON},
      {SMARTBUFF_BLOODPRESENCE, -1, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_FROSTPRESENCE, -1, SMARTBUFF_CONST_SELF},
      {SMARTBUFF_UNHOLYPRESENCE, -1, SMARTBUFF_CONST_SELF}
    };
    SMARTBUFF_PATTERNS = SMARTBUFF_DEATHKNIGHT_PATTERN;
  end

  -- Stones and oils
  SMARTBUFF_WEAPON = {
    {SMARTBUFF_SSROUGH, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_SSCOARSE, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_SSHEAVY, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_SSSOLID, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_SSDENSE, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_SSELEMENTAL, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_SSFEL, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_SSADAMANTITE, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_WSROUGH, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_WSCOARSE, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_WSHEAVY, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_WSSOLID, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_WSDENSE, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_WSFEL, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_WSADAMANTITE, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_SHADOWOIL, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_FROSTOIL, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_MANAOILMINOR, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_MANAOILLESSER, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_MANAOILBRILLIANT, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_MANAOILSUPERIOR, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_WIZARDOILMINOR, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_WIZARDOILLESSER, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_WIZARDOIL, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_WIZARDOILBRILLIANT, 60, SMARTBUFF_CONST_INV},
    {SMARTBUFF_WIZARDOILSUPERIOR, 60, SMARTBUFF_CONST_INV}
  };

  -- Tracking
  SMARTBUFF_TRACKING = {
    {SMARTBUFF_FINDMINERALS, -1, SMARTBUFF_CONST_TRACK},
    {SMARTBUFF_FINDHERBS, -1, SMARTBUFF_CONST_TRACK},
    {SMARTBUFF_FINDTREASURE, -1, SMARTBUFF_CONST_TRACK},
    {SMARTBUFF_TRACKHUMANOIDS, -1, SMARTBUFF_CONST_TRACK},
    {SMARTBUFF_TRACKBEASTS, -1, SMARTBUFF_CONST_TRACK},
    {SMARTBUFF_TRACKUNDEAD, -1, SMARTBUFF_CONST_TRACK},
    {SMARTBUFF_TRACKHIDDEN, -1, SMARTBUFF_CONST_TRACK},
    {SMARTBUFF_TRACKELEMENTALS, -1, SMARTBUFF_CONST_TRACK},
    {SMARTBUFF_TRACKDEMONS, -1, SMARTBUFF_CONST_TRACK},
    {SMARTBUFF_TRACKGIANTS, -1, SMARTBUFF_CONST_TRACK},
    {SMARTBUFF_TRACKDRAGONKIN, -1, SMARTBUFF_CONST_TRACK},
    {SMARTBUFF_SENSEDEMONS, -1, SMARTBUFF_CONST_TRACK},
    {SMARTBUFF_SENSEUNDEAD, -1, SMARTBUFF_CONST_TRACK}
  };

  -- Racial
  SMARTBUFF_RACIAL = {
    {SMARTBUFF_STONEFORM, 0.133, SMARTBUFF_CONST_SELF}, -- Dwarv
    {SMARTBUFF_PRECEPTION, 0.333, SMARTBUFF_CONST_SELF}, -- Human
    {SMARTBUFF_BLOODFURY, 0.416, SMARTBUFF_CONST_SELF}, -- Orc
    {SMARTBUFF_BERSERKING, 0.166, SMARTBUFF_CONST_SELF}, -- Troll
    {SMARTBUFF_WOTFORSAKEN, 0.083, SMARTBUFF_CONST_SELF} -- Undead
  };

  -- FOOD
  SMARTBUFF_FOOD = {
    {SMARTBUFF_SPICYCRAWDAD, 30, SMARTBUFF_CONST_FOOD},
    {SMARTBUFF_MOKNATHALSHORTRIBS, 30, SMARTBUFF_CONST_FOOD},
    {SMARTBUFF_CRUNCHYSERPENT, 30, SMARTBUFF_CONST_FOOD},
    {SMARTBUFF_GOLDENFISHSTICKS, 30, SMARTBUFF_CONST_FOOD},
    {SMARTBUFF_SPICYHOTTALBUK, 30, SMARTBUFF_CONST_FOOD},
    {SMARTBUFF_SKULLFISHSOUP, 30, SMARTBUFF_CONST_FOOD},    
    {SMARTBUFF_TALBUKSTEAK, 30, SMARTBUFF_CONST_FOOD},
    {SMARTBUFF_WARPBURGER, 30, SMARTBUFF_CONST_FOOD},
    {SMARTBUFF_ROASTEDCLEFTHOOF, 30, SMARTBUFF_CONST_FOOD},
    {SMARTBUFF_POACHEDBLUEFISH, 30, SMARTBUFF_CONST_FOOD},
    {SMARTBUFF_GRILLEDMUDFISH, 30, SMARTBUFF_CONST_FOOD},
    {SMARTBUFF_BLACKENEDBASILISK, 30, SMARTBUFF_CONST_FOOD},
    {SMARTBUFF_BLACKENEDSPOREFISH, 30, SMARTBUFF_CONST_FOOD},
    {SMARTBUFF_SPORELINGSNACK, 30, SMARTBUFF_CONST_FOOD},
    {SMARTBUFF_BROILEDBLOODFIN, 30, SMARTBUFF_CONST_FOOD},    
    {SMARTBUFF_CLAMBAR, 30, SMARTBUFF_CONST_FOOD},
    {SMARTBUFF_FELTAILDELIGHT, 30, SMARTBUFF_CONST_FOOD},
    {SMARTBUFF_RAVAGERDOG, 30, SMARTBUFF_CONST_FOOD},
    {SMARTBUFF_BUZZARDBITES, 30, SMARTBUFF_CONST_FOOD},
    {SMARTBUFF_SAGEFISHDELIGHT, 15, SMARTBUFF_CONST_FOOD}
  };  
  
  SMARTBUFF_AddMsgD("Spell list initialized");
end

