SlashList = {} or SlashList
local SlashList = SlashList

local pairs = pairs
local sfind = string.find
local tconcat = table.concat
local tinsert = table.insert
local tsort = table.sort
local tremove = table.remove
local pattern = "slash_"
local textdump

-- Credits to Endeavours_NotePad
local backdropTable =	{
	bgFile = "Interface/AchievementFrame/UI-Achievement-StatsBackground", edgeFile = "Interface/AchievementFrame/UI-Achievement-WoodBorder",
	tile = false, tileSize = 16, edgeSize = 32, insets = { left = 4, right = 4, top = 4, bottom = 4 }
						}

local function compressTable(t)
	for i = 1, #t do
		if t[i] == t[i + 1] then
			tremove(t, i)
		else
			i = i + 1
		end
	end
end

local function gatherData(input)
	local list = {}

	for key, value in pairs(_G) do
		key = key:lower()
		if type(value) == "string" then
			if sfind(key, pattern, 1) and not sfind(value, "Appropriate format", 1) and sfind(value, "/", 1) then
				value = value:lower()
				if not input or input == "" or sfind(key, input) or sfind(value, input) then
					tinsert(list, value)
				end
			end
		end
	end
	return list
end

SLASH_SlashList1 = "/slashlist"
SLASH_SlashList2 = "/cmdlist"
SLASH_SlashList3 = "/cmds"

SlashCmdList.SlashList = function (input, editBox)
	input = input:lower()
	list = gatherData(input)
	tsort(list)
	compressTable(list)
	textdump = tconcat(list, "\n")
	SlashList.DisplayText()
end

function SlashList.DisplayText()
	if not SlashListFrame then
		SlashListFrame = CreateFrame("Frame", "SlashListFrame", UIParent)
		tinsert(UISpecialFrames, "SlashListFrame")
		SlashListFrame:SetBackdrop(PaneBackdrop)
		SlashListFrame:SetBackdropColor(0, 0, 0, 1)
		SlashListFrame:SetWidth(200)
		SlashListFrame:SetHeight(500)
		SlashListFrame:SetPoint("CENTER", UIParent, "CENTER")
		SlashListFrame:SetFrameStrata("DIALOG")
		SlashListFrame:SetBackdrop(backdropTable)
		SlashListFrame:SetMovable(true)
		SlashListFrame:SetClampedToScreen(true)
		SlashListFrame:EnableMouse(true)
		SlashListFrame:RegisterForDrag("LeftButton")
		SlashListFrame:SetScript("OnDragStart", function() if arg1 == "LeftButton" then SlashListFrame:StartMoving() end end)
		SlashListFrame:SetScript("OnDragStop", function() SlashListFrame:StopMovingOrSizing() end)

		local header = SlashListFrame:CreateTexture(nil, "OVERLAY")
		header:SetTexture("Interface\\AchievementFrame\\UI-Achievement-Alert-Background.blp")
		header:SetWidth(300 * 0.7)
		header:SetHeight(88 * 0.7 )
		header:SetPoint("BOTTOM", SlashListFrame, "TOP", 0, -40)
		header:SetTexCoord(0, 0.605, 0, 0.703)

		local text = SlashListFrame:CreateFontString(nil, "OVERLAY")
		text:SetTextColor(1, 1, 0.3, 1)
		text:SetPoint("BOTTOM", header, 3, 25)
		text:SetFont("Fonts\\MORPHEUS.TTF", 14, "OUTLINE")
		text:SetText("Slash Commands")

		local scrollArea = CreateFrame("ScrollFrame", "SlashListScroll", SlashListFrame, "UIPanelScrollFrameTemplate")
		scrollArea:SetPoint("TOPLEFT", SlashListFrame, "TOPLEFT", 8, -30)
		scrollArea:SetPoint("BOTTOMRIGHT", SlashListFrame, "BOTTOMRIGHT", -30, 8)

		SlashListFrame.editBox = CreateFrame("EditBox", "SlashListEdit", SlashListFrame)
		SlashListFrame.editBox:SetMultiLine(true)
		SlashListFrame.editBox:SetMaxLetters(99999)
		SlashListFrame.editBox:EnableMouse(false)
		SlashListFrame.editBox:EnableKeyboard(false)
		SlashListFrame.editBox:SetAutoFocus(true)
		SlashListFrame.editBox:SetFontObject(ChatFontNormal)
		SlashListFrame.editBox:SetWidth(120)
		SlashListFrame.editBox:SetHeight(470)
		SlashListFrame.editBox:SetScript("OnEscapePressed", function() SlashListFrame:Hide() end)

		scrollArea:SetScrollChild(SlashListFrame.editBox)

		local close = CreateFrame("Button", nil, SlashListFrame, "UIPanelCloseButton")
		close:SetPoint("TOPRIGHT", SlashListFrame, "TOPRIGHT")
	end
	SlashListFrame.editBox:SetText(textdump)
	SlashListFrame:Show()
end
