-- @release $Id: SlamAndAwe.lua 51 2012-08-21 23:53:55Z reighnman $

if select(2, UnitClass('player')) ~= "WARRIOR" then
	DisableAddOn("SlamAndAwe")
	return
end

local L = LibStub("AceLocale-3.0"):GetLocale("SlamAndAwe")
local AceAddon = LibStub("AceAddon-3.0")
local media = LibStub:GetLibrary("LibSharedMedia-3.0")
SlamAndAwe = AceAddon:NewAddon("SlamAndAwe", "AceConsole-3.0", "AceEvent-3.0", "AceTimer-3.0")
local SCT = SCT
local REVISION = tonumber(("$Revision: 51 $"):match("%d+"))
local _, _, _, clientVersion = GetBuildInfo()
local queryDisable = false

SlamAndAwe.frames = {}

SlamAndAwe.BaseFrame = CreateFrame("Frame","SlamAndAweBase",UIParent)
SlamAndAwe.frames["DeathWish"] = CreateFrame("Frame","SAA_Bar1_Status",SlamAndAwe.BaseFrame)
SlamAndAwe.frames["DeathWish"].icon = CreateFrame("Frame","SAA_Bar1_StatusIcon",SlamAndAwe.BaseFrame)
SlamAndAwe.frames["Recklessness"] = CreateFrame("Frame","SAA_Bar2_Status",SlamAndAwe.BaseFrame)
SlamAndAwe.frames["Recklessness"].icon = CreateFrame("Frame","SAA_Bar2_StatusIcon",SlamAndAwe.BaseFrame)
SlamAndAwe.frames["ColossusSmash"] = CreateFrame("Frame","SAA_Bar3_Status",SlamAndAwe.BaseFrame)
SlamAndAwe.frames["ColossusSmash"].icon = CreateFrame("Frame","SAA_Bar3_StatusIcon",SlamAndAwe.BaseFrame)
SlamAndAwe.frames["DeadlyCalm"] = CreateFrame("Frame","SAA_Bar4_Status",SlamAndAwe.BaseFrame)
SlamAndAwe.frames["DeadlyCalm"].icon = CreateFrame("Frame","SAA_Bar4_StatusIcon",SlamAndAwe.BaseFrame)
SlamAndAwe.frames["Rage"] = CreateFrame("Frame","SAA_Bar5_Status",SlamAndAwe.BaseFrame)
SlamAndAwe.frames["GCD"] = CreateFrame("Frame", "SAA_Bar6_Status", SlamAndAwe.BaseFrame)
SlamAndAwe.msgFrame = CreateFrame("MessageFrame","SlamAndAweMsg",UIParent)
SlamAndAwe.questionFrame = CreateFrame("Frame","SlamAndAweQuestion",UIParent)

SlamAndAwe.textures = {}
SlamAndAwe.borders = {}
SlamAndAwe.fonts = {}
SlamAndAwe.sounds = {}
SlamAndAwe.barBackdrop = {
		bgFile = "Interface/Tooltips/UI-Tooltip-Background",
		edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		tile = false, tileSize = 0, edgeSize = 12,
		insets = { left = 2, right = 2, top = 2, bottom = 2 }
	}
SlamAndAwe.frameBackdrop ={
		bgFile = "Interface/Tooltips/UI-Tooltip-Background",
		--edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		tile = false, tileSize = 0, edgeSize = 12,
		insets = { left = 0, right = 0, top = 0, bottom = 0 }
	}
SlamAndAwe.GCDMin = 0
SlamAndAwe.GCDMax = 0
SlamAndAwe.GCDWidth = 0
	
local shearMin, ShearMax, GCDPercent
local updateActiveRage = true
local updateActiveGCD = true
local GCDTime = 0

--SlamAndAwe
local CSMin, CSMax, DWMin, DWMax, REMin, REMax, RageMin, RageMax
local updateActiveColossusSmash = false
local CSTime = 0
local updateActiveDeathWish = false
local DWTime = 0
local updateActiveRecklessness = false
local RETime = 0

-----------------------------------------
-- Initialisation & Startup Routines
-----------------------------------------

function SlamAndAwe:OnInitialize()
	local AceConfigReg = LibStub("AceConfigRegistry-3.0")
	local AceConfigDialog = LibStub("AceConfigDialog-3.0")
	self:SetConstants()
	self:SetBindings()
	self:SetDefaultOptions()
	
	SlamAndAwe.db = LibStub("AceDB-3.0"):New("SlamAndAweDBPC", SlamAndAwe.defaults, "char")
	self:SetPriorityTable()
	self:GetMSBTAreaDefaults()
	LibStub("AceConfig-3.0"):RegisterOptionsTable("SlamAndAwe", self:GetOptions(), {"slamandawe", "saa"} )
	media.RegisterCallback(self, "LibSharedMedia_Registered")
	
	-- Add the options to blizzard frame (add them backwards so they show up in the proper order
	self.optionsFrame = AceConfigDialog:AddToBlizOptions("SlamAndAwe", "SlamAndAwe")
	SlamAndAwe.db:RegisterDefaults(SlamAndAwe.defaults)
	if not SlamAndAwe.db.char.immuneTargets then
		SlamAndAwe.db.char.immuneTargets = {}
	end
	self:InitialiseUptime()
	self:InitialiseBindings()
	self:CreateUptimeFrame()
	self:CreatePriorityFrame()
	self:CreateMsgFrame()
	self:News()
	self:VerifyOptions()

	local version = GetAddOnMetadata("SlamAndAwe","Version")
	self.version = ("SlamAndAwe v%s (r%s)"):format(version, REVISION)
	self:Print(self.version.." Loaded.  This is an alpha release in testing.")
end

function SlamAndAwe:SetConstants()
	SlamAndAwe.constants = {}
	local C = SlamAndAwe.constants

	SlamAndAwe.constants["Purge"], _, SlamAndAwe.constants["Purge Icon"] = GetSpellInfo(6552) -- Probably not needed
	SlamAndAwe.constants["Flurry"], _, SlamAndAwe.constants["Flurry Icon"] = GetSpellInfo(16278) -- For uptime frame
	SlamAndAwe.constants["Enrage"], _, SlamAndAwe.constants["Enrage Icon"] = GetSpellInfo(13046) -- For uptime frame
	SlamAndAwe.constants["Colossus Smash"], _, SlamAndAwe.constants["Colossus Smash Icon"] = GetSpellInfo(86346)
	SlamAndAwe.constants["Bloodthirst"], _, SlamAndAwe.constants["Bloodthirst Icon"] = GetSpellInfo(23881)
	SlamAndAwe.constants["Raging Blow"], _, SlamAndAwe.constants["Raging Blow Icon"] = GetSpellInfo(85288)
	SlamAndAwe.constants["Berserker Rage"], _, SlamAndAwe.constants["Berserker Rage Icon"] = GetSpellInfo(18499)
	SlamAndAwe.constants["Death Wish"], _, SlamAndAwe.constants["Death Wish Icon"] = GetSpellInfo(12292)	
	SlamAndAwe.constants["Slam"], _, SlamAndAwe.constants["Slam Icon"] = GetSpellInfo(1464)
	SlamAndAwe.constants["Bloodsurge"], _, SlamAndAwe.constants["Bloodsurge Icon"] = GetSpellInfo(46915)
	SlamAndAwe.constants["Heroic Strike"], _, SlamAndAwe.constants["Heroic Strike Icon"] = GetSpellInfo(78)
	SlamAndAwe.constants["Battle Trance"], _, SlamAndAwe.constants["Battle Trance Icon"] = GetSpellInfo(12964)
	SlamAndAwe.constants["Demoralizing Shout"], _, SlamAndAwe.constants["Demoralizing Shout Icon"] = GetSpellInfo(1160)
	SlamAndAwe.constants["Shattering Throw"], _, SlamAndAwe.constants["Shattering Throw Icon"] = GetSpellInfo(64382)
	SlamAndAwe.constants["Incite"], _, SlamAndAwe.constants["Incite Icon"] = GetSpellInfo(50687)
	SlamAndAwe.constants["Execute"], _, SlamAndAwe.constants["Execute Icon"] = GetSpellInfo(5308)
	SlamAndAwe.constants["Battle Shout"], _, SlamAndAwe.constants["Battle Shout Icon"] = GetSpellInfo(6673)
	SlamAndAwe.constants["Recklessness"], _, SlamAndAwe.constants["Recklessness Icon"] = GetSpellInfo(1719)
	SlamAndAwe.constants["Executioner"], _, SlamAndAwe.constants["Executioner Icon"] = GetSpellInfo(90806)
	SlamAndAwe.constants["Deadly Calm"], _, SlamAndAwe.constants["Deadly Calm Icon"] = GetSpellInfo(85730)   
    
end

function SlamAndAwe:OnDisable()
    -- Called when the addon is disabled
	self:UnregisterEvent("PLAYER_ENTERING_WORLD")
	self:UnregisterEvent("PLAYER_LOGIN")
	self:UnregisterEvent("PLAYER_ALIVE")
	self:UnregisterEvent("UNIT_SPELLCAST_SUCCEEDED")
	self:UnregisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	self:UnregisterEvent("CHARACTER_POINTS_CHANGED")
	self:UnregisterEvent("PLAYER_REGEN_DISABLED")
	self:UnregisterEvent("PLAYER_REGEN_ENABLED")
	self:UnregisterEvent("SPELL_UPDATE_COOLDOWN")
	self:UnregisterEvent("UPDATE_BINDINGS")
	self:UnregisterEvent("UI_ERROR_MESSAGE")
	self:UnregisterEvent("UNIT_POWER")
--	we must still look out for talent changes to fire change of spec to re-enable
--	self:UnregisterEvent("PLAYER_TALENT_UPDATE")
--	self:UnregisterEvent("ACTIVE_TALENT_GROUP_CHANGED")
	self:UnregisterEvent("UNIT_EXITED_VEHICLE")
	self:UnregisterEvent("UNIT_ENTERED_VEHICLE")
end

function SlamAndAwe:OnEnable()
	self:LibSharedMedia_Registered()
	self:RegisterEvent("PLAYER_ENTERING_WORLD")
	self:RegisterEvent("PLAYER_LOGIN")
	self:RegisterEvent("PLAYER_ALIVE")
	self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	self:RegisterEvent("CHARACTER_POINTS_CHANGED")
	self:RegisterEvent("PLAYER_REGEN_DISABLED")
	self:RegisterEvent("PLAYER_REGEN_ENABLED")
	self:RegisterEvent("SPELL_UPDATE_COOLDOWN")
	self:RegisterEvent("UPDATE_BINDINGS")
	self:RegisterEvent("UI_ERROR_MESSAGE")
	self:RegisterEvent("UNIT_POWER")
	self:RegisterEvent("PLAYER_TALENT_UPDATE")
	self:RegisterEvent("ACTIVE_TALENT_GROUP_CHANGED")
	self:RegisterEvent("UNIT_ENTERED_VEHICLE")
	self:RegisterEvent("UNIT_EXITED_VEHICLE")
end

function SlamAndAwe:LibSharedMedia_Registered()
	media:Register("sound", "SAA Maelstrom 1", "Sound\\Spells\\ShootWandLaunchLightning.wav")
	media:Register("sound", "SAA Maelstrom 2", "Sound\\Spells\\DynamiteExplode.wav")
	media:Register("sound", "SAA Maelstrom 3", "Sound\\Spells\\ArmorKitBuffSound.wav")
	media:Register("sound", "SAA Maelstrom 4", "Sound\\Spells\\Fizzle\\FizzleShadowA.wav")
	media:Register("sound", "SAA Maelstrom 5", "Sound\\Spells\\LevelUp.wav")
	media:Register("sound", "SAA Maelstrom 6", "Sound\\Spells\\Tradeskills\\FishBite.wav")
	media:Register("sound", "SAA Maelstrom 7", "Sound\\Spells\\Tradeskills\\MiningHitA.wav")
	media:Register("sound", "SAA Maelstrom 8", "Sound\\Spells\\AspectofTheSnake.wav")
	media:Register("sound", "SAA Maelstrom 9", "Sound\\Spells\\bind2_Impact_Base.wav")
	media:Register("sound", "SAA Shield 1", "Sound\\Doodad\\BellowIn.wav")
	media:Register("sound", "SAA Shield 2", "Sound\\Doodad\\BellowOut.wav")
	media:Register("sound", "SAA Shield 3", "Sound\\Doodad\\PVP_Lordaeron_Door_Open.wav")
	media:Register("sound", "SAA Shield 4", "Sound\\Spells\\ShaysBell.wav")

	for k, v in pairs(media:List("statusbar")) do
		self.textures[v] = v
	end
	for k, v in pairs(media:List("border")) do
		self.borders[v] = v
	end
	for k, v in pairs(media:List("font")) do
		self.fonts[v] = v
	end
	for k, v in pairs(media:List("sound")) do
		self.sounds[v] = v
	end
end

----------------------
-- Event Routines
----------------------

	
function SlamAndAwe:UNIT_ENTERED_VEHICLE()
	if UnitInVehicle("player") then
		self:TidyUpAfterCombat() -- on entering vehicle treat as if out of combat ie: disable incombat displays
	end
end

function SlamAndAwe:UNIT_EXITED_VEHICLE()
	if not UnitInVehicle("player") and InCombatLockdown() then
		self:EnteredCombat()  -- if in combat when exit vehichle enable SlamAndAwe combat effects
	end
end

function SlamAndAwe:PLAYER_ENTERING_WORLD()
	self:SetBorderTexture(nil, SlamAndAwe.db.char.border)
	self:SetBarBorderTexture(nil, SlamAndAwe.db.char.barborder)
	self:SetTalentEffects()
	self:RedrawFrames()
	self:UpdateBindings()
	SlamAndAwe.db.char.priority.prOption = SlamAndAwe.db.char.priority.prOptions[SlamAndAwe.db.char.priority.groupnumber]
end

function SlamAndAwe:PLAYER_LOGIN()
	self:SetBorderTexture(nil, SlamAndAwe.db.char.border)
	self:SetBarBorderTexture(nil, SlamAndAwe.db.char.barborder)
	queryDisable = false -- when player first logs in set test for talents in Enh Spec to false
	self:RageBar()
end

function SlamAndAwe:PLAYER_ALIVE()
	self:SetTalentEffects()
	self:RedrawFrames()
	self:UpdateBindings()
	self:RageBar()
	if not queryDisable then -- only ask if not in Enh and addon active if this is fired immediately after first login
		self:QueryDisableAddon()
		queryDisable = true
	end
end

function SlamAndAwe:UI_ERROR_MESSAGE(_, ...)
	if SlamAndAwe.db.char.warning.range then
		local arg1 = select(1,...) or ""
		if strfind(arg1, L["Out of range"]) or strfind(arg1, L["too far away"]) then
			self:PrintMsg(arg1, SlamAndAwe.db.char.warning.colour, 0.5)
		end
	end
end

function SlamAndAwe:UNIT_POWER()
   self:RageBar()
end

function SlamAndAwe:COMBAT_LOG_EVENT_UNFILTERED(_, timestamp, event, hideCaster, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, ...)
	if sourceGUID == UnitGUID("player") then
		local spellID = select(1,...) or 0
		if SlamAndAwe.db.char.warning.interrupt and event == "SPELL_INTERRUPT" then
			local spellName = select(5,...)
			if spellName then
				self:PrintMsg(L["Interrupted: "] .. spellName, SlamAndAwe.db.char.warning.colour, SlamAndAwe.db.char.warning.duration)
			end
		end
	end
end

function SlamAndAwe:SPELL_UPDATE_COOLDOWN()
	if SlamAndAwe.db.char.gcdshow then
		self:GCDBar()
	end
end

function SlamAndAwe:UNIT_SPELLCAST_SUCCEEDED(_, ...)
	local arg1 = select(1,...) or ""
	local arg2 = select(2,...) or ""
	if arg1 == "player" then -- skip if someone else casting
		if SlamAndAwe.db.char.csshow then
			if arg2 == SlamAndAwe.constants["Colossus Smash"] then
				self:ColossusSmashBar()
			end
		end
	  if SlamAndAwe.db.char.dwshow then
			if arg2 == SlamAndAwe.constants["Death Wish"] then
				self:DeathWishBar()
			end
		end
		if SlamAndAwe.db.char.reshow then
			if arg2 == SlamAndAwe.constants["Recklessness"] then
				self:RecklessnessBar()
			end
		end
		if SlamAndAwe.db.char.reshow then
			if arg2 == SlamAndAwe.constants["Deadly Calm"] then
				self:DeadlyCalmBar()
			end
		end
	end
end

function SlamAndAwe:CHARACTER_POINTS_CHANGED()
	self:SetTalentEffects()
	self:CreateBaseFrame()
end

function SlamAndAwe:PLAYER_REGEN_DISABLED() -- Entering Combat
	self:EnteredCombat()
end

function SlamAndAwe:PLAYER_REGEN_ENABLED() -- Leaving Combat
	self:TidyUpAfterCombat()
end

function SlamAndAwe:UPDATE_BINDINGS()
	if not InCombatLockdown() then
		self:UpdateBindings()
	end
end

function SlamAndAwe:PLAYER_TALENT_UPDATE()
	self:SetTalentEffects()
	self:RedrawFrames()
end

function SlamAndAwe:ACTIVE_TALENT_GROUP_CHANGED()
	self:QuerySpecChanged()
end

----------------------------
-- Combat start and stop
----------------------------

function SlamAndAwe:EnteredCombat()
	if UnitInVehicle("player") then -- don't enable priorities & bars if we enter combat in a vehicle
		return
	end
	if SlamAndAwe.db.char.disablebars then
		self.BaseFrame:Show()
	end
	if SlamAndAwe.db.char.uptime.show then
		if not self.uptime.incombat then
			self.uptime.incombat = true
			-- reset last fight data on entering combat
			self:InitialiseUptimeBuffs(self.uptime.lastfight)
			self.uptime.currentTime = GetTime()
			self:UpdateUptime()
			self:UpdateUptimeFrames(true)
			self.uptime.TimerEvent = self:ScheduleRepeatingTimer("UpdateUptime", 0.1, nil);
		end
	end
	if SlamAndAwe.db.char.priority.show and not SlamAndAwe.db.char.disabled then
		SlamAndAwe.db.char.priority.next = "none"
		self:SetPriorityIcon(SlamAndAwe.db.char.priority.next)
		self.updatePriority = true
		self.PriorityFrame:Show()
	end
end

function SlamAndAwe:TidyUpAfterCombat()
	self.frames["DeathWish"].icon:Hide()
	self.frames["ColossusSmash"].icon:Hide()
	self.frames["Recklessness"].icon:Hide()
	self.frames["DeadlyCalm"].icon:Hide()
		
	self:SetPriorityIcon("none")
	self.updatePriority = false
	self.PriorityFrame:Hide()
	if SlamAndAwe.db.char.uptime.show then
		if self.uptime.incombat then
			self:UpdateUptime()
			self.uptime.incombat = false
			self:UpdateUptimeFrames(true)
			self:CancelTimer(self.uptime.TimerEvent , false)
		end
	end
	if SlamAndAwe.db.char.disablebars then
		self.BaseFrame:Hide()
	end
	if not SlamAndAwe.db.char.binding.macroset then
		-- call update Bindings to set macro keys if we were in combat when addon initialised
		self:UpdateBindings()
	end
end

----------------------------
-- Question box handler
----------------------------

function SlamAndAwe:QuerySpecChanged()
	if SlamAndAwe.db.char.specchangewarning then
		if SlamAndAwe.db.char.maelstromTalents == 0 and not SlamAndAwe.db.char.disabled then
			-- addon is enabled but we have changed to a non Fury Spec ask if we should disable addon
			self:DisplayQuestionFrame(false, true)
		elseif SlamAndAwe.db.char.maelstromTalents > 0 and SlamAndAwe.db.char.disabled then
			-- addon is disabled and we have changed to an Fury Spec ask if we should enable addon
			self:DisplayQuestionFrame(true, true)
		end
	end
end

function SlamAndAwe:QueryDisableAddon()
	if SlamAndAwe.db.char.maelstromTalents == 0 then -- check MW talents again to counter Player_Entering_World bug
		self:SetTalentEffects()
	end
	if UnitLevel("player") >= 60 then -- don't bother asking to disable addon if player under level 60.
		if SlamAndAwe.db.char.maelstromTalents == 0 and not SlamAndAwe.db.char.disabled then
			-- addon is enabled but we have changed to a non Enhance Spec ask if we should disable addon
			self:DisplayQuestionFrame(false, false)
		elseif SlamAndAwe.db.char.maelstromTalents > 0 and SlamAndAwe.db.char.disabled then
			-- addon is disabled and we have changed to an Enhance Spec ask if we should enable addon
			self:DisplayQuestionFrame(true, false)
		end
	end
end

StaticPopupDialogs["SAA_QUESTION_FRAME"] = {
	text = L["You have changed to a new talent spec do you want to enable SlamAndAwe?"],
	button1 = "Yes",
	button2 = "No",
	OnAccept = function()
		SlamAndAwe:EnableDisable()
	end,
	timeout = 0,
	hideOnEscape = 1,
}

function SlamAndAwe:DisplayQuestionFrame(enable, spec)
	if spec then
		if enable then 
			StaticPopupDialogs["SAA_QUESTION_FRAME"].text = L["You have changed to a new talent spec do you want to enable SlamAndAwe?"]
		else
			StaticPopupDialogs["SAA_QUESTION_FRAME"].text = L["You have changed to a new talent spec do you want to disable SlamAndAwe?"]
		end
	else
		if enable then 
			StaticPopupDialogs["SAA_QUESTION_FRAME"].text = L["You are in Fury spec, do you want to enable SlamAndAwe?"]
		else
			StaticPopupDialogs["SAA_QUESTION_FRAME"].text = L["You are NOT in Fury spec, do you want to disable SlamAndAwe?"]
		end
	end
	self:DebugPrint("entered DisplayQuestionFrame, text is :"..StaticPopupDialogs["SAA_QUESTION_FRAME"].text)
	StaticPopup_Show("SAA_QUESTION_FRAME")
end
	
---------------------------
-- Buff Info functions
---------------------------

-- function SlamAndAwe:GetMaelstromInfo()
-- 	local index = 1
-- 	while UnitBuff("PLAYER", index) do
-- 		local name, _, _, count, _, _, maelstromTime = UnitBuff("PLAYER", index)
-- 		if name == SlamAndAwe.constants["Maelstrom Weapon"] then
-- 			return count, maelstromTime
-- 		end
-- 		index = index + 1
-- 	end
-- 	return 0, 0 
-- end

---------------------------
-- functions
---------------------------

function SlamAndAwe:RedrawFrames()
	self:CreateBaseFrame()
	self:CreateUptimeFrame()
end

function SlamAndAwe:SetTalentEffects()
	local currRank, maxRank
	_, _, _, _, currRank, maxRank = GetTalentInfo(2,17)
	SlamAndAwe.db.char.maelstromTalents = currRank
	_, _, _, _, currRank, maxRank = GetTalentInfo(1,6) 
	local reverberation = currRank
	if SlamAndAwe.db.char.maelstromTalents == 0 then
		updateActiveMaelstrom = false
	end

--	_, _, _, _, currRank, maxRank = GetTalentInfo(2,19)
--	if currRank == 0 then
--		SlamAndAwe.db.char.feralSpiritTalented = false
--	else
--		SlamAndAwe.db.char.feralSpiritTalented = true
--	end

--SlamAndAwe

  SlamAndAwe.db.char.CSLen = 6
  SlamAndAwe.db.char.CSPercent = 1
  SlamAndAwe.db.char.DWLen = 30
  SlamAndAwe.db.char.DWPercent = 1
  SlamAndAwe.db.char.RELen = 12
  SlamAndAwe.db.char.REPercent = 1
  SlamAndAwe.db.char.DCLen = 10
  SlamAndAwe.db.char.DCPercent = 1
  
	if SlamAndAwe.db.char.gcdfullwidth then
		GCDPercent = 1
	else
		GCDPercent = 1.5 / SlamAndAwe.db.char.maxLen
	end
end

function SlamAndAwe:DisplayVersion()
	self:Print(self.version)
end

function SlamAndAwe:CreateBaseFrame()
	if not SlamAndAwe.db.char.SSPercent or not SlamAndAwe.db.char.WFProcPercent or not SlamAndAwe.db.char.ShockPercent or not SlamAndAwe.db.char.ShearPercent or not SlamAndAwe.db.char.CSPercent or not SlamAndAwe.db.char.FNPercent or not GCDPercent then
		self:SetTalentEffects()
	end
	self.BaseFrame:SetScale(SlamAndAwe.db.char.scale)
	self.BaseFrame:SetFrameStrata("BACKGROUND")
	self.BaseFrame:SetWidth(SlamAndAwe.db.char.fWidth + SlamAndAwe.db.char.fHeight / 7)
	self.BaseFrame:SetHeight(SlamAndAwe.db.char.fHeight)
	self.BaseFrame:SetBackdrop(self.frameBackdrop)
	self.BaseFrame:SetBackdropColor(1, 1, 1, 0)
	self.BaseFrame:SetMovable(true)
	self.BaseFrame:RegisterForDrag("LeftButton")
	self.BaseFrame:SetPoint(SlamAndAwe.db.char.point, SlamAndAwe.db.char.relativeTo, SlamAndAwe.db.char.relativePoint, SlamAndAwe.db.char.xOffset, SlamAndAwe.db.char.yOffset)
	self.BaseFrame:SetScript("OnDragStart", 
		function()
			self.BaseFrame:StartMoving();
		end );
	self.BaseFrame:SetScript("OnDragStop",
		function()
			self.BaseFrame:StopMovingOrSizing();
			self.BaseFrame:SetScript("OnUpdate", nil);
			self:FinishedMoving(SlamAndAwe.db.char, self.BaseFrame);
		end );
	self.BaseFrame:Show()
	SlamAndAwe.db.char.movingframes = false
	
	local barHeight = SlamAndAwe.db.char.fHeight / 7
	local baseOffset = (-1 * barHeight) + 3
	local barCount = 0

	SlamAndAwe:SetBarFrame(self.frames["GCD"], 
					SlamAndAwe.db.char.fWidth * GCDPercent, barHeight,
					barCount * baseOffset, 1,
					0, 1.5, 
					6, 1, 
					.6, .6, .6, .6,
					false)
	self.GCDWidth = self.frames["GCD"].statusbar:GetWidth() -- to account for spark width
	if SlamAndAwe.db.char.gcdshow then
		barCount = barCount + 1 -- we will use gcd frame 
	end

	SlamAndAwe:SetBarFrame(self.frames["Rage"], 
					SlamAndAwe.db.char.fWidth * SlamAndAwe.db.char.REPercent, barHeight, 
					barCount * baseOffset, 1,
					0, 100, 
					6, 1, 
					1, 0, 0, .9,
					false)
	if SlamAndAwe.db.char.rageshow then
		barCount = barCount + 1 -- we will use Rage frame 
	end
	
	colours = SlamAndAwe.db.char.colours.colossussmash
	SlamAndAwe:SetBarFrame(self.frames["ColossusSmash"], 
					SlamAndAwe.db.char.fWidth * SlamAndAwe.db.char.CSPercent, barHeight, 
					barCount * baseOffset, 1,
					0, SlamAndAwe.db.char.CSLen, 
					10, 1, 
					colours.r, colours.g, colours.b, colours.a,
					true)
	if SlamAndAwe.db.char.csshow then
		barCount = barCount + 1 -- we will use ColossusSmash frame 
	end
	self:SetBarIcon(self.frames["ColossusSmash"].icon, 86346)
		
	colours = SlamAndAwe.db.char.colours.recklessness
	SlamAndAwe:SetBarFrame(self.frames["Recklessness"], 
					SlamAndAwe.db.char.fWidth * SlamAndAwe.db.char.REPercent, barHeight, 
					barCount * baseOffset, 1,
					0, SlamAndAwe.db.char.RELen, 
					10, 1, 
					colours.r, colours.g, colours.b, colours.a,
					true)
	if SlamAndAwe.db.char.reshow then
		barCount = barCount + 1 -- we will use Recklessness frame 
	end
	self:SetBarIcon(self.frames["Recklessness"].icon, 1719)
			
	colours = SlamAndAwe.db.char.colours.deathwish
	SlamAndAwe:SetBarFrame(self.frames["DeathWish"], 
					SlamAndAwe.db.char.fWidth * SlamAndAwe.db.char.DWPercent, barHeight, 
					barCount * baseOffset, 1,
					0, SlamAndAwe.db.char.DWLen, 
					10, 1, 
					colours.r, colours.g, colours.b, colours.a,
					true)
	if SlamAndAwe.db.char.dwshow then
		barCount = barCount + 1 -- we will use DeathWish frame 
	end
	self:SetBarIcon(self.frames["DeathWish"].icon, 12292)

	colours = SlamAndAwe.db.char.colours.deathwish
	SlamAndAwe:SetBarFrame(self.frames["DeadlyCalm"], 
					SlamAndAwe.db.char.fWidth * SlamAndAwe.db.char.DCPercent, barHeight, 
					barCount * baseOffset, 1,
					0, SlamAndAwe.db.char.DCLen, 
					10, 1, 
					colours.r, colours.g, colours.b, colours.a,
					true)
	if SlamAndAwe.db.char.dwshow then
		barCount = barCount + 1 -- we will use DeadlyCalm frame 
	end
	self:SetBarIcon(self.frames["DeadlyCalm"].icon, 85730)
end

function SlamAndAwe:SetBarFrame(frameName, barWidth, barHeight, frameOffset, frameLevel, minValue, maxValue, frameValue, frameSpark, frameR, frameG, frameB, frameAlpha, icon)
	frameName:SetFrameStrata("LOW")
	frameName:SetWidth(barWidth)
	frameName:SetHeight(barHeight)
	frameName:ClearAllPoints()
	frameName:SetPoint("TOPLEFT", self.BaseFrame, "TOPLEFT", barHeight, frameOffset)
	frameName:SetBackdrop(self.barBackdrop);
	frameName:SetBackdropColor(0, 0, 0, .2);
	frameName:SetBackdropBorderColor( 1, 1, 1, 1);
	frameName:EnableMouse(false)
	if not frameName.statusbar then
		frameName.statusbar = CreateFrame("StatusBar", nil, frameName)
	end
	frameName.statusbar:SetFrameLevel(frameLevel)
	frameName.statusbar:ClearAllPoints()
	frameName.statusbar:SetHeight(barHeight - 6)
	frameName.statusbar:SetWidth(barWidth - 6)
	frameName.statusbar:SetPoint("TOPLEFT", frameName, "TOPLEFT", 3, -3)
	frameName.statusbar:SetStatusBarTexture(media:Fetch("statusbar", SlamAndAwe.db.char.texture))
	frameName.statusbar:GetStatusBarTexture():SetHorizTile(true) -- fix for textures stretching rather than revealing
	frameName.statusbar:SetStatusBarColor(frameR, frameG, frameB, frameAlpha)
	frameName.statusbar:SetMinMaxValues(minValue,maxValue)
	frameName.statusbar:SetValue(frameValue)
	
	if not frameName.spark then
		frameName.spark = frameName.statusbar:CreateTexture(nil, "OVERLAY")
	end
	frameName.spark:SetTexture("Interface\\CastingBar\\UI-CastingBar-Spark")
	frameName.spark:SetWidth(16)
	frameName.spark:SetHeight(barHeight + 16)
	frameName.spark:SetBlendMode("ADD")
	frameName.spark:SetPoint("CENTER",frameName.statusbar,"BOTTOMLEFT",(barWidth - 6)* frameSpark, -1)
	frameName.spark:Show()
	
	if not frameName.text then
		frameName.text = frameName:CreateFontString(nil,"OVERLAY")
	end
	local barfont = media:Fetch("font", SlamAndAwe.db.char.barfont)
	frameName.text:SetFont(barfont, SlamAndAwe.db.char.barfontsize, SlamAndAwe.db.char.barfonteffect)
	frameName.text:ClearAllPoints()
	frameName.text:SetTextColor(1, 1, 1, 1)
	frameName.text:SetPoint("CENTER", frameName, "CENTER");
	frameName.text:SetText("")

	frameName:SetScript("OnUpdate", 
		function()
			SlamAndAwe:OnBarUpdate();
		end );
	if icon then
		frameName.icon:SetWidth(barHeight - 3) -- same as height to get square box
		frameName.icon:SetHeight(barHeight - 3)
		frameName.icon:SetPoint("TOPRIGHT", frameName, "TOPLEFT", 0 , -2)
		frameName.icon:Hide()
	end	
	frameName:Hide()
end

function SlamAndAwe:SetBarIcon(iconFrame, spellID)
	local _, _, icon = GetSpellInfo(spellID)
	iconFrame:SetBackdrop({
		bgFile = icon,
		--edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		tile = false, tileSize = 0, edgeSize = 12,
		insets = { left = 0, right = 0, top = 0, bottom = 0 } })
end

function SlamAndAwe:ResetBars()
	self.BaseFrame:ClearAllPoints()
	SlamAndAwe.db.char.point = self.defaults.char.point
	SlamAndAwe.db.char.relativeTo = self.defaults.char.relativeTo 
	SlamAndAwe.db.char.relativePoint = self.defaults.char.relativePoint
	SlamAndAwe.db.char.xOffset = self.defaults.char.xOffset
	SlamAndAwe.db.char.yOffset = self.defaults.char.yOffset
	SlamAndAwe.db.char.fWidth = self.defaults.char.fWidth
	SlamAndAwe.db.char.fHeight = self.defaults.char.fHeight
	SlamAndAwe.db.char.scale = self.defaults.char.scale
	SlamAndAwe.db.char.barfont = self.defaults.char.barfont
	SlamAndAwe.db.char.barfontsize = self.defaults.char.barfontsize
	SlamAndAwe.db.char.bartexture = self.defaults.char.bartexture
	SlamAndAwe.db.char.texture = self.defaults.char.texture
	self.BaseFrame:SetPoint(SlamAndAwe.db.char.point, SlamAndAwe.db.char.relativeTo, SlamAndAwe.db.char.relativePoint, SlamAndAwe.db.char.xOffset, SlamAndAwe.db.char.yOffset)
	SlamAndAwe:SetTalentEffects()
	self:RedrawFrames()
	SlamAndAwe.db.char.movingframes = true -- so that call to ShowHideBars resets to false
	self:ShowHideBars()
	self:Print(L["config_reset"])
end

function SlamAndAwe:DebugTalents()
	local numTabs = GetNumTalentTabs();
	for t=1, numTabs do
		DEFAULT_CHAT_FRAME:AddMessage(GetTalentTabInfo(t)..":");
		local numTalents = GetNumTalents(t);
		for i=1, numTalents do
			nameTalent, icon, tier, column, currRank, maxRank= GetTalentInfo(t,i);
			DEFAULT_CHAT_FRAME:AddMessage("- "..i..":"..nameTalent..": "..currRank.."/"..maxRank);
		end
	end
end

function SlamAndAwe:DebugFrameValues()
	self:Print("CSLen : "..SlamAndAwe.db.char.CSLen)
	self:Print("CSPercent : "..SlamAndAwe.db.char.CSPercent)
	self:Print("DWLen : "..SlamAndAwe.db.char.DWLen)
	self:Print("DWPercent : "..SlamAndAwe.db.char.DWPercent)
end

function SlamAndAwe:GCDBar()
	local startTime, duration, enabled = GetSpellCooldown(SlamAndAwe.constants["Demoralizing Shout"]) -- Lightning Shield chosen because it has no other cooldown and all shammys will have it
	duration = duration or 0 -- force nil to 0 if for some bizzare reason no LS available.
	if duration > 0 then 
		self.frames["GCD"]:Show()
		updateActiveGCD = true
		GCDTime = startTime + duration
		self.GCDMax = duration
	end
end

function SlamAndAwe:RageBar()
	RageMin, RageMax = self.frames["Rage"].statusbar:GetMinMaxValues()
	self.frames["Rage"]:Show()
	updateActiveRage = true
end

function SlamAndAwe:ColossusSmashBar()
	local colours = SlamAndAwe.db.char.colours.colossussmash
	self.frames["ColossusSmash"].statusbar:SetStatusBarColor(colours.r, colours.g, colours.b, colours.a)
	self.frames["ColossusSmash"]:Show()
	updateActiveColossusSmash = true
	CSTime = GetTime() + SlamAndAwe.db.char.CSLen
	CSMin, CSMax = self.frames["ColossusSmash"].statusbar:GetMinMaxValues()
	if SlamAndAwe.db.char.showicons then
		self.frames["ColossusSmash"].icon:Show()
	else
		self.frames["ColossusSmash"].icon:Hide()
	end
end

function SlamAndAwe:DeathWishBar()
	local colours = SlamAndAwe.db.char.colours.deathwish
	self.frames["DeathWish"].statusbar:SetStatusBarColor(colours.r, colours.g, colours.b, colours.a)
	self.frames["DeathWish"]:Show()
	updateActiveDeathWish = true
	DWTime = GetTime() + SlamAndAwe.db.char.DWLen
	DWMin, DWMax = self.frames["DeathWish"].statusbar:GetMinMaxValues()
	if SlamAndAwe.db.char.showicons then
		self.frames["DeathWish"].icon:Show()
	else
		self.frames["DeathWish"].icon:Hide()
	end
end

function SlamAndAwe:RecklessnessBar()
	local colours = SlamAndAwe.db.char.colours.recklessness
	self.frames["Recklessness"].statusbar:SetStatusBarColor(colours.r, colours.g, colours.b, colours.a)
	self.frames["Recklessness"]:Show()
	updateActiveRecklessness = true
	RETime = GetTime() + SlamAndAwe.db.char.RELen
	REMin, REMax = self.frames["Recklessness"].statusbar:GetMinMaxValues()
	if SlamAndAwe.db.char.showicons then
		self.frames["Recklessness"].icon:Show()
	else
		self.frames["Recklessness"].icon:Hide()
	end
end

function SlamAndAwe:DeadlyCalmBar()
	local colours = SlamAndAwe.db.char.colours.recklessness
	self.frames["DeadlyCalm"].statusbar:SetStatusBarColor(colours.r, colours.g, colours.b, colours.a)
	self.frames["DeadlyCalm"]:Show()
	updateActiveDeadlyCalm = true
	DCTime = GetTime() + SlamAndAwe.db.char.DCLen
	DCMin, DCMax = self.frames["DeadlyCalm"].statusbar:GetMinMaxValues()
	if SlamAndAwe.db.char.showicons then
		self.frames["DeadlyCalm"].icon:Show()
	else
		self.frames["DeadlyCalm"].icon:Hide()
	end
end

function SlamAndAwe:DebugDebuffInfo()
	local index = 1
	while UnitDebuff("target", index) do
		local name, _, _, count, _, _, debuffExpires, unitCaster = UnitDebuff("target", index)
		local isMine = unitCaster == "player" 
		local expires = debuffExpires-GetTime()
		if isMine then
			self:DebugPrint("Debuff :"..name.." expires:"..expires)
		end
		index = index + 1
	end
end


function SlamAndAwe:DurationString(duration)
    local string = (("%1.1f"):format(duration % 60)) .. "s";
    
    if (duration >= 60) then
        duration = floor(duration - (duration % 60)) / 60; -- minutes
        
        string = (duration % 60) .."m " .. string;
        
        if (duration >= 60) then
            duration = (duration - (duration % 60)) / 60; -- hours
            string = duration .. "h " .. string;
        end
    end
    return string
end

function SlamAndAwe:CheckPurgeableBuff()
	if SlamAndAwe.db.char.hsshow then
     local avail = SlamAndAwe:SpellAvailable(SlamAndAwe.constants["Heroic Strike"])
     local usable, nomana = IsUsableSpell(SlamAndAwe.constants["Heroic Strike"])
     local buff1 = SlamAndAwe:GetBuffInfo(SlamAndAwe.constants["Battle Trance"])
     local buff2 = SlamAndAwe:GetBuffInfo(SlamAndAwe.constants["Incite"])    		
     local rage = UnitPower("player", "rage")
		local hsrage = SlamAndAwe.db.char.rageThreshold
		
		if buff1 or buff2 then
      if usable and avail then
        return true
      end     
    elseif rage >= hsrage then
        if usable and avail then
						return true
        end
		end
	end
	return false
end

local OBU = {}

function SlamAndAwe:OnBarUpdate()
	if SlamAndAwe.db.char.disabled then
		return
	end
	
	OBU.width = SlamAndAwe.db.char.fWidth - 6
	OBU.timeLeft = 0

	if updateActiveGCD then
		OBU.timeLeft = GCDTime - GetTime()
		self.frames["GCD"].statusbar:SetValue(OBU.timeLeft)
		OBU.sparkpoint = OBU.timeLeft / 1.5 * self.GCDWidth
		if OBU.sparkpoint > self.GCDWidth then
			OBU.sparkpoint = self.GCDWidth
		end
		self.frames["GCD"].spark:SetPoint("CENTER",self.frames["GCD"].statusbar,"LEFT", OBU.sparkpoint,-1)
		if GCDTime < GetTime() then
			self.frames["GCD"]:Hide()
			updateActiveGCD = false
		end
	end
	
	if updateActiveRage then
		local crage = UnitPower("player", "rage")
		self.frames["Rage"].statusbar:SetValue(crage)
		self.frames["Rage"].spark:SetPoint("CENTER",self.frames["Rage"].statusbar,"LEFT", crage/100 * OBU.width * SlamAndAwe.db.char.REPercent ,-1)
	
		self.frames["Rage"].text:SetText(UnitPower('player'))
		self.frames["Rage"].text:SetPoint("CENTER",self.frames["Rage"].statusbar,"LEFT",10,-1)
	end	
	
	if updateActiveColossusSmash then
		OBU.timeLeft = CSTime - GetTime()
		self.frames["ColossusSmash"].statusbar:SetValue(OBU.timeLeft)
		self.frames["ColossusSmash"].spark:SetPoint("CENTER",self.frames["ColossusSmash"].statusbar,"LEFT", OBU.timeLeft/CSMax * OBU.width * SlamAndAwe.db.char.CSPercent ,-1)
		if CSTime < GetTime() then
			self.frames["ColossusSmash"]:Hide()
			self.frames["ColossusSmash"].icon:Hide()
			updateActiveColossusSmash = false
		end
	end

	
	if updateActiveRecklessness then
		OBU.timeLeft = RETime - GetTime()
		self.frames["Recklessness"].statusbar:SetValue(OBU.timeLeft)
		self.frames["Recklessness"].spark:SetPoint("CENTER",self.frames["Recklessness"].statusbar,"LEFT", OBU.timeLeft/REMax * OBU.width * SlamAndAwe.db.char.REPercent ,-1)
		if RETime < GetTime() then
			self.frames["Recklessness"]:Hide()
			self.frames["Recklessness"].icon:Hide()
			updateActiveRecklessness = false
		end
	end

	if updateActiveDeathWish then
		OBU.timeLeft = DWTime - GetTime()
		self.frames["DeathWish"].statusbar:SetValue(OBU.timeLeft)
		self.frames["DeathWish"].spark:SetPoint("CENTER",self.frames["DeathWish"].statusbar,"LEFT", OBU.timeLeft/DWMax * OBU.width * SlamAndAwe.db.char.DWPercent ,-1)
		if DWTime < GetTime() then
			self.frames["DeathWish"]:Hide()
			self.frames["DeathWish"].icon:Hide()
			updateActiveDeathWish = false
		end
	end
	
	if updateActiveDeadlyCalm then
		OBU.timeLeft = DCTime - GetTime()
		self.frames["DeadlyCalm"].statusbar:SetValue(OBU.timeLeft)
		self.frames["DeadlyCalm"].spark:SetPoint("CENTER",self.frames["DeadlyCalm"].statusbar,"LEFT", OBU.timeLeft/DCMax * OBU.width * SlamAndAwe.db.char.DCPercent ,-1)
		if DCTime < GetTime() then
			self.frames["DeadlyCalm"]:Hide()
			self.frames["DeadlyCalm"].icon:Hide()
			updateActiveDeadlyCalm = false
		end
	end
	
	if SlamAndAwe.db.char.priority.show and not SlamAndAwe.db.char.disabled then
		if SlamAndAwe.db.char.priority.showinterrupt and self.PriorityFrame.interrupt then
			OBU.EnemySpell, _, _, OBU.EnemySpellIcon = UnitCastingInfo("target")
			if not OBU.EnemySpell then
				OBU.EnemySpellIcon = "Interface/Tooltips/UI-Tooltip-Background"
			end
			local nStance = GetShapeshiftForm();
			if self:SpellAvailable(SlamAndAwe.constants["Purge"]) and nStance ~= 2 then
				self:SetSubFrameBackdrop(self.PriorityFrame.interrupt.frame, OBU.EnemySpellIcon, 4)
				self.PriorityFrame.interrupt.frame:SetBackdropBorderColor(1, 1, 1, 1);
			else
				self:SetSubFrameBackdrop(self.PriorityFrame.interrupt.frame, OBU.EnemySpellIcon, 20)
				self.PriorityFrame.interrupt.frame:SetBackdropBorderColor(1, 0, 0, 1); -- set border colour to Red if Purge not available
			end
			if not OBU.EnemySpell then
				self.PriorityFrame.interrupt.frame:SetBackdropColor(0, 0, 0, 0);
			end
		end
	end
end

function SlamAndAwe:CreateMsgFrame()
	self.msgFrame:ClearAllPoints()
	self.msgFrame:SetWidth(400)
	self.msgFrame:SetHeight(75)
	self.msgFrame:SetFrameStrata("BACKGROUND")
	self.msgFrame:SetBackdrop({
		bgFile = "Interface/Tooltips/UI-Tooltip-Background",
		--edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
		tile = false, tileSize = 0, edgeSize = 12,
		insets = { left = 2, right = 2, top = 2, bottom = 2 }
	})
	self.msgFrame:SetBackdropColor(1, 1, 1, 0)
	self.msgFrame:SetMovable(true)
	self.msgFrame:RegisterForDrag("LeftButton")
	self.msgFrame:SetScript("OnDragStart", 
		function()
			self.msgFrame:StartMoving();
		end );
	self.msgFrame:SetScript("OnDragStop",
		function()
			self.msgFrame:StopMovingOrSizing();
			self.msgFrame:SetScript("OnUpdate", nil);
			self:FinishedMoving(SlamAndAwe.db.char.warning, self.msgFrame);
		end );
	self.msgFrame:SetPoint(SlamAndAwe.db.char.warning.point, SlamAndAwe.db.char.warning.relativeTo, SlamAndAwe.db.char.warning.relativePoint, SlamAndAwe.db.char.warning.xOffset, SlamAndAwe.db.char.warning.yOffset)
	self.msgFrame:SetInsertMode("TOP")
	self.msgFrame:SetFrameStrata("HIGH")
	self.msgFrame:SetToplevel(true)
	local font = media:Fetch("font", SlamAndAwe.db.char.msgfont)
	self.msgFrame:SetFont(font, SlamAndAwe.db.char.msgfontsize, SlamAndAwe.db.char.msgfonteffect)
		
	self.msgFrame:Show()
end

function SlamAndAwe:PrintMsg(msg, col, time)
	if SlamAndAwe.db.char.warning.show and not SlamAndAwe.db.char.disabled then
		if col == nil then
			col = { r=1, b=1, g=1, a=1 }
		end
		if time == nil then 
			time = 3
		end
		if time ~= 5 then
			self.msgFrame:SetTimeVisible(time)
		end
		self.msgFrame:AddMessage(msg, col.r, col.g, col.b, 1, col.time)
	end
end

function SlamAndAwe:DebugPrint(msg)
	if SlamAndAwe.db.char.debug then
		self:Print(msg)
	end
end