-- Author      : Skylar State
-- Last Updated : 9/21/2014 04:42 AM

local SkyUI = SkyUI
local SkyBaseClass = SkyBaseClass
local evt = CreateFrame("Frame") -- Event Catcher Frame


local SkyUnitFrame = SkyUI_CreateClass(SkyBaseClass)


SkyUnitFrame.prototype.F = nil -- Frame

SkyUnitFrame.prototype.RT = 0 -- RelativeTo Position
SkyUnitFrame.prototype.X = 0
SkyUnitFrame.prototype.Y = 0
SkyUnitFrame.prototype.W = 0
SkyUnitFrame.prototype.H = 0

SkyUnitFrame.prototype.Unit = nil
SkyUnitFrame.prototype.GUID = nil
SkyUnitFrame.prototype.Health = 0
SkyUnitFrame.prototype.Power = 0
SkyUnitFrame.prototype.TargetGUID = nil
SkyUnitFrame.prototype.TexturesReversed = nil

SkyUnitFrame.prototype.Spec = nil
SkyUnitFrame.prototype.TS = nil
SkyUnitFrame.prototype.tO = {X = 0, Y = 0}
SkyUnitFrame.prototype.Txt = nil

SkyUnitFrame.prototype.IsCasting = false
SkyUnitFrame.prototype.CastIsChanneled = false
SkyUnitFrame.prototype.CastEnd = nil
SkyUnitFrame.prototype.CastDuration = nil
SkyUnitFrame.prototype.Spell = nil

SkyUnitFrame.prototype.IncomingHeals = 0

SkyUnitFrame.prototype.AuraBars = {}

local UpdateInterval = 0.1
SkyUnitFrame.prototype.TimeSinceLastUpdate = 0
SkyUnitFrame.prototype.cd_i = 0


function SkyUnitFrame.prototype:init(unit)
 SkyUI[unit] = self;

	local frameSpec
	if unit == "player" then frameSpec = SkyUI.Specs.UnitFrames.Frames.Player
	elseif unit == "target" then frameSpec = SkyUI.Specs.UnitFrames.Frames.Target end
 self.Name = unit
	self.RT = frameSpec.RT
	self.X = frameSpec.X
	self.Y = frameSpec.Y
	self.W = frameSpec.W
	self.H = frameSpec.H
	self.T = SkyUI.Specs.UnitFrames.Unit.Textures
	self.Txt = SkyUI.Specs.UnitFrames.Unit.Text

	self.TS = SkyUI.Specs.UnitFrames.TextureSheet
	if SkyUI.Specs.UnitFrames.TextureOffset then self.tO = SkyUI.Specs.UnitFrames.TextureOffset end
	
 self.Unit = unit

	self.TargetGUID = UnitGUID(self.Unit .. "target")

 self:CreateFrame()
	
	if unit == "target" then self.TexturesReversed = true end
 self:AddTextures()
	
	
	self.F.Clickable = CreateFrame("Button", self.BaseName .. self.Unit .. "Clickable", self.F, "SecureUnitButtonTemplate")

	self.F.Clickable:EnableMouse(true)
	self.F.Clickable:RegisterForClicks("AnyUp")
	self.F.Clickable:SetAttribute("type1", "target")
	self.F.Clickable:SetAttribute("type2", "menu")
	self.F.Clickable:SetAttribute("unit", self.Unit)
	self.F.Clickable:SetAllPoints(self.F)
	if self.Unit == "player" then self.F.Clickable.menu = function(self) ToggleDropDownMenu(1, 1, PlayerFrameDropDown, self, 0 ,0) end
	elseif self.Unit == "target" then self.F.Clickable.menu = function(self) ToggleDropDownMenu(1, 1, _G[TargetFrame:GetName().."DropDown"], self, 0 ,0) end end
 self.F.Clickable:SetScript("OnEnter", self.OnEnter)
 self.F.Clickable:SetScript("OnLeave", self.OnLeave)


	self.F.CastBar:Hide()
	self.F.Cast:Hide()
	self.F.CastIconOverlay:Hide()
	
 if self.Txt then self:AddText() end -- Add any frame text/labels if provided
 self:UpdateUnitName()
--	self.F.UnitName:SetText(UnitName(self.Unit))
--	self:UpdateUnitName(self.Unit)
--	self.F.UnitName:SetAlpha(0)
--	self.F.CDSpannerL:SetAlpha(1)
--	self.F.CDSpannerS:SetAlpha(1)
--	self.F.CDSpannerR:SetAlpha(1)
-- self.F.UnitLevel:SetText(UnitLevel(unit))

 self.F.Portrait = self.F:CreateTexture(self.BaseName .. self.Unit .. "Portrait", "ARTWORK")
 self.F.Portrait:SetWidth(39)
 self.F.Portrait:SetHeight(39)
 if self.TexturesReversed then
	 self.F.Portrait:SetPoint("TOPRIGHT", self.F, -5, -4)
	 self.F.Portrait:SetTexCoord(1, 0, 1, 1, 0, 0, 0, 1)
	else self.F.Portrait:SetPoint("TOPLEFT", self.F, 5, -4) end
	self.F.Portrait:SetDrawLayer("OVERLAY", 7)
 self.F.Portrait:Show()
-- 	self.F.Portrait:SetTexCoord(0.10, 0.90, 0.10, 0.90)
 SetPortraitTexture(self.F.Portrait, self.Unit)


 self.F.ClassIcon = self.F:CreateTexture(self.BaseName .. self.Unit .. "ClassIcon", "OVERLAY")
	self.F.ClassIcon:SetSize(24, 24)
	self.F.ClassIcon:SetTexture("Interface\\TargetingFrame\\UI-Classes-Circles")
 if self.TexturesReversed then
	 self.F.ClassIcon:SetPoint("TOPRIGHT", self.F, -43, -22)
	else self.F.ClassIcon:SetPoint("TOPLEFT", self.F, 43, -22) end

 self:CreateAuraTextures()
 self:AuraUpdates()
 
	self:UpdateVertBar(self.F.IncomingHealth, 1, UnitHealthMax(self.Unit), self.T.IncomingHealth)



 self.F:SetScript("OnUpdate", self.Update)

end

function SkyUnitFrame.prototype:OnEnter(motion)
--	self:GetParent().UnitName:SetAlpha(1)
--	self:GetParent().CDSpannerL:SetAlpha(1)
--	self:GetParent().CDSpannerS:SetAlpha(1)
--	self:GetParent().CDSpannerR:SetAlpha(1)
end
function SkyUnitFrame.prototype:OnLeave(motion)
--	self:GetParent().UnitName:SetAlpha(0)
--	self:GetParent().UnitName:SetAlpha(0)
--	self:GetParent().CDSpannerL:SetAlpha(0)
--	self:GetParent().CDSpannerS:SetAlpha(0)
--	self:GetParent().CDSpannerR:SetAlpha(0)
end

--/run local m,f=GetMouseFocus(),CnB or CreateFrame("Button","CnB",nil,"SecureActionButtonTemplate") f:SetAttribute("type","cancelaura") f:SetAttribute("unit","player") f:SetAttribute("spell",m and m._buff and m._buff.name)
--/click CnB

local function updateTooltip(self)
	if( GameTooltip:IsOwned(self) ) then
		GameTooltip:SetUnitAura(self.TT.Unit, self.TT.Index, self.TT.Filter)
	end
end

local function showTooltip(self)
	GameTooltip:SetOwner(self, "ANCHOR_BOTTOMLEFT")
	GameTooltip:SetUnitAura(self.TT.Unit, self.TT.Index, self.TT.Filter)
	self:SetScript("OnUpdate", updateTooltip)
end

local function hideTooltip(self)
	self:SetScript("OnUpdate", nil)
	GameTooltip:Hide()
end


function SkyUnitFrame.prototype:CreateAuraFrame(n, i, t)

 local f = CreateFrame("Frame", self.BaseName .. self.Unit .. n .. "Frame" .. i, self.F)
	f:EnableMouse(true)
	
	if self.TexturesReversed then t.RT = "TOPRIGHT"
	else t.RT = "TOPLEFT" end

	if self.TexturesReversed then f:SetPoint(t.RT, -t.X - self.tO.X, t.Y + self.tO.Y)
	else f:SetPoint("TOPLEFT", t.X + self.tO.X, t.Y + self.tO.Y) end
	f:SetSize(t.W, t.H)
	f:SetFrameLevel(5)
		
	local a = f:CreateTexture()
	a:SetAllPoints(f)
--	a:SetTexture(1, 0, 0, 1)
	a:SetTexCoord(0.1, 0.9, 0.1, 0.9)
	f.texture = a
	
	f:SetScript("OnEnter", showTooltip)
 f:SetScript("OnLeave", hideTooltip)
		
	f.TT = nil
 f:Hide()
	
	self.F[n .. "Frame" .. i] = f
end

function SkyUnitFrame.prototype:CreateAuraTextures()
 local a, ad, b, d, bb, db, t = self.T.AuraBuff, self.T.AuraDebuff, self.T.Buff, self.T.Debuff, self.T.BuffBar, self.T.DebuffBar, {}
	
--	for i = 0, 12, 1 do
--	 local ii = i + 1
--  t["AuraBG" .. ii] = { X = 39 - 20 * (i % 2) - 20 * (math.floor(i / 2)), Y = -90.5 + 20 * (math.floor(i / 2)), tX = 182, tY = 374, W = 21, H = 21, L = "BACKGROUND" }
--	end

 for i=1, 8 do
	 local ii = i - 1
  t["BuffBar" .. i] = { X = bb.X, Y = bb.Y + ii * 17, tX = bb.tX, tY = bb.tY, W = bb.W, H = bb.H, L = bb.L }
  t["BuffLife" .. i] = { X = b.X, Y = b.Y + ii * 17, tX = b.tX, tY = b.tY, W = b.W, H = b.H, L = b.L }
		self:CreateAuraFrame("Buff", i, { X = a.X + 1, Y = a.Y + 17 + ii * 17 - 1, tX = a.tX, tY = a.tY, W = a.W - 2, H = a.H - 2, L = "OVERLAY", Clr = SkyUI.Clr.Transparent })
--  t["BuffIcon" .. i] = 

  t["DebuffBar" .. i] = { X = db.X, Y = db.Y - ii * 17, tX = db.tX, tY = db.tY, W = db.W, H = db.H, L = db.L }
  t["DebuffLife" .. i] = { X = d.X, Y = d.Y - ii * 17, tX = d.tX, tY = d.tY, W = d.W, H = d.H, L = d.L }
		self:CreateAuraFrame("Debuff", i, { X = ad.X + 1, Y = ad.Y - 16 - ii * 17 - 1, tX = ad.tX, tY = ad.tY, W = ad.W - 2, H = ad.H - 2, L = "OVERLAY", Clr = SkyUI.Clr.Transparent })
--  t["DebuffIcon" .. i] = 
	end

 for i=1, 12 do
	 local ii = i - 1
  t["AuraBuff" .. i] = { X = a.X + (math.floor(ii / 2) * 17), Y = a.Y - ((ii % 2) * 17), tX = a.tX, tY = a.tY, W = a.W, H = a.H, L = a.L }
		self:CreateAuraFrame("AuraBuff", i, { X = a.X + (math.floor(ii / 2) * 17) + 1, Y = a.Y - ((ii % 2) * 17) - 1, tX = a.tX, tY = a.tY, W = a.W - 2, H = a.H - 2, L = "OVERLAY", Clr = SkyUI.Clr.Transparent })
--  t["AuraBuffIcon" .. i] = 

  t["AuraDebuff" .. i] = { X = ad.X + (math.floor(ii / 2) * 17), Y = ad.Y + ((ii % 2) * 17), tX = ad.tX, tY = ad.tY, W = ad.W, H = ad.H, L = ad.L }
		self:CreateAuraFrame("AuraDebuff", i, { X = ad.X + (math.floor(ii / 3) * 17) + 1, Y = ad.Y + ((ii % 3) * 17) - 1, tX = ad.tX, tY = ad.tY, W = ad.W - 2, H = ad.H - 2, L = "OVERLAY", Clr = SkyUI.Clr.Transparent })
--  t["AuraDebuffIcon" .. i] = 

	end
	
	self:AddTextures(t)

-- self:CreateAuraFrames("BuffIcon", 8)
-- self:CreateAuraFrames("DebuffIcon", 8)
-- self:CreateAuraFrames("AuraBuffIcon", 12)
-- self:CreateAuraFrames("AuraDebuffIcon", 12)

end

function SkyUnitFrame.prototype:UpdateVertBar(t, curVal, maxVal, v, YOffset) -- , textureOffset, reversedTexture
 if curVal == 0 then curVal = 1 end
 if maxVal == 0 or t == nil then return end
	if curVal > maxVal then curVal = maxVal end
	if not YOffset then YOffset = 0 end
	
	local p = curVal / maxVal;

	local newHeight = v.H * p
	local dif = v.H - newHeight

 local g = self.TS
	
	local x1, x2, y1, y2 = v.tX / g.W, (v.tX + v.W) / g.W, (v.tY+dif) / g.H, (v.tY + v.H) / g.H

 point, relativeTo, relativePoint, xOfs, yOfs = t:GetPoint()

	if self.TexturesReversed then
	 t:SetTexCoord(x2, y1, x2, y2, x1, y1, x1, y2)
 	t:SetPoint(relativePoint, t:GetParent(), -v.X - self.tO.X, v.Y + self.tO.Y - dif + YOffset)
	else
	 t:SetTexCoord(x1, x2, y1, y2)
 	t:SetPoint(relativePoint, t:GetParent(), v.X + self.tO.X, v.Y + self.tO.Y - dif + YOffset)
	end
	
	t:SetSize(v.W, newHeight)
end




function SkyUnitFrame.prototype:UpdateAuraBars() -- ! ** !  ! ** !  ! ** !  ! ** !  ! ** !  ! ** !  ! ** !  ! ** !  ! ** !  ! ** !  ! ** !  ! ** !  ! ** !  ! ** !  --
-- Start .. Duration .. Expires
 local g = self.TS
	
 for k, v in pairs(self.AuraBars) do
		local durationRemaining = v.Expires - GetTime()
  self:UpdateVertBar(self.F[k], durationRemaining, v.Duration, v.T, v.Offset)
	end
end


function SkyUnitFrame.prototype:UpdateUnitReaction()
 if self.Unit == "target" and UnitCanAttack("player", "target") and (UnitReaction("player", "target") < 4 or (UnitReaction("player", "target")  == 4 and UnitThreatSituation("player", "target"))) then
  self.F.Health:SetVertexColor(SkyUI.Clr.HealthHostile.r, SkyUI.Clr.HealthHostile.g, SkyUI.Clr.HealthHostile.b, SkyUI.Clr.HealthHostile.a)
  self.F.IncomingHealth:SetVertexColor(SkyUI.Clr.HealthHostileIncoming.r, SkyUI.Clr.HealthHostileIncoming.g, SkyUI.Clr.HealthHostileIncoming.b, SkyUI.Clr.HealthHostileIncoming.a)
 else
  self.F.Health:SetVertexColor(SkyUI.Clr.HealthFriendly.r, SkyUI.Clr.HealthFriendly.g, SkyUI.Clr.HealthFriendly.b, SkyUI.Clr.HealthFriendly.a)
  self.F.IncomingHealth:SetVertexColor(SkyUI.Clr.HealthIncoming.r, SkyUI.Clr.HealthIncoming.g, SkyUI.Clr.HealthIncoming.b, SkyUI.Clr.HealthIncoming.a)
 end
end


-- **************  UPDATE ! UPDATE ! UPDATE ! UPDATE ! UPDATE ! UPDATE ! UPDATE ! UPDATE ! UPDATE ! UPDATE ! UPDATE ! ********************************** ! UPDATE ! UPDATE --
function SkyUnitFrame.prototype:Update(elapsed)
 local sui = self.sui

 if sui.Spell then sui:CastUpdate() end

 if sui.TimeSinceLastUpdate < UpdateInterval then
  sui.TimeSinceLastUpdate = sui.TimeSinceLastUpdate + elapsed
		return
	end
	
 sui.TimeSinceLastUpdate = 0
	
	local guid = UnitGUID(sui.Unit)
	local targetGUID = UnitGUID(sui.Unit .. "target")
	local health = UnitHealth(sui.Unit)
	local power = UnitPower(sui.Unit)

 if not guid then -- No Unit Selected, Hide Frame
	 self:SetAlpha(0)
	elseif( guid ~= sui.GUID ) then -- Target Changed, Update frame data
	 if not sui.GUID then self:SetAlpha(1) end
	 SetPortraitTexture(sui.F.Portrait, sui.Unit)
 	local powerType, powerToken, _, _, _ = UnitPowerType(sui.Unit)
  self.Power:SetVertexColor(PowerBarColor[powerType].r, PowerBarColor[powerType].g, PowerBarColor[powerType].b)
  sui:UpdateVertBar(self.Health, health, UnitHealthMax(sui.Unit), sui.T.Health)
  sui:UpdateVertBar(self.Power, power, UnitPowerMax(sui.Unit), sui.T.Power)
--		sui:UpdateUnitName()
		
--  local classToken = select(2, UnitClass(sui.Unit))
--	 self.ClassIcon:SetTexCoord(CLASS_ICON_TCOORDS[classToken][1], CLASS_ICON_TCOORDS[classToken][2], CLASS_ICON_TCOORDS[classToken][3], CLASS_ICON_TCOORDS[classToken][4])


		if UnitIsPlayer(sui.Unit) then			
			local t = CLASS_ICON_TCOORDS[select(2,UnitClassBase(sui.Unit))]
			if t then
				self.ClassIcon:SetTexture("Interface\\TargetingFrame\\UI-Classes-Circles")
				self.ClassIcon:SetTexCoord(unpack(t))
			end
		else
			self.ClassIcon:SetTexCoord(0,0,0,0)
		end
		
		sui:UpdateUnitReaction()

--   DEFAULT_CHAT_FRAME:AddMessage("Friend:" .. tostring(UnitIsFriend("target", "player")))
--   DEFAULT_CHAT_FRAME:AddMessage("CanAttack:" .. tostring(UnitCanAttack("target", "player")))
--   print("UnitThreatSituation:" .. tostring(UnitThreatSituation("player", "target")))
--   DEFAULT_CHAT_FRAME:AddMessage("targettarget:" .. tostring(UnitName("targettarget")))

	else
		if sui.Health ~= health then
		 sui:UpdateVertBar(self.Health, health, UnitHealthMax(sui.Unit), sui.T.Health)
		 sui:IncomingHealsUpdate(nil, sui.Unit)

		end
  if sui.Power ~= power then sui:UpdateVertBar(self.Power, power, UnitPowerMax(sui.Unit), sui.T.Power) end
	end

	sui.GUID = guid
	sui.TargetGUID = targetGUID
	sui.Health = health
	sui.Power = power

	sui:UpdateAuraBars()

--	if sui.cd_i < 3 then
--	 sui.cd_i = sui.cd_i + 1
--		return
--	end
--	sui.cd_i = 0


end

function SkyUnitFrame.prototype:CastStart(evt, ...)
	-- START ... currentTime .. END
	-- (END - currentTime) / Duration = Percent Left
 	
	local spell, rank, displayName, icon, startTime, endTime, isTradeSkill = UnitCastingInfo(self.Unit)
	if not (spell) then
	 spell, rank, displayName, icon, startTime, endTime = UnitChannelInfo(self.Unit)
	 self.CastIsChanneled = true;
	end
 if not (spell) then return end
 self.IsCasting = true

	self.Spell = spell
	self.CastEnd = endTime / 1000
 self.CastDuration = (endTime - startTime) / 1000

 self.F.CastBar:Show()
	self.F.Cast:Show()
	self.F.CastIconOverlay:Show()
 self.F.CastIconOverlay:SetTexture(icon)
 self.F.CastIconOverlay:SetTexCoord(0.1, 0.9, 0.1, 0.9)

 self.F.UnitName:Hide()
	self.F.CDSpannerL:Hide()
	self.F.CDSpannerS:Hide()
	self.F.CDSpannerR:Hide()

end

function SkyUnitFrame.prototype:CastUpdate()
 if not self.Spell then return end
	local p, v, t = (self.CastEnd - GetTime()) / self.CastDuration, self.T.Cast, self.F.Cast
 if p > 1 then p = 1 end

	if self.CastIsChanneled then
	
	else p = 1 - p end
	
 local newWidth = v.W * p
	local dif = v.W - newWidth

 local g = self.TS
	

	local x1, x2, y1, y2 = v.tX / g.W, (v.tX + newWidth) / g.W, v.tY / g.H, (v.tY + v.H) / g.H

 point, relativeTo, relativePoint, xOfs, yOfs = t:GetPoint()

	if self.TexturesReversed then
	 t:SetTexCoord(x2, y1, x2, y2, x1, y1, x1, y2)
 	t:SetPoint(relativePoint, t:GetParent(), -v.X - self.tO.X, v.Y + self.tO.Y)
	else
	 t:SetTexCoord(x1, x2, y1, y2)
 	t:SetPoint(relativePoint, t:GetParent(), v.X + self.tO.X, v.Y + self.tO.Y)
	end
	
	t:SetSize(newWidth, v.H)

	
end

function SkyUnitFrame.prototype:CastStop(evt, ...)

 self.IsCasting = false
 self.Spell = nil
	self.CastEnd = nil
 self.CastDuration = nil
	self.CastIsChanneled = false;

 self.F.CastBar:Hide()
	self.F.Cast:Hide()
	self.F.CastIconOverlay:Hide()

 self.F.UnitName:Show()
	self.F.CDSpannerL:Show()
	self.F.CDSpannerS:Show()
	self.F.CDSpannerR:Show()
end


function SkyUnitFrame.prototype:IncomingHealsUpdate()

	self.IncomingHeals = UnitGetIncomingHeals(self.Unit) or 0
 if self.IncomingHeals ~= 0 then self.IncomingHeals = self.IncomingHeals + UnitHealth(self.Unit) end
	if self.IncomingHeals >= UnitHealthMax(self.Unit) then self.IncomingHeals = 0 end
 self:UpdateVertBar(self.F.IncomingHealth, self.IncomingHeals, UnitHealthMax(self.Unit), self.T.IncomingHealth)
  
end


local function compareDurations(a,b)
 if not a[5] or not b[5] then return a[1] < b[1]
 else return a[5] < b[5] end
end




function SkyUnitFrame.prototype:AuraUpdates()
 
-- local buffs, debuffs, aurabuffs, auradebuffs = {}, {}, {}, {} -- 

 local auras = {}

-- local i, b, d, ab, ad = 1, 1, 1, 1, 1
 for i = 1, 20 do
	 bName, _, bIcon, _, bDebuffType, bDuration, bExpirationTime, _, bIsStealable, _, bSpellId = UnitAura(self.Unit, i, "HELPFUL") 
	 dName, _, dIcon, _, dDebuffType, dDuration, dExpirationTime, _, dIsStealable, _, dSpellId = UnitAura(self.Unit, i, "HARMFUL") 
  if bName then
		 if bDuration ~= 0 and bDuration < 100 then
			 auras[#auras + 1] = { 1, bName, bIcon, bDuration, bExpirationTime, bIsStealable, bSpellId, i }
		 else
			 auras[#auras + 1] = { 2, bName, bIcon, bDuration, bExpirationTime, bIsStealable, bSpellId, i }
		 end
		end

  if dName then
		 if dDuration ~= 0 and dDuration < 100 then
			 auras[#auras + 1] = { 3, dName, dIcon, dDuration, dExpirationTime, dIsStealable, dSpellId, i }
		 else
			 auras[#auras + 1] = { 4, dName, dIcon, dDuration, dExpirationTime, dIsStealable, dSpellId, i }
		 end
		end
		

		for i = 1, 12 do
		 if i < 9 then
			 self.F["BuffBar" .. i]:SetAlpha(0)
			 self.F["BuffLife" .. i]:SetAlpha(0)
			 self.F["DebuffBar" .. i]:SetAlpha(0)
			 self.F["DebuffLife" .. i]:SetAlpha(0)
				
				self.F["BuffFrame" .. i].Index = nil
    self.F["BuffFrame" .. i]:Hide()
				self.F["DebuffFrame" .. i].Index = nil
    self.F["DebuffFrame" .. i]:Hide()
			end
			self.F["AuraBuff" .. i]:SetAlpha(0)
			self.F["AuraDebuff" .. i]:SetAlpha(0)

   self.F["AuraBuffFrame" .. i].Index = nil
   self.F["AuraBuffFrame" .. i]:Hide()
   self.F["AuraDebuffFrame" .. i].Index = nil
   self.F["AuraDebuffFrame" .. i]:Hide()
		end
		
		local bb, b, db, d = 1, 1, 1, 1
		self.AuraBars = {}
		
		for i, k in ipairs(auras) do
		 if k[1] == 1 and bb < 8 and k[4] > 10 then
   
			 if self.F["BuffBar" .. bb] then
			 	self.F["BuffBar" .. bb]:SetAlpha(1)
			 	self.F["BuffLife" .. bb]:SetAlpha(1)
     self.F["BuffFrame" .. bb]:Show()
     self.F["BuffFrame" .. bb].TT = { Index = k[8], Unit = self.Unit, Filter = "HELPFUL" }
			 	self.F["BuffFrame" .. bb].texture:SetTexture(k[3])
			 	self.AuraBars["BuffLife" .. bb] = { Duration = k[4], Expires = k[5], T = self.T.Buff, Offset = (bb - 1) * 17 }
			  bb = bb + 1
			 end
			elseif k[1] == 2 or bb > 7 or k[4] < 11 then
			 if self.F["AuraBuff" .. b] then
				 self.F["AuraBuff" .. b]:SetAlpha(1)
     self.F["AuraBuffFrame" .. b]:Show()
     self.F["AuraBuffFrame" .. b].TT = { Index = k[8], Unit = self.Unit, Filter = "HELPFUL" }
				 self.F["AuraBuffFrame" .. b].texture:SetTexture(k[3])
			  b = b + 1
				end
			elseif k[1] == 3 and db < 8 and k[4] > 10 then
   
			 if self.F["DebuffBar" .. db] then
				 self.F["DebuffBar" .. db]:SetAlpha(1)
				 self.F["DebuffLife" .. db]:SetAlpha(1)
     self.F["DebuffFrame" .. db]:Show()
     self.F["DebuffFrame" .. db].TT = { Index = k[8], Unit = self.Unit, Filter = "HARMFUL" }
				 self.F["DebuffFrame" .. db].texture:SetTexture(k[3])
				 self.AuraBars["DebuffLife" .. db] = { Duration = k[4], Expires = k[5], T = self.T.Debuff, Offset = -(db - 1) * 17 }
     self.F["DebuffLife" .. db]:SetVertexColor(.5, 0, 1) -- THIS NEEDS TO BE MOVED TO BUFF FRAME INIT!
			  db = db + 1
				end
			elseif k[1] == 4 or gb > 7 or k[4] < 11 then
			 if self.F["AuraDebuff" .. d] then
				 self.F["AuraDebuff" .. d]:SetAlpha(1)
     self.F["AuraDebuffFrame" .. d]:Show()
     self.F["AuraDebuffFrame" .. d].TT = { Index = k[8], Unit = self.Unit, Filter = "HARMFUL" }
				 self.F["AuraDebuffFrame" .. d].texture:SetTexture(k[3])
			  d = d + 1
				end
			end
			
		end

  if not bName and not dName then break end
 end
 
	table.sort(auras, compareDurations)

end


function SkyUnitFrame.prototype:PLAYER_TARGET_CHANGED() -- hacky :(
 self:UpdateUnitName(f, "target")
 self:CastStop(evt, "target")
	if(UnitCastingInfo("target")) then self:CastStart(evt, "target")	end
 self:AuraUpdates()
end

function SkyUnitFrame.prototype:UpdateUnitName() -- hacky :(
 self.F.UnitName:SetText(UnitName(self.Unit))
	local w = self.F.UnitName:GetStringWidth() + 6
	self:UpdateCDSpanner(w)
 self.F.UnitLevel:SetText(UnitLevel(self.Unit))
end

function SkyUnitFrame.prototype:UpdateCDSpanner(w)
	self.F.CDSpannerS:SetWidth(w + 1)
	if self.TexturesReversed then self.F.CDSpannerR:SetPoint("TOPRIGHT", -self.T.CDSpannerR.X - self.tO.X - w, self.T.CDSpannerR.Y + self.tO.Y)
 else self.F.CDSpannerR:SetPoint("TOPLEFT", self.T.CDSpannerR.X + self.tO.X + w, self.T.CDSpannerR.Y + self.tO.Y) end
end

function SkyUnitFrame.prototype:PLAYER_ENTERING_WORLD()
		self:UpdateVertBar(self.Health, UnitHealth(self.Unit), UnitHealthMax(self.Unit), self.T.Health)
end

function SkyUnitFrame.prototype:UNIT_DISPLAYPOWER()
 	local powerType, powerToken, _, _, _ = UnitPowerType(self.Unit)
  self.F.Power:SetVertexColor(PowerBarColor[powerType].r, PowerBarColor[powerType].g, PowerBarColor[powerType].b)
end




function EventManager(self, evt, ...)

 -- OH NOES! MY UI DOESN'T SUPPORT PETS!!!!!!!!!! xD :(
-- if ... ~= "player" and ... ~= "target" then return end

 if evt == "PLAYER_ENTERING_WORLD" then
--  SkyUI.player:PLAYER_ENTERING_WORLD()
--  SkyUI.target:PLAYER_ENTERING_WORLD()
 SkyUI.player:UpdateUnitName()
 SkyUI.player:UNIT_DISPLAYPOWER()
 elseif evt == "PLAYER_TARGET_CHANGED" then
  SkyUI.target:PLAYER_TARGET_CHANGED()
 elseif evt == "PLAYER_XP_UPDATE" then
 SkyUI.player:UpdateUnitName()
	elseif SkyUI[...] then
  if evt == "UNIT_DISPLAYPOWER" then
   SkyUI[...]:UNIT_DISPLAYPOWER()
  elseif evt == "UNIT_SPELLCAST_START" or evt == "UNIT_SPELLCAST_CHANNEL_START" then SkyUI[...]:CastStart(evt, ...)
  elseif evt == "UNIT_SPELLCAST_STOP" or evt == "UNIT_SPELLCAST_CHANNEL_STOP" then SkyUI[...]:CastStop(evt, ...)
	
	 elseif evt == "UNIT_HEAL_PREDICTION" then SkyUI[...]:IncomingHealsUpdate(evt, ...)
 
  elseif evt == "UNIT_AURA" and SkyUI[...] then SkyUI[...]:AuraUpdates()
 
  elseif evt == "UNIT_THREAT_SITUATION_UPDATE" then
   SkyUI.target:UpdateUnitReaction()
  end
 end
end

SkyUnitFrame:new("player")
SkyUnitFrame:new("target")


PlayerFrame:Hide()
PlayerFrame:UnregisterAllEvents()
	
TargetFrame:Hide()
TargetFrame:UnregisterAllEvents()


evt:RegisterEvent("PLAYER_ENTERING_WORLD")
evt:RegisterEvent("PLAYER_XP_UPDATE")

evt:RegisterEvent("UNIT_DISPLAYPOWER")

evt:RegisterEvent("PLAYER_TARGET_CHANGED")

evt:RegisterEvent("UNIT_SPELLCAST_START")
evt:RegisterEvent("UNIT_SPELLCAST_STOP")

--evt:RegisterEvent("UNIT_SPELLCAST_FAILED")
--evt:RegisterEvent("UNIT_SPELLCAST_INTERRUPTED")

--evt:RegisterEvent("UNIT_SPELLCAST_DELAYED")
--evt:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")

evt:RegisterEvent("UNIT_SPELLCAST_CHANNEL_START")
--evt:RegisterEvent("UNIT_SPELLCAST_CHANNEL_UPDATE")
evt:RegisterEvent("UNIT_SPELLCAST_CHANNEL_STOP")

evt:RegisterEvent("UNIT_HEAL_PREDICTION")

evt:RegisterEvent("UNIT_AURA")

evt:RegisterEvent("UNIT_THREAT_SITUATION_UPDATE")

evt:SetScript("OnEvent", EventManager)




