﻿-- Author      : Skylar
-- Last Updated : 7/14/2012 10:54 AM
function SkyUI_CreateClass(parent)
	local class = { prototype = {} }
	if parent then
		class.super = parent
		setmetatable(class.prototype, { __index = parent.prototype })
	end
	local mt = { __index = class.prototype }
	function class:new(...)
		local self = setmetatable({}, mt)
		if self.init then
			self:init(...)
		end
		return self
	end

	return class
end


SkyUI = {}
local SkyUI = SkyUI
 

SkyUI.Graphics = { -- Textures
 Btn =	{ Path = "Interface\\addons\\SkyUI\\Textures\\SkyUI", W = 512, H = 512 },
	Units = { Path = "Interface\\addons\\SkyUI\\Textures\\SkyUI_unitFrames", W = 512, H = 512 },
}

SkyUI.Fonts = {
 Memoe = "Interface\\addons\\SkyUI\\Fonts\\MEMOE___.ttf",
	Nasalization = "Interface\\addons\\SkyUI\\Fonts\\nasalization.ttf",
	OrbitronBlack = "Interface\\addons\\SkyUI\\Fonts\\orbitron-black.ttf",
	OrbitronBold = "Interface\\addons\\SkyUI\\Fonts\\orbitron-bold.ttf",
	OrbitronLight = "Interface\\addons\\SkyUI\\Fonts\\orbitron-light.ttf",
	OrbitronMedium = "Interface\\addons\\SkyUI\\Fonts\\orbitron-medium.ttf",	
}
SkyUI.Clr = {
	None = {r = 1, g = 1, b = 1, a = 1},
	HealthFriendly = {r = 0, g = 1, b = 0.125, a = 1},
	HealthIncoming = {r = 0, g = .5, b = .075, a = 1},
	HealthHostile = {r = 0.95, g = 0.05, b = 0.05, a = 1},
	HealthHostileIncoming = {r = 0.75, g = 0.05, b = 0.05, a = 1},
	HealthNeutral = {r = 0.8, g = 0.8, b = 0.8, a = 1},
	Mana = {r = 0, g = 0.72265625, b = 0.92578125, a = 1},
	Energy = {r = 1, g = 1, b = 0, a = 1},
	Combo = {r = 1, g = 1, b = 0, a = 0},
	Transparent = {r = 1, g = 1, b = 1, a = 0 },
}
local Clr = SkyUI.Clr

SkyUI.Specs = {
	ActionBars = {
  Enabled = true,
  TextureSheet = SkyUI.Graphics.Btn, 
  KeyPad = {
 		bgTexture = { X = 0, Y = 0 },
 		RT = "RIGHT", X = -200, Y = 0, W = 131, H = 164,
 	},
  ArrowPad = {
 		bgTexture = { X = 0,	Y = 164	},
 		RT = "RIGHT",	X = -200,	Y = -200,	W = 98,	H = 132,
 	},
  VertBar = {
 		bgTexture = { X = 466,	Y = 50 },
 		RT = "RIGHT", X = -10, Y = 0, W = 32, H = 395,
 	},
  MainBar = {
 		bgTexture = { X = 3, Y = 444, W = 447, H = 49 },
 		RT = "BOTTOM", X = 0, Y = 20, W = 447, H = 49,
 		Textures = { -- Graphic, RelativeTo, offsetX, offsetY, texturecoordX, texturecoordY, Width, Height
 			["XPBarLeft"] = { RT = "BOTTOMLEFT", X = 5, Y = 4, tX = 7, tY = 498, W = 3, H = 7, L = "OVERLAY" },
 			["XPBarSpan"] = { RT = "BOTTOMLEFT", X = 8, Y = 4, tX = 10, tY = 498, W = 1, H = 7, L = "OVERLAY" },
 			["XPBarRight"] = { RT = "BOTTOMLEFT", X = 100, Y = 4, tX = 22, tY = 498, W = 3, H = 7, L = "OVERLAY" },
 		},
 		Text = {
 			["UIName"] = { String = "SkyUI", RT = "BOTTOM", X = 1, Y = 28.5, Font = SkyUI.Fonts.OrbitronBlack, Size = 10, Flags = "" }
 		},
 	},
  MicroMenu = {
 		bgTexture = nil,
 		RT = "BOTTOMRIGHT", X = -8, Y = 4, W = 257, H = 41,
 	}
	},
	UnitFrames = {
  Enabled = true,
 	TextureSheet = SkyUI.Graphics.Units,
		TextureOffset = {X = -36, Y = 111},
  Frames = { --[ Anchor, OffsetX, OffsetY, Width, Height, X1,X2,Y1,Y2 ]
   Player = { RT = "CENTER", X = -250, Y = -100, W = 122, H = 87 }, -- 230
   Target = { RT = "CENTER", X = 250, Y = -100, W = 122, H = 87 }, -- 222
   Party = {
				bgTexture = { X = 0, Y = 0 },
				RT = "TOPLEFT", X = 20, Y = 150, W = 140, H = 37, tX = 289, tY = 162
			},
  },
  Unit = {
			Textures = {
			 -- [ OffsetX, OffsetY, X, Y, Width, Height, Layer, DefaultVertexColor ]
   -- 181,267
    BG = { X = 0, Y = 0.5, tX = 0, tY = 0, W = 183, H = 269, L = "ARTWORK" },
		
    Health = { X = 3, Y = -6.5, tX = 182, tY = 7, W = 143, H = 164, L = "OVERLAY", Clr = Clr.HealthFriendly },
    IncomingHealth = { X = 3, Y = -6.5, tX = 182, tY = 7, W = 173, H = 173, L = "HIGHLIGHT", Clr = Clr.HealthIncoming },

    Power = { X = 79.5, Y = -160, tX = 79, tY = 268, W = 86, H = 86, L = "OVERLAY", Clr = Clr.Energy },

 		 CastBar = { X = 149, Y = -178.5, tX = 0,tY =  374, W = 169, H = 23, L = "BACKGROUND" },
 		 Cast = { X = 155.5, Y = -184.5, tX = 6, tY = 397, W = 139, H = 11, L = "ARTWORK" },
    CastIconOverlay = { X = 293.5, Y = -182.5, tX = 169, tY = 376, W = 17, H = 17, L = "OVERLAY" },

 		 CDSpannerL = { X = 148.5, Y = -181.5, tX = 182, tY = 183, W = 15, H = 18, L = "BACKGROUND" },
 		 CDSpannerS = { X = 163.5, Y = -181.5, tX = 201, tY = 183, W = 1, H = 18, L = "BACKGROUND" },
 		 CDSpannerR = { X = 164.5, Y = -181.5, tX = 202, tY = 183, W = 15, H = 18, L = "BACKGROUND" },
				
				BuffBar = { Skip = true, X = 37, Y = -33.5, tX = 318, tY = 268, W = 128, H = 112, L = "BACKGROUND", Clr.None},
    Buff = { Skip = true, X = 45, Y = -36.5, tX = 326, tY = 380, W = 101, H = 101, L = "ARTWORK", Clr.None},

				DebuffBar = { Skip = true, X = 90, Y = -191.5, tX = 222, tY = 268, W = 97, H = 81, L = "BACKGROUND", Clr.None},
    Debuff = { Skip = true, X = 97, Y = -194.5, tX = 240, tY = 380, W = 70, H = 70, L = "ARTWORK", Clr.None},

 			AuraBuff = { Skip = true, X = 149, Y = -146.5, tX = 302, tY = 333, W = 15, H = 15, L = "BACKGROUND" },
-- 			AuraDebuff = { Skip = nil, X = 149, Y = -163.5, tX = 302, tY = 333, W = 15, H = 15, L = "BACKGROUND" },

 			AuraDebuff = { Skip = true, X = 170, Y = -240.5, tX = 302, tY = 333, W = 15, H = 15, L = "BACKGROUND" },
-- 			Aura4 = { Skip = nil, X = 170, Y = -223.5, tX = 302, tY = 333, W = 15, H = 15, L = "BACKGROUND" },
-- 			Aura5 = { Skip = nil, X = 170, Y = -206.5, tX = 302, tY = 333, W = 15, H = 15, L = "BACKGROUND" },

			},
			Text = {
 			["UnitName"] = { String = "", X = 167.5, Y = -186.5, Font = SkyUI.Fonts.OrbitronBlack, Size = 10, Flags = "" },
 			["UnitLevel"] = { String = "1", X = 160, Y = -203, Font = SkyUI.Fonts.Nasalization, Size = 12, Flags = "OUTLINE"}
 		},
  },	
	},
 ComboPoints = {
  Enabled = false,
  TextureSheet = SkyUI.Graphics.Units,
		TextureOffset = {X = 0, Y = 0},
  Frames = { --[ Anchor, OffsetX, OffsetY, Width, Height, X1,X2,Y1,Y2 ]
   Combo = { RT = "CENTER", X = 0, Y = -220, W = 72, H = 72  },
  },
  Textures = {
   BG = { X = 0, Y = 0.5, tX = 5, tY = 408, W = 72, H = 72, L = "BACKGROUND" },
 	 C1 = { X = 0, Y = -16, tX = 113, tY = 408, W = 35, H = 35, L = "OVERLAY", Sub = 0, Clr = Clr.Combo, Rotate = 3 },
 	 C2 = { X = 21, Y = 0, tX = 113, tY = 408, W = 35, H = 35, L = "OVERLAY", Sub = 0, Clr = Clr.Combo, Rotate = 0 },
 	 C3 = { X = 37, Y = -21, tX = 113, tY = 408, W = 35, H = 35, L = "OVERLAY", Sub = 0, Clr = Clr.Combo, Rotate = 1},
 	 C4 = { X = 16, Y = -37, tX = 113, tY = 408, W = 35, H = 35, L = "OVERLAY", Sub = 0, Clr = Clr.Combo, Rotate = 2 },
 	 C5 = { X = 22, Y = -22, tX = 113, tY = 452, W = 28, H = 28, L = "OVERLAY", Sub = 1, Clr = Clr.Combo},
  }
 
 },

}


SkyBaseClass = SkyUI_CreateClass()
local SkyBaseClass = SkyBaseClass

SkyBaseClass.prototype.BaseName = "SkyUI_"

SkyBaseClass.Evt = CreateFrame("Frame") -- Event Catcher Frame

-- TexturePath, TextureSize, TextureCoordX, TextureCoordY

function SkyBaseClass.prototype:init()

end


function SkyBaseClass.prototype:SetBackground()
 if not self.bgTexture or not self.F then return end

	local t = self.bgTexture
	local g = self.TS
 local bg = self.F:CreateTexture(nil, "ARTWORK")
	bg:SetTexture(g.Path) -- SpriteSheet
	bg:SetAllPoints(self.F)
	bg:SetTexCoord(t.X / g.W, (t.X + self.W) / g.W, t.Y / g.H, (t.Y + self.H) / g.H)
	bg:Show()
 self.F.texture = bg
	
	self.F:Show()

end






function SkyBaseClass.prototype:AddTextures(Textures)
 if not self.T or not self.F then return end
	local g = self.TS

 if not Textures then Textures = self.T end
	
	for k,v in pairs(Textures) do
	 if not v.Skip then
	  self.F[k] = self.F:CreateTexture(self.BaseName .. self.Name .. k, v.L, nil, v.Sub)
   self.F[k]:SetTexture(g.Path)
			
			if self.TexturesReversed then v.RT = "TOPRIGHT"
			elseif v.RT == nil then v.RT = "TOPLEFT" end
			
		 self.F[k]:SetSize(v.W, v.H)
			
			local x1, x2, y1, y2 = v.tX / g.W, (v.tX + v.W) / g.W, v.tY / g.H, (v.tY + v.H) / g.H

   -- x1,y1               x2,y1
   --                          
   --
   --
   -- x1,y2               x2,y2

   

   
   if self.TexturesReversed then
	 	 self.F[k]:SetPoint(v.RT, -v.X - self.tO.X, v.Y + self.tO.Y)
    --                                         UL, LL, UR, LR
			 self.F[k]:SetTexCoord(x2, y1, x2, y2, x1, y1, x1, y2)
   elseif v.Rotate then
 		 self.F[k]:SetPoint(v.RT, v.X + self.tO.X, v.Y + self.tO.Y)
    
--    local ULx, ULy, LLx, LLy, URx, URy, LRx, LRy = x1, y1, x1, y2, x2, y1, x2, y2
    local URx, URy, LRx, LRy, LLx, LLy, ULx, ULy = x2, y1, x2, y2, x1, y2, x1, y1
    

    local i = v.Rotate
    while i > 0 do
     local t1, t2 = ULx, ULy
     ULx, ULy = LLx, LLy
     LLx, LLy = LRx, LRy
     LRx, LRy = URx, URy
     URx, URy = t1, t2
     i = i - 1
    end
    
    self.F[k]:SetTexCoord(ULx, ULy, LLx, LLy, URx, URy, LRx, LRy)
   

		 else
 		 self.F[k]:SetPoint(v.RT, v.X + self.tO.X, v.Y + self.tO.Y)
			 self.F[k]:SetTexCoord(x1, x2, y1, y2)
    if v.Rotation then self.F[k]:SetRotation(v.Rotation) end
			end
	  self.F[k]:Show()
			if v.Clr then self.F[k]:SetVertexColor(v.Clr.r, v.Clr.g, v.Clr.b, v.Clr.a) end
		end
 end

end


function SkyBaseClass.prototype:AddText()
 if not self.Txt or not self.F then return end

 for k,v in pairs(self.Txt) do
	 self.F[k] = self.F:CreateFontString(self.BaseName .. self.Name .. k, "OVERLAY")
  self.F[k]:SetFont(v.Font, v.Size, v.Flags)
		self.F[k]:ClearAllPoints()
		
		if self.TexturesReversed then v.RT = "TOPRIGHT"
		elseif v.RT == nil then v.RT = "TOPLEFT" end

		if self.TexturesReversed then
		 self.F[k]:SetPoint(v.RT, -v.X - self.tO.X, v.Y + self.tO.Y)
			self.F[k]:SetJustifyH("RIGHT")
  else
		 self.F[k]:SetPoint(v.RT, v.X + self.tO.X, v.Y + self.tO.Y)
		end
		self.F[k]:SetText(v.String)
		self.F[k]:Show()
	end

end


SkyUI.Page = {
	["Druid"] = "[bonusbar:1] 1; [bonusbar:2] 2; [bonusbar:3] 3; [bonusbar:4] 4;",
	["Warrior"] = "[bonusbar:1] 1; [bonusbar:2] 2; [bonusbar:3] 3;",
	["Rogue"] = "[bonusbar:1] 1;",
	["Priest"] = "[bonusbar:1] 1;",
	["DEFAULT"] = "[bonusbar:0] 0; [bonusbar:5] 5; [bonusbar:1,stealth:1] 2; [overridebar][possessbar] possess;",
}


function SkyBaseClass.prototype:GetBar()
	local condition = SkyUI.Page["DEFAULT"]
	local class = UnitClass("player")

	local page = SkyUI.Page[class]
	if page then
		condition = condition.." "..page
	end
	condition = condition.." 0"

	return condition
end

function SkyBaseClass.prototype:CreateFrame()
	self.F = CreateFrame("Frame", self.BaseName .. self.Name, UIParent)
 self.F:SetPoint(self.RT, self.X, self.Y)
	self.F:SetSize(self.W, self.H)
	self.F:Show()
	self.F.sui = self
end
function SkyBaseClass.prototype:CreateSecureHeader()
	self.Header = CreateFrame("Frame", nil, nil, "SecureHandlerStateTemplate")

 if self.Name == "KeyPad" then
 self.Header:SetAttribute("_onstate-page", [[

		if newstate == "possess" or newstate == "11" then
			if HasVehicleActionBar() then
				newstate = GetVehicleBarIndex()
			elseif HasOverrideActionBar() then
				newstate = GetOverrideBarIndex()
			elseif HasTempShapeshiftActionBar() then
				newstate = GetTempShapeshiftBarIndex()
			else
				newstate = nil
			end
			if not newstate then -- cannot determine possess/vehicle action bar page
				newstate = 12
			end
		end
  
		self:SetAttribute("state", newstate)
		control:ChildUpdate("state", newstate)
 ]])
 
 RegisterStateDriver(self.Header, "page", self.GetBar()) 
 end
 
 self.Header:SetPoint(self.RT, self.X, self.Y)
	self.Header:SetSize(self.W, self.H)
	self.Header:Show()
	self.Header.sui = self
 end


 
 
 
 
 
 
 

function InitUI(self, evt, ...)
 if SkyUI.SkyCombos and SkyUI.Specs.ComboPoints.Enabled then SkyUI.SkyCombos:new()
 end
end

local evt = CreateFrame("Frame") -- Event Catcher Frame
evt:RegisterEvent("PLAYER_ENTERING_WORLD")
evt:SetScript("OnEvent", InitUI)

 
 
 
 
 
 
-- DEFAULT_CHAT_FRAME:AddMessage(UIParent:GetEffectiveScale());
-- ChatFrame:Hide()
--MinimapCluster:Hide()

