-- Author      : Skylar State
-- Last Updated : 7/14/2012 10:54 AM

local SkyUI = SkyUI
local SkyBaseClass = SkyBaseClass

local lib10 = LibStub("LibActionButton-1.0")
local lib10Config = {
	outOfRangeColoring = "button",
	tooltip = "enabled",
	showGrid = false,
	colors = { range = { 0.8, 0.1, 0.1 }, mana = { 0.5, 0.5, 1.0 }	},
	hideElements = {	macro = true,	hotkey = true,	equipped = true,	},
	keyBoundTarget = false,
	clickOnDown = false,
}



local ButtonSizes = { {24, 24}, {24, 57}, {57, 24} }
local KeyPadPageOffsets = { 0, 48, 0, 68, 0, 107, 0 }

local customExitButton = {
	func = function(button)
		VehicleExit()
	end,
	texture = "Interface\\Icons\\Spell_Shadow_SacrificialShield",
	tooltip = LEAVE_VEHICLE,
}

local ButtonConfigs = {
-- [Cat,Battle,Stealth,Shadowform,Possess]: 1 [Prowl,Defensive]: 2, [Bear,Beserker]: 3, Moonkin : 4, 
-- 
-- 
-- 
-- 

  ["KeyPad"] = {
   {69, 37, 1, 1},   -- n9
   {36, 37, 1, 2},   -- n8
   {3, 37, 1, 3},    -- n7
   {36, 70, 1, 4}, -- n5
   {3, 70, 1, 5},    -- n4
   {69, 103, 1, 6},  -- n3
   {69, 70, 1, 7},   -- n6
   {36, 103, 1, 8},  -- n2
   {3, 103, 1, 9},   -- n1
   {3, 136, 3, 10},   -- n0
   {69, 136, 1, 11},  -- n.
   {102, 37, 2, 12},  -- n+

   {36, 4, 1, 13},    -- n/
   {69, 4, 1, 14},    -- n*
   {102, 4, 1, 15},   -- n-

  },

  ["ArrowPad"] = {
   {37, 4, 1, 28},   -- up
   {4, 37, 1, 29},   -- left
   {37, 37, 1, 30},  -- down
   {70, 37, 1, 31},  -- right
   {4, 71, 1, 32},   -- f
   {4, 104, 1, 33},  -- v
   {37, 71, 1, 34},  -- mouse up
   {37, 104, 1, 35}, -- mouse down
   {70, 71, 1, 36},  -- page up
   {70, 104, 1, 37}, -- page down
  },

  ["VertBar"] = {
   {4, 4, 1, 38},    -- 
   {4, 37, 1, 39},   -- 
   {4, 70, 1, 40},   -- 
   {4, 103, 1, 41},  -- 
   {4, 136, 1, 42},  -- 
   {4, 169, 1, 43},  -- 
   {4, 202, 1, 44},  -- 
   {4, 235, 1, 45},  -- 
   {4, 268, 1, 46},  -- 
   {4, 301, 1, 47},  -- 
   {4, 334, 1, 48},  -- 
   {4, 367, 1, 49},  -- 
  },

  ["MainBar"] = {
   {4, 4, 1, 16},     -- 0
   {37, 4, 1, 17},    -- 1
   {70, 4, 1, 18},    -- 2
   {103, 4, 1, 19},   -- 3
   {136, 4, 1, 20},   -- 4
   {169, 4, 1, 21},   -- 5
   {254, 4, 1, 22},   -- 6
   {287, 4, 1, 23},   -- 7
   {320, 4, 1, 24},   -- 8
   {353, 4, 1, 25},  -- 9
   {386, 4, 1, 26},  -- -
   {419, 4, 1, 27},  -- =
  },
		
		["MicroMenu"] = {}

}






local SkyActionBar = SkyUI_CreateClass(SkyBaseClass)



SkyActionBar.prototype.Name = nil
SkyActionBar.prototype.Buttons = {}
SkyActionBar.prototype.F = nil -- Frame

SkyActionBar.prototype.bgTexture = nil -- Background Texture: TexturePath, TexCoordX, TexCoordY, TexWidth, TexHeight
SkyActionBar.prototype.RT = 0 -- RelativeTo Position
SkyActionBar.prototype.X = 0
SkyActionBar.prototype.Y = 0
SkyActionBar.prototype.W = 0
SkyActionBar.prototype.H = 0
SkyActionBar.prototype.T = nil -- Textures
SkyActionBar.prototype.Txt = nil

SkyActionBar.prototype.TS = nil
SkyActionBar.prototype.tO = {X = 0, Y = 0}
SkyActionBar.prototype.InVehicle = false



function SkyActionBar.prototype:init(name)
	-- Assign Variables
	self.Name = name
	local spec = SkyUI.Specs.ActionBars[self.Name]
	self.bgTexture = spec.bgTexture
	self.RT = spec.RT
	self.X = spec.X
	self.Y = spec.Y
	self.W = spec.W
	self.H = spec.H
	self.T = spec.Textures
	self.Txt = spec.Text
	
	self.TS = SkyUI.Specs.ActionBars.TextureSheet
	if SkyUI.Specs.ActionBars.TextureOffset then self.tO = SkyUI.Specs.ActionBars.TextureOffset end
	
	-- Setup Frame and Textures
 self:CreateFrame()
 self:CreateSecureHeader()
 if self.bgTexture then self:SetBackground() end -- Add a background texture if provided
 if self.T then self:AddTextures() end -- Add any additional textures attached to the frame if provided
 if self.Txt then self:AddText() end -- Add any frame text/labels if provided


 -- Setup Buttons and Button Textures
 local config = ButtonConfigs[self.Name]
 
 for k,v in pairs(config) do
	 local n = v[4]
		local name = self.BaseName .. self.Name .. "Btn" .. n
		local b = lib10:CreateButton(n, name, self.Header, lib10Config)
		b.Name = name

		b:SetState(0, "action", n)
  

  -- [Cat,Battle,Stealth,Shadowform,Possess]: 1 [Prowl,Defensive]: 2, [Bear,Beserker]: 3, Moonkin : 4, 


  if self.Name == "KeyPad" then
--   for k = 1,12 do
    local i = n - 1 -- Keypad Zero Offset
		  b:SetState(1, "action", 60 + i)
	 	 b:SetState(2, "action", 75 + i)
		  b:SetState(3, "action", 90 + i)
		  b:SetState(4, "action", 105 + i)
		  b:SetState(5, "action", 121 + i)
		  b:SetState(6, "action", 64 + i)
		  b:SetState(7, "action", 64 + i)
		  b:SetState(8, "action", 64 + i)
		  b:SetState(9, "action", 64 + i)
		  b:SetState(10, "action", 64 + i)
    
		if i == 9 then -- 9 is 'NUM0' key
			b:SetState(11, "custom", customExitButton)
			b:SetState(12, "custom", customExitButton)
  else
		  b:SetState(11, "action", 121 + i)
		  b:SetState(12, "action", 121 + i)
		end
    
--   end
-- 		b:SetState(k, "action", (k - 1) * 12 + n + 1)
--   for k = 1,14 do
 --			b:SetState(k, "action", 73)
 --		end
 
   --  for k = 1,14 do
 --			b:SetState(k, "action", (k - 1) * 12 + n + 1)
 --		end
--   for i=1,12 do
--		  b:SetState(i, "action", 1)
 --  end
  end
  
  
		b:ClearAllPoints()
		b:SetFrameLevel(self.F:GetFrameLevel() + 1)
		
		b.count:SetFont(SkyUI.Fonts.Memoe, 7, "OUTLINE")
  b.count:ClearAllPoints()
  b.count:SetPoint("BOTTOMRIGHT", 5, -4)
  b.icon:SetTexCoord(0.07, 0.93, .07, 0.93)
	
	 b.CDOverlay = b:CreateTexture(b.Name .. "CDOverlay", "ARTWORK")
		b.CDOverlay:SetAllPoints(b)
  b.CDOverlay:SetTexture(0, 0, 0, 0.75)
  b.CDOverlay:Hide()
  
  b.ItemBG = b:CreateTexture(b.Name .. "ItemBG", "ARTWORK")
  b.ItemBG:SetTexture(0, 0, 0, 0.85)

  b.ActionCD = b:CreateFontString(b.Name .. "ActionCD", "ARTWORK")
  b.ActionCD:SetFont(SkyUI.Fonts.Nasalization, 10, "OUTLINE")
  b.ActionCD:ClearAllPoints()
  b.ActionCD:SetPoint("CENTER", b, 1, 0)
  b.ActionCD:SetText("0")
  b.ActionCD:Hide()

		self.Buttons[n] = b		

 end
	self.F:SetAttribute("state-page", "0")

 self.F:RegisterEvent("PLAYER_ENTERING_WORLD")
 self.F:SetScript("OnEvent", self.EventManager)
 self.F:Show()
	
	CastingBarFrame:UnregisterAllEvents()
	PetCastingBarFrame:UnregisterAllEvents()
	
end

function SkyActionBar.prototype:EventManager(evt, ...)
 if evt == "PLAYER_ENTERING_WORLD" then

 local uiscale = UIParent:GetScale()
 local config = ButtonConfigs[self.sui.Name]

  for i,v in ipairs(config) do
   self.sui.Buttons[v[4]]:SetSize(ButtonSizes[v[3]][1] * uiscale, ButtonSizes[v[3]][2] * uiscale)
   self.sui.Buttons[v[4]]:SetPoint("TOPLEFT", self, "TOPLEFT", v[1] * uiscale, -v[2] * uiscale)
  end

	end

end



--[[
for k,v in pairs(buttonConfigs) do
 local fk = F[k]
 for q,z in ipairs(v) do
  z4 = z[4]
  buttons[z4] = lib10:CreateButton(z4, "SkyUIBtn"..z4, SkyHeader, lib10Config)
  buttons[z4]:ClearAllPoints()
  buttons[z4]:SetState(0, "action", z4)
  buttons[z4]:SetFrameLevel(10)
  buttons[z4].count:SetFont("Interface\\addons\\SkyUI\\Fonts\\MEMOE___.ttf", 7, "OUTLINE")
  buttons[z4].count:ClearAllPoints()
  buttons[z4].count:SetPoint("BOTTOMRIGHT", 5, -4)
  buttons[z4].icon:SetTexCoord(0.07, 0.93, .07, 0.93)

  
  t = buttons[z4]:CreateTexture("$parentCDOverlay", "ARTWORK")
  t:SetAllPoints(buttons[z4])
  t:SetTexture(0, 0, 0, 0.75)
  t:Hide()
  
  t = buttons[z4]:CreateTexture("$parentItemBG", "ARTWORK")
  t:SetTexture(0, 0, 0, 0.85)

  fnt = buttons[z4]:CreateFontString(buttons[z4]:GetName().."SKYUICD", "ARTWORK")
  fnt:SetFont("Interface\\addons\\SkyUI\\Fonts\\nasalization.ttf", 10, "OUTLINE")
  fnt:ClearAllPoints()
  fnt:SetPoint("CENTER", buttons[z4], 1, 0)
  fnt:SetText("0")
  fnt:Hide()

 

  
 end
end
]]--





local UpdateInterval, TimeSinceLastUpdate = 0.1, 0

local UpdatableButtonCooldowns = {}
local cd_i = 0

local function OnUpdateCB(self, elapsed)
 TimeSinceLastUpdate = TimeSinceLastUpdate + elapsed

 if MainMenuBar:IsShown() and not self.InVehicle then MainMenuBar:Hide() end
	
 if (TimeSinceLastUpdate > UpdateInterval) then




  cd_i = cd_i + 1
  if cd_i > 5 then

	  for btn in next, lib10:GetAllButtons() do
    local start, duration, enable = GetActionCooldown(btn.id);
    if start ~= 0 then
     if UpdatableButtonCooldowns[btn] == nil then
      btn.ActionCD:Show()
      btn.CDOverlay:Show()
      UpdatableButtonCooldowns[btn] = true
     end
     cd_i = 0
    end
   end
  end
 
  for btn in next, UpdatableButtonCooldowns do
   local start, duration, enable = GetActionCooldown(btn.id);
   if ( start ~= 0) then
    local d,s = duration - (GetTime() - start)
    if(d > 99) then s = string.format("%i", d / 60).."m"
    elseif(d > 9.9) then s = string.format("%i", d)
    else s = string.format("%.1f", d)
    end
    btn.ActionCD:SetText(s)
   else
    btn.ActionCD:Hide()
    btn.CDOverlay:Hide()
    UpdatableButtonCooldowns[btn] = nil
   end
  end

  TimeSinceLastUpdate = 0
 end

end









local KeyPad = SkyUI_CreateClass(SkyActionBar)
local ArrowPad = SkyUI_CreateClass(SkyActionBar)
local VertBar = SkyUI_CreateClass(SkyActionBar)
local MainBar = SkyUI_CreateClass(SkyActionBar)
local MicroMenu = SkyUI_CreateClass(SkyActionBar)


function MainBar.prototype:init()

 MainBar.super.prototype.init(self, "MainBar")
	
	self.PlayerXP = 0
	
 self.F:RegisterEvent("PLAYER_LOGIN")
 self.F:RegisterEvent("PLAYER_ENTERING_WORLD")
	self.F:RegisterEvent("PLAYER_XP_UPDATE")
 self.F:RegisterEvent("UNIT_ENTERED_VEHICLE")
 self.F:SetScript("OnEvent", self.EventManager)
end

function MainBar.prototype:XPUpdate()
 local xp, m, w = UnitXP("player")
 if self.PlayerXP == xp then return end
 self.PlayerXP = xp
 m = UnitXPMax("player")
 w = (self.PlayerXP / m) * 433
 self.F.XPBarSpan:SetWidth(w)
 self.F.XPBarRight:SetPoint("BOTTOMLEFT", w + 8, 4)
end

function MainBar.prototype:EventManager(evt, ...)
	if evt == "PLAYER_LOGIN" or evt == "PLAYER_XP_UPDATE" then self.sui:XPUpdate()
 elseif evt == "UNIT_ENTERED_VEHICLE" then MainMenuBar:Show() self.InVehicle = true
 elseif evt == "UNIT_EXITED_VEHICLE" then MainMenuBar:Show() self.InVehicle = false
 elseif evt == "PLAYER_ENTERING_WORLD" then MainMenuBar:Hide() end
 MainBar.super.prototype.EventManager(self, evt, ...)
end

function ShowVehicleMenu()
-- frame = EnumerateFrames()
-- while frame do
--   DEFAULT_CHAT_FRAME:AddMessage(frame:GetName() or "Anonymous Frame")
--   frame=EnumerateFrames(frame)
--  end
end

function MicroMenu.prototype:EventManager(evt, ...)
 if evt == "PLAYER_ENTERING_WORLD" then self.sui:InitButtons() end
end

function MicroMenu.prototype:init()
 MicroMenu.super.prototype.init(self, "MicroMenu")

 self.F:RegisterEvent("PLAYER_ENTERING_WORLD")
 self.F:SetScript("OnEvent", self.EventManager)
end

function MicroMenu.prototype:InitButtons()
	self.Buttons = {}
	table.insert(self.Buttons, CharacterMicroButton)
	table.insert(self.Buttons, SpellbookMicroButton)
	table.insert(self.Buttons, TalentMicroButton)
	table.insert(self.Buttons, AchievementMicroButton)
	table.insert(self.Buttons, QuestLogMicroButton)
	table.insert(self.Buttons, GuildMicroButton)
	table.insert(self.Buttons, PVPMicroButton)
	table.insert(self.Buttons, LFDMicroButton)
	table.insert(self.Buttons, MainMenuMicroButton)
	table.insert(self.Buttons, HelpMicroButton)  
		
 local iii
 for k, v in ipairs(self.Buttons) do
  v:SetParent(self.F)
  v:SetFrameLevel(self.F:GetFrameLevel() + 1)
  v:ClearAllPoints()
  v:SetPoint("TOPLEFT", k * 25 - 24, 20)
  v:SetSize(27, 58)
  v:Show()
 end
 self.F:SetScale(0.8)

end





function KeyPad.prototype:init()
 KeyPad.super.prototype.init(self, "KeyPad")
end
function ArrowPad.prototype:init()
 ArrowPad.super.prototype.init(self, "ArrowPad")
end
function VertBar.prototype:init()
 VertBar.super.prototype.init(self, "VertBar")
end


SkyUI.KeyPad = KeyPad:new()
SkyUI.VertBar = VertBar:new()
SkyUI.ArrowPad = ArrowPad:new()
SkyUI.MainBar = MainBar:new()
SkyUI.MicroMenu = MicroMenu:new()


local function ButtonUpdate(ev, btn)
-- local c = btn.count
-- DEFAULT_CHAT_FRAME:AddMessage("!!!")

-- if ({GetActionInfo(btn.id)})[1] == "item" then
--  btn.ItemBG:SetPoint("BOTTOMRIGHT", c, 0, 0)
--  btn.ItemBG:SetSize(c:GetWidth() + 2, c:GetHeight() + 2)
--  btn.ItemBG:Show()
-- else btn.ItemBG:Hide() end

end
SkyBaseClass.Evt:SetScript("OnUpdate", OnUpdateCB)

lib10:RegisterCallback("OnButtonUpdate", ButtonUpdate)
--print(GetVehicleBarIndex())

--  uiscale = UIParent:GetScale()
--  for k,v in pairs(buttonConfigs) do
--   local fk = F[k]
--   for q,z in ipairs(v) do
--    buttons[z[4]]:SetSize(buttonSizes[z[3]][1] * uiscale, buttonSizes[z[3]][2] * uiscale)
--    buttons[z[4]]:SetPoint("TOPLEFT", fk, "TOPLEFT", z[1] * uiscale, -z[2] * uiscale)
--   end
--  end



