if not SimpleUnitFrames or not SimpleUnitFrames:HasModule("Basics") then return end

local moduleName = "player"
local core = SimpleUnitFrames
local L = core.loc.Basics
local Securehook_TargetofTarget_Update

local basics = SimpleUnitFrames:GetModule("Basics")

local OPTION_ORDER = 100
basics.consoleOptions.targettarget = {
	type = 'group',
	name = L['ToT Frame'],
	desc = L['ToT Frame'],
	args = {
		mhp = {
			order = OPTION_ORDER + 1,
			type = 'text',
			name = L['Middle Health Text'],
			desc = L['Middle Health Text Description'],
			get = function() return basics.db.profile.targettarget.mhp end,
			set = function(v) 
							basics.db.profile.targettarget.mhp = v
							Securehook_TargetofTarget_Update()
						end,
			validate = basics.formatList,
		},
		rhp = {
			order = OPTION_ORDER + 2,
			type = 'text',
			name = L['Right Health Text'],
			desc = L['Right Health Text Description'],
			get = function() return basics.db.profile.targettarget.rhp end,
			set = function(v) 
							basics.db.profile.targettarget.rhp = v
							Securehook_TargetofTarget_Update()
						end,
			validate = basics.formatList,
		},
		mmp = {
			order = OPTION_ORDER + 3,
			type = 'text',
			name = L['Middle Mana Text'],
			desc = L['Middle Mana Text Description'],
			get = function() return basics.db.profile.targettarget.mmp end,
			set = function(v)
							basics.db.profile.targettarget.mmp = v
							Securehook_TargetofTarget_Update()
						end,
			validate = basics.formatList,
		},
		rmp = {
			order = OPTION_ORDER + 4,
			type = 'text',
			name = L['Right Mana Text'],
			desc = L['Right Mana Text Description'],
			get = function() return basics.db.profile.targettarget.rmp end,
			set = function(v)
							basics.db.profile.targettarget.rmp = v
							Securehook_TargetofTarget_Update()
						end,
			validate = basics.formatList,
		},
	}
}

basics.defaultOptions.targettarget = {
	mhp = "HPpercent",
	rhp = "HPcurrmax",
	mmp = "MPpercent",
	rmp = "MPcurrmax",
}

basics.frameSettings.targettarget = {
	parent = TargetofTargetFrame,
	texts = {
		mhp = {
			point = { "TOPRIGHT", TargetofTargetHealthBar, "TOPRIGHT", 0, 2 },
		},
		rhp = {
			point = { "TOPLEFT", TargetofTargetHealthBar, "TOPRIGHT", 32, 2 },
		},
		mmp = {
			point = { "TOPRIGHT", TargetofTargetManaBar, "TOPRIGHT", 0, 2 },
		},
		rmp = {
			point = { "TOPLEFT", TargetofTargetManaBar, "TOPRIGHT", 32, 2 },
		},
	},
}

function Securehook_TargetofTarget_Update()
	if TargetofTargetFrame:IsShown() then
		basics:Refresh("targettarget")
	end
end

-- ToT Frame cannot use UNIT_ events.
hooksecurefunc("TargetofTarget_Update", Securehook_TargetofTarget_Update )

