if not SimpleUnitFrames or not SimpleUnitFrames:HasModule("Basics") then return end

local moduleName = "player"
local core = SimpleUnitFrames
local L = core.loc.Basics

local basics = SimpleUnitFrames:GetModule("Basics")

local OPTION_ORDER = 100
basics.consoleOptions.target = {
	type = 'group',
	name = L['Target Frame'],
	desc = L['Target Frame'],
	args = {	
		hp = {
			order = OPTION_ORDER + 1,
			type = 'text',
			name = L['Health Text'],
			desc = L['Health Text Description'],
			get = function() return basics.db.profile.target.hp end,
			set = function(v) 
							basics.db.profile.target.hp = v
							basics:Refresh('target')
						end,
			validate = basics.formatList,
		},
		mp = {
			order = OPTION_ORDER + 2,
			type = 'text',
			name = L['Mana Text'],
			desc = L['Mana Text Description'],
			get = function() return basics.db.profile.target.mp end,
			set = function(v)
							basics.db.profile.target.mp = v
							basics:Refresh('target')
						end,
			validate = basics.formatList,
		},
		class = {
			order = OPTION_ORDER + 5,
			type = 'toggle',
			name = L['Class Icon'],
			desc = L['Class Icon Description'],
			get = function() return basics.db.profile.target.class end,
			set = function(v)
				basics.db.profile.target.class = v
				basics:UpdateClassIcon('target')
			end
		}
	}
}

basics.defaultOptions.target = {
	hp = "HPcomplete",
	mp = "MPcomplete",
	class = true,
}

basics.frameSettings.target = {
	parent = TargetFrame,
	texts = {
		hp = {
			point = { "TOP", TargetFrameHealthBar, "TOP" },
		},
		mp = {
			point = { "TOP", TargetFrameManaBar, "TOP" },
		},
	},
	classIcon = {
		size = 32,
		point = { "TOPRIGHT", TargetFrame, "TOPRIGHT", -85, -5 },
	},
}

local Target = SimpleUnitFrames:NewModule("Target", "AceEvent-2.0")

function Target:OnInitialize()
	-- Disable the "Dead" text of Target Frame.
	TargetDeadText:SetText()
end

function Target:OnEnable()
	self:RegisterEvent("PLAYER_TARGET_CHANGED")
end

function Target:PLAYER_TARGET_CHANGED()
	basics:Refresh("target")
end
