local NEW_MAX_TARGET_BUFFS = 16

local OnLoad
local Count
local ResizeOriginals
local Adjust

function OnLoad()
	local points = {
		[6] = { "LEFT", "TargetFrameBuff5", "RIGHT", 3, 0 },
		[7] = { "TOPLEFT", "TargetFrameBuff1", "BOTTOMLEFT", 0, -3 },
		[8] = { "LEFT", "TargetFrameBuff7", "RIGHT", 3, 0 },
		[9] = { "LEFT", "TargetFrameBuff8", "RIGHT", 3, 0 },
		[10] = { "LEFT", "TargetFrameBuff9", "RIGHT", 3, 0 },
		[11] = { "LEFT", "TargetFrameBuff10", "RIGHT", 3, 0 },
		[12] = { "LEFT", "TargetFrameBuff11", "RIGHT", 3, 0 },
		[13] = { "LEFT", "TargetFrameBuff12", "RIGHT", 3, 0 },
		[14] = { "LEFT", "TargetFrameBuff13", "RIGHT", 3, 0 },
		[15] = { "LEFT", "TargetFrameBuff14", "RIGHT", 3, 0 },
		[16] = { "LEFT", "TargetFrameBuff15", "RIGHT", 3, 0 },
	}
	for i,point in ipairs(points) do
		local button = CreateFrame("Button", nil, TargetFrame, "TargetBuffButtonTemplate")
		button:SetWidth(17)
		button:SetHeight(17)
		button:SetPoint(unpack(point))
	end
	hooksecurefunc("TargetDebuffButton_Update", Adjust)
end

function Count()
	local i = 0
	while UnitBuff("target", i + 1) do
		i = i + 1
	end
	return i
end

function ResizeOriginals(size)
	for i=1, 5 do
		local button = _G["TargetFrameBuff" .. i]
		if button then
			button:SetWidth(size)
			button:SetHeight(size)
		end
	end
	for i=1, 6 do
		local button = _G["TargetFrameDebuff" .. i]
		local frame = _G["TargetFrameDebuff" .. i .. "Border"]
		if button then
			button:SetWidth(size)
			button:SetHeight(size)
		end
		if frame then
			frame:SetWidth(size + 2)
			frame:SetHeight(size + 2)
		end
	end
end

function Adjust()

	-- buffs up to MAX_TARGET_BUFFS are handled by the standard Blizzard code
	for i=MAX_TARGET_BUFFS+1, NEW_MAX_TARGET_BUFFS do
		local name, rank, icon, count = UnitBuff("target", i)
		local button = _G["TargetFrameBuff"..i]
		if ( icon ) then
			_G["TargetFrameBuff"..i.."Icon"]:SetTexture(icon)
			local buffCount = _G["TargetFrameBuff"..i.."Count"]
			button:Show()
			if ( count > 1 ) then
				buffCount:SetText(count)
				buffCount:Show()
			else
				buffCount:Hide()
			end
			button.id = i
		else
			button:Hide()
		end
	end

	if UnitIsFriend("player", "target") then
		local buffs = Count()
		if buffs > MAX_TARGET_BUFFS then
	
			ResizeOriginals(17)
			TargetFrameBuff6:ClearAllPoints()
			TargetFrameBuff7:ClearAllPoints()
			TargetFrameBuff11:ClearAllPoints()
			TargetFrameDebuff1:ClearAllPoints()
			if TargetofTargetFrame:IsShown() then
				-- 5/5/6 buff layout
				TargetFrameBuff6:SetPoint("TOPLEFT", "TargetFrameBuff1", "BOTTOMLEFT", 0, -2)
				TargetFrameBuff7:SetPoint("LEFT", "TargetFrameBuff6", "RIGHT", 3, 0)
				TargetFrameBuff11:SetPoint("TOPLEFT", "TargetFrameBuff6", "BOTTOMLEFT", 0, -2)
				if buffs > 10 then
					TargetFrameDebuff1:SetPoint("TOPLEFT", "TargetFrameBuff11", "BOTTOMLEFT", 0, -2)
				else
					TargetFrameDebuff1:SetPoint("TOPLEFT", "TargetFrameBuff6", "BOTTOMLEFT", 0, -2)
				end
			else
				-- 6/10 buff layout
				TargetFrameBuff6:SetPoint("LEFT", "TargetFrameBuff5", "RIGHT", 3, 0)
				TargetFrameBuff7:SetPoint("TOPLEFT", "TargetFrameBuff1", "BOTTOMLEFT", 0, -2)
				TargetFrameBuff11:SetPoint("LEFT", "TargetFrameBuff10", "RIGHT", 3, 0)
				if buffs > 6 then
					TargetFrameDebuff1:SetPoint("TOPLEFT", "TargetFrameBuff7", "BOTTOMLEFT", 0, -2)
				else
					TargetFrameDebuff1:SetPoint("TOPLEFT", "TargetFrameBuff1", "BOTTOMLEFT", 0, -2)
				end
			end
		end
	end
end


OnLoad()