if not SimpleUnitFrames or not SimpleUnitFrames:HasModule("Basics") then return end

local core = SimpleUnitFrames
local L = core.loc.Basics

local basics = core:GetModule("Basics")

local OPTION_ORDER = 100
basics.consoleOptions.player = {
	type = 'group',
	name = L['Player Frame'],
	desc = L['Player Frame'],
	args = {	
		mhp = {
			order = OPTION_ORDER + 1,
			type = 'text',
			name = L['Middle Health Text'],
			desc = L['Middle Health Text Description'],
			get = function() return basics.db.profile.player.mhp end,
			set = function(v) 
							basics.db.profile.player.mhp = v
							basics:Refresh('player')
						end,
			validate = basics.formatList,
		},
		rhp = {
			order = OPTION_ORDER + 2,
			type = 'text',
			name = L['Right Health Text'],
			desc = L['Right Health Text Description'],
			get = function() return basics.db.profile.player.rhp end,
			set = function(v) 
							basics.db.profile.player.rhp = v
							basics:Refresh('player')
						end,
			validate = basics.formatList,
		},
		mmp = {
			order = OPTION_ORDER + 3,
			type = 'text',
			name = L['Middle Mana Text'],
			desc = L['Middle Mana Text Description'],
			get = function() return basics.db.profile.player.mmp end,
			set = function(v)
							basics.db.profile.player.mmp = v
							basics:Refresh('player')
						end,
			validate = basics.formatList,
		},
		rmp = {
			order = OPTION_ORDER + 4,
			type = 'text',
			name = L['Right Mana Text'],
			desc = L['Right Mana Text Description'],
			get = function() return basics.db.profile.player.rmp end,
			set = function(v)
							basics.db.profile.player.rmp = v
							basics:Refresh('player')
						end,
			validate = basics.formatList,
		},
		class = {
			order = OPTION_ORDER + 5,
			type = 'toggle',
			name = L['Class Icon'],
			desc = L['Class Icon Description'],
			get = function() return basics.db.profile.player.class end,
			set = function(v)
				basics.db.profile.player.class = v
				basics:UpdateClassIcon('player')
			end
		}
	}
}

basics.defaultOptions.player = {
	mhp = "HPcurrmax",
	rhp = "HPpercent",
	mmp = "MPcurrmax",
	rmp = "MPpercent",
	class = true
}

basics.frameSettings.player = {
	parent = PlayerFrame,
	texts = {
		mhp = {
			point = { "TOP", PlayerFrameHealthBar, "TOP" },
		},
		rhp = {
			point = { "TOPLEFT", PlayerFrameHealthBar, "TOPRIGHT", 5, 0 },
		},
		mmp = {
			point = {"TOP", PlayerFrameManaBar, "TOP" },
		},
		rmp = {
			point = { "TOPLEFT", PlayerFrameManaBar, "TOPRIGHT", 5, 0 },
		},
	},
	classIcon = {
		size = 32,
		point = { "TOPLEFT", PlayerFrame, "TOPLEFT", 85, -5 },
	},
}

local function HideMe(fontString)
	fontString:Hide()
end


-- Disable the default player HP/MP text.
hooksecurefunc(PlayerFrameHealthBar.TextString, "Show", HideMe)
hooksecurefunc(PlayerFrameManaBar.TextString, "Show", HideMe)

