if not SimpleUnitFrames or not SimpleUnitFrames:HasModule("Basics") then return end

local core = SimpleUnitFrames
local L = core.loc.Basics

local basics = SimpleUnitFrames:GetModule("Basics")

local OPTION_ORDER = 100
basics.consoleOptions.pet = {
	type = 'group',
	name = L['Pet Frame'],
	desc = L['Pet Frame'],
	args = {	
		mhp = {
			order = OPTION_ORDER + 1,
			type = 'text',
			name = L['Middle Health Text'],
			desc = L['Middle Health Text Description'],
			get = function() return basics.db.profile.pet.mhp end,
			set = function(v) 
							basics.db.profile.pet.mhp = v
							basics:Refresh('pet')
						end,
			validate = basics.formatList,
		},
		rhp = {
			order = OPTION_ORDER + 2,
			type = 'text',
			name = L['Right Health Text'],
			desc = L['Right Health Text Description'],
			get = function() return basics.db.profile.pet.rhp end,
			set = function(v) 
							basics.db.profile.pet.rhp = v
							basics:Refresh('pet')
						end,
			validate = basics.formatList,
		},
		mmp = {
			order = OPTION_ORDER + 3,
			type = 'text',
			name = L['Middle Mana Text'],
			desc = L['Middle Mana Text Description'],
			get = function() return basics.db.profile.pet.mmp end,
			set = function(v)
							basics.db.profile.pet.mmp = v
							basics:Refresh('pet')
						end,
			validate = basics.formatList,
		},
		rmp = {
			order = OPTION_ORDER + 4,
			type = 'text',
			name = L['Right Mana Text'],
			desc = L['Right Mana Text Description'],
			get = function() return basics.db.profile.pet.rmp end,
			set = function(v)
							basics.db.profile.pet.rmp = v
							basics:Refresh('pet')
						end,
			validate = basics.formatList,
		},
	}
}

basics.defaultOptions.pet = {
	mhp = "HPpercent",
	rhp = "HPcurrmax",
	mmp = "MPpercent",
	rmp = "MPcurrmax",
}

basics.frameSettings.pet = {
	parent = PetFrame,
	texts = {
		mhp = {
			point = { "TOP", "PetFrameHealthBar", "TOP", 0, 2 },
		},
		rhp = {
			point = { "TOPLEFT", "PetFrameHealthBar", "TOPRIGHT", 1, 2 },
		},
		mmp = {
			point = { "TOP", "PetFrameManaBar", "TOP", 0, 0 },
		},
		rmp = {
			point = { "TOPLEFT", "PetFrameManaBar", "TOPRIGHT", 1, 0 },
		},
	},
}

-- Disable the default HP/MP text.
local HideMe = function(fontString) fontString:Hide() end
hooksecurefunc(PetFrameHealthBar.TextString, "Show", HideMe)
hooksecurefunc(PetFrameManaBar.TextString, "Show", HideMe)
