if not SimpleUnitFrames or not SimpleUnitFrames:HasModule("Basics") then return end

local core = SimpleUnitFrames
local L = core.loc.Basics

local basics = core:GetModule("Basics")


core.CopyTable(basics.unitMap, {
	partypet1 = "partypet",
	partypet2 = "partypet",
	partypet3 = "partypet",
	partypet4 = "partypet",
} )


basics.defaultOptions.partypet = {
	hp = "HPcurrmax",
}

basics.consoleOptions.partypet = {
	type = 'group',
	name = L['Party Pet Frame'],
	desc = L['Party Pet Frame'],
	args = {	
		hp = {
			type = 'text',
			name = L['Health Text'],
			desc = L['Health Text Description'],
			get = function() return basics.db.profile.partypet.hp end,
			set = function(v) 
				basics.db.profile.partypet.hp = v
				for i=1, GetNumPartyMembers() do
					basics:Refresh('partypet'..i)
				end
			end,
			validate = basics.formatList,
		}
	}
}

local frameSettings = basics.frameSettings
for i=1, 4 do
	local partypetFrame = getglobal("PartyMemberFrame" .. i .. "PetFrame")
	frameSettings["partypet"..i] = {
		parent = partypetFrame,
		texts = {
			hp = {
				point = { "TOPLEFT", partypetFrame, "TOPLEFT", 60, -4 },
			},
		},
	}
end

