if not SimpleUnitFrames or not SimpleUnitFrames:HasModule("Basics") then return end

local core = SimpleUnitFrames
local L = core.loc.Basics

local basics = core:GetModule("Basics")
local Party = core:NewModule("Party", "AceEvent-2.0")

local OPTION_ORDER = 100

core.CopyTable(basics.unitMap, {
	party1 = "party",
	party2 = "party",
	party3 = "party",
	party4 = "party",
} )

basics.consoleOptions.party = {
	type = 'group',
	name = L['Party Frame'],
	desc = L['Party Frame'],
	args = {	
		mhp = {
			order = OPTION_ORDER + 1,
			type = 'text',
			name = L['Middle Health Text'],
			desc = L['Middle Health Text Description'],
			get = function() return basics.db.profile.party.mhp end,
			set = function(v) 
							basics.db.profile.party.mhp = v
							basics:Refresh()
						end,
			validate = basics.formatList,
		},
		rhp = {
			order = OPTION_ORDER + 2,
			type = 'text',
			name = L['Right Health Text'],
			desc = L['Right Health Text Description'],
			get = function() return basics.db.profile.party.rhp end,
			set = function(v) 
							basics.db.profile.party.rhp = v
							basics:Refresh()
						end,
			validate = basics.formatList,
		},
		mmp = {
			order = OPTION_ORDER + 3,
			type = 'text',
			name = L['Middle Mana Text'],
			desc = L['Middle Mana Text Description'],
			get = function() return basics.db.profile.party.mmp end,
			set = function(v)
							basics.db.profile.party.mmp = v
							basics:Refresh()
						end,
			validate = basics.formatList,
		},
		rmp = {
			order = OPTION_ORDER + 4,
			type = 'text',
			name = L['Right Mana Text'],
			desc = L['Right Mana Text Description'],
			get = function() return basics.db.profile.party.rmp end,
			set = function(v)
							basics.db.profile.party.rmp = v
							basics:Refresh()
						end,
			validate = basics.formatList,
		},
		class = {
			order = OPTION_ORDER + 5,
			type = 'toggle',
			name = L['Class Icon'],
			desc = L['Class Icon Description'],
			get = function() return basics.db.profile.party.class end,
			set = function(v)
				basics.db.profile.party.class = v
				for i=1, GetNumPartyMembers() do
					basics:UpdateClassIcon('party'..i)
				end
			end
		}
	}
}

basics.defaultOptions.party = {
	mhp = "HPpercent",
	rhp = "HPcurrmax",
	mmp = "MPpercent",
	rmp = "MPcurrmax",
	class = true
}

local frameSettings = basics.frameSettings
for i=1, 4 do
	local partyFrame = "PartyMemberFrame" .. i
	frameSettings["party"..i] = {
		parent = _G[partyFrame],
		classIcon = {
			size = 24,
			point = { "TOPLEFT", partyFrame, "TOPLEFT", 30, 0 },
		},
		texts = {
			mhp = {
				point = { "TOP", partyFrame.."HealthBar", "TOP", 0, 1 },
			},
			rhp = {
				point = { "TOPLEFT", partyFrame.."HealthBar", "TOPRIGHT", 2, 1 },
			},
			mmp = {
				point = { "TOP", partyFrame.."ManaBar", "TOP", 0, 1 },
			},
			rmp = {
				point = { "TOPLEFT", partyFrame.."ManaBar", "TOPRIGHT", 2, 1 },
			},
		},
	}
end



function Party:OnEnable()
	self:RegisterEvent("PARTY_MEMBERS_CHANGED")
	local function HideMe(fontString)
		fontString:Hide()
	end

	-- Disable the default party HP/MP text.
	for i=1, 4 do
		hooksecurefunc(_G["PartyMemberFrame"..i.."HealthBar"].TextString, "Show", HideMe)
		hooksecurefunc(_G["PartyMemberFrame"..i.."ManaBar"].TextString, "Show", HideMe)
	end
	

end

function Party:PARTY_MEMBERS_CHANGED()
	for i=1, GetNumPartyMembers(), 1 do
		local unit = "party"..i
		basics:Refresh(unit)
		basics:UpdateClassIcon(unit)
	end
end

