if not SimpleUnitFrames or not FocusFrame then return end


if SimpleUnitFrames:HasModule("Basics") then

	local core = SimpleUnitFrames
	local L = core.loc.Basics
	L["Focus Frame"] = "Focus Frame"

	local basics = SimpleUnitFrames:GetModule("Basics")
	
	if FocusFrameHealthBarText then
		hooksecurefunc(FocusFrameHealthBarText, "Show", FocusFrameHealthBarText.Hide)
	end
	if FocusFrameManaBarText then
		hooksecurefunc(FocusFrameManaBarText, "Show", FocusFrameManaBarText.Hide)
	end

	local OPTION_ORDER = 100
	basics.consoleOptions.focus = {
		type = 'group',
		name = L['Focus Frame'],
		desc = L['Focus Frame'],
		args = {	
			hp = {
				order = OPTION_ORDER + 1,
				type = 'text',
				name = L['Health Text'],
				desc = L['Health Text Description'],
				get = function() return basics.db.profile.focus.hp end,
				set = function(v) 
								basics.db.profile.focus.hp = v
								basics:Refresh('focus')
							end,
				validate = basics.formatList,
			},
			mp = {
				order = OPTION_ORDER + 2,
				type = 'text',
				name = L['Mana Text'],
				desc = L['Mana Text Description'],
				get = function() return basics.db.profile.focus.mp end,
				set = function(v)
								basics.db.profile.focus.mp = v
								basics:Refresh('focus')
							end,
				validate = basics.formatList,
			},
			class = {
				order = OPTION_ORDER + 5,
				type = 'toggle',
				name = L['Class Icon'],
				desc = L['Class Icon Description'],
				get = function() return basics.db.profile.focus.class end,
				set = function(v)
					basics.db.profile.focus.class = v
					basics:UpdateClassIcon('focus')
				end
			},
		}
	}

	basics.defaultOptions.focus = {
		hp = "HPcomplete",
		mp = "MPcomplete",
		class = true,
	}

	basics.frameSettings.focus = {
		parent = FocusFrame,
		texts = {
			hp = {
				point = { "TOP", FocusFrameHealthBar, "TOP" },
			},
			mp = {
				point = { "TOP", FocusFrameManaBar, "TOP" },
			},
		},
		classIcon = {
			size = 32,
			point = { "TOPRIGHT", FocusFrame, "TOPRIGHT", -85, -5 },
		},
	}

	local Focus = SimpleUnitFrames:NewModule("Focus", "AceEvent-2.0")

	function Focus:OnInitialize()
		FocusDeadText:SetText()
	end
	function Focus:OnEnable()
		self:RegisterEvent("PLAYER_FOCUS_CHANGED")
	end

	function Focus:PLAYER_FOCUS_CHANGED()
		basics:Refresh("focus")
		basics:UpdateClassIcon("focus")
	end
end


if SimpleUnitFrames:HasModule("PortraitDamage") then

	local PortraitDamage = SimpleUnitFrames:GetModule("PortraitDamage")

	PortraitDamage.frameSettings.focus = {
		parent = FocusFrame,
		font = "NumberFontNormalHuge",
		point = { "Center", FocusPortrait, "CENTER" },
		size = 30,
	}


end

