local moduleName = "PortraitDamage"
local core = SimpleUnitFrames

-- If the module has already been created this will prevent recreation of the module.
if core:HasModule(moduleName) then return end

local L = core.loc.PortraitDamage
local OnEvent
local OnUpdate
local CreateDamageFrame


local PortraitDamage = core:NewModule(moduleName)

PortraitDamage.unitMap = {}
PortraitDamage.consoleOptions = {}
PortraitDamage.defaultOptions = {} 
PortraitDamage.frameSettings = {}


function PortraitDamage:OnInitialize()

	self.db = core:AcquireDBNamespace(moduleName)
	
	self.frames = {}

	for unit in pairs(self.frameSettings) do
		if not self.unitMap[unit] then
			self.unitMap[unit] = unit
		end
		local mappedUnit = self.unitMap[unit] or unit
		self.defaultOptions[mappedUnit] = true
		if not self.consoleOptions[mappedUnit] then
			self.consoleOptions[mappedUnit] = {
				type = 'toggle',
				name = L[mappedUnit] or mappedUnit,
				desc = L[mappedUnit] or mappedUnit,
				get = function()
					return self.db.profile[mappedUnit]
				end,
				set = function(v)
					self.db.profile[mappedUnit] = v
					self:RefreshSettings()
				end,
			}
		end
	end

	core:RegisterDefaults(moduleName, 'profile', self.defaultOptions)
	
	self:RefreshSettings(unit)
	
	core.consoleOptions.args.portrait = {
		order = 200,
		type = 'group',
		name = L["Portrait Damage"],
		desc = L["Toggle the display of Portrait Damage on specific frame."],
		args = self.consoleOptions,
	}
	


end

function PortraitDamage:RefreshSettings(unit)
	if unit ~= nil then
	
		local mappedUnit = self.unitMap[unit] or unit
		
		if self.db.profile[mappedUnit] then 
			
			if not self.frames[unit] and self.frameSettings[unit] then
				self.frames[unit] = CreateDamageFrame(unit, self.frameSettings[unit])
				self.frameSettings[unit] = nil
			end
			
			if self.frames[unit] then
				self.frames[unit]:RegisterEvent("UNIT_COMBAT")
				self.frames[unit]:SetScript("OnUpdate", OnUpdate)
			end
			
		else
		
			if self.frames[unit] then
				self.frames[unit]:UnregisterAllEvents()
				self.frames[unit]:SetScript("OnUpdate", nil)
				self.frames[unit].fontString:SetText("")
				self.frames[unit].fontString:Hide()
			end
			
		end
		
	else
		
		for unit in pairs(self.unitMap) do	
			self:RefreshSettings(unit)
		end
		
	end
	
end

function CreateDamageFrame(unit, settings)

	local parent = settings.parent
	local frame = CreateFrame("Frame", nil, parent)
	frame:SetFrameLevel(parent:GetFrameLevel()+2)
	
	-- It seems some frames might change their frameLevel, so adjust this.
	--hooksecurefunc(parent, "Show", function() frame:SetFrameLevel(parent:GetFrameLevel()+1) end)
	frame.unit = unit
	
	local parentFont = settings.font
	if not parentFont then
		parentFont = "NumberFontNormalHuge"
	end
	local font = frame:CreateFontString(nil, "OVERLAY", parentFont)
	font:SetPoint(unpack(settings.point))
	font:Hide()
	frame.fontString = font
	
	frame:SetScript("OnEvent", OnEvent)

	-- A quick hack to get around the 'this' requirement of CombatFeedback_Initialize
	local oldThis = _G.this
	_G.this = frame
	CombatFeedback_Initialize(font, settings.size)
	_G.this = oldThis
	
	return frame

end

function OnEvent(frame, event, arg1, arg2, arg3, arg4, arg5)
	if arg1 == this.unit then
		CombatFeedback_OnCombatEvent(arg2, arg3, arg4, arg5)
	end
end

function OnUpdate(arg1)
	CombatFeedback_OnUpdate(arg1)
end

