local SUF = AceLibrary("AceAddon-2.0"):new("AceModuleCore-2.0", "AceDB-2.0", "AceConsole-2.0")

SUF.loc = {}

--[[
	CopyTable(into, from) : Updates 'into' with the vaues in 'from'
	- Deep copy the table
	- Copy key to value for the case: "key" = true
--]]
local function CopyTable(to, from, overwrite)
	for k, v in pairs(from) do
		if overwrite or to[k] == nil then
			if type(v) == 'table' then
				if not to[k] then
					to[k] = {}
				end
				CopyTable(to[k], v, overwrite)
			elseif v == true then
				to[k] = k -- Special case.
			else
				to[k] = v
			end
		elseif type(v) == 'table' and type(to[k]) == 'table' then
			CopyTable(to[k], v, overwrite)
		end
	end
	return to
end



SUF.CopyTable = CopyTable

function SUF:OnInitialize()

	self:RegisterDB("SimpleUnitFramesDB", "SimpleUnitFramesDBPerChar")

	local consoleOptions = {
		type = 'group',
		args = {}
	}

	self:RegisterChatCommand( { '/suf' }, consoleOptions )
	
	-- This only works after RegisterChatCommand().
	consoleOptions.args.standby = nil
	
	self.consoleOptions = consoleOptions
	
	self.loc = nil
	
end

function SUF:OnEnable()

end

function SUF:OnDisable()
	for name, module in self:IterateModules() do
		if module.OnDisable then
			module:OnDisable()
		end
	end
end

-- Save the table as base locales if there isn't one, update the current locales if there is one.
function SUF:UpdateLocales(loc)
	CopyTable(self.loc, loc, true)
end


setglobal('SimpleUnitFrames', SUF)
