--[[
SimpleMD - Copyright (C) 2008 Michael Joseph Murray aka Starinnia of Lothar
$Revision: 69360 $
$Date: 2008-04-12 17:00:26 -0400 (Sat, 12 Apr 2008) $
contact: codemaster2010@gmail.com
-----------------------------------------------------------------------------------------
This addon is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.0 of the License, or (at your option) any later version.

This addon is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
]]

local PlayerName = UnitName("player")
local SpellTarget
local rev = tonumber(("$Revision: 69360 $"):match("%d+"))
local addonID = "SimpleMD - r"..rev

SimpleMD = AceLibrary("AceAddon-2.0"):new("AceEvent-2.0", "AceConsole-2.0", "AceDB-2.0", "AceComm-2.0", "Sink-1.0")
local DD = AceLibrary("Dewdrop-2.0")
local SML = LibStub("LibSharedMedia-2.0")
local L = AceLibrary("AceLocale-2.2"):new("SimpleMD")

function SimpleMD:OnInitialize()
	--set DB, defaults and CommPrefix
	SimpleMD:RegisterDB("SimplemdDB")
	SimpleMD:RegisterDefaults('profile', self.defaults)
	SimpleMD:SetCommPrefix("SimpleMD")
	
	--anchor and frame for OnUpdate stuff
	self.anchor, self.frame = self:CreateAnchor(addonID)
	--table for holding refs to timers
	self.anchor.timers = {}
	self.timercount = 0
	--recycle the old timers, less garbage = good
	self.recyclePile = {}
	--who has active timers?
	self.idents = {}
	--stubs
	self.gain = ""
	self.fade = ""
	DD:Register(self.anchor, "children", self.MenuRequest, 'cursorX', true, 'cursorY', true)
end

function SimpleMD:OnEnable()
	--set the texture for the bar icons
	self.tex = [[Interface\Icons\Ability_Hunter_Misdirection]]
	
	--register the comm
	self:RegisterComm("SimpleMD", "GROUP", "OnCommReceive")
	
	--register needed UNIT and SIMPLEMD events
	self:RegisterEvent("RAID_ROSTER_UPDATE", "RaidStatus") --to clear static bars after leaving a raid
	self:RegisterEvent("UNIT_SPELLCAST_SENT", "GetSpellTarget")
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED", "GetCastInfo")
	self:RegisterEvent("SIMPLEMD_MISDIRECT_CD", "CooldownBroadcast")
	self:RegisterEvent("SIMPLEMD_TESTBARS", "ClearTimers")
end

function SimpleMD:OnDisable()
	self:UnregisrerAllEvents()
	self.tex = nil
end

--because the old way I did this was very messy and only worked 90% of the time...
local function stringParse(str, char)
	local _, stop = string.find(str, char)
	
	return string.sub(str, stop+1)
end

local target
function SimpleMD:OnCommReceive(prefix, sender, distro, message)
	--check to see if message is another user broadcasting a MD cast
	--message should be SMDGAIN-target_name
	if string.find(message, "SMDGAIN-") then
		target = stringParse(message, "-")
		if self.db.profile.showBars then
			self:CreateTimer(sender, target, 120, self.db.profile.reverse, self.db.profile.stay, self.db.profile.growUp)
		end
		if self.db.profile.showGain then
			self.gain = string.gsub(self.db.profile.messageGain, "<player>", sender)
			self.gain = string.gsub(self.gain, "<target>", target)
			self:PrintMessage(self.gain, 2)
		end
	end
	--check to see if message is another user broadcasting a MD fade
	--message should be SMDFADE-target_name
	if string.find(message, "SMDFADE-") then
		if self.db.profile.showFade then
			target = stringParse(message, "-")
			self.fade = string.gsub(self.db.profile.messageFade, "<player>", sender)
			self.fade = string.gsub(self.fade, "<target>", target)
			self:PrintMessage(self.fade, 2)
		end
		--if CD bars are being used, change the color to the normal choice from the special signifying active charges
		if self.db.profile.showBars then
			for k, v in pairs(self.idents) do
				if v == sender then
					self.anchor.timers[k].timer:SetStatusBarColor(self.db.profile.barR, self.db.profile.barG, self.db.profile.barB, 1)
				end
			end
		end
	end
	--user used readiness
	if message == "SMDREADINESS" then
		if self.db.profile.showReadiness then
			self:PrintMessage(sender .. " " .. self.db.profile.readiness, 2)
		end
		if self.db.profile.showBars then
			self:ReadinessCheck(sender)
		end
	end
	--sixty seconds left
	if message == "SMDSIXTY" and self.db.profile.sixty then
		self:PrintMessage(sender .. " " .. self.db.profile.sixtyCD, 2)
	end
	--thirty seconds left
	if message == "SMDTHIRTY" and self.db.profile.thirty then
		self:PrintMessage(sender .. " " .. self.db.profile.thirtyCD, 2)
	end
	--ten seconds left
	if message == "SMDTEN" and self.db.profile.ten then
		self:PrintMessage(sender .. " " .. self.db.profile.tenCD, 2)
	end
	--MD ready
	if message == "SMDREADY" and self.db.profile.ready then
		self:PrintMessage(sender .. " " .. self.db.profile.noCD, 2)
	end
	target = nil
end

function SimpleMD:PrintMessage(message, id)
	--id of 1 signifies an internal source of the message
	-- ie. messages the local client is printing
	-- these messages include SCT/UI Error Frame/Chat Log
	--but also your broadcast to the party chat/raid chat/raid warning/custom channel
	if id == 1 then
		--print to chat frame
		if self.db.profile.showInChat and self.db.profile.showSelf then
			self:Print(message)
		end
		--print to Error Message frame
		if self.db.profile.showOnScreen and self.db.profile.showSelf then
			UIErrorsFrame:AddMessage(message, self.db.profile.r, self.db.profile.g, self.db.profile.b, 5.0)
		end
		--print to Party chat
		if self.db.profile.showParty and GetNumRaidMembers() == 0 then
			SendChatMessage(message, "PARTY")
		end
		--print to Raid Chat
		if self.db.profile.showRaid and UnitInRaid("player") then
			SendChatMessage(message, "RAID")
		end
		--print to Raid Warning
		if (IsRaidLeader() or IsRaidOfficer()) and self.db.profile.showRW then
			SendChatMessage(message, "RAID_WARNING")
		end
		-- print to custom channel
		if self.db.profile.showInChannel and self.db.profile.channel ~= "" then
			SendChatMessage(message, "CHANNEL", GetDefaultLanguage("player"), GetChannelName(self.db.profile.channel))
		end
		--print to Scrolling Text
		if self.db.profile.showFloating and self.db.profile.showSelf then
			self:Pour(message, self.db.profile.r, self.db.profile.g, self.db.profile.b)
		end
	end
	
	-- id of 2 signifies an external source of the message
	-- ie. We are locally printing message sent by other users
	-- this block should never have raid/party/raid warning/channel prints inside
	if id == 2 then
		--print to Scrolling Text mod
		if self.db.profile.showFloating then
			self:Pour(message, self.db.profile.r, self.db.profile.g, self.db.profile.b)
		end
		--print to chat frame
		if self.db.profile.showInChat then
			self:Print(message)
		end
		--print to error frame
		if self.db.profile.showOnScreen then
			UIErrorsFrame:AddMessage(message, self.db.profile.r, self.db.profile.g, self.db.profile.b, 5.0)
		end
	end
end

function SimpleMD:Gain()
	--if we're not all alone and people care about our misdirects
	if GetNumPartyMembers() > 0 or GetNumRaidMembers() > 0 then
		self.gain = string.gsub(self.db.profile.messageGain, "<player>", PlayerName)
		self.gain = string.gsub(self.gain, "<target>", SpellTarget)
		
		if self.db.profile.showBars then
			self:CreateTimer(PlayerName, SpellTarget, 120, self.db.profile.reverse, self.db.profile.stay, self.db.profile.growUp)
		end
		
		if self.db.profile.showGain then
			self:PrintMessage(self.gain, 1)
		end
		self:SendCommMessage("GROUP", "SMDGAIN-"..SpellTarget)
	end
end

function SimpleMD:Fade()
	--if we're not all alone and people care about our misdirects
	if GetNumPartyMembers() > 0 or GetNumRaidMembers() > 0 then
		self.fade = string.gsub(self.db.profile.messageFade, "<player>", PlayerName)
		self.fade = string.gsub(self.fade, "<target>", SpellTarget)
		
		if self.db.profile.showFade then
			self:PrintMessage(self.fade, 1)
		end
		--if we're showing the bars change the color back to normal once the MD charges are gone
		if self.db.profile.showBars then
			for k, v in pairs(self.idents) do
				if v == PlayerName then
					self.anchor.timers[k].timer:SetStatusBarColor(self.db.profile.barR, self.db.profile.barG, self.db.profile.barB, 1)
				end
			end
		end
		self:SendCommMessage("GROUP", "SMDFADE-"..SpellTarget)
	end
end

--check to see if spell is Misdirection, if it is set the spell target
function SimpleMD:GetSpellTarget(unit, spell, arg3, target)
	if unit == "player" then
		if spell == L["Misdirection"] then
			SpellTarget = target
		end
	end
end

function SimpleMD:GetCastInfo(...)
	if select(10, ...) == L["Misdirection"] then
		if select(7, ...) == PlayerName then
			if select(2, ...) == "SPELL_AURA_APPLIED" then
				self:Gain()
				
				if GetNumPartyMembers() > 0 or GetNumRaidMembers() > 0 then
					self:ScheduleEvent("SIMPLEMD_MISDIRECT_CD", 60, 60) --60 second warning
					self:ScheduleEvent("SIMPLEMD_MISDIRECT_CD", 90, 30) --30 second warning
					self:ScheduleEvent("SIMPLEMD_MISDIRECT_CD", 110, 10) -- 10 second warning
					self:ScheduleEvent("SIMPLEMD_MISDIRECT_CD", 120, 0) -- cooldown finished
				end
				
			elseif select(2, ...) == "SPELL_AURA_REMOVED" and select(2, UnitClass("player")) == "HUNTER" then
				self:Fade()
			end
		end
	elseif  select(10, ...) == L["Readiness"] then
		if select(4, ...) == PlayerName then
			if GetNumPartyMembers() > 0 or GetNumRaidMembers() > 0 then
				self:CancelAllScheduledEvents() --cancel all CD message events
				if self.db.profile.showReadiness then
					self:PrintMessage(PlayerName .. " " .. self.db.profile.readiness, 1)
				end
				SimpleMD:SendCommMessage("GROUP", "SMDREADINESS")
				if self.db.profile.showSelf and self.db.profile.showBars then
					self:ReadinessCheck(PlayerName)
				end
			end
		end
	end
end

--Event for broadcasting the cooldown messages
--Do nothing if player is dead or ghost since they can't MD anymore (thanks Cerqua)
function SimpleMD:CooldownBroadcast(timeleft)
	if not UnitIsDeadOrGhost("player") then
		if timeleft == 60 then
			if self.db.profile.sixty then
				self:PrintMessage(PlayerName .. " " .. self.db.profile.sixtyCD, 1)
			end
			self:SendCommMessage("GROUP", "SMDSIXTY")
		end
		if timeleft == 30 then
			if self.db.profile.thirty then
				self:PrintMessage(PlayerName .. " " .. self.db.profile.thirtyCD, 1)
			end
			self:SendCommMessage("GROUP", "SMDTHIRTY")
		end
		if timeleft == 10 then
			if self.db.profile.ten then
				self:PrintMessage(PlayerName .. " " .. self.db.profile.tenCD, 1)
			end
			self:SendCommMessage("GROUP", "SMDTEN")
		end
		if timeleft == 0 then
			if self.db.profile.ready then
				self:PrintMessage(PlayerName .. " " .. self.db.profile.noCD, 1)
			end
			self:SendCommMessage("GROUP", "SMDDONE")
		end
	end
end

--see if the player is in a raid, if not.. clear the CD bars
function SimpleMD:RaidStatus()
	if not UnitInRaid("player") then
		self:ClearTimers()
	end
end

function SimpleMD:ToggleAnchor()
	if self.anchor:IsVisible() then
		self.anchor:Hide()
	else
		self.anchor:Show()
	end
end

--Disable the bars and immediately cancel all running timers
function SimpleMD:DisableBars()
	if self.db.profile.showBars then
		self.db.profile.showBars = false
	else
		self.db.profile.showBars = true
	end
	
	SimpleMD:ClearTimers()
end

--Test function for all aspects of the mod
function SimpleMD:Test()
	if self.db.profile.showInChat then
		self:Print(L["Testing Chat Frame Printing"])
	end
	if self.db.profile.showOnScreen then
		UIErrorsFrame:AddMessage(L["Testing On Screen Printing"], self.db.profile.r, self.db.profile.g, self.db.profile.b, 5.0)
	end
	if self.db.profile.showInChannel and channel ~= "" then
		SendChatMessage(L["Testing Channel Printing"], "CHANNEL", GetDefaultLanguage("player"), GetChannelName(self.db.profile.channel))
	end
	if self.db.profile.showFloating then
		self:Pour(L["Testing Floating Message"], self.db.profile.r, self.db.profile.g, self.db.profile.b)
	end
	if self.db.profile.showBars then
		self:ClearTimers()
		self:CreateTimer("Test1 ", "test_target", 30, self.db.profile.reverse, self.db.profile.stay, self.db.profile.growUp)
		self:CreateTimer("test2 ", nil, 30, self.db.profile.reverse, self.db.profile.stay, self.db.profile.growUp)
		self:ScheduleEvent("SIMPLEMD_TESTBARS", 30)
	end
end
