local DD = AceLibrary("Dewdrop-2.0")
local SML = LibStub("LibSharedMedia-2.0")
local SML_bars = SML:List("statusbar")
local SML_font = SML:List("font")
local L = AceLibrary("AceLocale-2.2"):new("SimpleMD")


local opts = {
	type='group',
	args = {
		anchor = {
			type = 'execute',
			name = L["Anchor"],
			desc = L["Show the dragable anchor."],
			func = "ToggleAnchor",
			order = 1,
		},
		bars = {
			type = 'group',
			name = L["Bar"],
			desc = L["Bar Options"],
			order = 2,
			args = {
				texture = {
					type = 'text',
					name = L["Bar Texture"],
					desc = L["Bar Texture"],
					get = function() return SimpleMD.db.profile.texture end,
					set = function(texture)
						SimpleMD.db.profile.texture = texture
						for k, v in pairs(SimpleMD.anchor.timers) do
							SimpleMD.anchor.timers[k].timer:SetStatusBarTexture(SML:Fetch('statusbar', texture))
							SimpleMD.anchor.timers[k].timer.bg:SetTexture(SML:Fetch('statusbar', texture))
						end
					end,
					validate = SML_bars,
					usage = L["<texture>"],
				},
				color = {
					type = 'color',
					name = L["Bar Color"],
					desc = L["Set the default bar color."],
					get = function() return SimpleMD.db.profile.barR, SimpleMD.db.profile.barG, SimpleMD.db.profile.barB end,
					set = function(r, g, b)
						SimpleMD.db.profile.barR, SimpleMD.db.profile.barG, SimpleMD.db.profile.barB = r, g, b
						for k, v in pairs(SimpleMD.anchor.timers) do
							SimpleMD.anchor.timers[k].timer:SetStatusBarColor(r, g, b, 1)
						end
					end,
				},
				bgcolor = {
					type = 'color',
					name = L["Background Color"],
					desc = L["Set the bar background color."],
					get = function() return SimpleMD.db.profile.BGr, SimpleMD.db.profile.BGg, SimpleMD.db.profile.BGb end,
					set = function(r, g, b)
						SimpleMD.db.profile.BGr, SimpleMD.db.profile.BGg, SimpleMD.db.profile.BGb = r, g, b
						for k, v in pairs(SimpleMD.anchor.timers) do
							SimpleMD.anchor.timers[k].timer.bg:SetVertexColor(r, g, b)
						end
					end,
				},
				bgalpha = {
					type = 'range',
					name = L["Background Alpha"],
					desc = L["Set the bar background alpha."],
					get = function () return SimpleMD.db.profile.bg_alpha end,
					set = function (alpha)
						SimpleMD.db.profile.bg_alpha = alpha
						for k, v in pairs(SimpleMD.anchor.timers) do
							SimpleMD.anchor.timers[k].timer.bg:SetAlphs(alpha)
						end
					end,
					min = 0.0,
					max = 1.0,
					step = 0.01,
				},
				text = {
					type = 'text',
					name = L["Font"],
					desc = L["Font"],
					get = function() return SimpleMD.db.profile.font end,
					set = function(font)
						SimpleMD.db.profile.font = font
						for k, v in pairs(SimpleMD.anchor.timers) do
							SimpleMD.anchor.timers[k].text:SetFont(SML:Fetch('font', font), SimpleMD.db.profile.textSize)
							SimpleMD.anchor.timers[k].timetext:SetFont(SML:Fetch('font', font), SimpleMD.db.profile.textSize)
						end
					end,
					validate = SML_font,
					usage = "<font name>",
				},
				textcolor = {
					type = 'color',
					name = L["Text Color"],
					desc = L["Set the bar text color."],
					get = function() return SimpleMD.db.profile.txtR, SimpleMD.db.profile.txtG, SimpleMD.db.profile.txtB end,
					set = function(r, g, b)
						SimpleMD.db.profile.txtR, SimpleMD.db.profile.txtG, SimpleMD.db.profile.txtB = r, g, b
						for k, v in pairs(SimpleMD.anchor.timers) do
							SimpleMD.anchor.timers[k].text:SetTextColor(r, g, b, 1)
							SimpleMD.anchor.timers[k].timetext:SetTextColor(r, g, b, 1)
						end
					end,
				},
				textsize = {
					type = 'range',
					name = L["Text Size"],
					desc = L["Set the bar text size."],
					get = function () return SimpleMD.db.profile.textSize end,
					set = function (size)
						SimpleMD.db.profile.textSize = size
						for k, v in pairs(SimpleMD.anchor.timers) do
							SimpleMD.anchor.timers[k].text:SetFont(SML:Fetch('font', SimpleMD.db.profile.font), size)
							SimpleMD.anchor.timers[k].timetext:SetFont(SML:Fetch('font', SimpleMD.db.profile.font), size)
						end
					end,
					min = 8,
					max = 20,
					step = 0.5
				},
				scale = {
					type = 'range',
					name = L["Bar Scale"],
					desc = L["Set the bar scale."],
					get = function () return SimpleMD.db.profile.barScale end,
					set = function (scale)
						SimpleMD.db.profile.barScale = scale
						for k, v in pairs(SimpleMD.anchor.timers) do
							SimpleMD.anchor.timers[k]:SetWidth(SimpleMD.db.profile.barWidth * scale)
							SimpleMD.anchor.timers[k]:SetHeight(SimpleMD.db.profile.barHeight * scale)
							SimpleMD.anchor.timers[k].icon:SetWidth(SimpleMD.db.profile.barHeight * scale)
							SimpleMD.anchor.timers[k].icon:SetHeight(SimpleMD.db.profile.barHeight * scale)
							SimpleMD.anchor.timers[k].text:SetWidth(SimpleMD.db.profile.barWidth * SimpleMD.db.profile.barScale)
							SimpleMD.anchor.timers[k].text:SetHeight(SimpleMD.db.profile.barHeight * SimpleMD.db.profile.barScale)
							SimpleMD.anchor.timers[k].timetext:SetWidth(SimpleMD.db.profile.barWidth * SimpleMD.db.profile.barScale)
							SimpleMD.anchor.timers[k].timetext:SetHeight(SimpleMD.db.profile.barHeight * SimpleMD.db.profile.barScale)
						end
					end,
					min = 0.5,
					max = 1.5,
					step = 0.1
				},
				height = {
					type = 'range',
					name = L["Bar Height"],
					desc = L["Set the bar height."],
					get = function () return SimpleMD.db.profile.barHeight end,
					set = function (height)
						SimpleMD.db.profile.barHeight = height
						for k, v in pairs(SimpleMD.anchor.timers) do
							SimpleMD.anchor.timers[k]:SetHeight(height * SimpleMD.db.profile.barScale)
							SimpleMD.anchor.timers[k].icon:SetWidth(height * SimpleMD.db.profile.barScale)
							SimpleMD.anchor.timers[k].icon:SetHeight(height * SimpleMD.db.profile.barScale)
							SimpleMD.anchor.timers[k].text:SetHeight(height * SimpleMD.db.profile.barScale)
							SimpleMD.anchor.timers[k].timetext:SetHeight(height * SimpleMD.db.profile.barScale)
						end
					end,
					min = 8,
					max = 30,
					step = 0.5,
				},
				width = {
					type = 'range',
					name = L["Bar Width"],
					desc = L["Set the bar width."],
					get = function () return SimpleMD.db.profile.barWidth end,
					set = function (width)
						SimpleMD.db.profile.barWidth = width
						for k, v in pairs(SimpleMD.anchor.timers) do
							SimpleMD.anchor.timers[k]:SetWidth(width * SimpleMD.db.profile.barScale)
							SimpleMD.anchor.timers[k].text:SetWidth(width * SimpleMD.db.profile.barScale)
							SimpleMD.anchor.timers[k].timetext:SetWidth(width * SimpleMD.db.profile.barScale)
						end
					end,
					min = 50,
					max = 300,
					step = 1.0,
				},
				growth = {
					type = 'toggle',
					name = L["Grow Up"],
					desc = L["Toggle the bar growing upwards or downwards."],
					get = function () return SimpleMD.db.profile.growUp end,
					set = function ()
						SimpleMD.db.profile.growUp = not SimpleMD.db.profile.growUp
						SimpleMD:ReanchorTimers(SimpleMD.db.profile.growUp)
					end,
				},
				reverse = {
					type = 'toggle',
					name = L["Reverse"],
					desc = L["Toggle the bar fill direction."],
					get = function() return SimpleMD.db.profile.reverse end,
					set = function()
						SimpleMD.db.profile.reverse = not SimpleMD.db.profile.reverse
						for k, v in pairs(SimpleMD.anchor.timers) do
							SimpleMD.anchor.timers[k].reversed = SimpleMD.db.profile.reverse
						end
					end,
				},
				stay = {
					type = 'toggle',
					name = L["Static Bars"],
					desc = L["Toggle the static bars feature"],
					get = function() return SimpleMD.db.profile.stay end,
					set = function()
						SimpleMD.db.profile.stay = not SimpleMD.db.profile.stay
						for k, v in pairs(SimpleMD.anchor.timers) do
							SimpleMD.anchor.timers[k].stayonscreen = SimpleMD.db.profile.stay
						end
					end,
				},
			},
		},
		messages = {
			type = 'group',
			name = L["Message Text Options"],
			desc = L["Options for setting the various alert texts"],
			order = 4,
			args = {
				gain = {
					type = 'text',
					name = L["Gain Message"],
					desc = L["Set Misdirection Gained Message: use <player> to autofill your name and <target> to autofill MD's target's name"],
					usage = L["<your message>"],
					get = function() return SimpleMD.db.profile.messageGain end,
					set = function(v) SimpleMD.db.profile.messageGain = v end,
				},
				fade = {
					type = 'text',
					name = L["Faded Message"],
					desc = L["Set Misdirection Faded Message: use <player> to autofill your name and <target> to autofill MD's target's name"],
					usage = L["<your message>"],
					get = function() return SimpleMD.db.profile.messageFade end,
					set = function(v) SimpleMD.db.profile.messageFade = v end,
				},
				tensec = {
					type = 'text',
					name = L["10 Second Warning"],
					desc = L["Set Ten Seconds Remaining Message. NOTE: The name of the broadcaster preceeds the message"],
					usage = L["<your message>"],
					get = function() return SimpleMD.db.profile.tenCD end,
					set = function(v) SimpleMD.db.profile.tenCD = v end,
				},
				thirtysec = {
					type = 'text',
					name = L["30 Second Warning"],
					desc = L["Set Thirty Seconds Remaining Message. NOTE: The name of the broadcaster preceeds the message"],
					usage = L["<your message>"],
					get = function() return SimpleMD.db.profile.thirtyCD end,
					set = function(v) SimpleMD.db.profile.thirtyCD = v end,
				},
				sixtysec = {
					type = 'text',
					name = L["60 Second Warning"],
					desc = L["Set Sixty Seconds Remaining Message. NOTE: The name of the broadcaster preceeds the message"],
					usage = L["<your message>"],
					get = function() return SimpleMD.db.profile.sixtyCD end,
					set = function(v) SimpleMD.db.profile.sixtyCD = v end,
				},
				cddone = {
					type = 'text',
					name = L["Cooldown Finished Warning"],
					desc = L["Set Cooldown Finished Message. NOTE: The name of the broadcaster preceeds the message"],
					usage = L["<your message>"],
					get = function() return SimpleMD.db.profile.noCD end,
					set = function(v) SimpleMD.db.profile.noCD = v end,
				},
				readiness = {
					type = 'text',
					name = L["Readiness Warning"],
					desc = L["Set Readiness Message. NOTE: The name of the broadcaster preceeds the message"],
					usage = L["<your message>"],
					get = function() return SimpleMD.db.profile.readiness end,
					set = function(v) SimpleMD.db.profile.readiness = v end,
				},
			},
		},
		broadcast = {
			type = 'group',
			name = L["Broadcast Options"],
			desc = L["Options for how and where the alerts are displayed"],
			order = 5,
			args = {
				screen = {
					type = 'toggle',
					name = L["Show on Screen"],
					desc = L["Toggles the display of the alert message on screen"],
					get = function() return SimpleMD.db.profile.showOnScreen end,
					set = function() SimpleMD.db.profile.showOnScreen = not SimpleMD.db.profile.showOnScreen end,
				},
				console = {
					type = 'toggle',
					name = L["Show in Chat"],
					desc = L["Toggles the display of the alerts as self messages"],
					get = function() return SimpleMD.db.profile.showInChat end,
					set = function() SimpleMD.db.profile.showInChat = not SimpleMD.db.profile.showInChat end,
				},
				channel = {
					type = 'toggle',
					name = L["Show in Channel"],
					desc = L["Toggles broadcasting of alerts to a user defined channel"],
					get = function() return SimpleMD.db.profile.showInChannel end,
					set = function() SimpleMD.db.profile.showInChannel = not SimpleMD.db.profile.showInChannel end,
				},
				floating = {
					type = 'toggle',
					name = L["Show in Combat Text"],
					desc = L["Toggles showing alerts in popular SCT like mods"],
					get = function() return SimpleMD.db.profile.showFloating end,
					set = function() SimpleMD.db.profile.showFloating = not SimpleMD.db.profile.showFloating end,
				},
				showSelf = {
					type = 'toggle',
					name = L["Show Own Alerts"],
					desc = L["Toggles showing your alerts on your client"],
					get = function() return SimpleMD.db.profile.showSelf end,
					set = function() SimpleMD.db.profile.showSelf = not SimpleMD.db.profile.showSelf end,
				},
				channelName = {
					type = 'text',
					name = L["Custom Channel"],
					desc = L["Name of custom channel"],
					usage = L["<channel name>"],
					get = function() return SimpleMD.db.profile.channel end,
					set = function(v) SimpleMD.db.profile.channel = v end,
				},
				raidwarning = {
					type = 'toggle',
					name = L["Show in Raid Warning"],
					desc = L["Broadcast Misdirection casts to Raid Warning"],
					get = function() return SimpleMD.db.profile.showRW end,
					set = function() SimpleMD.db.profile.showRW = not SimpleMD.db.profile.showRW end,
				},
				showgain = {
					type = 'toggle',
					name = L["Show Gain Message"],
					desc = L["Toggles the display and broadcast of the Gain message"],
					get = function() return SimpleMD.db.profile.showGain end,
					set = function() SimpleMD.db.profile.showGain = not SimpleMD.db.profile.showGain end,
				},
				showfade = {
					type = 'toggle',
					name = L["Show Faded Message"],
					desc = L["Toggles the display and broadcast of the Faded message"],
					get = function() return SimpleMD.db.profile.showFade end,
					set = function() SimpleMD.db.profile.showFade = not SimpleMD.db.profile.showFade end,
				},
				party = {
					type = 'toggle',
					name = L["Show in Party Chat"],
					desc = L["Toggles broadcasting alerts to Party chat"],
					get = function() return SimpleMD.db.profile.showParty end,
					set = function() SimpleMD.db.profile.showParty = not SimpleMD.db.profile.showParty end,
				},
				raid = {
					type = 'toggle',
					name = L["Show in Raid Chat"],
					desc = L["Toggles broadcasting alerts to Raid chat"],
					get = function() return SimpleMD.db.profile.showRaid end,
					set = function() SimpleMD.db.profile.showRaid = not SimpleMD.db.profile.showRaid end,
				},
			},
		},
		cooldowns = {
			type = 'group',
			name = L["Cooldown Broadcast Options"],
			desc = L["Toggle which cooldown warnings you want to display to other users"],
			order = 6,
			args = {
				bars = {
					type = 'toggle',
					name = L["Show Cooldown Bars"],
					desc = L["Toggles the creation of cooldown bars"],
					get = function() return SimpleMD.db.profile.showBars end,
					set = "DisableBars",
				},
				ready = {
					type = 'toggle',
					name = L["CD Finished Warning"],
					desc = L["Display a warning when MD cooldown finishes"],
					get = function() return SimpleMD.db.profile.ready end,
					set = function() SimpleMD.db.profile.ready = not SimpleMD.db.profile.ready end,
				},
				readiness = {
					type = 'toggle',
					name = L["Readiness Message"],
					desc = L["Toggle showing readiness messages"],
					get = function() return SimpleMD.db.profile.showReadiness end,
					set = function() SimpleMD.db.profile.showReadiness = not SimpleMD.db.profile.showReadiness end,
				},
				ten = {
					type = 'toggle',
					name = L["10 Second Warning"],
					desc = L["Display a warning with 10 seconds left on MD cooldown"],
					get = function() return SimpleMD.db.profile.ten end,
					set = function() SimpleMD.db.profile.ten = not SimpleMD.db.profile.ten end,
				},
				thirty = {
					type = 'toggle',
					name = L["30 Second Warning"],
					desc = L["Display a warning with 30 seconds left on MD cooldown"],
					get = function() return SimpleMD.db.profile.thirty end,
					set = function() SimpleMD.db.profile.thirty = not SimpleMD.db.profile.thirty end,
				},
				sixty = {
					type = 'toggle',
					name = L["60 Second Warning"],
					desc = L["Display a warning with 60 seconds left on MD cooldown"],
					get = function() return SimpleMD.db.profile.sixty end,
					set = function() SimpleMD.db.profile.sixty = not SimpleMD.db.profile.sixty end,
				},
			},
		},
		color = {
			type = 'color',
			name = L["Text Color"],
			desc = L["Color for the On Screen Display"],
			get = function() return SimpleMD.db.profile.r, SimpleMD.db.profile.g, SimpleMD.db.profile.b end,
			set = function(r, g, b) SimpleMD.db.profile.r, SimpleMD.db.profile.g, SimpleMD.db.profile.b = r, g, b end,
			order = 7,
		},
		test = {
			type = 'execute',
			name = "Test Settings",
			desc = "Perform a test of all graphical elements",
			func = "Test",
			order = 8,
		},
	},
}

opts.args.config = {
	type = "execute",
	name = L["Config"],
	desc = L["Show the GUI configuration menu."],
	guiHidden = true,
	func = function() DD:Open(UIParent, 'children', function() DD:FeedAceOptionsTable(opts) end, 'cursorX', true, 'cursorY', true) end,
}

SimpleMD:RegisterChatCommand(L["Slash-Commands"], opts)
SimpleMD.menu = opts
SimpleMD.MenuRequest = opts