-- If you aren't a paladin, then disable the addon
if select(2, UnitClass('player')) ~= "PALADIN" then
	DisableAddOn("SimpleHolyPower")
	return
end


local f = CreateFrame("frame")
local max_holy_power = 3	 -- this will change with MoP
local xpos = 0
local ypos = 0
local r = 0.9686274509803922
local g = 0.674509803921568
local b = 0.1450980392156863
local scale = 1
local leftanchor = "CENTER"
local hpframes = {}


f:SetScript("OnEvent", function(self, event, ...)
    self[event](self, ...)
end)

local function updateHP()
	local power = UnitPower("player", 9)
	local i = 1

	while i <= power do
		hpframes[i]:SetBackdropColor(r, g, b, 1)
		i = 1 + i
	end

	while i <= max_holy_power do
		hpframes[i]:SetBackdropColor(r, g, b, 0.1)
		i = 1 + i
	end


end


local function updateFrames()
	for i = 1,max_holy_power do
		hpframes[i]:SetSize(22, 22)

		hpframes[i]:SetBackdropColor(r, g, b, 0.1)
		hpframes[i]:SetBackdropBorderColor(0, 0, 0, 1)
	 
		if i == 1 then
			hpframes[i]:SetPoint(leftanchor, UIParent, leftanchor, xpos, ypos)
			hpframes[i]:SetScale(scale)

			hpframes[i]:SetMovable(true)
			hpframes[i]:EnableMouse(true)
			hpframes[i]:RegisterForDrag("LeftButton")
			hpframes[i]:SetScript("OnDragStart", function(self)
				if IsAltKeyDown() then
					self:StartMoving()
				end
			end)
			hpframes[i]:SetScript("OnDragStop", function(self)
				self:StopMovingOrSizing()
				anch,_, _, x, y = self:GetPoint(1)
				xpos = x
				SimpleHolyPowerDB.xpos = x
				xpos = y
				SimpleHolyPowerDB.ypos = y
				leftanchor = anch
				SimpleHolyPowerDB.leftanchor = anch

			end)
			

		else
			hpframes[i]:SetPoint("RIGHT", 23, 0)

		end

		hpframes[i]:Show()

	end
	updateHP()
end

local function initFrames()
	for i = 1,max_holy_power do
		hpframes[i] = CreateFrame("Frame", "SHPFrame"..i, i == 1 and UIParent or hpframes[i-1])
		hpframes[i]:SetBackdrop({bgFile=[[Interface\ChatFrame\ChatFrameBackground]],edgeFile=[[Interface/Tooltips/UI-Tooltip-Border]],tile=true,tileSize=4,edgeSize=4,insets={left=0.5,right=0.5,top=0.5,bottom=0.5}})

	end
	updateFrames()
end

local function destroyFrames()
	for i = 1,max_holy_power do
		hpframes[i]:Hide()
		hpframes[i] = nil
	end
	hpframes = {}
end

function ColorPickCallback(restore)
	if restore then
		r, g, b = unpack(restore)
	else
		r, g, b = ColorPickerFrame:GetColorRGB();
	end
	
	SimpleHolyPowerDB.r = r
	SimpleHolyPowerDB.g = g
	SimpleHolyPowerDB.b = b

	updateFrames()
end

function f:PLAYER_ENTERING_WORLD()
	updateHP()
end

function f:UNIT_POWER(unit, type)
	if type == "HOLY_POWER" and unit == "player" then
		updateHP()
	end
end

function f:UNIT_ENTERED_VEHICLE(unit)
	if unit == "player" then
		for i = 1,max_holy_power do
			hpframes[i]:Hide()
		end
	end
end

function f:UNIT_EXITED_VEHICLE(unit)
	if unit == "player" then
		for i = 1,max_holy_power do
			hpframes[i]:Show()
		end
	end
end


function f:ADDON_LOADED(addon)
	if addon ~= "SimpleHolyPower" then return end
	if select(2, UnitClass('player')) ~= "PALADIN" then
		return
	end

	local defaults = {
		xpos = 0,
		ypos = 0,
		r = 0.9686274509803922,
		g = 0.6745098039215687,
		b = 0.1450980392156863,
		scale = 1,
		leftanchor = "CENTER"
	}
		
	SimpleHolyPowerDB = SimpleHolyPowerDB or {}
		
	for k,v in pairs(defaults) do
		if SimpleHolyPowerDB[k] == nil then
			SimpleHolyPowerDB[k] = v
		end
	end


	SLASH_SHP1, SLASH_SHP2 = "/shp", "/simpleholypower"
	SlashCmdList.SHP = function(txt)
		local cmd, msg = txt:match("^(%S*)%s*(.-)$");
		cmd = string.lower(cmd)
		msg = string.lower(msg)

		if cmd == "reset" then
			xpos = 0
			ypos = 0
			r = 0.9686274509803922
			g = 0.674509803921568
			b = 0.1450980392156863
			scale = 1
			leftanchor = "CENTER"
			SimpleHolyPowerDB.xpos = 0
			SimpleHolyPowerDB.ypos = 0
			SimpleHolyPowerDB.r = 0.9686274509803922
			SimpleHolyPowerDB.g = 0.674509803921568
			SimpleHolyPowerDB.b = 0.1450980392156863
			SimpleHolyPowerDB.scale = 1
			SimpleHolyPowerDB.leftanchor = "CENTER"
			
			destroyFrames()
			initFrames()

			print("Frame reset to the center, you can now move it to the desired position.")

		elseif cmd == "scale" then
			local num = tonumber(msg)
			if num then
				scale = num
				SimpleHolyPowerDB.scale = num

				updateFrames()
			else
				print("Not a valid scale! Scale has to be a number, recommended to be between 0.5 and 3")
			end
		elseif cmd == "color" or cmd == "colour" then
			ColorPickerFrame:SetColorRGB(r,g,b)
			ColorPickerFrame.previousValues = {r,g,b}
			ColorPickerFrame.func, ColorPickerFrame.opacityFunc, ColorPickerFrame.cancelFunc = ColorPickCallback, ColorPickCallback, ColorPickCallback
			ColorPickerFrame:Hide() -- apparently needed...
			ColorPickerFrame:Show()
		else
			print("|cff3399FF/shp|r usage:")
			print("|cff3399FF/shp reset|r Resets the addon back to default settings. Use if you can't see the frame and/or dragged it out of the screen.")
			print("|cff3399FF/shp color|r Open the color picker window.")
			print("|cff3399FF/shp scale|r Change the scale of the addon (default: 1, don't use values larger than 3)")
			print("|cff33FF99To move the boxes:|r Alt+Left mouse button on the leftmost box to drag it.")
		end

	end

	xpos = SimpleHolyPowerDB.xpos
	ypos = SimpleHolyPowerDB.ypos
	r = SimpleHolyPowerDB.r
	g = SimpleHolyPowerDB.g
	b = SimpleHolyPowerDB.b
	scale = SimpleHolyPowerDB.scale
	leftanchor = SimpleHolyPowerDB.leftanchor

	initFrames()
	f:RegisterEvent("UNIT_POWER")
	f:RegisterEvent("PLAYER_ENTERING_WORLD")
	f:RegisterEvent("UNIT_ENTERED_VEHICLE")
	f:RegisterEvent("UNIT_EXITED_VEHICLE")



end

f:RegisterEvent("ADDON_LOADED")

