--[[
   dynamically create an event catcher frame to do stuff after other addons are
   loaded
  ]]
local ShortTerm = LibStub("AceAddon-3.0"):NewAddon(
	"ShortTerm"
);
local L = LibStub("AceLocale-3.0"):GetLocale("Short term");
local LG = LibStub("AceLocale-3.0"):GetLocale("Short term message groups");

ShortTermMemory = {};
ShortTermMemorySettings = {
	BacklogLength = 30,
	Events = {
		SYSTEM = false,        BATTLEGROUND_LEADER = true,
		SAY = true,            GUILD = true,
		EMOTE = true,          GUILD_OFFICER = true,   
		YELL = true,           MONSTER_SAY = true,  
		WHISPER = true,        MONSTER_YELL = true,  
		PARTY = true,          MONSTER_EMOTE = true, 
		RAID = true,           MONSTER_WHISPER = true,  
		RAID_LEADER = true,    MONSTER_BOSS_EMOTE = true,    
		RAID_WARNING = true,   MONSTER_BOSS_WHISPER = true,      
		BATTLEGROUND = true,   ERRORS = false,     
		AFK = true,            SKILL = true,
		DND = true,            LOOT = true,
		IGNORED = true,        MONEY = true,
		BG_HORDE = true,       OPENING = false,
		BG_ALLIANCE = true,    TRADESKILLS = false,
		BG_NEUTRAL = true,     PET_INFO = false,
		COMBAT_XP_GAIN = false,COMBAT_MISC_INFO = false,
		ACHIEVEMENT = true,    COMBAT_HONOR_GAIN = false,
		CHANNEL = true,        COMBAT_FACTION_CHANGE = false,
		GUILD_ACHIEVEMENT = true,
		BN_WHISPER = true,     BN_CONVERSATION = true,
		BN_TOAST = false,
	},
};
local ShortTermMemoryEvents = ShortTermMemorySettings.Events;
local optionstable, optionstablecategory;

-- /spew LibStub("AceAddon-3.0"):GetAddon("ShortTerm").cache.data
local LibRingCache = LibStub:GetLibrary("LibRingCache-1.0");
local save = function(self, ...)
	--print(...);
	ShortTerm.cache:append({...});
end

local events = {
	SYSTEM                = { "CHAT_MSG_SYSTEM","TIME_PLAYED_MSG",
	                          "PLAYER_LEVEL_UP","CHARACTER_POINTS_CHANGED",},
	SAY                   = { "CHAT_MSG_SAY",},
	EMOTE                 = { "CHAT_MSG_EMOTE","CHAT_MSG_TEXT_EMOTE",},
	YELL                  = { "CHAT_MSG_YELL",},
	WHISPER               = { "CHAT_MSG_WHISPER","CHAT_MSG_WHISPER_INFORM",},
	BN_WHISPER            = { "CHAT_MSG_BN_WHISPER","CHAT_MSG_BN_WHISPER_INFORM",},
	BN_CONVERSATION       = { "CHAT_MSG_BN_CONVERSATION",
	                          "CHAT_MSG_BN_CONVERSATION_LIST",
							  "CHAT_MSG_BN_CONVERSATION_NOTICE",},
	BN_TOAST              = { "CHAT_MSG_BN_INLINE_TOAST_ALERT",
	                          "CHAT_MSG_BN_INLINE_TOAST_BROADCAST",
	                          "CHAT_MSG_BN_INLINE_TOAST_BROADCAST_INFORM",
							  "CHAT_MSG_BN_INLINE_TOAST_CONVERSATION",},
	PARTY                 = { "CHAT_MSG_PARTY","CHAT_MSG_PARTY_LEADER",
	                          "CHAT_MSG_MONSTER_PARTY",},
	RAID                  = { "CHAT_MSG_RAID",},
	RAID_LEADER           = { "CHAT_MSG_RAID_LEADER", },
	RAID_WARNING          = { "CHAT_MSG_RAID_WARNING", },
	BATTLEGROUND          = { "CHAT_MSG_BATTLEGROUND", },
	BATTLEGROUND_LEADER   = { "CHAT_MSG_BATTLEGROUND_LEADER", },
	GUILD                 = { "CHAT_MSG_GUILD","GUILD_MOTD", },
	GUILD_OFFICER         = { "CHAT_MSG_OFFICER", },
	MONSTER_SAY           = { "CHAT_MSG_MONSTER_SAY", },
	MONSTER_YELL          = { "CHAT_MSG_MONSTER_YELL", },
	MONSTER_EMOTE         = { "CHAT_MSG_MONSTER_EMOTE", },
	MONSTER_WHISPER       = { "CHAT_MSG_MONSTER_WHISPER", },
	MONSTER_BOSS_EMOTE    = { "CHAT_MSG_RAID_BOSS_EMOTE", },
	MONSTER_BOSS_WHISPER  = { "CHAT_MSG_RAID_BOSS_WHISPER", },
	ERRORS                = { "CHAT_MSG_RESTRICTED","CHAT_MSG_FILTERED", },
	AFK                   = { "CHAT_MSG_AFK", },
	DND                   = { "CHAT_MSG_DND", },
	IGNORED               = { "CHAT_MSG_IGNORED", },
	BG_HORDE              = { "CHAT_MSG_BG_SYSTEM_HORDE", },
	BG_ALLIANCE           = { "CHAT_MSG_BG_SYSTEM_ALLIANCE", },
	BG_NEUTRAL            = { "CHAT_MSG_BG_SYSTEM_NEUTRAL", },
	COMBAT_XP_GAIN        = { "CHAT_MSG_COMBAT_XP_GAIN", },
	COMBAT_HONOR_GAIN     = { "CHAT_MSG_COMBAT_HONOR_GAIN", },
	COMBAT_FACTION_CHANGE = { "CHAT_MSG_COMBAT_FACTION_CHANGE", },
	SKILL                 = { "CHAT_MSG_SKILL", },
	LOOT                  = { "CHAT_MSG_LOOT", },
	MONEY                 = { "CHAT_MSG_MONEY", },
	OPENING               = { "CHAT_MSG_OPENING", },
	TRADESKILLS           = { "CHAT_MSG_TRADESKILLS", },
	PET_INFO              = { "CHAT_MSG_PET_INFO", },
	COMBAT_MISC_INFO      = { "CHAT_MSG_COMBAT_MISC_INFO", },
	ACHIEVEMENT           = { "CHAT_MSG_ACHIEVEMENT", },
	GUILD_ACHIEVEMENT     = { "CHAT_MSG_GUILD_ACHIEVEMENT", },
	CHANNEL               = { "CHAT_MSG_CHANNEL_JOIN",   "CHAT_MSG_CHANNEL_LEAVE",
	                          "CHAT_MSG_CHANNEL_NOTICE", "CHAT_MSG_CHANNEL_NOTICE_USER",
	                          "CHAT_MSG_CHANNEL_LIST",   "CHAT_MSG_CHANNEL", },
};

--[[ kReorder(table, num) ]--
 Re-Orders a table by its (numeric) keys. Keys will change their value but not
 their relative position.
 
 This function will not affect non-numeric keys.
 
 This function does not return a table but modify the supplied one.
 
 the optional 2nd parameter will cause this function to discard the first n-num
 items and only leave the remaining num items in the table.
]]
local function kReorder(tbl, num)
	local keys = {};
	for k,v in pairs(tbl) do
		if type(k) == "number" then
			tinsert(keys, k);
		end
	end
	sort(keys);
	
	local start = 1;
	if num and num > 0 and num < #keys then
		start = #keys-num+1;
	end
	
	local j = 1;
	local v;
	-- clear entries 1 to #-num or none if start equals 1
	for i=1, start-1 do
		tbl[keys[i]] = nil;
	end
	for i=start,#keys do
		--print(i, keys[i], "to", j);
		v = tbl[keys[i]];
		tbl[keys[i]] = nil;
		tbl[j] = v
		j = j+1;
	end
	
	return j;
end
function ShortTerm:OnEnable()
	-- set up ringbuffer
	self.cache = LibRingCache:createBlackbox(ShortTermMemorySettings.BacklogLength,
	                                 ShortTermMemory);
	-- load saved events into ShortTermMemoryEvents
	ShortTermMemoryEvents = ShortTermMemorySettings.Events;
	-- load old lines into the chat
	local f;
	local fs = {};
	for k,v in ipairs(ShortTermMemory) do
		for i=0, 9 do
			f = _G["ChatFrame"..i];
			if f and f:IsEventRegistered(v[1]) then
				_G.arg13 = v[14]; -- hack because arg13 is somehow missing in ChatFrame.lua ???
				ChatFrame_MessageEventHandler(_G["ChatFrame"..i], unpack(v));
				fs[f] = true;
			end
		end
	end
	for k in pairs(fs) do
		k:AddMessage("[|cFFFF5500End of short term memory|r]");
	end
	-- create a catcher frame to log messages
	if not self.frame then
		self.frame = CreateFrame("frame", UIParent);
	end
	for k,v in pairs(ShortTermMemoryEvents) do
		if v then
			for l,event in pairs(events[k]) do
				self.frame:RegisterEvent(event);
			end
		end
	end
	self.frame:SetScript("OnEvent", save);
end

function ShortTerm:OnDisable()
	return;
end

--[[ OPTIONS ]]--
optionstable = {
	type = "group",
	name = L.SHORT_TERM_MEMORY,
	childGroups = "tab",
	args = {
		com = {
			name = L.DISCLAIMER,
			type = "description",
			order = 2,
		},
		gui = {
			name = "Config dialog",
			order = 1,
			guiHidden = true,
			dialogHidden = true,
			type = "execute",
			func = function() InterfaceOptionsFrame_OpenToCategory(optionstablecategory); end,
		},
		general = {
			name = L.GENERAL,
			order = 3,
			type = "group",
			args = {
				backloglength = {
					name = L.BACKLOG_LENGTH,
					desc = L.BACKLOG_LENGTH_DESC,
					type = "range",
					order = 1,
					min = 10,
					max = 500,
					step = 1,
					bigStep = 10,
					width = "full",
					set = function(info,val)
						val = tonumber(val);
						ShortTermMemorySettings.BacklogLength = val;
						-- lets just hope the player does not do this too often.
						ShortTerm.cache = LibRingCache:createBlackbox(val, ShortTermMemory);
					end,
					get = function() return ShortTermMemorySettings.BacklogLength or 50; end,
				},
				backlogtime = {
					name = L.BACKLOG_TIME,
					desc = L.BACKLOG_TIME_DESC,
					type = "range",
					order = 2,
					disabled = true,
					min = 0,
					max = 72,
					step = 1,
					bigStep = 1,
					width = "full",
					set = function(info,val)
						ShortTermMemorySettings.BacklogTimeOut = val;
					end,
					get = function() return ShortTermMemorySettings.BacklogTimeOut or 2; end,
				},
				--[[showfragments = {
					name = L.SHOW_FRAGMENTS,
					desc = L.SHOW_FRAGMENTS_DESC,
					type = "toggle",
					order = 3,
					set = function(info,val)
						ShortTermMemorySettings.ShowFragments = val;
					end,
					get = function()
						return ShortTermMemorySettings.ShowFragments or false;
					end,
				},]]
			},
		},
		types = {
			name = L.TYPES,
			desc = L.TYPES_DESC,
			order = 3,
			type = "group",
			args = {
				desc = {
					name = L.TYPES_DESC,
					type = "description",
					order = 1,
				},
				types = {
					name = L.TYPES2,
					type = "multiselect",
					width = "full",
					values = function()
						local ks = {};
						for k,v in pairs(events) do
							ks[k] = LG[k];
						end
						return ks;
					end,
					get = function(info, index)
						return ShortTermMemorySettings.Events[index] or false;
					end,
					set = function(info, index, val)
						ShortTermMemorySettings.Events[index] = val or false;
					end,
				}
			},
		},
	},
};

local AceConfig = LibStub("AceConfig-3.0");
local AceConfigDialog = LibStub("AceConfigDialog-3.0");

AceConfig:RegisterOptionsTable("Short term memory", optionstable);
optionstablecategory = AceConfigDialog:AddToBlizOptions("Short term memory", nil, nil);