
local types = {
	["string"]   = "STR",
	["table"]    = "TBL",
	["function"] = "FNC",
	["number"]   = "NUM",	
}
local function print_table(t)
	local i=0;
	print(t);
	for k,v in pairs(t) do
		print(types[type(k)], k, types[type(v)], v);
		i = i+1;
	end
	return i;
end

local function collect()
	collectgarbage("collect");
end

local LRC = LibStub("LibRingCache-1.0");

do
	local c = LRC:create(10);
	local i=0;
	
	print("--------------- Tests --------------");
	print("Table data");
	-- test inserts
	for i=0, 9, 1 do
		c:insert("k"..i, {i});
	end
	assert(print_table(c.data) == 10, "Expected 10 items");
	
	print("Table data after garbage collect");
	collect();
	assert(print_table(c.data) == 10, "Expected 10 items");
	
	local toadd = "l1";
	print("Table data after inserting one single item ("..toadd..")");
	c:insert(toadd, {"added"});
	assert(print_table(c.data) == 11, "Expected 11 items");
	
	print("Table data after garbage collect");
	collect();
	assert(print_table(c.data) == 10, "Expected 10 items");
	assert(c:get("k0") == nil, "Expected k0 to have been collected");
	
	do
		print("Inserting another item (and do a GC), but I save k1 in a variable first");
		local v0 = c:get("k1");
		c:insert("l2", {"added2"});
		collect();
		assert(print_table(c.data) == 11, "Expected 11 items");
		assert(c:get("k1") ~= nil, "Expected k1 to still be here");
	end
	
	print("Variable should be released now");
	collect();
	assert(print_table(c.data) == 10, "Expected 10 items");
	assert(c:get("k1") == nil, "Expected k1 to be nil");
	
	print("Table should be cleared but still contain metatable");
	c:clear();
	assert(print_table(c.data) == 0, "Expected 0 (zero) items");
	print_table(getmetatable(c.data));
	assert(getmetatable(c.data) and getmetatable(c.data).__mode =="kv",
		"Expected table to contain a metatable with kv mode setting");

	print("Test with a prefilled table");
	c = LRC:create(10, {{1}, {2}, {3}, {4}});
	c:insert("5th", {"BooOOOOOH!"});
	collect();
	assert(print_table(c.data) == 5, "Expected 5 items");
	c:insert("6th",  {"BooOOOOOH!"});
	c:insert("7th",  {"BooOOOOOH!"});
	c:insert("8th",  {"BooOOOOOH!"});
	c:insert("9th",  {"BooOOOOOH!"});
	c:insert("10th", {"BooOOOOOH!"});
	c:insert("11th", {"BooOOOOOH!"});
	c:insert("12th", {"BooOOOOOH!"});
	c:insert("13th", {"BooOOOOOH!"});
	c:insert("14th", {"BooOOOOOH!"});
	c:insert("15th", {"BooOOOOOH!"});
	collect();
	assert(print_table(c.data) == 10, "Expected 10 items");

	print("Test with only string values... None should be collected");
	c = LRC:create(10, {"1", "2", "3", "4"});
	c:insert("5th",  "BooOOOOOH!");
	c:insert("6th",  "BooOOOOOH!");
	c:insert("7th",  "BooOOOOOH!");
	c:insert("8th",  "BooOOOOOH!");
	c:insert("9th",  "BooOOOOOH!");
	c:insert("10th", "BooOOOOOH!");
	c:insert("11th", "BooOOOOOH!");
	c:insert("12th", "BooOOOOOH!");
	c:insert("13th", "BooOOOOOH!");
	c:insert("14th", "BooOOOOOH!");
	c:insert("15th", "BooOOOOOH!");
	collect();
	assert(print_table(c.data) == 15, "Expected 15 items");

	print("------------ Benchmarks ------------");
	local iterations = 10000;
	print(iterations.." inserts");
	-- bench inserts
	debugprofilestart();
	for i=0, iterations, 1 do
		c:insert("k"..i, {i});
	end
	print(debugprofilestop(), "ms");
	
	print(iterations.." gets");
	-- bench gets
	debugprofilestart();
	for i=0, iterations, 1 do
		c:get("k"..i, {i});
	end
	print(debugprofilestop(), "ms");
	print("All tests finished, and if you see this message all were successful.");
end
