--[[

### SHAMAN's FRIEND ### 

Author: Glyph @ EU-Sylvanas

This addon is designed specially for the Shaman class. It contains a lot of usefull functions no matter which spec you are.

Here are a few off the functions:
 - Remind/alert for Elemental Shields and Weapon Enchants when fading or missing in combat (with sound support)
 - Show total Windfury damage with options to include advanced info: Crits, misses and which hand the procs come from. 
   If it procced of Stormstrike, the data from both hits are summed together and adds to the damage.
 - Show a message when Lightning Overload procs, optionally together with total damage and number of crits.
 - Separate frame allowing for easy Earth Shield tracking and recast
 - Show buffs removed by Purge and/or broadcast it to the chat window
 - Show spell interrupted by Earth Shock and/or broadcast it to the chat window
 - Show when your Grounding Totem aborbs a spell and/or broadcast it to the chat window
 - Show when one of your T5 bonuses procs
 - Can print messages in MSBT, SCT, Parrot and a few other places.
 - Announce to your group whenever you cast Bloodlust/Heroism or Mana Tide
 - Uses spellID when avaible, this removes the need of localization in most cases.
 
Of course you can choose yourself which functions you want.
It is built on Ace2 for increased effiency and perfomance, with low memory footprint.
 
"/sf" or "/shamanfriend" to show the GUI.

### Known problems ### 
 - The time setting for the duration to display messages is not working fail safe (best is to leave it to default)
 
### ChangeLog ###
Version 1.12b3
 - Bugfix

Version 1.12b2
 - Bugfix

Version 1.12b
 - Fix raid/party messages for purge, heroism and mana tide to be smart. "raid" goes to "party" when not in a raid, and no error is displayed during solo play (thanks oscarucb)
 - Set Bloodlust/Heroism default text appropriately for Alliance Shammys (thanks oscarucb)
 - Fix earthshield icon to properly disappear when the UI is hidden (thanks oscarucb)
 - Updated embedded SinkLib to hopefully fix some issues with scrolling text
 - Some various bugfixes

Version 1.12
 - Fixed Purge Announce for patch 2.4.3 (thanks syeren)
 - Fixed so that message output "raid" goes to "party" if not in a raid (thanks oscarucb)
 - Fixed so that message output doesn't display an error anymore when not in a group (thanks oscarucb)
 - Fixed so that "Ground self only" works even if the grounding totem has a raid icon on it (thanks oscarucb)
 - Lowered priority on Earth Shield frame, should now be hidden when using alt+z (thanks oscarucb)

Version 1.11c
 - Fixed SCT support
 - Fixed errors with localization
 - Hopefully fixed Earth Shield
 
Version 1.11b
 - Bugfixed Chain Lightning Overload
 - Bugfix for Lightning Overload and resists, had to much hit rating to notice before :)
 - Dirty fix for Weapon Enchants
 - TOC update

Version 1.11
 - Rewrote close to all parsing code because of the 2.4 patch
 - Windfury now counts damage from stormstrike as well
 - Windfury can show which hand the proc comes from
 - Lightning Overload now works with Chain Lightning as well
 - Lightning Overload made a lot more reliable (should be close to perfect)
 - Now uses spellID on most places, which means  be a bit faster and a bit more reliable and work in most languages without localization
 - Reordered some of the options for easier configuration
 - Updated German localization (thanks blackburni)
 
Version 1.10d
 - Bugfixes for Earth Shield tracker, might still be a few problems left
 - Earth Shield tracker should know work on yourself as well

Version 1.10c
 - Bugfixes :s

Version 1.10
 - Added a sepparate Earth Shield tracker frame with ability to recast it
 - Fixed a bug with Resto set bonus

Version 1.9
 - Added possibility to show a message when Bloodlust/Heroism is cast
 - Added possibility to show a message when Mana Tide is cast
 - Made the UI to show only by typing /sf or /shamanfriend, use /sfcl if you still wan't the command line options
 - Fixed Earth Shield tracking
 
Version 1.8b
 - Fixed a bug with set bonus message not being displayed
 - Updated TOC to 20300
 - Removed Frost Shock DR as Blizzard changed it

Version 1.8
 - LO Alternate shouldn't get a false positive 
 when changing between targets with same name any more
 - Added option to add target name to the messages broadcasted to chat
 - Fixed possible problems with having LO alternate on and remove TLC procs off
 - Fixed a bug with scrolling text settings

Version 1.7
 - Updated TOC to 20200 patch
 - Fixed the custom frame positioning to work with 2.2 
  If you lose the frame, just reset the options, or type 
  /script ShamanFriend.db.profile.display.x = nil; ShamanFriend.db.profile.display.y = nil and then /rl in the console
 - Added a small attempt to an Earth Shield tracker, please tell me if it works :)
 
Version 1.6
 - Added resto 4-piece T5-bonus
 - Fixed a typo which broke the T5 Enhance option
 - Now also alerts when a weapon enchant runs out of time
 - Bugfixes
 
Version 1.5b
 - Bugfix
 - Updated SinkLib, should fix a few problems with scrolling text

Version 1.5
 - Added coice to select an alternative way to detect LO procs.
   This one should work better in raids where targets have large hitboxes, 
   but doesn't work well when you change target often.
 - Added option to select the duration of messages
 - Added SinkLib
 - Some optimizations
 
Version 1.4
 - Updated German translation (thanks Taalas)
 - Updated some of the options
 - Added option to attempt to turn off Lightning Capacitator
 - Added option to turn on text when you get a proc from the T5 set bonus
 - Added option to broadcast grounded things to the chat

Version 1.3
 - Updated TOC to 20100
 - Added option to add a font effect to the custom frame
 - Updated Korean localization (thanks Sayclub)
 - You can now select which chat to print the message in

Version 1.2
 - Fixed Grounding Totem message to work in PvP
 - Added Earth Shock message
 - Some minor bugfixes

Version 1.1
 - Reworked the options, some of them may reset
 - Added option to broadcast the Purged buffs to chat.
 - Added Ground Totem message
 - Fixed bug with LO and spell reflect

Version 1.0
 - Updated embedded libraries
 - Added a Waterfall GUI use "/sf ui" or "/shamanfriend ui" to show it. You can still use the old commands if you prefer them.
 - Added damage for Lightning Overload
 - Slightly increased the width of the custom frame
 
Version 0.11b
 - Improved method to detect Lightning Overload

Version 0.11
 - Added options to view a message when Lightning Overload proc, currently only working on Lightning Bolt due to some limitations in the lua functions

Version 0.10b
 - Dispelled Diseases and Poisons incorrectly showed up as purged

Version 0.10
 - Removed Chronos embedded library (fresh install recommended)
 - Frost Shock messages didn't show up as localized
 - New method to detect Purge, was incompatible with newer versions of ParserLib, this one is also more efficient

Version 0.9
 - Minor code optimization
 - Now only loads for Shaman characters
 - Updated Korean localization (thanks Sayclub)
 - Added German localization (thanks Bhim)

Version 0.8
 - Added option to select which font to use in the Custom Frame
 - Slightly tweaked the options, some of them may reset

Version 0.7c
 - Bugfixes again :)

Version 0.7b
 - Bugfixes

Version 0.7
 - Frost Shock Diminishing Return information added
 - SCT support added
 - MSBT support added (thanks Sayclub)

Version 0.6
 - Localization support added
 - Korean Localization added  (thanks Sayclub)
 - Some minor code improvements

Version 0.5
 - Added custom frame to show the messages in
 - Bugfixes
	
Version 0.4
 - Added Purge helper, shows the name of buff removed
 - Rearranged options
	
Version 0.3b
 - Bugfixes
	
Version 0.3
 - Added Windfury counter

Version 0.2
 - Added configuration
 - Added Sound support

Version 0.1
 - Addon created

]]

local L = AceLibrary("AceLocale-2.2"):new("ShamanFriend")
local consoleoptions = { 
    type = "group",
    name = "Shaman Friend",
    desc = L["Options for ShamanFriend"],
    args = {
		ui = {
			name = L["Show UI"],
			type = "execute",
			desc = L["Shows the Graphical User Interface"],
			func = function(v)
				ShamanFriend:ShowUI()
			end,
			wfHidden = true,
			disabled = function() return not ShamanFriend:IsActive() end,
			order = 999,
		},
		alert = {
			name = L["Alerts"],
			type = 'group',
			desc = L["Settings for Elemental Shields and Weapon Enchants."],
			order = 200, 
			args = {
				shield = {
					name = L["Elemental Shield"],
					type = "toggle",
					desc = L["Toggle check for Elemental Shield."],
					get = function() return ShamanFriend.db.profile.alert.shield end,
					set = function(v)
						ShamanFriend.db.profile.alert.shield = v
						ShamanFriend:LoadEvents()
					end,
				},
				weapon = {
					name = L["Weapon Enchant"],
					type = "toggle",
					desc = L["Toggle check for Weapon Enchants."],
					get = function() return ShamanFriend.db.profile.alert.weapon end,
					set = function(v)
						ShamanFriend.db.profile.alert.weapon = v
						ShamanFriend:LoadEvents()
					end,
				},
				entercombat = {
					name = L["Enter Combat"],
					type = "toggle",
					desc = L["Notify when entering combat."],
					get = function() return ShamanFriend.db.profile.alert.entercombat end,
					set = function(v)
						ShamanFriend.db.profile.alert.entercombat = v
						ShamanFriend:LoadEvents()
					end,
				},
				aftercombat = {
					name = L["After Combat"],
					type = "toggle",
					desc = L["Notify after the end of combat."],
					get = function() return ShamanFriend.db.profile.alert.aftercombat end,
					set = function(v)
						ShamanFriend.db.profile.alert.aftercombat = v
						ShamanFriend:LoadEvents()
					end,
				},
				mounted = {
					name = L["No Mounted"],
					type = "toggle",
					desc = L["Disable notifications when mounted."],
					get = function() return ShamanFriend.db.profile.alert.mounted end,
					set = function(v) ShamanFriend.db.profile.alert.mounted = v end,
				},
				sound = {
					name = L["Sound"],
					type = "text",
					desc = L["Play a sound when a buff is missing."],
					get = function() return ShamanFriend.db.profile.alert.sound end,
					set = function(v) ShamanFriend.db.profile.alert.sound = v	end,
					validate = {
						["ding"] = L["Ding"],
						["dong"] = L["Dong"],
						["dodo"] = L["Dodo"],
						["bell"] = L["Bell"],
						["none"] = L["None"],
					},
				},
				display = {
					name = L["Display"],
					type = 'group',
					desc = L["Settings for how to display the message."], 
					args = {
						color = {
							name = L["Color"],
							type = 'color',
							desc = L["Sets the color of the text when displaying messages."],
							get = function()
							local v = ShamanFriend.db.profile.alert.display.color
								return v.r,v.g,v.b
								end,
							set = function(r,g,b) ShamanFriend.db.profile.alert.display.color = {r=r,g=g,b=b} end
						},
						scroll = {
							type = 'toggle',
							name = L["Scroll output"],
							desc = L["Toggle showing messages in scrolling text. (Settings are in the 'Output Category')"],
							get = function() return ShamanFriend.db.profile.alert.display.scroll end,
							set = function(t) ShamanFriend.db.profile.alert.display.scroll = t end,
						},
						frames = {
							type = 'toggle',
							name = L["Frames output"],
							desc = L["Toggle whether the message will show up in the frames. (Settings are in the 'General Display' category.)"],
							get = function() return ShamanFriend.db.profile.alert.display.frames end,
							set = function(t) ShamanFriend.db.profile.alert.display.frames = t end,
						},
						time = {
							--hidden = true,
							name = L["Time to display message"],
							type = "range",
							desc = L["Set the time the message will be displayed (5=default)"],
							get = function() return ShamanFriend.db.profile.alert.display.time end,
							set = function(v)
								ShamanFriend.db.profile.alert.display.time = v
							end,
							step = 1,
							min = 1,
							max = 20,
							order = 111,
						},
					}
				},
			}
		},
		spell = {
			name = L["Spells"],
			type = 'group',
			desc = L["Settings regarding different spells."],
			order = 300,
			args = {
				purge = {
					name = L["Purge"],
					type = "toggle",
					desc = L["Toggle Purge information."],
					get = function() return ShamanFriend.db.profile.spell.purge end,
					set = function(v)
						ShamanFriend.db.profile.spell.purge = v
						ShamanFriend:LoadEvents()
					end,
					order = 301,
				},
				purgemsg = {
					name = L["Broadcast Purge"],
					type = "text",
					desc = L["Broadcast Purge message to the following chat. (Above option must be enabled)"],
					get = function() return ShamanFriend.db.profile.spell.purgemsg end,
					set = function(v)
						ShamanFriend.db.profile.spell.purgemsg = v
					end,
					disabled = function() return not ShamanFriend.db.profile.spell.purge end,
					validate = {
						["RAID"] = L["Raid"],
						["PARTY"] = L["Party"],
						["RAID_WARNING"] = L["Raid Warning"],
						["none"] = L["None"],
					},
					order = 302,
				},
				h303 = {type = "header", name = " ", order = 303},
				earthshock = {
					name = L["Earth Shock"],
					type = "toggle",
					desc = L["Toggle Earth Shock information."],
					get = function() return ShamanFriend.db.profile.spell.earthshock end,
					set = function(v)
						ShamanFriend.db.profile.spell.earthshock = v
						ShamanFriend:LoadEvents()
					end,
					order = 304,
				},
				earthshockmsg = {
					name = L["Broadcast Earth Shock"],
					type = "text",
					desc = L["Broadcast Earth Shock message to the following chat. (Above option must be enabled)"],
					get = function() return ShamanFriend.db.profile.spell.earthshockmsg end,
					set = function(v)
						ShamanFriend.db.profile.spell.earthshockmsg = v
					end,
					disabled = function() return not ShamanFriend.db.profile.spell.earthshock end,
					validate = {
						["RAID"] = L["Raid"],
						["PARTY"] = L["Party"],
						["RAID_WARNING"] = L["Raid Warning"],
						["none"] = L["None"],
					},
					order = 305,
				},
				h306 = {type = "header", name = " ", order = 306},
				--[[frostshock = {
					name = L["Frost Shock"],
					type = "toggle",
					desc = L["Toggle Frost Shock Diminishing Return information."],
					get = function() return ShamanFriend.db.profile.spell.frostshock end,
					set = function(v)
						ShamanFriend.db.profile.spell.frostshock = v
						ShamanFriend:LoadEvents()
					end,
					order = 307,
				},
				h308 = {type = "header", name = " ", order = 308},]]
				target = {
					name = L["Add target"],
					type = "toggle",
					desc = L["Add the target to the end of the message when broadcasting."],
					get = function() return ShamanFriend.db.profile.spell.target end,
					set = function(v)
						ShamanFriend.db.profile.spell.target = v
					end,
					order = 307,
				},
				h308 = {type = "header", name = " ", order = 308},
				ground = {
					name = L["Grounding Totem"],
					type = "toggle",
					desc = L["Toggle message when Grounding Totem absorbs a spell."],
					get = function() return ShamanFriend.db.profile.spell.ground end,
					set = function(v)
						ShamanFriend.db.profile.spell.ground = v
						ShamanFriend:LoadEvents()
					end,
					order = 309,
				},
				groundself = {
					name = L["Ground self only"],
					type = "toggle",
					desc = L["Only show grounding message for your own Grounding Totem"],
					get = function() return ShamanFriend.db.profile.spell.groundself end,
					set = function(v)
						ShamanFriend.db.profile.spell.groundself = v
						ShamanFriend:LoadEvents()
					end,
					disabled = function() return not ShamanFriend.db.profile.spell.ground end,
					order = 310,
				},
				groundmsg = {
					name = L["Broadcast Grounding Totem"],
					type = "text",
					desc = L["Broadcast Grounding Totem message to the following chat. (Above option must be enabled)"],
					get = function() return ShamanFriend.db.profile.spell.groundmsg end,
					set = function(v)
						ShamanFriend.db.profile.spell.groundmsg = v
					end,
					disabled = function() return not ShamanFriend.db.profile.spell.ground end,
					validate = {
						["RAID"] = L["Raid"],
						["PARTY"] = L["Party"],
						["RAID_WARNING"] = L["Raid Warning"],
						["none"] = L["None"],
					},
					order = 311,
				},
				h312 = {type = "header", name = " ", order = 312},
				bloodlust = {
					name = L["Bloodlust message"],
					type = "toggle",
					desc = L["Send a message when Bloodlust/Heroism is cast."],
					get = function() return ShamanFriend.db.profile.spell.bloodlust end,
					set = function(v)
						ShamanFriend.db.profile.spell.bloodlust = v
						ShamanFriend:LoadEvents()
					end,
					order = 313,
				},
				bloodlusttext = {
					name = L["Bloodlust text"],
					type = "text",
					desc = L["The text in the message when Bloodlust/Heroism is cast."],
					get = function() return ShamanFriend.db.profile.spell.bloodlusttext end,
					set = function(v)
						ShamanFriend.db.profile.spell.bloodlusttext = v
						ShamanFriend:LoadEvents()
					end,
					usage = "%t = your target",
					disabled = function() return not ShamanFriend.db.profile.spell.bloodlust end,
					order = 314,
				},
				bloodlustchat = {
					name = L["Bloodlust chat"],
					type = "text",
					desc = L["Chat for the Bloodlust/Heroism message."],
					get = function() return ShamanFriend.db.profile.spell.bloodlustchat end,
					set = function(v)
						ShamanFriend.db.profile.spell.bloodlustchat = v
						ShamanFriend:LoadEvents()
					end,
					disabled = function() return not ShamanFriend.db.profile.spell.bloodlust end,
					validate = {
						["RAID"] = L["Raid"],
						["PARTY"] = L["Party"],
						["YELL"] = L["Yell"],
						["SAY"] = L["Say"],
						["RAID_WARNING"] = L["Raid Warning"],
					},
					order = 315,
				},
				h316 = {type = "header", name = " ", order = 316},
				manatide = {
					name = L["Mana Tide message"],
					type = "toggle",
					desc = L["Send a message when Mana Tide is cast."],
					get = function() return ShamanFriend.db.profile.spell.manatide end,
					set = function(v)
						ShamanFriend.db.profile.spell.manatide = v
						ShamanFriend:LoadEvents()
					end,
					order = 317,
				},
				manatidetext = {
					name = L["Mana Tide text"],
					type = "text",
					desc = L["The text in the message when Mana Tide is cast."],
					get = function() return ShamanFriend.db.profile.spell.manatidetext end,
					set = function(v)
						ShamanFriend.db.profile.spell.manatidetext = v
						ShamanFriend:LoadEvents()
					end,
					usage = "%t = your target",
					disabled = function() return not ShamanFriend.db.profile.spell.manatide end,
					order = 318,
				},
				manatidechat = {
					name = L["Mana Tide chat"],
					type = "text",
					desc = L["Chat for the Mana Tide message."],
					get = function() return ShamanFriend.db.profile.spell.manatidechat end,
					set = function(v)
						ShamanFriend.db.profile.spell.manatidechat = v
						ShamanFriend:LoadEvents()
					end,
					disabled = function() return not ShamanFriend.db.profile.spell.manatide end,
					validate = {
						["RAID"] = L["Raid"],
						["PARTY"] = L["Party"],
						["YELL"] = L["Yell"],
						["SAY"] = L["Say"],
						["RAID_WARNING"] = L["Raid Warning"],
					},
					order = 319,
				},
				display = {
					name = L["Display"],
					type = 'group',
					desc = L["Settings for how to display the message."], 
					args = {
						color = {
							name = L["Color"],
							type = 'color',
							desc = L["Sets the color of the text when displaying messages."],
							get = function()
							local v = ShamanFriend.db.profile.spell.display.color
								return v.r,v.g,v.b
								end,
							set = function(r,g,b) ShamanFriend.db.profile.spell.display.color = {r=r,g=g,b=b} end
						},
						scroll = {
							type = 'toggle',
							name = L["Scroll output"],
							desc = L["Toggle showing messages in scrolling text. (Settings are in the 'Output Category')"],
							get = function() return ShamanFriend.db.profile.spell.display.scroll end,
							set = function(t) ShamanFriend.db.profile.spell.display.scroll = t end,
						},
						frames = {
							type = 'toggle',
							name = L["Frames output"],
							desc = L["Toggle whether the message will show up in the frames. (Settings are in the 'General Display' category.)"],
							get = function() return ShamanFriend.db.profile.spell.display.frames end,
							set = function(t) ShamanFriend.db.profile.spell.display.frames = t end,
						},
						time = {
							--hidden = true,
							name = L["Time to display message"],
							type = "range",
							desc = L["Set the time the message will be displayed (5=default)"],
							get = function() return ShamanFriend.db.profile.spell.display.time end,
							set = function(v)
								ShamanFriend.db.profile.spell.display.time = v
							end,
							step = 1,
							min = 1,
							max = 20,
							order = 111,
						},
					}
				},
			}
		},
		display = {
			name = L["General Display"],
			type = 'group',
			desc = L["General Display settings and options for the Custom Message Frame."],
			order = 100, 
			args = {
				chat = {
					name = L["In Chat"],
					type = "toggle",
					desc = L["Display message in Chat Frame."],
					get = function() return ShamanFriend.db.profile.display.chat end,
					set = function(v) ShamanFriend.db.profile.display.chat = v end,
					order = 110,
				},
				number= {
					name = L["Chat number"],
					type = "range",
					desc = L["Choose which chat to display the messages in (0=default)."],
					get = function() return ShamanFriend.db.profile.display.number end,
					set = function(v)
						ShamanFriend.db.profile.display.number = v
					end,
					step = 1,
					min = 0,
					max = 10,
					order = 111,
				},
				screen = {
					name = L["On Screen"],
					type = "toggle",
					desc = L["Display message in Blizzard UI Error Frame."],
					get = function() return ShamanFriend.db.profile.display.screen end,
					set = function(v) ShamanFriend.db.profile.display.screen = v end,
					order = 120,
				},
				frame = {
					name = L["Custom Frame"],
					type = "toggle",
					desc = L["Display message in Custom Message Frame."],
					get = function() return ShamanFriend.db.profile.display.frame end,
					set = function(v)
						ShamanFriend.db.profile.display.frame = v
						ShamanFriend:LoadEvents()
					end,
					order = 130,
				},
				fontSize = {
					name = L["Font Size"],
					type = "range",
					desc = L["Set the font size in the Custom Message Frame."],
					get = function() return ShamanFriend.db.profile.display.fontSize end,
					set = function(v)
						ShamanFriend.db.profile.display.fontSize = v
						ShamanFriend:UpdateFont()
					end,
					step = 1,
					min = 8,
					max = 32,
					order = 132,
				},
				fontFace = {
					name = L["Font Face"],
					type = "text",
					desc = L["Set the font face in the Custom Message Frame."],
					get = function() return ShamanFriend.db.profile.display.fontFace end,
					set = function(v)
						ShamanFriend.db.profile.display.fontFace = v
						ShamanFriend:UpdateFont()
					end,
					validate = {
						[L["FRIZQT__.TTF"]] = L["Normal"],
						[L["ARIALN.TTF"]] = L["Arial"],
						[L["skurri.ttf"]] = L["Skurri"],
						[L["MORPHEUS.ttf"]] = L["Morpheus"],
					},
					order = 133,
				},
				fontEffect = {
					name = L["Font Effect"],
					type = "text",
					desc = L["Set the font effect in the Custom Message Frame."],
					get = function() return ShamanFriend.db.profile.display.fontEffect end,
					set = function(v)
						ShamanFriend.db.profile.display.fontEffect = v
						ShamanFriend:UpdateFont()
					end,
					validate = {
						["none"] = L["None"],
						[L["OUTLINE"]] = L["OUTLINE"],
						[L["THICKOUTLINE"]] = L["THICKOUTLINE"],
						[L["MONOCHROME"]] = L["MONOCHROME"],
					},
					order = 134,
				},
				lock = {
					name = L["Lock"],
					type = "toggle",
					desc = L["Toggle locking of the Custom Message Frame."],
					get = function() return ShamanFriend.db.profile.display.lock end,
					set = function(v)
						ShamanFriend.db.profile.display.lock = v
						ShamanFriend:UpdateLock()
					end,
					order = 131,
				},
			}
		},
		wf = {
			name = L["Windfury"],
			type = 'group',
			desc = L["Settings for Windfury counter."],
			order = 500,
			args = {
				enable = {
					name = L["Enable"],
					type = "toggle",
					desc = L["Enable WF hit counter."],
					get = function() return ShamanFriend.db.profile.wf.enable end,
					set = function(v)
						ShamanFriend.db.profile.wf.enable = v
						ShamanFriend:LoadEvents()
					end,
					order = 501,
				},
				crit = {
					name = L["Crit"],
					type = "toggle",
					desc = L["Enable display of WF crits."],
					get = function() return ShamanFriend.db.profile.wf.crit end,
					set = function(v) ShamanFriend.db.profile.wf.crit = v end,
					disabled = function() return not ShamanFriend.db.profile.wf.enable end,
					order = 502,
				},
				miss = {
					name = L["Miss"],
					type = "toggle",
					desc = L["Enable display of WF misses."],
					get = function() return ShamanFriend.db.profile.wf.miss end,
					set = function(v) ShamanFriend.db.profile.wf.miss = v end,
					disabled = function() return not ShamanFriend.db.profile.wf.enable end,
					order = 503,
				},
				hand = {
					name = L["Hand"],
					type = "toggle",
					desc = L["Show which hand the proc comes from"],
					get = function() return ShamanFriend.db.profile.wf.hand end,
					set = function(v) ShamanFriend.db.profile.wf.hand = v end,
					disabled = function() return not ShamanFriend.db.profile.wf.enable end,
					order = 503,
				},
				display = {
					name = L["Display"],
					type = 'group',
					desc = L["Settings for how to display the message."], 
					args = {
						color = {
							name = L["Color"],
							type = 'color',
							desc = L["Sets the color of the text when displaying messages."],
							get = function()
							local v = ShamanFriend.db.profile.wf.display.color
								return v.r,v.g,v.b
								end,
							set = function(r,g,b) ShamanFriend.db.profile.wf.display.color = {r=r,g=g,b=b} end
						},
						scroll = {
							type = 'toggle',
							name = L["Scroll output"],
							desc = L["Toggle showing messages in scrolling text. (Settings are in the 'Output Category')"],
							get = function() return ShamanFriend.db.profile.wf.display.scroll end,
							set = function(t) ShamanFriend.db.profile.wf.display.scroll = t end,
						},
						frames = {
							type = 'toggle',
							name = L["Frames output"],
							desc = L["Toggle whether the message will show up in the frames. (Settings are in the 'General Display' category.)"],
							get = function() return ShamanFriend.db.profile.wf.display.frames end,
							set = function(t) ShamanFriend.db.profile.wf.display.frames = t end,
						},
						time = {
							--hidden = true,
							name = L["Time to display message"],
							type = "range",
							desc = L["Set the time the message will be displayed (5=default)"],
							get = function() return ShamanFriend.db.profile.wf.display.time end,
							set = function(v)
								ShamanFriend.db.profile.wf.display.time = v
							end,
							step = 1,
							min = 1,
							max = 20,
							order = 111,
						},
					}
				},
			}
		},
		lo = {
			name = L["Lightning Overload"],
			type = 'group',
			desc = L["Settings for Lightning Overload."],
			order = 400,
			args = {
				enable = {
					name = L["Enable"],
					type = "toggle",
					desc = L["Toggle whether to show a message when Lightning Overload procs."],
					get = function() return ShamanFriend.db.profile.lo.enable end,
					set = function(v)
						ShamanFriend.db.profile.lo.enable = v
						ShamanFriend:LoadEvents()
					end,
					order = 401,
				},
				crit = {
					name = L["Crit"],
					type = "toggle",
					desc = L["Enable display of Lightning Overload crits."],
					get = function() return ShamanFriend.db.profile.lo.crit end,
					set = function(v) ShamanFriend.db.profile.lo.crit = v end,
					disabled = function() return not ShamanFriend.db.profile.lo.enable end,
					order = 403,
				},
				damage = {
					name = L["Damage"],
					type = "toggle",
					desc = L["Enable display of Lightning Overload total damage."],
					get = function() return ShamanFriend.db.profile.lo.damage end,
					set = function(v) ShamanFriend.db.profile.lo.damage = v end,
					disabled = function() return not ShamanFriend.db.profile.lo.enable end,
					order = 404,
				},
				--[[trinket = {
					name = L["No Lightning Capacitator"],
					type = "toggle",
					desc = L["Attempt to remove procs coming from the Lightning Capacitator trinket. (Does not always work, and can cause the damage from dual procs to be a bit off)"],
					get = function() return ShamanFriend.db.profile.lo.trinket end,
					set = function(v)
						ShamanFriend.db.profile.lo.trinket = v
						ShamanFriend:LoadEvents()
					end,
					disabled = function() return not ShamanFriend.db.profile.lo.enable end,
					order = 405,
				},]]
				display = {
					name = L["Display"],
					type = 'group',
					desc = L["Settings for how to display the message."], 
					args = {
						color = {
							name = L["Color"],
							type = 'color',
							desc = L["Sets the color of the text when displaying messages."],
							get = function()
							local v = ShamanFriend.db.profile.lo.display.color
								return v.r,v.g,v.b
								end,
							set = function(r,g,b) ShamanFriend.db.profile.lo.display.color = {r=r,g=g,b=b} end
						},
						scroll = {
							type = 'toggle',
							name = L["Scroll output"],
							desc = L["Toggle showing messages in scrolling text. (Settings are in the 'Output Category')"],
							get = function() return ShamanFriend.db.profile.lo.display.scroll end,
							set = function(t) ShamanFriend.db.profile.lo.display.scroll = t end,
						},
						frames = {
							type = 'toggle',
							name = L["Frames output"],
							desc = L["Toggle whether the message will show up in the frames. (Settings are in the 'General Display' category.)"],
							get = function() return ShamanFriend.db.profile.lo.display.frames end,
							set = function(t) ShamanFriend.db.profile.lo.display.frames = t end,
						},
						time = {
							--hidden = true,
							name = L["Time to display message"],
							type = "range",
							desc = L["Set the time the message will be displayed (5=default)"],
							get = function() return ShamanFriend.db.profile.lo.display.time end,
							set = function(v)
								ShamanFriend.db.profile.lo.display.time = v
							end,
							step = 1,
							min = 1,
							max = 20,
							order = 111,
						},
					}
				},
			}
		},
		eshield = {
			name = L["Earth Shield"],
			type = 'group',
			desc = L["Settings for Earth Shield."],
			order = 500,
			args = {
				enable = {
					name = L["Enable"],
					type = "toggle",
					desc = L["Toggle Earth Shield tracker"],
					get = function() return ShamanFriend.db.profile.eshield.enable end,
					set = function(v)
						ShamanFriend.db.profile.eshield.enable = v
						ShamanFriend:LoadEvents()
					end,
					order = 501,
				},
				display = {
					name = L["Display"],
					type = 'group',
					desc = L["Settings for how to display the message."], 
					args = {
						color = {
							name = L["Color"],
							type = 'color',
							desc = L["Sets the color of the text when displaying messages."],
							get = function()
							local v = ShamanFriend.db.profile.eshield.display.color
								return v.r,v.g,v.b
								end,
							set = function(r,g,b) ShamanFriend.db.profile.eshield.display.color = {r=r,g=g,b=b} end
						},
						scroll = {
							type = 'toggle',
							name = L["Scroll output"],
							desc = L["Toggle showing messages in scrolling text. (Settings are in the 'Output Category')"],
							get = function() return ShamanFriend.db.profile.eshield.display.scroll end,
							set = function(t) ShamanFriend.db.profile.eshield.display.scroll = t end,
						},
						frames = {
							type = 'toggle',
							name = L["Frames output"],
							desc = L["Toggle whether the message will show up in the frames. (Settings are in the 'General Display' category.)"],
							get = function() return ShamanFriend.db.profile.eshield.display.frames end,
							set = function(t) ShamanFriend.db.profile.eshield.display.frames = t end,
						},
						time = {
							--hidden = true,
							name = L["Time to display message"],
							type = "range",
							desc = L["Set the time the message will be displayed (5=default)"],
							get = function() return ShamanFriend.db.profile.eshield.display.time end,
							set = function(v)
								ShamanFriend.db.profile.eshield.display.time = v
							end,
							step = 1,
							min = 1,
							max = 20,
							order = 111,
						},
					}
				},
			}
		},
		--[[totem = {
			name = L["Totems"],
			type = 'group',
			desc = L["Settings for Totems."],
			order = 500,
			args = {
				kill = {
					name = L["Warn on kill"],
					type = "toggle",
					desc = L["Shows a message whenether one of your totems are killed."],
					get = function() return ShamanFriend.db.profile.totem.kill end,
					set = function(v)
						ShamanFriend.db.profile.totem.kill = v
						ShamanFriend:LoadEvents()
					end,
					order = 501,
				},
				killmsg = {
					name = L["Broadcast on kill"],
					type = "text",
					desc = L["Broadcast to the following chat when one of your totems are killed. (Above option must be enabled)"],
					get = function() return ShamanFriend.db.profile.totem.killmsg end,
					set = function(v)
						ShamanFriend.db.profile.totem.killmsg = v
					end,
					disabled = function() return not ShamanFriend.db.profile.totem.killmsg end,
					validate = {
						["RAID"] = L["Raid"],
						["PARTY"] = L["Party"],
						["RAID_WARNING"] = L["Raid Warning"],
						["none"] = L["None"],
					},
					order = 502,
				},
				display = {
					name = L["Display"],
					type = 'group',
					desc = L["Settings for how to display the message."], 
					args = {
						color = {
							name = L["Color"],
							type = 'color',
							desc = L["Sets the color of the text when displaying messages."],
							get = function()
							local v = ShamanFriend.db.profile.totem.display.color
								return v.r,v.g,v.b
								end,
							set = function(r,g,b) ShamanFriend.db.profile.totem.display.color = {r=r,g=g,b=b} end
						},
						scroll = {
							type = 'toggle',
							name = L["Scroll output"],
							desc = L["Toggle showing messages in scrolling text. (Settings are in the 'Output Category')"],
							get = function() return ShamanFriend.db.profile.totem.display.scroll end,
							set = function(t) ShamanFriend.db.profile.totem.display.scroll = t end,
						},
						frames = {
							type = 'toggle',
							name = L["Frames output"],
							desc = L["Toggle whether the message will show up in the frames. (Settings are in the 'General Display' category.)"],
							get = function() return ShamanFriend.db.profile.lo.display.frames end,
							set = function(t) ShamanFriend.db.profile.totem.display.frames = t end,
						},
						time = {
							--hidden = true,
							name = L["Time to display message"],
							type = "range",
							desc = L["Set the time the message will be displayed (5=default)"],
							get = function() return ShamanFriend.db.profile.totem.display.time end,
							set = function(v)
								ShamanFriend.db.profile.totem.display.time = v
							end,
							step = 1,
							min = 1,
							max = 20,
							order = 111,
						},
					}
				},
			}
		},]]
		misc = {
			name = L["Miscellaneous"],
			type = 'group',
			desc = L["Various other small notices/usefull functions."],
			order = 800,
			args = {
				elet5 = {
					name = L["Elemental T5 2-piece bonus"],
					type = "toggle",
					desc = L["Show a message when you get the proc from the Elemental Tier5 2-piece bonus"],
					get = function() return ShamanFriend.db.profile.misc.elet5 end,
					set = function(v)
						ShamanFriend.db.profile.misc.elet5 = v
						ShamanFriend:LoadEvents()
					end,
				},
				enht5 = {
					name = L["Enhancement T5 2-piece bonus"],
					type = "toggle",
					desc = L["Show a message when you get the proc from the Enhancement Tier5 2-piece bonus"],
					get = function() return ShamanFriend.db.profile.misc.enht5 end,
					set = function(v)
						ShamanFriend.db.profile.misc.enht5 = v
						ShamanFriend:LoadEvents()
					end,
				},
				restot5 = {
					name = L["Restoration T5 4-piece bonus"],
					type = "toggle",
					desc = L["Show a message when you get the proc from the Restoration Tier5 4-piece bonus"],
					get = function() return ShamanFriend.db.profile.misc.restot5 end,
					set = function(v)
						ShamanFriend.db.profile.misc.restot5 = v
						ShamanFriend:LoadEvents()
					end,
				},
				display = {
					name = L["Display"],
					type = 'group',
					desc = L["Settings for how to display the message."], 
					args = {
						color = {
							name = L["Color"],
							type = 'color',
							desc = L["Sets the color of the text when displaying messages."],
							get = function()
							local v = ShamanFriend.db.profile.misc.display.color
								return v.r,v.g,v.b
								end,
							set = function(r,g,b) ShamanFriend.db.profile.misc.display.color = {r=r,g=g,b=b} end
						},
						scroll = {
							type = 'toggle',
							name = L["Scroll output"],
							desc = L["Toggle showing messages in scrolling text. (Settings are in the 'Output Category')"],
							get = function() return ShamanFriend.db.profile.misc.display.scroll end,
							set = function(t) ShamanFriend.db.profile.misc.display.scroll = t end,
						},
						frames = {
							type = 'toggle',
							name = L["Frames output"],
							desc = L["Toggle whether the message will show up in the frames. (Settings are in the 'General Display' category.)"],
							get = function() return ShamanFriend.db.profile.misc.display.frames end,
							set = function(t) ShamanFriend.db.profile.misc.display.frames = t end,
						},
						time = {
							--hidden = true,
							name = L["Time to display message"],
							type = "range",
							desc = L["Set the time the message will be displayed (5=default)"],
							get = function() return ShamanFriend.db.profile.misc.display.time end,
							set = function(v)
								ShamanFriend.db.profile.misc.display.time = v
							end,
							step = 1,
							min = 1,
							max = 20,
							order = 111,
						},
					}
				},
			}
		},
    }
}

local bloodlusttextdefault
if UnitRace("player") == "Draenei" then
  bloodlusttextdefault = "Heroism UP! Now go pewpew!"
else
  bloodlusttextdefault = "Bloodlust UP! Now go pewpew %t!"
end

local defaults = {
	alert = {
		shield = true,
		weapon = true,
		entercombat = true,
		aftercombat = false,
		mounted = true,
		sound = "none",
		display = {
			color = { r=1, g=1, b=1 },
			scroll = false,
			frames = true,
			time = 5,
		},
	},
	spell = {
		purge = true,
		purgemsg = "none",
		earthshock = false,
		earthshockmsg = "none",
		ground = false,
		groundself = true,
		groundmsg = "none",
		target = false,
		bloodlust = false,
		bloodlusttext = bloodlusttextdefault,
		bloodlustchat = "YELL",
		manatide = false,
		manatidetext = "Mana Tide UP! More mana to the people!",
		manatidechat = "YELL",
		display = {
			color = { r=1, g=0.5, b=0.7 },
			scroll = false,
			frames = true,
			time = 5,
		},
	},
	display = {
		chat = false,
		number = 0,
		screen = false,
		frame = true,
		fontSize = 18,
		fontFace = L["FRIZQT__.TTF"],
		fontEffect = L["OUTLINE"],
		lock = true,
	},
	wf = {
		enable = true,
		crit = true,
		miss = false,
		hand = false,
		display = {
			color = { r=0.7, g=0.7, b=1 },
			scroll = false,
			frames = true,
			time = 5,
		},
	},
	lo = {
		enable = true,
		crit = false,
		damage = false,
		display = {
			color = { r=0.7, g=0.7, b=1 },
			scroll = false,
			frames = true,
			time = 5,
		},
	},
	eshield = {
		enable = false,
		display = {
			color = { r=0.7, g=0.7, b=1 },
			scroll = false,
			frames = true,
			time = 5,
		},
	},
	--[[totem = {
		kill = false,
		killmsg = "none",
		display = {
			color = { r=0.7, g=0.7, b=1 },
			scroll = false,
			frames = true,
			time = 5,
		},
	},]]
	misc = {
		elet5 = false,
		enht5 = false,
		restot5 = false,
		display = {
			color = { r=0.7, g=1, b=0.7 },
			scroll = false,
			frames = true,
			time = 5,
		},
	},
	sink10OutputSink = "None",
	
}

local sounds = {
	ding = "Sound\\Doodad\\BellTollAlliance.wav",
	dong = "Sound\\Doodad\\BellTollHorde.wav",
	bell = "AuctionWindowClose",
	dodo = "igQuestFailed",
}

ShamanFriend = AceLibrary("AceAddon-2.0"):new("AceConsole-2.0", "AceDB-2.0", "AceEvent-2.0", "Sink-1.0")

local waterfall = AceLibrary("Waterfall-1.0")

local wf_str
local wf_guid
local wf_hand
local wf_cnt = 1
local wf_crit = 0
local wf_miss = 0
local wf_dmg = 0
local fs_target, fs_cnt
local time = 0
local lo_str
local lo_c
local lo_hit = 0
local lo_crit = 0
local eshield_target = "-"
local eshield_count
local eshield_id

local trackedEvents = {}

local lb_ids = {
	[403] = true,
	[529] = true,
	[548] = true,
	[915] = true,
	[943] = true,
	[6041] = true,
	[10391] = true,
	[10392] = true,
	[15207] = true,
	[15208] = true,
	[25448] = true,
	[25449] = true
}

local lb_ol_ids = {
	[45284] = true,
	[45286] = true,
	[45287] = true,
	[45288] = true,
	[45289] = true,
	[45290] = true,
	[45291] = true,
	[45292] = true,
	[45293] = true,
	[45294] = true,
	[45295] = true,
	[45296] = true
}

local cl_ids = {
	[421] = true,
	[930] = true,
	[2860] = true,
	[10605] = true,
	[25439] = true,
	[25442] = true
}

local cl_ol_ids = {
	[45297] = true,
	[45298] = true,
	[45299] = true,
	[45300] = true,
	[45301] = true,
	[45302] = true
}

local shield_ids = {
	-- Water Shield:
	[24398] = true,
	[33736] = true,
	
	-- Lightning Shield:
	[324] = true,
	[325] = true,
	[905] = true,
	[945] = true,
	[8134] = true,
	[10431] = true,
	[10432] = true,
	[25496] = true,
	[25472] = true,
	
	-- Eart Shield:
	[974] = true,
	[32593] = true,
	[32594] = true
}

local eshield_ids = {
	[974] = true,
	[32593] = true,
	[32594] = true
}

local earthshock_ids = {
	[8042] = true,
	[8044] = true,
	[8045] = true,
	[8046] = true,
	[10412] = true,
	[10413] = true,
	[10414] = true,
	[25454] = true,
}
	-- Spell IDs
	-- Lightning Bolt: 403 529 548 915 943 6041 10391 10392 15207 15208 25448 25449
	-- Bolt OL: 45284 45286 45287 45288 45289 45290 45291 45292 45293 45294 45295 45296
	
	-- CL: 421 930 2860 10605 25439 25442
	-- CL OL: 45297 45298 45299 45300 45301 45302
	
	-- Trinket: 37661
	
	-- Water Shield: 24398 33736
	-- Lightning Shield: 324 325 905 945 8134 10431 10432 25496 25472
	-- Eart Shield: 974 32593 32594
	
	-- WF: 25504 33750


ShamanFriend.Wf = 0
ShamanFriend.Wf_miss = 0
ShamanFriend.Wf_crit = 0

function ShamanFriend:OnInitialize()
	self:RegisterDB("ShamanFriendDB")
	self:RegisterDefaults('profile', defaults)
	
	--self:RegisterChatCommand({"/shamanfriend", "/sf"}, consoleoptions)
	
	waterfall:Register("ShamanFriend",
		'aceOptions', consoleoptions,
		'treeType', "TREE",
		'title',"Shaman's Friend")
	
	self:RegisterChatCommand({"/shamanfriend", "/sf"}, function()
		waterfall:Open("ShamanFriend")
	end)
		
		self:RegisterChatCommand({"/sfcl"}, consoleoptions)
	
	self:RegisterSink("SF", "Shaman Friend", nil, "SinkPrint")
	
	local lc, ec = UnitClass("player")
	if ec == "SHAMAN" then
		self:ToggleActive(true)
	else
		self:ToggleActive(false)
	end
end

function ShamanFriend:OnEnable()
	self:LoadEvents()
end

function ShamanFriend:OnDisable()
	self:UnregisterAllEvents()
end

function ShamanFriend:ShowUI()
	waterfall:Open("ShamanFriend")
end

function ShamanFriend:LoadEvents()
	self:UnregisterAllEvents()
	
	trackedEvents = {}
	
	self:RegisterEvent("COMBAT_LOG_EVENT_UNFILTERED")
	
	-- Enter combat
	if self.db.profile.alert.entercombat then
		self:RegisterEvent("PLAYER_REGEN_DISABLED")
	end
	
	-- After combat
	if self.db.profile.alert.aftercombat == true then
		self:RegisterEvent("PLAYER_REGEN_ENABLED")
	end
	
	-- Shield
	if self.db.profile.alert.shield then
		trackedEvents["SPELL_AURA_REMOVED"] = true
	end
	
	-- Weapon
	if self.db.profile.alert.weapon then
		trackedEvents["ENCHANT_REMOVED"] = true
	end
	
	-- Wf
	if self.db.profile.wf.enable then
		trackedEvents["SWING_DAMAGE"] = true
		trackedEvents["SWING_MISSED"] = true
		trackedEvents["SPELL_DAMAGE"] = true
		trackedEvents["SPELL_MISSED"] = true
		--trackedEvents["UNIT_DIED"] = true
	end
	
	-- LO
	if self.db.profile.lo.enable then
		trackedEvents["SPELL_DAMAGE"] = true
		trackedEvents["SPELL_MISSED"] = true
	end
	
	-- BL + Tide
	if self.db.profile.spell.bloodlust or self.db.profile.spell.manatide then
		self:RegisterEvent("UNIT_SPELLCAST_SUCCEEDED")
	end
	
	-- Earth Shield tracker
	if self.db.profile.eshield.enable then
		trackedEvents["SPELL_AURA_APPLIED"] = true
		trackedEvents["SPELL_AURA_REMOVED"] = true
		trackedEvents["SPELL_HEAL"] = true
		self:RegisterEvent("SPELL_UPDATE_COOLDOWN")
		self:RegisterEvent("UNIT_SPELLCAST_SENT")
	end
	
	-- Set bonus
	if self.db.profile.misc.elet5 or self.db.profile.misc.enht5 or self.db.profile.misc.restot5 then
		trackedEvents["SPELL_AURA_APPLIED"] = true
	end
	
	-- Purge
	if self.db.profile.spell.purge then
		trackedEvents["SPELL_DISPEL"] = true
	end
	
	-- Ground
	if self.db.profile.spell.ground then
		trackedEvents["SPELL_DAMAGE"] = true
		trackedEvents["SPELL_MISSED"] = true
	end
	
	-- Earth Shock
	if self.db.profile.spell.earthshock then
		trackedEvents["SPELL_INTERRUPT"] = true
	end
	
	-- Totem kills
	--if self.db.profile.totem.kill then
	--	trackedEvents["UNIT_DIED"] = true
	--end
	
	-- Custom Message Frame
	if (not self.msgFrame) and self.db.profile.display.frame then
		self:CreateCustomFrame()
	end
	
	-- Create Eshield Frame
	if self.db.profile.eshield.enable then
		if (not self.eshieldFrame) then
			self:CreateEshieldFrame()
		end
		if self.eshieldFrame then
			self.eshieldFrame:Show()
			self.eshieldButton:Show()
		end
	elseif self.eshieldFrame then
		self.eshieldFrame:Hide()
		self.eshieldButton:Hide()
	end
end

function ShamanFriend:COMBAT_LOG_EVENT_UNFILTERED(timestamp, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags, ...)
	if not trackedEvents[event] then
		--self:Print("NOT tracked")
		--self:Print(timestamp, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags)
		--self:Print(...)
		return
	end
	if (event == "SWING_DAMAGE" or event == "SWING_MISSED") and sourceGUID == UnitGUID("player") then
		if self.db.profile.wf.enable then
			self:WfHandler("melee",select(1,...),select(6,...),event)
			
		end
	elseif (event == "SPELL_DAMAGE" or event == "SPELL_MISSED") then
		if sourceGUID == UnitGUID("player") then
			if self.db.profile.lo.enable then
				if event == "SPELL_DAMAGE" then
					self:LoHandler(select(1,...),select(4,...),select(9,...))
				elseif event == "SPELL_MISSED" then
					self:LoHandler(select(1,...),0,0)
				end
			end
			if self.db.profile.wf.enable then
				self:WfHandler(select(1,...),select(4,...),select(9,...),event)
			end
		else
			if self.db.profile.spell.ground then
                                -- self:Print(timestamp, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags)
				-- destFlags == 8465 for my unmarked totem. With a raid mark on totem, higher bits may be set. 
				if ((not self.db.profile.spell.groundself) or math.fmod(destFlags,65536) == 8465) and destName == L["Grounding Totem"] then
					self:Message(L["Ground: "] .. select(2,...) .. string.format(" (%s)",strlower(select(4,...))),"spell")
					if self:ChatChannel(self.db.profile.spell.groundmsg) ~= "none" then
						SendChatMessage(L["Ground: "] .. select(2,...) .. string.format(" (%s)",strlower(select(4,...))),self:ChatChannel(self.db.profile.spell.groundmsg))
					end
				end 
			end		
		end
	elseif event == "SPELL_AURA_REMOVED" then
		if self.db.profile.alert.shield and destGUID == UnitGUID("player") then
			if shield_ids[select(1,...)] then
				self:Message(select(2,...) .. L[" faded"], "alert")
			end
		end
		if self.db.profile.eshield.enable and destName == eshield_target and eshield_ids[select(1,...)] then
			self:eshield_BuffCheck()
			self:CancelScheduledEvent("ShamanFriendESBC")
		end
	elseif event == "SPELL_HEAL" then
		if self.db.profile.eshield.enable and select(1,...) == 379 and destName == eshield_target then
			self:eshield_BuffCheck()
		end
	elseif event == "SPELL_AURA_APPLIED" then
		if self.db.profile.eshield.enable and destName == eshield_target and eshield_ids[select(1,...)] then
			self:eshield_BuffCheck()
			self:ScheduleRepeatingEvent("ShamanFriendESBC",self.eshield_BuffCheck, 20, self)
		end
		if self.db.profile.misc.elet5 and select(1,...) == 37234 and destGUID == UnitGUID("player") then
			self:Message(L["Gained set bonus"], "misc")
		elseif self.db.profile.misc.enht5 and select(1,...) == 37240 and destGUID == UnitGUID("player") then
			self:Message(L["Gained set bonus"], "misc")
		elseif self.db.profile.misc.restot5 and select(1,...) == 39950 and destGUID == UnitGUID("player") then
			self:Message(L["Gained set bonus"], "misc")
		end
	elseif event == "SPELL_INTERRUPT" then
		if self.db.profile.spell.earthshock and sourceGUID == UnitGUID("player") and earthshock_ids[select(1,...)] then
			self:Message(string.format(L["Interrupted: %s"],select(5,...)),"spell")
			if self:ChatChannel(self.db.profile.spell.earthshockmsg) ~= "none" then
				if self.db.profile.spell.target then
					SendChatMessage(string.format(L["Interrupted: %s"] .. " (%s)",select(5,...),destName),self:ChatChannel(self.db.profile.spell.earthshockmsg))
				else
					SendChatMessage(string.format(L["Interrupted: %s"],select(5,...)),self:ChatChannel(self.db.profile.spell.earthshockmsg))
				end
			end
		end	
	elseif event == "SPELL_DISPEL" then
		if self.db.profile.spell.purge and sourceGUID == UnitGUID("player") and (select(1,...) == 370 or select(1,...) == 8012) then
			self:Message(L["Purge: "] .. select(5,...),"spell")
			if self:ChatChannel(self.db.profile.spell.purgemsg) ~= "none" then
				if self.db.profile.spell.target then
					SendChatMessage(string.format(L["Purge: "] .. "%s (%s)",select(5,...),destName),self:ChatChannel(self.db.profile.spell.purgemsg))
				else
					SendChatMessage(L["Purge: "] .. select(5,...),self:ChatChannel(self.db.profile.spell.purgemsg))
				end
			end
		end
	elseif event == "UNIT_DIED" then
		if self.db.profile.wf.enable and sourceGUID == wf_guid then
			--wf_guid = nil
		end
		--[[if self.db.profile.totem.kill and sourceFlags == 8465 then
			self:Message(L["Killed: "] .. select(5,...),"totem")
			if self:ChatChannel(self.db.profile.spell.purgemsg) ~= "none" then
				if self.db.profile.spell.target then
					SendChatMessage(string.format(L["Killed: "] .. "%s (%s)",select(5,...),destName),self:ChatChannel(self.db.profile.spell.purgemsg))
				else
					SendChatMessage(L["Killed: "] .. select(5,...),self:ChatChannel(self.db.profile.spell.purgemsg))
				end
			end
		end]]
	elseif event == "ENCHANT_REMOVED" then
		if self.db.profile.alert.weapon and destGUID == UnitGUID("player") and IsEquippedItem(select(3,...)) == 1 then
			self:ScheduleEvent("ShamanFriendESBC",function() local a,_,_,d = GetWeaponEnchantInfo()
			if not (a or d) then
				self:Message(L["Weapon Enchant faded"], "alert")
			end end, 1, self)
		end
	end
	
	--self:Print("tracked")
	--self:Print(timestamp, event, sourceGUID, sourceName, sourceFlags, destGUID, destName, destFlags)
	--self:Print(...)
end

function ShamanFriend:ChatChannel(chat)
         if chat == "RAID" and not UnitInRaid("player") then
             chat = "PARTY"
         end
         if chat == "PARTY" and GetNumPartyMembers() == 0 then
             chat = "none"
         end
	return chat;
end

function ShamanFriend:UNIT_SPELLCAST_SUCCEEDED(a1,a2,a3)
	if self.db.profile.spell.bloodlust and self:ChatChannel(self.db.profile.spell.bloodlustchat) ~= "none" and (a2 == L["Bloodlust"] or a2 == L["Heroism"]) then
		SendChatMessage(self.db.profile.spell.bloodlusttext,self:ChatChannel(self.db.profile.spell.bloodlustchat))
	elseif self.db.profile.spell.manatide and self:ChatChannel(self.db.profile.spell.manatidechat) ~= "none" and a2 == L["Mana Tide Totem"] then
   	        SendChatMessage(self.db.profile.spell.manatidetext,self:ChatChannel(self.db.profile.spell.manatidechat))
	end
end

function ShamanFriend:WfHandler(id, damage, crit, event)
	-- Melee + mh stormstrike
	if id == "melee" or id == 32175 then
		wf_cnt = 0
		if event == "SWING_MISSED" or event == "SPELL_MISSED" then
			wf_miss = 1
			wf_dmg = 0
			wf_crit = 0
		else
			wf_miss = 0
			--self:Print("aaa: " .. damage .. "event: " .. event)
			wf_dmg = damage
			if crit == 1 then
				wf_crit = 1
			else
				wf_crit = 0
			end
		end

	-- oh stormstrike + wf mh + wf oh
	elseif id == 32176 or id == 25504 or id == 33750 then
		if id ~= 32176 then
			wf_cnt = wf_cnt + 1
			if id == 25504 then
				wf_hand = "mh"
			elseif id == 33750 then
				wf_hand = "oh"
			end 
		end
		
		if event == "SWING_MISSED" or event == "SPELL_MISSED" then
			wf_miss = wf_miss + 1
		else
			--self:Print("bbb: " .. damage)
			wf_dmg = wf_dmg + damage
			
			if crit == 1 then
				wf_crit = wf_crit + 1
			end
		end
	
	end
	
	
	if wf_cnt == 2 then
		self:WfPrinter()
	end
end

function ShamanFriend:WfPrinter()
	if wf_hand == "mh" and self.db.profile.wf.hand then
		wf_str = L["MH Windfury"]
	elseif wf_hand == "oh" and self.db.profile.wf.hand then
		wf_str = L["OH Windfury"]
	else
		wf_str = L["Windfury"]
	end
	
	
	if wf_crit == 0 or not self.db.profile.wf.crit then
		wf_str = wf_str .. ": " .. wf_dmg
	elseif wf_crit == 1 then
		wf_str = wf_str .. L[" Single crit: "] .. wf_dmg
	elseif wf_crit == 2 then
		wf_str = wf_str .. L[" DOUBLE crit: "] .. wf_dmg
	elseif wf_crit == 3 then
		wf_str = wf_str .. L[" TRIPLE crit: "] .. wf_dmg
	elseif wf_crit ==4 then
		wf_str = wf_str .. L[" QUADRUPLE crit: "] .. wf_dmg
	else
		wf_str = wf_str .. " " .. wf_crit .. " crit: " .. wf_dmg
	end
	if self.db.profile.wf.miss and wf_miss > 0 then
		wf_str = wf_str .. " (" .. wf_miss .. L[" miss"] .. ")"
	end
	self:Message(wf_str, "wf")
	
	
	self.Wf = wf_dmg
	self.Wf_miss = wf_miss
	self.Wf_crit = wf_crit
	wf_cnt = 0
	wf_miss = 0
	wf_crit = 0
	wf_dmg = 0
end

function ShamanFriend:LoHandler(spellID, spellDamage, spellCrit)
	if lb_ids[spellID] then
		lo_hit = spellDamage
		if spellCrit == 1 then
			lo_crit = 1
		else
			lo_crit = 0
		end
	elseif lb_ol_ids[spellID] then
		lo_hit = lo_hit + spellDamage
		if spellCrit == 1 then
			lo_crit = lo_crit +1
		end
		
		lo_str = L["Lightning Overload"]
		if self.db.profile.lo.crit then
			if lo_crit == 1 then
				lo_str = lo_str .. L[" CRIT"]
			elseif lo_crit == 2 then
				lo_str = lo_str .. L[" DOUBLE CRIT"]
			elseif lo_crit > 2 then
				lo_str = lo_str .. lo_crit .. L[" CRIT"]
			end
		end
		
		if self.db.profile.lo.damage then
			lo_str = lo_str .. ": " .. lo_hit
		end
		self:Message(lo_str, "lo")
	elseif cl_ids[spellID] then
		lo_c = 2
	elseif cl_ol_ids[spellID] then
		lo_c = lo_c + 1
		if lo_c / 3 == 1 then
			lo_str = L["Chain Lightning Overload"]
			self:Message(lo_str,"lo")
		elseif lo_c / 6 == 1 then
			lo_str = L["DOUBLE Chain Lightning Overload"]
			self:Message(lo_str,"lo")
		elseif lo_c / 9 == 1 then
			lo_str = L["TRIPLE Chain Lightning Overload"]
			self:Message(lo_str,"lo")
		end
	end
end

function ShamanFriend:UNIT_SPELLCAST_SENT(a1, a2, a3, a4)
	if self.db.profile.eshield.enable and a2 == L["Earth Shield"] then
		if a4 ~= nil then
			if InCombatLockdown() and eshield_target ~= a4 then
				self.eshieldButton.texture:SetVertexColor(0.8,0,0,0.8)
			end
			eshield_target = a4
			if UnitInParty(a4) or UnitInRaid(a4) then
				self:ScheduleLeaveCombatAction("eshield_SetTarget", eshield_target)
				self:eshield_BuffCheck()
				--self:ScheduleRepeatingEvent("ShamanFriendESBC",self.eshield_BuffCheck, 20, self)
			else
				eshield_target = "Outside group"
				self:ScheduleLeaveCombatAction("eshield_SetTarget", "target")
				self:eshield_BuffCheck()
				self:CancelScheduledEvent("ShamanFriendESBC")
			end
		end
	end
end

--function ShamanFriend:ESSetTarget(t)
--	eshield_target = t
--end

function ShamanFriend:PLAYER_REGEN_DISABLED()
	if self.db.profile.alert.shield then
		self:CheckShield()
	end
	if self.db.profile.alert.weapon then
		self:CheckWeapon()
	end
end

function ShamanFriend:PLAYER_REGEN_ENABLED()
	if self.db.profile.alert.aftercombat then
		if self.db.profile.alert.shield then
			self:CheckShield()
		end
		if self.db.profile.alert.weapon then
			self:CheckWeapon()
		end
	end
end

function ShamanFriend:CheckShield()
	if not (GetPlayerBuffName(L["Lightning Shield"]) or GetPlayerBuffName(L["Water Shield"]) or GetPlayerBuffName(L["Earth Shield"])) then
		if not (self.db.profile.alert.mounted and IsMounted()) then
			self:Message(L["Missing: Elemental Shield"], "alert")
		end
	end
end


function ShamanFriend:CheckWeapon()
	local a,_,_,d = GetWeaponEnchantInfo()
	if not a then
		if not (self.db.profile.alert.mounted and IsMounted()) then
			self:Message(L["Missing: Main Hand Enchant"], "alert")
		end
	end
	
	if OffhandHasWeapon() and not d then
		if not (self.db.profile.alert.mounted and IsMounted()) then
			self:Message(L["Missing: Off Hand Enchant"], "alert")
		end
	end
end

function ShamanFriend:Message(str, type)
	local c, t
	if type == "wf" then
		c = self.db.profile.wf.display.color
		t = self.db.profile.wf.display.time
	elseif type == "alert" then
		c = self.db.profile.alert.display.color
		t = self.db.profile.alert.display.time
	elseif type == "spell" then
		c = self.db.profile.spell.display.color
		t = self.db.profile.spell.display.time
	elseif type == "lo" then
		c = self.db.profile.lo.display.color
		t = self.db.profile.lo.display.time
	elseif type == "misc" then
		c = self.db.profile.misc.display.color
		t = self.db.profile.misc.display.time
	end
	if (type == "wf" and self.db.profile.wf.display.frames) or (type == "alert" and self.db.profile.alert.display.frames) or (type == "spell" and self.db.profile.spell.display.frames) or (type == "lo" and self.db.profile.lo.display.frames) or (type == "misc" and self.db.profile.misc.display.frames) then
		if self.db.profile.display.chat then
			if self.db.profile.display.number == 0 then
				self:Print(str)
			else
				local chatframe = getglobal("ChatFrame" .. self.db.profile.display.number)
				chatframe:AddMessage(str, c.r, c.g, c.b)
			end
		end
		if self.db.profile.display.screen then
			UIErrorsFrame:AddMessage(str, c.r, c.g, c.b, 1, t)
		end
		if self.db.profile.display.frame then
			if t ~= 5 then
				self.msgFrame:SetTimeVisible(t)
			end
			self.msgFrame:AddMessage(str, c.r, c.g, c.b, 1, t)
		end
	end
	if ((type == "wf" and self.db.profile.wf.display.scroll) or (type == "alert" and self.db.profile.alert.display.scroll) or (type == "spell" and self.db.profile.spell.display.scroll) or (type == "lo" and self.db.profile.lo.display.scroll) or (type == "misc" and self.db.profile.misc.display.scroll)) then
		self:Pour(str, c.r, c.g, c.b)
		
		--[[if (IsAddOnLoaded("MikScrollingBattleText")) then
			MikSBT.DisplayMessage(
				str,
				MikSBT.DISPLAYTYPE_OUTGOING, 
				true, 
				self.db.profile.scroll.fontColor.r*255, 
				self.db.profile.scroll.fontColor.g*255, 
				self.db.profile.scroll.fontColor.b*255, 
				self.db.profile.scroll.fontSize, 
				self.db.profile.scroll.fontFace
			);
		elseif (IsAddOnLoaded("sct")) then
			if self.db.profile.scroll.sctScroll then
				SCT:CmdDisplay("'" .. str .. "' " .. floor(self.db.profile.scroll.fontColor.r*10) .. " " .. floor(self.db.profile.scroll.fontColor.g*10) .. " " .. floor(self.db.profile.scroll.fontColor.b*10))
			else
				SCT:DisplayMessage(
					str,
					self.db.profile.scroll.fontColor
				);
			end
			
		end]]
		
	end
	
	if type == "alert" and self.db.profile.alert.sound ~= "none" then
		local sound = sounds[self.db.profile.alert.sound]
		if string.find(sound, "%\\") then
			PlaySoundFile(sound)
		else
			PlaySound(sound)
		end
	end
end

function ShamanFriend:SinkPrint(addon, message, r, g, b)
	if not self.msgFrame then self:CreateCustomFrame() end
	self.msgFrame:AddMessage(message, r, g, b, 1, UIERRORS_HOLD_TIME)
end

function ShamanFriend:CreateCustomFrame()
	self.dragButton = CreateFrame("Button",nil,UIParent)
	self.dragButton.owner = self
	self.dragButton:Hide()
	self.dragButton:ClearAllPoints()
	self.dragButton:SetWidth(250)
	self.dragButton:SetHeight(20)
	
	if self.db.profile.display.x and self.db.profile.display.y then
		--local s = self.dragButton:GetEffectiveScale()
		--self.dragbutton:ClearAllPoints()
		--self.dragButton:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", self.db.profile.display.x / s, self.db.profile.display.y / s)
		self.dragButton:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", self.db.profile.display.x, self.db.profile.display.y)
	else 
		self.dragButton:SetPoint("TOP", UIErrorsFrame, "BOTTOM", 0, 0)
	end	
	
	self.dragButton:SetBackdrop({
		bgFile = "Interface/Tooltips/UI-Tooltip-Background",
	})
	self.dragButton:SetBackdropColor(0,0,0.3,.6)	
	
	self.dragButton:SetMovable(true)
	self.dragButton:RegisterForDrag("LeftButton")
	self.dragButton:SetScript("OnDragStart", function() this.owner.dragButton:StartMoving() end )
	self.dragButton:SetScript("OnDragStop",
		function()
			this.owner.dragButton:StopMovingOrSizing()
			self.db.profile.display.x = this.owner.dragButton:GetLeft()
			self.db.profile.display.y = this.owner.dragButton:GetTop()
			--local s = this.owner.dragButton:GetEffectiveScale()
			--self.db.profile.display.x = this.owner.dragButton:GetLeft() * s
			--self.db.profile.display.y = this.owner.dragButton:GetTop() * s
		end
	)

	self.msgFrame = CreateFrame("MessageFrame")
	self.msgFrame.owner = self
	self.msgFrame:ClearAllPoints()
	self.msgFrame:SetWidth(400)
	self.msgFrame:SetHeight(75)
	self.msgFrame:SetPoint("TOP", self.dragButton, "TOP", 0, 0)
	self.msgFrame:SetInsertMode("TOP")
	self.msgFrame:SetFrameStrata("HIGH")
	self.msgFrame:SetToplevel(true)

	self:UpdateLock()
	self:UpdateFont()
	
	self.msgFrame:Show()
end

function ShamanFriend:UpdateFont()
	if self.db.profile.display.frame and self.msgFrame then
		self.msgFrame:SetFont("Fonts\\" .. self.db.profile.display.fontFace, self.db.profile.display.fontSize,self.db.profile.display.fontEffect)
		
		--if self.db.profile.display.fontSize == "small" then
		--	self.msgFrame:SetFontObject(GameFontNormalSmall)
		--elseif self.db.profile.display.fontSize == "normal" then
		--	self.msgFrame:SetFontObject(GameFontNormal)
		--elseif self.db.profile.display.fontSize == "large" then
		--	self.msgFrame:SetFontObject(GameFontNormalLarge)
		--elseif self.db.profile.display.fontSize == "huge" then
		--	self.msgFrame:SetFontObject(GameFontNormalHuge)
		--end
	end
end

function ShamanFriend:UpdateLock()
	if self.db.profile.display.frame and self.msgFrame then
		if self.db.profile.display.lock then
			self.dragButton:SetMovable(false)
			self.dragButton:RegisterForDrag()
			self.msgFrame:SetBackdrop(nil)
			self.msgFrame:SetBackdropColor(0,0,0,0)
			self.dragButton:Hide()
		else
			self.dragButton:Show()
			self.dragButton:SetMovable(true)
			self.dragButton:RegisterForDrag("LeftButton")
			self.msgFrame:SetBackdrop({
				bgFile = "Interface/Tooltips/UI-Tooltip-Background",
			})
			self.msgFrame:SetBackdropColor(0,0,0.3,.3)
		end
	end
end

function ShamanFriend:CreateEshieldFrame()
	local i = 1
	while true do
	   local spell, rank = GetSpellName(i, BOOKTYPE_SPELL)
	   if (not spell) then
		  break
	   end
	   --if spell == "Healing Wave" then
	   if spell == L["Earth Shield"] then
		  eshield_id = i
	   end
	   i = i + 1
	end
	if eshield_id == nil then
		return
	end
	
	self.eshieldFrame = CreateFrame("Frame","ShamanFriend_eshield",UIParent)
	self.eshieldFrame.owner = self
	self.eshieldFrame:ClearAllPoints()
	self.eshieldFrame:SetWidth(170)
	self.eshieldFrame:SetHeight(54)
--	self.eshieldFrame:SetFrameStrata("DIALOG")
	self.eshieldFrame:SetFrameStrata("MEDIUM")
	self.eshieldFrame:SetToplevel(true)
	self.eshieldFrame:SetMovable(true)
	self.eshieldFrame:EnableMouse(true)
	self.eshieldFrame:SetBackdrop({
			bgFile = "Interface/Tooltips/UI-Tooltip-Background",
			edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
			tile = true, tileSize = 8, edgeSize = 9,
			insets = { left = 2, right =2, top = 2, bottom = 2 }
		})
	self.eshieldFrame:SetBackdropColor(0.1,0.1,0.1,0.9)
	self.eshieldFrame:SetMovable(true)
	self.eshieldFrame:RegisterForDrag("LeftButton")
	self.eshieldFrame:SetScript("OnDragStart", function() this.owner.eshieldFrame:StartMoving() end )
	self.eshieldFrame:SetScript("OnDragStop",
		function()
			this.owner.eshieldFrame:StopMovingOrSizing()
			self.db.profile.eshield.x = this.owner.eshieldFrame:GetLeft()
			self.db.profile.eshield.y = this.owner.eshieldFrame:GetTop()
		end
	)
	
	if self.db.profile.eshield.x and self.db.profile.eshield.y then
		self.eshieldFrame:SetPoint("TOPLEFT", UIParent, "BOTTOMLEFT", self.db.profile.eshield.x, self.db.profile.eshield.y)
	else 
		self.eshieldFrame:SetPoint("BOTTOMRIGHT", UIParrent, "BOTTOMRIGHT", -200, 300)
	end	
	
	self.eshieldHeader = self.eshieldFrame:CreateFontString(nil, "OVERLAY")
	self.eshieldHeader.owner = self
	self.eshieldHeader:SetFontObject(GameFontNormalSmall)
	self.eshieldHeader:ClearAllPoints()
	self.eshieldHeader:SetWidth(170)
	self.eshieldHeader:SetHeight(12)
	self.eshieldHeader:SetPoint("TOP", self.eshieldFrame, "TOP",0,-2)
	self.eshieldHeader:SetJustifyH("CENTER")
	self.eshieldHeader:SetJustifyV("TOP")
	self.eshieldHeader:SetText(L["Shaman Friend ES Tracker"])
	
	self.eshieldInfo = self.eshieldFrame:CreateFontString(nil, "OVERLAY")
	self.eshieldInfo.owner = self
	self.eshieldInfo:SetFontObject(GameFontNormalSmall)
	self.eshieldInfo:ClearAllPoints()
	self.eshieldInfo:SetTextColor(1, 1, 1, 1)
	self.eshieldInfo:SetWidth(130)
	self.eshieldInfo:SetHeight(36)
	self.eshieldInfo:SetPoint("TOP", self.eshieldHeader, "BOTTOM",0,0)
	self.eshieldInfo:SetJustifyH("LEFT")
	self.eshieldInfo:SetJustifyV("MIDDLE")
	
	self.eshieldButton = CreateFrame("Button", "ShamanFriend_eshieldButton", self.eshieldFrame, "SecureActionButtonTemplate,SecureAnchorEnterTemplate")
	self.eshieldButton.class = self
	self.eshieldButton:SetPoint("TOPRIGHT", self.eshieldFrame, "TOPLEFT", 0, 0)
	self.eshieldButton:SetWidth(36)
	self.eshieldButton:SetHeight(36)
--	self.eshieldButton:SetFrameStrata("DIALOG")
	self.eshieldButton:SetFrameStrata("MEDIUM")
	self.eshieldButton:SetToplevel(true)
	self.eshieldButton:HookScript("OnEnter", ShamanFriend.ShowTooltip)
	self.eshieldButton:HookScript("OnLeave", ShamanFriend.HideTooltip)
	
	--self.eshieldButton:SetNormalTexture(GetSpellTexture("Healing Wave"))
	--self.eshieldButton:SetNormalTexture(GetSpellTexture(L["Earth Shield"]))
	--self.eshieldButton:SetNormalTexture("")
	
	self.eshieldButton.texture = self.eshieldButton:CreateTexture(nil, "ARTWORK")
	--self.eshieldButton.texture:SetTexture(GetSpellTexture("Healing Wave"))
	self.eshieldButton.texture:SetTexture(GetSpellTexture(L["Earth Shield"]))
	self.eshieldButton.texture:SetPoint("TOPLEFT", self.eshieldButton, "TOPLEFT", 3, -3)
	self.eshieldButton.texture:SetPoint("BOTTOMRIGHT", self.eshieldButton, "BOTTOMRIGHT",  -3, 3)
	self.eshieldButton.texture:SetTexCoord(0.10, 0.90, 0.10, 0.90)
	
	
	self.eshieldButton_shadow = CreateFrame("Frame", "ShamanFriend_eshieldButton_shadow", self.eshieldButton)
	--frame:SetBackdrop({bgFile = "Interface\\Tooltips\\UI-Tooltip-Background", tile = true, tileSize = 1, edgeFile = "", edgeSize = 0, insets = {left = 0, right = 0, top = 0, bottom = 0},})
	self.eshieldButton_shadow:SetBackdrop({
			bgFile = "Interface/Tooltips/UI-Tooltip-Background",
			edgeFile = "Interface/Tooltips/UI-Tooltip-Border",
			tile = true, tileSize = 8, edgeSize = 9,
			insets = { left = 2, right =2, top = 2, bottom = 2 }
		})
	self.eshieldButton_shadow:SetBackdropColor(0.1, 0.1, 0.1, 0.9)
	self.eshieldButton_shadow:SetAllPoints(self.eshieldButton)
	self.eshieldButton_shadow:SetFrameLevel(0)
	
	self.eshieldButton.Cooldown = CreateFrame("Cooldown", "ShamanFriend_eshieldButton_cooldown", self.eshieldButton, "CooldownFrameTemplate");
	
	self:ScheduleLeaveCombatAction("eshield_SetTarget","target")
	
	self:eshield_SetText("-","-")
	
	self.eshieldFrame:Show()
end

function ShamanFriend:ShowTooltip()
	if (eshield_id) then
		GameTooltip:SetOwner(ShamanFriend.eshieldButton,ANCHOR_LEFT)
		GameTooltip:SetSpell(eshield_id, BOOKTYPE_SPELL)
	end
end

function ShamanFriend:HideTooltip()
	GameTooltip:Hide()
end

function ShamanFriend:eshield_SetText(eshield_text_charges, eshield_text_time)
	if eshield_target == L["Outside group"] then
		eshield_text_charges = "-"
		eshield_text_time = "-"
		self.eshieldInfo:SetText(L["Charges: "] .. eshield_text_charges .. "|n" .. L["Time: "] .. eshield_text_time .. "|n" .. L["Target: "] .. "|cffff0000" .. eshield_target .. "|r")
	else
		self.eshieldInfo:SetText(L["Charges: "] .. eshield_text_charges .. "|n" .. L["Time: "] .. eshield_text_time .. "|n" .. L["Target: "] .. eshield_target)
	end
end

function ShamanFriend:eshield_BuffCheck()
	if (not eshield_target) or eshield_target == L["Outside group"] or eshield_target == "-" then
		self:eshield_SetText("-","-")
	else
		local i = 1
		local buff = UnitBuff(eshield_target, i)
		local nothing = true
		while buff do
			if buff == L["Earth Shield"] then
			--if buff == "Water Shield" then
				local buff, _, _, count, _, timeLeft = UnitBuff(eshield_target, i)
				if timeLeft == nil then
					timeLeft = "|cff999999Unavailable|r"
				else
					timeLeft = math.ceil(timeLeft / 60) .. L[" min"]
				end
				self:eshield_SetText(count,timeLeft)
				nothing = false
				break
			end
			i = i + 1;
			buff = UnitBuff(eshield_target, i);
		end
		
		if nothing then
			self:eshield_SetText("-","-")
		end
	end
end

function ShamanFriend:eshield_SetTarget(t)
	self.eshieldButton:SetAttribute("type1", "spell")
	--self.eshieldButton:SetAttribute("spell1", "Healing Wave")
	self.eshieldButton:SetAttribute("spell1", L["Earth Shield"])
	self.eshieldButton:SetAttribute("unit1", t)
	self.eshieldButton.texture:SetVertexColor(1,1,1,1)
end

function ShamanFriend:SPELL_UPDATE_COOLDOWN()
	if eshield_id then
		local start, duration, enable = GetSpellCooldown(eshield_id, BOOKTYPE_SPELL );
		CooldownFrame_SetTimer(self.eshieldButton.Cooldown, start, duration, enable );
	end
end
