------------------------------------------------------------------------------------------
--Warlock Resources-----------------------------------------------------------------------
------------------------------------------------------------------------------------------

local SN, L, F, T, M, _ = unpack(select(2,...))

if SN.playerClass ~= "WARLOCK" then return end

local LSM = LibStub("LibSharedMedia-3.0")
local CP = SN:GetModule("classResources")

local MODNAME = "shards"

local SHARD = CP:NewModule(MODNAME, "AceEvent-3.0")

local MAX_POWER_PER_EMBER = 10
local SPELL_POWER_DEMONIC_FURY = SPELL_POWER_DEMONIC_FURY
local SPELL_POWER_BURNING_EMBERS = SPELL_POWER_BURNING_EMBERS
local SPELL_POWER_SOUL_SHARDS = SPELL_POWER_SOUL_SHARDS
local SPEC_WARLOCK_DESTRUCTION = SPEC_WARLOCK_DESTRUCTION
local SPEC_WARLOCK_AFFLICTION = SPEC_WARLOCK_AFFLICTION
local SPEC_WARLOCK_DEMONOLOGY = SPEC_WARLOCK_DEMONOLOGY
local GetSpecialization = GetSpecialization
local UnitPowerMax = UnitPowerMax
local UnitPower = UnitPower
local floor = floor

local maxShard = SN["classMaxResourceBar"]["WARLOCK"]

function SHARD:OnInitialize()
	
	local frame = F.classpower
	
	frame.shards = CP:PowerBubbles(maxShard)

	frame.shards:SetScript("OnEvent", function(self, event, ...)
		SHARD:ShardEvents(self)
	end)
	frame.shards:Hide()
end

function SHARD:OnEnable()
	local frame = F.classpower
	WarlockPowerFrame:UnregisterAllEvents()
	WarlockPowerFrame._Show = WarlockPowerFrame.Show
	WarlockPowerFrame.Show = WarlockPowerFrame.Hide
    WarlockPowerFrame:Hide()
	frame.shards:Show()
	frame.shards:RegisterEvent("UNIT_POWER")
	frame.shards:RegisterEvent("PLAYER_TALENT_UPDATE")
	frame.shards:RegisterEvent("PLAYER_ENTERING_WORLD")
	frame.shards:RegisterEvent("UNIT_DISPLAYPOWER")
	SHARD:ShardEvents(frame.shards)
	collectgarbage("collect")
end

function SHARD:OnDisable()
	local frame = F.classpower
	frame.shards:UnregisterAllEvents()
	frame.shards:Hide()
	WarlockPowerFrame.Show = WarlockPowerFrame._Show
	WarlockPowerFrame:Show()
	WarlockPowerFrame:GetScript("OnLoad")(WarlockPowerFrame)
	collectgarbage("collect")
end

function SHARD:ShardEvents(self)
	local color = M.classResources.WARLOCK
	local spec = GetSpecialization()
	if spec then
		if not self:IsShown() then 
			self:Show()
		end

		for i = 1, maxShard do
			self[i]:Show()
			self[i]:SetStatusBarColor(color[spec][1], color[spec][2], color[spec][3], 1)
			self[i]:SetBackdropColor(color[spec][1], color[spec][2], color[spec][3], 0.2)
		end
		
		if (spec == SPEC_WARLOCK_DESTRUCTION) then	
			local maxPower = UnitPowerMax("player", SPELL_POWER_BURNING_EMBERS, true)
			local power = UnitPower("player", SPELL_POWER_BURNING_EMBERS, true)
			local numEmbers = power / MAX_POWER_PER_EMBER
			local numBars = floor(maxPower / MAX_POWER_PER_EMBER)
			self.maxbub = numBars

			for i = 1, numBars do
				if not self[i]:IsShown() then
					self[i]:Show()
				end

				self[i]:SetSize(CP:ReturnBubSize(self))

				if i == 1 then
					self[i]:SetPoint("LEFT", self, 1, 0)
				else
					self[i]:SetPoint("LEFT", self[(i - 1)], "RIGHT", 1, 0)
				end

				self[i]:SetMinMaxValues((MAX_POWER_PER_EMBER * i) - MAX_POWER_PER_EMBER, MAX_POWER_PER_EMBER * i)
				self[i]:SetValue(power)
			end
		elseif ( spec == SPEC_WARLOCK_AFFLICTION ) then
			local numShards = UnitPower("player", SPELL_POWER_SOUL_SHARDS)
			local maxShards = UnitPowerMax("player", SPELL_POWER_SOUL_SHARDS)
			self.maxbub = maxShards

			for i = 1, maxShards do
				
				self[i]:SetSize(CP:ReturnBubSize(self))
				self[i]:SetMinMaxValues(0, 1)
				self[i]:SetValue(1)

				
				if not self[i]:IsShown() then
					self[i]:Show()
				end

				if i == 1 then
					self[i]:SetPoint("LEFT", self, 1, 0)
				else
					self[i]:SetPoint("LEFT", self[(i - 1)], "RIGHT", 1, 0)
				end
				if i <= numShards then
					self[i]:SetAlpha(1)
				else
					self[i]:SetAlpha(0.1)
				end
			end
		elseif spec == SPEC_WARLOCK_DEMONOLOGY then
			local power = UnitPower("player", SPELL_POWER_DEMONIC_FURY)
			local maxPower = UnitPowerMax("player", SPELL_POWER_DEMONIC_FURY)
			
			self.maxbub = 1

			for i = 2, 4 do
				if self[i]:IsShown() then
					self[i]:Hide()
				end
			end

			self[1]:SetSize(CP:ReturnBubSize(self))
			self[1]:SetMinMaxValues(0, maxPower)
			self[1]:SetValue(power)
		end
	else
		if self:IsShown() then 
			self:Hide()
		end
	end
end

function SHARD:Lock()
	F.classpower.shards:Show()
	F.classpower.shards:RegisterEvent("UNIT_POWER")
	F.classpower.shards:RegisterEvent("PLAYER_TALENT_UPDATE")
	F.classpower.shards:RegisterEvent("PLAYER_ENTERING_WORLD")
	F.classpower.shards:RegisterEvent("UNIT_DISPLAYPOWER")
	SHARD:ShardEvents(F.classpower.shards)
end

function SHARD:Unlock()
	F.classpower.shards:UnregisterAllEvents()
	F.classpower.shards:Hide()
end

function SHARD:Reset()
end

function SHARD:ApplySettings()
	local spec = GetSpecialization()

	F.classpower.shards:SetSize(F.classpower:GetWidth(), F.classpower:GetHeight())

	if spec == 1 or 3 then
		F.classpower.shards.maxbub = maxShard
		for i = 1, maxShard do
			F.classpower.shards[i]:SetSize(CP:ReturnBubSize(F.classpower.shards))
			F.classpower.shards[i]:SetStatusBarTexture(LSM:Fetch("statusbar", SN.data.profile.classResources.texture))
		end
	elseif spec == 2 then
		F.classpower.shards.maxbub = 1
		F.classpower.shards[1]:SetSize(CP:ReturnBubSize(F.classpower.shards))
		F.classpower.shards[1]:SetStatusBarTexture(LSM:Fetch("statusbar", SN.data.profile.classResources.texture))
	end
end