------------------------------------------------------------------------------------------
--Shadow Orbs-----------------------------------------------------------------------------
------------------------------------------------------------------------------------------

local SN, L, F, T, M, _ = unpack(select(2,...))

if SN.playerClass ~= "PRIEST" then return end

local LSM = LibStub("LibSharedMedia-3.0")
local CP = SN:GetModule("classResources")

local MODNAME = "shadoworbs"

local ORBS = CP:NewModule(MODNAME, "AceEvent-3.0")

local SPELL_POWER_SHADOW_ORBS = SPELL_POWER_SHADOW_ORBS
local SHADOW_ORBS_SHOW_LEVEL = SHADOW_ORBS_SHOW_LEVEL
local PRIEST_BAR_NUM_ORBS = PRIEST_BAR_NUM_ORBS
local SPEC_PRIEST_SHADOW = SPEC_PRIEST_SHADOW
local GetSpecialization = GetSpecialization
local UnitLevel = UnitLevel
local UnitPower = UnitPower
local IsAddOnLoaded = IsAddOnLoaded
local collectgarbage = collectgarbage
local unpack = unpack

function ORBS:OnInitialize()
	local frame = F.classpower
	local color = M.classResources.PRIEST
	
	frame.shadoworbs = CP:PowerBubbles(PRIEST_BAR_NUM_ORBS)
	for i = 1, PRIEST_BAR_NUM_ORBS do
		frame.shadoworbs[i]:SetStatusBarColor(unpack(color))
		frame.shadoworbs[i]:SetAlpha(0.1)
	end
	frame.shadoworbs:SetScript("OnEvent", function(self, event, ...)
		local unitID, type = ...
		if unitID == "player" then
			ORBS:OrbPoints(self)
		end
		local spec = GetSpecialization()
		local level = UnitLevel("player")

		if spec == SPEC_PRIEST_SHADOW and level > SHADOW_ORBS_SHOW_LEVEL then
			self:Show()
		else
			self:Hide()
		end	
	end)
	frame.shadoworbs:Hide()
end

function ORBS:OnEnable()
	local frame = F.classpower
	local spec = GetSpecialization()
	local level = UnitLevel("player")

	if spec == SPEC_PRIEST_SHADOW and level > SHADOW_ORBS_SHOW_LEVEL then
		frame:Show()
	else
		frame:Hide()
	end	
	frame.shadoworbs:RegisterEvent("UPDATE_SHAPESHIFT_FORMS")
	frame.shadoworbs:RegisterEvent("UNIT_DISPLAYPOWER")
	frame.shadoworbs:RegisterEvent("UNIT_POWER_FREQUENT")
	frame.shadoworbs:RegisterEvent("PLAYER_LEVEL_UP")
	frame.shadoworbs:RegisterEvent("PLAYER_TALENT_UPDATE")
	PriestBarFrame:Hide()
	PriestBarFrame:UnregisterAllEvents()
	ORBS:OrbPoints(frame.shadoworbs)
	collectgarbage("collect")
end

function ORBS:OnDisable()
	local frame = F.classpower
	frame.shadoworbs:UnregisterAllEvents()
	frame.shadoworbs:Hide()
	PriestBarFrame:Show()
	PriestBarFrame:GetScript("OnLoad")(PriestBarFrame)
	PriestBarFrame.spec = 0
	PriestBarFrame_CheckAndShow()
	collectgarbage("collect")
end

function ORBS:OrbPoints(self)
	local sOrbs = UnitPower("player", SPELL_POWER_SHADOW_ORBS)
	if sOrbs > 0 then
		for i = 1, PRIEST_BAR_NUM_ORBS do
			self[i]:SetAlpha(0.1)
		end
		for i = 1, sOrbs do
			self[i]:SetAlpha(1)
		end
	else
		for i = 1, PRIEST_BAR_NUM_ORBS do
			self[i]:SetAlpha(0.1)
		end
	end
end

function ORBS:Lock()
	local frame = F.classpower
	local spec = GetSpecialization()
	local level = UnitLevel("player")

	if spec == SPEC_PRIEST_SHADOW and level > SHADOW_ORBS_SHOW_LEVEL then
		frame:Show()
	else
		frame:Hide()
	end	
	frame.shadoworbs:RegisterEvent("UPDATE_SHAPESHIFT_FORMS")
	frame.shadoworbs:RegisterEvent("UNIT_DISPLAYPOWER")
	frame.shadoworbs:RegisterEvent("UNIT_POWER_FREQUENT")
	frame.shadoworbs:RegisterEvent("PLAYER_LEVEL_UP")
	frame.shadoworbs:RegisterEvent("PLAYER_TALENT_UPDATE")
	ORBS:OrbPoints(frame.shadoworbs)
end

function ORBS:Unlock()
	local frame = F.classpower
	frame.shadoworbs:UnregisterAllEvents()
	frame.shadoworbs:Hide()
end

function ORBS:Reset()
end

function ORBS:ApplySettings()
	F.classpower.shadoworbs:SetSize(F.classpower:GetWidth(), F.classpower:GetHeight())

	for i = 1, PRIEST_BAR_NUM_ORBS do
		F.classpower.shadoworbs[i]:SetSize(CP:ReturnBubSize(F.classpower.shadoworbs))
		F.classpower.shadoworbs[i]:SetStatusBarTexture(LSM:Fetch("statusbar", SN.data.profile.classResources.texture))
	end
	ORBS:OrbPoints(F.classpower.shadoworbs)
end
