------------------------------------------------------------------------------------------
--Death Knight Runes----------------------------------------------------------------------
------------------------------------------------------------------------------------------

local SN, L, F, T, M, _ = unpack(select(2,...))

if SN.playerClass ~= "DEATHKNIGHT" then return end

local LSM = LibStub("LibSharedMedia-3.0")
local CP = SN:GetModule("classResources")

local MODNAME = "runes"

local RUNE = CP:NewModule(MODNAME, "AceEvent-3.0")

local runemap = { 1, 2, 5, 6, 3, 4 }
local GetRuneCooldown = GetRuneCooldown
local GetSpecialization = GetSpecialization
local GetRuneType = GetRuneType
local GetTime = GetTime
local IsAddOnLoaded = IsAddOnLoaded
local collectgarbage = collectgarbage
local unpack = unpack

function RUNE:OnEnable()
	
	local frame = F.classpower
	if not frame.runes then
		local color = M.classResources.DEATHKNIGHT
		local maxRune = SN["classMaxResourceBar"]["DEATHKNIGHT"]

		frame.runes = CP:PowerBubbles(maxRune)
		frame.runes.maxRune = maxRune

		frame.runes:SetScript("OnUpdate", function(self, elapsed)
			if GetSpecialization() == nil and elapsed then return end
			local runes = self:GetParent()
			if(runes) then
				for i=1, self.maxRune do
					RUNE:UpdateType(self, nil, i)
				end
			end
			self:SetScript("OnUpdate", nil)
		end)
		frame.runes:SetScript("OnEvent", function(self, event, ...)
			if event == "RUNE_POWER_UPDATE" then
				local rid = ...
				RUNE:UpdateRune(self, event, rid, true)
			elseif event == "RUNE_TYPE_UPDATE" then
				local rid = ...
				RUNE:UpdateType(self, event, rid, true)
			end
		end)
		for i = 1, maxRune do
			frame.runes[i]:SetOrientation(SN.data.profile.classResources.orientation)
		end
		frame.runes:Hide()
	end
		
	frame.runes:Show()
	frame.runes:RegisterEvent("RUNE_TYPE_UPDATE")
	frame.runes:RegisterEvent("RUNE_POWER_UPDATE")
	RuneFrame:Hide()
	RuneFrame:UnregisterAllEvents()
	collectgarbage("collect")
end

function RUNE:OnDisable()
	local frame = F.classpower
	if not frame.runes then return end
	frame.runes:UnregisterAllEvents()
	frame.runes:Hide()
	RuneFrame:Show()
	RuneFrame:GetScript("OnLoad")(RuneFrame)
	for i=1,SN["classMaxResourceBar"]["DEATHKNIGHT"] do
		local runeButton = _G["RuneButtonIndividual"..i];
		if runeButton then
			RuneButton_Update(runeButton, i, true);
		end
	end
	collectgarbage("collect")
end

function RUNE:OnInitialize()
	local frame = F.classpower
	local color = M.classResources.DEATHKNIGHT
	local maxRune = SN["classMaxResourceBar"]["DEATHKNIGHT"]

	frame.runes = CP:PowerBubbles(maxRune)
	frame.runes.maxRune = maxRune

	frame.runes:SetScript("OnUpdate", function(self, elapsed)
		if GetSpecialization() == nil and elapsed then return end
		local runes = self:GetParent()
		if(runes) then
			for i=1, self.maxRune do
				RUNE:UpdateType(self, nil, i)
			end
		end
		self:SetScript("OnUpdate", nil)
	end)
	frame.runes:SetScript("OnEvent", function(self, event, ...)
		if event == "RUNE_POWER_UPDATE" then
			local rid = ...
			RUNE:UpdateRune(self, event, rid, true)
		elseif event == "RUNE_TYPE_UPDATE" then
			local rid = ...
			RUNE:UpdateType(self, event, rid, true)
		end
	end)
	for i = 1, maxRune do
		frame.runes[i]:SetOrientation(SN.data.profile.classResources.orientation)
	end
	frame.runes:Hide()
end

function RUNE:Lock()
	local frame = F.classpower
	if not frame.runes then
		local color = M.classResources.DEATHKNIGHT
		local maxRune = SN["classMaxResourceBar"]["DEATHKNIGHT"]

		frame.runes = CP:PowerBubbles(maxRune)
		frame.runes.maxRune = maxRune

		frame.runes:SetScript("OnUpdate", function(self, elapsed)
			if GetSpecialization() == nil and elapsed then return end
			local runes = self:GetParent()
			if(runes) then
				for i=1, self.maxRune do
					RUNE:UpdateType(self, nil, i)
				end
			end
			self:SetScript("OnUpdate", nil)
		end)
		frame.runes:SetScript("OnEvent", function(self, event, ...)
			if event == "RUNE_POWER_UPDATE" then
				local rid = ...
				RUNE:UpdateRune(self, event, rid, true)
			elseif event == "RUNE_TYPE_UPDATE" then
				local rid = ...
				RUNE:UpdateType(self, event, rid, true)
			end
		end)
		for i = 1, maxRune do
			frame.runes[i]:SetOrientation(SN.data.profile.classResources.orientation)
		end
		frame.runes:Hide()
	end
		
	frame.runes:Show()
	frame.runes:RegisterEvent("RUNE_TYPE_UPDATE")
	frame.runes:RegisterEvent("RUNE_POWER_UPDATE")
end

function RUNE:Unlock()
	local frame = F.classpower
	if not frame.runes then return end
	frame.runes:UnregisterAllEvents()
	frame.runes:Hide()
end

function RUNE:Reset()
end

function RUNE:ApplySettings()
	local maxRune = F.classpower.runes.maxRune
	F.classpower.runes:SetSize(F.classpower:GetWidth(), F.classpower:GetHeight())
	for i = 1, maxRune do
		F.classpower.runes[i]:SetSize(CP:ReturnBubSize(F.classpower.runes))
		F.classpower.runes[i]:SetOrientation(SN.data.profile.classResources.orientation)
		F.classpower.runes[i]:SetStatusBarTexture(LSM:Fetch("statusbar", SN.data.profile.classResources.texture))
	end
end

function RUNE:UpdateType(self, event, rid)
	local runeColors = M.classResources.DEATHKNIGHT
	local rune = self[runemap[rid]]
	if not GetRuneType(rid) then return end
	local colors = runeColors[GetRuneType(rid)]

	rune:SetStatusBarColor(unpack(colors))
end

local function Update(self, event)
	for i=1, self.maxRune do
		RUNE:UpdateRune(self, event, i)
	end
end

local function UpdateAllRuneTypes(self, elapsed)
	if GetSpecialization() == nil and elapsed then return end
	local runes = self:GetParent()
	if(runes) then
		for i=1, self.maxRune do
			RUNE:UpdateType(runes, nil, i)
		end
	end
	self:SetScript("OnUpdate", nil)
end

function RUNE:UpdateRune(self, event, rid)
	local rune = self[runemap[rid]]
	if(rune) then
		local start, duration, runeReady = GetRuneCooldown(rid)
		if (runeReady) then
			rune:SetMinMaxValues(0, 1)
			rune:SetValue(1)
			rune:SetAlpha(1)
			rune:SetScript("OnUpdate", nil)
		else
			rune.duration = GetTime() - start
			rune.max = duration
			rune:SetMinMaxValues(1, duration)
			rune:SetAlpha(0.45)
			rune:SetScript("OnUpdate", function(self, elapsed)
				local duration = self.duration + elapsed
				if(duration >= self.max) then
					return self:SetScript("OnUpdate", nil)
				else
					self.duration = duration
					return self:SetValue(duration)
				end
			end)
		end
	end
end