------------------------------------------------------------------------------------------
--Holy Power------------------------------------------------------------------------------
------------------------------------------------------------------------------------------

local SN, L, F, T, M, _ = unpack(select(2,...))

if SN.playerClass ~= "PALADIN" then return end

local LSM = LibStub("LibSharedMedia-3.0")
local CP = SN:GetModule("classResources")

local MODNAME = "holypower"

local HOLY = CP:NewModule(MODNAME, "AceEvent-3.0")

local SPELL_POWER_HOLY_POWER = SPELL_POWER_HOLY_POWER
local MAX_HOLY_POWER = 5
local UnitPower = UnitPower
local IsAddOnLoaded = IsAddOnLoaded
local collectgarbage = collectgarbage
local unpack = unpack

function HOLY:OnEnable()
	local frame = F.classpower
	frame.holypower:Show()
	frame.holypower:RegisterEvent("UNIT_POWER")
	PaladinPowerBar:Hide()
	PaladinPowerBar:UnregisterAllEvents()
	HOLY:HolyPoints(frame.holypower)
	collectgarbage("collect")
end

function HOLY:OnDisable()
	local frame = F.classpower
	frame.holypower:UnregisterEvent("UNIT_POWER")
	frame.holypower:Hide()
	PaladinPowerBar:Show()
	PaladinPowerBar:GetScript("OnLoad")(PaladinPowerBar)
	collectgarbage("collect")
end

function HOLY:OnInitialize()
	local frame = F.classpower
	local color = M.classResources.PALADIN

	frame.holypower = CP:PowerBubbles(MAX_HOLY_POWER)
	for i = 1, MAX_HOLY_POWER do
		frame.holypower[i]:SetStatusBarColor(unpack(color))
	end

	frame.holypower:SetScript("OnEvent", function(self, event, ...)

		if event == "UNIT_POWER" then
			local unitID, type = ...
			if unitID == "player" and type == "HOLY_POWER" then
				HOLY:HolyPoints(self)
			end
		end
	end)
	frame.holypower:Hide()
end

function HOLY:Lock()
	local frame = F.classpower
	frame.holypower:Show()
	frame.holypower:RegisterEvent("UNIT_POWER")
	HOLY:HolyPoints(frame.holypower)
end

function HOLY:Unlock()
	local frame = F.classpower
	frame.holypower:UnregisterEvent("UNIT_POWER")
	frame.holypower:Hide()
end

function HOLY:Reset()
end

function HOLY:ApplySettings()
	F.classpower.holypower:SetSize(F.classpower:GetWidth(), F.classpower:GetHeight())
	for i = 1, MAX_HOLY_POWER do
		F.classpower.holypower[i]:SetSize(CP:ReturnBubSize(F.classpower.holypower))
		F.classpower.holypower[i]:SetStatusBarTexture(LSM:Fetch("statusbar", SN.data.profile.classResources.texture))
	end
end

function HOLY:HolyPoints(self)
	local hpower = UnitPower("player", SPELL_POWER_HOLY_POWER)
	if hpower > 0 then
		for i = 1, MAX_HOLY_POWER do
			self[i]:SetAlpha(0.1)
		end
		for i = 1, hpower do
			self[i]:SetAlpha(1)
		end
	else
		for i = 1, MAX_HOLY_POWER do
			self[i]:SetAlpha(0.1)
		end
	end
end