------------------------------------------------------------------------------------------
--Druid Eclipse Bar-----------------------------------------------------------------------
------------------------------------------------------------------------------------------

local SN, L, F, T, M, _ = unpack(select(2,...))

if SN.playerClass ~= "DRUID" then return end

local LSM = LibStub("LibSharedMedia-3.0")
local CP = SN:GetModule("classResources")

local MODNAME = "eclipse"

local ECLIPSE = CP:NewModule(MODNAME, "AceEvent-3.0")

local ECLIPSE_BAR_SOLAR_BUFF_ID = ECLIPSE_BAR_SOLAR_BUFF_ID
local ECLIPSE_BAR_LUNAR_BUFF_ID = ECLIPSE_BAR_LUNAR_BUFF_ID
local SPELL_POWER_ECLIPSE = SPELL_POWER_ECLIPSE
local MOONKIN_FORM = MOONKIN_FORM
local UnitPower = UnitPower
local UnitPowerMax = UnitPowerMax
local UnitAura = UnitAura
local GetShapeshiftFormID = GetShapeshiftFormID
local GetSpecialization = GetSpecialization
local GetEclipseDirection = GetEclipseDirection
local IsAddOnLoaded = IsAddOnLoaded
local collectgarbage = collectgarbage
local unpack = unpack

function ECLIPSE:OnInitialize()
	local color = M.classResources.DRUID
	local frame = F.classpower

	local power = UnitPower("player", SPELL_POWER_ECLIPSE)
	local maxPower = UnitPowerMax("player", SPELL_POWER_ECLIPSE)
	frame.eclipse = CreateFrame("Frame", nil, frame)
	
	frame.eclipse:SetSize(SN.data.profile.classResources.width, SN.data.profile.classResources.height)
	frame.eclipse:SetPoint("TOPLEFT", frame, "TOPLEFT", 0, 0)
	frame.eclipse:SetScript("OnEvent", function(self, event, ...)
		ECLIPSE:EclipseUpdate(self, event, ...)
	end)
		
	frame.eclipse[1] = CreateFrame("StatusBar", nil, frame.eclipse)
	frame.eclipse[2] = CreateFrame("StatusBar", nil, frame.eclipse)
	
	frame.eclipse[2]:SetSize(SN.data.profile.classResources.width - 2, SN.data.profile.classResources.height - 2)
	frame.eclipse[2]:SetPoint("LEFT", frame.eclipse, 1, 0)
	frame.eclipse[2]:SetStatusBarTexture(LSM:Fetch("statusbar", SN.data.profile.classResources.texture))
	frame.eclipse[2]:GetStatusBarTexture():SetHorizTile(false)
	frame.eclipse[2]:SetAlpha(1)
	frame.eclipse[2]:SetMinMaxValues(-maxPower, maxPower)
	frame.eclipse[2]:SetValue(power)
	frame.eclipse[2]:SetStatusBarColor(unpack(color[1]))

	frame.eclipse[1]:SetSize(SN.data.profile.classResources.width - 2, SN.data.profile.classResources.height - 2)
	frame.eclipse[1]:SetPoint("LEFT", frame.eclipse[2]:GetStatusBarTexture(), "RIGHT")
	frame.eclipse[1]:SetStatusBarTexture(LSM:Fetch("statusbar", SN.data.profile.classResources.texture))
	frame.eclipse[1]:GetStatusBarTexture():SetHorizTile(false)
	frame.eclipse[1]:SetAlpha(1)
	frame.eclipse[1]:SetMinMaxValues(-maxPower, maxPower)
	frame.eclipse[1]:SetValue(power * -1)
	frame.eclipse[1]:SetStatusBarColor(unpack(color[2]))
	
	frame.eclipse.value = frame.eclipse[2]:CreateFontString(nil, 'OVERLAY')
	frame.eclipse.value:SetFont(M.media.font, 18, "OUTLINE")
	frame.eclipse.value:SetPoint("CENTER", frame.eclipse[2]:GetStatusBarTexture(), "RIGHT")
	
	local direction = GetEclipseDirection()
	if direction == "sun" then
		frame.eclipse.value:SetText("   >")
		frame.eclipse.value:SetTextColor(.2,.2,1,1)
	elseif direction == "moon" then
		frame.eclipse.value:SetText("<   ")
		frame.eclipse.value:SetTextColor(1,1,.3, 1)
	else
		frame.eclipse.value:SetText("")
	end
	SN:CreateBackDrop(frame.eclipse)
	frame.eclipse:Hide()
end

function ECLIPSE:OnEnable()
	local frame = F.classpower
	frame.eclipse:Show()
	frame.eclipse:RegisterEvent("ECLIPSE_DIRECTION_CHANGE")
	frame.eclipse:RegisterEvent("PLAYER_TALENT_UPDATE")
	frame.eclipse:RegisterEvent("UNIT_AURA")
	frame.eclipse:RegisterEvent("UNIT_POWER")
	frame.eclipse:RegisterEvent("UPDATE_SHAPESHIFT_FORM")
	ECLIPSE:ShowEclipse()
	EclipseBarFrame:Hide()
	EclipseBarFrame:UnregisterAllEvents()
	collectgarbage("collect")
end

function ECLIPSE:OnDisable()
	local frame = F.classpower
	frame.eclipse:UnregisterEvent("ECLIPSE_DIRECTION_CHANGE")
	frame.eclipse:UnregisterEvent("UNIT_AURA")
	frame.eclipse:UnregisterEvent("UNIT_POWER")
	frame.eclipse:Hide()
	EclipseBarFrame:Show()
	EclipseBarFrame:GetScript("OnLoad")(EclipseBarFrame)
	collectgarbage("collect")
end

function ECLIPSE:EclipseUpdate(self, event, ...)
	
	if event == "ECLIPSE_DIRECTION_CHANGE" then
		local direction = GetEclipseDirection()
		if direction == "sun" then
			self.value:SetText("   >")
			self.value:SetTextColor(.2,.2,1,1)
		elseif direction == "moon" then
			self.value:SetText("<   ")
			self.value:SetTextColor(1,1,.3, 1)
		else
			self.value:SetText("<   >")
		end
	end

	if event == "UNIT_POWER" then
	
		local power = UnitPower('player', SPELL_POWER_ECLIPSE)
		local maxPower = UnitPowerMax('player', SPELL_POWER_ECLIPSE)
		
		self[2]:SetMinMaxValues(-maxPower, maxPower)
		self[2]:SetValue(power)

		self[1]:SetMinMaxValues(-maxPower, maxPower)
		self[1]:SetValue(power * -1)
	end

	if event == "UNIT_AURA" then
		local i = 1
		local hasSolarEclipse, hasLunarEclipse
		repeat
			local _, _, _, _, _, _, _, _, _, _, spellID = UnitAura("player", i, 'HELPFUL')

			if(spellID == ECLIPSE_BAR_SOLAR_BUFF_ID) then
				hasSolarEclipse = true
			elseif(spellID == ECLIPSE_BAR_LUNAR_BUFF_ID) then
				hasLunarEclipse = true
			end

			i = i + 1
		until not spellID
	end

	if event == "UPDATE_SHAPESHIFT_FORM" or "PLAYER_TALENT_UPDATE" then
		ECLIPSE:ShowEclipse()
	end
	
end

function ECLIPSE:ShowEclipse()
	local showBar
	local form = GetShapeshiftFormID()
	if form == MOONKIN_FORM or not form then
		if GetSpecialization() == 1 then
			showBar = true
		else
			showBar = false
		end
	else
		showBar = false
	end

	if showBar then
		F.classpower.eclipse:Show()
		local power = UnitPower('player', SPELL_POWER_ECLIPSE)
		local maxPower = UnitPowerMax('player', SPELL_POWER_ECLIPSE)
		
		F.classpower.eclipse[2]:SetMinMaxValues(-maxPower, maxPower)
		F.classpower.eclipse[2]:SetValue(power)

		F.classpower.eclipse[1]:SetMinMaxValues(-maxPower, maxPower)
		F.classpower.eclipse[1]:SetValue(power * -1)
		local direction = GetEclipseDirection()
		if direction == "sun" then
			F.classpower.eclipse.value:SetText("   >")
			F.classpower.eclipse.value:SetTextColor(.2,.2,1,1)
		elseif direction == "moon" then
			F.classpower.eclipse.value:SetText("<   ")
			F.classpower.eclipse.value:SetTextColor(1,1,.3, 1)
		else
			F.classpower.eclipse.value:SetText("<   >")
		end
	else
		F.classpower.eclipse:Hide()
	end
end

function ECLIPSE:Lock()
	local frame = F.classpower
	frame.eclipse:Show()
	frame.eclipse:RegisterEvent("ECLIPSE_DIRECTION_CHANGE")
	frame.eclipse:RegisterEvent("PLAYER_TALENT_UPDATE")
	frame.eclipse:RegisterEvent("UNIT_AURA")
	frame.eclipse:RegisterEvent("UNIT_POWER")
	frame.eclipse:RegisterEvent("UPDATE_SHAPESHIFT_FORM")
	ECLIPSE:ShowEclipse()
end

function ECLIPSE:Unlock()
	local frame = F.classpower
	frame.eclipse:UnregisterEvent("ECLIPSE_DIRECTION_CHANGE")
	frame.eclipse:UnregisterEvent("UNIT_AURA")
	frame.eclipse:UnregisterEvent("UNIT_POWER")
	frame.eclipse:Hide()
end

function ECLIPSE:Reset()
end

function ECLIPSE:ApplySettings()
	F.classpower.eclipse:SetSize(F.classpower:GetWidth(), F.classpower:GetHeight())
	F.classpower.eclipse[1]:SetStatusBarTexture(LSM:Fetch("statusbar", SN.data.profile.classResources.texture))
	F.classpower.eclipse[1]:SetSize(F.classpower.eclipse:GetWidth() - 2, F.classpower.eclipse:GetHeight() - 2)
	F.classpower.eclipse[2]:SetStatusBarTexture(LSM:Fetch("statusbar", SN.data.profile.classResources.texture))
	F.classpower.eclipse[2]:SetSize(F.classpower.eclipse:GetWidth() - 2, F.classpower.eclipse:GetHeight() - 2)
end