------------------------------------------------------------------------------------------
--Combo Point-----------------------------------------------------------------------------
------------------------------------------------------------------------------------------

local SN, L, F, T, M, _ = unpack(select(2,...))
local LSM = LibStub("LibSharedMedia-3.0")
local CP = SN:GetModule("classResources")

local MODNAME = "combo"

local COMBO

if (SN.playerClass == "ROGUE" or SN.playerClass == "DRUID") then

	COMBO = CP:NewModule(MODNAME, "AceEvent-3.0")
else
	return
end

local GetShapeshiftFormID = GetShapeshiftFormID
local GetComboPoints = GetComboPoints
local MAX_COMBO_POINTS = MAX_COMBO_POINTS
local CAT_FORM = CAT_FORM
local unpack = unpack
local collectgarbage = collectgarbage

function COMBO:ShowCombo()
	local showBar
	local form = GetShapeshiftFormID()
	if form == CAT_FORM  then
		F.classpower.points:Show()
	else
		F.classpower.points:Hide()
	end
end

function COMBO:ComboPoints(self)
	local cpoints = GetComboPoints("player", "target")
	if cpoints > 0 then
		for i = 1, cpoints do
			self[i]:SetAlpha(1)
		end
	else
		for i = 1, MAX_COMBO_POINTS do
			self[i]:SetAlpha(0.1)
		end
	end
end

function COMBO:OnInitialize()
	local frame = F.classpower
	local color = M.classResources.ROGUE

	frame.points = CP:PowerBubbles(MAX_COMBO_POINTS)
	for i = 1, MAX_COMBO_POINTS do
		frame.points[i]:SetStatusBarColor(unpack(color[i]))
	end
	frame.points:SetScript("OnEvent", function(self, event, ...)
		if event == "UNIT_COMBO_POINTS" then
			COMBO:ComboPoints(self)
		elseif event == "PLAYER_TARGET_CHANGED" then
			COMBO:ComboPoints(self)
		end

		if event == "UPDATE_SHAPESHIFT_FORM" then
			local form = GetShapeshiftFormID()
			if SN.playerClass == "DRUID" then
				COMBO:ShowCombo()
			end
		end
	end)
	frame.points:Show()
end

function COMBO:OnEnable()
	local frame = F.classpower
	local form = GetShapeshiftFormID()
	if SN.playerClass == "DRUID" then
		COMBO:ShowCombo()
	else
		frame.points:Show()
	end
	frame.points:RegisterEvent("UNIT_COMBO_POINTS")
	frame.points:RegisterEvent("PLAYER_TARGET_CHANGED")
	frame.points:RegisterEvent("UPDATE_SHAPESHIFT_FORM")
	COMBO:ComboPoints(frame.points)
	ComboFrame:Hide()
	ComboFrame:UnregisterAllEvents()
	collectgarbage("collect")
end

function COMBO:OnDisable()
	local frame = F.classpower
	frame.points:UnregisterEvent("UNIT_COMBO_POINTS")
	frame.points:UnregisterEvent("PLAYER_TARGET_CHANGED")
	frame.points:Hide()
	ComboFrame:Show()
	ComboFrame:GetScript("OnLoad")(ComboFrame)
	collectgarbage("collect")
end

function COMBO:Lock()
	local frame = F.classpower
	local form = GetShapeshiftFormID()
	if SN.playerClass == "DRUID" then
		COMBO:ShowCombo()
	else
		frame.points:Show()
	end
	frame.points:RegisterEvent("UNIT_COMBO_POINTS")
	frame.points:RegisterEvent("PLAYER_TARGET_CHANGED")
	frame.points:RegisterEvent("UPDATE_SHAPESHIFT_FORM")
	COMBO:ComboPoints(frame.points)
end

function COMBO:Unlock()
	local frame = F.classpower
	frame.points:UnregisterEvent("UNIT_COMBO_POINTS")
	frame.points:UnregisterEvent("PLAYER_TARGET_CHANGED")
	frame.points:Hide()
end

function COMBO:Reset()
end

function COMBO:ApplySettings()
	F.classpower.points:SetSize(F.classpower:GetWidth(), F.classpower:GetHeight())
	for i = 1, MAX_COMBO_POINTS do
		F.classpower.points[i]:SetSize(CP:ReturnBubSize(F.classpower.points))
		F.classpower.points[i]:SetStatusBarTexture(LSM:Fetch("statusbar", SN.data.profile.classResources.texture))
	end
end