------------------------------------------------------------------------------------------
--Monk Chi--------------------------------------------------------------------------------
------------------------------------------------------------------------------------------

local SN, L, F, T, M, _ = unpack(select(2,...))

if SN.playerClass ~= "MONK" then return end

local LSM = LibStub("LibSharedMedia-3.0")
local CP = SN:GetModule("classResources")

local MODNAME = "chi"

local CHI = CP:NewModule(MODNAME, "AceEvent-3.0")

local unpack = unpack
local collectgarbage = collectgarbage
local SPELL_POWER_CHI = SPELL_POWER_CHI
local UnitPower = UnitPower
local UnitPowerMax = UnitPowerMax
local maxChi = SN["classMaxResourceBar"]["MONK"]

function CHI:OnInitialize()
	
	local frame = F.classpower
	local color = M.classResources.MONK
	
	frame.chi = CP:PowerBubbles(maxChi)
	for i = 1, maxChi do
		frame.chi[i]:SetStatusBarColor(unpack(color[i]))
	end

	frame.chi:SetScript("OnEvent", function(self, event, ...)

		if event == "UNIT_POWER" or event == "UNIT_DISPLAYPOWER" then
			CHI:ChiPoints(self)
		end
	end)
	frame.chi:Hide()
end

function CHI:OnEnable()
	
	local frame = F.classpower
	frame.chi:Show()
	frame.chi:RegisterEvent("UNIT_POWER")
	frame.chi:RegisterEvent("UNIT_DISPLAYPOWER")
	frame.chi:RegisterEvent("PLAYER_LEVEL_UP")	
	MonkHarmonyBar:Hide()
	MonkHarmonyBar:UnregisterAllEvents()
	CHI:ChiPoints(frame.chi)
	collectgarbage("collect")
end

function CHI:OnDisable()
	
	local frame = F.classpower
	frame.chi:UnregisterAllEvents()
	frame.chi:Hide()
	MonkHarmonyBar:Show()
	MonkHarmonyBar:GetScript("OnLoad")(MonkHarmonyBar)
	collectgarbage("collect")
end

function CHI:Lock()
	local frame = F.classpower
	frame.chi:Show()
	frame.chi:RegisterEvent("UNIT_POWER")
	frame.chi:RegisterEvent("UNIT_DISPLAYPOWER")
	frame.chi:RegisterEvent("PLAYER_LEVEL_UP")
	CHI:ChiPoints(frame.chi)
end

function CHI:Unlock()
	local frame = F.classpower
	frame.chi:UnregisterAllEvents()
	frame.chi:Hide()
end

function CHI:Reset()
	
end

function CHI:ApplySettings()
	
	F.classpower.chi:SetSize(F.classpower:GetWidth(), F.classpower:GetHeight())
	CHI:ChiPoints(F.classpower.chi)
	for i = 1, maxChi do
		F.classpower.chi[i]:SetStatusBarTexture(LSM:Fetch("statusbar", SN.data.profile.classResources.texture))
	end
end

function CHI:ChiPoints(self)
	local light = UnitPower("player", SPELL_POWER_CHI)
	local numPoints = UnitPowerMax("player", SPELL_POWER_CHI)
	
	self.maxbub = numPoints

	for i = 1, numPoints do
		if i <= light then
			self[i]:SetAlpha(1)
		else
			self[i]:SetAlpha(0.1)
		end
		self[i]:SetSize(CP:ReturnBubSize(self))
		if i == 1 then
			self[i]:SetPoint("LEFT", self, 1, 0)
		else
			self[i]:SetPoint("LEFT", self[(i - 1)], "RIGHT", 1, 0)
		end
		self[i]:Show()
		if numPoints < SN["classMaxResourceBar"]["MONK"] then
			self[SN["classMaxResourceBar"]["MONK"]]:Hide()
		end
	end
end